# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnvironmentKeyvaluemapsArgs', 'EnvironmentKeyvaluemaps']

@pulumi.input_type
class EnvironmentKeyvaluemapsArgs:
    def __init__(__self__, *,
                 env_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a EnvironmentKeyvaluemaps resource.
        :param pulumi.Input[builtins.str] env_id: The Apigee environment group associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}`.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: Required. ID of the key value map.
        """
        pulumi.set(__self__, "env_id", env_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Input[builtins.str]:
        """
        The Apigee environment group associated with the Apigee environment,
        in the format `organizations/{{org_name}}/environments/{{env_name}}`.


        - - -
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "env_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. ID of the key value map.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _EnvironmentKeyvaluemapsState:
    def __init__(__self__, *,
                 env_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnvironmentKeyvaluemaps resources.
        :param pulumi.Input[builtins.str] env_id: The Apigee environment group associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}`.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: Required. ID of the key value map.
        """
        if env_id is not None:
            pulumi.set(__self__, "env_id", env_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="envId")
    def env_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Apigee environment group associated with the Apigee environment,
        in the format `organizations/{{org_name}}/environments/{{env_name}}`.


        - - -
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "env_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. ID of the key value map.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("gcp:apigee/environmentKeyvaluemaps:EnvironmentKeyvaluemaps")
class EnvironmentKeyvaluemaps(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 env_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Collection of key/value string pairs.

        To get more information about EnvironmentKeyvaluemaps, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.keyvaluemaps/create)
        * How-to Guides
            * [Using key value maps](https://cloud.google.com/apigee/docs/api-platform/cache/key-value-maps)

        ## Example Usage

        ### Apigee Environment Keyvaluemaps Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_environment = gcp.apigee.Environment("apigee_environment",
            org_id=apigee_org.id,
            name="tf-test-env",
            description="Apigee Environment",
            display_name="Apigee Environment")
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="tf-test-instance",
            location="us-central1",
            org_id=apigee_org.id)
        apigee_instance_attachment = gcp.apigee.InstanceAttachment("apigee_instance_attachment",
            instance_id=apigee_instance.id,
            environment=apigee_environment.name)
        apigee_environment_keyvaluemaps = gcp.apigee.EnvironmentKeyvaluemaps("apigee_environment_keyvaluemaps",
            env_id=apigee_environment.id,
            name="tf-test-env-kvms",
            opts = pulumi.ResourceOptions(depends_on=[
                    apigee_org,
                    apigee_environment,
                    apigee_instance,
                    apigee_instance_attachment,
                ]))
        ```

        ## Import

        EnvironmentKeyvaluemaps can be imported using any of these accepted formats:

        * `{{env_id}}/keyvaluemaps/{{name}}`

        * `{{env_id}}/{{name}}`

        When using the `pulumi import` command, EnvironmentKeyvaluemaps can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/environmentKeyvaluemaps:EnvironmentKeyvaluemaps default {{env_id}}/keyvaluemaps/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/environmentKeyvaluemaps:EnvironmentKeyvaluemaps default {{env_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] env_id: The Apigee environment group associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}`.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: Required. ID of the key value map.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentKeyvaluemapsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Collection of key/value string pairs.

        To get more information about EnvironmentKeyvaluemaps, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.keyvaluemaps/create)
        * How-to Guides
            * [Using key value maps](https://cloud.google.com/apigee/docs/api-platform/cache/key-value-maps)

        ## Example Usage

        ### Apigee Environment Keyvaluemaps Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_environment = gcp.apigee.Environment("apigee_environment",
            org_id=apigee_org.id,
            name="tf-test-env",
            description="Apigee Environment",
            display_name="Apigee Environment")
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="tf-test-instance",
            location="us-central1",
            org_id=apigee_org.id)
        apigee_instance_attachment = gcp.apigee.InstanceAttachment("apigee_instance_attachment",
            instance_id=apigee_instance.id,
            environment=apigee_environment.name)
        apigee_environment_keyvaluemaps = gcp.apigee.EnvironmentKeyvaluemaps("apigee_environment_keyvaluemaps",
            env_id=apigee_environment.id,
            name="tf-test-env-kvms",
            opts = pulumi.ResourceOptions(depends_on=[
                    apigee_org,
                    apigee_environment,
                    apigee_instance,
                    apigee_instance_attachment,
                ]))
        ```

        ## Import

        EnvironmentKeyvaluemaps can be imported using any of these accepted formats:

        * `{{env_id}}/keyvaluemaps/{{name}}`

        * `{{env_id}}/{{name}}`

        When using the `pulumi import` command, EnvironmentKeyvaluemaps can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/environmentKeyvaluemaps:EnvironmentKeyvaluemaps default {{env_id}}/keyvaluemaps/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/environmentKeyvaluemaps:EnvironmentKeyvaluemaps default {{env_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentKeyvaluemapsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentKeyvaluemapsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 env_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentKeyvaluemapsArgs.__new__(EnvironmentKeyvaluemapsArgs)

            if env_id is None and not opts.urn:
                raise TypeError("Missing required property 'env_id'")
            __props__.__dict__["env_id"] = env_id
            __props__.__dict__["name"] = name
        super(EnvironmentKeyvaluemaps, __self__).__init__(
            'gcp:apigee/environmentKeyvaluemaps:EnvironmentKeyvaluemaps',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            env_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'EnvironmentKeyvaluemaps':
        """
        Get an existing EnvironmentKeyvaluemaps resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] env_id: The Apigee environment group associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}`.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: Required. ID of the key value map.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentKeyvaluemapsState.__new__(_EnvironmentKeyvaluemapsState)

        __props__.__dict__["env_id"] = env_id
        __props__.__dict__["name"] = name
        return EnvironmentKeyvaluemaps(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Output[builtins.str]:
        """
        The Apigee environment group associated with the Apigee environment,
        in the format `organizations/{{org_name}}/environments/{{env_name}}`.


        - - -
        """
        return pulumi.get(self, "env_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Required. ID of the key value map.
        """
        return pulumi.get(self, "name")

