# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FlowhookArgs', 'Flowhook']

@pulumi.input_type
class FlowhookArgs:
    def __init__(__self__, *,
                 environment: pulumi.Input[builtins.str],
                 flow_hook_point: pulumi.Input[builtins.str],
                 org_id: pulumi.Input[builtins.str],
                 sharedflow: pulumi.Input[builtins.str],
                 continue_on_error: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Flowhook resource.
        :param pulumi.Input[builtins.str] environment: The resource ID of the environment.
        :param pulumi.Input[builtins.str] flow_hook_point: Where in the API call flow the flow hook is invoked. Must be one of PreProxyFlowHook, PostProxyFlowHook, PreTargetFlowHook, or PostTargetFlowHook.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the environment
        :param pulumi.Input[builtins.str] sharedflow: Id of the Sharedflow attaching to a flowhook point.
        :param pulumi.Input[builtins.bool] continue_on_error: Flag that specifies whether execution should continue if the flow hook throws an exception. Set to true to continue execution. Set to false to stop execution if the flow hook throws an exception. Defaults to true.
        :param pulumi.Input[builtins.str] description: Description of the flow hook.
        """
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "flow_hook_point", flow_hook_point)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "sharedflow", sharedflow)
        if continue_on_error is not None:
            pulumi.set(__self__, "continue_on_error", continue_on_error)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Input[builtins.str]:
        """
        The resource ID of the environment.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="flowHookPoint")
    def flow_hook_point(self) -> pulumi.Input[builtins.str]:
        """
        Where in the API call flow the flow hook is invoked. Must be one of PreProxyFlowHook, PostProxyFlowHook, PreTargetFlowHook, or PostTargetFlowHook.
        """
        return pulumi.get(self, "flow_hook_point")

    @flow_hook_point.setter
    def flow_hook_point(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "flow_hook_point", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[builtins.str]:
        """
        The Apigee Organization associated with the environment
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def sharedflow(self) -> pulumi.Input[builtins.str]:
        """
        Id of the Sharedflow attaching to a flowhook point.
        """
        return pulumi.get(self, "sharedflow")

    @sharedflow.setter
    def sharedflow(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sharedflow", value)

    @property
    @pulumi.getter(name="continueOnError")
    def continue_on_error(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that specifies whether execution should continue if the flow hook throws an exception. Set to true to continue execution. Set to false to stop execution if the flow hook throws an exception. Defaults to true.
        """
        return pulumi.get(self, "continue_on_error")

    @continue_on_error.setter
    def continue_on_error(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "continue_on_error", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the flow hook.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _FlowhookState:
    def __init__(__self__, *,
                 continue_on_error: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 flow_hook_point: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 sharedflow: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Flowhook resources.
        :param pulumi.Input[builtins.bool] continue_on_error: Flag that specifies whether execution should continue if the flow hook throws an exception. Set to true to continue execution. Set to false to stop execution if the flow hook throws an exception. Defaults to true.
        :param pulumi.Input[builtins.str] description: Description of the flow hook.
        :param pulumi.Input[builtins.str] environment: The resource ID of the environment.
        :param pulumi.Input[builtins.str] flow_hook_point: Where in the API call flow the flow hook is invoked. Must be one of PreProxyFlowHook, PostProxyFlowHook, PreTargetFlowHook, or PostTargetFlowHook.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the environment
        :param pulumi.Input[builtins.str] sharedflow: Id of the Sharedflow attaching to a flowhook point.
        """
        if continue_on_error is not None:
            pulumi.set(__self__, "continue_on_error", continue_on_error)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if flow_hook_point is not None:
            pulumi.set(__self__, "flow_hook_point", flow_hook_point)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if sharedflow is not None:
            pulumi.set(__self__, "sharedflow", sharedflow)

    @property
    @pulumi.getter(name="continueOnError")
    def continue_on_error(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that specifies whether execution should continue if the flow hook throws an exception. Set to true to continue execution. Set to false to stop execution if the flow hook throws an exception. Defaults to true.
        """
        return pulumi.get(self, "continue_on_error")

    @continue_on_error.setter
    def continue_on_error(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "continue_on_error", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the flow hook.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID of the environment.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="flowHookPoint")
    def flow_hook_point(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Where in the API call flow the flow hook is invoked. Must be one of PreProxyFlowHook, PostProxyFlowHook, PreTargetFlowHook, or PostTargetFlowHook.
        """
        return pulumi.get(self, "flow_hook_point")

    @flow_hook_point.setter
    def flow_hook_point(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "flow_hook_point", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Apigee Organization associated with the environment
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def sharedflow(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the Sharedflow attaching to a flowhook point.
        """
        return pulumi.get(self, "sharedflow")

    @sharedflow.setter
    def sharedflow(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sharedflow", value)


@pulumi.type_token("gcp:apigee/flowhook:Flowhook")
class Flowhook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 continue_on_error: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 flow_hook_point: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 sharedflow: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Represents a sharedflow attachment to a flowhook point.

        To get more information about Flowhook, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.flowhooks#FlowHook)
        * How-to Guides
            * [organizations.environments.flowhooks](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.flowhooks#FlowHook)

        ## Import

        Flowhook can be imported using any of these accepted formats:

        * `organizations/{{org_id}}/environments/{{environment}}/flowhooks/{{flow_hook_point}}`

        * `{{org_id}}/{{environment}}/{{flow_hook_point}}`

        When using the `pulumi import` command, Flowhook can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/flowhook:Flowhook default organizations/{{org_id}}/environments/{{environment}}/flowhooks/{{flow_hook_point}}
        ```

        ```sh
        $ pulumi import gcp:apigee/flowhook:Flowhook default {{org_id}}/{{environment}}/{{flow_hook_point}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] continue_on_error: Flag that specifies whether execution should continue if the flow hook throws an exception. Set to true to continue execution. Set to false to stop execution if the flow hook throws an exception. Defaults to true.
        :param pulumi.Input[builtins.str] description: Description of the flow hook.
        :param pulumi.Input[builtins.str] environment: The resource ID of the environment.
        :param pulumi.Input[builtins.str] flow_hook_point: Where in the API call flow the flow hook is invoked. Must be one of PreProxyFlowHook, PostProxyFlowHook, PreTargetFlowHook, or PostTargetFlowHook.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the environment
        :param pulumi.Input[builtins.str] sharedflow: Id of the Sharedflow attaching to a flowhook point.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlowhookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a sharedflow attachment to a flowhook point.

        To get more information about Flowhook, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.flowhooks#FlowHook)
        * How-to Guides
            * [organizations.environments.flowhooks](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.flowhooks#FlowHook)

        ## Import

        Flowhook can be imported using any of these accepted formats:

        * `organizations/{{org_id}}/environments/{{environment}}/flowhooks/{{flow_hook_point}}`

        * `{{org_id}}/{{environment}}/{{flow_hook_point}}`

        When using the `pulumi import` command, Flowhook can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/flowhook:Flowhook default organizations/{{org_id}}/environments/{{environment}}/flowhooks/{{flow_hook_point}}
        ```

        ```sh
        $ pulumi import gcp:apigee/flowhook:Flowhook default {{org_id}}/{{environment}}/{{flow_hook_point}}
        ```

        :param str resource_name: The name of the resource.
        :param FlowhookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlowhookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 continue_on_error: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 flow_hook_point: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 sharedflow: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlowhookArgs.__new__(FlowhookArgs)

            __props__.__dict__["continue_on_error"] = continue_on_error
            __props__.__dict__["description"] = description
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            if flow_hook_point is None and not opts.urn:
                raise TypeError("Missing required property 'flow_hook_point'")
            __props__.__dict__["flow_hook_point"] = flow_hook_point
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if sharedflow is None and not opts.urn:
                raise TypeError("Missing required property 'sharedflow'")
            __props__.__dict__["sharedflow"] = sharedflow
        super(Flowhook, __self__).__init__(
            'gcp:apigee/flowhook:Flowhook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            continue_on_error: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            environment: Optional[pulumi.Input[builtins.str]] = None,
            flow_hook_point: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            sharedflow: Optional[pulumi.Input[builtins.str]] = None) -> 'Flowhook':
        """
        Get an existing Flowhook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] continue_on_error: Flag that specifies whether execution should continue if the flow hook throws an exception. Set to true to continue execution. Set to false to stop execution if the flow hook throws an exception. Defaults to true.
        :param pulumi.Input[builtins.str] description: Description of the flow hook.
        :param pulumi.Input[builtins.str] environment: The resource ID of the environment.
        :param pulumi.Input[builtins.str] flow_hook_point: Where in the API call flow the flow hook is invoked. Must be one of PreProxyFlowHook, PostProxyFlowHook, PreTargetFlowHook, or PostTargetFlowHook.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the environment
        :param pulumi.Input[builtins.str] sharedflow: Id of the Sharedflow attaching to a flowhook point.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlowhookState.__new__(_FlowhookState)

        __props__.__dict__["continue_on_error"] = continue_on_error
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["flow_hook_point"] = flow_hook_point
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["sharedflow"] = sharedflow
        return Flowhook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="continueOnError")
    def continue_on_error(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Flag that specifies whether execution should continue if the flow hook throws an exception. Set to true to continue execution. Set to false to stop execution if the flow hook throws an exception. Defaults to true.
        """
        return pulumi.get(self, "continue_on_error")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the flow hook.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[builtins.str]:
        """
        The resource ID of the environment.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="flowHookPoint")
    def flow_hook_point(self) -> pulumi.Output[builtins.str]:
        """
        Where in the API call flow the flow hook is invoked. Must be one of PreProxyFlowHook, PostProxyFlowHook, PreTargetFlowHook, or PostTargetFlowHook.
        """
        return pulumi.get(self, "flow_hook_point")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[builtins.str]:
        """
        The Apigee Organization associated with the environment
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def sharedflow(self) -> pulumi.Output[builtins.str]:
        """
        Id of the Sharedflow attaching to a flowhook point.
        """
        return pulumi.get(self, "sharedflow")

