# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityMonitoringConditionArgs', 'SecurityMonitoringCondition']

@pulumi.input_type
class SecurityMonitoringConditionArgs:
    def __init__(__self__, *,
                 condition_id: pulumi.Input[builtins.str],
                 org_id: pulumi.Input[builtins.str],
                 profile: pulumi.Input[builtins.str],
                 scope: pulumi.Input[builtins.str],
                 include_all_resources: Optional[pulumi.Input['SecurityMonitoringConditionIncludeAllResourcesArgs']] = None):
        """
        The set of arguments for constructing a SecurityMonitoringCondition resource.
        :param pulumi.Input[builtins.str] condition_id: Resource ID of the security monitoring condition.
               
               
               - - -
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee Security Monitoring Condition,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[builtins.str] profile: ID of security profile of the security monitoring condition.
        :param pulumi.Input[builtins.str] scope: ID of security profile of the security monitoring condition.
        :param pulumi.Input['SecurityMonitoringConditionIncludeAllResourcesArgs'] include_all_resources: A nested object resource.
        """
        pulumi.set(__self__, "condition_id", condition_id)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "profile", profile)
        pulumi.set(__self__, "scope", scope)
        if include_all_resources is not None:
            pulumi.set(__self__, "include_all_resources", include_all_resources)

    @property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID of the security monitoring condition.


        - - -
        """
        return pulumi.get(self, "condition_id")

    @condition_id.setter
    def condition_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "condition_id", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[builtins.str]:
        """
        The Apigee Organization associated with the Apigee Security Monitoring Condition,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Input[builtins.str]:
        """
        ID of security profile of the security monitoring condition.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[builtins.str]:
        """
        ID of security profile of the security monitoring condition.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="includeAllResources")
    def include_all_resources(self) -> Optional[pulumi.Input['SecurityMonitoringConditionIncludeAllResourcesArgs']]:
        """
        A nested object resource.
        """
        return pulumi.get(self, "include_all_resources")

    @include_all_resources.setter
    def include_all_resources(self, value: Optional[pulumi.Input['SecurityMonitoringConditionIncludeAllResourcesArgs']]):
        pulumi.set(self, "include_all_resources", value)


@pulumi.input_type
class _SecurityMonitoringConditionState:
    def __init__(__self__, *,
                 condition_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 include_all_resources: Optional[pulumi.Input['SecurityMonitoringConditionIncludeAllResourcesArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 total_deployed_resources: Optional[pulumi.Input[builtins.int]] = None,
                 total_monitored_resources: Optional[pulumi.Input[builtins.int]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityMonitoringCondition resources.
        :param pulumi.Input[builtins.str] condition_id: Resource ID of the security monitoring condition.
               
               
               - - -
        :param pulumi.Input[builtins.str] create_time: The timestamp at which this profile was created.
        :param pulumi.Input['SecurityMonitoringConditionIncludeAllResourcesArgs'] include_all_resources: A nested object resource.
        :param pulumi.Input[builtins.str] name: Name of the security monitoring condition resource,
               in the format `organizations/{{org_name}}/securityMonitoringConditions/{{condition_id}}`.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee Security Monitoring Condition,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[builtins.str] profile: ID of security profile of the security monitoring condition.
        :param pulumi.Input[builtins.str] scope: ID of security profile of the security monitoring condition.
        :param pulumi.Input[builtins.int] total_deployed_resources: Total number of deployed resources within scope.
        :param pulumi.Input[builtins.int] total_monitored_resources: Total number of monitored resources within this condition.
        :param pulumi.Input[builtins.str] update_time: The timestamp at which this profile was most recently updated.
        """
        if condition_id is not None:
            pulumi.set(__self__, "condition_id", condition_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if include_all_resources is not None:
            pulumi.set(__self__, "include_all_resources", include_all_resources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if total_deployed_resources is not None:
            pulumi.set(__self__, "total_deployed_resources", total_deployed_resources)
        if total_monitored_resources is not None:
            pulumi.set(__self__, "total_monitored_resources", total_monitored_resources)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID of the security monitoring condition.


        - - -
        """
        return pulumi.get(self, "condition_id")

    @condition_id.setter
    def condition_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp at which this profile was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="includeAllResources")
    def include_all_resources(self) -> Optional[pulumi.Input['SecurityMonitoringConditionIncludeAllResourcesArgs']]:
        """
        A nested object resource.
        """
        return pulumi.get(self, "include_all_resources")

    @include_all_resources.setter
    def include_all_resources(self, value: Optional[pulumi.Input['SecurityMonitoringConditionIncludeAllResourcesArgs']]):
        pulumi.set(self, "include_all_resources", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the security monitoring condition resource,
        in the format `organizations/{{org_name}}/securityMonitoringConditions/{{condition_id}}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Apigee Organization associated with the Apigee Security Monitoring Condition,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of security profile of the security monitoring condition.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of security profile of the security monitoring condition.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="totalDeployedResources")
    def total_deployed_resources(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total number of deployed resources within scope.
        """
        return pulumi.get(self, "total_deployed_resources")

    @total_deployed_resources.setter
    def total_deployed_resources(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_deployed_resources", value)

    @property
    @pulumi.getter(name="totalMonitoredResources")
    def total_monitored_resources(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total number of monitored resources within this condition.
        """
        return pulumi.get(self, "total_monitored_resources")

    @total_monitored_resources.setter
    def total_monitored_resources(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_monitored_resources", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp at which this profile was most recently updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:apigee/securityMonitoringCondition:SecurityMonitoringCondition")
class SecurityMonitoringCondition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition_id: Optional[pulumi.Input[builtins.str]] = None,
                 include_all_resources: Optional[pulumi.Input[Union['SecurityMonitoringConditionIncludeAllResourcesArgs', 'SecurityMonitoringConditionIncludeAllResourcesArgsDict']]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Security monitoring condition for risk assessment version 2 in Apigee.

        To get more information about SecurityMonitoringCondition, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.securityMonitoringConditions/create)
        * How-to Guides
            * [Creating a security monitoring condition](https://cloud.google.com/apigee/docs/api-security/security-scores#monitoring-conditions)

        ## Example Usage

        ### Apigee Security Monitoring Condition Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        env = gcp.apigee.Environment("env",
            name="my-environment",
            description="Apigee Environment",
            display_name="environment-1",
            org_id=apigee_org.id)
        apigee_org_security_addons_config = gcp.apigee.AddonsConfig("apigee_org_security_addons_config",
            org=apigee_org.name,
            addons_config={
                "api_security_config": {
                    "enabled": True,
                },
            })
        security_monitoring_condition = gcp.apigee.SecurityMonitoringCondition("security_monitoring_condition",
            condition_id="my-condition",
            org_id=apigee_org.id,
            profile="google-default",
            scope="my-environment",
            include_all_resources={},
            opts = pulumi.ResourceOptions(depends_on=[apigee_org_security_addons_config]))
        ```

        ## Import

        SecurityMonitoringCondition can be imported using any of these accepted formats:

        * `{{org_id}}/securityMonitoringConditions/{{condition_id}}`

        * `{{org_id}}/{{condition_id}}`

        When using the `pulumi import` command, SecurityMonitoringCondition can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/securityMonitoringCondition:SecurityMonitoringCondition default {{org_id}}/securityMonitoringConditions/{{condition_id}}
        ```

        ```sh
        $ pulumi import gcp:apigee/securityMonitoringCondition:SecurityMonitoringCondition default {{org_id}}/{{condition_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] condition_id: Resource ID of the security monitoring condition.
               
               
               - - -
        :param pulumi.Input[Union['SecurityMonitoringConditionIncludeAllResourcesArgs', 'SecurityMonitoringConditionIncludeAllResourcesArgsDict']] include_all_resources: A nested object resource.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee Security Monitoring Condition,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[builtins.str] profile: ID of security profile of the security monitoring condition.
        :param pulumi.Input[builtins.str] scope: ID of security profile of the security monitoring condition.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityMonitoringConditionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Security monitoring condition for risk assessment version 2 in Apigee.

        To get more information about SecurityMonitoringCondition, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.securityMonitoringConditions/create)
        * How-to Guides
            * [Creating a security monitoring condition](https://cloud.google.com/apigee/docs/api-security/security-scores#monitoring-conditions)

        ## Example Usage

        ### Apigee Security Monitoring Condition Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        env = gcp.apigee.Environment("env",
            name="my-environment",
            description="Apigee Environment",
            display_name="environment-1",
            org_id=apigee_org.id)
        apigee_org_security_addons_config = gcp.apigee.AddonsConfig("apigee_org_security_addons_config",
            org=apigee_org.name,
            addons_config={
                "api_security_config": {
                    "enabled": True,
                },
            })
        security_monitoring_condition = gcp.apigee.SecurityMonitoringCondition("security_monitoring_condition",
            condition_id="my-condition",
            org_id=apigee_org.id,
            profile="google-default",
            scope="my-environment",
            include_all_resources={},
            opts = pulumi.ResourceOptions(depends_on=[apigee_org_security_addons_config]))
        ```

        ## Import

        SecurityMonitoringCondition can be imported using any of these accepted formats:

        * `{{org_id}}/securityMonitoringConditions/{{condition_id}}`

        * `{{org_id}}/{{condition_id}}`

        When using the `pulumi import` command, SecurityMonitoringCondition can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/securityMonitoringCondition:SecurityMonitoringCondition default {{org_id}}/securityMonitoringConditions/{{condition_id}}
        ```

        ```sh
        $ pulumi import gcp:apigee/securityMonitoringCondition:SecurityMonitoringCondition default {{org_id}}/{{condition_id}}
        ```

        :param str resource_name: The name of the resource.
        :param SecurityMonitoringConditionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityMonitoringConditionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition_id: Optional[pulumi.Input[builtins.str]] = None,
                 include_all_resources: Optional[pulumi.Input[Union['SecurityMonitoringConditionIncludeAllResourcesArgs', 'SecurityMonitoringConditionIncludeAllResourcesArgsDict']]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityMonitoringConditionArgs.__new__(SecurityMonitoringConditionArgs)

            if condition_id is None and not opts.urn:
                raise TypeError("Missing required property 'condition_id'")
            __props__.__dict__["condition_id"] = condition_id
            __props__.__dict__["include_all_resources"] = include_all_resources
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if profile is None and not opts.urn:
                raise TypeError("Missing required property 'profile'")
            __props__.__dict__["profile"] = profile
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["total_deployed_resources"] = None
            __props__.__dict__["total_monitored_resources"] = None
            __props__.__dict__["update_time"] = None
        super(SecurityMonitoringCondition, __self__).__init__(
            'gcp:apigee/securityMonitoringCondition:SecurityMonitoringCondition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            condition_id: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            include_all_resources: Optional[pulumi.Input[Union['SecurityMonitoringConditionIncludeAllResourcesArgs', 'SecurityMonitoringConditionIncludeAllResourcesArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            profile: Optional[pulumi.Input[builtins.str]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None,
            total_deployed_resources: Optional[pulumi.Input[builtins.int]] = None,
            total_monitored_resources: Optional[pulumi.Input[builtins.int]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'SecurityMonitoringCondition':
        """
        Get an existing SecurityMonitoringCondition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] condition_id: Resource ID of the security monitoring condition.
               
               
               - - -
        :param pulumi.Input[builtins.str] create_time: The timestamp at which this profile was created.
        :param pulumi.Input[Union['SecurityMonitoringConditionIncludeAllResourcesArgs', 'SecurityMonitoringConditionIncludeAllResourcesArgsDict']] include_all_resources: A nested object resource.
        :param pulumi.Input[builtins.str] name: Name of the security monitoring condition resource,
               in the format `organizations/{{org_name}}/securityMonitoringConditions/{{condition_id}}`.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee Security Monitoring Condition,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[builtins.str] profile: ID of security profile of the security monitoring condition.
        :param pulumi.Input[builtins.str] scope: ID of security profile of the security monitoring condition.
        :param pulumi.Input[builtins.int] total_deployed_resources: Total number of deployed resources within scope.
        :param pulumi.Input[builtins.int] total_monitored_resources: Total number of monitored resources within this condition.
        :param pulumi.Input[builtins.str] update_time: The timestamp at which this profile was most recently updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityMonitoringConditionState.__new__(_SecurityMonitoringConditionState)

        __props__.__dict__["condition_id"] = condition_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["include_all_resources"] = include_all_resources
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["profile"] = profile
        __props__.__dict__["scope"] = scope
        __props__.__dict__["total_deployed_resources"] = total_deployed_resources
        __props__.__dict__["total_monitored_resources"] = total_monitored_resources
        __props__.__dict__["update_time"] = update_time
        return SecurityMonitoringCondition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> pulumi.Output[builtins.str]:
        """
        Resource ID of the security monitoring condition.


        - - -
        """
        return pulumi.get(self, "condition_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp at which this profile was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="includeAllResources")
    def include_all_resources(self) -> pulumi.Output[Optional['outputs.SecurityMonitoringConditionIncludeAllResources']]:
        """
        A nested object resource.
        """
        return pulumi.get(self, "include_all_resources")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the security monitoring condition resource,
        in the format `organizations/{{org_name}}/securityMonitoringConditions/{{condition_id}}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[builtins.str]:
        """
        The Apigee Organization associated with the Apigee Security Monitoring Condition,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Output[builtins.str]:
        """
        ID of security profile of the security monitoring condition.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[builtins.str]:
        """
        ID of security profile of the security monitoring condition.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="totalDeployedResources")
    def total_deployed_resources(self) -> pulumi.Output[builtins.int]:
        """
        Total number of deployed resources within scope.
        """
        return pulumi.get(self, "total_deployed_resources")

    @property
    @pulumi.getter(name="totalMonitoredResources")
    def total_monitored_resources(self) -> pulumi.Output[builtins.int]:
        """
        Total number of monitored resources within this condition.
        """
        return pulumi.get(self, "total_monitored_resources")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp at which this profile was most recently updated.
        """
        return pulumi.get(self, "update_time")

