# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HostProjectRegistrationArgs', 'HostProjectRegistration']

@pulumi.input_type
class HostProjectRegistrationArgs:
    def __init__(__self__, *,
                 gcp_project: pulumi.Input[builtins.str],
                 host_project_registration_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a HostProjectRegistration resource.
        :param pulumi.Input[builtins.str] gcp_project: Required. Immutable. Google cloud project name in the format: "projects/abc" or "projects/123".
               As input, project name with either project id or number are accepted.
               As output, this field will contain project number.
        :param pulumi.Input[builtins.str] host_project_registration_id: Required. The ID to use for the Host Project Registration, which will become the
               final component of the host project registration's resource name. The ID
               must be the same as the Google cloud project specified in the
               host_project_registration.gcp_project field.
               
               
               - - -
        :param pulumi.Input[builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "gcp_project", gcp_project)
        pulumi.set(__self__, "host_project_registration_id", host_project_registration_id)
        pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="gcpProject")
    def gcp_project(self) -> pulumi.Input[builtins.str]:
        """
        Required. Immutable. Google cloud project name in the format: "projects/abc" or "projects/123".
        As input, project name with either project id or number are accepted.
        As output, this field will contain project number.
        """
        return pulumi.get(self, "gcp_project")

    @gcp_project.setter
    def gcp_project(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "gcp_project", value)

    @property
    @pulumi.getter(name="hostProjectRegistrationId")
    def host_project_registration_id(self) -> pulumi.Input[builtins.str]:
        """
        Required. The ID to use for the Host Project Registration, which will become the
        final component of the host project registration's resource name. The ID
        must be the same as the Google cloud project specified in the
        host_project_registration.gcp_project field.


        - - -
        """
        return pulumi.get(self, "host_project_registration_id")

    @host_project_registration_id.setter
    def host_project_registration_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host_project_registration_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _HostProjectRegistrationState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 gcp_project: Optional[pulumi.Input[builtins.str]] = None,
                 host_project_registration_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering HostProjectRegistration resources.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which the host project registration was created.
        :param pulumi.Input[builtins.str] gcp_project: Required. Immutable. Google cloud project name in the format: "projects/abc" or "projects/123".
               As input, project name with either project id or number are accepted.
               As output, this field will contain project number.
        :param pulumi.Input[builtins.str] host_project_registration_id: Required. The ID to use for the Host Project Registration, which will become the
               final component of the host project registration's resource name. The ID
               must be the same as the Google cloud project specified in the
               host_project_registration.gcp_project field.
               
               
               - - -
        :param pulumi.Input[builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] name: Identifier. The name of the host project registration.
               Format:
               "projects/{project}/locations/{location}/hostProjectRegistrations/{host_project_registration}".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if gcp_project is not None:
            pulumi.set(__self__, "gcp_project", gcp_project)
        if host_project_registration_id is not None:
            pulumi.set(__self__, "host_project_registration_id", host_project_registration_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which the host project registration was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="gcpProject")
    def gcp_project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. Immutable. Google cloud project name in the format: "projects/abc" or "projects/123".
        As input, project name with either project id or number are accepted.
        As output, this field will contain project number.
        """
        return pulumi.get(self, "gcp_project")

    @gcp_project.setter
    def gcp_project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gcp_project", value)

    @property
    @pulumi.getter(name="hostProjectRegistrationId")
    def host_project_registration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. The ID to use for the Host Project Registration, which will become the
        final component of the host project registration's resource name. The ID
        must be the same as the Google cloud project specified in the
        host_project_registration.gcp_project field.


        - - -
        """
        return pulumi.get(self, "host_project_registration_id")

    @host_project_registration_id.setter
    def host_project_registration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_project_registration_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The name of the host project registration.
        Format:
        "projects/{project}/locations/{location}/hostProjectRegistrations/{host_project_registration}".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gcp:apihub/hostProjectRegistration:HostProjectRegistration")
class HostProjectRegistration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gcp_project: Optional[pulumi.Input[builtins.str]] = None,
                 host_project_registration_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Host project registration refers to the registration of a Google cloud project with API hub as a host project.
        This is the project where API hub is provisioned.
        It acts as the consumer project for the API hub instance provisioned.
        Multiple runtime projects can be attached to the host project and these attachments define the scope of API hub.

        ## Example Usage

        ### Apihub Host Project Registration Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.Project("project",
            name="apihub-proj",
            project_id="apihub-proj",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[project]))
        # Enable API hub API
        apihub_service = gcp.projects.Service("apihub_service",
            project=project.project_id,
            service="apihub.googleapis.com",
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        apihub_host_project = gcp.apihub.HostProjectRegistration("apihub_host_project",
            project=project.project_id,
            location="asia-south1",
            host_project_registration_id=project.project_id,
            gcp_project=project.project_id.apply(lambda project_id: f"projects/{project_id}"),
            opts = pulumi.ResourceOptions(depends_on=[apihub_service]))
        ```

        ## Import

        HostProjectRegistration can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/hostProjectRegistrations/{{host_project_registration_id}}`

        * `{{project}}/{{location}}/{{host_project_registration_id}}`

        * `{{location}}/{{host_project_registration_id}}`

        When using the `pulumi import` command, HostProjectRegistration can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apihub/hostProjectRegistration:HostProjectRegistration default projects/{{project}}/locations/{{location}}/hostProjectRegistrations/{{host_project_registration_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/hostProjectRegistration:HostProjectRegistration default {{project}}/{{location}}/{{host_project_registration_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/hostProjectRegistration:HostProjectRegistration default {{location}}/{{host_project_registration_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] gcp_project: Required. Immutable. Google cloud project name in the format: "projects/abc" or "projects/123".
               As input, project name with either project id or number are accepted.
               As output, this field will contain project number.
        :param pulumi.Input[builtins.str] host_project_registration_id: Required. The ID to use for the Host Project Registration, which will become the
               final component of the host project registration's resource name. The ID
               must be the same as the Google cloud project specified in the
               host_project_registration.gcp_project field.
               
               
               - - -
        :param pulumi.Input[builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostProjectRegistrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Host project registration refers to the registration of a Google cloud project with API hub as a host project.
        This is the project where API hub is provisioned.
        It acts as the consumer project for the API hub instance provisioned.
        Multiple runtime projects can be attached to the host project and these attachments define the scope of API hub.

        ## Example Usage

        ### Apihub Host Project Registration Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.Project("project",
            name="apihub-proj",
            project_id="apihub-proj",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[project]))
        # Enable API hub API
        apihub_service = gcp.projects.Service("apihub_service",
            project=project.project_id,
            service="apihub.googleapis.com",
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        apihub_host_project = gcp.apihub.HostProjectRegistration("apihub_host_project",
            project=project.project_id,
            location="asia-south1",
            host_project_registration_id=project.project_id,
            gcp_project=project.project_id.apply(lambda project_id: f"projects/{project_id}"),
            opts = pulumi.ResourceOptions(depends_on=[apihub_service]))
        ```

        ## Import

        HostProjectRegistration can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/hostProjectRegistrations/{{host_project_registration_id}}`

        * `{{project}}/{{location}}/{{host_project_registration_id}}`

        * `{{location}}/{{host_project_registration_id}}`

        When using the `pulumi import` command, HostProjectRegistration can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apihub/hostProjectRegistration:HostProjectRegistration default projects/{{project}}/locations/{{location}}/hostProjectRegistrations/{{host_project_registration_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/hostProjectRegistration:HostProjectRegistration default {{project}}/{{location}}/{{host_project_registration_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/hostProjectRegistration:HostProjectRegistration default {{location}}/{{host_project_registration_id}}
        ```

        :param str resource_name: The name of the resource.
        :param HostProjectRegistrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostProjectRegistrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gcp_project: Optional[pulumi.Input[builtins.str]] = None,
                 host_project_registration_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostProjectRegistrationArgs.__new__(HostProjectRegistrationArgs)

            if gcp_project is None and not opts.urn:
                raise TypeError("Missing required property 'gcp_project'")
            __props__.__dict__["gcp_project"] = gcp_project
            if host_project_registration_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_project_registration_id'")
            __props__.__dict__["host_project_registration_id"] = host_project_registration_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
        super(HostProjectRegistration, __self__).__init__(
            'gcp:apihub/hostProjectRegistration:HostProjectRegistration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            gcp_project: Optional[pulumi.Input[builtins.str]] = None,
            host_project_registration_id: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None) -> 'HostProjectRegistration':
        """
        Get an existing HostProjectRegistration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which the host project registration was created.
        :param pulumi.Input[builtins.str] gcp_project: Required. Immutable. Google cloud project name in the format: "projects/abc" or "projects/123".
               As input, project name with either project id or number are accepted.
               As output, this field will contain project number.
        :param pulumi.Input[builtins.str] host_project_registration_id: Required. The ID to use for the Host Project Registration, which will become the
               final component of the host project registration's resource name. The ID
               must be the same as the Google cloud project specified in the
               host_project_registration.gcp_project field.
               
               
               - - -
        :param pulumi.Input[builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] name: Identifier. The name of the host project registration.
               Format:
               "projects/{project}/locations/{location}/hostProjectRegistrations/{host_project_registration}".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostProjectRegistrationState.__new__(_HostProjectRegistrationState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["gcp_project"] = gcp_project
        __props__.__dict__["host_project_registration_id"] = host_project_registration_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        return HostProjectRegistration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which the host project registration was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="gcpProject")
    def gcp_project(self) -> pulumi.Output[builtins.str]:
        """
        Required. Immutable. Google cloud project name in the format: "projects/abc" or "projects/123".
        As input, project name with either project id or number are accepted.
        As output, this field will contain project number.
        """
        return pulumi.get(self, "gcp_project")

    @property
    @pulumi.getter(name="hostProjectRegistrationId")
    def host_project_registration_id(self) -> pulumi.Output[builtins.str]:
        """
        Required. The ID to use for the Host Project Registration, which will become the
        final component of the host project registration's resource name. The ID
        must be the same as the Google cloud project specified in the
        host_project_registration.gcp_project field.


        - - -
        """
        return pulumi.get(self, "host_project_registration_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The name of the host project registration.
        Format:
        "projects/{project}/locations/{location}/hostProjectRegistrations/{host_project_registration}".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

