# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PluginInstanceArgs', 'PluginInstance']

@pulumi.input_type
class PluginInstanceArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 plugin: pulumi.Input[builtins.str],
                 plugin_instance_id: pulumi.Input[builtins.str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionArgs']]]] = None,
                 auth_config: Optional[pulumi.Input['PluginInstanceAuthConfigArgs']] = None,
                 disable: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PluginInstance resource.
        :param pulumi.Input[builtins.str] display_name: The display name for this plugin instance. Max length is 255 characters.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] plugin: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] plugin_instance_id: The ID to use for the plugin instance, which will become the final
               component of the plugin instance's resource name. This field is optional.
               * If provided, the same will be used. The service will throw an error if
               the specified id is already used by another plugin instance in the plugin
               resource.
               * If not provided, a system generated id will be used.
               This value should be 4-63 characters, and valid characters
               are /a-z[0-9]-_/.
        :param pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionArgs']]] actions: The action status for the plugin instance.
               Structure is documented below.
        :param pulumi.Input['PluginInstanceAuthConfigArgs'] auth_config: AuthConfig represents the authentication information.
        :param pulumi.Input[builtins.bool] disable: The display name for this plugin instance. Max length is 255 characters.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "plugin", plugin)
        pulumi.set(__self__, "plugin_instance_id", plugin_instance_id)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if disable is not None:
            pulumi.set(__self__, "disable", disable)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The display name for this plugin instance. Max length is 255 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def plugin(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "plugin")

    @plugin.setter
    def plugin(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "plugin", value)

    @property
    @pulumi.getter(name="pluginInstanceId")
    def plugin_instance_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID to use for the plugin instance, which will become the final
        component of the plugin instance's resource name. This field is optional.
        * If provided, the same will be used. The service will throw an error if
        the specified id is already used by another plugin instance in the plugin
        resource.
        * If not provided, a system generated id will be used.
        This value should be 4-63 characters, and valid characters
        are /a-z[0-9]-_/.
        """
        return pulumi.get(self, "plugin_instance_id")

    @plugin_instance_id.setter
    def plugin_instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "plugin_instance_id", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionArgs']]]]:
        """
        The action status for the plugin instance.
        Structure is documented below.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional[pulumi.Input['PluginInstanceAuthConfigArgs']]:
        """
        AuthConfig represents the authentication information.
        """
        return pulumi.get(self, "auth_config")

    @auth_config.setter
    def auth_config(self, value: Optional[pulumi.Input['PluginInstanceAuthConfigArgs']]):
        pulumi.set(self, "auth_config", value)

    @property
    @pulumi.getter
    def disable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The display name for this plugin instance. Max length is 255 characters.
        """
        return pulumi.get(self, "disable")

    @disable.setter
    def disable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _PluginInstanceState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionArgs']]]] = None,
                 auth_config: Optional[pulumi.Input['PluginInstanceAuthConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 disable: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 error_message: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 plugin: Optional[pulumi.Input[builtins.str]] = None,
                 plugin_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PluginInstance resources.
        :param pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionArgs']]] actions: The action status for the plugin instance.
               Structure is documented below.
        :param pulumi.Input['PluginInstanceAuthConfigArgs'] auth_config: AuthConfig represents the authentication information.
        :param pulumi.Input[builtins.str] create_time: Timestamp indicating when the plugin instance was created.
        :param pulumi.Input[builtins.bool] disable: The display name for this plugin instance. Max length is 255 characters.
        :param pulumi.Input[builtins.str] display_name: The display name for this plugin instance. Max length is 255 characters.
        :param pulumi.Input[builtins.str] error_message: Error message describing the failure, if any, during Create, Delete or
               ApplyConfig operation corresponding to the plugin instance.This field will
               only be populated if the plugin instance is in the ERROR or FAILED state.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] name: Identifier. The unique name of the plugin instance resource.
               Format:
               `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
        :param pulumi.Input[builtins.str] plugin: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] plugin_instance_id: The ID to use for the plugin instance, which will become the final
               component of the plugin instance's resource name. This field is optional.
               * If provided, the same will be used. The service will throw an error if
               the specified id is already used by another plugin instance in the plugin
               resource.
               * If not provided, a system generated id will be used.
               This value should be 4-63 characters, and valid characters
               are /a-z[0-9]-_/.
        :param pulumi.Input[builtins.str] state: The current state of the plugin instance (e.g., enabled, disabled,
               provisioning).
               Possible values:
               STATE_UNSPECIFIED
               CREATING
               ACTIVE
               APPLYING_CONFIG
               ERROR
               FAILED
               DELETING
        :param pulumi.Input[builtins.str] update_time: Timestamp indicating when the plugin instance was last updated.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if disable is not None:
            pulumi.set(__self__, "disable", disable)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plugin is not None:
            pulumi.set(__self__, "plugin", plugin)
        if plugin_instance_id is not None:
            pulumi.set(__self__, "plugin_instance_id", plugin_instance_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionArgs']]]]:
        """
        The action status for the plugin instance.
        Structure is documented below.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional[pulumi.Input['PluginInstanceAuthConfigArgs']]:
        """
        AuthConfig represents the authentication information.
        """
        return pulumi.get(self, "auth_config")

    @auth_config.setter
    def auth_config(self, value: Optional[pulumi.Input['PluginInstanceAuthConfigArgs']]):
        pulumi.set(self, "auth_config", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp indicating when the plugin instance was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def disable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The display name for this plugin instance. Max length is 255 characters.
        """
        return pulumi.get(self, "disable")

    @disable.setter
    def disable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name for this plugin instance. Max length is 255 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Error message describing the failure, if any, during Create, Delete or
        ApplyConfig operation corresponding to the plugin instance.This field will
        only be populated if the plugin instance is in the ERROR or FAILED state.
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "error_message", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The unique name of the plugin instance resource.
        Format:
        `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def plugin(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "plugin")

    @plugin.setter
    def plugin(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plugin", value)

    @property
    @pulumi.getter(name="pluginInstanceId")
    def plugin_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the plugin instance, which will become the final
        component of the plugin instance's resource name. This field is optional.
        * If provided, the same will be used. The service will throw an error if
        the specified id is already used by another plugin instance in the plugin
        resource.
        * If not provided, a system generated id will be used.
        This value should be 4-63 characters, and valid characters
        are /a-z[0-9]-_/.
        """
        return pulumi.get(self, "plugin_instance_id")

    @plugin_instance_id.setter
    def plugin_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plugin_instance_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the plugin instance (e.g., enabled, disabled,
        provisioning).
        Possible values:
        STATE_UNSPECIFIED
        CREATING
        ACTIVE
        APPLYING_CONFIG
        ERROR
        FAILED
        DELETING
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp indicating when the plugin instance was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:apihub/pluginInstance:PluginInstance")
class PluginInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PluginInstanceActionArgs', 'PluginInstanceActionArgsDict']]]]] = None,
                 auth_config: Optional[pulumi.Input[Union['PluginInstanceAuthConfigArgs', 'PluginInstanceAuthConfigArgsDict']]] = None,
                 disable: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 plugin: Optional[pulumi.Input[builtins.str]] = None,
                 plugin_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Description

        ## Example Usage

        ### Apihub Plugin Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        apihub_plugin_instance_basic = gcp.apihub.PluginInstance("apihub_plugin_instance_basic",
            location="us-central1",
            plugin="existing-plugin-id",
            plugin_instance_id="test",
            display_name="Sample Plugin Instance Display Name",
            disable=False,
            actions=[{
                "action_id": "existing-action-id",
            }])
        ```

        ## Import

        PluginInstance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/plugins/{{plugin}}/instances/{{plugin_instance_id}}`

        * `{{project}}/{{location}}/{{plugin}}/{{plugin_instance_id}}`

        * `{{location}}/{{plugin}}/{{plugin_instance_id}}`

        When using the `pulumi import` command, PluginInstance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apihub/pluginInstance:PluginInstance default projects/{{project}}/locations/{{location}}/plugins/{{plugin}}/instances/{{plugin_instance_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/pluginInstance:PluginInstance default {{project}}/{{location}}/{{plugin}}/{{plugin_instance_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/pluginInstance:PluginInstance default {{location}}/{{plugin}}/{{plugin_instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PluginInstanceActionArgs', 'PluginInstanceActionArgsDict']]]] actions: The action status for the plugin instance.
               Structure is documented below.
        :param pulumi.Input[Union['PluginInstanceAuthConfigArgs', 'PluginInstanceAuthConfigArgsDict']] auth_config: AuthConfig represents the authentication information.
        :param pulumi.Input[builtins.bool] disable: The display name for this plugin instance. Max length is 255 characters.
        :param pulumi.Input[builtins.str] display_name: The display name for this plugin instance. Max length is 255 characters.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] plugin: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] plugin_instance_id: The ID to use for the plugin instance, which will become the final
               component of the plugin instance's resource name. This field is optional.
               * If provided, the same will be used. The service will throw an error if
               the specified id is already used by another plugin instance in the plugin
               resource.
               * If not provided, a system generated id will be used.
               This value should be 4-63 characters, and valid characters
               are /a-z[0-9]-_/.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PluginInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Description

        ## Example Usage

        ### Apihub Plugin Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        apihub_plugin_instance_basic = gcp.apihub.PluginInstance("apihub_plugin_instance_basic",
            location="us-central1",
            plugin="existing-plugin-id",
            plugin_instance_id="test",
            display_name="Sample Plugin Instance Display Name",
            disable=False,
            actions=[{
                "action_id": "existing-action-id",
            }])
        ```

        ## Import

        PluginInstance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/plugins/{{plugin}}/instances/{{plugin_instance_id}}`

        * `{{project}}/{{location}}/{{plugin}}/{{plugin_instance_id}}`

        * `{{location}}/{{plugin}}/{{plugin_instance_id}}`

        When using the `pulumi import` command, PluginInstance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apihub/pluginInstance:PluginInstance default projects/{{project}}/locations/{{location}}/plugins/{{plugin}}/instances/{{plugin_instance_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/pluginInstance:PluginInstance default {{project}}/{{location}}/{{plugin}}/{{plugin_instance_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/pluginInstance:PluginInstance default {{location}}/{{plugin}}/{{plugin_instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param PluginInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PluginInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PluginInstanceActionArgs', 'PluginInstanceActionArgsDict']]]]] = None,
                 auth_config: Optional[pulumi.Input[Union['PluginInstanceAuthConfigArgs', 'PluginInstanceAuthConfigArgsDict']]] = None,
                 disable: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 plugin: Optional[pulumi.Input[builtins.str]] = None,
                 plugin_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PluginInstanceArgs.__new__(PluginInstanceArgs)

            __props__.__dict__["actions"] = actions
            __props__.__dict__["auth_config"] = auth_config
            __props__.__dict__["disable"] = disable
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if plugin is None and not opts.urn:
                raise TypeError("Missing required property 'plugin'")
            __props__.__dict__["plugin"] = plugin
            if plugin_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'plugin_instance_id'")
            __props__.__dict__["plugin_instance_id"] = plugin_instance_id
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["error_message"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        super(PluginInstance, __self__).__init__(
            'gcp:apihub/pluginInstance:PluginInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PluginInstanceActionArgs', 'PluginInstanceActionArgsDict']]]]] = None,
            auth_config: Optional[pulumi.Input[Union['PluginInstanceAuthConfigArgs', 'PluginInstanceAuthConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            disable: Optional[pulumi.Input[builtins.bool]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            error_message: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            plugin: Optional[pulumi.Input[builtins.str]] = None,
            plugin_instance_id: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'PluginInstance':
        """
        Get an existing PluginInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PluginInstanceActionArgs', 'PluginInstanceActionArgsDict']]]] actions: The action status for the plugin instance.
               Structure is documented below.
        :param pulumi.Input[Union['PluginInstanceAuthConfigArgs', 'PluginInstanceAuthConfigArgsDict']] auth_config: AuthConfig represents the authentication information.
        :param pulumi.Input[builtins.str] create_time: Timestamp indicating when the plugin instance was created.
        :param pulumi.Input[builtins.bool] disable: The display name for this plugin instance. Max length is 255 characters.
        :param pulumi.Input[builtins.str] display_name: The display name for this plugin instance. Max length is 255 characters.
        :param pulumi.Input[builtins.str] error_message: Error message describing the failure, if any, during Create, Delete or
               ApplyConfig operation corresponding to the plugin instance.This field will
               only be populated if the plugin instance is in the ERROR or FAILED state.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] name: Identifier. The unique name of the plugin instance resource.
               Format:
               `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
        :param pulumi.Input[builtins.str] plugin: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] plugin_instance_id: The ID to use for the plugin instance, which will become the final
               component of the plugin instance's resource name. This field is optional.
               * If provided, the same will be used. The service will throw an error if
               the specified id is already used by another plugin instance in the plugin
               resource.
               * If not provided, a system generated id will be used.
               This value should be 4-63 characters, and valid characters
               are /a-z[0-9]-_/.
        :param pulumi.Input[builtins.str] state: The current state of the plugin instance (e.g., enabled, disabled,
               provisioning).
               Possible values:
               STATE_UNSPECIFIED
               CREATING
               ACTIVE
               APPLYING_CONFIG
               ERROR
               FAILED
               DELETING
        :param pulumi.Input[builtins.str] update_time: Timestamp indicating when the plugin instance was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PluginInstanceState.__new__(_PluginInstanceState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["auth_config"] = auth_config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["disable"] = disable
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["error_message"] = error_message
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["plugin"] = plugin
        __props__.__dict__["plugin_instance_id"] = plugin_instance_id
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return PluginInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.PluginInstanceAction']]:
        """
        The action status for the plugin instance.
        Structure is documented below.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> pulumi.Output[Optional['outputs.PluginInstanceAuthConfig']]:
        """
        AuthConfig represents the authentication information.
        """
        return pulumi.get(self, "auth_config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp indicating when the plugin instance was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def disable(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The display name for this plugin instance. Max length is 255 characters.
        """
        return pulumi.get(self, "disable")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name for this plugin instance. Max length is 255 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> pulumi.Output[builtins.str]:
        """
        Error message describing the failure, if any, during Create, Delete or
        ApplyConfig operation corresponding to the plugin instance.This field will
        only be populated if the plugin instance is in the ERROR or FAILED state.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The unique name of the plugin instance resource.
        Format:
        `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def plugin(self) -> pulumi.Output[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "plugin")

    @property
    @pulumi.getter(name="pluginInstanceId")
    def plugin_instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID to use for the plugin instance, which will become the final
        component of the plugin instance's resource name. This field is optional.
        * If provided, the same will be used. The service will throw an error if
        the specified id is already used by another plugin instance in the plugin
        resource.
        * If not provided, a system generated id will be used.
        This value should be 4-63 characters, and valid characters
        are /a-z[0-9]-_/.
        """
        return pulumi.get(self, "plugin_instance_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the plugin instance (e.g., enabled, disabled,
        provisioning).
        Possible values:
        STATE_UNSPECIFIED
        CREATING
        ACTIVE
        APPLYING_CONFIG
        ERROR
        FAILED
        DELETING
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp indicating when the plugin instance was last updated.
        """
        return pulumi.get(self, "update_time")

