# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StandardAppVersionArgs', 'StandardAppVersion']

@pulumi.input_type
class StandardAppVersionArgs:
    def __init__(__self__, *,
                 deployment: pulumi.Input['StandardAppVersionDeploymentArgs'],
                 entrypoint: pulumi.Input['StandardAppVersionEntrypointArgs'],
                 runtime: pulumi.Input[builtins.str],
                 service: pulumi.Input[builtins.str],
                 app_engine_apis: Optional[pulumi.Input[builtins.bool]] = None,
                 automatic_scaling: Optional[pulumi.Input['StandardAppVersionAutomaticScalingArgs']] = None,
                 basic_scaling: Optional[pulumi.Input['StandardAppVersionBasicScalingArgs']] = None,
                 delete_service_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 env_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 handlers: Optional[pulumi.Input[Sequence[pulumi.Input['StandardAppVersionHandlerArgs']]]] = None,
                 inbound_services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 instance_class: Optional[pulumi.Input[builtins.str]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input['StandardAppVersionLibraryArgs']]]] = None,
                 manual_scaling: Optional[pulumi.Input['StandardAppVersionManualScalingArgs']] = None,
                 noop_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_api_version: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 threadsafe: Optional[pulumi.Input[builtins.bool]] = None,
                 version_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_access_connector: Optional[pulumi.Input['StandardAppVersionVpcAccessConnectorArgs']] = None):
        """
        The set of arguments for constructing a StandardAppVersion resource.
        :param pulumi.Input['StandardAppVersionDeploymentArgs'] deployment: Code and application artifacts that make up this version.
               Structure is documented below.
        :param pulumi.Input['StandardAppVersionEntrypointArgs'] entrypoint: The entrypoint for the application.
               Structure is documented below.
        :param pulumi.Input[builtins.str] runtime: Desired runtime. Example python27.
        :param pulumi.Input[builtins.str] service: AppEngine service resource
        :param pulumi.Input[builtins.bool] app_engine_apis: Allows App Engine second generation runtimes to access the legacy bundled services.
        :param pulumi.Input['StandardAppVersionAutomaticScalingArgs'] automatic_scaling: Automatic scaling is based on request rate, response latencies, and other application metrics.
        :param pulumi.Input['StandardAppVersionBasicScalingArgs'] basic_scaling: Basic scaling creates instances when your application receives requests. Each instance will be shut down when the
               application becomes idle. Basic scaling is ideal for work that is intermittent or driven by user activity.
        :param pulumi.Input[builtins.bool] delete_service_on_destroy: If set to 'true', the service will be deleted if it is the last version.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] env_variables: Environment variables available to the application.
        :param pulumi.Input[Sequence[pulumi.Input['StandardAppVersionHandlerArgs']]] handlers: An ordered list of URL-matching patterns that should be applied to incoming requests. The first matching URL handles the
               request and other request handlers are not attempted.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] inbound_services: A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL",
               "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE",
               "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE",
               "INBOUND_SERVICE_WARMUP"]
        :param pulumi.Input[builtins.str] instance_class: Instance class that is used to run this version. Valid values are AutomaticScaling: F1, F2, F4, F4_1G BasicScaling or
               ManualScaling: B1, B2, B4, B4_1G, B8 Defaults to F1 for AutomaticScaling and B2 for ManualScaling and BasicScaling. If
               no scaling is specified, AutomaticScaling is chosen.
        :param pulumi.Input[Sequence[pulumi.Input['StandardAppVersionLibraryArgs']]] libraries: Configuration for third-party Python runtime libraries that are required by the application.
        :param pulumi.Input['StandardAppVersionManualScalingArgs'] manual_scaling: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of
               its memory over time.
        :param pulumi.Input[builtins.bool] noop_on_destroy: If set to 'true', the application version will not be deleted.
        :param pulumi.Input[builtins.str] runtime_api_version: The version of the API in the given runtime environment. Please see the app.yaml reference for valid values at
               'https://cloud.google.com/appengine/docs/standard/<language>/config/appref'\\ Substitute '<language>' with 'python',
               'java', 'php', 'ruby', 'go' or 'nodejs'.
        :param pulumi.Input[builtins.str] service_account: The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as default
               if this field is neither provided in app.yaml file nor through CLI flag.
        :param pulumi.Input[builtins.bool] threadsafe: Whether multiple requests can be dispatched to this version at once.
        :param pulumi.Input[builtins.str] version_id: Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters,
               numbers, or hyphens. Reserved names,"default", "latest", and any name with the prefix "ah-".
        :param pulumi.Input['StandardAppVersionVpcAccessConnectorArgs'] vpc_access_connector: Enables VPC connectivity for standard apps.
        """
        pulumi.set(__self__, "deployment", deployment)
        pulumi.set(__self__, "entrypoint", entrypoint)
        pulumi.set(__self__, "runtime", runtime)
        pulumi.set(__self__, "service", service)
        if app_engine_apis is not None:
            pulumi.set(__self__, "app_engine_apis", app_engine_apis)
        if automatic_scaling is not None:
            pulumi.set(__self__, "automatic_scaling", automatic_scaling)
        if basic_scaling is not None:
            pulumi.set(__self__, "basic_scaling", basic_scaling)
        if delete_service_on_destroy is not None:
            pulumi.set(__self__, "delete_service_on_destroy", delete_service_on_destroy)
        if env_variables is not None:
            pulumi.set(__self__, "env_variables", env_variables)
        if handlers is not None:
            pulumi.set(__self__, "handlers", handlers)
        if inbound_services is not None:
            pulumi.set(__self__, "inbound_services", inbound_services)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if libraries is not None:
            pulumi.set(__self__, "libraries", libraries)
        if manual_scaling is not None:
            pulumi.set(__self__, "manual_scaling", manual_scaling)
        if noop_on_destroy is not None:
            pulumi.set(__self__, "noop_on_destroy", noop_on_destroy)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if runtime_api_version is not None:
            pulumi.set(__self__, "runtime_api_version", runtime_api_version)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if threadsafe is not None:
            pulumi.set(__self__, "threadsafe", threadsafe)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if vpc_access_connector is not None:
            pulumi.set(__self__, "vpc_access_connector", vpc_access_connector)

    @property
    @pulumi.getter
    def deployment(self) -> pulumi.Input['StandardAppVersionDeploymentArgs']:
        """
        Code and application artifacts that make up this version.
        Structure is documented below.
        """
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: pulumi.Input['StandardAppVersionDeploymentArgs']):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter
    def entrypoint(self) -> pulumi.Input['StandardAppVersionEntrypointArgs']:
        """
        The entrypoint for the application.
        Structure is documented below.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: pulumi.Input['StandardAppVersionEntrypointArgs']):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[builtins.str]:
        """
        Desired runtime. Example python27.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[builtins.str]:
        """
        AppEngine service resource
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="appEngineApis")
    def app_engine_apis(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows App Engine second generation runtimes to access the legacy bundled services.
        """
        return pulumi.get(self, "app_engine_apis")

    @app_engine_apis.setter
    def app_engine_apis(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "app_engine_apis", value)

    @property
    @pulumi.getter(name="automaticScaling")
    def automatic_scaling(self) -> Optional[pulumi.Input['StandardAppVersionAutomaticScalingArgs']]:
        """
        Automatic scaling is based on request rate, response latencies, and other application metrics.
        """
        return pulumi.get(self, "automatic_scaling")

    @automatic_scaling.setter
    def automatic_scaling(self, value: Optional[pulumi.Input['StandardAppVersionAutomaticScalingArgs']]):
        pulumi.set(self, "automatic_scaling", value)

    @property
    @pulumi.getter(name="basicScaling")
    def basic_scaling(self) -> Optional[pulumi.Input['StandardAppVersionBasicScalingArgs']]:
        """
        Basic scaling creates instances when your application receives requests. Each instance will be shut down when the
        application becomes idle. Basic scaling is ideal for work that is intermittent or driven by user activity.
        """
        return pulumi.get(self, "basic_scaling")

    @basic_scaling.setter
    def basic_scaling(self, value: Optional[pulumi.Input['StandardAppVersionBasicScalingArgs']]):
        pulumi.set(self, "basic_scaling", value)

    @property
    @pulumi.getter(name="deleteServiceOnDestroy")
    def delete_service_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to 'true', the service will be deleted if it is the last version.
        """
        return pulumi.get(self, "delete_service_on_destroy")

    @delete_service_on_destroy.setter
    def delete_service_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_service_on_destroy", value)

    @property
    @pulumi.getter(name="envVariables")
    def env_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Environment variables available to the application.
        """
        return pulumi.get(self, "env_variables")

    @env_variables.setter
    def env_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "env_variables", value)

    @property
    @pulumi.getter
    def handlers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StandardAppVersionHandlerArgs']]]]:
        """
        An ordered list of URL-matching patterns that should be applied to incoming requests. The first matching URL handles the
        request and other request handlers are not attempted.
        """
        return pulumi.get(self, "handlers")

    @handlers.setter
    def handlers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StandardAppVersionHandlerArgs']]]]):
        pulumi.set(self, "handlers", value)

    @property
    @pulumi.getter(name="inboundServices")
    def inbound_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL",
        "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE",
        "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE",
        "INBOUND_SERVICE_WARMUP"]
        """
        return pulumi.get(self, "inbound_services")

    @inbound_services.setter
    def inbound_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "inbound_services", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Instance class that is used to run this version. Valid values are AutomaticScaling: F1, F2, F4, F4_1G BasicScaling or
        ManualScaling: B1, B2, B4, B4_1G, B8 Defaults to F1 for AutomaticScaling and B2 for ManualScaling and BasicScaling. If
        no scaling is specified, AutomaticScaling is chosen.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter
    def libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StandardAppVersionLibraryArgs']]]]:
        """
        Configuration for third-party Python runtime libraries that are required by the application.
        """
        return pulumi.get(self, "libraries")

    @libraries.setter
    def libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StandardAppVersionLibraryArgs']]]]):
        pulumi.set(self, "libraries", value)

    @property
    @pulumi.getter(name="manualScaling")
    def manual_scaling(self) -> Optional[pulumi.Input['StandardAppVersionManualScalingArgs']]:
        """
        A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of
        its memory over time.
        """
        return pulumi.get(self, "manual_scaling")

    @manual_scaling.setter
    def manual_scaling(self, value: Optional[pulumi.Input['StandardAppVersionManualScalingArgs']]):
        pulumi.set(self, "manual_scaling", value)

    @property
    @pulumi.getter(name="noopOnDestroy")
    def noop_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to 'true', the application version will not be deleted.
        """
        return pulumi.get(self, "noop_on_destroy")

    @noop_on_destroy.setter
    def noop_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "noop_on_destroy", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="runtimeApiVersion")
    def runtime_api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the API in the given runtime environment. Please see the app.yaml reference for valid values at
        'https://cloud.google.com/appengine/docs/standard/<language>/config/appref'\\ Substitute '<language>' with 'python',
        'java', 'php', 'ruby', 'go' or 'nodejs'.
        """
        return pulumi.get(self, "runtime_api_version")

    @runtime_api_version.setter
    def runtime_api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runtime_api_version", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as default
        if this field is neither provided in app.yaml file nor through CLI flag.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def threadsafe(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether multiple requests can be dispatched to this version at once.
        """
        return pulumi.get(self, "threadsafe")

    @threadsafe.setter
    def threadsafe(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "threadsafe", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters,
        numbers, or hyphens. Reserved names,"default", "latest", and any name with the prefix "ah-".
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_id", value)

    @property
    @pulumi.getter(name="vpcAccessConnector")
    def vpc_access_connector(self) -> Optional[pulumi.Input['StandardAppVersionVpcAccessConnectorArgs']]:
        """
        Enables VPC connectivity for standard apps.
        """
        return pulumi.get(self, "vpc_access_connector")

    @vpc_access_connector.setter
    def vpc_access_connector(self, value: Optional[pulumi.Input['StandardAppVersionVpcAccessConnectorArgs']]):
        pulumi.set(self, "vpc_access_connector", value)


@pulumi.input_type
class _StandardAppVersionState:
    def __init__(__self__, *,
                 app_engine_apis: Optional[pulumi.Input[builtins.bool]] = None,
                 automatic_scaling: Optional[pulumi.Input['StandardAppVersionAutomaticScalingArgs']] = None,
                 basic_scaling: Optional[pulumi.Input['StandardAppVersionBasicScalingArgs']] = None,
                 delete_service_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 deployment: Optional[pulumi.Input['StandardAppVersionDeploymentArgs']] = None,
                 entrypoint: Optional[pulumi.Input['StandardAppVersionEntrypointArgs']] = None,
                 env_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 handlers: Optional[pulumi.Input[Sequence[pulumi.Input['StandardAppVersionHandlerArgs']]]] = None,
                 inbound_services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 instance_class: Optional[pulumi.Input[builtins.str]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input['StandardAppVersionLibraryArgs']]]] = None,
                 manual_scaling: Optional[pulumi.Input['StandardAppVersionManualScalingArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 noop_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 runtime: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_api_version: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 threadsafe: Optional[pulumi.Input[builtins.bool]] = None,
                 version_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_access_connector: Optional[pulumi.Input['StandardAppVersionVpcAccessConnectorArgs']] = None):
        """
        Input properties used for looking up and filtering StandardAppVersion resources.
        :param pulumi.Input[builtins.bool] app_engine_apis: Allows App Engine second generation runtimes to access the legacy bundled services.
        :param pulumi.Input['StandardAppVersionAutomaticScalingArgs'] automatic_scaling: Automatic scaling is based on request rate, response latencies, and other application metrics.
        :param pulumi.Input['StandardAppVersionBasicScalingArgs'] basic_scaling: Basic scaling creates instances when your application receives requests. Each instance will be shut down when the
               application becomes idle. Basic scaling is ideal for work that is intermittent or driven by user activity.
        :param pulumi.Input[builtins.bool] delete_service_on_destroy: If set to 'true', the service will be deleted if it is the last version.
        :param pulumi.Input['StandardAppVersionDeploymentArgs'] deployment: Code and application artifacts that make up this version.
               Structure is documented below.
        :param pulumi.Input['StandardAppVersionEntrypointArgs'] entrypoint: The entrypoint for the application.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] env_variables: Environment variables available to the application.
        :param pulumi.Input[Sequence[pulumi.Input['StandardAppVersionHandlerArgs']]] handlers: An ordered list of URL-matching patterns that should be applied to incoming requests. The first matching URL handles the
               request and other request handlers are not attempted.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] inbound_services: A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL",
               "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE",
               "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE",
               "INBOUND_SERVICE_WARMUP"]
        :param pulumi.Input[builtins.str] instance_class: Instance class that is used to run this version. Valid values are AutomaticScaling: F1, F2, F4, F4_1G BasicScaling or
               ManualScaling: B1, B2, B4, B4_1G, B8 Defaults to F1 for AutomaticScaling and B2 for ManualScaling and BasicScaling. If
               no scaling is specified, AutomaticScaling is chosen.
        :param pulumi.Input[Sequence[pulumi.Input['StandardAppVersionLibraryArgs']]] libraries: Configuration for third-party Python runtime libraries that are required by the application.
        :param pulumi.Input['StandardAppVersionManualScalingArgs'] manual_scaling: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of
               its memory over time.
        :param pulumi.Input[builtins.str] name: Full path to the Version resource in the API. Example, "v1".
        :param pulumi.Input[builtins.bool] noop_on_destroy: If set to 'true', the application version will not be deleted.
        :param pulumi.Input[builtins.str] runtime: Desired runtime. Example python27.
        :param pulumi.Input[builtins.str] runtime_api_version: The version of the API in the given runtime environment. Please see the app.yaml reference for valid values at
               'https://cloud.google.com/appengine/docs/standard/<language>/config/appref'\\ Substitute '<language>' with 'python',
               'java', 'php', 'ruby', 'go' or 'nodejs'.
        :param pulumi.Input[builtins.str] service: AppEngine service resource
        :param pulumi.Input[builtins.str] service_account: The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as default
               if this field is neither provided in app.yaml file nor through CLI flag.
        :param pulumi.Input[builtins.bool] threadsafe: Whether multiple requests can be dispatched to this version at once.
        :param pulumi.Input[builtins.str] version_id: Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters,
               numbers, or hyphens. Reserved names,"default", "latest", and any name with the prefix "ah-".
        :param pulumi.Input['StandardAppVersionVpcAccessConnectorArgs'] vpc_access_connector: Enables VPC connectivity for standard apps.
        """
        if app_engine_apis is not None:
            pulumi.set(__self__, "app_engine_apis", app_engine_apis)
        if automatic_scaling is not None:
            pulumi.set(__self__, "automatic_scaling", automatic_scaling)
        if basic_scaling is not None:
            pulumi.set(__self__, "basic_scaling", basic_scaling)
        if delete_service_on_destroy is not None:
            pulumi.set(__self__, "delete_service_on_destroy", delete_service_on_destroy)
        if deployment is not None:
            pulumi.set(__self__, "deployment", deployment)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if env_variables is not None:
            pulumi.set(__self__, "env_variables", env_variables)
        if handlers is not None:
            pulumi.set(__self__, "handlers", handlers)
        if inbound_services is not None:
            pulumi.set(__self__, "inbound_services", inbound_services)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if libraries is not None:
            pulumi.set(__self__, "libraries", libraries)
        if manual_scaling is not None:
            pulumi.set(__self__, "manual_scaling", manual_scaling)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if noop_on_destroy is not None:
            pulumi.set(__self__, "noop_on_destroy", noop_on_destroy)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if runtime_api_version is not None:
            pulumi.set(__self__, "runtime_api_version", runtime_api_version)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if threadsafe is not None:
            pulumi.set(__self__, "threadsafe", threadsafe)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if vpc_access_connector is not None:
            pulumi.set(__self__, "vpc_access_connector", vpc_access_connector)

    @property
    @pulumi.getter(name="appEngineApis")
    def app_engine_apis(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows App Engine second generation runtimes to access the legacy bundled services.
        """
        return pulumi.get(self, "app_engine_apis")

    @app_engine_apis.setter
    def app_engine_apis(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "app_engine_apis", value)

    @property
    @pulumi.getter(name="automaticScaling")
    def automatic_scaling(self) -> Optional[pulumi.Input['StandardAppVersionAutomaticScalingArgs']]:
        """
        Automatic scaling is based on request rate, response latencies, and other application metrics.
        """
        return pulumi.get(self, "automatic_scaling")

    @automatic_scaling.setter
    def automatic_scaling(self, value: Optional[pulumi.Input['StandardAppVersionAutomaticScalingArgs']]):
        pulumi.set(self, "automatic_scaling", value)

    @property
    @pulumi.getter(name="basicScaling")
    def basic_scaling(self) -> Optional[pulumi.Input['StandardAppVersionBasicScalingArgs']]:
        """
        Basic scaling creates instances when your application receives requests. Each instance will be shut down when the
        application becomes idle. Basic scaling is ideal for work that is intermittent or driven by user activity.
        """
        return pulumi.get(self, "basic_scaling")

    @basic_scaling.setter
    def basic_scaling(self, value: Optional[pulumi.Input['StandardAppVersionBasicScalingArgs']]):
        pulumi.set(self, "basic_scaling", value)

    @property
    @pulumi.getter(name="deleteServiceOnDestroy")
    def delete_service_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to 'true', the service will be deleted if it is the last version.
        """
        return pulumi.get(self, "delete_service_on_destroy")

    @delete_service_on_destroy.setter
    def delete_service_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_service_on_destroy", value)

    @property
    @pulumi.getter
    def deployment(self) -> Optional[pulumi.Input['StandardAppVersionDeploymentArgs']]:
        """
        Code and application artifacts that make up this version.
        Structure is documented below.
        """
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: Optional[pulumi.Input['StandardAppVersionDeploymentArgs']]):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[pulumi.Input['StandardAppVersionEntrypointArgs']]:
        """
        The entrypoint for the application.
        Structure is documented below.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: Optional[pulumi.Input['StandardAppVersionEntrypointArgs']]):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter(name="envVariables")
    def env_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Environment variables available to the application.
        """
        return pulumi.get(self, "env_variables")

    @env_variables.setter
    def env_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "env_variables", value)

    @property
    @pulumi.getter
    def handlers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StandardAppVersionHandlerArgs']]]]:
        """
        An ordered list of URL-matching patterns that should be applied to incoming requests. The first matching URL handles the
        request and other request handlers are not attempted.
        """
        return pulumi.get(self, "handlers")

    @handlers.setter
    def handlers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StandardAppVersionHandlerArgs']]]]):
        pulumi.set(self, "handlers", value)

    @property
    @pulumi.getter(name="inboundServices")
    def inbound_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL",
        "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE",
        "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE",
        "INBOUND_SERVICE_WARMUP"]
        """
        return pulumi.get(self, "inbound_services")

    @inbound_services.setter
    def inbound_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "inbound_services", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Instance class that is used to run this version. Valid values are AutomaticScaling: F1, F2, F4, F4_1G BasicScaling or
        ManualScaling: B1, B2, B4, B4_1G, B8 Defaults to F1 for AutomaticScaling and B2 for ManualScaling and BasicScaling. If
        no scaling is specified, AutomaticScaling is chosen.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter
    def libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StandardAppVersionLibraryArgs']]]]:
        """
        Configuration for third-party Python runtime libraries that are required by the application.
        """
        return pulumi.get(self, "libraries")

    @libraries.setter
    def libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StandardAppVersionLibraryArgs']]]]):
        pulumi.set(self, "libraries", value)

    @property
    @pulumi.getter(name="manualScaling")
    def manual_scaling(self) -> Optional[pulumi.Input['StandardAppVersionManualScalingArgs']]:
        """
        A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of
        its memory over time.
        """
        return pulumi.get(self, "manual_scaling")

    @manual_scaling.setter
    def manual_scaling(self, value: Optional[pulumi.Input['StandardAppVersionManualScalingArgs']]):
        pulumi.set(self, "manual_scaling", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full path to the Version resource in the API. Example, "v1".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="noopOnDestroy")
    def noop_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to 'true', the application version will not be deleted.
        """
        return pulumi.get(self, "noop_on_destroy")

    @noop_on_destroy.setter
    def noop_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "noop_on_destroy", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Desired runtime. Example python27.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="runtimeApiVersion")
    def runtime_api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the API in the given runtime environment. Please see the app.yaml reference for valid values at
        'https://cloud.google.com/appengine/docs/standard/<language>/config/appref'\\ Substitute '<language>' with 'python',
        'java', 'php', 'ruby', 'go' or 'nodejs'.
        """
        return pulumi.get(self, "runtime_api_version")

    @runtime_api_version.setter
    def runtime_api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runtime_api_version", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AppEngine service resource
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as default
        if this field is neither provided in app.yaml file nor through CLI flag.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def threadsafe(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether multiple requests can be dispatched to this version at once.
        """
        return pulumi.get(self, "threadsafe")

    @threadsafe.setter
    def threadsafe(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "threadsafe", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters,
        numbers, or hyphens. Reserved names,"default", "latest", and any name with the prefix "ah-".
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_id", value)

    @property
    @pulumi.getter(name="vpcAccessConnector")
    def vpc_access_connector(self) -> Optional[pulumi.Input['StandardAppVersionVpcAccessConnectorArgs']]:
        """
        Enables VPC connectivity for standard apps.
        """
        return pulumi.get(self, "vpc_access_connector")

    @vpc_access_connector.setter
    def vpc_access_connector(self, value: Optional[pulumi.Input['StandardAppVersionVpcAccessConnectorArgs']]):
        pulumi.set(self, "vpc_access_connector", value)


@pulumi.type_token("gcp:appengine/standardAppVersion:StandardAppVersion")
class StandardAppVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_engine_apis: Optional[pulumi.Input[builtins.bool]] = None,
                 automatic_scaling: Optional[pulumi.Input[Union['StandardAppVersionAutomaticScalingArgs', 'StandardAppVersionAutomaticScalingArgsDict']]] = None,
                 basic_scaling: Optional[pulumi.Input[Union['StandardAppVersionBasicScalingArgs', 'StandardAppVersionBasicScalingArgsDict']]] = None,
                 delete_service_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 deployment: Optional[pulumi.Input[Union['StandardAppVersionDeploymentArgs', 'StandardAppVersionDeploymentArgsDict']]] = None,
                 entrypoint: Optional[pulumi.Input[Union['StandardAppVersionEntrypointArgs', 'StandardAppVersionEntrypointArgsDict']]] = None,
                 env_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 handlers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StandardAppVersionHandlerArgs', 'StandardAppVersionHandlerArgsDict']]]]] = None,
                 inbound_services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 instance_class: Optional[pulumi.Input[builtins.str]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StandardAppVersionLibraryArgs', 'StandardAppVersionLibraryArgsDict']]]]] = None,
                 manual_scaling: Optional[pulumi.Input[Union['StandardAppVersionManualScalingArgs', 'StandardAppVersionManualScalingArgsDict']]] = None,
                 noop_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 runtime: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_api_version: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 threadsafe: Optional[pulumi.Input[builtins.bool]] = None,
                 version_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_access_connector: Optional[pulumi.Input[Union['StandardAppVersionVpcAccessConnectorArgs', 'StandardAppVersionVpcAccessConnectorArgsDict']]] = None,
                 __props__=None):
        """
        Standard App Version resource to create a new version of standard GAE Application.
        Learn about the differences between the standard environment and the flexible environment
        at https://cloud.google.com/appengine/docs/the-appengine-environments.
        Currently supporting Zip and File Containers.

        To get more information about StandardAppVersion, see:

        * [API documentation](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/appengine/docs/standard)

        ## Example Usage

        ### App Engine Standard App Version

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_service_account = gcp.serviceaccount.Account("custom_service_account",
            account_id="my-account",
            display_name="Custom Service Account")
        gae_api = gcp.projects.IAMMember("gae_api",
            project=custom_service_account.project,
            role="roles/compute.networkUser",
            member=custom_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        storage_viewer = gcp.projects.IAMMember("storage_viewer",
            project=custom_service_account.project,
            role="roles/storage.objectViewer",
            member=custom_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        bucket = gcp.storage.Bucket("bucket",
            name="appengine-static-content",
            location="US")
        object = gcp.storage.BucketObject("object",
            name="hello-world.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("./test-fixtures/hello-world.zip"))
        myapp_v1 = gcp.appengine.StandardAppVersion("myapp_v1",
            version_id="v1",
            service="myapp",
            runtime="nodejs20",
            entrypoint={
                "shell": "node ./app.js",
            },
            deployment={
                "zip": {
                    "source_url": pulumi.Output.all(
                        bucketName=bucket.name,
                        objectName=object.name
        ).apply(lambda resolved_outputs: f"https://storage.googleapis.com/{resolved_outputs['bucketName']}/{resolved_outputs['objectName']}")
        ,
                },
            },
            env_variables={
                "port": "8080",
            },
            automatic_scaling={
                "max_concurrent_requests": 10,
                "min_idle_instances": 1,
                "max_idle_instances": 3,
                "min_pending_latency": "1s",
                "max_pending_latency": "5s",
                "standard_scheduler_settings": {
                    "target_cpu_utilization": 0.5,
                    "target_throughput_utilization": 0.75,
                    "min_instances": 2,
                    "max_instances": 10,
                },
            },
            delete_service_on_destroy=True,
            service_account=custom_service_account.email)
        myapp_v2 = gcp.appengine.StandardAppVersion("myapp_v2",
            version_id="v2",
            service="myapp",
            runtime="nodejs20",
            app_engine_apis=True,
            entrypoint={
                "shell": "node ./app.js",
            },
            deployment={
                "zip": {
                    "source_url": pulumi.Output.all(
                        bucketName=bucket.name,
                        objectName=object.name
        ).apply(lambda resolved_outputs: f"https://storage.googleapis.com/{resolved_outputs['bucketName']}/{resolved_outputs['objectName']}")
        ,
                },
            },
            env_variables={
                "port": "8080",
            },
            basic_scaling={
                "max_instances": 5,
            },
            noop_on_destroy=True,
            service_account=custom_service_account.email)
        ```

        ## Import

        StandardAppVersion can be imported using any of these accepted formats:

        * `apps/{{project}}/services/{{service}}/versions/{{version_id}}`

        * `{{project}}/{{service}}/{{version_id}}`

        * `{{service}}/{{version_id}}`

        When using the `pulumi import` command, StandardAppVersion can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:appengine/standardAppVersion:StandardAppVersion default apps/{{project}}/services/{{service}}/versions/{{version_id}}
        ```

        ```sh
        $ pulumi import gcp:appengine/standardAppVersion:StandardAppVersion default {{project}}/{{service}}/{{version_id}}
        ```

        ```sh
        $ pulumi import gcp:appengine/standardAppVersion:StandardAppVersion default {{service}}/{{version_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] app_engine_apis: Allows App Engine second generation runtimes to access the legacy bundled services.
        :param pulumi.Input[Union['StandardAppVersionAutomaticScalingArgs', 'StandardAppVersionAutomaticScalingArgsDict']] automatic_scaling: Automatic scaling is based on request rate, response latencies, and other application metrics.
        :param pulumi.Input[Union['StandardAppVersionBasicScalingArgs', 'StandardAppVersionBasicScalingArgsDict']] basic_scaling: Basic scaling creates instances when your application receives requests. Each instance will be shut down when the
               application becomes idle. Basic scaling is ideal for work that is intermittent or driven by user activity.
        :param pulumi.Input[builtins.bool] delete_service_on_destroy: If set to 'true', the service will be deleted if it is the last version.
        :param pulumi.Input[Union['StandardAppVersionDeploymentArgs', 'StandardAppVersionDeploymentArgsDict']] deployment: Code and application artifacts that make up this version.
               Structure is documented below.
        :param pulumi.Input[Union['StandardAppVersionEntrypointArgs', 'StandardAppVersionEntrypointArgsDict']] entrypoint: The entrypoint for the application.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] env_variables: Environment variables available to the application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StandardAppVersionHandlerArgs', 'StandardAppVersionHandlerArgsDict']]]] handlers: An ordered list of URL-matching patterns that should be applied to incoming requests. The first matching URL handles the
               request and other request handlers are not attempted.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] inbound_services: A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL",
               "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE",
               "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE",
               "INBOUND_SERVICE_WARMUP"]
        :param pulumi.Input[builtins.str] instance_class: Instance class that is used to run this version. Valid values are AutomaticScaling: F1, F2, F4, F4_1G BasicScaling or
               ManualScaling: B1, B2, B4, B4_1G, B8 Defaults to F1 for AutomaticScaling and B2 for ManualScaling and BasicScaling. If
               no scaling is specified, AutomaticScaling is chosen.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StandardAppVersionLibraryArgs', 'StandardAppVersionLibraryArgsDict']]]] libraries: Configuration for third-party Python runtime libraries that are required by the application.
        :param pulumi.Input[Union['StandardAppVersionManualScalingArgs', 'StandardAppVersionManualScalingArgsDict']] manual_scaling: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of
               its memory over time.
        :param pulumi.Input[builtins.bool] noop_on_destroy: If set to 'true', the application version will not be deleted.
        :param pulumi.Input[builtins.str] runtime: Desired runtime. Example python27.
        :param pulumi.Input[builtins.str] runtime_api_version: The version of the API in the given runtime environment. Please see the app.yaml reference for valid values at
               'https://cloud.google.com/appengine/docs/standard/<language>/config/appref'\\ Substitute '<language>' with 'python',
               'java', 'php', 'ruby', 'go' or 'nodejs'.
        :param pulumi.Input[builtins.str] service: AppEngine service resource
        :param pulumi.Input[builtins.str] service_account: The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as default
               if this field is neither provided in app.yaml file nor through CLI flag.
        :param pulumi.Input[builtins.bool] threadsafe: Whether multiple requests can be dispatched to this version at once.
        :param pulumi.Input[builtins.str] version_id: Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters,
               numbers, or hyphens. Reserved names,"default", "latest", and any name with the prefix "ah-".
        :param pulumi.Input[Union['StandardAppVersionVpcAccessConnectorArgs', 'StandardAppVersionVpcAccessConnectorArgsDict']] vpc_access_connector: Enables VPC connectivity for standard apps.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StandardAppVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Standard App Version resource to create a new version of standard GAE Application.
        Learn about the differences between the standard environment and the flexible environment
        at https://cloud.google.com/appengine/docs/the-appengine-environments.
        Currently supporting Zip and File Containers.

        To get more information about StandardAppVersion, see:

        * [API documentation](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/appengine/docs/standard)

        ## Example Usage

        ### App Engine Standard App Version

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_service_account = gcp.serviceaccount.Account("custom_service_account",
            account_id="my-account",
            display_name="Custom Service Account")
        gae_api = gcp.projects.IAMMember("gae_api",
            project=custom_service_account.project,
            role="roles/compute.networkUser",
            member=custom_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        storage_viewer = gcp.projects.IAMMember("storage_viewer",
            project=custom_service_account.project,
            role="roles/storage.objectViewer",
            member=custom_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        bucket = gcp.storage.Bucket("bucket",
            name="appengine-static-content",
            location="US")
        object = gcp.storage.BucketObject("object",
            name="hello-world.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("./test-fixtures/hello-world.zip"))
        myapp_v1 = gcp.appengine.StandardAppVersion("myapp_v1",
            version_id="v1",
            service="myapp",
            runtime="nodejs20",
            entrypoint={
                "shell": "node ./app.js",
            },
            deployment={
                "zip": {
                    "source_url": pulumi.Output.all(
                        bucketName=bucket.name,
                        objectName=object.name
        ).apply(lambda resolved_outputs: f"https://storage.googleapis.com/{resolved_outputs['bucketName']}/{resolved_outputs['objectName']}")
        ,
                },
            },
            env_variables={
                "port": "8080",
            },
            automatic_scaling={
                "max_concurrent_requests": 10,
                "min_idle_instances": 1,
                "max_idle_instances": 3,
                "min_pending_latency": "1s",
                "max_pending_latency": "5s",
                "standard_scheduler_settings": {
                    "target_cpu_utilization": 0.5,
                    "target_throughput_utilization": 0.75,
                    "min_instances": 2,
                    "max_instances": 10,
                },
            },
            delete_service_on_destroy=True,
            service_account=custom_service_account.email)
        myapp_v2 = gcp.appengine.StandardAppVersion("myapp_v2",
            version_id="v2",
            service="myapp",
            runtime="nodejs20",
            app_engine_apis=True,
            entrypoint={
                "shell": "node ./app.js",
            },
            deployment={
                "zip": {
                    "source_url": pulumi.Output.all(
                        bucketName=bucket.name,
                        objectName=object.name
        ).apply(lambda resolved_outputs: f"https://storage.googleapis.com/{resolved_outputs['bucketName']}/{resolved_outputs['objectName']}")
        ,
                },
            },
            env_variables={
                "port": "8080",
            },
            basic_scaling={
                "max_instances": 5,
            },
            noop_on_destroy=True,
            service_account=custom_service_account.email)
        ```

        ## Import

        StandardAppVersion can be imported using any of these accepted formats:

        * `apps/{{project}}/services/{{service}}/versions/{{version_id}}`

        * `{{project}}/{{service}}/{{version_id}}`

        * `{{service}}/{{version_id}}`

        When using the `pulumi import` command, StandardAppVersion can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:appengine/standardAppVersion:StandardAppVersion default apps/{{project}}/services/{{service}}/versions/{{version_id}}
        ```

        ```sh
        $ pulumi import gcp:appengine/standardAppVersion:StandardAppVersion default {{project}}/{{service}}/{{version_id}}
        ```

        ```sh
        $ pulumi import gcp:appengine/standardAppVersion:StandardAppVersion default {{service}}/{{version_id}}
        ```

        :param str resource_name: The name of the resource.
        :param StandardAppVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StandardAppVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_engine_apis: Optional[pulumi.Input[builtins.bool]] = None,
                 automatic_scaling: Optional[pulumi.Input[Union['StandardAppVersionAutomaticScalingArgs', 'StandardAppVersionAutomaticScalingArgsDict']]] = None,
                 basic_scaling: Optional[pulumi.Input[Union['StandardAppVersionBasicScalingArgs', 'StandardAppVersionBasicScalingArgsDict']]] = None,
                 delete_service_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 deployment: Optional[pulumi.Input[Union['StandardAppVersionDeploymentArgs', 'StandardAppVersionDeploymentArgsDict']]] = None,
                 entrypoint: Optional[pulumi.Input[Union['StandardAppVersionEntrypointArgs', 'StandardAppVersionEntrypointArgsDict']]] = None,
                 env_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 handlers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StandardAppVersionHandlerArgs', 'StandardAppVersionHandlerArgsDict']]]]] = None,
                 inbound_services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 instance_class: Optional[pulumi.Input[builtins.str]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StandardAppVersionLibraryArgs', 'StandardAppVersionLibraryArgsDict']]]]] = None,
                 manual_scaling: Optional[pulumi.Input[Union['StandardAppVersionManualScalingArgs', 'StandardAppVersionManualScalingArgsDict']]] = None,
                 noop_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 runtime: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_api_version: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 threadsafe: Optional[pulumi.Input[builtins.bool]] = None,
                 version_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_access_connector: Optional[pulumi.Input[Union['StandardAppVersionVpcAccessConnectorArgs', 'StandardAppVersionVpcAccessConnectorArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StandardAppVersionArgs.__new__(StandardAppVersionArgs)

            __props__.__dict__["app_engine_apis"] = app_engine_apis
            __props__.__dict__["automatic_scaling"] = automatic_scaling
            __props__.__dict__["basic_scaling"] = basic_scaling
            __props__.__dict__["delete_service_on_destroy"] = delete_service_on_destroy
            if deployment is None and not opts.urn:
                raise TypeError("Missing required property 'deployment'")
            __props__.__dict__["deployment"] = deployment
            if entrypoint is None and not opts.urn:
                raise TypeError("Missing required property 'entrypoint'")
            __props__.__dict__["entrypoint"] = entrypoint
            __props__.__dict__["env_variables"] = env_variables
            __props__.__dict__["handlers"] = handlers
            __props__.__dict__["inbound_services"] = inbound_services
            __props__.__dict__["instance_class"] = instance_class
            __props__.__dict__["libraries"] = libraries
            __props__.__dict__["manual_scaling"] = manual_scaling
            __props__.__dict__["noop_on_destroy"] = noop_on_destroy
            __props__.__dict__["project"] = project
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["runtime_api_version"] = runtime_api_version
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["threadsafe"] = threadsafe
            __props__.__dict__["version_id"] = version_id
            __props__.__dict__["vpc_access_connector"] = vpc_access_connector
            __props__.__dict__["name"] = None
        super(StandardAppVersion, __self__).__init__(
            'gcp:appengine/standardAppVersion:StandardAppVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_engine_apis: Optional[pulumi.Input[builtins.bool]] = None,
            automatic_scaling: Optional[pulumi.Input[Union['StandardAppVersionAutomaticScalingArgs', 'StandardAppVersionAutomaticScalingArgsDict']]] = None,
            basic_scaling: Optional[pulumi.Input[Union['StandardAppVersionBasicScalingArgs', 'StandardAppVersionBasicScalingArgsDict']]] = None,
            delete_service_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            deployment: Optional[pulumi.Input[Union['StandardAppVersionDeploymentArgs', 'StandardAppVersionDeploymentArgsDict']]] = None,
            entrypoint: Optional[pulumi.Input[Union['StandardAppVersionEntrypointArgs', 'StandardAppVersionEntrypointArgsDict']]] = None,
            env_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            handlers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StandardAppVersionHandlerArgs', 'StandardAppVersionHandlerArgsDict']]]]] = None,
            inbound_services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            instance_class: Optional[pulumi.Input[builtins.str]] = None,
            libraries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StandardAppVersionLibraryArgs', 'StandardAppVersionLibraryArgsDict']]]]] = None,
            manual_scaling: Optional[pulumi.Input[Union['StandardAppVersionManualScalingArgs', 'StandardAppVersionManualScalingArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            noop_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            runtime: Optional[pulumi.Input[builtins.str]] = None,
            runtime_api_version: Optional[pulumi.Input[builtins.str]] = None,
            service: Optional[pulumi.Input[builtins.str]] = None,
            service_account: Optional[pulumi.Input[builtins.str]] = None,
            threadsafe: Optional[pulumi.Input[builtins.bool]] = None,
            version_id: Optional[pulumi.Input[builtins.str]] = None,
            vpc_access_connector: Optional[pulumi.Input[Union['StandardAppVersionVpcAccessConnectorArgs', 'StandardAppVersionVpcAccessConnectorArgsDict']]] = None) -> 'StandardAppVersion':
        """
        Get an existing StandardAppVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] app_engine_apis: Allows App Engine second generation runtimes to access the legacy bundled services.
        :param pulumi.Input[Union['StandardAppVersionAutomaticScalingArgs', 'StandardAppVersionAutomaticScalingArgsDict']] automatic_scaling: Automatic scaling is based on request rate, response latencies, and other application metrics.
        :param pulumi.Input[Union['StandardAppVersionBasicScalingArgs', 'StandardAppVersionBasicScalingArgsDict']] basic_scaling: Basic scaling creates instances when your application receives requests. Each instance will be shut down when the
               application becomes idle. Basic scaling is ideal for work that is intermittent or driven by user activity.
        :param pulumi.Input[builtins.bool] delete_service_on_destroy: If set to 'true', the service will be deleted if it is the last version.
        :param pulumi.Input[Union['StandardAppVersionDeploymentArgs', 'StandardAppVersionDeploymentArgsDict']] deployment: Code and application artifacts that make up this version.
               Structure is documented below.
        :param pulumi.Input[Union['StandardAppVersionEntrypointArgs', 'StandardAppVersionEntrypointArgsDict']] entrypoint: The entrypoint for the application.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] env_variables: Environment variables available to the application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StandardAppVersionHandlerArgs', 'StandardAppVersionHandlerArgsDict']]]] handlers: An ordered list of URL-matching patterns that should be applied to incoming requests. The first matching URL handles the
               request and other request handlers are not attempted.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] inbound_services: A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL",
               "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE",
               "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE",
               "INBOUND_SERVICE_WARMUP"]
        :param pulumi.Input[builtins.str] instance_class: Instance class that is used to run this version. Valid values are AutomaticScaling: F1, F2, F4, F4_1G BasicScaling or
               ManualScaling: B1, B2, B4, B4_1G, B8 Defaults to F1 for AutomaticScaling and B2 for ManualScaling and BasicScaling. If
               no scaling is specified, AutomaticScaling is chosen.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StandardAppVersionLibraryArgs', 'StandardAppVersionLibraryArgsDict']]]] libraries: Configuration for third-party Python runtime libraries that are required by the application.
        :param pulumi.Input[Union['StandardAppVersionManualScalingArgs', 'StandardAppVersionManualScalingArgsDict']] manual_scaling: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of
               its memory over time.
        :param pulumi.Input[builtins.str] name: Full path to the Version resource in the API. Example, "v1".
        :param pulumi.Input[builtins.bool] noop_on_destroy: If set to 'true', the application version will not be deleted.
        :param pulumi.Input[builtins.str] runtime: Desired runtime. Example python27.
        :param pulumi.Input[builtins.str] runtime_api_version: The version of the API in the given runtime environment. Please see the app.yaml reference for valid values at
               'https://cloud.google.com/appengine/docs/standard/<language>/config/appref'\\ Substitute '<language>' with 'python',
               'java', 'php', 'ruby', 'go' or 'nodejs'.
        :param pulumi.Input[builtins.str] service: AppEngine service resource
        :param pulumi.Input[builtins.str] service_account: The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as default
               if this field is neither provided in app.yaml file nor through CLI flag.
        :param pulumi.Input[builtins.bool] threadsafe: Whether multiple requests can be dispatched to this version at once.
        :param pulumi.Input[builtins.str] version_id: Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters,
               numbers, or hyphens. Reserved names,"default", "latest", and any name with the prefix "ah-".
        :param pulumi.Input[Union['StandardAppVersionVpcAccessConnectorArgs', 'StandardAppVersionVpcAccessConnectorArgsDict']] vpc_access_connector: Enables VPC connectivity for standard apps.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StandardAppVersionState.__new__(_StandardAppVersionState)

        __props__.__dict__["app_engine_apis"] = app_engine_apis
        __props__.__dict__["automatic_scaling"] = automatic_scaling
        __props__.__dict__["basic_scaling"] = basic_scaling
        __props__.__dict__["delete_service_on_destroy"] = delete_service_on_destroy
        __props__.__dict__["deployment"] = deployment
        __props__.__dict__["entrypoint"] = entrypoint
        __props__.__dict__["env_variables"] = env_variables
        __props__.__dict__["handlers"] = handlers
        __props__.__dict__["inbound_services"] = inbound_services
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["libraries"] = libraries
        __props__.__dict__["manual_scaling"] = manual_scaling
        __props__.__dict__["name"] = name
        __props__.__dict__["noop_on_destroy"] = noop_on_destroy
        __props__.__dict__["project"] = project
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["runtime_api_version"] = runtime_api_version
        __props__.__dict__["service"] = service
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["threadsafe"] = threadsafe
        __props__.__dict__["version_id"] = version_id
        __props__.__dict__["vpc_access_connector"] = vpc_access_connector
        return StandardAppVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appEngineApis")
    def app_engine_apis(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Allows App Engine second generation runtimes to access the legacy bundled services.
        """
        return pulumi.get(self, "app_engine_apis")

    @property
    @pulumi.getter(name="automaticScaling")
    def automatic_scaling(self) -> pulumi.Output[Optional['outputs.StandardAppVersionAutomaticScaling']]:
        """
        Automatic scaling is based on request rate, response latencies, and other application metrics.
        """
        return pulumi.get(self, "automatic_scaling")

    @property
    @pulumi.getter(name="basicScaling")
    def basic_scaling(self) -> pulumi.Output[Optional['outputs.StandardAppVersionBasicScaling']]:
        """
        Basic scaling creates instances when your application receives requests. Each instance will be shut down when the
        application becomes idle. Basic scaling is ideal for work that is intermittent or driven by user activity.
        """
        return pulumi.get(self, "basic_scaling")

    @property
    @pulumi.getter(name="deleteServiceOnDestroy")
    def delete_service_on_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set to 'true', the service will be deleted if it is the last version.
        """
        return pulumi.get(self, "delete_service_on_destroy")

    @property
    @pulumi.getter
    def deployment(self) -> pulumi.Output['outputs.StandardAppVersionDeployment']:
        """
        Code and application artifacts that make up this version.
        Structure is documented below.
        """
        return pulumi.get(self, "deployment")

    @property
    @pulumi.getter
    def entrypoint(self) -> pulumi.Output['outputs.StandardAppVersionEntrypoint']:
        """
        The entrypoint for the application.
        Structure is documented below.
        """
        return pulumi.get(self, "entrypoint")

    @property
    @pulumi.getter(name="envVariables")
    def env_variables(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Environment variables available to the application.
        """
        return pulumi.get(self, "env_variables")

    @property
    @pulumi.getter
    def handlers(self) -> pulumi.Output[Sequence['outputs.StandardAppVersionHandler']]:
        """
        An ordered list of URL-matching patterns that should be applied to incoming requests. The first matching URL handles the
        request and other request handlers are not attempted.
        """
        return pulumi.get(self, "handlers")

    @property
    @pulumi.getter(name="inboundServices")
    def inbound_services(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL",
        "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE",
        "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE",
        "INBOUND_SERVICE_WARMUP"]
        """
        return pulumi.get(self, "inbound_services")

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[builtins.str]:
        """
        Instance class that is used to run this version. Valid values are AutomaticScaling: F1, F2, F4, F4_1G BasicScaling or
        ManualScaling: B1, B2, B4, B4_1G, B8 Defaults to F1 for AutomaticScaling and B2 for ManualScaling and BasicScaling. If
        no scaling is specified, AutomaticScaling is chosen.
        """
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter
    def libraries(self) -> pulumi.Output[Optional[Sequence['outputs.StandardAppVersionLibrary']]]:
        """
        Configuration for third-party Python runtime libraries that are required by the application.
        """
        return pulumi.get(self, "libraries")

    @property
    @pulumi.getter(name="manualScaling")
    def manual_scaling(self) -> pulumi.Output[Optional['outputs.StandardAppVersionManualScaling']]:
        """
        A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of
        its memory over time.
        """
        return pulumi.get(self, "manual_scaling")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Full path to the Version resource in the API. Example, "v1".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="noopOnDestroy")
    def noop_on_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set to 'true', the application version will not be deleted.
        """
        return pulumi.get(self, "noop_on_destroy")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[builtins.str]:
        """
        Desired runtime. Example python27.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="runtimeApiVersion")
    def runtime_api_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of the API in the given runtime environment. Please see the app.yaml reference for valid values at
        'https://cloud.google.com/appengine/docs/standard/<language>/config/appref'\\ Substitute '<language>' with 'python',
        'java', 'php', 'ruby', 'go' or 'nodejs'.
        """
        return pulumi.get(self, "runtime_api_version")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[builtins.str]:
        """
        AppEngine service resource
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[builtins.str]:
        """
        The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as default
        if this field is neither provided in app.yaml file nor through CLI flag.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def threadsafe(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether multiple requests can be dispatched to this version at once.
        """
        return pulumi.get(self, "threadsafe")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters,
        numbers, or hyphens. Reserved names,"default", "latest", and any name with the prefix "ah-".
        """
        return pulumi.get(self, "version_id")

    @property
    @pulumi.getter(name="vpcAccessConnector")
    def vpc_access_connector(self) -> pulumi.Output[Optional['outputs.StandardAppVersionVpcAccessConnector']]:
        """
        Enables VPC connectivity for standard apps.
        """
        return pulumi.get(self, "vpc_access_connector")

