# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationAttributes',
    'ApplicationAttributesBusinessOwner',
    'ApplicationAttributesCriticality',
    'ApplicationAttributesDeveloperOwner',
    'ApplicationAttributesEnvironment',
    'ApplicationAttributesOperatorOwner',
    'ApplicationScope',
    'ServiceAttributes',
    'ServiceAttributesBusinessOwner',
    'ServiceAttributesCriticality',
    'ServiceAttributesDeveloperOwner',
    'ServiceAttributesEnvironment',
    'ServiceAttributesOperatorOwner',
    'ServiceServiceProperty',
    'ServiceServiceReference',
    'WorkloadAttributes',
    'WorkloadAttributesBusinessOwner',
    'WorkloadAttributesCriticality',
    'WorkloadAttributesDeveloperOwner',
    'WorkloadAttributesEnvironment',
    'WorkloadAttributesOperatorOwner',
    'WorkloadWorkloadProperty',
    'WorkloadWorkloadReference',
    'GetApplicationAttributeResult',
    'GetApplicationAttributeBusinessOwnerResult',
    'GetApplicationAttributeCriticalityResult',
    'GetApplicationAttributeDeveloperOwnerResult',
    'GetApplicationAttributeEnvironmentResult',
    'GetApplicationAttributeOperatorOwnerResult',
    'GetApplicationScopeResult',
    'GetDiscoveredServiceServicePropertyResult',
    'GetDiscoveredServiceServiceReferenceResult',
    'GetDiscoveredWorkloadWorkloadPropertyResult',
    'GetDiscoveredWorkloadWorkloadReferenceResult',
]

@pulumi.output_type
class ApplicationAttributes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "businessOwners":
            suggest = "business_owners"
        elif key == "developerOwners":
            suggest = "developer_owners"
        elif key == "operatorOwners":
            suggest = "operator_owners"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 business_owners: Optional[Sequence['outputs.ApplicationAttributesBusinessOwner']] = None,
                 criticality: Optional['outputs.ApplicationAttributesCriticality'] = None,
                 developer_owners: Optional[Sequence['outputs.ApplicationAttributesDeveloperOwner']] = None,
                 environment: Optional['outputs.ApplicationAttributesEnvironment'] = None,
                 operator_owners: Optional[Sequence['outputs.ApplicationAttributesOperatorOwner']] = None):
        """
        :param Sequence['ApplicationAttributesBusinessOwnerArgs'] business_owners: Optional. Business team that ensures user needs are met and value is delivered
               Structure is documented below.
        :param 'ApplicationAttributesCriticalityArgs' criticality: Criticality of the Application, Service, or Workload
               Structure is documented below.
        :param Sequence['ApplicationAttributesDeveloperOwnerArgs'] developer_owners: Optional. Developer team that owns development and coding.
               Structure is documented below.
        :param 'ApplicationAttributesEnvironmentArgs' environment: Environment of the Application, Service, or Workload
               Structure is documented below.
        :param Sequence['ApplicationAttributesOperatorOwnerArgs'] operator_owners: Optional. Operator team that ensures runtime and operations.
               Structure is documented below.
        """
        if business_owners is not None:
            pulumi.set(__self__, "business_owners", business_owners)
        if criticality is not None:
            pulumi.set(__self__, "criticality", criticality)
        if developer_owners is not None:
            pulumi.set(__self__, "developer_owners", developer_owners)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if operator_owners is not None:
            pulumi.set(__self__, "operator_owners", operator_owners)

    @property
    @pulumi.getter(name="businessOwners")
    def business_owners(self) -> Optional[Sequence['outputs.ApplicationAttributesBusinessOwner']]:
        """
        Optional. Business team that ensures user needs are met and value is delivered
        Structure is documented below.
        """
        return pulumi.get(self, "business_owners")

    @property
    @pulumi.getter
    def criticality(self) -> Optional['outputs.ApplicationAttributesCriticality']:
        """
        Criticality of the Application, Service, or Workload
        Structure is documented below.
        """
        return pulumi.get(self, "criticality")

    @property
    @pulumi.getter(name="developerOwners")
    def developer_owners(self) -> Optional[Sequence['outputs.ApplicationAttributesDeveloperOwner']]:
        """
        Optional. Developer team that owns development and coding.
        Structure is documented below.
        """
        return pulumi.get(self, "developer_owners")

    @property
    @pulumi.getter
    def environment(self) -> Optional['outputs.ApplicationAttributesEnvironment']:
        """
        Environment of the Application, Service, or Workload
        Structure is documented below.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="operatorOwners")
    def operator_owners(self) -> Optional[Sequence['outputs.ApplicationAttributesOperatorOwner']]:
        """
        Optional. Operator team that ensures runtime and operations.
        Structure is documented below.
        """
        return pulumi.get(self, "operator_owners")


@pulumi.output_type
class ApplicationAttributesBusinessOwner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationAttributesBusinessOwner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationAttributesBusinessOwner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationAttributesBusinessOwner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: builtins.str,
                 display_name: Optional[builtins.str] = None):
        """
        :param builtins.str email: Required. Email address of the contacts.
        :param builtins.str display_name: Optional. Contact's name.
        """
        pulumi.set(__self__, "email", email)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Required. Email address of the contacts.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Optional. Contact's name.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class ApplicationAttributesCriticality(dict):
    def __init__(__self__, *,
                 type: builtins.str):
        """
        :param builtins.str type: Criticality type.
               Possible values are: `MISSION_CRITICAL`, `HIGH`, `MEDIUM`, `LOW`.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Criticality type.
        Possible values are: `MISSION_CRITICAL`, `HIGH`, `MEDIUM`, `LOW`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApplicationAttributesDeveloperOwner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationAttributesDeveloperOwner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationAttributesDeveloperOwner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationAttributesDeveloperOwner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: builtins.str,
                 display_name: Optional[builtins.str] = None):
        """
        :param builtins.str email: Required. Email address of the contacts.
        :param builtins.str display_name: Optional. Contact's name.
        """
        pulumi.set(__self__, "email", email)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Required. Email address of the contacts.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Optional. Contact's name.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class ApplicationAttributesEnvironment(dict):
    def __init__(__self__, *,
                 type: builtins.str):
        """
        :param builtins.str type: Environment type.
               Possible values are: `PRODUCTION`, `STAGING`, `TEST`, `DEVELOPMENT`.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Environment type.
        Possible values are: `PRODUCTION`, `STAGING`, `TEST`, `DEVELOPMENT`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApplicationAttributesOperatorOwner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationAttributesOperatorOwner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationAttributesOperatorOwner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationAttributesOperatorOwner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: builtins.str,
                 display_name: Optional[builtins.str] = None):
        """
        :param builtins.str email: Required. Email address of the contacts.
        :param builtins.str display_name: Optional. Contact's name.
        """
        pulumi.set(__self__, "email", email)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Required. Email address of the contacts.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Optional. Contact's name.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class ApplicationScope(dict):
    def __init__(__self__, *,
                 type: builtins.str):
        """
        :param builtins.str type: Required. Scope Type.
               Possible values:
               REGIONAL
               GLOBAL
               Possible values are: `REGIONAL`, `GLOBAL`.
               
               - - -
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Required. Scope Type.
        Possible values:
        REGIONAL
        GLOBAL
        Possible values are: `REGIONAL`, `GLOBAL`.

        - - -
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceAttributes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "businessOwners":
            suggest = "business_owners"
        elif key == "developerOwners":
            suggest = "developer_owners"
        elif key == "operatorOwners":
            suggest = "operator_owners"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 business_owners: Optional[Sequence['outputs.ServiceAttributesBusinessOwner']] = None,
                 criticality: Optional['outputs.ServiceAttributesCriticality'] = None,
                 developer_owners: Optional[Sequence['outputs.ServiceAttributesDeveloperOwner']] = None,
                 environment: Optional['outputs.ServiceAttributesEnvironment'] = None,
                 operator_owners: Optional[Sequence['outputs.ServiceAttributesOperatorOwner']] = None):
        """
        :param Sequence['ServiceAttributesBusinessOwnerArgs'] business_owners: Business team that ensures user needs are met and value is delivered
               Structure is documented below.
        :param 'ServiceAttributesCriticalityArgs' criticality: Criticality of the Application, Service, or Workload
               Structure is documented below.
        :param Sequence['ServiceAttributesDeveloperOwnerArgs'] developer_owners: Developer team that owns development and coding.
               Structure is documented below.
        :param 'ServiceAttributesEnvironmentArgs' environment: Environment of the Application, Service, or Workload
               Structure is documented below.
        :param Sequence['ServiceAttributesOperatorOwnerArgs'] operator_owners: Operator team that ensures runtime and operations.
               Structure is documented below.
        """
        if business_owners is not None:
            pulumi.set(__self__, "business_owners", business_owners)
        if criticality is not None:
            pulumi.set(__self__, "criticality", criticality)
        if developer_owners is not None:
            pulumi.set(__self__, "developer_owners", developer_owners)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if operator_owners is not None:
            pulumi.set(__self__, "operator_owners", operator_owners)

    @property
    @pulumi.getter(name="businessOwners")
    def business_owners(self) -> Optional[Sequence['outputs.ServiceAttributesBusinessOwner']]:
        """
        Business team that ensures user needs are met and value is delivered
        Structure is documented below.
        """
        return pulumi.get(self, "business_owners")

    @property
    @pulumi.getter
    def criticality(self) -> Optional['outputs.ServiceAttributesCriticality']:
        """
        Criticality of the Application, Service, or Workload
        Structure is documented below.
        """
        return pulumi.get(self, "criticality")

    @property
    @pulumi.getter(name="developerOwners")
    def developer_owners(self) -> Optional[Sequence['outputs.ServiceAttributesDeveloperOwner']]:
        """
        Developer team that owns development and coding.
        Structure is documented below.
        """
        return pulumi.get(self, "developer_owners")

    @property
    @pulumi.getter
    def environment(self) -> Optional['outputs.ServiceAttributesEnvironment']:
        """
        Environment of the Application, Service, or Workload
        Structure is documented below.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="operatorOwners")
    def operator_owners(self) -> Optional[Sequence['outputs.ServiceAttributesOperatorOwner']]:
        """
        Operator team that ensures runtime and operations.
        Structure is documented below.
        """
        return pulumi.get(self, "operator_owners")


@pulumi.output_type
class ServiceAttributesBusinessOwner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAttributesBusinessOwner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAttributesBusinessOwner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAttributesBusinessOwner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: builtins.str,
                 display_name: Optional[builtins.str] = None):
        """
        :param builtins.str email: Required. Email address of the contacts.
        :param builtins.str display_name: Contact's name.
        """
        pulumi.set(__self__, "email", email)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Required. Email address of the contacts.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Contact's name.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class ServiceAttributesCriticality(dict):
    def __init__(__self__, *,
                 type: builtins.str):
        """
        :param builtins.str type: Criticality type.
               Possible values are: `MISSION_CRITICAL`, `HIGH`, `MEDIUM`, `LOW`.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Criticality type.
        Possible values are: `MISSION_CRITICAL`, `HIGH`, `MEDIUM`, `LOW`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceAttributesDeveloperOwner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAttributesDeveloperOwner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAttributesDeveloperOwner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAttributesDeveloperOwner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: builtins.str,
                 display_name: Optional[builtins.str] = None):
        """
        :param builtins.str email: Required. Email address of the contacts.
        :param builtins.str display_name: Contact's name.
        """
        pulumi.set(__self__, "email", email)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Required. Email address of the contacts.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Contact's name.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class ServiceAttributesEnvironment(dict):
    def __init__(__self__, *,
                 type: builtins.str):
        """
        :param builtins.str type: Environment type.
               Possible values are: `PRODUCTION`, `STAGING`, `TEST`, `DEVELOPMENT`.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Environment type.
        Possible values are: `PRODUCTION`, `STAGING`, `TEST`, `DEVELOPMENT`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceAttributesOperatorOwner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAttributesOperatorOwner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAttributesOperatorOwner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAttributesOperatorOwner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: builtins.str,
                 display_name: Optional[builtins.str] = None):
        """
        :param builtins.str email: Required. Email address of the contacts.
        :param builtins.str display_name: Contact's name.
        """
        pulumi.set(__self__, "email", email)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Required. Email address of the contacts.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Contact's name.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class ServiceServiceProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcpProject":
            suggest = "gcp_project"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceServiceProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceServiceProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceServiceProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcp_project: Optional[builtins.str] = None,
                 location: Optional[builtins.str] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param builtins.str gcp_project: (Output)
               Output only. The service project identifier that the underlying cloud resource resides in.
        :param builtins.str location: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param builtins.str zone: (Output)
               Output only. The location that the underlying resource resides in if it is zonal, for example, us-west1-a).
        """
        if gcp_project is not None:
            pulumi.set(__self__, "gcp_project", gcp_project)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="gcpProject")
    def gcp_project(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The service project identifier that the underlying cloud resource resides in.
        """
        return pulumi.get(self, "gcp_project")

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The location that the underlying resource resides in if it is zonal, for example, us-west1-a).
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class ServiceServiceReference(dict):
    def __init__(__self__, *,
                 uri: Optional[builtins.str] = None):
        """
        :param builtins.str uri: (Output)
               Output only. The underlying resource URI (For example, URI of Forwarding Rule, URL Map,
               and Backend Service).
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The underlying resource URI (For example, URI of Forwarding Rule, URL Map,
        and Backend Service).
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class WorkloadAttributes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "businessOwners":
            suggest = "business_owners"
        elif key == "developerOwners":
            suggest = "developer_owners"
        elif key == "operatorOwners":
            suggest = "operator_owners"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 business_owners: Optional[Sequence['outputs.WorkloadAttributesBusinessOwner']] = None,
                 criticality: Optional['outputs.WorkloadAttributesCriticality'] = None,
                 developer_owners: Optional[Sequence['outputs.WorkloadAttributesDeveloperOwner']] = None,
                 environment: Optional['outputs.WorkloadAttributesEnvironment'] = None,
                 operator_owners: Optional[Sequence['outputs.WorkloadAttributesOperatorOwner']] = None):
        """
        :param Sequence['WorkloadAttributesBusinessOwnerArgs'] business_owners: Business team that ensures user needs are met and value is delivered
               Structure is documented below.
        :param 'WorkloadAttributesCriticalityArgs' criticality: Criticality of the Application, Service, or Workload
               Structure is documented below.
        :param Sequence['WorkloadAttributesDeveloperOwnerArgs'] developer_owners: Developer team that owns development and coding.
               Structure is documented below.
        :param 'WorkloadAttributesEnvironmentArgs' environment: Environment of the Application, Service, or Workload
               Structure is documented below.
        :param Sequence['WorkloadAttributesOperatorOwnerArgs'] operator_owners: Operator team that ensures runtime and operations.
               Structure is documented below.
        """
        if business_owners is not None:
            pulumi.set(__self__, "business_owners", business_owners)
        if criticality is not None:
            pulumi.set(__self__, "criticality", criticality)
        if developer_owners is not None:
            pulumi.set(__self__, "developer_owners", developer_owners)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if operator_owners is not None:
            pulumi.set(__self__, "operator_owners", operator_owners)

    @property
    @pulumi.getter(name="businessOwners")
    def business_owners(self) -> Optional[Sequence['outputs.WorkloadAttributesBusinessOwner']]:
        """
        Business team that ensures user needs are met and value is delivered
        Structure is documented below.
        """
        return pulumi.get(self, "business_owners")

    @property
    @pulumi.getter
    def criticality(self) -> Optional['outputs.WorkloadAttributesCriticality']:
        """
        Criticality of the Application, Service, or Workload
        Structure is documented below.
        """
        return pulumi.get(self, "criticality")

    @property
    @pulumi.getter(name="developerOwners")
    def developer_owners(self) -> Optional[Sequence['outputs.WorkloadAttributesDeveloperOwner']]:
        """
        Developer team that owns development and coding.
        Structure is documented below.
        """
        return pulumi.get(self, "developer_owners")

    @property
    @pulumi.getter
    def environment(self) -> Optional['outputs.WorkloadAttributesEnvironment']:
        """
        Environment of the Application, Service, or Workload
        Structure is documented below.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="operatorOwners")
    def operator_owners(self) -> Optional[Sequence['outputs.WorkloadAttributesOperatorOwner']]:
        """
        Operator team that ensures runtime and operations.
        Structure is documented below.
        """
        return pulumi.get(self, "operator_owners")


@pulumi.output_type
class WorkloadAttributesBusinessOwner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadAttributesBusinessOwner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadAttributesBusinessOwner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadAttributesBusinessOwner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: builtins.str,
                 display_name: Optional[builtins.str] = None):
        """
        :param builtins.str email: Email address of the contacts.
        :param builtins.str display_name: Contact's name.
        """
        pulumi.set(__self__, "email", email)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Email address of the contacts.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Contact's name.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class WorkloadAttributesCriticality(dict):
    def __init__(__self__, *,
                 type: builtins.str):
        """
        :param builtins.str type: Criticality type.
               Possible values are: `MISSION_CRITICAL`, `HIGH`, `MEDIUM`, `LOW`.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Criticality type.
        Possible values are: `MISSION_CRITICAL`, `HIGH`, `MEDIUM`, `LOW`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WorkloadAttributesDeveloperOwner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadAttributesDeveloperOwner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadAttributesDeveloperOwner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadAttributesDeveloperOwner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: builtins.str,
                 display_name: Optional[builtins.str] = None):
        """
        :param builtins.str email: Email address of the contacts.
        :param builtins.str display_name: Contact's name.
        """
        pulumi.set(__self__, "email", email)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Email address of the contacts.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Contact's name.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class WorkloadAttributesEnvironment(dict):
    def __init__(__self__, *,
                 type: builtins.str):
        """
        :param builtins.str type: Environment type.
               Possible values are: `PRODUCTION`, `STAGING`, `TEST`, `DEVELOPMENT`.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Environment type.
        Possible values are: `PRODUCTION`, `STAGING`, `TEST`, `DEVELOPMENT`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WorkloadAttributesOperatorOwner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadAttributesOperatorOwner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadAttributesOperatorOwner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadAttributesOperatorOwner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: builtins.str,
                 display_name: Optional[builtins.str] = None):
        """
        :param builtins.str email: Email address of the contacts.
        :param builtins.str display_name: Contact's name.
        """
        pulumi.set(__self__, "email", email)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Email address of the contacts.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Contact's name.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class WorkloadWorkloadProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcpProject":
            suggest = "gcp_project"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadWorkloadProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadWorkloadProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadWorkloadProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcp_project: Optional[builtins.str] = None,
                 location: Optional[builtins.str] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param builtins.str gcp_project: (Output)
               Output only. The service project identifier that the underlying cloud resource resides in. Empty for non cloud resources.
        :param builtins.str location: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param builtins.str zone: (Output)
               Output only. The location that the underlying compute resource resides in if it is zonal (e.g us-west1-a).
        """
        if gcp_project is not None:
            pulumi.set(__self__, "gcp_project", gcp_project)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="gcpProject")
    def gcp_project(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The service project identifier that the underlying cloud resource resides in. Empty for non cloud resources.
        """
        return pulumi.get(self, "gcp_project")

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The location that the underlying compute resource resides in if it is zonal (e.g us-west1-a).
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class WorkloadWorkloadReference(dict):
    def __init__(__self__, *,
                 uri: Optional[builtins.str] = None):
        """
        :param builtins.str uri: (Output)
               Output only. The underlying compute resource uri.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The underlying compute resource uri.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetApplicationAttributeResult(dict):
    def __init__(__self__, *,
                 business_owners: Sequence['outputs.GetApplicationAttributeBusinessOwnerResult'],
                 criticalities: Sequence['outputs.GetApplicationAttributeCriticalityResult'],
                 developer_owners: Sequence['outputs.GetApplicationAttributeDeveloperOwnerResult'],
                 environments: Sequence['outputs.GetApplicationAttributeEnvironmentResult'],
                 operator_owners: Sequence['outputs.GetApplicationAttributeOperatorOwnerResult']):
        """
        :param Sequence['GetApplicationAttributeBusinessOwnerArgs'] business_owners: Optional. Business team that ensures user needs are met and value is delivered
        :param Sequence['GetApplicationAttributeCriticalityArgs'] criticalities: Criticality of the Application, Service, or Workload
        :param Sequence['GetApplicationAttributeDeveloperOwnerArgs'] developer_owners: Optional. Developer team that owns development and coding.
        :param Sequence['GetApplicationAttributeEnvironmentArgs'] environments: Environment of the Application, Service, or Workload
        :param Sequence['GetApplicationAttributeOperatorOwnerArgs'] operator_owners: Optional. Operator team that ensures runtime and operations.
        """
        pulumi.set(__self__, "business_owners", business_owners)
        pulumi.set(__self__, "criticalities", criticalities)
        pulumi.set(__self__, "developer_owners", developer_owners)
        pulumi.set(__self__, "environments", environments)
        pulumi.set(__self__, "operator_owners", operator_owners)

    @property
    @pulumi.getter(name="businessOwners")
    def business_owners(self) -> Sequence['outputs.GetApplicationAttributeBusinessOwnerResult']:
        """
        Optional. Business team that ensures user needs are met and value is delivered
        """
        return pulumi.get(self, "business_owners")

    @property
    @pulumi.getter
    def criticalities(self) -> Sequence['outputs.GetApplicationAttributeCriticalityResult']:
        """
        Criticality of the Application, Service, or Workload
        """
        return pulumi.get(self, "criticalities")

    @property
    @pulumi.getter(name="developerOwners")
    def developer_owners(self) -> Sequence['outputs.GetApplicationAttributeDeveloperOwnerResult']:
        """
        Optional. Developer team that owns development and coding.
        """
        return pulumi.get(self, "developer_owners")

    @property
    @pulumi.getter
    def environments(self) -> Sequence['outputs.GetApplicationAttributeEnvironmentResult']:
        """
        Environment of the Application, Service, or Workload
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter(name="operatorOwners")
    def operator_owners(self) -> Sequence['outputs.GetApplicationAttributeOperatorOwnerResult']:
        """
        Optional. Operator team that ensures runtime and operations.
        """
        return pulumi.get(self, "operator_owners")


@pulumi.output_type
class GetApplicationAttributeBusinessOwnerResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 email: builtins.str):
        """
        :param builtins.str display_name: Optional. Contact's name.
        :param builtins.str email: Required. Email address of the contacts.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "email", email)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Optional. Contact's name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Required. Email address of the contacts.
        """
        return pulumi.get(self, "email")


@pulumi.output_type
class GetApplicationAttributeCriticalityResult(dict):
    def __init__(__self__, *,
                 type: builtins.str):
        """
        :param builtins.str type: Criticality type. Possible values: ["MISSION_CRITICAL", "HIGH", "MEDIUM", "LOW"]
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Criticality type. Possible values: ["MISSION_CRITICAL", "HIGH", "MEDIUM", "LOW"]
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetApplicationAttributeDeveloperOwnerResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 email: builtins.str):
        """
        :param builtins.str display_name: Optional. Contact's name.
        :param builtins.str email: Required. Email address of the contacts.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "email", email)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Optional. Contact's name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Required. Email address of the contacts.
        """
        return pulumi.get(self, "email")


@pulumi.output_type
class GetApplicationAttributeEnvironmentResult(dict):
    def __init__(__self__, *,
                 type: builtins.str):
        """
        :param builtins.str type: Environment type. Possible values: ["PRODUCTION", "STAGING", "TEST", "DEVELOPMENT"]
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Environment type. Possible values: ["PRODUCTION", "STAGING", "TEST", "DEVELOPMENT"]
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetApplicationAttributeOperatorOwnerResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 email: builtins.str):
        """
        :param builtins.str display_name: Optional. Contact's name.
        :param builtins.str email: Required. Email address of the contacts.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "email", email)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Optional. Contact's name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Required. Email address of the contacts.
        """
        return pulumi.get(self, "email")


@pulumi.output_type
class GetApplicationScopeResult(dict):
    def __init__(__self__, *,
                 type: builtins.str):
        """
        :param builtins.str type: Required. Scope Type. 
                Possible values:
               REGIONAL
               GLOBAL Possible values: ["REGIONAL", "GLOBAL"]
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Required. Scope Type. 
         Possible values:
        REGIONAL
        GLOBAL Possible values: ["REGIONAL", "GLOBAL"]
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDiscoveredServiceServicePropertyResult(dict):
    def __init__(__self__, *,
                 gcp_project: builtins.str,
                 location: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.str gcp_project: The service project identifier that the underlying cloud resource resides in.
        :param builtins.str location: The location of the discovered service.
        :param builtins.str zone: The location that the underlying resource resides in if it is zonal.
        """
        pulumi.set(__self__, "gcp_project", gcp_project)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="gcpProject")
    def gcp_project(self) -> builtins.str:
        """
        The service project identifier that the underlying cloud resource resides in.
        """
        return pulumi.get(self, "gcp_project")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location of the discovered service.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        The location that the underlying resource resides in if it is zonal.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetDiscoveredServiceServiceReferenceResult(dict):
    def __init__(__self__, *,
                 path: builtins.str,
                 uri: builtins.str):
        """
        :param builtins.str path: Additional path under the resource URI.
        :param builtins.str uri: The underlying resource URI.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Additional path under the resource URI.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        The underlying resource URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetDiscoveredWorkloadWorkloadPropertyResult(dict):
    def __init__(__self__, *,
                 gcp_project: builtins.str,
                 location: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.str gcp_project: The service project identifier that the underlying cloud resource resides in.
        :param builtins.str location: The location of the discovered workload.
        :param builtins.str zone: The location that the underlying resource resides in if it is zonal.
        """
        pulumi.set(__self__, "gcp_project", gcp_project)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="gcpProject")
    def gcp_project(self) -> builtins.str:
        """
        The service project identifier that the underlying cloud resource resides in.
        """
        return pulumi.get(self, "gcp_project")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location of the discovered workload.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        The location that the underlying resource resides in if it is zonal.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetDiscoveredWorkloadWorkloadReferenceResult(dict):
    def __init__(__self__, *,
                 uri: builtins.str):
        """
        :param builtins.str uri: The underlying resource URI.
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        The underlying resource URI.
        """
        return pulumi.get(self, "uri")


