# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AuthConfigClientCertificate',
    'AuthConfigDecryptedCredential',
    'AuthConfigDecryptedCredentialAuthToken',
    'AuthConfigDecryptedCredentialJwt',
    'AuthConfigDecryptedCredentialOauth2AuthorizationCode',
    'AuthConfigDecryptedCredentialOauth2ClientCredentials',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParams',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntry',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKey',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValue',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValue',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValue',
    'AuthConfigDecryptedCredentialOidcToken',
    'AuthConfigDecryptedCredentialServiceAccountCredentials',
    'AuthConfigDecryptedCredentialUsernameAndPassword',
    'ClientCloudKmsConfig',
]

@pulumi.output_type
class AuthConfigClientCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptedPrivateKey":
            suggest = "encrypted_private_key"
        elif key == "sslCertificate":
            suggest = "ssl_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthConfigClientCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthConfigClientCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthConfigClientCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encrypted_private_key: builtins.str,
                 ssl_certificate: builtins.str,
                 passphrase: Optional[builtins.str] = None):
        """
        :param builtins.str encrypted_private_key: The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines.
        :param builtins.str ssl_certificate: The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines.
        :param builtins.str passphrase: 'passphrase' should be left unset if private key is not encrypted.
               Note that 'passphrase' is not the password for web server, but an extra layer of security to protected private key.
        """
        pulumi.set(__self__, "encrypted_private_key", encrypted_private_key)
        pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)

    @property
    @pulumi.getter(name="encryptedPrivateKey")
    def encrypted_private_key(self) -> builtins.str:
        """
        The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines.
        """
        return pulumi.get(self, "encrypted_private_key")

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> builtins.str:
        """
        The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines.
        """
        return pulumi.get(self, "ssl_certificate")

    @property
    @pulumi.getter
    def passphrase(self) -> Optional[builtins.str]:
        """
        'passphrase' should be left unset if private key is not encrypted.
        Note that 'passphrase' is not the password for web server, but an extra layer of security to protected private key.
        """
        return pulumi.get(self, "passphrase")


@pulumi.output_type
class AuthConfigDecryptedCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialType":
            suggest = "credential_type"
        elif key == "authToken":
            suggest = "auth_token"
        elif key == "oauth2AuthorizationCode":
            suggest = "oauth2_authorization_code"
        elif key == "oauth2ClientCredentials":
            suggest = "oauth2_client_credentials"
        elif key == "oidcToken":
            suggest = "oidc_token"
        elif key == "serviceAccountCredentials":
            suggest = "service_account_credentials"
        elif key == "usernameAndPassword":
            suggest = "username_and_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthConfigDecryptedCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthConfigDecryptedCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthConfigDecryptedCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential_type: builtins.str,
                 auth_token: Optional['outputs.AuthConfigDecryptedCredentialAuthToken'] = None,
                 jwt: Optional['outputs.AuthConfigDecryptedCredentialJwt'] = None,
                 oauth2_authorization_code: Optional['outputs.AuthConfigDecryptedCredentialOauth2AuthorizationCode'] = None,
                 oauth2_client_credentials: Optional['outputs.AuthConfigDecryptedCredentialOauth2ClientCredentials'] = None,
                 oidc_token: Optional['outputs.AuthConfigDecryptedCredentialOidcToken'] = None,
                 service_account_credentials: Optional['outputs.AuthConfigDecryptedCredentialServiceAccountCredentials'] = None,
                 username_and_password: Optional['outputs.AuthConfigDecryptedCredentialUsernameAndPassword'] = None):
        """
        :param builtins.str credential_type: Credential type associated with auth configs.
        :param 'AuthConfigDecryptedCredentialAuthTokenArgs' auth_token: Auth token credential.
               Structure is documented below.
        :param 'AuthConfigDecryptedCredentialJwtArgs' jwt: JWT credential.
               Structure is documented below.
        :param 'AuthConfigDecryptedCredentialOauth2AuthorizationCodeArgs' oauth2_authorization_code: OAuth2 authorization code credential.
               Structure is documented below.
        :param 'AuthConfigDecryptedCredentialOauth2ClientCredentialsArgs' oauth2_client_credentials: OAuth2 client credentials.
               Structure is documented below.
        :param 'AuthConfigDecryptedCredentialOidcTokenArgs' oidc_token: Google OIDC ID Token.
               Structure is documented below.
        :param 'AuthConfigDecryptedCredentialServiceAccountCredentialsArgs' service_account_credentials: Service account credential.
               Structure is documented below.
        :param 'AuthConfigDecryptedCredentialUsernameAndPasswordArgs' username_and_password: Username and password credential.
               Structure is documented below.
        """
        pulumi.set(__self__, "credential_type", credential_type)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if jwt is not None:
            pulumi.set(__self__, "jwt", jwt)
        if oauth2_authorization_code is not None:
            pulumi.set(__self__, "oauth2_authorization_code", oauth2_authorization_code)
        if oauth2_client_credentials is not None:
            pulumi.set(__self__, "oauth2_client_credentials", oauth2_client_credentials)
        if oidc_token is not None:
            pulumi.set(__self__, "oidc_token", oidc_token)
        if service_account_credentials is not None:
            pulumi.set(__self__, "service_account_credentials", service_account_credentials)
        if username_and_password is not None:
            pulumi.set(__self__, "username_and_password", username_and_password)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> builtins.str:
        """
        Credential type associated with auth configs.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional['outputs.AuthConfigDecryptedCredentialAuthToken']:
        """
        Auth token credential.
        Structure is documented below.
        """
        return pulumi.get(self, "auth_token")

    @property
    @pulumi.getter
    def jwt(self) -> Optional['outputs.AuthConfigDecryptedCredentialJwt']:
        """
        JWT credential.
        Structure is documented below.
        """
        return pulumi.get(self, "jwt")

    @property
    @pulumi.getter(name="oauth2AuthorizationCode")
    def oauth2_authorization_code(self) -> Optional['outputs.AuthConfigDecryptedCredentialOauth2AuthorizationCode']:
        """
        OAuth2 authorization code credential.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth2_authorization_code")

    @property
    @pulumi.getter(name="oauth2ClientCredentials")
    def oauth2_client_credentials(self) -> Optional['outputs.AuthConfigDecryptedCredentialOauth2ClientCredentials']:
        """
        OAuth2 client credentials.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth2_client_credentials")

    @property
    @pulumi.getter(name="oidcToken")
    def oidc_token(self) -> Optional['outputs.AuthConfigDecryptedCredentialOidcToken']:
        """
        Google OIDC ID Token.
        Structure is documented below.
        """
        return pulumi.get(self, "oidc_token")

    @property
    @pulumi.getter(name="serviceAccountCredentials")
    def service_account_credentials(self) -> Optional['outputs.AuthConfigDecryptedCredentialServiceAccountCredentials']:
        """
        Service account credential.
        Structure is documented below.
        """
        return pulumi.get(self, "service_account_credentials")

    @property
    @pulumi.getter(name="usernameAndPassword")
    def username_and_password(self) -> Optional['outputs.AuthConfigDecryptedCredentialUsernameAndPassword']:
        """
        Username and password credential.
        Structure is documented below.
        """
        return pulumi.get(self, "username_and_password")


@pulumi.output_type
class AuthConfigDecryptedCredentialAuthToken(dict):
    def __init__(__self__, *,
                 token: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str token: The token for the auth type.
        :param builtins.str type: Authentication type, e.g. "Basic", "Bearer", etc.
        """
        if token is not None:
            pulumi.set(__self__, "token", token)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def token(self) -> Optional[builtins.str]:
        """
        The token for the auth type.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Authentication type, e.g. "Basic", "Bearer", etc.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AuthConfigDecryptedCredentialJwt(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jwtHeader":
            suggest = "jwt_header"
        elif key == "jwtPayload":
            suggest = "jwt_payload"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthConfigDecryptedCredentialJwt. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthConfigDecryptedCredentialJwt.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthConfigDecryptedCredentialJwt.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jwt: Optional[builtins.str] = None,
                 jwt_header: Optional[builtins.str] = None,
                 jwt_payload: Optional[builtins.str] = None,
                 secret: Optional[builtins.str] = None):
        """
        :param builtins.str jwt: (Output)
               The token calculated by the header, payload and signature.
        :param builtins.str jwt_header: Identifies which algorithm is used to generate the signature.
        :param builtins.str jwt_payload: Contains a set of claims. The JWT specification defines seven Registered Claim Names which are the standard fields commonly included in tokens. Custom claims are usually also included, depending on the purpose of the token.
        :param builtins.str secret: User's pre-shared secret to sign the token.
        """
        if jwt is not None:
            pulumi.set(__self__, "jwt", jwt)
        if jwt_header is not None:
            pulumi.set(__self__, "jwt_header", jwt_header)
        if jwt_payload is not None:
            pulumi.set(__self__, "jwt_payload", jwt_payload)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def jwt(self) -> Optional[builtins.str]:
        """
        (Output)
        The token calculated by the header, payload and signature.
        """
        return pulumi.get(self, "jwt")

    @property
    @pulumi.getter(name="jwtHeader")
    def jwt_header(self) -> Optional[builtins.str]:
        """
        Identifies which algorithm is used to generate the signature.
        """
        return pulumi.get(self, "jwt_header")

    @property
    @pulumi.getter(name="jwtPayload")
    def jwt_payload(self) -> Optional[builtins.str]:
        """
        Contains a set of claims. The JWT specification defines seven Registered Claim Names which are the standard fields commonly included in tokens. Custom claims are usually also included, depending on the purpose of the token.
        """
        return pulumi.get(self, "jwt_payload")

    @property
    @pulumi.getter
    def secret(self) -> Optional[builtins.str]:
        """
        User's pre-shared secret to sign the token.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class AuthConfigDecryptedCredentialOauth2AuthorizationCode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authEndpoint":
            suggest = "auth_endpoint"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthConfigDecryptedCredentialOauth2AuthorizationCode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthConfigDecryptedCredentialOauth2AuthorizationCode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthConfigDecryptedCredentialOauth2AuthorizationCode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_endpoint: Optional[builtins.str] = None,
                 client_id: Optional[builtins.str] = None,
                 client_secret: Optional[builtins.str] = None,
                 scope: Optional[builtins.str] = None,
                 token_endpoint: Optional[builtins.str] = None):
        """
        :param builtins.str auth_endpoint: The auth url endpoint to send the auth code request to.
        :param builtins.str client_id: The client's id.
        :param builtins.str client_secret: The client's secret.
        :param builtins.str scope: A space-delimited list of requested scope permissions.
        :param builtins.str token_endpoint: The token url endpoint to send the token request to.
        """
        if auth_endpoint is not None:
            pulumi.set(__self__, "auth_endpoint", auth_endpoint)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)

    @property
    @pulumi.getter(name="authEndpoint")
    def auth_endpoint(self) -> Optional[builtins.str]:
        """
        The auth url endpoint to send the auth code request to.
        """
        return pulumi.get(self, "auth_endpoint")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[builtins.str]:
        """
        The client's id.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[builtins.str]:
        """
        The client's secret.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def scope(self) -> Optional[builtins.str]:
        """
        A space-delimited list of requested scope permissions.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[builtins.str]:
        """
        The token url endpoint to send the token request to.
        """
        return pulumi.get(self, "token_endpoint")


@pulumi.output_type
class AuthConfigDecryptedCredentialOauth2ClientCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "requestType":
            suggest = "request_type"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "tokenParams":
            suggest = "token_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthConfigDecryptedCredentialOauth2ClientCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthConfigDecryptedCredentialOauth2ClientCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthConfigDecryptedCredentialOauth2ClientCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[builtins.str] = None,
                 client_secret: Optional[builtins.str] = None,
                 request_type: Optional[builtins.str] = None,
                 scope: Optional[builtins.str] = None,
                 token_endpoint: Optional[builtins.str] = None,
                 token_params: Optional['outputs.AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParams'] = None):
        """
        :param builtins.str client_id: The client's ID.
        :param builtins.str client_secret: The client's secret.
        :param builtins.str request_type: Represent how to pass parameters to fetch access token Possible values: ["REQUEST_TYPE_UNSPECIFIED", "REQUEST_BODY", "QUERY_PARAMETERS", "ENCODED_HEADER"]
        :param builtins.str scope: A space-delimited list of requested scope permissions.
        :param builtins.str token_endpoint: The token endpoint is used by the client to obtain an access token by presenting its authorization grant or refresh token.
        :param 'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsArgs' token_params: Token parameters for the auth request.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if request_type is not None:
            pulumi.set(__self__, "request_type", request_type)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if token_params is not None:
            pulumi.set(__self__, "token_params", token_params)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[builtins.str]:
        """
        The client's ID.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[builtins.str]:
        """
        The client's secret.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="requestType")
    def request_type(self) -> Optional[builtins.str]:
        """
        Represent how to pass parameters to fetch access token Possible values: ["REQUEST_TYPE_UNSPECIFIED", "REQUEST_BODY", "QUERY_PARAMETERS", "ENCODED_HEADER"]
        """
        return pulumi.get(self, "request_type")

    @property
    @pulumi.getter
    def scope(self) -> Optional[builtins.str]:
        """
        A space-delimited list of requested scope permissions.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[builtins.str]:
        """
        The token endpoint is used by the client to obtain an access token by presenting its authorization grant or refresh token.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="tokenParams")
    def token_params(self) -> Optional['outputs.AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParams']:
        """
        Token parameters for the auth request.
        """
        return pulumi.get(self, "token_params")


@pulumi.output_type
class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParams(dict):
    def __init__(__self__, *,
                 entries: Optional[Sequence['outputs.AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntry']] = None):
        """
        :param Sequence['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryArgs'] entries: A list of parameter map entries.
               Structure is documented below.
        """
        if entries is not None:
            pulumi.set(__self__, "entries", entries)

    @property
    @pulumi.getter
    def entries(self) -> Optional[Sequence['outputs.AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntry']]:
        """
        A list of parameter map entries.
        Structure is documented below.
        """
        return pulumi.get(self, "entries")


@pulumi.output_type
class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntry(dict):
    def __init__(__self__, *,
                 key: Optional['outputs.AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKey'] = None,
                 value: Optional['outputs.AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValue'] = None):
        """
        :param 'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyArgs' key: Key of the map entry.
               Structure is documented below.
        :param 'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueArgs' value: Value of the map entry.
               Structure is documented below.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional['outputs.AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKey']:
        """
        Key of the map entry.
        Structure is documented below.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional['outputs.AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValue']:
        """
        Value of the map entry.
        Structure is documented below.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "literalValue":
            suggest = "literal_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 literal_value: Optional['outputs.AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValue'] = None):
        """
        :param 'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValueArgs' literal_value: Passing a literal value
               Structure is documented below.
        """
        if literal_value is not None:
            pulumi.set(__self__, "literal_value", literal_value)

    @property
    @pulumi.getter(name="literalValue")
    def literal_value(self) -> Optional['outputs.AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValue']:
        """
        Passing a literal value
        Structure is documented below.
        """
        return pulumi.get(self, "literal_value")


@pulumi.output_type
class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 string_value: Optional[builtins.str] = None):
        """
        :param builtins.str string_value: String.
        """
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[builtins.str]:
        """
        String.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "literalValue":
            suggest = "literal_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 literal_value: Optional['outputs.AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValue'] = None):
        """
        :param 'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValueArgs' literal_value: Passing a literal value
               Structure is documented below.
        """
        if literal_value is not None:
            pulumi.set(__self__, "literal_value", literal_value)

    @property
    @pulumi.getter(name="literalValue")
    def literal_value(self) -> Optional['outputs.AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValue']:
        """
        Passing a literal value
        Structure is documented below.
        """
        return pulumi.get(self, "literal_value")


@pulumi.output_type
class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 string_value: Optional[builtins.str] = None):
        """
        :param builtins.str string_value: String.
        """
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[builtins.str]:
        """
        String.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class AuthConfigDecryptedCredentialOidcToken(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccountEmail":
            suggest = "service_account_email"
        elif key == "tokenExpireTime":
            suggest = "token_expire_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthConfigDecryptedCredentialOidcToken. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthConfigDecryptedCredentialOidcToken.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthConfigDecryptedCredentialOidcToken.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audience: Optional[builtins.str] = None,
                 service_account_email: Optional[builtins.str] = None,
                 token: Optional[builtins.str] = None,
                 token_expire_time: Optional[builtins.str] = None):
        """
        :param builtins.str audience: Audience to be used when generating OIDC token. The audience claim identifies the recipients that the JWT is intended for.
        :param builtins.str service_account_email: The service account email to be used as the identity for the token.
        :param builtins.str token: (Output)
               ID token obtained for the service account.
        :param builtins.str token_expire_time: (Output)
               The approximate time until the token retrieved is valid.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if token_expire_time is not None:
            pulumi.set(__self__, "token_expire_time", token_expire_time)

    @property
    @pulumi.getter
    def audience(self) -> Optional[builtins.str]:
        """
        Audience to be used when generating OIDC token. The audience claim identifies the recipients that the JWT is intended for.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[builtins.str]:
        """
        The service account email to be used as the identity for the token.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def token(self) -> Optional[builtins.str]:
        """
        (Output)
        ID token obtained for the service account.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="tokenExpireTime")
    def token_expire_time(self) -> Optional[builtins.str]:
        """
        (Output)
        The approximate time until the token retrieved is valid.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "token_expire_time")


@pulumi.output_type
class AuthConfigDecryptedCredentialServiceAccountCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthConfigDecryptedCredentialServiceAccountCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthConfigDecryptedCredentialServiceAccountCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthConfigDecryptedCredentialServiceAccountCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scope: Optional[builtins.str] = None,
                 service_account: Optional[builtins.str] = None):
        """
        :param builtins.str scope: A space-delimited list of requested scope permissions.
        :param builtins.str service_account: Name of the service account that has the permission to make the request.
        """
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter
    def scope(self) -> Optional[builtins.str]:
        """
        A space-delimited list of requested scope permissions.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[builtins.str]:
        """
        Name of the service account that has the permission to make the request.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class AuthConfigDecryptedCredentialUsernameAndPassword(dict):
    def __init__(__self__, *,
                 password: Optional[builtins.str] = None,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str password: Password to be used.
               
               <a name="nested_decrypted_credential_oauth2_authorization_code"></a>The `oauth2_authorization_code` block supports:
        :param builtins.str username: Username to be used.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        Password to be used.

        <a name="nested_decrypted_credential_oauth2_authorization_code"></a>The `oauth2_authorization_code` block supports:
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        Username to be used.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ClientCloudKmsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsLocation":
            suggest = "kms_location"
        elif key == "kmsRing":
            suggest = "kms_ring"
        elif key == "keyVersion":
            suggest = "key_version"
        elif key == "kmsProjectId":
            suggest = "kms_project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientCloudKmsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientCloudKmsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientCloudKmsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: builtins.str,
                 kms_location: builtins.str,
                 kms_ring: builtins.str,
                 key_version: Optional[builtins.str] = None,
                 kms_project_id: Optional[builtins.str] = None):
        """
        :param builtins.str key: A Cloud KMS key is a named object containing one or more key versions, along
               with metadata for the key. A key exists on exactly one key ring tied to a
               specific location.
        :param builtins.str kms_location: Location name of the key ring, e.g. "us-west1".
        :param builtins.str kms_ring: A key ring organizes keys in a specific Google Cloud location and allows you to
               manage access control on groups of keys. A key ring's name does not need to be
               unique across a Google Cloud project, but must be unique within a given location.
        :param builtins.str key_version: Each version of a key contains key material used for encryption or signing.
               A key's version is represented by an integer, starting at 1. To decrypt data
               or verify a signature, you must use the same key version that was used to
               encrypt or sign the data.
        :param builtins.str kms_project_id: The Google Cloud project id of the project where the kms key stored. If empty,
               the kms key is stored at the same project as customer's project and ecrypted
               with CMEK, otherwise, the kms key is stored in the tenant project and
               encrypted with GMEK.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "kms_location", kms_location)
        pulumi.set(__self__, "kms_ring", kms_ring)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)
        if kms_project_id is not None:
            pulumi.set(__self__, "kms_project_id", kms_project_id)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        A Cloud KMS key is a named object containing one or more key versions, along
        with metadata for the key. A key exists on exactly one key ring tied to a
        specific location.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="kmsLocation")
    def kms_location(self) -> builtins.str:
        """
        Location name of the key ring, e.g. "us-west1".
        """
        return pulumi.get(self, "kms_location")

    @property
    @pulumi.getter(name="kmsRing")
    def kms_ring(self) -> builtins.str:
        """
        A key ring organizes keys in a specific Google Cloud location and allows you to
        manage access control on groups of keys. A key ring's name does not need to be
        unique across a Google Cloud project, but must be unique within a given location.
        """
        return pulumi.get(self, "kms_ring")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[builtins.str]:
        """
        Each version of a key contains key material used for encryption or signing.
        A key's version is represented by an integer, starting at 1. To decrypt data
        or verify a signature, you must use the same key version that was used to
        encrypt or sign the data.
        """
        return pulumi.get(self, "key_version")

    @property
    @pulumi.getter(name="kmsProjectId")
    def kms_project_id(self) -> Optional[builtins.str]:
        """
        The Google Cloud project id of the project where the kms key stored. If empty,
        the kms key is stored at the same project as customer's project and ecrypted
        with CMEK, otherwise, the kms key is stored in the tenant project and
        encrypted with GMEK.
        """
        return pulumi.get(self, "kms_project_id")


