# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VpcscConfigArgs', 'VpcscConfig']

@pulumi.input_type
class VpcscConfigArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 vpcsc_policy: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VpcscConfig resource.
        :param pulumi.Input[builtins.str] location: The name of the location this config is located in.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] vpcsc_policy: The VPC SC policy for project and location.
               Possible values are: `DENY`, `ALLOW`.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if vpcsc_policy is not None:
            pulumi.set(__self__, "vpcsc_policy", vpcsc_policy)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the location this config is located in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="vpcscPolicy")
    def vpcsc_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VPC SC policy for project and location.
        Possible values are: `DENY`, `ALLOW`.
        """
        return pulumi.get(self, "vpcsc_policy")

    @vpcsc_policy.setter
    def vpcsc_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpcsc_policy", value)


@pulumi.input_type
class _VpcscConfigState:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 vpcsc_policy: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpcscConfig resources.
        :param pulumi.Input[builtins.str] location: The name of the location this config is located in.
        :param pulumi.Input[builtins.str] name: The name of the project's VPC SC Config.
               Always of the form: projects/{project}/location/{location}/vpcscConfig
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] vpcsc_policy: The VPC SC policy for project and location.
               Possible values are: `DENY`, `ALLOW`.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if vpcsc_policy is not None:
            pulumi.set(__self__, "vpcsc_policy", vpcsc_policy)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the location this config is located in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the project's VPC SC Config.
        Always of the form: projects/{project}/location/{location}/vpcscConfig
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="vpcscPolicy")
    def vpcsc_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VPC SC policy for project and location.
        Possible values are: `DENY`, `ALLOW`.
        """
        return pulumi.get(self, "vpcsc_policy")

    @vpcsc_policy.setter
    def vpcsc_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpcsc_policy", value)


@pulumi.type_token("gcp:artifactregistry/vpcscConfig:VpcscConfig")
class VpcscConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 vpcsc_policy: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Artifact Registry Vpcsc Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_config = gcp.artifactregistry.VpcscConfig("my-config",
            location="us-central1",
            vpcsc_policy="ALLOW")
        ```

        ## Import

        VPCSCConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/vpcscConfig/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, VPCSCConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:artifactregistry/vpcscConfig:VpcscConfig default projects/{{project}}/locations/{{location}}/vpcscConfig/{{name}}
        ```

        ```sh
        $ pulumi import gcp:artifactregistry/vpcscConfig:VpcscConfig default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:artifactregistry/vpcscConfig:VpcscConfig default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: The name of the location this config is located in.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] vpcsc_policy: The VPC SC policy for project and location.
               Possible values are: `DENY`, `ALLOW`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VpcscConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Artifact Registry Vpcsc Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_config = gcp.artifactregistry.VpcscConfig("my-config",
            location="us-central1",
            vpcsc_policy="ALLOW")
        ```

        ## Import

        VPCSCConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/vpcscConfig/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, VPCSCConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:artifactregistry/vpcscConfig:VpcscConfig default projects/{{project}}/locations/{{location}}/vpcscConfig/{{name}}
        ```

        ```sh
        $ pulumi import gcp:artifactregistry/vpcscConfig:VpcscConfig default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:artifactregistry/vpcscConfig:VpcscConfig default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param VpcscConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcscConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 vpcsc_policy: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcscConfigArgs.__new__(VpcscConfigArgs)

            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["vpcsc_policy"] = vpcsc_policy
            __props__.__dict__["name"] = None
        super(VpcscConfig, __self__).__init__(
            'gcp:artifactregistry/vpcscConfig:VpcscConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            vpcsc_policy: Optional[pulumi.Input[builtins.str]] = None) -> 'VpcscConfig':
        """
        Get an existing VpcscConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: The name of the location this config is located in.
        :param pulumi.Input[builtins.str] name: The name of the project's VPC SC Config.
               Always of the form: projects/{project}/location/{location}/vpcscConfig
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] vpcsc_policy: The VPC SC policy for project and location.
               Possible values are: `DENY`, `ALLOW`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcscConfigState.__new__(_VpcscConfigState)

        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["vpcsc_policy"] = vpcsc_policy
        return VpcscConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The name of the location this config is located in.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the project's VPC SC Config.
        Always of the form: projects/{project}/location/{location}/vpcscConfig
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="vpcscPolicy")
    def vpcsc_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The VPC SC policy for project and location.
        Possible values are: `DENY`, `ALLOW`.
        """
        return pulumi.get(self, "vpcsc_policy")

