# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BackupPlanAssociationRulesConfigInfo',
    'BackupPlanAssociationRulesConfigInfoLastBackupError',
    'BackupPlanBackupRule',
    'BackupPlanBackupRuleStandardSchedule',
    'BackupPlanBackupRuleStandardScheduleBackupWindow',
    'BackupPlanBackupRuleStandardScheduleWeekDayOfMonth',
    'ManagementServerManagementUri',
    'ManagementServerNetwork',
    'GetBackupBackupResult',
    'GetBackupPlanAssociationRulesConfigInfoResult',
    'GetBackupPlanAssociationRulesConfigInfoLastBackupErrorResult',
    'GetBackupPlanBackupRuleResult',
    'GetBackupPlanBackupRuleStandardScheduleResult',
    'GetBackupPlanBackupRuleStandardScheduleBackupWindowResult',
    'GetBackupPlanBackupRuleStandardScheduleWeekDayOfMonthResult',
    'GetDataSourceBackupConfigInfoResult',
    'GetDataSourceBackupConfigInfoBackupApplianceBackupConfigResult',
    'GetDataSourceBackupConfigInfoGcpBackupConfigResult',
    'GetDataSourceDataSourceBackupApplianceApplicationResult',
    'GetDataSourceDataSourceGcpResourceResult',
    'GetDataSourceDataSourceGcpResourceComputeInstanceDataSourcePropertyResult',
    'GetManagementServerManagementUriResult',
    'GetManagementServerNetworkResult',
]

@pulumi.output_type
class BackupPlanAssociationRulesConfigInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastBackupErrors":
            suggest = "last_backup_errors"
        elif key == "lastBackupState":
            suggest = "last_backup_state"
        elif key == "ruleId":
            suggest = "rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanAssociationRulesConfigInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanAssociationRulesConfigInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanAssociationRulesConfigInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_backup_errors: Optional[Sequence['outputs.BackupPlanAssociationRulesConfigInfoLastBackupError']] = None,
                 last_backup_state: Optional[builtins.str] = None,
                 rule_id: Optional[builtins.str] = None):
        """
        :param Sequence['BackupPlanAssociationRulesConfigInfoLastBackupErrorArgs'] last_backup_errors: (Output)
               google.rpc.Status object to store the last backup error
               Structure is documented below.
        :param builtins.str last_backup_state: (Output)
               State of last backup taken.
        :param builtins.str rule_id: (Output)
               Backup Rule id fetched from backup plan.
        """
        if last_backup_errors is not None:
            pulumi.set(__self__, "last_backup_errors", last_backup_errors)
        if last_backup_state is not None:
            pulumi.set(__self__, "last_backup_state", last_backup_state)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @property
    @pulumi.getter(name="lastBackupErrors")
    def last_backup_errors(self) -> Optional[Sequence['outputs.BackupPlanAssociationRulesConfigInfoLastBackupError']]:
        """
        (Output)
        google.rpc.Status object to store the last backup error
        Structure is documented below.
        """
        return pulumi.get(self, "last_backup_errors")

    @property
    @pulumi.getter(name="lastBackupState")
    def last_backup_state(self) -> Optional[builtins.str]:
        """
        (Output)
        State of last backup taken.
        """
        return pulumi.get(self, "last_backup_state")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[builtins.str]:
        """
        (Output)
        Backup Rule id fetched from backup plan.
        """
        return pulumi.get(self, "rule_id")


@pulumi.output_type
class BackupPlanAssociationRulesConfigInfoLastBackupError(dict):
    def __init__(__self__, *,
                 code: Optional[builtins.float] = None,
                 message: Optional[builtins.str] = None):
        """
        :param builtins.float code: (Output)
               The status code, which should be an enum value of [google.rpc.Code]
        :param builtins.str message: (Output)
               A developer-facing error message, which should be in English.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.float]:
        """
        (Output)
        The status code, which should be an enum value of [google.rpc.Code]
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        (Output)
        A developer-facing error message, which should be in English.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class BackupPlanBackupRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupRetentionDays":
            suggest = "backup_retention_days"
        elif key == "ruleId":
            suggest = "rule_id"
        elif key == "standardSchedule":
            suggest = "standard_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_retention_days: builtins.int,
                 rule_id: builtins.str,
                 standard_schedule: 'outputs.BackupPlanBackupRuleStandardSchedule'):
        """
        :param builtins.int backup_retention_days: Configures the duration for which backup data will be kept. The value should be greater than or equal to minimum enforced retention of the backup vault.
        :param builtins.str rule_id: The unique ID of this `BackupRule`. The `rule_id` is unique per `BackupPlan`.
        :param 'BackupPlanBackupRuleStandardScheduleArgs' standard_schedule: StandardSchedule defines a schedule that runs within the confines of a defined window of days.
               Structure is documented below.
        """
        pulumi.set(__self__, "backup_retention_days", backup_retention_days)
        pulumi.set(__self__, "rule_id", rule_id)
        pulumi.set(__self__, "standard_schedule", standard_schedule)

    @property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> builtins.int:
        """
        Configures the duration for which backup data will be kept. The value should be greater than or equal to minimum enforced retention of the backup vault.
        """
        return pulumi.get(self, "backup_retention_days")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> builtins.str:
        """
        The unique ID of this `BackupRule`. The `rule_id` is unique per `BackupPlan`.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="standardSchedule")
    def standard_schedule(self) -> 'outputs.BackupPlanBackupRuleStandardSchedule':
        """
        StandardSchedule defines a schedule that runs within the confines of a defined window of days.
        Structure is documented below.
        """
        return pulumi.get(self, "standard_schedule")


@pulumi.output_type
class BackupPlanBackupRuleStandardSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recurrenceType":
            suggest = "recurrence_type"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "backupWindow":
            suggest = "backup_window"
        elif key == "daysOfMonths":
            suggest = "days_of_months"
        elif key == "daysOfWeeks":
            suggest = "days_of_weeks"
        elif key == "hourlyFrequency":
            suggest = "hourly_frequency"
        elif key == "weekDayOfMonth":
            suggest = "week_day_of_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupRuleStandardSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupRuleStandardSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupRuleStandardSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recurrence_type: builtins.str,
                 time_zone: builtins.str,
                 backup_window: Optional['outputs.BackupPlanBackupRuleStandardScheduleBackupWindow'] = None,
                 days_of_months: Optional[Sequence[builtins.int]] = None,
                 days_of_weeks: Optional[Sequence[builtins.str]] = None,
                 hourly_frequency: Optional[builtins.int] = None,
                 months: Optional[Sequence[builtins.str]] = None,
                 week_day_of_month: Optional['outputs.BackupPlanBackupRuleStandardScheduleWeekDayOfMonth'] = None):
        """
        :param builtins.str recurrence_type: RecurrenceType enumerates the applicable periodicity for the schedule.
               Possible values are: `HOURLY`, `DAILY`, `WEEKLY`, `MONTHLY`, `YEARLY`.
        :param builtins.str time_zone: The time zone to be used when interpreting the schedule.
        :param 'BackupPlanBackupRuleStandardScheduleBackupWindowArgs' backup_window: A BackupWindow defines the window of the day during which backup jobs will run. Jobs are queued at the beginning of the window and will be marked as
               `NOT_RUN` if they do not start by the end of the window.
               Structure is documented below.
        :param Sequence[builtins.int] days_of_months: Specifies days of months like 1, 5, or 14 on which jobs will run.
        :param Sequence[builtins.str] days_of_weeks: Specifies days of week like MONDAY or TUESDAY, on which jobs will run. This is required for `recurrence_type`, `WEEKLY` and is not applicable otherwise.
               Each value may be one of: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        :param builtins.int hourly_frequency: Specifies frequency for hourly backups. An hourly frequency of 2 means jobs will run every 2 hours from start time till end time defined.
               This is required for `recurrence_type`, `HOURLY` and is not applicable otherwise.
        :param Sequence[builtins.str] months: Specifies values of months
               Each value may be one of: `MONTH_UNSPECIFIED`, `JANUARY`, `FEBRUARY`, `MARCH`, `APRIL`, `MAY`, `JUNE`, `JULY`, `AUGUST`, `SEPTEMBER`, `OCTOBER`, `NOVEMBER`, `DECEMBER`.
        :param 'BackupPlanBackupRuleStandardScheduleWeekDayOfMonthArgs' week_day_of_month: Specifies a week day of the month like FIRST SUNDAY or LAST MONDAY, on which jobs will run.
               Structure is documented below.
        """
        pulumi.set(__self__, "recurrence_type", recurrence_type)
        pulumi.set(__self__, "time_zone", time_zone)
        if backup_window is not None:
            pulumi.set(__self__, "backup_window", backup_window)
        if days_of_months is not None:
            pulumi.set(__self__, "days_of_months", days_of_months)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        if hourly_frequency is not None:
            pulumi.set(__self__, "hourly_frequency", hourly_frequency)
        if months is not None:
            pulumi.set(__self__, "months", months)
        if week_day_of_month is not None:
            pulumi.set(__self__, "week_day_of_month", week_day_of_month)

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> builtins.str:
        """
        RecurrenceType enumerates the applicable periodicity for the schedule.
        Possible values are: `HOURLY`, `DAILY`, `WEEKLY`, `MONTHLY`, `YEARLY`.
        """
        return pulumi.get(self, "recurrence_type")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        The time zone to be used when interpreting the schedule.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> Optional['outputs.BackupPlanBackupRuleStandardScheduleBackupWindow']:
        """
        A BackupWindow defines the window of the day during which backup jobs will run. Jobs are queued at the beginning of the window and will be marked as
        `NOT_RUN` if they do not start by the end of the window.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_window")

    @property
    @pulumi.getter(name="daysOfMonths")
    def days_of_months(self) -> Optional[Sequence[builtins.int]]:
        """
        Specifies days of months like 1, 5, or 14 on which jobs will run.
        """
        return pulumi.get(self, "days_of_months")

    @property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies days of week like MONDAY or TUESDAY, on which jobs will run. This is required for `recurrence_type`, `WEEKLY` and is not applicable otherwise.
        Each value may be one of: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "days_of_weeks")

    @property
    @pulumi.getter(name="hourlyFrequency")
    def hourly_frequency(self) -> Optional[builtins.int]:
        """
        Specifies frequency for hourly backups. An hourly frequency of 2 means jobs will run every 2 hours from start time till end time defined.
        This is required for `recurrence_type`, `HOURLY` and is not applicable otherwise.
        """
        return pulumi.get(self, "hourly_frequency")

    @property
    @pulumi.getter
    def months(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies values of months
        Each value may be one of: `MONTH_UNSPECIFIED`, `JANUARY`, `FEBRUARY`, `MARCH`, `APRIL`, `MAY`, `JUNE`, `JULY`, `AUGUST`, `SEPTEMBER`, `OCTOBER`, `NOVEMBER`, `DECEMBER`.
        """
        return pulumi.get(self, "months")

    @property
    @pulumi.getter(name="weekDayOfMonth")
    def week_day_of_month(self) -> Optional['outputs.BackupPlanBackupRuleStandardScheduleWeekDayOfMonth']:
        """
        Specifies a week day of the month like FIRST SUNDAY or LAST MONDAY, on which jobs will run.
        Structure is documented below.
        """
        return pulumi.get(self, "week_day_of_month")


@pulumi.output_type
class BackupPlanBackupRuleStandardScheduleBackupWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startHourOfDay":
            suggest = "start_hour_of_day"
        elif key == "endHourOfDay":
            suggest = "end_hour_of_day"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupRuleStandardScheduleBackupWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupRuleStandardScheduleBackupWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupRuleStandardScheduleBackupWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_hour_of_day: builtins.int,
                 end_hour_of_day: Optional[builtins.int] = None):
        """
        :param builtins.int start_hour_of_day: The hour of the day (0-23) when the window starts, for example, if the value of the start hour of the day is 6, that means the backup window starts at 6:00.
        :param builtins.int end_hour_of_day: The hour of the day (1-24) when the window ends, for example, if the value of end hour of the day is 10, that means the backup window end time is 10:00.
               The end hour of the day should be greater than the start
               
               - - -
        """
        pulumi.set(__self__, "start_hour_of_day", start_hour_of_day)
        if end_hour_of_day is not None:
            pulumi.set(__self__, "end_hour_of_day", end_hour_of_day)

    @property
    @pulumi.getter(name="startHourOfDay")
    def start_hour_of_day(self) -> builtins.int:
        """
        The hour of the day (0-23) when the window starts, for example, if the value of the start hour of the day is 6, that means the backup window starts at 6:00.
        """
        return pulumi.get(self, "start_hour_of_day")

    @property
    @pulumi.getter(name="endHourOfDay")
    def end_hour_of_day(self) -> Optional[builtins.int]:
        """
        The hour of the day (1-24) when the window ends, for example, if the value of end hour of the day is 10, that means the backup window end time is 10:00.
        The end hour of the day should be greater than the start

        - - -
        """
        return pulumi.get(self, "end_hour_of_day")


@pulumi.output_type
class BackupPlanBackupRuleStandardScheduleWeekDayOfMonth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "weekOfMonth":
            suggest = "week_of_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupRuleStandardScheduleWeekDayOfMonth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupRuleStandardScheduleWeekDayOfMonth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupRuleStandardScheduleWeekDayOfMonth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: builtins.str,
                 week_of_month: builtins.str):
        """
        :param builtins.str day_of_week: Specifies the day of the week.
               Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        :param builtins.str week_of_month: WeekOfMonth enumerates possible weeks in the month, e.g. the first, third, or last week of the month.
               Possible values are: `WEEK_OF_MONTH_UNSPECIFIED`, `FIRST`, `SECOND`, `THIRD`, `FOURTH`, `LAST`.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "week_of_month", week_of_month)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> builtins.str:
        """
        Specifies the day of the week.
        Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="weekOfMonth")
    def week_of_month(self) -> builtins.str:
        """
        WeekOfMonth enumerates possible weeks in the month, e.g. the first, third, or last week of the month.
        Possible values are: `WEEK_OF_MONTH_UNSPECIFIED`, `FIRST`, `SECOND`, `THIRD`, `FOURTH`, `LAST`.
        """
        return pulumi.get(self, "week_of_month")


@pulumi.output_type
class ManagementServerManagementUri(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "webUi":
            suggest = "web_ui"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementServerManagementUri. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementServerManagementUri.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementServerManagementUri.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api: Optional[builtins.str] = None,
                 web_ui: Optional[builtins.str] = None):
        """
        :param builtins.str api: (Output)
               The management console api endpoint.
        :param builtins.str web_ui: (Output)
               The management console webUi.
        """
        if api is not None:
            pulumi.set(__self__, "api", api)
        if web_ui is not None:
            pulumi.set(__self__, "web_ui", web_ui)

    @property
    @pulumi.getter
    def api(self) -> Optional[builtins.str]:
        """
        (Output)
        The management console api endpoint.
        """
        return pulumi.get(self, "api")

    @property
    @pulumi.getter(name="webUi")
    def web_ui(self) -> Optional[builtins.str]:
        """
        (Output)
        The management console webUi.
        """
        return pulumi.get(self, "web_ui")


@pulumi.output_type
class ManagementServerNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "peeringMode":
            suggest = "peering_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementServerNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementServerNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementServerNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network: builtins.str,
                 peering_mode: Optional[builtins.str] = None):
        """
        :param builtins.str network: Network with format `projects/{{project_id}}/global/networks/{{network_id}}`
        :param builtins.str peering_mode: Type of Network peeringMode
               Default value is `PRIVATE_SERVICE_ACCESS`.
               Possible values are: `PRIVATE_SERVICE_ACCESS`.
        """
        pulumi.set(__self__, "network", network)
        if peering_mode is not None:
            pulumi.set(__self__, "peering_mode", peering_mode)

    @property
    @pulumi.getter
    def network(self) -> builtins.str:
        """
        Network with format `projects/{{project_id}}/global/networks/{{network_id}}`
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="peeringMode")
    def peering_mode(self) -> Optional[builtins.str]:
        """
        Type of Network peeringMode
        Default value is `PRIVATE_SERVICE_ACCESS`.
        Possible values are: `PRIVATE_SERVICE_ACCESS`.
        """
        return pulumi.get(self, "peering_mode")


@pulumi.output_type
class GetBackupBackupResult(dict):
    def __init__(__self__, *,
                 backup_id: builtins.str,
                 backup_vault_id: builtins.str,
                 data_source_id: builtins.str,
                 location: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str backup_id: Id of the requesting object, Backup.
        :param builtins.str backup_vault_id: The ID of the Backup Vault of the Data Source in which the Backup belongs.
        :param builtins.str data_source_id: The ID of the Data Source in which the Backup belongs.
        :param builtins.str location: The location in which the Backup belongs.
        :param builtins.str name: Name of the resource.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "backup_vault_id", backup_vault_id)
        pulumi.set(__self__, "data_source_id", data_source_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> builtins.str:
        """
        Id of the requesting object, Backup.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="backupVaultId")
    def backup_vault_id(self) -> builtins.str:
        """
        The ID of the Backup Vault of the Data Source in which the Backup belongs.
        """
        return pulumi.get(self, "backup_vault_id")

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> builtins.str:
        """
        The ID of the Data Source in which the Backup belongs.
        """
        return pulumi.get(self, "data_source_id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location in which the Backup belongs.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetBackupPlanAssociationRulesConfigInfoResult(dict):
    def __init__(__self__, *,
                 last_backup_errors: Sequence['outputs.GetBackupPlanAssociationRulesConfigInfoLastBackupErrorResult'],
                 last_backup_state: builtins.str,
                 rule_id: builtins.str):
        """
        :param Sequence['GetBackupPlanAssociationRulesConfigInfoLastBackupErrorArgs'] last_backup_errors: google.rpc.Status object to store the last backup error
        :param builtins.str last_backup_state: State of last backup taken.
        :param builtins.str rule_id: Backup Rule id fetched from backup plan.
        """
        pulumi.set(__self__, "last_backup_errors", last_backup_errors)
        pulumi.set(__self__, "last_backup_state", last_backup_state)
        pulumi.set(__self__, "rule_id", rule_id)

    @property
    @pulumi.getter(name="lastBackupErrors")
    def last_backup_errors(self) -> Sequence['outputs.GetBackupPlanAssociationRulesConfigInfoLastBackupErrorResult']:
        """
        google.rpc.Status object to store the last backup error
        """
        return pulumi.get(self, "last_backup_errors")

    @property
    @pulumi.getter(name="lastBackupState")
    def last_backup_state(self) -> builtins.str:
        """
        State of last backup taken.
        """
        return pulumi.get(self, "last_backup_state")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> builtins.str:
        """
        Backup Rule id fetched from backup plan.
        """
        return pulumi.get(self, "rule_id")


@pulumi.output_type
class GetBackupPlanAssociationRulesConfigInfoLastBackupErrorResult(dict):
    def __init__(__self__, *,
                 code: builtins.float,
                 message: builtins.str):
        """
        :param builtins.float code: The status code, which should be an enum value of [google.rpc.Code]
        :param builtins.str message: A developer-facing error message, which should be in English.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> builtins.float:
        """
        The status code, which should be an enum value of [google.rpc.Code]
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A developer-facing error message, which should be in English.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class GetBackupPlanBackupRuleResult(dict):
    def __init__(__self__, *,
                 backup_retention_days: builtins.int,
                 rule_id: builtins.str,
                 standard_schedules: Sequence['outputs.GetBackupPlanBackupRuleStandardScheduleResult']):
        """
        :param builtins.int backup_retention_days: Configures the duration for which backup data will be kept. The value should be greater than or equal to minimum enforced retention of the backup vault.
        :param builtins.str rule_id: The unique ID of this 'BackupRule'. The 'rule_id' is unique per 'BackupPlan'.
        :param Sequence['GetBackupPlanBackupRuleStandardScheduleArgs'] standard_schedules: StandardSchedule defines a schedule that runs within the confines of a defined window of days.
        """
        pulumi.set(__self__, "backup_retention_days", backup_retention_days)
        pulumi.set(__self__, "rule_id", rule_id)
        pulumi.set(__self__, "standard_schedules", standard_schedules)

    @property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> builtins.int:
        """
        Configures the duration for which backup data will be kept. The value should be greater than or equal to minimum enforced retention of the backup vault.
        """
        return pulumi.get(self, "backup_retention_days")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> builtins.str:
        """
        The unique ID of this 'BackupRule'. The 'rule_id' is unique per 'BackupPlan'.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="standardSchedules")
    def standard_schedules(self) -> Sequence['outputs.GetBackupPlanBackupRuleStandardScheduleResult']:
        """
        StandardSchedule defines a schedule that runs within the confines of a defined window of days.
        """
        return pulumi.get(self, "standard_schedules")


@pulumi.output_type
class GetBackupPlanBackupRuleStandardScheduleResult(dict):
    def __init__(__self__, *,
                 backup_windows: Sequence['outputs.GetBackupPlanBackupRuleStandardScheduleBackupWindowResult'],
                 days_of_months: Sequence[builtins.int],
                 days_of_weeks: Sequence[builtins.str],
                 hourly_frequency: builtins.int,
                 months: Sequence[builtins.str],
                 recurrence_type: builtins.str,
                 time_zone: builtins.str,
                 week_day_of_months: Sequence['outputs.GetBackupPlanBackupRuleStandardScheduleWeekDayOfMonthResult']):
        """
        :param Sequence['GetBackupPlanBackupRuleStandardScheduleBackupWindowArgs'] backup_windows: A BackupWindow defines the window of the day during which backup jobs will run. Jobs are queued at the beginning of the window and will be marked as
               'NOT_RUN' if they do not start by the end of the window.
        :param Sequence[builtins.int] days_of_months: Specifies days of months like 1, 5, or 14 on which jobs will run.
        :param Sequence[builtins.str] days_of_weeks: Specifies days of week like MONDAY or TUESDAY, on which jobs will run. This is required for 'recurrence_type', 'WEEKLY' and is not applicable otherwise. Possible values: ["DAY_OF_WEEK_UNSPECIFIED", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        :param builtins.int hourly_frequency: Specifies frequency for hourly backups. An hourly frequency of 2 means jobs will run every 2 hours from start time till end time defined.
               This is required for 'recurrence_type', 'HOURLY' and is not applicable otherwise.
        :param Sequence[builtins.str] months: Specifies values of months Possible values: ["MONTH_UNSPECIFIED", "JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"]
        :param builtins.str recurrence_type: RecurrenceType enumerates the applicable periodicity for the schedule. Possible values: ["HOURLY", "DAILY", "WEEKLY", "MONTHLY", "YEARLY"]
        :param builtins.str time_zone: The time zone to be used when interpreting the schedule.
        :param Sequence['GetBackupPlanBackupRuleStandardScheduleWeekDayOfMonthArgs'] week_day_of_months: Specifies a week day of the month like FIRST SUNDAY or LAST MONDAY, on which jobs will run.
        """
        pulumi.set(__self__, "backup_windows", backup_windows)
        pulumi.set(__self__, "days_of_months", days_of_months)
        pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        pulumi.set(__self__, "hourly_frequency", hourly_frequency)
        pulumi.set(__self__, "months", months)
        pulumi.set(__self__, "recurrence_type", recurrence_type)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "week_day_of_months", week_day_of_months)

    @property
    @pulumi.getter(name="backupWindows")
    def backup_windows(self) -> Sequence['outputs.GetBackupPlanBackupRuleStandardScheduleBackupWindowResult']:
        """
        A BackupWindow defines the window of the day during which backup jobs will run. Jobs are queued at the beginning of the window and will be marked as
        'NOT_RUN' if they do not start by the end of the window.
        """
        return pulumi.get(self, "backup_windows")

    @property
    @pulumi.getter(name="daysOfMonths")
    def days_of_months(self) -> Sequence[builtins.int]:
        """
        Specifies days of months like 1, 5, or 14 on which jobs will run.
        """
        return pulumi.get(self, "days_of_months")

    @property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Sequence[builtins.str]:
        """
        Specifies days of week like MONDAY or TUESDAY, on which jobs will run. This is required for 'recurrence_type', 'WEEKLY' and is not applicable otherwise. Possible values: ["DAY_OF_WEEK_UNSPECIFIED", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        """
        return pulumi.get(self, "days_of_weeks")

    @property
    @pulumi.getter(name="hourlyFrequency")
    def hourly_frequency(self) -> builtins.int:
        """
        Specifies frequency for hourly backups. An hourly frequency of 2 means jobs will run every 2 hours from start time till end time defined.
        This is required for 'recurrence_type', 'HOURLY' and is not applicable otherwise.
        """
        return pulumi.get(self, "hourly_frequency")

    @property
    @pulumi.getter
    def months(self) -> Sequence[builtins.str]:
        """
        Specifies values of months Possible values: ["MONTH_UNSPECIFIED", "JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"]
        """
        return pulumi.get(self, "months")

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> builtins.str:
        """
        RecurrenceType enumerates the applicable periodicity for the schedule. Possible values: ["HOURLY", "DAILY", "WEEKLY", "MONTHLY", "YEARLY"]
        """
        return pulumi.get(self, "recurrence_type")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        The time zone to be used when interpreting the schedule.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="weekDayOfMonths")
    def week_day_of_months(self) -> Sequence['outputs.GetBackupPlanBackupRuleStandardScheduleWeekDayOfMonthResult']:
        """
        Specifies a week day of the month like FIRST SUNDAY or LAST MONDAY, on which jobs will run.
        """
        return pulumi.get(self, "week_day_of_months")


@pulumi.output_type
class GetBackupPlanBackupRuleStandardScheduleBackupWindowResult(dict):
    def __init__(__self__, *,
                 end_hour_of_day: builtins.int,
                 start_hour_of_day: builtins.int):
        """
        :param builtins.int end_hour_of_day: The hour of the day (1-24) when the window ends, for example, if the value of end hour of the day is 10, that means the backup window end time is 10:00.
               The end hour of the day should be greater than the start
        :param builtins.int start_hour_of_day: The hour of the day (0-23) when the window starts, for example, if the value of the start hour of the day is 6, that means the backup window starts at 6:00.
        """
        pulumi.set(__self__, "end_hour_of_day", end_hour_of_day)
        pulumi.set(__self__, "start_hour_of_day", start_hour_of_day)

    @property
    @pulumi.getter(name="endHourOfDay")
    def end_hour_of_day(self) -> builtins.int:
        """
        The hour of the day (1-24) when the window ends, for example, if the value of end hour of the day is 10, that means the backup window end time is 10:00.
        The end hour of the day should be greater than the start
        """
        return pulumi.get(self, "end_hour_of_day")

    @property
    @pulumi.getter(name="startHourOfDay")
    def start_hour_of_day(self) -> builtins.int:
        """
        The hour of the day (0-23) when the window starts, for example, if the value of the start hour of the day is 6, that means the backup window starts at 6:00.
        """
        return pulumi.get(self, "start_hour_of_day")


@pulumi.output_type
class GetBackupPlanBackupRuleStandardScheduleWeekDayOfMonthResult(dict):
    def __init__(__self__, *,
                 day_of_week: builtins.str,
                 week_of_month: builtins.str):
        """
        :param builtins.str day_of_week: Specifies the day of the week. Possible values: ["DAY_OF_WEEK_UNSPECIFIED", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        :param builtins.str week_of_month: WeekOfMonth enumerates possible weeks in the month, e.g. the first, third, or last week of the month. Possible values: ["WEEK_OF_MONTH_UNSPECIFIED", "FIRST", "SECOND", "THIRD", "FOURTH", "LAST"]
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "week_of_month", week_of_month)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> builtins.str:
        """
        Specifies the day of the week. Possible values: ["DAY_OF_WEEK_UNSPECIFIED", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="weekOfMonth")
    def week_of_month(self) -> builtins.str:
        """
        WeekOfMonth enumerates possible weeks in the month, e.g. the first, third, or last week of the month. Possible values: ["WEEK_OF_MONTH_UNSPECIFIED", "FIRST", "SECOND", "THIRD", "FOURTH", "LAST"]
        """
        return pulumi.get(self, "week_of_month")


@pulumi.output_type
class GetDataSourceBackupConfigInfoResult(dict):
    def __init__(__self__, *,
                 backup_appliance_backup_configs: Sequence['outputs.GetDataSourceBackupConfigInfoBackupApplianceBackupConfigResult'],
                 gcp_backup_configs: Sequence['outputs.GetDataSourceBackupConfigInfoGcpBackupConfigResult'],
                 last_backup_error: Mapping[str, builtins.str],
                 last_backup_state: builtins.str,
                 last_successful_backup_consistency_time: builtins.str):
        """
        :param Sequence['GetDataSourceBackupConfigInfoBackupApplianceBackupConfigArgs'] backup_appliance_backup_configs: Configuration for an application backed up by a Backup Appliance.
        :param Sequence['GetDataSourceBackupConfigInfoGcpBackupConfigArgs'] gcp_backup_configs: Configuration for a Google Cloud resource.
        :param Mapping[str, builtins.str] last_backup_error: If the last backup failed, this field has the error message.
        :param builtins.str last_backup_state: LastBackupstate tracks whether the last backup was not yet started, successful, failed, or could not be run because of the lack of permissions.
        :param builtins.str last_successful_backup_consistency_time: If the last backup were successful, this field has the consistency date.
        """
        pulumi.set(__self__, "backup_appliance_backup_configs", backup_appliance_backup_configs)
        pulumi.set(__self__, "gcp_backup_configs", gcp_backup_configs)
        pulumi.set(__self__, "last_backup_error", last_backup_error)
        pulumi.set(__self__, "last_backup_state", last_backup_state)
        pulumi.set(__self__, "last_successful_backup_consistency_time", last_successful_backup_consistency_time)

    @property
    @pulumi.getter(name="backupApplianceBackupConfigs")
    def backup_appliance_backup_configs(self) -> Sequence['outputs.GetDataSourceBackupConfigInfoBackupApplianceBackupConfigResult']:
        """
        Configuration for an application backed up by a Backup Appliance.
        """
        return pulumi.get(self, "backup_appliance_backup_configs")

    @property
    @pulumi.getter(name="gcpBackupConfigs")
    def gcp_backup_configs(self) -> Sequence['outputs.GetDataSourceBackupConfigInfoGcpBackupConfigResult']:
        """
        Configuration for a Google Cloud resource.
        """
        return pulumi.get(self, "gcp_backup_configs")

    @property
    @pulumi.getter(name="lastBackupError")
    def last_backup_error(self) -> Mapping[str, builtins.str]:
        """
        If the last backup failed, this field has the error message.
        """
        return pulumi.get(self, "last_backup_error")

    @property
    @pulumi.getter(name="lastBackupState")
    def last_backup_state(self) -> builtins.str:
        """
        LastBackupstate tracks whether the last backup was not yet started, successful, failed, or could not be run because of the lack of permissions.
        """
        return pulumi.get(self, "last_backup_state")

    @property
    @pulumi.getter(name="lastSuccessfulBackupConsistencyTime")
    def last_successful_backup_consistency_time(self) -> builtins.str:
        """
        If the last backup were successful, this field has the consistency date.
        """
        return pulumi.get(self, "last_successful_backup_consistency_time")


@pulumi.output_type
class GetDataSourceBackupConfigInfoBackupApplianceBackupConfigResult(dict):
    def __init__(__self__, *,
                 application_name: builtins.str,
                 backup_appliance_id: builtins.str,
                 backup_appliance_name: builtins.str,
                 host_name: builtins.str,
                 sla_id: builtins.str,
                 slp_name: builtins.str,
                 slt_name: builtins.str):
        """
        :param builtins.str application_name: The name of the application.
        :param builtins.str backup_appliance_id: The ID of the backup appliance.
        :param builtins.str backup_appliance_name: The name of the backup appliance.
        :param builtins.str host_name: The name of the host where the application is running.
        :param builtins.str sla_id: The ID of the SLA of this application.
        :param builtins.str slp_name: The name of the SLP associated with the application.
        :param builtins.str slt_name: The name of the SLT associated with the application.
        """
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "backup_appliance_id", backup_appliance_id)
        pulumi.set(__self__, "backup_appliance_name", backup_appliance_name)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "sla_id", sla_id)
        pulumi.set(__self__, "slp_name", slp_name)
        pulumi.set(__self__, "slt_name", slt_name)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> builtins.str:
        """
        The name of the application.
        """
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter(name="backupApplianceId")
    def backup_appliance_id(self) -> builtins.str:
        """
        The ID of the backup appliance.
        """
        return pulumi.get(self, "backup_appliance_id")

    @property
    @pulumi.getter(name="backupApplianceName")
    def backup_appliance_name(self) -> builtins.str:
        """
        The name of the backup appliance.
        """
        return pulumi.get(self, "backup_appliance_name")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The name of the host where the application is running.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="slaId")
    def sla_id(self) -> builtins.str:
        """
        The ID of the SLA of this application.
        """
        return pulumi.get(self, "sla_id")

    @property
    @pulumi.getter(name="slpName")
    def slp_name(self) -> builtins.str:
        """
        The name of the SLP associated with the application.
        """
        return pulumi.get(self, "slp_name")

    @property
    @pulumi.getter(name="sltName")
    def slt_name(self) -> builtins.str:
        """
        The name of the SLT associated with the application.
        """
        return pulumi.get(self, "slt_name")


@pulumi.output_type
class GetDataSourceBackupConfigInfoGcpBackupConfigResult(dict):
    def __init__(__self__, *,
                 backup_plan: builtins.str,
                 backup_plan_association: builtins.str,
                 backup_plan_description: builtins.str,
                 backup_plan_rules: Sequence[builtins.str]):
        """
        :param builtins.str backup_plan: The name of the backup plan.
        :param builtins.str backup_plan_association: The name of the backup plan association.
        :param builtins.str backup_plan_description: The description of the backup plan.
        :param Sequence[builtins.str] backup_plan_rules: The names of the backup plan rules which point to this backupvault
        """
        pulumi.set(__self__, "backup_plan", backup_plan)
        pulumi.set(__self__, "backup_plan_association", backup_plan_association)
        pulumi.set(__self__, "backup_plan_description", backup_plan_description)
        pulumi.set(__self__, "backup_plan_rules", backup_plan_rules)

    @property
    @pulumi.getter(name="backupPlan")
    def backup_plan(self) -> builtins.str:
        """
        The name of the backup plan.
        """
        return pulumi.get(self, "backup_plan")

    @property
    @pulumi.getter(name="backupPlanAssociation")
    def backup_plan_association(self) -> builtins.str:
        """
        The name of the backup plan association.
        """
        return pulumi.get(self, "backup_plan_association")

    @property
    @pulumi.getter(name="backupPlanDescription")
    def backup_plan_description(self) -> builtins.str:
        """
        The description of the backup plan.
        """
        return pulumi.get(self, "backup_plan_description")

    @property
    @pulumi.getter(name="backupPlanRules")
    def backup_plan_rules(self) -> Sequence[builtins.str]:
        """
        The names of the backup plan rules which point to this backupvault
        """
        return pulumi.get(self, "backup_plan_rules")


@pulumi.output_type
class GetDataSourceDataSourceBackupApplianceApplicationResult(dict):
    def __init__(__self__, *,
                 appliance_id: builtins.str,
                 application_id: builtins.str,
                 application_name: builtins.str,
                 backup_appliance: builtins.str,
                 host_id: builtins.str,
                 hostname: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str appliance_id: Appliance Id of the Backup Appliance.
        :param builtins.str application_id: The appid field of the application within the Backup Appliance.
        :param builtins.str application_name: The name of the Application as known to the Backup Appliance.
        :param builtins.str backup_appliance: Appliance name.
        :param builtins.str host_id: Hostid of the application host.
        :param builtins.str hostname: Hostname of the host where the application is running.
        :param builtins.str type: The type of the application. e.g. VMBackup
        """
        pulumi.set(__self__, "appliance_id", appliance_id)
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "backup_appliance", backup_appliance)
        pulumi.set(__self__, "host_id", host_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="applianceId")
    def appliance_id(self) -> builtins.str:
        """
        Appliance Id of the Backup Appliance.
        """
        return pulumi.get(self, "appliance_id")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> builtins.str:
        """
        The appid field of the application within the Backup Appliance.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> builtins.str:
        """
        The name of the Application as known to the Backup Appliance.
        """
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter(name="backupAppliance")
    def backup_appliance(self) -> builtins.str:
        """
        Appliance name.
        """
        return pulumi.get(self, "backup_appliance")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> builtins.str:
        """
        Hostid of the application host.
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        Hostname of the host where the application is running.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the application. e.g. VMBackup
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDataSourceDataSourceGcpResourceResult(dict):
    def __init__(__self__, *,
                 compute_instance_data_source_properties: Sequence['outputs.GetDataSourceDataSourceGcpResourceComputeInstanceDataSourcePropertyResult'],
                 gcp_resourcename: builtins.str,
                 location: builtins.str,
                 type: builtins.str):
        """
        :param Sequence['GetDataSourceDataSourceGcpResourceComputeInstanceDataSourcePropertyArgs'] compute_instance_data_source_properties: ComputeInstanceDataSourceProperties has a subset of Compute Instance properties that are useful at the Datasource level.
        :param builtins.str gcp_resourcename: Full resource pathname URL of the source Google Cloud resource.
        :param builtins.str location: The location in which the Data Source belongs.
        :param builtins.str type: The type of the Google Cloud resource. Use the Unified Resource Type,
               						eg. compute.googleapis.com/Instance.
        """
        pulumi.set(__self__, "compute_instance_data_source_properties", compute_instance_data_source_properties)
        pulumi.set(__self__, "gcp_resourcename", gcp_resourcename)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="computeInstanceDataSourceProperties")
    def compute_instance_data_source_properties(self) -> Sequence['outputs.GetDataSourceDataSourceGcpResourceComputeInstanceDataSourcePropertyResult']:
        """
        ComputeInstanceDataSourceProperties has a subset of Compute Instance properties that are useful at the Datasource level.
        """
        return pulumi.get(self, "compute_instance_data_source_properties")

    @property
    @pulumi.getter(name="gcpResourcename")
    def gcp_resourcename(self) -> builtins.str:
        """
        Full resource pathname URL of the source Google Cloud resource.
        """
        return pulumi.get(self, "gcp_resourcename")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location in which the Data Source belongs.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the Google Cloud resource. Use the Unified Resource Type,
        						eg. compute.googleapis.com/Instance.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDataSourceDataSourceGcpResourceComputeInstanceDataSourcePropertyResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 machine_type: builtins.str,
                 name: builtins.str,
                 total_disk_count: builtins.str,
                 total_disk_size_gb: builtins.str):
        """
        :param builtins.str description: The description of the Compute Engine instance.
        :param builtins.str machine_type: The machine type of the instance.
        :param builtins.str name: Name of the compute instance backed up by the datasource.
        :param builtins.str total_disk_count: The total number of disks attached to the Instance.
        :param builtins.str total_disk_size_gb: The sum of all the disk sizes.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "total_disk_count", total_disk_count)
        pulumi.set(__self__, "total_disk_size_gb", total_disk_size_gb)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the Compute Engine instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> builtins.str:
        """
        The machine type of the instance.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the compute instance backed up by the datasource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="totalDiskCount")
    def total_disk_count(self) -> builtins.str:
        """
        The total number of disks attached to the Instance.
        """
        return pulumi.get(self, "total_disk_count")

    @property
    @pulumi.getter(name="totalDiskSizeGb")
    def total_disk_size_gb(self) -> builtins.str:
        """
        The sum of all the disk sizes.
        """
        return pulumi.get(self, "total_disk_size_gb")


@pulumi.output_type
class GetManagementServerManagementUriResult(dict):
    def __init__(__self__, *,
                 api: builtins.str,
                 web_ui: builtins.str):
        """
        :param builtins.str api: The management console api endpoint.
        :param builtins.str web_ui: The management console webUi.
        """
        pulumi.set(__self__, "api", api)
        pulumi.set(__self__, "web_ui", web_ui)

    @property
    @pulumi.getter
    def api(self) -> builtins.str:
        """
        The management console api endpoint.
        """
        return pulumi.get(self, "api")

    @property
    @pulumi.getter(name="webUi")
    def web_ui(self) -> builtins.str:
        """
        The management console webUi.
        """
        return pulumi.get(self, "web_ui")


@pulumi.output_type
class GetManagementServerNetworkResult(dict):
    def __init__(__self__, *,
                 network: builtins.str,
                 peering_mode: builtins.str):
        """
        :param builtins.str network: Network with format 'projects/{{project_id}}/global/networks/{{network_id}}'
        :param builtins.str peering_mode: Type of Network peeringMode Default value: "PRIVATE_SERVICE_ACCESS" Possible values: ["PRIVATE_SERVICE_ACCESS"]
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "peering_mode", peering_mode)

    @property
    @pulumi.getter
    def network(self) -> builtins.str:
        """
        Network with format 'projects/{{project_id}}/global/networks/{{network_id}}'
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="peeringMode")
    def peering_mode(self) -> builtins.str:
        """
        Type of Network peeringMode Default value: "PRIVATE_SERVICE_ACCESS" Possible values: ["PRIVATE_SERVICE_ACCESS"]
        """
        return pulumi.get(self, "peering_mode")


