# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AppConnectionApplicationEndpointArgs',
    'AppConnectionApplicationEndpointArgsDict',
    'AppConnectionGatewayArgs',
    'AppConnectionGatewayArgsDict',
    'AppConnectorPrincipalInfoArgs',
    'AppConnectorPrincipalInfoArgsDict',
    'AppConnectorPrincipalInfoServiceAccountArgs',
    'AppConnectorPrincipalInfoServiceAccountArgsDict',
    'AppGatewayAllocatedConnectionArgs',
    'AppGatewayAllocatedConnectionArgsDict',
    'ApplicationEndpointMatcherArgs',
    'ApplicationEndpointMatcherArgsDict',
    'ApplicationIamBindingConditionArgs',
    'ApplicationIamBindingConditionArgsDict',
    'ApplicationIamMemberConditionArgs',
    'ApplicationIamMemberConditionArgsDict',
    'ApplicationUpstreamArgs',
    'ApplicationUpstreamArgsDict',
    'ApplicationUpstreamEgressPolicyArgs',
    'ApplicationUpstreamEgressPolicyArgsDict',
    'ApplicationUpstreamNetworkArgs',
    'ApplicationUpstreamNetworkArgsDict',
    'SecurityGatewayApplicationEndpointMatcherArgs',
    'SecurityGatewayApplicationEndpointMatcherArgsDict',
    'SecurityGatewayApplicationIamBindingConditionArgs',
    'SecurityGatewayApplicationIamBindingConditionArgsDict',
    'SecurityGatewayApplicationIamMemberConditionArgs',
    'SecurityGatewayApplicationIamMemberConditionArgsDict',
    'SecurityGatewayApplicationUpstreamArgs',
    'SecurityGatewayApplicationUpstreamArgsDict',
    'SecurityGatewayApplicationUpstreamEgressPolicyArgs',
    'SecurityGatewayApplicationUpstreamEgressPolicyArgsDict',
    'SecurityGatewayApplicationUpstreamNetworkArgs',
    'SecurityGatewayApplicationUpstreamNetworkArgsDict',
    'SecurityGatewayHubArgs',
    'SecurityGatewayHubArgsDict',
    'SecurityGatewayHubInternetGatewayArgs',
    'SecurityGatewayHubInternetGatewayArgsDict',
    'SecurityGatewayIamBindingConditionArgs',
    'SecurityGatewayIamBindingConditionArgsDict',
    'SecurityGatewayIamMemberConditionArgs',
    'SecurityGatewayIamMemberConditionArgsDict',
]

MYPY = False

if not MYPY:
    class AppConnectionApplicationEndpointArgsDict(TypedDict):
        host: pulumi.Input[builtins.str]
        """
        Hostname or IP address of the remote application endpoint.
        """
        port: pulumi.Input[builtins.int]
        """
        Port of the remote application endpoint.

        - - -
        """
elif False:
    AppConnectionApplicationEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppConnectionApplicationEndpointArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[builtins.str],
                 port: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] host: Hostname or IP address of the remote application endpoint.
        :param pulumi.Input[builtins.int] port: Port of the remote application endpoint.
               
               - - -
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[builtins.str]:
        """
        Hostname or IP address of the remote application endpoint.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[builtins.int]:
        """
        Port of the remote application endpoint.

        - - -
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "port", value)


if not MYPY:
    class AppConnectionGatewayArgsDict(TypedDict):
        app_gateway: pulumi.Input[builtins.str]
        """
        AppGateway name in following format: projects/{project_id}/locations/{locationId}/appgateways/{gateway_id}.
        """
        ingress_port: NotRequired[pulumi.Input[builtins.int]]
        """
        (Output)
        Ingress port reserved on the gateways for this AppConnection, if not specified or zero, the default port is 19443.
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of hosting used by the gateway. Refer to
        https://cloud.google.com/beyondcorp/docs/reference/rest/v1/projects.locations.appConnections#Type_1
        for a list of possible values.
        """
        uri: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Server-defined URI for this resource.
        """
elif False:
    AppConnectionGatewayArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppConnectionGatewayArgs:
    def __init__(__self__, *,
                 app_gateway: pulumi.Input[builtins.str],
                 ingress_port: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] app_gateway: AppGateway name in following format: projects/{project_id}/locations/{locationId}/appgateways/{gateway_id}.
        :param pulumi.Input[builtins.int] ingress_port: (Output)
               Ingress port reserved on the gateways for this AppConnection, if not specified or zero, the default port is 19443.
        :param pulumi.Input[builtins.str] type: The type of hosting used by the gateway. Refer to
               https://cloud.google.com/beyondcorp/docs/reference/rest/v1/projects.locations.appConnections#Type_1
               for a list of possible values.
        :param pulumi.Input[builtins.str] uri: (Output)
               Server-defined URI for this resource.
        """
        pulumi.set(__self__, "app_gateway", app_gateway)
        if ingress_port is not None:
            pulumi.set(__self__, "ingress_port", ingress_port)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="appGateway")
    def app_gateway(self) -> pulumi.Input[builtins.str]:
        """
        AppGateway name in following format: projects/{project_id}/locations/{locationId}/appgateways/{gateway_id}.
        """
        return pulumi.get(self, "app_gateway")

    @app_gateway.setter
    def app_gateway(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "app_gateway", value)

    @property
    @pulumi.getter(name="ingressPort")
    def ingress_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Output)
        Ingress port reserved on the gateways for this AppConnection, if not specified or zero, the default port is 19443.
        """
        return pulumi.get(self, "ingress_port")

    @ingress_port.setter
    def ingress_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ingress_port", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of hosting used by the gateway. Refer to
        https://cloud.google.com/beyondcorp/docs/reference/rest/v1/projects.locations.appConnections#Type_1
        for a list of possible values.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Server-defined URI for this resource.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uri", value)


if not MYPY:
    class AppConnectorPrincipalInfoArgsDict(TypedDict):
        service_account: pulumi.Input['AppConnectorPrincipalInfoServiceAccountArgsDict']
        """
        ServiceAccount represents a GCP service account.
        Structure is documented below.
        """
elif False:
    AppConnectorPrincipalInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppConnectorPrincipalInfoArgs:
    def __init__(__self__, *,
                 service_account: pulumi.Input['AppConnectorPrincipalInfoServiceAccountArgs']):
        """
        :param pulumi.Input['AppConnectorPrincipalInfoServiceAccountArgs'] service_account: ServiceAccount represents a GCP service account.
               Structure is documented below.
        """
        pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Input['AppConnectorPrincipalInfoServiceAccountArgs']:
        """
        ServiceAccount represents a GCP service account.
        Structure is documented below.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: pulumi.Input['AppConnectorPrincipalInfoServiceAccountArgs']):
        pulumi.set(self, "service_account", value)


if not MYPY:
    class AppConnectorPrincipalInfoServiceAccountArgsDict(TypedDict):
        email: pulumi.Input[builtins.str]
        """
        Email address of the service account.

        - - -
        """
elif False:
    AppConnectorPrincipalInfoServiceAccountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppConnectorPrincipalInfoServiceAccountArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] email: Email address of the service account.
               
               - - -
        """
        pulumi.set(__self__, "email", email)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[builtins.str]:
        """
        Email address of the service account.

        - - -
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email", value)


if not MYPY:
    class AppGatewayAllocatedConnectionArgsDict(TypedDict):
        ingress_port: NotRequired[pulumi.Input[builtins.int]]
        """
        The ingress port of an allocated connection.
        """
        psc_uri: NotRequired[pulumi.Input[builtins.str]]
        """
        The PSC uri of an allocated connection.
        """
elif False:
    AppGatewayAllocatedConnectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppGatewayAllocatedConnectionArgs:
    def __init__(__self__, *,
                 ingress_port: Optional[pulumi.Input[builtins.int]] = None,
                 psc_uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] ingress_port: The ingress port of an allocated connection.
        :param pulumi.Input[builtins.str] psc_uri: The PSC uri of an allocated connection.
        """
        if ingress_port is not None:
            pulumi.set(__self__, "ingress_port", ingress_port)
        if psc_uri is not None:
            pulumi.set(__self__, "psc_uri", psc_uri)

    @property
    @pulumi.getter(name="ingressPort")
    def ingress_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The ingress port of an allocated connection.
        """
        return pulumi.get(self, "ingress_port")

    @ingress_port.setter
    def ingress_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ingress_port", value)

    @property
    @pulumi.getter(name="pscUri")
    def psc_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PSC uri of an allocated connection.
        """
        return pulumi.get(self, "psc_uri")

    @psc_uri.setter
    def psc_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "psc_uri", value)


if not MYPY:
    class ApplicationEndpointMatcherArgsDict(TypedDict):
        hostname: pulumi.Input[builtins.str]
        """
        Required. Hostname of the application.
        """
        ports: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]
        """
        Optional. Ports of the application.

        - - -
        """
elif False:
    ApplicationEndpointMatcherArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationEndpointMatcherArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[builtins.str],
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None):
        """
        :param pulumi.Input[builtins.str] hostname: Required. Hostname of the application.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] ports: Optional. Ports of the application.
               
               - - -
        """
        pulumi.set(__self__, "hostname", hostname)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[builtins.str]:
        """
        Required. Hostname of the application.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        Optional. Ports of the application.

        - - -
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "ports", value)


if not MYPY:
    class ApplicationIamBindingConditionArgsDict(TypedDict):
        expression: pulumi.Input[builtins.str]
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        title: pulumi.Input[builtins.str]
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
elif False:
    ApplicationIamBindingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[builtins.str] title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class ApplicationIamMemberConditionArgsDict(TypedDict):
        expression: pulumi.Input[builtins.str]
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        title: pulumi.Input[builtins.str]
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
elif False:
    ApplicationIamMemberConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[builtins.str] title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class ApplicationUpstreamArgsDict(TypedDict):
        egress_policy: NotRequired[pulumi.Input['ApplicationUpstreamEgressPolicyArgsDict']]
        """
        Optional. Routing policy information.
        Structure is documented below.
        """
        network: NotRequired[pulumi.Input['ApplicationUpstreamNetworkArgsDict']]
        """
        Network to forward traffic to.
        Structure is documented below.
        """
elif False:
    ApplicationUpstreamArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationUpstreamArgs:
    def __init__(__self__, *,
                 egress_policy: Optional[pulumi.Input['ApplicationUpstreamEgressPolicyArgs']] = None,
                 network: Optional[pulumi.Input['ApplicationUpstreamNetworkArgs']] = None):
        """
        :param pulumi.Input['ApplicationUpstreamEgressPolicyArgs'] egress_policy: Optional. Routing policy information.
               Structure is documented below.
        :param pulumi.Input['ApplicationUpstreamNetworkArgs'] network: Network to forward traffic to.
               Structure is documented below.
        """
        if egress_policy is not None:
            pulumi.set(__self__, "egress_policy", egress_policy)
        if network is not None:
            pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter(name="egressPolicy")
    def egress_policy(self) -> Optional[pulumi.Input['ApplicationUpstreamEgressPolicyArgs']]:
        """
        Optional. Routing policy information.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_policy")

    @egress_policy.setter
    def egress_policy(self, value: Optional[pulumi.Input['ApplicationUpstreamEgressPolicyArgs']]):
        pulumi.set(self, "egress_policy", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['ApplicationUpstreamNetworkArgs']]:
        """
        Network to forward traffic to.
        Structure is documented below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['ApplicationUpstreamNetworkArgs']]):
        pulumi.set(self, "network", value)


if not MYPY:
    class ApplicationUpstreamEgressPolicyArgsDict(TypedDict):
        regions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        Required. List of regions where the application sends traffic to.
        """
elif False:
    ApplicationUpstreamEgressPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationUpstreamEgressPolicyArgs:
    def __init__(__self__, *,
                 regions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] regions: Required. List of regions where the application sends traffic to.
        """
        pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Required. List of regions where the application sends traffic to.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "regions", value)


if not MYPY:
    class ApplicationUpstreamNetworkArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Required. Network name is of the format:
        `projects/{project}/global/networks/{network}`
        """
elif False:
    ApplicationUpstreamNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationUpstreamNetworkArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: Required. Network name is of the format:
               `projects/{project}/global/networks/{network}`
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Required. Network name is of the format:
        `projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class SecurityGatewayApplicationEndpointMatcherArgsDict(TypedDict):
        hostname: pulumi.Input[builtins.str]
        """
        Required. Hostname of the application.
        """
        ports: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]
        """
        Optional. Ports of the application.

        - - -
        """
elif False:
    SecurityGatewayApplicationEndpointMatcherArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationEndpointMatcherArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[builtins.str],
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None):
        """
        :param pulumi.Input[builtins.str] hostname: Required. Hostname of the application.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] ports: Optional. Ports of the application.
               
               - - -
        """
        pulumi.set(__self__, "hostname", hostname)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[builtins.str]:
        """
        Required. Hostname of the application.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        Optional. Ports of the application.

        - - -
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "ports", value)


if not MYPY:
    class SecurityGatewayApplicationIamBindingConditionArgsDict(TypedDict):
        expression: pulumi.Input[builtins.str]
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        title: pulumi.Input[builtins.str]
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
elif False:
    SecurityGatewayApplicationIamBindingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[builtins.str] title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class SecurityGatewayApplicationIamMemberConditionArgsDict(TypedDict):
        expression: pulumi.Input[builtins.str]
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        title: pulumi.Input[builtins.str]
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
elif False:
    SecurityGatewayApplicationIamMemberConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[builtins.str] title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class SecurityGatewayApplicationUpstreamArgsDict(TypedDict):
        egress_policy: NotRequired[pulumi.Input['SecurityGatewayApplicationUpstreamEgressPolicyArgsDict']]
        """
        Optional. Routing policy information.
        Structure is documented below.
        """
        network: NotRequired[pulumi.Input['SecurityGatewayApplicationUpstreamNetworkArgsDict']]
        """
        Network to forward traffic to.
        Structure is documented below.
        """
elif False:
    SecurityGatewayApplicationUpstreamArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationUpstreamArgs:
    def __init__(__self__, *,
                 egress_policy: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamEgressPolicyArgs']] = None,
                 network: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamNetworkArgs']] = None):
        """
        :param pulumi.Input['SecurityGatewayApplicationUpstreamEgressPolicyArgs'] egress_policy: Optional. Routing policy information.
               Structure is documented below.
        :param pulumi.Input['SecurityGatewayApplicationUpstreamNetworkArgs'] network: Network to forward traffic to.
               Structure is documented below.
        """
        if egress_policy is not None:
            pulumi.set(__self__, "egress_policy", egress_policy)
        if network is not None:
            pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter(name="egressPolicy")
    def egress_policy(self) -> Optional[pulumi.Input['SecurityGatewayApplicationUpstreamEgressPolicyArgs']]:
        """
        Optional. Routing policy information.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_policy")

    @egress_policy.setter
    def egress_policy(self, value: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamEgressPolicyArgs']]):
        pulumi.set(self, "egress_policy", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['SecurityGatewayApplicationUpstreamNetworkArgs']]:
        """
        Network to forward traffic to.
        Structure is documented below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamNetworkArgs']]):
        pulumi.set(self, "network", value)


if not MYPY:
    class SecurityGatewayApplicationUpstreamEgressPolicyArgsDict(TypedDict):
        regions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        Required. List of regions where the application sends traffic to.
        """
elif False:
    SecurityGatewayApplicationUpstreamEgressPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationUpstreamEgressPolicyArgs:
    def __init__(__self__, *,
                 regions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] regions: Required. List of regions where the application sends traffic to.
        """
        pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Required. List of regions where the application sends traffic to.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "regions", value)


if not MYPY:
    class SecurityGatewayApplicationUpstreamNetworkArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Required. Network name is of the format:
        `projects/{project}/global/networks/{network}`
        """
elif False:
    SecurityGatewayApplicationUpstreamNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationUpstreamNetworkArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: Required. Network name is of the format:
               `projects/{project}/global/networks/{network}`
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Required. Network name is of the format:
        `projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class SecurityGatewayHubArgsDict(TypedDict):
        region: pulumi.Input[builtins.str]
        """
        The identifier for this object. Format specified above.
        """
        internet_gateway: NotRequired[pulumi.Input['SecurityGatewayHubInternetGatewayArgsDict']]
        """
        Internet Gateway configuration.
        Structure is documented below.
        """
elif False:
    SecurityGatewayHubArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayHubArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[builtins.str],
                 internet_gateway: Optional[pulumi.Input['SecurityGatewayHubInternetGatewayArgs']] = None):
        """
        :param pulumi.Input[builtins.str] region: The identifier for this object. Format specified above.
        :param pulumi.Input['SecurityGatewayHubInternetGatewayArgs'] internet_gateway: Internet Gateway configuration.
               Structure is documented below.
        """
        pulumi.set(__self__, "region", region)
        if internet_gateway is not None:
            pulumi.set(__self__, "internet_gateway", internet_gateway)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[builtins.str]:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="internetGateway")
    def internet_gateway(self) -> Optional[pulumi.Input['SecurityGatewayHubInternetGatewayArgs']]:
        """
        Internet Gateway configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "internet_gateway")

    @internet_gateway.setter
    def internet_gateway(self, value: Optional[pulumi.Input['SecurityGatewayHubInternetGatewayArgs']]):
        pulumi.set(self, "internet_gateway", value)


if not MYPY:
    class SecurityGatewayHubInternetGatewayArgsDict(TypedDict):
        assigned_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Output)
        Output only. List of IP addresses assigned to the Cloud NAT.
        """
elif False:
    SecurityGatewayHubInternetGatewayArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayHubInternetGatewayArgs:
    def __init__(__self__, *,
                 assigned_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] assigned_ips: (Output)
               Output only. List of IP addresses assigned to the Cloud NAT.
        """
        if assigned_ips is not None:
            pulumi.set(__self__, "assigned_ips", assigned_ips)

    @property
    @pulumi.getter(name="assignedIps")
    def assigned_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Output)
        Output only. List of IP addresses assigned to the Cloud NAT.
        """
        return pulumi.get(self, "assigned_ips")

    @assigned_ips.setter
    def assigned_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "assigned_ips", value)


if not MYPY:
    class SecurityGatewayIamBindingConditionArgsDict(TypedDict):
        expression: pulumi.Input[builtins.str]
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        title: pulumi.Input[builtins.str]
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
elif False:
    SecurityGatewayIamBindingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[builtins.str] title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class SecurityGatewayIamMemberConditionArgsDict(TypedDict):
        expression: pulumi.Input[builtins.str]
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        title: pulumi.Input[builtins.str]
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
elif False:
    SecurityGatewayIamMemberConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[builtins.str] title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


