# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[builtins.str],
                 endpoint_matchers: pulumi.Input[Sequence[pulumi.Input['ApplicationEndpointMatcherArgs']]],
                 security_gateways_id: pulumi.Input[builtins.str],
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 upstreams: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationUpstreamArgs']]]] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[builtins.str] application_id: Optional. User-settable Application resource ID.
               * Must start with a letter.
               * Must contain between 4-63 characters from `/a-z-/`.
               * Must end with a number or letter.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationEndpointMatcherArgs']]] endpoint_matchers: Required. Endpoint matchers associated with an application.
               A combination of hostname and ports as endpoint matcher is used to match
               the application.
               Match conditions for OR logic.
               An array of match conditions to allow for multiple matching criteria.
               The rule is considered a match if one the conditions are met.
               The conditions can be one of the following combination
               (Hostname), (Hostname & Ports)
               EXAMPLES:
               Hostname - ("*.abc.com"), ("xyz.abc.com")
               Hostname and Ports - ("abc.com" and "22"), ("abc.com" and "22,33") etc
               Structure is documented below.
        :param pulumi.Input[builtins.str] security_gateways_id: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] display_name: Optional. An arbitrary user-provided name for the Application resource. Cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationUpstreamArgs']]] upstreams: Optional. List of which upstream resource(s) to forward traffic to.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "endpoint_matchers", endpoint_matchers)
        pulumi.set(__self__, "security_gateways_id", security_gateways_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if upstreams is not None:
            pulumi.set(__self__, "upstreams", upstreams)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        Optional. User-settable Application resource ID.
        * Must start with a letter.
        * Must contain between 4-63 characters from `/a-z-/`.
        * Must end with a number or letter.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="endpointMatchers")
    def endpoint_matchers(self) -> pulumi.Input[Sequence[pulumi.Input['ApplicationEndpointMatcherArgs']]]:
        """
        Required. Endpoint matchers associated with an application.
        A combination of hostname and ports as endpoint matcher is used to match
        the application.
        Match conditions for OR logic.
        An array of match conditions to allow for multiple matching criteria.
        The rule is considered a match if one the conditions are met.
        The conditions can be one of the following combination
        (Hostname), (Hostname & Ports)
        EXAMPLES:
        Hostname - ("*.abc.com"), ("xyz.abc.com")
        Hostname and Ports - ("abc.com" and "22"), ("abc.com" and "22,33") etc
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint_matchers")

    @endpoint_matchers.setter
    def endpoint_matchers(self, value: pulumi.Input[Sequence[pulumi.Input['ApplicationEndpointMatcherArgs']]]):
        pulumi.set(self, "endpoint_matchers", value)

    @property
    @pulumi.getter(name="securityGatewaysId")
    def security_gateways_id(self) -> pulumi.Input[builtins.str]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "security_gateways_id")

    @security_gateways_id.setter
    def security_gateways_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "security_gateways_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. An arbitrary user-provided name for the Application resource. Cannot exceed 64 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def upstreams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationUpstreamArgs']]]]:
        """
        Optional. List of which upstream resource(s) to forward traffic to.
        """
        return pulumi.get(self, "upstreams")

    @upstreams.setter
    def upstreams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationUpstreamArgs']]]]):
        pulumi.set(self, "upstreams", value)


@pulumi.input_type
class _ApplicationState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_matchers: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationEndpointMatcherArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 security_gateways_id: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 upstreams: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationUpstreamArgs']]]] = None):
        """
        Input properties used for looking up and filtering Application resources.
        :param pulumi.Input[builtins.str] application_id: Optional. User-settable Application resource ID.
               * Must start with a letter.
               * Must contain between 4-63 characters from `/a-z-/`.
               * Must end with a number or letter.
        :param pulumi.Input[builtins.str] create_time: Output only. Timestamp when the resource was created.
        :param pulumi.Input[builtins.str] display_name: Optional. An arbitrary user-provided name for the Application resource. Cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationEndpointMatcherArgs']]] endpoint_matchers: Required. Endpoint matchers associated with an application.
               A combination of hostname and ports as endpoint matcher is used to match
               the application.
               Match conditions for OR logic.
               An array of match conditions to allow for multiple matching criteria.
               The rule is considered a match if one the conditions are met.
               The conditions can be one of the following combination
               (Hostname), (Hostname & Ports)
               EXAMPLES:
               Hostname - ("*.abc.com"), ("xyz.abc.com")
               Hostname and Ports - ("abc.com" and "22"), ("abc.com" and "22,33") etc
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Identifier. Name of the resource.
        :param pulumi.Input[builtins.str] security_gateways_id: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] update_time: Output only. Timestamp when the resource was last modified.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationUpstreamArgs']]] upstreams: Optional. List of which upstream resource(s) to forward traffic to.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoint_matchers is not None:
            pulumi.set(__self__, "endpoint_matchers", endpoint_matchers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if security_gateways_id is not None:
            pulumi.set(__self__, "security_gateways_id", security_gateways_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if upstreams is not None:
            pulumi.set(__self__, "upstreams", upstreams)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. User-settable Application resource ID.
        * Must start with a letter.
        * Must contain between 4-63 characters from `/a-z-/`.
        * Must end with a number or letter.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. An arbitrary user-provided name for the Application resource. Cannot exceed 64 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="endpointMatchers")
    def endpoint_matchers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationEndpointMatcherArgs']]]]:
        """
        Required. Endpoint matchers associated with an application.
        A combination of hostname and ports as endpoint matcher is used to match
        the application.
        Match conditions for OR logic.
        An array of match conditions to allow for multiple matching criteria.
        The rule is considered a match if one the conditions are met.
        The conditions can be one of the following combination
        (Hostname), (Hostname & Ports)
        EXAMPLES:
        Hostname - ("*.abc.com"), ("xyz.abc.com")
        Hostname and Ports - ("abc.com" and "22"), ("abc.com" and "22,33") etc
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint_matchers")

    @endpoint_matchers.setter
    def endpoint_matchers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationEndpointMatcherArgs']]]]):
        pulumi.set(self, "endpoint_matchers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="securityGatewaysId")
    def security_gateways_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "security_gateways_id")

    @security_gateways_id.setter
    def security_gateways_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_gateways_id", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Timestamp when the resource was last modified.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def upstreams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationUpstreamArgs']]]]:
        """
        Optional. List of which upstream resource(s) to forward traffic to.
        """
        return pulumi.get(self, "upstreams")

    @upstreams.setter
    def upstreams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationUpstreamArgs']]]]):
        pulumi.set(self, "upstreams", value)


@pulumi.type_token("gcp:beyondcorp/application:Application")
class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_matchers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationEndpointMatcherArgs', 'ApplicationEndpointMatcherArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 security_gateways_id: Optional[pulumi.Input[builtins.str]] = None,
                 upstreams: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationUpstreamArgs', 'ApplicationUpstreamArgsDict']]]]] = None,
                 __props__=None):
        """
        > **Warning:** `beyondcorp.Application` is deprecated. Use `beyondcorp.SecurityGatewayApplication` instead.

        Specifies application endpoint(s) to protect behind a Security Gateway.

        ## Example Usage

        ### Beyondcorp Application Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.beyondcorp.SecurityGateway("default",
            security_gateway_id="default",
            display_name="My Security Gateway resource",
            hubs=[{
                "region": "us-central1",
            }])
        example = gcp.beyondcorp.Application("example",
            security_gateways_id=default.security_gateway_id,
            application_id="google",
            endpoint_matchers=[{
                "hostname": "google.com",
            }])
        ```
        ### Beyondcorp Application Vpc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.beyondcorp.SecurityGateway("default",
            security_gateway_id="default",
            display_name="My Security Gateway resource",
            hubs=[{
                "region": "us-central1",
            }])
        example = gcp.beyondcorp.Application("example",
            security_gateways_id=default.security_gateway_id,
            application_id="my-vm-service",
            endpoint_matchers=[{
                "hostname": "my-vm-service.com",
            }],
            upstreams=[{
                "egress_policy": {
                    "regions": ["us-central1"],
                },
                "network": {
                    "name": f"projects/{project.project_id}/global/networks/default",
                },
            }])
        ```

        ## Import

        Application can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/securityGateways/{{security_gateways_id}}/applications/{{application_id}}`

        * `{{project}}/{{security_gateways_id}}/{{application_id}}`

        * `{{security_gateways_id}}/{{application_id}}`

        When using the `pulumi import` command, Application can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:beyondcorp/application:Application default projects/{{project}}/locations/global/securityGateways/{{security_gateways_id}}/applications/{{application_id}}
        ```

        ```sh
        $ pulumi import gcp:beyondcorp/application:Application default {{project}}/{{security_gateways_id}}/{{application_id}}
        ```

        ```sh
        $ pulumi import gcp:beyondcorp/application:Application default {{security_gateways_id}}/{{application_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: Optional. User-settable Application resource ID.
               * Must start with a letter.
               * Must contain between 4-63 characters from `/a-z-/`.
               * Must end with a number or letter.
        :param pulumi.Input[builtins.str] display_name: Optional. An arbitrary user-provided name for the Application resource. Cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationEndpointMatcherArgs', 'ApplicationEndpointMatcherArgsDict']]]] endpoint_matchers: Required. Endpoint matchers associated with an application.
               A combination of hostname and ports as endpoint matcher is used to match
               the application.
               Match conditions for OR logic.
               An array of match conditions to allow for multiple matching criteria.
               The rule is considered a match if one the conditions are met.
               The conditions can be one of the following combination
               (Hostname), (Hostname & Ports)
               EXAMPLES:
               Hostname - ("*.abc.com"), ("xyz.abc.com")
               Hostname and Ports - ("abc.com" and "22"), ("abc.com" and "22,33") etc
               Structure is documented below.
        :param pulumi.Input[builtins.str] security_gateways_id: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationUpstreamArgs', 'ApplicationUpstreamArgsDict']]]] upstreams: Optional. List of which upstream resource(s) to forward traffic to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Warning:** `beyondcorp.Application` is deprecated. Use `beyondcorp.SecurityGatewayApplication` instead.

        Specifies application endpoint(s) to protect behind a Security Gateway.

        ## Example Usage

        ### Beyondcorp Application Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.beyondcorp.SecurityGateway("default",
            security_gateway_id="default",
            display_name="My Security Gateway resource",
            hubs=[{
                "region": "us-central1",
            }])
        example = gcp.beyondcorp.Application("example",
            security_gateways_id=default.security_gateway_id,
            application_id="google",
            endpoint_matchers=[{
                "hostname": "google.com",
            }])
        ```
        ### Beyondcorp Application Vpc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.beyondcorp.SecurityGateway("default",
            security_gateway_id="default",
            display_name="My Security Gateway resource",
            hubs=[{
                "region": "us-central1",
            }])
        example = gcp.beyondcorp.Application("example",
            security_gateways_id=default.security_gateway_id,
            application_id="my-vm-service",
            endpoint_matchers=[{
                "hostname": "my-vm-service.com",
            }],
            upstreams=[{
                "egress_policy": {
                    "regions": ["us-central1"],
                },
                "network": {
                    "name": f"projects/{project.project_id}/global/networks/default",
                },
            }])
        ```

        ## Import

        Application can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/securityGateways/{{security_gateways_id}}/applications/{{application_id}}`

        * `{{project}}/{{security_gateways_id}}/{{application_id}}`

        * `{{security_gateways_id}}/{{application_id}}`

        When using the `pulumi import` command, Application can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:beyondcorp/application:Application default projects/{{project}}/locations/global/securityGateways/{{security_gateways_id}}/applications/{{application_id}}
        ```

        ```sh
        $ pulumi import gcp:beyondcorp/application:Application default {{project}}/{{security_gateways_id}}/{{application_id}}
        ```

        ```sh
        $ pulumi import gcp:beyondcorp/application:Application default {{security_gateways_id}}/{{application_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_matchers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationEndpointMatcherArgs', 'ApplicationEndpointMatcherArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 security_gateways_id: Optional[pulumi.Input[builtins.str]] = None,
                 upstreams: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationUpstreamArgs', 'ApplicationUpstreamArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["display_name"] = display_name
            if endpoint_matchers is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_matchers'")
            __props__.__dict__["endpoint_matchers"] = endpoint_matchers
            __props__.__dict__["project"] = project
            if security_gateways_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_gateways_id'")
            __props__.__dict__["security_gateways_id"] = security_gateways_id
            __props__.__dict__["upstreams"] = upstreams
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(Application, __self__).__init__(
            'gcp:beyondcorp/application:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_matchers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationEndpointMatcherArgs', 'ApplicationEndpointMatcherArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            security_gateways_id: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            upstreams: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationUpstreamArgs', 'ApplicationUpstreamArgsDict']]]]] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: Optional. User-settable Application resource ID.
               * Must start with a letter.
               * Must contain between 4-63 characters from `/a-z-/`.
               * Must end with a number or letter.
        :param pulumi.Input[builtins.str] create_time: Output only. Timestamp when the resource was created.
        :param pulumi.Input[builtins.str] display_name: Optional. An arbitrary user-provided name for the Application resource. Cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationEndpointMatcherArgs', 'ApplicationEndpointMatcherArgsDict']]]] endpoint_matchers: Required. Endpoint matchers associated with an application.
               A combination of hostname and ports as endpoint matcher is used to match
               the application.
               Match conditions for OR logic.
               An array of match conditions to allow for multiple matching criteria.
               The rule is considered a match if one the conditions are met.
               The conditions can be one of the following combination
               (Hostname), (Hostname & Ports)
               EXAMPLES:
               Hostname - ("*.abc.com"), ("xyz.abc.com")
               Hostname and Ports - ("abc.com" and "22"), ("abc.com" and "22,33") etc
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Identifier. Name of the resource.
        :param pulumi.Input[builtins.str] security_gateways_id: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] update_time: Output only. Timestamp when the resource was last modified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationUpstreamArgs', 'ApplicationUpstreamArgsDict']]]] upstreams: Optional. List of which upstream resource(s) to forward traffic to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationState.__new__(_ApplicationState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["endpoint_matchers"] = endpoint_matchers
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["security_gateways_id"] = security_gateways_id
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["upstreams"] = upstreams
        return Application(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        Optional. User-settable Application resource ID.
        * Must start with a letter.
        * Must contain between 4-63 characters from `/a-z-/`.
        * Must end with a number or letter.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. An arbitrary user-provided name for the Application resource. Cannot exceed 64 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endpointMatchers")
    def endpoint_matchers(self) -> pulumi.Output[Sequence['outputs.ApplicationEndpointMatcher']]:
        """
        Required. Endpoint matchers associated with an application.
        A combination of hostname and ports as endpoint matcher is used to match
        the application.
        Match conditions for OR logic.
        An array of match conditions to allow for multiple matching criteria.
        The rule is considered a match if one the conditions are met.
        The conditions can be one of the following combination
        (Hostname), (Hostname & Ports)
        EXAMPLES:
        Hostname - ("*.abc.com"), ("xyz.abc.com")
        Hostname and Ports - ("abc.com" and "22"), ("abc.com" and "22,33") etc
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint_matchers")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="securityGatewaysId")
    def security_gateways_id(self) -> pulumi.Output[builtins.str]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "security_gateways_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Timestamp when the resource was last modified.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def upstreams(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationUpstream']]]:
        """
        Optional. List of which upstream resource(s) to forward traffic to.
        """
        return pulumi.get(self, "upstreams")

