# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAppConnectionResult',
    'AwaitableGetAppConnectionResult',
    'get_app_connection',
    'get_app_connection_output',
]

@pulumi.output_type
class GetAppConnectionResult:
    """
    A collection of values returned by getAppConnection.
    """
    def __init__(__self__, application_endpoints=None, connectors=None, display_name=None, effective_labels=None, gateways=None, id=None, labels=None, name=None, project=None, pulumi_labels=None, region=None, type=None):
        if application_endpoints and not isinstance(application_endpoints, list):
            raise TypeError("Expected argument 'application_endpoints' to be a list")
        pulumi.set(__self__, "application_endpoints", application_endpoints)
        if connectors and not isinstance(connectors, list):
            raise TypeError("Expected argument 'connectors' to be a list")
        pulumi.set(__self__, "connectors", connectors)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if gateways and not isinstance(gateways, list):
            raise TypeError("Expected argument 'gateways' to be a list")
        pulumi.set(__self__, "gateways", gateways)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="applicationEndpoints")
    def application_endpoints(self) -> Sequence['outputs.GetAppConnectionApplicationEndpointResult']:
        return pulumi.get(self, "application_endpoints")

    @property
    @pulumi.getter
    def connectors(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "connectors")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def gateways(self) -> Sequence['outputs.GetAppConnectionGatewayResult']:
        return pulumi.get(self, "gateways")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")


class AwaitableGetAppConnectionResult(GetAppConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppConnectionResult(
            application_endpoints=self.application_endpoints,
            connectors=self.connectors,
            display_name=self.display_name,
            effective_labels=self.effective_labels,
            gateways=self.gateways,
            id=self.id,
            labels=self.labels,
            name=self.name,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            region=self.region,
            type=self.type)


def get_app_connection(name: Optional[builtins.str] = None,
                       project: Optional[builtins.str] = None,
                       region: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppConnectionResult:
    """
    Get information about a Google BeyondCorp App Connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_beyondcorp_app_connection = gcp.beyondcorp.get_app_connection(name="my-beyondcorp-app-connection")
    ```


    :param builtins.str name: The name of the App Connection.
           
           - - -
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param builtins.str region: The region in which the resource belongs. If it
           is not provided, the provider region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:beyondcorp/getAppConnection:getAppConnection', __args__, opts=opts, typ=GetAppConnectionResult).value

    return AwaitableGetAppConnectionResult(
        application_endpoints=pulumi.get(__ret__, 'application_endpoints'),
        connectors=pulumi.get(__ret__, 'connectors'),
        display_name=pulumi.get(__ret__, 'display_name'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        gateways=pulumi.get(__ret__, 'gateways'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        region=pulumi.get(__ret__, 'region'),
        type=pulumi.get(__ret__, 'type'))
def get_app_connection_output(name: Optional[pulumi.Input[builtins.str]] = None,
                              project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppConnectionResult]:
    """
    Get information about a Google BeyondCorp App Connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_beyondcorp_app_connection = gcp.beyondcorp.get_app_connection(name="my-beyondcorp-app-connection")
    ```


    :param builtins.str name: The name of the App Connection.
           
           - - -
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param builtins.str region: The region in which the resource belongs. If it
           is not provided, the provider region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:beyondcorp/getAppConnection:getAppConnection', __args__, opts=opts, typ=GetAppConnectionResult)
    return __ret__.apply(lambda __response__: GetAppConnectionResult(
        application_endpoints=pulumi.get(__response__, 'application_endpoints'),
        connectors=pulumi.get(__response__, 'connectors'),
        display_name=pulumi.get(__response__, 'display_name'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        gateways=pulumi.get(__response__, 'gateways'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        region=pulumi.get(__response__, 'region'),
        type=pulumi.get(__response__, 'type')))
