# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityGatewayArgs', 'SecurityGateway']

@pulumi.input_type
class SecurityGatewayArgs:
    def __init__(__self__, *,
                 security_gateway_id: pulumi.Input[builtins.str],
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 hubs: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityGatewayHubArgs']]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SecurityGateway resource.
        :param pulumi.Input[builtins.str] security_gateway_id: Optional. User-settable SecurityGateway resource ID.
               * Must start with a letter.
               * Must contain between 4-63 characters from `/a-z-/`.
               * Must end with a number or letter.
               
               
               - - -
        :param pulumi.Input[builtins.str] display_name: Optional. An arbitrary user-provided name for the SecurityGateway.
               Cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityGatewayHubArgs']]] hubs: Optional. Map of Hubs that represents regional data path deployment with GCP region
               as a key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: (Optional, Deprecated)
               Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. Must be omitted or set to `global`.
               
               > **Warning:** `location` is deprecated and will be removed in a future major release.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "security_gateway_id", security_gateway_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if hubs is not None:
            pulumi.set(__self__, "hubs", hubs)
        if location is not None:
            warnings.warn("""`location` is deprecated and will be removed in a future major release.""", DeprecationWarning)
            pulumi.log.warn("""location is deprecated: `location` is deprecated and will be removed in a future major release.""")
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="securityGatewayId")
    def security_gateway_id(self) -> pulumi.Input[builtins.str]:
        """
        Optional. User-settable SecurityGateway resource ID.
        * Must start with a letter.
        * Must contain between 4-63 characters from `/a-z-/`.
        * Must end with a number or letter.


        - - -
        """
        return pulumi.get(self, "security_gateway_id")

    @security_gateway_id.setter
    def security_gateway_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "security_gateway_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. An arbitrary user-provided name for the SecurityGateway.
        Cannot exceed 64 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def hubs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityGatewayHubArgs']]]]:
        """
        Optional. Map of Hubs that represents regional data path deployment with GCP region
        as a key.
        Structure is documented below.
        """
        return pulumi.get(self, "hubs")

    @hubs.setter
    def hubs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityGatewayHubArgs']]]]):
        pulumi.set(self, "hubs", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`location` is deprecated and will be removed in a future major release.""")
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional, Deprecated)
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. Must be omitted or set to `global`.

        > **Warning:** `location` is deprecated and will be removed in a future major release.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _SecurityGatewayState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 delegating_service_account: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 external_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 hubs: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityGatewayHubArgs']]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 security_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityGateway resources.
        :param pulumi.Input[builtins.str] create_time: Output only. Timestamp when the resource was created.
        :param pulumi.Input[builtins.str] delegating_service_account: Service account used for operations that involve resources in consumer projects.
        :param pulumi.Input[builtins.str] display_name: Optional. An arbitrary user-provided name for the SecurityGateway.
               Cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] external_ips: Output only. IP addresses that will be used for establishing
               connection to the endpoints.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityGatewayHubArgs']]] hubs: Optional. Map of Hubs that represents regional data path deployment with GCP region
               as a key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: (Optional, Deprecated)
               Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. Must be omitted or set to `global`.
               
               > **Warning:** `location` is deprecated and will be removed in a future major release.
        :param pulumi.Input[builtins.str] name: Identifier. Name of the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] security_gateway_id: Optional. User-settable SecurityGateway resource ID.
               * Must start with a letter.
               * Must contain between 4-63 characters from `/a-z-/`.
               * Must end with a number or letter.
               
               
               - - -
        :param pulumi.Input[builtins.str] state: Output only. The operational state of the SecurityGateway.
               Possible values:
               STATE_UNSPECIFIED
               CREATING
               UPDATING
               DELETING
               RUNNING
               DOWN
               ERROR
        :param pulumi.Input[builtins.str] update_time: Output only. Timestamp when the resource was last modified.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delegating_service_account is not None:
            pulumi.set(__self__, "delegating_service_account", delegating_service_account)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_ips is not None:
            pulumi.set(__self__, "external_ips", external_ips)
        if hubs is not None:
            pulumi.set(__self__, "hubs", hubs)
        if location is not None:
            warnings.warn("""`location` is deprecated and will be removed in a future major release.""", DeprecationWarning)
            pulumi.log.warn("""location is deprecated: `location` is deprecated and will be removed in a future major release.""")
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if security_gateway_id is not None:
            pulumi.set(__self__, "security_gateway_id", security_gateway_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="delegatingServiceAccount")
    def delegating_service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service account used for operations that involve resources in consumer projects.
        """
        return pulumi.get(self, "delegating_service_account")

    @delegating_service_account.setter
    def delegating_service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delegating_service_account", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. An arbitrary user-provided name for the SecurityGateway.
        Cannot exceed 64 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="externalIps")
    def external_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Output only. IP addresses that will be used for establishing
        connection to the endpoints.
        """
        return pulumi.get(self, "external_ips")

    @external_ips.setter
    def external_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "external_ips", value)

    @property
    @pulumi.getter
    def hubs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityGatewayHubArgs']]]]:
        """
        Optional. Map of Hubs that represents regional data path deployment with GCP region
        as a key.
        Structure is documented below.
        """
        return pulumi.get(self, "hubs")

    @hubs.setter
    def hubs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityGatewayHubArgs']]]]):
        pulumi.set(self, "hubs", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`location` is deprecated and will be removed in a future major release.""")
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional, Deprecated)
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. Must be omitted or set to `global`.

        > **Warning:** `location` is deprecated and will be removed in a future major release.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="securityGatewayId")
    def security_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. User-settable SecurityGateway resource ID.
        * Must start with a letter.
        * Must contain between 4-63 characters from `/a-z-/`.
        * Must end with a number or letter.


        - - -
        """
        return pulumi.get(self, "security_gateway_id")

    @security_gateway_id.setter
    def security_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_gateway_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The operational state of the SecurityGateway.
        Possible values:
        STATE_UNSPECIFIED
        CREATING
        UPDATING
        DELETING
        RUNNING
        DOWN
        ERROR
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Timestamp when the resource was last modified.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:beyondcorp/securityGateway:SecurityGateway")
class SecurityGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 hubs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityGatewayHubArgs', 'SecurityGatewayHubArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 security_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Deployment of Security Gateway.

        ## Example Usage

        ### Beyondcorp Security Gateway Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.beyondcorp.SecurityGateway("example",
            security_gateway_id="default",
            display_name="My Security Gateway resource",
            hubs=[{
                "region": "us-central1",
            }])
        ```

        ## Import

        SecurityGateway can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/securityGateways/{{security_gateway_id}}`

        * `{{project}}/{{location}}/{{security_gateway_id}}`

        * `{{location}}/{{security_gateway_id}}`

        When using the `pulumi import` command, SecurityGateway can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:beyondcorp/securityGateway:SecurityGateway default projects/{{project}}/locations/{{location}}/securityGateways/{{security_gateway_id}}
        ```

        ```sh
        $ pulumi import gcp:beyondcorp/securityGateway:SecurityGateway default {{project}}/{{location}}/{{security_gateway_id}}
        ```

        ```sh
        $ pulumi import gcp:beyondcorp/securityGateway:SecurityGateway default {{location}}/{{security_gateway_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: Optional. An arbitrary user-provided name for the SecurityGateway.
               Cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityGatewayHubArgs', 'SecurityGatewayHubArgsDict']]]] hubs: Optional. Map of Hubs that represents regional data path deployment with GCP region
               as a key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: (Optional, Deprecated)
               Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. Must be omitted or set to `global`.
               
               > **Warning:** `location` is deprecated and will be removed in a future major release.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] security_gateway_id: Optional. User-settable SecurityGateway resource ID.
               * Must start with a letter.
               * Must contain between 4-63 characters from `/a-z-/`.
               * Must end with a number or letter.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Deployment of Security Gateway.

        ## Example Usage

        ### Beyondcorp Security Gateway Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.beyondcorp.SecurityGateway("example",
            security_gateway_id="default",
            display_name="My Security Gateway resource",
            hubs=[{
                "region": "us-central1",
            }])
        ```

        ## Import

        SecurityGateway can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/securityGateways/{{security_gateway_id}}`

        * `{{project}}/{{location}}/{{security_gateway_id}}`

        * `{{location}}/{{security_gateway_id}}`

        When using the `pulumi import` command, SecurityGateway can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:beyondcorp/securityGateway:SecurityGateway default projects/{{project}}/locations/{{location}}/securityGateways/{{security_gateway_id}}
        ```

        ```sh
        $ pulumi import gcp:beyondcorp/securityGateway:SecurityGateway default {{project}}/{{location}}/{{security_gateway_id}}
        ```

        ```sh
        $ pulumi import gcp:beyondcorp/securityGateway:SecurityGateway default {{location}}/{{security_gateway_id}}
        ```

        :param str resource_name: The name of the resource.
        :param SecurityGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 hubs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityGatewayHubArgs', 'SecurityGatewayHubArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 security_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityGatewayArgs.__new__(SecurityGatewayArgs)

            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["hubs"] = hubs
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if security_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_gateway_id'")
            __props__.__dict__["security_gateway_id"] = security_gateway_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delegating_service_account"] = None
            __props__.__dict__["external_ips"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        super(SecurityGateway, __self__).__init__(
            'gcp:beyondcorp/securityGateway:SecurityGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            delegating_service_account: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            external_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            hubs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityGatewayHubArgs', 'SecurityGatewayHubArgsDict']]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            security_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'SecurityGateway':
        """
        Get an existing SecurityGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Output only. Timestamp when the resource was created.
        :param pulumi.Input[builtins.str] delegating_service_account: Service account used for operations that involve resources in consumer projects.
        :param pulumi.Input[builtins.str] display_name: Optional. An arbitrary user-provided name for the SecurityGateway.
               Cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] external_ips: Output only. IP addresses that will be used for establishing
               connection to the endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityGatewayHubArgs', 'SecurityGatewayHubArgsDict']]]] hubs: Optional. Map of Hubs that represents regional data path deployment with GCP region
               as a key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: (Optional, Deprecated)
               Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. Must be omitted or set to `global`.
               
               > **Warning:** `location` is deprecated and will be removed in a future major release.
        :param pulumi.Input[builtins.str] name: Identifier. Name of the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] security_gateway_id: Optional. User-settable SecurityGateway resource ID.
               * Must start with a letter.
               * Must contain between 4-63 characters from `/a-z-/`.
               * Must end with a number or letter.
               
               
               - - -
        :param pulumi.Input[builtins.str] state: Output only. The operational state of the SecurityGateway.
               Possible values:
               STATE_UNSPECIFIED
               CREATING
               UPDATING
               DELETING
               RUNNING
               DOWN
               ERROR
        :param pulumi.Input[builtins.str] update_time: Output only. Timestamp when the resource was last modified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityGatewayState.__new__(_SecurityGatewayState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delegating_service_account"] = delegating_service_account
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["external_ips"] = external_ips
        __props__.__dict__["hubs"] = hubs
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["security_gateway_id"] = security_gateway_id
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return SecurityGateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="delegatingServiceAccount")
    def delegating_service_account(self) -> pulumi.Output[builtins.str]:
        """
        Service account used for operations that involve resources in consumer projects.
        """
        return pulumi.get(self, "delegating_service_account")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. An arbitrary user-provided name for the SecurityGateway.
        Cannot exceed 64 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalIps")
    def external_ips(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Output only. IP addresses that will be used for establishing
        connection to the endpoints.
        """
        return pulumi.get(self, "external_ips")

    @property
    @pulumi.getter
    def hubs(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityGatewayHub']]]:
        """
        Optional. Map of Hubs that represents regional data path deployment with GCP region
        as a key.
        Structure is documented below.
        """
        return pulumi.get(self, "hubs")

    @property
    @pulumi.getter
    @_utilities.deprecated("""`location` is deprecated and will be removed in a future major release.""")
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Optional, Deprecated)
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. Must be omitted or set to `global`.

        > **Warning:** `location` is deprecated and will be removed in a future major release.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="securityGatewayId")
    def security_gateway_id(self) -> pulumi.Output[builtins.str]:
        """
        Optional. User-settable SecurityGateway resource ID.
        * Must start with a letter.
        * Must contain between 4-63 characters from `/a-z-/`.
        * Must end with a number or letter.


        - - -
        """
        return pulumi.get(self, "security_gateway_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The operational state of the SecurityGateway.
        Possible values:
        STATE_UNSPECIFIED
        CREATING
        UPDATING
        DELETING
        RUNNING
        DOWN
        ERROR
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Timestamp when the resource was last modified.
        """
        return pulumi.get(self, "update_time")

