# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input['ConnectionAwsArgs']] = None,
                 azure: Optional[pulumi.Input['ConnectionAzureArgs']] = None,
                 cloud_resource: Optional[pulumi.Input['ConnectionCloudResourceArgs']] = None,
                 cloud_spanner: Optional[pulumi.Input['ConnectionCloudSpannerArgs']] = None,
                 cloud_sql: Optional[pulumi.Input['ConnectionCloudSqlArgs']] = None,
                 connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 friendly_name: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 spark: Optional[pulumi.Input['ConnectionSparkArgs']] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input['ConnectionAwsArgs'] aws: Connection properties specific to Amazon Web Services.
               Structure is documented below.
        :param pulumi.Input['ConnectionAzureArgs'] azure: Container for connection properties specific to Azure.
               Structure is documented below.
        :param pulumi.Input['ConnectionCloudResourceArgs'] cloud_resource: Container for connection properties for delegation of access to GCP resources.
               Structure is documented below.
        :param pulumi.Input['ConnectionCloudSpannerArgs'] cloud_spanner: Connection properties specific to Cloud Spanner
               Structure is documented below.
        :param pulumi.Input['ConnectionCloudSqlArgs'] cloud_sql: Connection properties specific to the Cloud SQL.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connection_id: Optional connection id that should be assigned to the created connection.
        :param pulumi.Input[builtins.str] description: A descriptive description for the connection
        :param pulumi.Input[builtins.str] friendly_name: A descriptive name for the connection
        :param pulumi.Input[builtins.str] kms_key_name: Optional. The Cloud KMS key that is used for encryption.
               Example: projects/[kms_project_id]/locations/[region]/keyRings/[key_region]/cryptoKeys/[key]
        :param pulumi.Input[builtins.str] location: The geographic location where the connection should reside.
               Cloud SQL instance must be in the same location as the connection
               with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
               Examples: US, EU, asia-northeast1, us-central1, europe-west1.
               Spanner Connections same as spanner region
               AWS allowed regions are aws-us-east-1
               Azure allowed regions are azure-eastus2
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ConnectionSparkArgs'] spark: Container for connection properties to execute stored procedures for Apache Spark. resources.
               Structure is documented below.
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure is not None:
            pulumi.set(__self__, "azure", azure)
        if cloud_resource is not None:
            pulumi.set(__self__, "cloud_resource", cloud_resource)
        if cloud_spanner is not None:
            pulumi.set(__self__, "cloud_spanner", cloud_spanner)
        if cloud_sql is not None:
            pulumi.set(__self__, "cloud_sql", cloud_sql)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if spark is not None:
            pulumi.set(__self__, "spark", spark)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['ConnectionAwsArgs']]:
        """
        Connection properties specific to Amazon Web Services.
        Structure is documented below.
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['ConnectionAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter
    def azure(self) -> Optional[pulumi.Input['ConnectionAzureArgs']]:
        """
        Container for connection properties specific to Azure.
        Structure is documented below.
        """
        return pulumi.get(self, "azure")

    @azure.setter
    def azure(self, value: Optional[pulumi.Input['ConnectionAzureArgs']]):
        pulumi.set(self, "azure", value)

    @property
    @pulumi.getter(name="cloudResource")
    def cloud_resource(self) -> Optional[pulumi.Input['ConnectionCloudResourceArgs']]:
        """
        Container for connection properties for delegation of access to GCP resources.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_resource")

    @cloud_resource.setter
    def cloud_resource(self, value: Optional[pulumi.Input['ConnectionCloudResourceArgs']]):
        pulumi.set(self, "cloud_resource", value)

    @property
    @pulumi.getter(name="cloudSpanner")
    def cloud_spanner(self) -> Optional[pulumi.Input['ConnectionCloudSpannerArgs']]:
        """
        Connection properties specific to Cloud Spanner
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_spanner")

    @cloud_spanner.setter
    def cloud_spanner(self, value: Optional[pulumi.Input['ConnectionCloudSpannerArgs']]):
        pulumi.set(self, "cloud_spanner", value)

    @property
    @pulumi.getter(name="cloudSql")
    def cloud_sql(self) -> Optional[pulumi.Input['ConnectionCloudSqlArgs']]:
        """
        Connection properties specific to the Cloud SQL.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql")

    @cloud_sql.setter
    def cloud_sql(self, value: Optional[pulumi.Input['ConnectionCloudSqlArgs']]):
        pulumi.set(self, "cloud_sql", value)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional connection id that should be assigned to the created connection.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A descriptive description for the connection
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A descriptive name for the connection
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The Cloud KMS key that is used for encryption.
        Example: projects/[kms_project_id]/locations/[region]/keyRings/[key_region]/cryptoKeys/[key]
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The geographic location where the connection should reside.
        Cloud SQL instance must be in the same location as the connection
        with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
        Examples: US, EU, asia-northeast1, us-central1, europe-west1.
        Spanner Connections same as spanner region
        AWS allowed regions are aws-us-east-1
        Azure allowed regions are azure-eastus2
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def spark(self) -> Optional[pulumi.Input['ConnectionSparkArgs']]:
        """
        Container for connection properties to execute stored procedures for Apache Spark. resources.
        Structure is documented below.
        """
        return pulumi.get(self, "spark")

    @spark.setter
    def spark(self, value: Optional[pulumi.Input['ConnectionSparkArgs']]):
        pulumi.set(self, "spark", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input['ConnectionAwsArgs']] = None,
                 azure: Optional[pulumi.Input['ConnectionAzureArgs']] = None,
                 cloud_resource: Optional[pulumi.Input['ConnectionCloudResourceArgs']] = None,
                 cloud_spanner: Optional[pulumi.Input['ConnectionCloudSpannerArgs']] = None,
                 cloud_sql: Optional[pulumi.Input['ConnectionCloudSqlArgs']] = None,
                 connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 friendly_name: Optional[pulumi.Input[builtins.str]] = None,
                 has_credential: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 spark: Optional[pulumi.Input['ConnectionSparkArgs']] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input['ConnectionAwsArgs'] aws: Connection properties specific to Amazon Web Services.
               Structure is documented below.
        :param pulumi.Input['ConnectionAzureArgs'] azure: Container for connection properties specific to Azure.
               Structure is documented below.
        :param pulumi.Input['ConnectionCloudResourceArgs'] cloud_resource: Container for connection properties for delegation of access to GCP resources.
               Structure is documented below.
        :param pulumi.Input['ConnectionCloudSpannerArgs'] cloud_spanner: Connection properties specific to Cloud Spanner
               Structure is documented below.
        :param pulumi.Input['ConnectionCloudSqlArgs'] cloud_sql: Connection properties specific to the Cloud SQL.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connection_id: Optional connection id that should be assigned to the created connection.
        :param pulumi.Input[builtins.str] description: A descriptive description for the connection
        :param pulumi.Input[builtins.str] friendly_name: A descriptive name for the connection
        :param pulumi.Input[builtins.bool] has_credential: True if the connection has credential assigned.
        :param pulumi.Input[builtins.str] kms_key_name: Optional. The Cloud KMS key that is used for encryption.
               Example: projects/[kms_project_id]/locations/[region]/keyRings/[key_region]/cryptoKeys/[key]
        :param pulumi.Input[builtins.str] location: The geographic location where the connection should reside.
               Cloud SQL instance must be in the same location as the connection
               with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
               Examples: US, EU, asia-northeast1, us-central1, europe-west1.
               Spanner Connections same as spanner region
               AWS allowed regions are aws-us-east-1
               Azure allowed regions are azure-eastus2
        :param pulumi.Input[builtins.str] name: The resource name of the connection in the form of:
               "projects/{project_id}/locations/{location_id}/connections/{connectionId}"
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ConnectionSparkArgs'] spark: Container for connection properties to execute stored procedures for Apache Spark. resources.
               Structure is documented below.
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure is not None:
            pulumi.set(__self__, "azure", azure)
        if cloud_resource is not None:
            pulumi.set(__self__, "cloud_resource", cloud_resource)
        if cloud_spanner is not None:
            pulumi.set(__self__, "cloud_spanner", cloud_spanner)
        if cloud_sql is not None:
            pulumi.set(__self__, "cloud_sql", cloud_sql)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if has_credential is not None:
            pulumi.set(__self__, "has_credential", has_credential)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if spark is not None:
            pulumi.set(__self__, "spark", spark)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['ConnectionAwsArgs']]:
        """
        Connection properties specific to Amazon Web Services.
        Structure is documented below.
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['ConnectionAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter
    def azure(self) -> Optional[pulumi.Input['ConnectionAzureArgs']]:
        """
        Container for connection properties specific to Azure.
        Structure is documented below.
        """
        return pulumi.get(self, "azure")

    @azure.setter
    def azure(self, value: Optional[pulumi.Input['ConnectionAzureArgs']]):
        pulumi.set(self, "azure", value)

    @property
    @pulumi.getter(name="cloudResource")
    def cloud_resource(self) -> Optional[pulumi.Input['ConnectionCloudResourceArgs']]:
        """
        Container for connection properties for delegation of access to GCP resources.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_resource")

    @cloud_resource.setter
    def cloud_resource(self, value: Optional[pulumi.Input['ConnectionCloudResourceArgs']]):
        pulumi.set(self, "cloud_resource", value)

    @property
    @pulumi.getter(name="cloudSpanner")
    def cloud_spanner(self) -> Optional[pulumi.Input['ConnectionCloudSpannerArgs']]:
        """
        Connection properties specific to Cloud Spanner
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_spanner")

    @cloud_spanner.setter
    def cloud_spanner(self, value: Optional[pulumi.Input['ConnectionCloudSpannerArgs']]):
        pulumi.set(self, "cloud_spanner", value)

    @property
    @pulumi.getter(name="cloudSql")
    def cloud_sql(self) -> Optional[pulumi.Input['ConnectionCloudSqlArgs']]:
        """
        Connection properties specific to the Cloud SQL.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql")

    @cloud_sql.setter
    def cloud_sql(self, value: Optional[pulumi.Input['ConnectionCloudSqlArgs']]):
        pulumi.set(self, "cloud_sql", value)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional connection id that should be assigned to the created connection.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A descriptive description for the connection
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A descriptive name for the connection
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="hasCredential")
    def has_credential(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        True if the connection has credential assigned.
        """
        return pulumi.get(self, "has_credential")

    @has_credential.setter
    def has_credential(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "has_credential", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The Cloud KMS key that is used for encryption.
        Example: projects/[kms_project_id]/locations/[region]/keyRings/[key_region]/cryptoKeys/[key]
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The geographic location where the connection should reside.
        Cloud SQL instance must be in the same location as the connection
        with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
        Examples: US, EU, asia-northeast1, us-central1, europe-west1.
        Spanner Connections same as spanner region
        AWS allowed regions are aws-us-east-1
        Azure allowed regions are azure-eastus2
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the connection in the form of:
        "projects/{project_id}/locations/{location_id}/connections/{connectionId}"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def spark(self) -> Optional[pulumi.Input['ConnectionSparkArgs']]:
        """
        Container for connection properties to execute stored procedures for Apache Spark. resources.
        Structure is documented below.
        """
        return pulumi.get(self, "spark")

    @spark.setter
    def spark(self, value: Optional[pulumi.Input['ConnectionSparkArgs']]):
        pulumi.set(self, "spark", value)


@pulumi.type_token("gcp:bigquery/connection:Connection")
class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[Union['ConnectionAwsArgs', 'ConnectionAwsArgsDict']]] = None,
                 azure: Optional[pulumi.Input[Union['ConnectionAzureArgs', 'ConnectionAzureArgsDict']]] = None,
                 cloud_resource: Optional[pulumi.Input[Union['ConnectionCloudResourceArgs', 'ConnectionCloudResourceArgsDict']]] = None,
                 cloud_spanner: Optional[pulumi.Input[Union['ConnectionCloudSpannerArgs', 'ConnectionCloudSpannerArgsDict']]] = None,
                 cloud_sql: Optional[pulumi.Input[Union['ConnectionCloudSqlArgs', 'ConnectionCloudSqlArgsDict']]] = None,
                 connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 friendly_name: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 spark: Optional[pulumi.Input[Union['ConnectionSparkArgs', 'ConnectionSparkArgsDict']]] = None,
                 __props__=None):
        """
        A connection allows BigQuery connections to external data sources..

        To get more information about Connection, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/bigqueryconnection/rest/v1/projects.locations.connections/create)
        * How-to Guides
            * [Cloud SQL federated queries](https://cloud.google.com/bigquery/docs/cloud-sql-federated-queries)

        ## Example Usage

        ### Bigquery Connection Cloud Resource

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="US",
            friendly_name="👋",
            description="a riveting description",
            cloud_resource={})
        ```
        ### Bigquery Connection Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        instance = gcp.sql.DatabaseInstance("instance",
            name="my-database-instance",
            database_version="POSTGRES_11",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password=pwd.result)
        connection = gcp.bigquery.Connection("connection",
            friendly_name="👋",
            description="a riveting description",
            location="US",
            cloud_sql={
                "instance_id": instance.connection_name,
                "database": db.name,
                "type": "POSTGRES",
                "credential": {
                    "username": user.name,
                    "password": user.password,
                },
            })
        ```
        ### Bigquery Connection Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        instance = gcp.sql.DatabaseInstance("instance",
            name="my-database-instance",
            database_version="POSTGRES_11",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password=pwd.result)
        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="US",
            friendly_name="👋",
            description="a riveting description",
            cloud_sql={
                "instance_id": instance.connection_name,
                "database": db.name,
                "type": "POSTGRES",
                "credential": {
                    "username": user.name,
                    "password": user.password,
                },
            })
        ```
        ### Bigquery Connection Aws

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="aws-us-east-1",
            friendly_name="👋",
            description="a riveting description",
            aws={
                "access_role": {
                    "iam_role_id": "arn:aws:iam::999999999999:role/omnirole",
                },
            })
        ```
        ### Bigquery Connection Azure

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="azure-eastus2",
            friendly_name="👋",
            description="a riveting description",
            azure={
                "customer_tenant_id": "customer-tenant-id",
                "federated_application_client_id": "b43eeeee-eeee-eeee-eeee-a480155501ce",
            })
        ```
        ### Bigquery Connection Cloudspanner

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="US",
            friendly_name="👋",
            description="a riveting description",
            cloud_spanner={
                "database": "projects/project/instances/instance/databases/database",
                "database_role": "database_role",
            })
        ```
        ### Bigquery Connection Cloudspanner Databoost

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="US",
            friendly_name="👋",
            description="a riveting description",
            cloud_spanner={
                "database": "projects/project/instances/instance/databases/database",
                "use_parallelism": True,
                "use_data_boost": True,
                "max_parallelism": 100,
            })
        ```
        ### Bigquery Connection Spark

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataproc.Cluster("basic",
            name="my-connection",
            region="us-central1",
            cluster_config={
                "software_config": {
                    "override_properties": {
                        "dataproc:dataproc.allow.zero.workers": "true",
                    },
                },
                "master_config": {
                    "num_instances": 1,
                    "machine_type": "e2-standard-2",
                    "disk_config": {
                        "boot_disk_size_gb": 35,
                    },
                },
            })
        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="US",
            friendly_name="👋",
            description="a riveting description",
            spark={
                "spark_history_server_config": {
                    "dataproc_cluster": basic.id,
                },
            })
        ```
        ### Bigquery Connection Sql With Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.sql.DatabaseInstance("instance",
            name="my-database-instance",
            region="us-central1",
            database_version="POSTGRES_11",
            settings={
                "tier": "db-f1-micro",
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password="tf-test-my-password_15222")
        bq_connection_cmek = gcp.bigquery.Connection("bq-connection-cmek",
            friendly_name="👋",
            description="a riveting description",
            location="US",
            kms_key_name="projects/project/locations/us-central1/keyRings/us-central1/cryptoKeys/bq-key",
            cloud_sql={
                "instance_id": instance.connection_name,
                "database": db.name,
                "type": "POSTGRES",
                "credential": {
                    "username": user.name,
                    "password": user.password,
                },
            })
        ```

        ## Import

        Connection can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connections/{{connection_id}}`

        * `{{project}}/{{location}}/{{connection_id}}`

        * `{{location}}/{{connection_id}}`

        When using the `pulumi import` command, Connection can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/connection:Connection default projects/{{project}}/locations/{{location}}/connections/{{connection_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/connection:Connection default {{project}}/{{location}}/{{connection_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/connection:Connection default {{location}}/{{connection_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionAwsArgs', 'ConnectionAwsArgsDict']] aws: Connection properties specific to Amazon Web Services.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionAzureArgs', 'ConnectionAzureArgsDict']] azure: Container for connection properties specific to Azure.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionCloudResourceArgs', 'ConnectionCloudResourceArgsDict']] cloud_resource: Container for connection properties for delegation of access to GCP resources.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionCloudSpannerArgs', 'ConnectionCloudSpannerArgsDict']] cloud_spanner: Connection properties specific to Cloud Spanner
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionCloudSqlArgs', 'ConnectionCloudSqlArgsDict']] cloud_sql: Connection properties specific to the Cloud SQL.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connection_id: Optional connection id that should be assigned to the created connection.
        :param pulumi.Input[builtins.str] description: A descriptive description for the connection
        :param pulumi.Input[builtins.str] friendly_name: A descriptive name for the connection
        :param pulumi.Input[builtins.str] kms_key_name: Optional. The Cloud KMS key that is used for encryption.
               Example: projects/[kms_project_id]/locations/[region]/keyRings/[key_region]/cryptoKeys/[key]
        :param pulumi.Input[builtins.str] location: The geographic location where the connection should reside.
               Cloud SQL instance must be in the same location as the connection
               with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
               Examples: US, EU, asia-northeast1, us-central1, europe-west1.
               Spanner Connections same as spanner region
               AWS allowed regions are aws-us-east-1
               Azure allowed regions are azure-eastus2
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ConnectionSparkArgs', 'ConnectionSparkArgsDict']] spark: Container for connection properties to execute stored procedures for Apache Spark. resources.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ConnectionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A connection allows BigQuery connections to external data sources..

        To get more information about Connection, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/bigqueryconnection/rest/v1/projects.locations.connections/create)
        * How-to Guides
            * [Cloud SQL federated queries](https://cloud.google.com/bigquery/docs/cloud-sql-federated-queries)

        ## Example Usage

        ### Bigquery Connection Cloud Resource

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="US",
            friendly_name="👋",
            description="a riveting description",
            cloud_resource={})
        ```
        ### Bigquery Connection Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        instance = gcp.sql.DatabaseInstance("instance",
            name="my-database-instance",
            database_version="POSTGRES_11",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password=pwd.result)
        connection = gcp.bigquery.Connection("connection",
            friendly_name="👋",
            description="a riveting description",
            location="US",
            cloud_sql={
                "instance_id": instance.connection_name,
                "database": db.name,
                "type": "POSTGRES",
                "credential": {
                    "username": user.name,
                    "password": user.password,
                },
            })
        ```
        ### Bigquery Connection Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        instance = gcp.sql.DatabaseInstance("instance",
            name="my-database-instance",
            database_version="POSTGRES_11",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password=pwd.result)
        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="US",
            friendly_name="👋",
            description="a riveting description",
            cloud_sql={
                "instance_id": instance.connection_name,
                "database": db.name,
                "type": "POSTGRES",
                "credential": {
                    "username": user.name,
                    "password": user.password,
                },
            })
        ```
        ### Bigquery Connection Aws

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="aws-us-east-1",
            friendly_name="👋",
            description="a riveting description",
            aws={
                "access_role": {
                    "iam_role_id": "arn:aws:iam::999999999999:role/omnirole",
                },
            })
        ```
        ### Bigquery Connection Azure

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="azure-eastus2",
            friendly_name="👋",
            description="a riveting description",
            azure={
                "customer_tenant_id": "customer-tenant-id",
                "federated_application_client_id": "b43eeeee-eeee-eeee-eeee-a480155501ce",
            })
        ```
        ### Bigquery Connection Cloudspanner

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="US",
            friendly_name="👋",
            description="a riveting description",
            cloud_spanner={
                "database": "projects/project/instances/instance/databases/database",
                "database_role": "database_role",
            })
        ```
        ### Bigquery Connection Cloudspanner Databoost

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="US",
            friendly_name="👋",
            description="a riveting description",
            cloud_spanner={
                "database": "projects/project/instances/instance/databases/database",
                "use_parallelism": True,
                "use_data_boost": True,
                "max_parallelism": 100,
            })
        ```
        ### Bigquery Connection Spark

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataproc.Cluster("basic",
            name="my-connection",
            region="us-central1",
            cluster_config={
                "software_config": {
                    "override_properties": {
                        "dataproc:dataproc.allow.zero.workers": "true",
                    },
                },
                "master_config": {
                    "num_instances": 1,
                    "machine_type": "e2-standard-2",
                    "disk_config": {
                        "boot_disk_size_gb": 35,
                    },
                },
            })
        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="US",
            friendly_name="👋",
            description="a riveting description",
            spark={
                "spark_history_server_config": {
                    "dataproc_cluster": basic.id,
                },
            })
        ```
        ### Bigquery Connection Sql With Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.sql.DatabaseInstance("instance",
            name="my-database-instance",
            region="us-central1",
            database_version="POSTGRES_11",
            settings={
                "tier": "db-f1-micro",
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password="tf-test-my-password_15222")
        bq_connection_cmek = gcp.bigquery.Connection("bq-connection-cmek",
            friendly_name="👋",
            description="a riveting description",
            location="US",
            kms_key_name="projects/project/locations/us-central1/keyRings/us-central1/cryptoKeys/bq-key",
            cloud_sql={
                "instance_id": instance.connection_name,
                "database": db.name,
                "type": "POSTGRES",
                "credential": {
                    "username": user.name,
                    "password": user.password,
                },
            })
        ```

        ## Import

        Connection can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connections/{{connection_id}}`

        * `{{project}}/{{location}}/{{connection_id}}`

        * `{{location}}/{{connection_id}}`

        When using the `pulumi import` command, Connection can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/connection:Connection default projects/{{project}}/locations/{{location}}/connections/{{connection_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/connection:Connection default {{project}}/{{location}}/{{connection_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/connection:Connection default {{location}}/{{connection_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[Union['ConnectionAwsArgs', 'ConnectionAwsArgsDict']]] = None,
                 azure: Optional[pulumi.Input[Union['ConnectionAzureArgs', 'ConnectionAzureArgsDict']]] = None,
                 cloud_resource: Optional[pulumi.Input[Union['ConnectionCloudResourceArgs', 'ConnectionCloudResourceArgsDict']]] = None,
                 cloud_spanner: Optional[pulumi.Input[Union['ConnectionCloudSpannerArgs', 'ConnectionCloudSpannerArgsDict']]] = None,
                 cloud_sql: Optional[pulumi.Input[Union['ConnectionCloudSqlArgs', 'ConnectionCloudSqlArgsDict']]] = None,
                 connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 friendly_name: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 spark: Optional[pulumi.Input[Union['ConnectionSparkArgs', 'ConnectionSparkArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["aws"] = aws
            __props__.__dict__["azure"] = azure
            __props__.__dict__["cloud_resource"] = cloud_resource
            __props__.__dict__["cloud_spanner"] = cloud_spanner
            __props__.__dict__["cloud_sql"] = cloud_sql
            __props__.__dict__["connection_id"] = connection_id
            __props__.__dict__["description"] = description
            __props__.__dict__["friendly_name"] = friendly_name
            __props__.__dict__["kms_key_name"] = kms_key_name
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["spark"] = spark
            __props__.__dict__["has_credential"] = None
            __props__.__dict__["name"] = None
        super(Connection, __self__).__init__(
            'gcp:bigquery/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws: Optional[pulumi.Input[Union['ConnectionAwsArgs', 'ConnectionAwsArgsDict']]] = None,
            azure: Optional[pulumi.Input[Union['ConnectionAzureArgs', 'ConnectionAzureArgsDict']]] = None,
            cloud_resource: Optional[pulumi.Input[Union['ConnectionCloudResourceArgs', 'ConnectionCloudResourceArgsDict']]] = None,
            cloud_spanner: Optional[pulumi.Input[Union['ConnectionCloudSpannerArgs', 'ConnectionCloudSpannerArgsDict']]] = None,
            cloud_sql: Optional[pulumi.Input[Union['ConnectionCloudSqlArgs', 'ConnectionCloudSqlArgsDict']]] = None,
            connection_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            friendly_name: Optional[pulumi.Input[builtins.str]] = None,
            has_credential: Optional[pulumi.Input[builtins.bool]] = None,
            kms_key_name: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            spark: Optional[pulumi.Input[Union['ConnectionSparkArgs', 'ConnectionSparkArgsDict']]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionAwsArgs', 'ConnectionAwsArgsDict']] aws: Connection properties specific to Amazon Web Services.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionAzureArgs', 'ConnectionAzureArgsDict']] azure: Container for connection properties specific to Azure.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionCloudResourceArgs', 'ConnectionCloudResourceArgsDict']] cloud_resource: Container for connection properties for delegation of access to GCP resources.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionCloudSpannerArgs', 'ConnectionCloudSpannerArgsDict']] cloud_spanner: Connection properties specific to Cloud Spanner
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionCloudSqlArgs', 'ConnectionCloudSqlArgsDict']] cloud_sql: Connection properties specific to the Cloud SQL.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connection_id: Optional connection id that should be assigned to the created connection.
        :param pulumi.Input[builtins.str] description: A descriptive description for the connection
        :param pulumi.Input[builtins.str] friendly_name: A descriptive name for the connection
        :param pulumi.Input[builtins.bool] has_credential: True if the connection has credential assigned.
        :param pulumi.Input[builtins.str] kms_key_name: Optional. The Cloud KMS key that is used for encryption.
               Example: projects/[kms_project_id]/locations/[region]/keyRings/[key_region]/cryptoKeys/[key]
        :param pulumi.Input[builtins.str] location: The geographic location where the connection should reside.
               Cloud SQL instance must be in the same location as the connection
               with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
               Examples: US, EU, asia-northeast1, us-central1, europe-west1.
               Spanner Connections same as spanner region
               AWS allowed regions are aws-us-east-1
               Azure allowed regions are azure-eastus2
        :param pulumi.Input[builtins.str] name: The resource name of the connection in the form of:
               "projects/{project_id}/locations/{location_id}/connections/{connectionId}"
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ConnectionSparkArgs', 'ConnectionSparkArgsDict']] spark: Container for connection properties to execute stored procedures for Apache Spark. resources.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["aws"] = aws
        __props__.__dict__["azure"] = azure
        __props__.__dict__["cloud_resource"] = cloud_resource
        __props__.__dict__["cloud_spanner"] = cloud_spanner
        __props__.__dict__["cloud_sql"] = cloud_sql
        __props__.__dict__["connection_id"] = connection_id
        __props__.__dict__["description"] = description
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["has_credential"] = has_credential
        __props__.__dict__["kms_key_name"] = kms_key_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["spark"] = spark
        return Connection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aws(self) -> pulumi.Output[Optional['outputs.ConnectionAws']]:
        """
        Connection properties specific to Amazon Web Services.
        Structure is documented below.
        """
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter
    def azure(self) -> pulumi.Output[Optional['outputs.ConnectionAzure']]:
        """
        Container for connection properties specific to Azure.
        Structure is documented below.
        """
        return pulumi.get(self, "azure")

    @property
    @pulumi.getter(name="cloudResource")
    def cloud_resource(self) -> pulumi.Output[Optional['outputs.ConnectionCloudResource']]:
        """
        Container for connection properties for delegation of access to GCP resources.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_resource")

    @property
    @pulumi.getter(name="cloudSpanner")
    def cloud_spanner(self) -> pulumi.Output[Optional['outputs.ConnectionCloudSpanner']]:
        """
        Connection properties specific to Cloud Spanner
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_spanner")

    @property
    @pulumi.getter(name="cloudSql")
    def cloud_sql(self) -> pulumi.Output[Optional['outputs.ConnectionCloudSql']]:
        """
        Connection properties specific to the Cloud SQL.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql")

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Output[builtins.str]:
        """
        Optional connection id that should be assigned to the created connection.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A descriptive description for the connection
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A descriptive name for the connection
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="hasCredential")
    def has_credential(self) -> pulumi.Output[builtins.bool]:
        """
        True if the connection has credential assigned.
        """
        return pulumi.get(self, "has_credential")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. The Cloud KMS key that is used for encryption.
        Example: projects/[kms_project_id]/locations/[region]/keyRings/[key_region]/cryptoKeys/[key]
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The geographic location where the connection should reside.
        Cloud SQL instance must be in the same location as the connection
        with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
        Examples: US, EU, asia-northeast1, us-central1, europe-west1.
        Spanner Connections same as spanner region
        AWS allowed regions are aws-us-east-1
        Azure allowed regions are azure-eastus2
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the connection in the form of:
        "projects/{project_id}/locations/{location_id}/connections/{connectionId}"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def spark(self) -> pulumi.Output[Optional['outputs.ConnectionSpark']]:
        """
        Container for connection properties to execute stored procedures for Apache Spark. resources.
        Structure is documented below.
        """
        return pulumi.get(self, "spark")

