# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatasetArgs', 'Dataset']

@pulumi.input_type
class DatasetArgs:
    def __init__(__self__, *,
                 dataset_id: pulumi.Input[builtins.str],
                 accesses: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAccessArgs']]]] = None,
                 default_collation: Optional[pulumi.Input[builtins.str]] = None,
                 default_encryption_configuration: Optional[pulumi.Input['DatasetDefaultEncryptionConfigurationArgs']] = None,
                 default_partition_expiration_ms: Optional[pulumi.Input[builtins.int]] = None,
                 default_table_expiration_ms: Optional[pulumi.Input[builtins.int]] = None,
                 delete_contents_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_catalog_dataset_options: Optional[pulumi.Input['DatasetExternalCatalogDatasetOptionsArgs']] = None,
                 external_dataset_reference: Optional[pulumi.Input['DatasetExternalDatasetReferenceArgs']] = None,
                 friendly_name: Optional[pulumi.Input[builtins.str]] = None,
                 is_case_insensitive: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 max_time_travel_hours: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 storage_billing_model: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Dataset resource.
        :param pulumi.Input[builtins.str] dataset_id: A unique ID for this dataset, without the project name. The ID
               must contain only letters (a-z, A-Z), numbers (0-9), or
               underscores (_). The maximum length is 1,024 characters.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input['DatasetAccessArgs']]] accesses: An array of objects that define dataset access for one or more entities.
               Structure is documented below.
        :param pulumi.Input[builtins.str] default_collation: Defines the default collation specification of future tables created
               in the dataset. If a table is created in this dataset without table-level
               default collation, then the table inherits the dataset default collation,
               which is applied to the string fields that do not have explicit collation
               specified. A change to this field affects only tables created afterwards,
               and does not alter the existing tables.
               The following values are supported:
               - 'und:ci': undetermined locale, case insensitive.
               - '': empty string. Default to case-sensitive behavior.
        :param pulumi.Input['DatasetDefaultEncryptionConfigurationArgs'] default_encryption_configuration: The default encryption key for all tables in the dataset. Once this property is set,
               all newly-created partitioned tables in the dataset will have encryption key set to
               this value, unless table creation request (or query) overrides the key.
               Structure is documented below.
        :param pulumi.Input[builtins.int] default_partition_expiration_ms: The default partition expiration for all partitioned tables in
               the dataset, in milliseconds.
               Once this property is set, all newly-created partitioned tables in
               the dataset will have an `expirationMs` property in the `timePartitioning`
               settings set to this value, and changing the value will only
               affect new tables, not existing ones. The storage in a partition will
               have an expiration time of its partition time plus this value.
               Setting this property overrides the use of `defaultTableExpirationMs`
               for partitioned tables: only one of `defaultTableExpirationMs` and
               `defaultPartitionExpirationMs` will be used for any new partitioned
               table. If you provide an explicit `timePartitioning.expirationMs` when
               creating or updating a partitioned table, that value takes precedence
               over the default partition expiration time indicated by this property.
        :param pulumi.Input[builtins.int] default_table_expiration_ms: The default lifetime of all tables in the dataset, in milliseconds.
               The minimum value is 3600000 milliseconds (one hour).
               Once this property is set, all newly-created tables in the dataset
               will have an `expirationTime` property set to the creation time plus
               the value in this property, and changing the value will only affect
               new tables, not existing ones. When the `expirationTime` for a given
               table is reached, that table will be deleted automatically.
               If a table's `expirationTime` is modified or removed before the
               table expires, or if you provide an explicit `expirationTime` when
               creating a table, that value takes precedence over the default
               expiration time indicated by this property.
        :param pulumi.Input[builtins.bool] delete_contents_on_destroy: If set to `true`, delete all the tables in the
               dataset when destroying the resource; otherwise,
               destroying the resource will fail if tables are present.
        :param pulumi.Input[builtins.str] description: A user-friendly description of the dataset
        :param pulumi.Input['DatasetExternalCatalogDatasetOptionsArgs'] external_catalog_dataset_options: Options defining open source compatible datasets living in the BigQuery catalog. Contains
               metadata of open source database, schema or namespace represented by the current dataset.
               Structure is documented below.
        :param pulumi.Input['DatasetExternalDatasetReferenceArgs'] external_dataset_reference: Information about the external metadata storage where the dataset is defined.
               Structure is documented below.
        :param pulumi.Input[builtins.str] friendly_name: A descriptive name for the dataset
        :param pulumi.Input[builtins.bool] is_case_insensitive: TRUE if the dataset and its table names are case-insensitive, otherwise FALSE.
               By default, this is FALSE, which means the dataset and its table names are
               case-sensitive. This field does not affect routine references.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels associated with this dataset. You can use these to
               organize and group your datasets.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The geographic location where the dataset should reside.
               See [official docs](https://cloud.google.com/bigquery/docs/dataset-locations).
               There are two types of locations, regional or multi-regional. A regional
               location is a specific geographic place, such as Tokyo, and a multi-regional
               location is a large geographic area, such as the United States, that
               contains at least two geographic places.
               The default value is multi-regional location `US`.
               Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] max_time_travel_hours: Defines the time travel window in hours. The value can be from 48 to 168 hours (2 to 7 days).
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] resource_tags: The tags attached to this table. Tag keys are globally unique. Tag key is expected to be
               in the namespaced format, for example "123456789012/environment" where 123456789012 is the
               ID of the parent organization or project resource for this tag key. Tag value is expected
               to be the short name, for example "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-control#definitions)
               for more details.
        :param pulumi.Input[builtins.str] storage_billing_model: Specifies the storage billing model for the dataset.
               Set this flag value to LOGICAL to use logical bytes for storage billing,
               or to PHYSICAL to use physical bytes instead.
               LOGICAL is the default if this flag isn't specified.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        if accesses is not None:
            pulumi.set(__self__, "accesses", accesses)
        if default_collation is not None:
            pulumi.set(__self__, "default_collation", default_collation)
        if default_encryption_configuration is not None:
            pulumi.set(__self__, "default_encryption_configuration", default_encryption_configuration)
        if default_partition_expiration_ms is not None:
            pulumi.set(__self__, "default_partition_expiration_ms", default_partition_expiration_ms)
        if default_table_expiration_ms is not None:
            pulumi.set(__self__, "default_table_expiration_ms", default_table_expiration_ms)
        if delete_contents_on_destroy is not None:
            pulumi.set(__self__, "delete_contents_on_destroy", delete_contents_on_destroy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_catalog_dataset_options is not None:
            pulumi.set(__self__, "external_catalog_dataset_options", external_catalog_dataset_options)
        if external_dataset_reference is not None:
            pulumi.set(__self__, "external_dataset_reference", external_dataset_reference)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_case_insensitive is not None:
            pulumi.set(__self__, "is_case_insensitive", is_case_insensitive)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_time_travel_hours is not None:
            pulumi.set(__self__, "max_time_travel_hours", max_time_travel_hours)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if storage_billing_model is not None:
            pulumi.set(__self__, "storage_billing_model", storage_billing_model)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Input[builtins.str]:
        """
        A unique ID for this dataset, without the project name. The ID
        must contain only letters (a-z, A-Z), numbers (0-9), or
        underscores (_). The maximum length is 1,024 characters.


        - - -
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter
    def accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAccessArgs']]]]:
        """
        An array of objects that define dataset access for one or more entities.
        Structure is documented below.
        """
        return pulumi.get(self, "accesses")

    @accesses.setter
    def accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAccessArgs']]]]):
        pulumi.set(self, "accesses", value)

    @property
    @pulumi.getter(name="defaultCollation")
    def default_collation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the default collation specification of future tables created
        in the dataset. If a table is created in this dataset without table-level
        default collation, then the table inherits the dataset default collation,
        which is applied to the string fields that do not have explicit collation
        specified. A change to this field affects only tables created afterwards,
        and does not alter the existing tables.
        The following values are supported:
        - 'und:ci': undetermined locale, case insensitive.
        - '': empty string. Default to case-sensitive behavior.
        """
        return pulumi.get(self, "default_collation")

    @default_collation.setter
    def default_collation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_collation", value)

    @property
    @pulumi.getter(name="defaultEncryptionConfiguration")
    def default_encryption_configuration(self) -> Optional[pulumi.Input['DatasetDefaultEncryptionConfigurationArgs']]:
        """
        The default encryption key for all tables in the dataset. Once this property is set,
        all newly-created partitioned tables in the dataset will have encryption key set to
        this value, unless table creation request (or query) overrides the key.
        Structure is documented below.
        """
        return pulumi.get(self, "default_encryption_configuration")

    @default_encryption_configuration.setter
    def default_encryption_configuration(self, value: Optional[pulumi.Input['DatasetDefaultEncryptionConfigurationArgs']]):
        pulumi.set(self, "default_encryption_configuration", value)

    @property
    @pulumi.getter(name="defaultPartitionExpirationMs")
    def default_partition_expiration_ms(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The default partition expiration for all partitioned tables in
        the dataset, in milliseconds.
        Once this property is set, all newly-created partitioned tables in
        the dataset will have an `expirationMs` property in the `timePartitioning`
        settings set to this value, and changing the value will only
        affect new tables, not existing ones. The storage in a partition will
        have an expiration time of its partition time plus this value.
        Setting this property overrides the use of `defaultTableExpirationMs`
        for partitioned tables: only one of `defaultTableExpirationMs` and
        `defaultPartitionExpirationMs` will be used for any new partitioned
        table. If you provide an explicit `timePartitioning.expirationMs` when
        creating or updating a partitioned table, that value takes precedence
        over the default partition expiration time indicated by this property.
        """
        return pulumi.get(self, "default_partition_expiration_ms")

    @default_partition_expiration_ms.setter
    def default_partition_expiration_ms(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_partition_expiration_ms", value)

    @property
    @pulumi.getter(name="defaultTableExpirationMs")
    def default_table_expiration_ms(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The default lifetime of all tables in the dataset, in milliseconds.
        The minimum value is 3600000 milliseconds (one hour).
        Once this property is set, all newly-created tables in the dataset
        will have an `expirationTime` property set to the creation time plus
        the value in this property, and changing the value will only affect
        new tables, not existing ones. When the `expirationTime` for a given
        table is reached, that table will be deleted automatically.
        If a table's `expirationTime` is modified or removed before the
        table expires, or if you provide an explicit `expirationTime` when
        creating a table, that value takes precedence over the default
        expiration time indicated by this property.
        """
        return pulumi.get(self, "default_table_expiration_ms")

    @default_table_expiration_ms.setter
    def default_table_expiration_ms(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_table_expiration_ms", value)

    @property
    @pulumi.getter(name="deleteContentsOnDestroy")
    def delete_contents_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `true`, delete all the tables in the
        dataset when destroying the resource; otherwise,
        destroying the resource will fail if tables are present.
        """
        return pulumi.get(self, "delete_contents_on_destroy")

    @delete_contents_on_destroy.setter
    def delete_contents_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_contents_on_destroy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-friendly description of the dataset
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalCatalogDatasetOptions")
    def external_catalog_dataset_options(self) -> Optional[pulumi.Input['DatasetExternalCatalogDatasetOptionsArgs']]:
        """
        Options defining open source compatible datasets living in the BigQuery catalog. Contains
        metadata of open source database, schema or namespace represented by the current dataset.
        Structure is documented below.
        """
        return pulumi.get(self, "external_catalog_dataset_options")

    @external_catalog_dataset_options.setter
    def external_catalog_dataset_options(self, value: Optional[pulumi.Input['DatasetExternalCatalogDatasetOptionsArgs']]):
        pulumi.set(self, "external_catalog_dataset_options", value)

    @property
    @pulumi.getter(name="externalDatasetReference")
    def external_dataset_reference(self) -> Optional[pulumi.Input['DatasetExternalDatasetReferenceArgs']]:
        """
        Information about the external metadata storage where the dataset is defined.
        Structure is documented below.
        """
        return pulumi.get(self, "external_dataset_reference")

    @external_dataset_reference.setter
    def external_dataset_reference(self, value: Optional[pulumi.Input['DatasetExternalDatasetReferenceArgs']]):
        pulumi.set(self, "external_dataset_reference", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A descriptive name for the dataset
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isCaseInsensitive")
    def is_case_insensitive(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        TRUE if the dataset and its table names are case-insensitive, otherwise FALSE.
        By default, this is FALSE, which means the dataset and its table names are
        case-sensitive. This field does not affect routine references.
        """
        return pulumi.get(self, "is_case_insensitive")

    @is_case_insensitive.setter
    def is_case_insensitive(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_case_insensitive", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels associated with this dataset. You can use these to
        organize and group your datasets.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The geographic location where the dataset should reside.
        See [official docs](https://cloud.google.com/bigquery/docs/dataset-locations).
        There are two types of locations, regional or multi-regional. A regional
        location is a specific geographic place, such as Tokyo, and a multi-regional
        location is a large geographic area, such as the United States, that
        contains at least two geographic places.
        The default value is multi-regional location `US`.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maxTimeTravelHours")
    def max_time_travel_hours(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the time travel window in hours. The value can be from 48 to 168 hours (2 to 7 days).
        """
        return pulumi.get(self, "max_time_travel_hours")

    @max_time_travel_hours.setter
    def max_time_travel_hours(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_time_travel_hours", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The tags attached to this table. Tag keys are globally unique. Tag key is expected to be
        in the namespaced format, for example "123456789012/environment" where 123456789012 is the
        ID of the parent organization or project resource for this tag key. Tag value is expected
        to be the short name, for example "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-control#definitions)
        for more details.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "resource_tags", value)

    @property
    @pulumi.getter(name="storageBillingModel")
    def storage_billing_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the storage billing model for the dataset.
        Set this flag value to LOGICAL to use logical bytes for storage billing,
        or to PHYSICAL to use physical bytes instead.
        LOGICAL is the default if this flag isn't specified.
        """
        return pulumi.get(self, "storage_billing_model")

    @storage_billing_model.setter
    def storage_billing_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_billing_model", value)


@pulumi.input_type
class _DatasetState:
    def __init__(__self__, *,
                 accesses: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAccessArgs']]]] = None,
                 creation_time: Optional[pulumi.Input[builtins.int]] = None,
                 dataset_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_collation: Optional[pulumi.Input[builtins.str]] = None,
                 default_encryption_configuration: Optional[pulumi.Input['DatasetDefaultEncryptionConfigurationArgs']] = None,
                 default_partition_expiration_ms: Optional[pulumi.Input[builtins.int]] = None,
                 default_table_expiration_ms: Optional[pulumi.Input[builtins.int]] = None,
                 delete_contents_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 external_catalog_dataset_options: Optional[pulumi.Input['DatasetExternalCatalogDatasetOptionsArgs']] = None,
                 external_dataset_reference: Optional[pulumi.Input['DatasetExternalDatasetReferenceArgs']] = None,
                 friendly_name: Optional[pulumi.Input[builtins.str]] = None,
                 is_case_insensitive: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 last_modified_time: Optional[pulumi.Input[builtins.int]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 max_time_travel_hours: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 storage_billing_model: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Dataset resources.
        :param pulumi.Input[Sequence[pulumi.Input['DatasetAccessArgs']]] accesses: An array of objects that define dataset access for one or more entities.
               Structure is documented below.
        :param pulumi.Input[builtins.int] creation_time: The time when this dataset was created, in milliseconds since the
               epoch.
        :param pulumi.Input[builtins.str] dataset_id: A unique ID for this dataset, without the project name. The ID
               must contain only letters (a-z, A-Z), numbers (0-9), or
               underscores (_). The maximum length is 1,024 characters.
               
               
               - - -
        :param pulumi.Input[builtins.str] default_collation: Defines the default collation specification of future tables created
               in the dataset. If a table is created in this dataset without table-level
               default collation, then the table inherits the dataset default collation,
               which is applied to the string fields that do not have explicit collation
               specified. A change to this field affects only tables created afterwards,
               and does not alter the existing tables.
               The following values are supported:
               - 'und:ci': undetermined locale, case insensitive.
               - '': empty string. Default to case-sensitive behavior.
        :param pulumi.Input['DatasetDefaultEncryptionConfigurationArgs'] default_encryption_configuration: The default encryption key for all tables in the dataset. Once this property is set,
               all newly-created partitioned tables in the dataset will have encryption key set to
               this value, unless table creation request (or query) overrides the key.
               Structure is documented below.
        :param pulumi.Input[builtins.int] default_partition_expiration_ms: The default partition expiration for all partitioned tables in
               the dataset, in milliseconds.
               Once this property is set, all newly-created partitioned tables in
               the dataset will have an `expirationMs` property in the `timePartitioning`
               settings set to this value, and changing the value will only
               affect new tables, not existing ones. The storage in a partition will
               have an expiration time of its partition time plus this value.
               Setting this property overrides the use of `defaultTableExpirationMs`
               for partitioned tables: only one of `defaultTableExpirationMs` and
               `defaultPartitionExpirationMs` will be used for any new partitioned
               table. If you provide an explicit `timePartitioning.expirationMs` when
               creating or updating a partitioned table, that value takes precedence
               over the default partition expiration time indicated by this property.
        :param pulumi.Input[builtins.int] default_table_expiration_ms: The default lifetime of all tables in the dataset, in milliseconds.
               The minimum value is 3600000 milliseconds (one hour).
               Once this property is set, all newly-created tables in the dataset
               will have an `expirationTime` property set to the creation time plus
               the value in this property, and changing the value will only affect
               new tables, not existing ones. When the `expirationTime` for a given
               table is reached, that table will be deleted automatically.
               If a table's `expirationTime` is modified or removed before the
               table expires, or if you provide an explicit `expirationTime` when
               creating a table, that value takes precedence over the default
               expiration time indicated by this property.
        :param pulumi.Input[builtins.bool] delete_contents_on_destroy: If set to `true`, delete all the tables in the
               dataset when destroying the resource; otherwise,
               destroying the resource will fail if tables are present.
        :param pulumi.Input[builtins.str] description: A user-friendly description of the dataset
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] etag: A hash of the resource.
        :param pulumi.Input['DatasetExternalCatalogDatasetOptionsArgs'] external_catalog_dataset_options: Options defining open source compatible datasets living in the BigQuery catalog. Contains
               metadata of open source database, schema or namespace represented by the current dataset.
               Structure is documented below.
        :param pulumi.Input['DatasetExternalDatasetReferenceArgs'] external_dataset_reference: Information about the external metadata storage where the dataset is defined.
               Structure is documented below.
        :param pulumi.Input[builtins.str] friendly_name: A descriptive name for the dataset
        :param pulumi.Input[builtins.bool] is_case_insensitive: TRUE if the dataset and its table names are case-insensitive, otherwise FALSE.
               By default, this is FALSE, which means the dataset and its table names are
               case-sensitive. This field does not affect routine references.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels associated with this dataset. You can use these to
               organize and group your datasets.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.int] last_modified_time: The date when this dataset or any of its tables was last modified, in
               milliseconds since the epoch.
        :param pulumi.Input[builtins.str] location: The geographic location where the dataset should reside.
               See [official docs](https://cloud.google.com/bigquery/docs/dataset-locations).
               There are two types of locations, regional or multi-regional. A regional
               location is a specific geographic place, such as Tokyo, and a multi-regional
               location is a large geographic area, such as the United States, that
               contains at least two geographic places.
               The default value is multi-regional location `US`.
               Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] max_time_travel_hours: Defines the time travel window in hours. The value can be from 48 to 168 hours (2 to 7 days).
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] resource_tags: The tags attached to this table. Tag keys are globally unique. Tag key is expected to be
               in the namespaced format, for example "123456789012/environment" where 123456789012 is the
               ID of the parent organization or project resource for this tag key. Tag value is expected
               to be the short name, for example "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-control#definitions)
               for more details.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[builtins.str] storage_billing_model: Specifies the storage billing model for the dataset.
               Set this flag value to LOGICAL to use logical bytes for storage billing,
               or to PHYSICAL to use physical bytes instead.
               LOGICAL is the default if this flag isn't specified.
        """
        if accesses is not None:
            pulumi.set(__self__, "accesses", accesses)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if default_collation is not None:
            pulumi.set(__self__, "default_collation", default_collation)
        if default_encryption_configuration is not None:
            pulumi.set(__self__, "default_encryption_configuration", default_encryption_configuration)
        if default_partition_expiration_ms is not None:
            pulumi.set(__self__, "default_partition_expiration_ms", default_partition_expiration_ms)
        if default_table_expiration_ms is not None:
            pulumi.set(__self__, "default_table_expiration_ms", default_table_expiration_ms)
        if delete_contents_on_destroy is not None:
            pulumi.set(__self__, "delete_contents_on_destroy", delete_contents_on_destroy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if external_catalog_dataset_options is not None:
            pulumi.set(__self__, "external_catalog_dataset_options", external_catalog_dataset_options)
        if external_dataset_reference is not None:
            pulumi.set(__self__, "external_dataset_reference", external_dataset_reference)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_case_insensitive is not None:
            pulumi.set(__self__, "is_case_insensitive", is_case_insensitive)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_time_travel_hours is not None:
            pulumi.set(__self__, "max_time_travel_hours", max_time_travel_hours)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if storage_billing_model is not None:
            pulumi.set(__self__, "storage_billing_model", storage_billing_model)

    @property
    @pulumi.getter
    def accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAccessArgs']]]]:
        """
        An array of objects that define dataset access for one or more entities.
        Structure is documented below.
        """
        return pulumi.get(self, "accesses")

    @accesses.setter
    def accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAccessArgs']]]]):
        pulumi.set(self, "accesses", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The time when this dataset was created, in milliseconds since the
        epoch.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique ID for this dataset, without the project name. The ID
        must contain only letters (a-z, A-Z), numbers (0-9), or
        underscores (_). The maximum length is 1,024 characters.


        - - -
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="defaultCollation")
    def default_collation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the default collation specification of future tables created
        in the dataset. If a table is created in this dataset without table-level
        default collation, then the table inherits the dataset default collation,
        which is applied to the string fields that do not have explicit collation
        specified. A change to this field affects only tables created afterwards,
        and does not alter the existing tables.
        The following values are supported:
        - 'und:ci': undetermined locale, case insensitive.
        - '': empty string. Default to case-sensitive behavior.
        """
        return pulumi.get(self, "default_collation")

    @default_collation.setter
    def default_collation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_collation", value)

    @property
    @pulumi.getter(name="defaultEncryptionConfiguration")
    def default_encryption_configuration(self) -> Optional[pulumi.Input['DatasetDefaultEncryptionConfigurationArgs']]:
        """
        The default encryption key for all tables in the dataset. Once this property is set,
        all newly-created partitioned tables in the dataset will have encryption key set to
        this value, unless table creation request (or query) overrides the key.
        Structure is documented below.
        """
        return pulumi.get(self, "default_encryption_configuration")

    @default_encryption_configuration.setter
    def default_encryption_configuration(self, value: Optional[pulumi.Input['DatasetDefaultEncryptionConfigurationArgs']]):
        pulumi.set(self, "default_encryption_configuration", value)

    @property
    @pulumi.getter(name="defaultPartitionExpirationMs")
    def default_partition_expiration_ms(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The default partition expiration for all partitioned tables in
        the dataset, in milliseconds.
        Once this property is set, all newly-created partitioned tables in
        the dataset will have an `expirationMs` property in the `timePartitioning`
        settings set to this value, and changing the value will only
        affect new tables, not existing ones. The storage in a partition will
        have an expiration time of its partition time plus this value.
        Setting this property overrides the use of `defaultTableExpirationMs`
        for partitioned tables: only one of `defaultTableExpirationMs` and
        `defaultPartitionExpirationMs` will be used for any new partitioned
        table. If you provide an explicit `timePartitioning.expirationMs` when
        creating or updating a partitioned table, that value takes precedence
        over the default partition expiration time indicated by this property.
        """
        return pulumi.get(self, "default_partition_expiration_ms")

    @default_partition_expiration_ms.setter
    def default_partition_expiration_ms(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_partition_expiration_ms", value)

    @property
    @pulumi.getter(name="defaultTableExpirationMs")
    def default_table_expiration_ms(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The default lifetime of all tables in the dataset, in milliseconds.
        The minimum value is 3600000 milliseconds (one hour).
        Once this property is set, all newly-created tables in the dataset
        will have an `expirationTime` property set to the creation time plus
        the value in this property, and changing the value will only affect
        new tables, not existing ones. When the `expirationTime` for a given
        table is reached, that table will be deleted automatically.
        If a table's `expirationTime` is modified or removed before the
        table expires, or if you provide an explicit `expirationTime` when
        creating a table, that value takes precedence over the default
        expiration time indicated by this property.
        """
        return pulumi.get(self, "default_table_expiration_ms")

    @default_table_expiration_ms.setter
    def default_table_expiration_ms(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_table_expiration_ms", value)

    @property
    @pulumi.getter(name="deleteContentsOnDestroy")
    def delete_contents_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `true`, delete all the tables in the
        dataset when destroying the resource; otherwise,
        destroying the resource will fail if tables are present.
        """
        return pulumi.get(self, "delete_contents_on_destroy")

    @delete_contents_on_destroy.setter
    def delete_contents_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_contents_on_destroy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-friendly description of the dataset
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A hash of the resource.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="externalCatalogDatasetOptions")
    def external_catalog_dataset_options(self) -> Optional[pulumi.Input['DatasetExternalCatalogDatasetOptionsArgs']]:
        """
        Options defining open source compatible datasets living in the BigQuery catalog. Contains
        metadata of open source database, schema or namespace represented by the current dataset.
        Structure is documented below.
        """
        return pulumi.get(self, "external_catalog_dataset_options")

    @external_catalog_dataset_options.setter
    def external_catalog_dataset_options(self, value: Optional[pulumi.Input['DatasetExternalCatalogDatasetOptionsArgs']]):
        pulumi.set(self, "external_catalog_dataset_options", value)

    @property
    @pulumi.getter(name="externalDatasetReference")
    def external_dataset_reference(self) -> Optional[pulumi.Input['DatasetExternalDatasetReferenceArgs']]:
        """
        Information about the external metadata storage where the dataset is defined.
        Structure is documented below.
        """
        return pulumi.get(self, "external_dataset_reference")

    @external_dataset_reference.setter
    def external_dataset_reference(self, value: Optional[pulumi.Input['DatasetExternalDatasetReferenceArgs']]):
        pulumi.set(self, "external_dataset_reference", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A descriptive name for the dataset
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isCaseInsensitive")
    def is_case_insensitive(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        TRUE if the dataset and its table names are case-insensitive, otherwise FALSE.
        By default, this is FALSE, which means the dataset and its table names are
        case-sensitive. This field does not affect routine references.
        """
        return pulumi.get(self, "is_case_insensitive")

    @is_case_insensitive.setter
    def is_case_insensitive(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_case_insensitive", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels associated with this dataset. You can use these to
        organize and group your datasets.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The date when this dataset or any of its tables was last modified, in
        milliseconds since the epoch.
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "last_modified_time", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The geographic location where the dataset should reside.
        See [official docs](https://cloud.google.com/bigquery/docs/dataset-locations).
        There are two types of locations, regional or multi-regional. A regional
        location is a specific geographic place, such as Tokyo, and a multi-regional
        location is a large geographic area, such as the United States, that
        contains at least two geographic places.
        The default value is multi-regional location `US`.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maxTimeTravelHours")
    def max_time_travel_hours(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the time travel window in hours. The value can be from 48 to 168 hours (2 to 7 days).
        """
        return pulumi.get(self, "max_time_travel_hours")

    @max_time_travel_hours.setter
    def max_time_travel_hours(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_time_travel_hours", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The tags attached to this table. Tag keys are globally unique. Tag key is expected to be
        in the namespaced format, for example "123456789012/environment" where 123456789012 is the
        ID of the parent organization or project resource for this tag key. Tag value is expected
        to be the short name, for example "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-control#definitions)
        for more details.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "resource_tags", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="storageBillingModel")
    def storage_billing_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the storage billing model for the dataset.
        Set this flag value to LOGICAL to use logical bytes for storage billing,
        or to PHYSICAL to use physical bytes instead.
        LOGICAL is the default if this flag isn't specified.
        """
        return pulumi.get(self, "storage_billing_model")

    @storage_billing_model.setter
    def storage_billing_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_billing_model", value)


@pulumi.type_token("gcp:bigquery/dataset:Dataset")
class Dataset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatasetAccessArgs', 'DatasetAccessArgsDict']]]]] = None,
                 dataset_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_collation: Optional[pulumi.Input[builtins.str]] = None,
                 default_encryption_configuration: Optional[pulumi.Input[Union['DatasetDefaultEncryptionConfigurationArgs', 'DatasetDefaultEncryptionConfigurationArgsDict']]] = None,
                 default_partition_expiration_ms: Optional[pulumi.Input[builtins.int]] = None,
                 default_table_expiration_ms: Optional[pulumi.Input[builtins.int]] = None,
                 delete_contents_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_catalog_dataset_options: Optional[pulumi.Input[Union['DatasetExternalCatalogDatasetOptionsArgs', 'DatasetExternalCatalogDatasetOptionsArgsDict']]] = None,
                 external_dataset_reference: Optional[pulumi.Input[Union['DatasetExternalDatasetReferenceArgs', 'DatasetExternalDatasetReferenceArgsDict']]] = None,
                 friendly_name: Optional[pulumi.Input[builtins.str]] = None,
                 is_case_insensitive: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 max_time_travel_hours: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 storage_billing_model: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Bigquery Dataset Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bqowner = gcp.serviceaccount.Account("bqowner", account_id="bqowner")
        dataset = gcp.bigquery.Dataset("dataset",
            dataset_id="example_dataset",
            friendly_name="test",
            description="This is a test description",
            location="EU",
            default_table_expiration_ms=3600000,
            labels={
                "env": "default",
            },
            accesses=[
                {
                    "role": "OWNER",
                    "user_by_email": bqowner.email,
                },
                {
                    "role": "READER",
                    "domain": "hashicorp.com",
                },
            ])
        ```
        ### Bigquery Dataset Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        key_ring = gcp.kms.KeyRing("key_ring",
            name="example-keyring",
            location="us")
        crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="example-key",
            key_ring=key_ring.id)
        dataset = gcp.bigquery.Dataset("dataset",
            dataset_id="example_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US",
            default_table_expiration_ms=3600000,
            default_encryption_configuration={
                "kms_key_name": crypto_key.id,
            })
        ```
        ### Bigquery Dataset Authorized Dataset

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bqowner = gcp.serviceaccount.Account("bqowner", account_id="bqowner")
        public = gcp.bigquery.Dataset("public",
            dataset_id="public",
            friendly_name="test",
            description="This dataset is public",
            location="EU",
            default_table_expiration_ms=3600000,
            labels={
                "env": "default",
            },
            accesses=[
                {
                    "role": "OWNER",
                    "user_by_email": bqowner.email,
                },
                {
                    "role": "READER",
                    "domain": "hashicorp.com",
                },
            ])
        dataset = gcp.bigquery.Dataset("dataset",
            dataset_id="private",
            friendly_name="test",
            description="This dataset is private",
            location="EU",
            default_table_expiration_ms=3600000,
            labels={
                "env": "default",
            },
            accesses=[
                {
                    "role": "OWNER",
                    "user_by_email": bqowner.email,
                },
                {
                    "role": "READER",
                    "domain": "hashicorp.com",
                },
                {
                    "dataset": {
                        "dataset": {
                            "project_id": public.project,
                            "dataset_id": public.dataset_id,
                        },
                        "target_types": ["VIEWS"],
                    },
                },
            ])
        ```
        ### Bigquery Dataset Authorized Routine

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        public = gcp.bigquery.Dataset("public",
            dataset_id="public_dataset",
            description="This dataset is public")
        public_routine = gcp.bigquery.Routine("public",
            dataset_id=public.dataset_id,
            routine_id="public_routine",
            routine_type="TABLE_VALUED_FUNCTION",
            language="SQL",
            definition_body="SELECT 1 + value AS value\\n",
            arguments=[{
                "name": "value",
                "argument_kind": "FIXED_TYPE",
                "data_type": json.dumps({
                    "typeKind": "INT64",
                }),
            }],
            return_table_type=json.dumps({
                "columns": [{
                    "name": "value",
                    "type": {
                        "typeKind": "INT64",
                    },
                }],
            }))
        private = gcp.bigquery.Dataset("private",
            dataset_id="private_dataset",
            description="This dataset is private",
            accesses=[
                {
                    "role": "OWNER",
                    "user_by_email": "my@service-account.com",
                },
                {
                    "routine": {
                        "project_id": public_routine.project,
                        "dataset_id": public_routine.dataset_id,
                        "routine_id": public_routine.routine_id,
                    },
                },
            ])
        ```
        ### Bigquery Dataset External Reference Aws

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dataset = gcp.bigquery.Dataset("dataset",
            dataset_id="example_dataset",
            friendly_name="test",
            description="This is a test description",
            location="aws-us-east-1",
            external_dataset_reference={
                "external_source": "aws-glue://arn:aws:glue:us-east-1:999999999999:database/database",
                "connection": "projects/project/locations/aws-us-east-1/connections/connection",
            })
        ```
        ### Bigquery Dataset External Catalog Dataset Options

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dataset = gcp.bigquery.Dataset("dataset",
            dataset_id="example_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US",
            external_catalog_dataset_options={
                "parameters": {
                    "dataset_owner": "test_dataset_owner",
                },
                "default_storage_location_uri": "gs://test_dataset/tables",
            })
        ```

        ## Import

        Dataset can be imported using any of these accepted formats:

        * `projects/{{project}}/datasets/{{dataset_id}}`

        * `{{project}}/{{dataset_id}}`

        * `{{dataset_id}}`

        When using the `pulumi import` command, Dataset can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/dataset:Dataset default projects/{{project}}/datasets/{{dataset_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/dataset:Dataset default {{project}}/{{dataset_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/dataset:Dataset default {{dataset_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatasetAccessArgs', 'DatasetAccessArgsDict']]]] accesses: An array of objects that define dataset access for one or more entities.
               Structure is documented below.
        :param pulumi.Input[builtins.str] dataset_id: A unique ID for this dataset, without the project name. The ID
               must contain only letters (a-z, A-Z), numbers (0-9), or
               underscores (_). The maximum length is 1,024 characters.
               
               
               - - -
        :param pulumi.Input[builtins.str] default_collation: Defines the default collation specification of future tables created
               in the dataset. If a table is created in this dataset without table-level
               default collation, then the table inherits the dataset default collation,
               which is applied to the string fields that do not have explicit collation
               specified. A change to this field affects only tables created afterwards,
               and does not alter the existing tables.
               The following values are supported:
               - 'und:ci': undetermined locale, case insensitive.
               - '': empty string. Default to case-sensitive behavior.
        :param pulumi.Input[Union['DatasetDefaultEncryptionConfigurationArgs', 'DatasetDefaultEncryptionConfigurationArgsDict']] default_encryption_configuration: The default encryption key for all tables in the dataset. Once this property is set,
               all newly-created partitioned tables in the dataset will have encryption key set to
               this value, unless table creation request (or query) overrides the key.
               Structure is documented below.
        :param pulumi.Input[builtins.int] default_partition_expiration_ms: The default partition expiration for all partitioned tables in
               the dataset, in milliseconds.
               Once this property is set, all newly-created partitioned tables in
               the dataset will have an `expirationMs` property in the `timePartitioning`
               settings set to this value, and changing the value will only
               affect new tables, not existing ones. The storage in a partition will
               have an expiration time of its partition time plus this value.
               Setting this property overrides the use of `defaultTableExpirationMs`
               for partitioned tables: only one of `defaultTableExpirationMs` and
               `defaultPartitionExpirationMs` will be used for any new partitioned
               table. If you provide an explicit `timePartitioning.expirationMs` when
               creating or updating a partitioned table, that value takes precedence
               over the default partition expiration time indicated by this property.
        :param pulumi.Input[builtins.int] default_table_expiration_ms: The default lifetime of all tables in the dataset, in milliseconds.
               The minimum value is 3600000 milliseconds (one hour).
               Once this property is set, all newly-created tables in the dataset
               will have an `expirationTime` property set to the creation time plus
               the value in this property, and changing the value will only affect
               new tables, not existing ones. When the `expirationTime` for a given
               table is reached, that table will be deleted automatically.
               If a table's `expirationTime` is modified or removed before the
               table expires, or if you provide an explicit `expirationTime` when
               creating a table, that value takes precedence over the default
               expiration time indicated by this property.
        :param pulumi.Input[builtins.bool] delete_contents_on_destroy: If set to `true`, delete all the tables in the
               dataset when destroying the resource; otherwise,
               destroying the resource will fail if tables are present.
        :param pulumi.Input[builtins.str] description: A user-friendly description of the dataset
        :param pulumi.Input[Union['DatasetExternalCatalogDatasetOptionsArgs', 'DatasetExternalCatalogDatasetOptionsArgsDict']] external_catalog_dataset_options: Options defining open source compatible datasets living in the BigQuery catalog. Contains
               metadata of open source database, schema or namespace represented by the current dataset.
               Structure is documented below.
        :param pulumi.Input[Union['DatasetExternalDatasetReferenceArgs', 'DatasetExternalDatasetReferenceArgsDict']] external_dataset_reference: Information about the external metadata storage where the dataset is defined.
               Structure is documented below.
        :param pulumi.Input[builtins.str] friendly_name: A descriptive name for the dataset
        :param pulumi.Input[builtins.bool] is_case_insensitive: TRUE if the dataset and its table names are case-insensitive, otherwise FALSE.
               By default, this is FALSE, which means the dataset and its table names are
               case-sensitive. This field does not affect routine references.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels associated with this dataset. You can use these to
               organize and group your datasets.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The geographic location where the dataset should reside.
               See [official docs](https://cloud.google.com/bigquery/docs/dataset-locations).
               There are two types of locations, regional or multi-regional. A regional
               location is a specific geographic place, such as Tokyo, and a multi-regional
               location is a large geographic area, such as the United States, that
               contains at least two geographic places.
               The default value is multi-regional location `US`.
               Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] max_time_travel_hours: Defines the time travel window in hours. The value can be from 48 to 168 hours (2 to 7 days).
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] resource_tags: The tags attached to this table. Tag keys are globally unique. Tag key is expected to be
               in the namespaced format, for example "123456789012/environment" where 123456789012 is the
               ID of the parent organization or project resource for this tag key. Tag value is expected
               to be the short name, for example "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-control#definitions)
               for more details.
        :param pulumi.Input[builtins.str] storage_billing_model: Specifies the storage billing model for the dataset.
               Set this flag value to LOGICAL to use logical bytes for storage billing,
               or to PHYSICAL to use physical bytes instead.
               LOGICAL is the default if this flag isn't specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatasetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Bigquery Dataset Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bqowner = gcp.serviceaccount.Account("bqowner", account_id="bqowner")
        dataset = gcp.bigquery.Dataset("dataset",
            dataset_id="example_dataset",
            friendly_name="test",
            description="This is a test description",
            location="EU",
            default_table_expiration_ms=3600000,
            labels={
                "env": "default",
            },
            accesses=[
                {
                    "role": "OWNER",
                    "user_by_email": bqowner.email,
                },
                {
                    "role": "READER",
                    "domain": "hashicorp.com",
                },
            ])
        ```
        ### Bigquery Dataset Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        key_ring = gcp.kms.KeyRing("key_ring",
            name="example-keyring",
            location="us")
        crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="example-key",
            key_ring=key_ring.id)
        dataset = gcp.bigquery.Dataset("dataset",
            dataset_id="example_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US",
            default_table_expiration_ms=3600000,
            default_encryption_configuration={
                "kms_key_name": crypto_key.id,
            })
        ```
        ### Bigquery Dataset Authorized Dataset

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bqowner = gcp.serviceaccount.Account("bqowner", account_id="bqowner")
        public = gcp.bigquery.Dataset("public",
            dataset_id="public",
            friendly_name="test",
            description="This dataset is public",
            location="EU",
            default_table_expiration_ms=3600000,
            labels={
                "env": "default",
            },
            accesses=[
                {
                    "role": "OWNER",
                    "user_by_email": bqowner.email,
                },
                {
                    "role": "READER",
                    "domain": "hashicorp.com",
                },
            ])
        dataset = gcp.bigquery.Dataset("dataset",
            dataset_id="private",
            friendly_name="test",
            description="This dataset is private",
            location="EU",
            default_table_expiration_ms=3600000,
            labels={
                "env": "default",
            },
            accesses=[
                {
                    "role": "OWNER",
                    "user_by_email": bqowner.email,
                },
                {
                    "role": "READER",
                    "domain": "hashicorp.com",
                },
                {
                    "dataset": {
                        "dataset": {
                            "project_id": public.project,
                            "dataset_id": public.dataset_id,
                        },
                        "target_types": ["VIEWS"],
                    },
                },
            ])
        ```
        ### Bigquery Dataset Authorized Routine

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        public = gcp.bigquery.Dataset("public",
            dataset_id="public_dataset",
            description="This dataset is public")
        public_routine = gcp.bigquery.Routine("public",
            dataset_id=public.dataset_id,
            routine_id="public_routine",
            routine_type="TABLE_VALUED_FUNCTION",
            language="SQL",
            definition_body="SELECT 1 + value AS value\\n",
            arguments=[{
                "name": "value",
                "argument_kind": "FIXED_TYPE",
                "data_type": json.dumps({
                    "typeKind": "INT64",
                }),
            }],
            return_table_type=json.dumps({
                "columns": [{
                    "name": "value",
                    "type": {
                        "typeKind": "INT64",
                    },
                }],
            }))
        private = gcp.bigquery.Dataset("private",
            dataset_id="private_dataset",
            description="This dataset is private",
            accesses=[
                {
                    "role": "OWNER",
                    "user_by_email": "my@service-account.com",
                },
                {
                    "routine": {
                        "project_id": public_routine.project,
                        "dataset_id": public_routine.dataset_id,
                        "routine_id": public_routine.routine_id,
                    },
                },
            ])
        ```
        ### Bigquery Dataset External Reference Aws

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dataset = gcp.bigquery.Dataset("dataset",
            dataset_id="example_dataset",
            friendly_name="test",
            description="This is a test description",
            location="aws-us-east-1",
            external_dataset_reference={
                "external_source": "aws-glue://arn:aws:glue:us-east-1:999999999999:database/database",
                "connection": "projects/project/locations/aws-us-east-1/connections/connection",
            })
        ```
        ### Bigquery Dataset External Catalog Dataset Options

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dataset = gcp.bigquery.Dataset("dataset",
            dataset_id="example_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US",
            external_catalog_dataset_options={
                "parameters": {
                    "dataset_owner": "test_dataset_owner",
                },
                "default_storage_location_uri": "gs://test_dataset/tables",
            })
        ```

        ## Import

        Dataset can be imported using any of these accepted formats:

        * `projects/{{project}}/datasets/{{dataset_id}}`

        * `{{project}}/{{dataset_id}}`

        * `{{dataset_id}}`

        When using the `pulumi import` command, Dataset can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/dataset:Dataset default projects/{{project}}/datasets/{{dataset_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/dataset:Dataset default {{project}}/{{dataset_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/dataset:Dataset default {{dataset_id}}
        ```

        :param str resource_name: The name of the resource.
        :param DatasetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatasetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatasetAccessArgs', 'DatasetAccessArgsDict']]]]] = None,
                 dataset_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_collation: Optional[pulumi.Input[builtins.str]] = None,
                 default_encryption_configuration: Optional[pulumi.Input[Union['DatasetDefaultEncryptionConfigurationArgs', 'DatasetDefaultEncryptionConfigurationArgsDict']]] = None,
                 default_partition_expiration_ms: Optional[pulumi.Input[builtins.int]] = None,
                 default_table_expiration_ms: Optional[pulumi.Input[builtins.int]] = None,
                 delete_contents_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_catalog_dataset_options: Optional[pulumi.Input[Union['DatasetExternalCatalogDatasetOptionsArgs', 'DatasetExternalCatalogDatasetOptionsArgsDict']]] = None,
                 external_dataset_reference: Optional[pulumi.Input[Union['DatasetExternalDatasetReferenceArgs', 'DatasetExternalDatasetReferenceArgsDict']]] = None,
                 friendly_name: Optional[pulumi.Input[builtins.str]] = None,
                 is_case_insensitive: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 max_time_travel_hours: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 storage_billing_model: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatasetArgs.__new__(DatasetArgs)

            __props__.__dict__["accesses"] = accesses
            if dataset_id is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_id'")
            __props__.__dict__["dataset_id"] = dataset_id
            __props__.__dict__["default_collation"] = default_collation
            __props__.__dict__["default_encryption_configuration"] = default_encryption_configuration
            __props__.__dict__["default_partition_expiration_ms"] = default_partition_expiration_ms
            __props__.__dict__["default_table_expiration_ms"] = default_table_expiration_ms
            __props__.__dict__["delete_contents_on_destroy"] = delete_contents_on_destroy
            __props__.__dict__["description"] = description
            __props__.__dict__["external_catalog_dataset_options"] = external_catalog_dataset_options
            __props__.__dict__["external_dataset_reference"] = external_dataset_reference
            __props__.__dict__["friendly_name"] = friendly_name
            __props__.__dict__["is_case_insensitive"] = is_case_insensitive
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["max_time_travel_hours"] = max_time_travel_hours
            __props__.__dict__["project"] = project
            __props__.__dict__["resource_tags"] = resource_tags
            __props__.__dict__["storage_billing_model"] = storage_billing_model
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Dataset, __self__).__init__(
            'gcp:bigquery/dataset:Dataset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatasetAccessArgs', 'DatasetAccessArgsDict']]]]] = None,
            creation_time: Optional[pulumi.Input[builtins.int]] = None,
            dataset_id: Optional[pulumi.Input[builtins.str]] = None,
            default_collation: Optional[pulumi.Input[builtins.str]] = None,
            default_encryption_configuration: Optional[pulumi.Input[Union['DatasetDefaultEncryptionConfigurationArgs', 'DatasetDefaultEncryptionConfigurationArgsDict']]] = None,
            default_partition_expiration_ms: Optional[pulumi.Input[builtins.int]] = None,
            default_table_expiration_ms: Optional[pulumi.Input[builtins.int]] = None,
            delete_contents_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            external_catalog_dataset_options: Optional[pulumi.Input[Union['DatasetExternalCatalogDatasetOptionsArgs', 'DatasetExternalCatalogDatasetOptionsArgsDict']]] = None,
            external_dataset_reference: Optional[pulumi.Input[Union['DatasetExternalDatasetReferenceArgs', 'DatasetExternalDatasetReferenceArgsDict']]] = None,
            friendly_name: Optional[pulumi.Input[builtins.str]] = None,
            is_case_insensitive: Optional[pulumi.Input[builtins.bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            last_modified_time: Optional[pulumi.Input[builtins.int]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            max_time_travel_hours: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            storage_billing_model: Optional[pulumi.Input[builtins.str]] = None) -> 'Dataset':
        """
        Get an existing Dataset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatasetAccessArgs', 'DatasetAccessArgsDict']]]] accesses: An array of objects that define dataset access for one or more entities.
               Structure is documented below.
        :param pulumi.Input[builtins.int] creation_time: The time when this dataset was created, in milliseconds since the
               epoch.
        :param pulumi.Input[builtins.str] dataset_id: A unique ID for this dataset, without the project name. The ID
               must contain only letters (a-z, A-Z), numbers (0-9), or
               underscores (_). The maximum length is 1,024 characters.
               
               
               - - -
        :param pulumi.Input[builtins.str] default_collation: Defines the default collation specification of future tables created
               in the dataset. If a table is created in this dataset without table-level
               default collation, then the table inherits the dataset default collation,
               which is applied to the string fields that do not have explicit collation
               specified. A change to this field affects only tables created afterwards,
               and does not alter the existing tables.
               The following values are supported:
               - 'und:ci': undetermined locale, case insensitive.
               - '': empty string. Default to case-sensitive behavior.
        :param pulumi.Input[Union['DatasetDefaultEncryptionConfigurationArgs', 'DatasetDefaultEncryptionConfigurationArgsDict']] default_encryption_configuration: The default encryption key for all tables in the dataset. Once this property is set,
               all newly-created partitioned tables in the dataset will have encryption key set to
               this value, unless table creation request (or query) overrides the key.
               Structure is documented below.
        :param pulumi.Input[builtins.int] default_partition_expiration_ms: The default partition expiration for all partitioned tables in
               the dataset, in milliseconds.
               Once this property is set, all newly-created partitioned tables in
               the dataset will have an `expirationMs` property in the `timePartitioning`
               settings set to this value, and changing the value will only
               affect new tables, not existing ones. The storage in a partition will
               have an expiration time of its partition time plus this value.
               Setting this property overrides the use of `defaultTableExpirationMs`
               for partitioned tables: only one of `defaultTableExpirationMs` and
               `defaultPartitionExpirationMs` will be used for any new partitioned
               table. If you provide an explicit `timePartitioning.expirationMs` when
               creating or updating a partitioned table, that value takes precedence
               over the default partition expiration time indicated by this property.
        :param pulumi.Input[builtins.int] default_table_expiration_ms: The default lifetime of all tables in the dataset, in milliseconds.
               The minimum value is 3600000 milliseconds (one hour).
               Once this property is set, all newly-created tables in the dataset
               will have an `expirationTime` property set to the creation time plus
               the value in this property, and changing the value will only affect
               new tables, not existing ones. When the `expirationTime` for a given
               table is reached, that table will be deleted automatically.
               If a table's `expirationTime` is modified or removed before the
               table expires, or if you provide an explicit `expirationTime` when
               creating a table, that value takes precedence over the default
               expiration time indicated by this property.
        :param pulumi.Input[builtins.bool] delete_contents_on_destroy: If set to `true`, delete all the tables in the
               dataset when destroying the resource; otherwise,
               destroying the resource will fail if tables are present.
        :param pulumi.Input[builtins.str] description: A user-friendly description of the dataset
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] etag: A hash of the resource.
        :param pulumi.Input[Union['DatasetExternalCatalogDatasetOptionsArgs', 'DatasetExternalCatalogDatasetOptionsArgsDict']] external_catalog_dataset_options: Options defining open source compatible datasets living in the BigQuery catalog. Contains
               metadata of open source database, schema or namespace represented by the current dataset.
               Structure is documented below.
        :param pulumi.Input[Union['DatasetExternalDatasetReferenceArgs', 'DatasetExternalDatasetReferenceArgsDict']] external_dataset_reference: Information about the external metadata storage where the dataset is defined.
               Structure is documented below.
        :param pulumi.Input[builtins.str] friendly_name: A descriptive name for the dataset
        :param pulumi.Input[builtins.bool] is_case_insensitive: TRUE if the dataset and its table names are case-insensitive, otherwise FALSE.
               By default, this is FALSE, which means the dataset and its table names are
               case-sensitive. This field does not affect routine references.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels associated with this dataset. You can use these to
               organize and group your datasets.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.int] last_modified_time: The date when this dataset or any of its tables was last modified, in
               milliseconds since the epoch.
        :param pulumi.Input[builtins.str] location: The geographic location where the dataset should reside.
               See [official docs](https://cloud.google.com/bigquery/docs/dataset-locations).
               There are two types of locations, regional or multi-regional. A regional
               location is a specific geographic place, such as Tokyo, and a multi-regional
               location is a large geographic area, such as the United States, that
               contains at least two geographic places.
               The default value is multi-regional location `US`.
               Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] max_time_travel_hours: Defines the time travel window in hours. The value can be from 48 to 168 hours (2 to 7 days).
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] resource_tags: The tags attached to this table. Tag keys are globally unique. Tag key is expected to be
               in the namespaced format, for example "123456789012/environment" where 123456789012 is the
               ID of the parent organization or project resource for this tag key. Tag value is expected
               to be the short name, for example "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-control#definitions)
               for more details.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[builtins.str] storage_billing_model: Specifies the storage billing model for the dataset.
               Set this flag value to LOGICAL to use logical bytes for storage billing,
               or to PHYSICAL to use physical bytes instead.
               LOGICAL is the default if this flag isn't specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatasetState.__new__(_DatasetState)

        __props__.__dict__["accesses"] = accesses
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["dataset_id"] = dataset_id
        __props__.__dict__["default_collation"] = default_collation
        __props__.__dict__["default_encryption_configuration"] = default_encryption_configuration
        __props__.__dict__["default_partition_expiration_ms"] = default_partition_expiration_ms
        __props__.__dict__["default_table_expiration_ms"] = default_table_expiration_ms
        __props__.__dict__["delete_contents_on_destroy"] = delete_contents_on_destroy
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["external_catalog_dataset_options"] = external_catalog_dataset_options
        __props__.__dict__["external_dataset_reference"] = external_dataset_reference
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["is_case_insensitive"] = is_case_insensitive
        __props__.__dict__["labels"] = labels
        __props__.__dict__["last_modified_time"] = last_modified_time
        __props__.__dict__["location"] = location
        __props__.__dict__["max_time_travel_hours"] = max_time_travel_hours
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["resource_tags"] = resource_tags
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["storage_billing_model"] = storage_billing_model
        return Dataset(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accesses(self) -> pulumi.Output[Sequence['outputs.DatasetAccess']]:
        """
        An array of objects that define dataset access for one or more entities.
        Structure is documented below.
        """
        return pulumi.get(self, "accesses")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.int]:
        """
        The time when this dataset was created, in milliseconds since the
        epoch.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Output[builtins.str]:
        """
        A unique ID for this dataset, without the project name. The ID
        must contain only letters (a-z, A-Z), numbers (0-9), or
        underscores (_). The maximum length is 1,024 characters.


        - - -
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="defaultCollation")
    def default_collation(self) -> pulumi.Output[builtins.str]:
        """
        Defines the default collation specification of future tables created
        in the dataset. If a table is created in this dataset without table-level
        default collation, then the table inherits the dataset default collation,
        which is applied to the string fields that do not have explicit collation
        specified. A change to this field affects only tables created afterwards,
        and does not alter the existing tables.
        The following values are supported:
        - 'und:ci': undetermined locale, case insensitive.
        - '': empty string. Default to case-sensitive behavior.
        """
        return pulumi.get(self, "default_collation")

    @property
    @pulumi.getter(name="defaultEncryptionConfiguration")
    def default_encryption_configuration(self) -> pulumi.Output[Optional['outputs.DatasetDefaultEncryptionConfiguration']]:
        """
        The default encryption key for all tables in the dataset. Once this property is set,
        all newly-created partitioned tables in the dataset will have encryption key set to
        this value, unless table creation request (or query) overrides the key.
        Structure is documented below.
        """
        return pulumi.get(self, "default_encryption_configuration")

    @property
    @pulumi.getter(name="defaultPartitionExpirationMs")
    def default_partition_expiration_ms(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The default partition expiration for all partitioned tables in
        the dataset, in milliseconds.
        Once this property is set, all newly-created partitioned tables in
        the dataset will have an `expirationMs` property in the `timePartitioning`
        settings set to this value, and changing the value will only
        affect new tables, not existing ones. The storage in a partition will
        have an expiration time of its partition time plus this value.
        Setting this property overrides the use of `defaultTableExpirationMs`
        for partitioned tables: only one of `defaultTableExpirationMs` and
        `defaultPartitionExpirationMs` will be used for any new partitioned
        table. If you provide an explicit `timePartitioning.expirationMs` when
        creating or updating a partitioned table, that value takes precedence
        over the default partition expiration time indicated by this property.
        """
        return pulumi.get(self, "default_partition_expiration_ms")

    @property
    @pulumi.getter(name="defaultTableExpirationMs")
    def default_table_expiration_ms(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The default lifetime of all tables in the dataset, in milliseconds.
        The minimum value is 3600000 milliseconds (one hour).
        Once this property is set, all newly-created tables in the dataset
        will have an `expirationTime` property set to the creation time plus
        the value in this property, and changing the value will only affect
        new tables, not existing ones. When the `expirationTime` for a given
        table is reached, that table will be deleted automatically.
        If a table's `expirationTime` is modified or removed before the
        table expires, or if you provide an explicit `expirationTime` when
        creating a table, that value takes precedence over the default
        expiration time indicated by this property.
        """
        return pulumi.get(self, "default_table_expiration_ms")

    @property
    @pulumi.getter(name="deleteContentsOnDestroy")
    def delete_contents_on_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set to `true`, delete all the tables in the
        dataset when destroying the resource; otherwise,
        destroying the resource will fail if tables are present.
        """
        return pulumi.get(self, "delete_contents_on_destroy")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A user-friendly description of the dataset
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        A hash of the resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="externalCatalogDatasetOptions")
    def external_catalog_dataset_options(self) -> pulumi.Output[Optional['outputs.DatasetExternalCatalogDatasetOptions']]:
        """
        Options defining open source compatible datasets living in the BigQuery catalog. Contains
        metadata of open source database, schema or namespace represented by the current dataset.
        Structure is documented below.
        """
        return pulumi.get(self, "external_catalog_dataset_options")

    @property
    @pulumi.getter(name="externalDatasetReference")
    def external_dataset_reference(self) -> pulumi.Output[Optional['outputs.DatasetExternalDatasetReference']]:
        """
        Information about the external metadata storage where the dataset is defined.
        Structure is documented below.
        """
        return pulumi.get(self, "external_dataset_reference")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A descriptive name for the dataset
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="isCaseInsensitive")
    def is_case_insensitive(self) -> pulumi.Output[builtins.bool]:
        """
        TRUE if the dataset and its table names are case-insensitive, otherwise FALSE.
        By default, this is FALSE, which means the dataset and its table names are
        case-sensitive. This field does not affect routine references.
        """
        return pulumi.get(self, "is_case_insensitive")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The labels associated with this dataset. You can use these to
        organize and group your datasets.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[builtins.int]:
        """
        The date when this dataset or any of its tables was last modified, in
        milliseconds since the epoch.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The geographic location where the dataset should reside.
        See [official docs](https://cloud.google.com/bigquery/docs/dataset-locations).
        There are two types of locations, regional or multi-regional. A regional
        location is a specific geographic place, such as Tokyo, and a multi-regional
        location is a large geographic area, such as the United States, that
        contains at least two geographic places.
        The default value is multi-regional location `US`.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maxTimeTravelHours")
    def max_time_travel_hours(self) -> pulumi.Output[builtins.str]:
        """
        Defines the time travel window in hours. The value can be from 48 to 168 hours (2 to 7 days).
        """
        return pulumi.get(self, "max_time_travel_hours")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The tags attached to this table. Tag keys are globally unique. Tag key is expected to be
        in the namespaced format, for example "123456789012/environment" where 123456789012 is the
        ID of the parent organization or project resource for this tag key. Tag value is expected
        to be the short name, for example "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-control#definitions)
        for more details.
        """
        return pulumi.get(self, "resource_tags")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="storageBillingModel")
    def storage_billing_model(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the storage billing model for the dataset.
        Set this flag value to LOGICAL to use logical bytes for storage billing,
        or to PHYSICAL to use physical bytes instead.
        LOGICAL is the default if this flag isn't specified.
        """
        return pulumi.get(self, "storage_billing_model")

