# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTablesResult',
    'AwaitableGetTablesResult',
    'get_tables',
    'get_tables_output',
]

@pulumi.output_type
class GetTablesResult:
    """
    A collection of values returned by getTables.
    """
    def __init__(__self__, dataset_id=None, id=None, project=None, tables=None):
        if dataset_id and not isinstance(dataset_id, str):
            raise TypeError("Expected argument 'dataset_id' to be a str")
        pulumi.set(__self__, "dataset_id", dataset_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if tables and not isinstance(tables, list):
            raise TypeError("Expected argument 'tables' to be a list")
        pulumi.set(__self__, "tables", tables)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def tables(self) -> Sequence['outputs.GetTablesTableResult']:
        """
        A list of all retrieved BigQuery tables. Structure is defined below.
        """
        return pulumi.get(self, "tables")


class AwaitableGetTablesResult(GetTablesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTablesResult(
            dataset_id=self.dataset_id,
            id=self.id,
            project=self.project,
            tables=self.tables)


def get_tables(dataset_id: Optional[builtins.str] = None,
               project: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTablesResult:
    """
    Get a list of tables in a BigQuery dataset. For more information see
    the [official documentation](https://cloud.google.com/bigquery/docs)
    and [API](https://cloud.google.com/bigquery/docs/reference/rest/v2/tables).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    tables = gcp.bigquery.get_tables(dataset_id="my-bq-dataset",
        project="my-project")
    ```


    :param builtins.str dataset_id: The dataset ID.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['datasetId'] = dataset_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:bigquery/getTables:getTables', __args__, opts=opts, typ=GetTablesResult).value

    return AwaitableGetTablesResult(
        dataset_id=pulumi.get(__ret__, 'dataset_id'),
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        tables=pulumi.get(__ret__, 'tables'))
def get_tables_output(dataset_id: Optional[pulumi.Input[builtins.str]] = None,
                      project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTablesResult]:
    """
    Get a list of tables in a BigQuery dataset. For more information see
    the [official documentation](https://cloud.google.com/bigquery/docs)
    and [API](https://cloud.google.com/bigquery/docs/reference/rest/v2/tables).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    tables = gcp.bigquery.get_tables(dataset_id="my-bq-dataset",
        project="my-project")
    ```


    :param builtins.str dataset_id: The dataset ID.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['datasetId'] = dataset_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:bigquery/getTables:getTables', __args__, opts=opts, typ=GetTablesResult)
    return __ret__.apply(lambda __response__: GetTablesResult(
        dataset_id=pulumi.get(__response__, 'dataset_id'),
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project'),
        tables=pulumi.get(__response__, 'tables')))
