# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 job_id: pulumi.Input[builtins.str],
                 copy: Optional[pulumi.Input['JobCopyArgs']] = None,
                 extract: Optional[pulumi.Input['JobExtractArgs']] = None,
                 job_timeout_ms: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 load: Optional[pulumi.Input['JobLoadArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input['JobQueryArgs']] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[builtins.str] job_id: The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
        :param pulumi.Input['JobCopyArgs'] copy: Copies a table.
        :param pulumi.Input['JobExtractArgs'] extract: Configures an extract job.
        :param pulumi.Input[builtins.str] job_timeout_ms: Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels associated with this job. You can use these to organize and group your jobs. **Note**: This field is
               non-authoritative, and will only manage the labels present in your configuration. Please refer to the field
               'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input['JobLoadArgs'] load: Configures a load job.
        :param pulumi.Input[builtins.str] location: Specifies where the error occurred, if present.
        :param pulumi.Input['JobQueryArgs'] query: Configures a query job.
        """
        pulumi.set(__self__, "job_id", job_id)
        if copy is not None:
            pulumi.set(__self__, "copy", copy)
        if extract is not None:
            pulumi.set(__self__, "extract", extract)
        if job_timeout_ms is not None:
            pulumi.set(__self__, "job_timeout_ms", job_timeout_ms)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load is not None:
            pulumi.set(__self__, "load", load)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter
    def copy(self) -> Optional[pulumi.Input['JobCopyArgs']]:
        """
        Copies a table.
        """
        return pulumi.get(self, "copy")

    @copy.setter
    def copy(self, value: Optional[pulumi.Input['JobCopyArgs']]):
        pulumi.set(self, "copy", value)

    @property
    @pulumi.getter
    def extract(self) -> Optional[pulumi.Input['JobExtractArgs']]:
        """
        Configures an extract job.
        """
        return pulumi.get(self, "extract")

    @extract.setter
    def extract(self, value: Optional[pulumi.Input['JobExtractArgs']]):
        pulumi.set(self, "extract", value)

    @property
    @pulumi.getter(name="jobTimeoutMs")
    def job_timeout_ms(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
        """
        return pulumi.get(self, "job_timeout_ms")

    @job_timeout_ms.setter
    def job_timeout_ms(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_timeout_ms", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels associated with this job. You can use these to organize and group your jobs. **Note**: This field is
        non-authoritative, and will only manage the labels present in your configuration. Please refer to the field
        'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def load(self) -> Optional[pulumi.Input['JobLoadArgs']]:
        """
        Configures a load job.
        """
        return pulumi.get(self, "load")

    @load.setter
    def load(self, value: Optional[pulumi.Input['JobLoadArgs']]):
        pulumi.set(self, "load", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies where the error occurred, if present.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input['JobQueryArgs']]:
        """
        Configures a query job.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input['JobQueryArgs']]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 copy: Optional[pulumi.Input['JobCopyArgs']] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 extract: Optional[pulumi.Input['JobExtractArgs']] = None,
                 job_id: Optional[pulumi.Input[builtins.str]] = None,
                 job_timeout_ms: Optional[pulumi.Input[builtins.str]] = None,
                 job_type: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 load: Optional[pulumi.Input['JobLoadArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 query: Optional[pulumi.Input['JobQueryArgs']] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['JobStatusArgs']]]] = None,
                 user_email: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input['JobCopyArgs'] copy: Copies a table.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: (Output)
               All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['JobExtractArgs'] extract: Configures an extract job.
        :param pulumi.Input[builtins.str] job_id: The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
        :param pulumi.Input[builtins.str] job_timeout_ms: Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
        :param pulumi.Input[builtins.str] job_type: (Output)
               The type of the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels associated with this job. You can use these to organize and group your jobs. **Note**: This field is
               non-authoritative, and will only manage the labels present in your configuration. Please refer to the field
               'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input['JobLoadArgs'] load: Configures a load job.
        :param pulumi.Input[builtins.str] location: Specifies where the error occurred, if present.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: (Output)
               The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['JobQueryArgs'] query: Configures a query job.
        :param pulumi.Input[Sequence[pulumi.Input['JobStatusArgs']]] statuses: The status of this job. Examine this value when polling an asynchronous job to see if the job is complete.
               Structure is documented below.
        :param pulumi.Input[builtins.str] user_email: Email address of the user who ran the job.
        """
        if copy is not None:
            pulumi.set(__self__, "copy", copy)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if extract is not None:
            pulumi.set(__self__, "extract", extract)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if job_timeout_ms is not None:
            pulumi.set(__self__, "job_timeout_ms", job_timeout_ms)
        if job_type is not None:
            pulumi.set(__self__, "job_type", job_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load is not None:
            pulumi.set(__self__, "load", load)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if user_email is not None:
            pulumi.set(__self__, "user_email", user_email)

    @property
    @pulumi.getter
    def copy(self) -> Optional[pulumi.Input['JobCopyArgs']]:
        """
        Copies a table.
        """
        return pulumi.get(self, "copy")

    @copy.setter
    def copy(self, value: Optional[pulumi.Input['JobCopyArgs']]):
        pulumi.set(self, "copy", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Output)
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def extract(self) -> Optional[pulumi.Input['JobExtractArgs']]:
        """
        Configures an extract job.
        """
        return pulumi.get(self, "extract")

    @extract.setter
    def extract(self, value: Optional[pulumi.Input['JobExtractArgs']]):
        pulumi.set(self, "extract", value)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter(name="jobTimeoutMs")
    def job_timeout_ms(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
        """
        return pulumi.get(self, "job_timeout_ms")

    @job_timeout_ms.setter
    def job_timeout_ms(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_timeout_ms", value)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        The type of the job.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels associated with this job. You can use these to organize and group your jobs. **Note**: This field is
        non-authoritative, and will only manage the labels present in your configuration. Please refer to the field
        'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def load(self) -> Optional[pulumi.Input['JobLoadArgs']]:
        """
        Configures a load job.
        """
        return pulumi.get(self, "load")

    @load.setter
    def load(self, value: Optional[pulumi.Input['JobLoadArgs']]):
        pulumi.set(self, "load", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies where the error occurred, if present.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Output)
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input['JobQueryArgs']]:
        """
        Configures a query job.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input['JobQueryArgs']]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobStatusArgs']]]]:
        """
        The status of this job. Examine this value when polling an asynchronous job to see if the job is complete.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Email address of the user who ran the job.
        """
        return pulumi.get(self, "user_email")

    @user_email.setter
    def user_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_email", value)


@pulumi.type_token("gcp:bigquery/job:Job")
class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy: Optional[pulumi.Input[Union['JobCopyArgs', 'JobCopyArgsDict']]] = None,
                 extract: Optional[pulumi.Input[Union['JobExtractArgs', 'JobExtractArgsDict']]] = None,
                 job_id: Optional[pulumi.Input[builtins.str]] = None,
                 job_timeout_ms: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 load: Optional[pulumi.Input[Union['JobLoadArgs', 'JobLoadArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[Union['JobQueryArgs', 'JobQueryArgsDict']]] = None,
                 __props__=None):
        """
        Jobs are actions that BigQuery runs on your behalf to load data, export data, query data, or copy data.
        Once a BigQuery job is created, it cannot be changed or deleted.

        To get more information about Job, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs)
        * How-to Guides
            * [BigQuery Jobs Intro](https://cloud.google.com/bigquery/docs/jobs-overview)

        ## Example Usage

        ### Bigquery Job Query

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bar = gcp.bigquery.Dataset("bar",
            dataset_id="job_query_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        foo = gcp.bigquery.Table("foo",
            deletion_protection=False,
            dataset_id=bar.dataset_id,
            table_id="job_query_table")
        job = gcp.bigquery.Job("job",
            job_id="job_query",
            labels={
                "example-label": "example-value",
            },
            query={
                "query": "SELECT state FROM [lookerdata:cdc.project_tycho_reports]",
                "destination_table": {
                    "project_id": foo.project,
                    "dataset_id": foo.dataset_id,
                    "table_id": foo.table_id,
                },
                "allow_large_results": True,
                "flatten_results": True,
                "script_options": {
                    "key_result_statement": "LAST",
                },
            })
        ```
        ### Bigquery Job Query Table Reference

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bar = gcp.bigquery.Dataset("bar",
            dataset_id="job_query_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        foo = gcp.bigquery.Table("foo",
            deletion_protection=False,
            dataset_id=bar.dataset_id,
            table_id="job_query_table")
        job = gcp.bigquery.Job("job",
            job_id="job_query",
            labels={
                "example-label": "example-value",
            },
            query={
                "query": "SELECT state FROM [lookerdata:cdc.project_tycho_reports]",
                "destination_table": {
                    "table_id": foo.id,
                },
                "default_dataset": {
                    "dataset_id": bar.id,
                },
                "allow_large_results": True,
                "flatten_results": True,
                "script_options": {
                    "key_result_statement": "LAST",
                },
            })
        ```
        ### Bigquery Job Load

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bar = gcp.bigquery.Dataset("bar",
            dataset_id="job_load_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        foo = gcp.bigquery.Table("foo",
            deletion_protection=False,
            dataset_id=bar.dataset_id,
            table_id="job_load_table")
        job = gcp.bigquery.Job("job",
            job_id="job_load",
            labels={
                "my_job": "load",
            },
            load={
                "source_uris": ["gs://cloud-samples-data/bigquery/us-states/us-states-by-date.csv"],
                "destination_table": {
                    "project_id": foo.project,
                    "dataset_id": foo.dataset_id,
                    "table_id": foo.table_id,
                },
                "skip_leading_rows": 1,
                "schema_update_options": [
                    "ALLOW_FIELD_RELAXATION",
                    "ALLOW_FIELD_ADDITION",
                ],
                "write_disposition": "WRITE_APPEND",
                "autodetect": True,
            })
        ```
        ### Bigquery Job Load Geojson

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-bq-geojson",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="geojson-data.jsonl",
            bucket=bucket.name,
            content=\"\"\"{"type":"Feature","properties":{"continent":"Europe","region":"Scandinavia"},"geometry":{"type":"Polygon","coordinates":[[[-30.94,53.33],[33.05,53.33],[33.05,71.86],[-30.94,71.86],[-30.94,53.33]]]}}
        {"type":"Feature","properties":{"continent":"Africa","region":"West Africa"},"geometry":{"type":"Polygon","coordinates":[[[-23.91,0],[11.95,0],[11.95,18.98],[-23.91,18.98],[-23.91,0]]]}}
        \"\"\")
        bar = gcp.bigquery.Dataset("bar",
            dataset_id="job_load_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        foo = gcp.bigquery.Table("foo",
            deletion_protection=False,
            dataset_id=bar.dataset_id,
            table_id="job_load_table")
        job = gcp.bigquery.Job("job",
            job_id="job_load",
            labels={
                "my_job": "load",
            },
            load={
                "source_uris": [pulumi.Output.all(
                    bucket=object.bucket,
                    name=object.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucket']}/{resolved_outputs['name']}")
        ],
                "destination_table": {
                    "project_id": foo.project,
                    "dataset_id": foo.dataset_id,
                    "table_id": foo.table_id,
                },
                "write_disposition": "WRITE_TRUNCATE",
                "autodetect": True,
                "source_format": "NEWLINE_DELIMITED_JSON",
                "json_extension": "GEOJSON",
            },
            opts = pulumi.ResourceOptions(depends_on=[object]))
        ```
        ### Bigquery Job Load Parquet

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.storage.Bucket("test",
            name="job_load_bucket",
            location="US",
            uniform_bucket_level_access=True)
        test_bucket_object = gcp.storage.BucketObject("test",
            name="job_load_bucket_object",
            source=pulumi.FileAsset("./test-fixtures/test.parquet.gzip"),
            bucket=test.name)
        test_dataset = gcp.bigquery.Dataset("test",
            dataset_id="job_load_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        test_table = gcp.bigquery.Table("test",
            deletion_protection=False,
            table_id="job_load_table",
            dataset_id=test_dataset.dataset_id)
        job = gcp.bigquery.Job("job",
            job_id="job_load",
            labels={
                "my_job": "load",
            },
            load={
                "source_uris": [pulumi.Output.all(
                    bucket=test_bucket_object.bucket,
                    name=test_bucket_object.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucket']}/{resolved_outputs['name']}")
        ],
                "destination_table": {
                    "project_id": test_table.project,
                    "dataset_id": test_table.dataset_id,
                    "table_id": test_table.table_id,
                },
                "schema_update_options": [
                    "ALLOW_FIELD_RELAXATION",
                    "ALLOW_FIELD_ADDITION",
                ],
                "write_disposition": "WRITE_APPEND",
                "source_format": "PARQUET",
                "autodetect": True,
                "parquet_options": {
                    "enum_as_string": True,
                    "enable_list_inference": True,
                },
            })
        ```
        ### Bigquery Job Copy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        count = 2
        source_dataset = []
        for range in [{"value": i} for i in range(0, count)]:
            source_dataset.append(gcp.bigquery.Dataset(f"source-{range['value']}",
                dataset_id=f"job_copy_{range['value']}_dataset",
                friendly_name="test",
                description="This is a test description",
                location="US"))
        source = []
        for range in [{"value": i} for i in range(0, count)]:
            source.append(gcp.bigquery.Table(f"source-{range['value']}",
                dataset_id=source_dataset[range["value"]].dataset_id,
                table_id=f"job_copy_{range['value']}_table",
                deletion_protection=False,
                schema=\"\"\"[
          {
            "name": "name",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "post_abbr",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "date",
            "type": "DATE",
            "mode": "NULLABLE"
          }
        ]
        \"\"\"))
        dest_dataset = gcp.bigquery.Dataset("dest",
            dataset_id="job_copy_dest_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        project = gcp.organizations.get_project(project_id="my-project-name")
        encrypt_role = gcp.kms.CryptoKeyIAMMember("encrypt_role",
            crypto_key_id="example-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:bq-{project.number}@bigquery-encryption.iam.gserviceaccount.com")
        dest = gcp.bigquery.Table("dest",
            deletion_protection=False,
            dataset_id=dest_dataset.dataset_id,
            table_id="job_copy_dest_table",
            schema=\"\"\"[
          {
            "name": "name",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "post_abbr",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "date",
            "type": "DATE",
            "mode": "NULLABLE"
          }
        ]
        \"\"\",
            encryption_configuration={
                "kms_key_name": "example-key",
            },
            opts = pulumi.ResourceOptions(depends_on=[encrypt_role]))
        job = gcp.bigquery.Job("job",
            job_id="job_copy",
            copy={
                "source_tables": [
                    {
                        "project_id": source[0].project,
                        "dataset_id": source[0].dataset_id,
                        "table_id": source[0].table_id,
                    },
                    {
                        "project_id": source[1].project,
                        "dataset_id": source[1].dataset_id,
                        "table_id": source[1].table_id,
                    },
                ],
                "destination_table": {
                    "project_id": dest.project,
                    "dataset_id": dest.dataset_id,
                    "table_id": dest.table_id,
                },
                "destination_encryption_configuration": {
                    "kms_key_name": "example-key",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[encrypt_role]))
        ```
        ### Bigquery Job Extract

        ```python
        import pulumi
        import pulumi_gcp as gcp

        source_one_dataset = gcp.bigquery.Dataset("source-one",
            dataset_id="job_extract_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        source_one = gcp.bigquery.Table("source-one",
            deletion_protection=False,
            dataset_id=source_one_dataset.dataset_id,
            table_id="job_extract_table",
            schema=\"\"\"[
          {
            "name": "name",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "post_abbr",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "date",
            "type": "DATE",
            "mode": "NULLABLE"
          }
        ]
        \"\"\")
        dest = gcp.storage.Bucket("dest",
            name="job_extract_bucket",
            location="US",
            force_destroy=True)
        job = gcp.bigquery.Job("job",
            job_id="job_extract",
            extract={
                "destination_uris": [dest.url.apply(lambda url: f"{url}/extract")],
                "source_table": {
                    "project_id": source_one.project,
                    "dataset_id": source_one.dataset_id,
                    "table_id": source_one.table_id,
                },
                "destination_format": "NEWLINE_DELIMITED_JSON",
                "compression": "GZIP",
            })
        ```

        ## Import

        Job can be imported using any of these accepted formats:

        * `projects/{{project}}/jobs/{{job_id}}/location/{{location}}`

        * `projects/{{project}}/jobs/{{job_id}}`

        * `{{project}}/{{job_id}}/{{location}}`

        * `{{job_id}}/{{location}}`

        * `{{project}}/{{job_id}}`

        * `{{job_id}}`

        When using the `pulumi import` command, Job can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/job:Job default projects/{{project}}/jobs/{{job_id}}/location/{{location}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/job:Job default projects/{{project}}/jobs/{{job_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/job:Job default {{project}}/{{job_id}}/{{location}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/job:Job default {{job_id}}/{{location}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/job:Job default {{project}}/{{job_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/job:Job default {{job_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['JobCopyArgs', 'JobCopyArgsDict']] copy: Copies a table.
        :param pulumi.Input[Union['JobExtractArgs', 'JobExtractArgsDict']] extract: Configures an extract job.
        :param pulumi.Input[builtins.str] job_id: The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
        :param pulumi.Input[builtins.str] job_timeout_ms: Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels associated with this job. You can use these to organize and group your jobs. **Note**: This field is
               non-authoritative, and will only manage the labels present in your configuration. Please refer to the field
               'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[Union['JobLoadArgs', 'JobLoadArgsDict']] load: Configures a load job.
        :param pulumi.Input[builtins.str] location: Specifies where the error occurred, if present.
        :param pulumi.Input[Union['JobQueryArgs', 'JobQueryArgsDict']] query: Configures a query job.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Jobs are actions that BigQuery runs on your behalf to load data, export data, query data, or copy data.
        Once a BigQuery job is created, it cannot be changed or deleted.

        To get more information about Job, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs)
        * How-to Guides
            * [BigQuery Jobs Intro](https://cloud.google.com/bigquery/docs/jobs-overview)

        ## Example Usage

        ### Bigquery Job Query

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bar = gcp.bigquery.Dataset("bar",
            dataset_id="job_query_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        foo = gcp.bigquery.Table("foo",
            deletion_protection=False,
            dataset_id=bar.dataset_id,
            table_id="job_query_table")
        job = gcp.bigquery.Job("job",
            job_id="job_query",
            labels={
                "example-label": "example-value",
            },
            query={
                "query": "SELECT state FROM [lookerdata:cdc.project_tycho_reports]",
                "destination_table": {
                    "project_id": foo.project,
                    "dataset_id": foo.dataset_id,
                    "table_id": foo.table_id,
                },
                "allow_large_results": True,
                "flatten_results": True,
                "script_options": {
                    "key_result_statement": "LAST",
                },
            })
        ```
        ### Bigquery Job Query Table Reference

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bar = gcp.bigquery.Dataset("bar",
            dataset_id="job_query_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        foo = gcp.bigquery.Table("foo",
            deletion_protection=False,
            dataset_id=bar.dataset_id,
            table_id="job_query_table")
        job = gcp.bigquery.Job("job",
            job_id="job_query",
            labels={
                "example-label": "example-value",
            },
            query={
                "query": "SELECT state FROM [lookerdata:cdc.project_tycho_reports]",
                "destination_table": {
                    "table_id": foo.id,
                },
                "default_dataset": {
                    "dataset_id": bar.id,
                },
                "allow_large_results": True,
                "flatten_results": True,
                "script_options": {
                    "key_result_statement": "LAST",
                },
            })
        ```
        ### Bigquery Job Load

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bar = gcp.bigquery.Dataset("bar",
            dataset_id="job_load_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        foo = gcp.bigquery.Table("foo",
            deletion_protection=False,
            dataset_id=bar.dataset_id,
            table_id="job_load_table")
        job = gcp.bigquery.Job("job",
            job_id="job_load",
            labels={
                "my_job": "load",
            },
            load={
                "source_uris": ["gs://cloud-samples-data/bigquery/us-states/us-states-by-date.csv"],
                "destination_table": {
                    "project_id": foo.project,
                    "dataset_id": foo.dataset_id,
                    "table_id": foo.table_id,
                },
                "skip_leading_rows": 1,
                "schema_update_options": [
                    "ALLOW_FIELD_RELAXATION",
                    "ALLOW_FIELD_ADDITION",
                ],
                "write_disposition": "WRITE_APPEND",
                "autodetect": True,
            })
        ```
        ### Bigquery Job Load Geojson

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-bq-geojson",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="geojson-data.jsonl",
            bucket=bucket.name,
            content=\"\"\"{"type":"Feature","properties":{"continent":"Europe","region":"Scandinavia"},"geometry":{"type":"Polygon","coordinates":[[[-30.94,53.33],[33.05,53.33],[33.05,71.86],[-30.94,71.86],[-30.94,53.33]]]}}
        {"type":"Feature","properties":{"continent":"Africa","region":"West Africa"},"geometry":{"type":"Polygon","coordinates":[[[-23.91,0],[11.95,0],[11.95,18.98],[-23.91,18.98],[-23.91,0]]]}}
        \"\"\")
        bar = gcp.bigquery.Dataset("bar",
            dataset_id="job_load_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        foo = gcp.bigquery.Table("foo",
            deletion_protection=False,
            dataset_id=bar.dataset_id,
            table_id="job_load_table")
        job = gcp.bigquery.Job("job",
            job_id="job_load",
            labels={
                "my_job": "load",
            },
            load={
                "source_uris": [pulumi.Output.all(
                    bucket=object.bucket,
                    name=object.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucket']}/{resolved_outputs['name']}")
        ],
                "destination_table": {
                    "project_id": foo.project,
                    "dataset_id": foo.dataset_id,
                    "table_id": foo.table_id,
                },
                "write_disposition": "WRITE_TRUNCATE",
                "autodetect": True,
                "source_format": "NEWLINE_DELIMITED_JSON",
                "json_extension": "GEOJSON",
            },
            opts = pulumi.ResourceOptions(depends_on=[object]))
        ```
        ### Bigquery Job Load Parquet

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.storage.Bucket("test",
            name="job_load_bucket",
            location="US",
            uniform_bucket_level_access=True)
        test_bucket_object = gcp.storage.BucketObject("test",
            name="job_load_bucket_object",
            source=pulumi.FileAsset("./test-fixtures/test.parquet.gzip"),
            bucket=test.name)
        test_dataset = gcp.bigquery.Dataset("test",
            dataset_id="job_load_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        test_table = gcp.bigquery.Table("test",
            deletion_protection=False,
            table_id="job_load_table",
            dataset_id=test_dataset.dataset_id)
        job = gcp.bigquery.Job("job",
            job_id="job_load",
            labels={
                "my_job": "load",
            },
            load={
                "source_uris": [pulumi.Output.all(
                    bucket=test_bucket_object.bucket,
                    name=test_bucket_object.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucket']}/{resolved_outputs['name']}")
        ],
                "destination_table": {
                    "project_id": test_table.project,
                    "dataset_id": test_table.dataset_id,
                    "table_id": test_table.table_id,
                },
                "schema_update_options": [
                    "ALLOW_FIELD_RELAXATION",
                    "ALLOW_FIELD_ADDITION",
                ],
                "write_disposition": "WRITE_APPEND",
                "source_format": "PARQUET",
                "autodetect": True,
                "parquet_options": {
                    "enum_as_string": True,
                    "enable_list_inference": True,
                },
            })
        ```
        ### Bigquery Job Copy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        count = 2
        source_dataset = []
        for range in [{"value": i} for i in range(0, count)]:
            source_dataset.append(gcp.bigquery.Dataset(f"source-{range['value']}",
                dataset_id=f"job_copy_{range['value']}_dataset",
                friendly_name="test",
                description="This is a test description",
                location="US"))
        source = []
        for range in [{"value": i} for i in range(0, count)]:
            source.append(gcp.bigquery.Table(f"source-{range['value']}",
                dataset_id=source_dataset[range["value"]].dataset_id,
                table_id=f"job_copy_{range['value']}_table",
                deletion_protection=False,
                schema=\"\"\"[
          {
            "name": "name",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "post_abbr",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "date",
            "type": "DATE",
            "mode": "NULLABLE"
          }
        ]
        \"\"\"))
        dest_dataset = gcp.bigquery.Dataset("dest",
            dataset_id="job_copy_dest_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        project = gcp.organizations.get_project(project_id="my-project-name")
        encrypt_role = gcp.kms.CryptoKeyIAMMember("encrypt_role",
            crypto_key_id="example-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:bq-{project.number}@bigquery-encryption.iam.gserviceaccount.com")
        dest = gcp.bigquery.Table("dest",
            deletion_protection=False,
            dataset_id=dest_dataset.dataset_id,
            table_id="job_copy_dest_table",
            schema=\"\"\"[
          {
            "name": "name",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "post_abbr",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "date",
            "type": "DATE",
            "mode": "NULLABLE"
          }
        ]
        \"\"\",
            encryption_configuration={
                "kms_key_name": "example-key",
            },
            opts = pulumi.ResourceOptions(depends_on=[encrypt_role]))
        job = gcp.bigquery.Job("job",
            job_id="job_copy",
            copy={
                "source_tables": [
                    {
                        "project_id": source[0].project,
                        "dataset_id": source[0].dataset_id,
                        "table_id": source[0].table_id,
                    },
                    {
                        "project_id": source[1].project,
                        "dataset_id": source[1].dataset_id,
                        "table_id": source[1].table_id,
                    },
                ],
                "destination_table": {
                    "project_id": dest.project,
                    "dataset_id": dest.dataset_id,
                    "table_id": dest.table_id,
                },
                "destination_encryption_configuration": {
                    "kms_key_name": "example-key",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[encrypt_role]))
        ```
        ### Bigquery Job Extract

        ```python
        import pulumi
        import pulumi_gcp as gcp

        source_one_dataset = gcp.bigquery.Dataset("source-one",
            dataset_id="job_extract_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        source_one = gcp.bigquery.Table("source-one",
            deletion_protection=False,
            dataset_id=source_one_dataset.dataset_id,
            table_id="job_extract_table",
            schema=\"\"\"[
          {
            "name": "name",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "post_abbr",
            "type": "STRING",
            "mode": "NULLABLE"
          },
          {
            "name": "date",
            "type": "DATE",
            "mode": "NULLABLE"
          }
        ]
        \"\"\")
        dest = gcp.storage.Bucket("dest",
            name="job_extract_bucket",
            location="US",
            force_destroy=True)
        job = gcp.bigquery.Job("job",
            job_id="job_extract",
            extract={
                "destination_uris": [dest.url.apply(lambda url: f"{url}/extract")],
                "source_table": {
                    "project_id": source_one.project,
                    "dataset_id": source_one.dataset_id,
                    "table_id": source_one.table_id,
                },
                "destination_format": "NEWLINE_DELIMITED_JSON",
                "compression": "GZIP",
            })
        ```

        ## Import

        Job can be imported using any of these accepted formats:

        * `projects/{{project}}/jobs/{{job_id}}/location/{{location}}`

        * `projects/{{project}}/jobs/{{job_id}}`

        * `{{project}}/{{job_id}}/{{location}}`

        * `{{job_id}}/{{location}}`

        * `{{project}}/{{job_id}}`

        * `{{job_id}}`

        When using the `pulumi import` command, Job can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/job:Job default projects/{{project}}/jobs/{{job_id}}/location/{{location}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/job:Job default projects/{{project}}/jobs/{{job_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/job:Job default {{project}}/{{job_id}}/{{location}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/job:Job default {{job_id}}/{{location}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/job:Job default {{project}}/{{job_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/job:Job default {{job_id}}
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy: Optional[pulumi.Input[Union['JobCopyArgs', 'JobCopyArgsDict']]] = None,
                 extract: Optional[pulumi.Input[Union['JobExtractArgs', 'JobExtractArgsDict']]] = None,
                 job_id: Optional[pulumi.Input[builtins.str]] = None,
                 job_timeout_ms: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 load: Optional[pulumi.Input[Union['JobLoadArgs', 'JobLoadArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[Union['JobQueryArgs', 'JobQueryArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["copy"] = copy
            __props__.__dict__["extract"] = extract
            if job_id is None and not opts.urn:
                raise TypeError("Missing required property 'job_id'")
            __props__.__dict__["job_id"] = job_id
            __props__.__dict__["job_timeout_ms"] = job_timeout_ms
            __props__.__dict__["labels"] = labels
            __props__.__dict__["load"] = load
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["query"] = query
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["job_type"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["user_email"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Job, __self__).__init__(
            'gcp:bigquery/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            copy: Optional[pulumi.Input[Union['JobCopyArgs', 'JobCopyArgsDict']]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            extract: Optional[pulumi.Input[Union['JobExtractArgs', 'JobExtractArgsDict']]] = None,
            job_id: Optional[pulumi.Input[builtins.str]] = None,
            job_timeout_ms: Optional[pulumi.Input[builtins.str]] = None,
            job_type: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            load: Optional[pulumi.Input[Union['JobLoadArgs', 'JobLoadArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            query: Optional[pulumi.Input[Union['JobQueryArgs', 'JobQueryArgsDict']]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobStatusArgs', 'JobStatusArgsDict']]]]] = None,
            user_email: Optional[pulumi.Input[builtins.str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['JobCopyArgs', 'JobCopyArgsDict']] copy: Copies a table.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: (Output)
               All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['JobExtractArgs', 'JobExtractArgsDict']] extract: Configures an extract job.
        :param pulumi.Input[builtins.str] job_id: The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
        :param pulumi.Input[builtins.str] job_timeout_ms: Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
        :param pulumi.Input[builtins.str] job_type: (Output)
               The type of the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels associated with this job. You can use these to organize and group your jobs. **Note**: This field is
               non-authoritative, and will only manage the labels present in your configuration. Please refer to the field
               'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[Union['JobLoadArgs', 'JobLoadArgsDict']] load: Configures a load job.
        :param pulumi.Input[builtins.str] location: Specifies where the error occurred, if present.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: (Output)
               The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['JobQueryArgs', 'JobQueryArgsDict']] query: Configures a query job.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobStatusArgs', 'JobStatusArgsDict']]]] statuses: The status of this job. Examine this value when polling an asynchronous job to see if the job is complete.
               Structure is documented below.
        :param pulumi.Input[builtins.str] user_email: Email address of the user who ran the job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["copy"] = copy
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["extract"] = extract
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["job_timeout_ms"] = job_timeout_ms
        __props__.__dict__["job_type"] = job_type
        __props__.__dict__["labels"] = labels
        __props__.__dict__["load"] = load
        __props__.__dict__["location"] = location
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["query"] = query
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["user_email"] = user_email
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def copy(self) -> pulumi.Output[Optional['outputs.JobCopy']]:
        """
        Copies a table.
        """
        return pulumi.get(self, "copy")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Output)
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def extract(self) -> pulumi.Output[Optional['outputs.JobExtract']]:
        """
        Configures an extract job.
        """
        return pulumi.get(self, "extract")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter(name="jobTimeoutMs")
    def job_timeout_ms(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
        """
        return pulumi.get(self, "job_timeout_ms")

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Output[builtins.str]:
        """
        (Output)
        The type of the job.
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The labels associated with this job. You can use these to organize and group your jobs. **Note**: This field is
        non-authoritative, and will only manage the labels present in your configuration. Please refer to the field
        'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def load(self) -> pulumi.Output[Optional['outputs.JobLoad']]:
        """
        Configures a load job.
        """
        return pulumi.get(self, "load")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies where the error occurred, if present.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Output)
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def query(self) -> pulumi.Output[Optional['outputs.JobQuery']]:
        """
        Configures a query job.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.JobStatus']]:
        """
        The status of this job. Examine this value when polling an asynchronous job to see if the job is complete.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> pulumi.Output[builtins.str]:
        """
        Email address of the user who ran the job.
        """
        return pulumi.get(self, "user_email")

