# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RowAccessPolicyArgs', 'RowAccessPolicy']

@pulumi.input_type
class RowAccessPolicyArgs:
    def __init__(__self__, *,
                 dataset_id: pulumi.Input[builtins.str],
                 filter_predicate: pulumi.Input[builtins.str],
                 policy_id: pulumi.Input[builtins.str],
                 table_id: pulumi.Input[builtins.str],
                 grantees: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a RowAccessPolicy resource.
        :param pulumi.Input[builtins.str] dataset_id: The ID of the dataset containing this row access policy.
        :param pulumi.Input[builtins.str] filter_predicate: A SQL boolean expression that represents the rows defined by this row
               access policy, similar to the boolean expression in a WHERE clause of a
               SELECT query on a table.
               References to other tables, routines, and temporary functions are not
               supported.
               Examples: region="EU"
               date_field = CAST('2019-9-27' as DATE)
               nullable_field is not NULL
               numeric_field BETWEEN 1.0 AND 5.0
               
               
               - - -
        :param pulumi.Input[builtins.str] policy_id: The ID of the row access policy. The ID must contain only
               letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum
               length is 256 characters.
        :param pulumi.Input[builtins.str] table_id: The ID of the table containing this row access policy.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] grantees: Input only. The optional list of iam_member users or groups that specifies the initial
               members that the row-level access policy should be created with.
               grantees types:
               - "user:alice@example.com": An email address that represents a specific
               Google account.
               - "serviceAccount:my-other-app@appspot.gserviceaccount.com": An email
               address that represents a service account.
               - "group:admins@example.com": An email address that represents a Google
               group.
               - "domain:example.com":The Google Workspace domain (primary) that
               represents all the users of that domain.
               - "allAuthenticatedUsers": A special identifier that represents all service
               accounts and all users on the internet who have authenticated with a Google
               Account. This identifier includes accounts that aren't connected to a
               Google Workspace or Cloud Identity domain, such as personal Gmail accounts.
               Users who aren't authenticated, such as anonymous visitors, aren't
               included.
               - "allUsers":A special identifier that represents anyone who is on
               the internet, including authenticated and unauthenticated users. Because
               BigQuery requires authentication before a user can access the service,
               allUsers includes only authenticated users.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "filter_predicate", filter_predicate)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "table_id", table_id)
        if grantees is not None:
            pulumi.set(__self__, "grantees", grantees)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the dataset containing this row access policy.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="filterPredicate")
    def filter_predicate(self) -> pulumi.Input[builtins.str]:
        """
        A SQL boolean expression that represents the rows defined by this row
        access policy, similar to the boolean expression in a WHERE clause of a
        SELECT query on a table.
        References to other tables, routines, and temporary functions are not
        supported.
        Examples: region="EU"
        date_field = CAST('2019-9-27' as DATE)
        nullable_field is not NULL
        numeric_field BETWEEN 1.0 AND 5.0


        - - -
        """
        return pulumi.get(self, "filter_predicate")

    @filter_predicate.setter
    def filter_predicate(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "filter_predicate", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the row access policy. The ID must contain only
        letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum
        length is 256 characters.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the table containing this row access policy.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "table_id", value)

    @property
    @pulumi.getter
    def grantees(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Input only. The optional list of iam_member users or groups that specifies the initial
        members that the row-level access policy should be created with.
        grantees types:
        - "user:alice@example.com": An email address that represents a specific
        Google account.
        - "serviceAccount:my-other-app@appspot.gserviceaccount.com": An email
        address that represents a service account.
        - "group:admins@example.com": An email address that represents a Google
        group.
        - "domain:example.com":The Google Workspace domain (primary) that
        represents all the users of that domain.
        - "allAuthenticatedUsers": A special identifier that represents all service
        accounts and all users on the internet who have authenticated with a Google
        Account. This identifier includes accounts that aren't connected to a
        Google Workspace or Cloud Identity domain, such as personal Gmail accounts.
        Users who aren't authenticated, such as anonymous visitors, aren't
        included.
        - "allUsers":A special identifier that represents anyone who is on
        the internet, including authenticated and unauthenticated users. Because
        BigQuery requires authentication before a user can access the service,
        allUsers includes only authenticated users.
        """
        return pulumi.get(self, "grantees")

    @grantees.setter
    def grantees(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "grantees", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _RowAccessPolicyState:
    def __init__(__self__, *,
                 creation_time: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_id: Optional[pulumi.Input[builtins.str]] = None,
                 filter_predicate: Optional[pulumi.Input[builtins.str]] = None,
                 grantees: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 last_modified_time: Optional[pulumi.Input[builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 table_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RowAccessPolicy resources.
        :param pulumi.Input[builtins.str] creation_time: The time when this row access policy was created, in milliseconds since
               the epoch.
        :param pulumi.Input[builtins.str] dataset_id: The ID of the dataset containing this row access policy.
        :param pulumi.Input[builtins.str] filter_predicate: A SQL boolean expression that represents the rows defined by this row
               access policy, similar to the boolean expression in a WHERE clause of a
               SELECT query on a table.
               References to other tables, routines, and temporary functions are not
               supported.
               Examples: region="EU"
               date_field = CAST('2019-9-27' as DATE)
               nullable_field is not NULL
               numeric_field BETWEEN 1.0 AND 5.0
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] grantees: Input only. The optional list of iam_member users or groups that specifies the initial
               members that the row-level access policy should be created with.
               grantees types:
               - "user:alice@example.com": An email address that represents a specific
               Google account.
               - "serviceAccount:my-other-app@appspot.gserviceaccount.com": An email
               address that represents a service account.
               - "group:admins@example.com": An email address that represents a Google
               group.
               - "domain:example.com":The Google Workspace domain (primary) that
               represents all the users of that domain.
               - "allAuthenticatedUsers": A special identifier that represents all service
               accounts and all users on the internet who have authenticated with a Google
               Account. This identifier includes accounts that aren't connected to a
               Google Workspace or Cloud Identity domain, such as personal Gmail accounts.
               Users who aren't authenticated, such as anonymous visitors, aren't
               included.
               - "allUsers":A special identifier that represents anyone who is on
               the internet, including authenticated and unauthenticated users. Because
               BigQuery requires authentication before a user can access the service,
               allUsers includes only authenticated users.
        :param pulumi.Input[builtins.str] last_modified_time: The time when this row access policy was last modified, in milliseconds
               since the epoch.
        :param pulumi.Input[builtins.str] policy_id: The ID of the row access policy. The ID must contain only
               letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum
               length is 256 characters.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] table_id: The ID of the table containing this row access policy.
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if filter_predicate is not None:
            pulumi.set(__self__, "filter_predicate", filter_predicate)
        if grantees is not None:
            pulumi.set(__self__, "grantees", grantees)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if table_id is not None:
            pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when this row access policy was created, in milliseconds since
        the epoch.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the dataset containing this row access policy.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="filterPredicate")
    def filter_predicate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A SQL boolean expression that represents the rows defined by this row
        access policy, similar to the boolean expression in a WHERE clause of a
        SELECT query on a table.
        References to other tables, routines, and temporary functions are not
        supported.
        Examples: region="EU"
        date_field = CAST('2019-9-27' as DATE)
        nullable_field is not NULL
        numeric_field BETWEEN 1.0 AND 5.0


        - - -
        """
        return pulumi.get(self, "filter_predicate")

    @filter_predicate.setter
    def filter_predicate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter_predicate", value)

    @property
    @pulumi.getter
    def grantees(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Input only. The optional list of iam_member users or groups that specifies the initial
        members that the row-level access policy should be created with.
        grantees types:
        - "user:alice@example.com": An email address that represents a specific
        Google account.
        - "serviceAccount:my-other-app@appspot.gserviceaccount.com": An email
        address that represents a service account.
        - "group:admins@example.com": An email address that represents a Google
        group.
        - "domain:example.com":The Google Workspace domain (primary) that
        represents all the users of that domain.
        - "allAuthenticatedUsers": A special identifier that represents all service
        accounts and all users on the internet who have authenticated with a Google
        Account. This identifier includes accounts that aren't connected to a
        Google Workspace or Cloud Identity domain, such as personal Gmail accounts.
        Users who aren't authenticated, such as anonymous visitors, aren't
        included.
        - "allUsers":A special identifier that represents anyone who is on
        the internet, including authenticated and unauthenticated users. Because
        BigQuery requires authentication before a user can access the service,
        allUsers includes only authenticated users.
        """
        return pulumi.get(self, "grantees")

    @grantees.setter
    def grantees(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "grantees", value)

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when this row access policy was last modified, in milliseconds
        since the epoch.
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modified_time", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the row access policy. The ID must contain only
        letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum
        length is 256 characters.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the table containing this row access policy.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "table_id", value)


@pulumi.type_token("gcp:bigquery/rowAccessPolicy:RowAccessPolicy")
class RowAccessPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset_id: Optional[pulumi.Input[builtins.str]] = None,
                 filter_predicate: Optional[pulumi.Input[builtins.str]] = None,
                 grantees: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 table_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Represents access on a subset of rows on the specified table, defined by its filter predicate. Access to the subset of rows is controlled by its IAM policy.

        ## Example Usage

        ### Bigquery Row Access Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.bigquery.Dataset("example",
            dataset_id="dataset_id",
            location="US")
        example_table = gcp.bigquery.Table("example",
            deletion_protection=False,
            dataset_id=example.dataset_id,
            table_id="table_id")
        example_row_access_policy = gcp.bigquery.RowAccessPolicy("example",
            dataset_id=example.dataset_id,
            table_id=example_table.table_id,
            policy_id="policy_id",
            filter_predicate="nullable_field is not NULL",
            grantees=["domain:google.com"])
        ```

        ## Import

        RowAccessPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}/rowAccessPolicies/{{policy_id}}`

        * `{{project}}/{{dataset_id}}/{{table_id}}/{{policy_id}}`

        * `{{dataset_id}}/{{table_id}}/{{policy_id}}`

        When using the `pulumi import` command, RowAccessPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/rowAccessPolicy:RowAccessPolicy default projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}/rowAccessPolicies/{{policy_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/rowAccessPolicy:RowAccessPolicy default {{project}}/{{dataset_id}}/{{table_id}}/{{policy_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/rowAccessPolicy:RowAccessPolicy default {{dataset_id}}/{{table_id}}/{{policy_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] dataset_id: The ID of the dataset containing this row access policy.
        :param pulumi.Input[builtins.str] filter_predicate: A SQL boolean expression that represents the rows defined by this row
               access policy, similar to the boolean expression in a WHERE clause of a
               SELECT query on a table.
               References to other tables, routines, and temporary functions are not
               supported.
               Examples: region="EU"
               date_field = CAST('2019-9-27' as DATE)
               nullable_field is not NULL
               numeric_field BETWEEN 1.0 AND 5.0
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] grantees: Input only. The optional list of iam_member users or groups that specifies the initial
               members that the row-level access policy should be created with.
               grantees types:
               - "user:alice@example.com": An email address that represents a specific
               Google account.
               - "serviceAccount:my-other-app@appspot.gserviceaccount.com": An email
               address that represents a service account.
               - "group:admins@example.com": An email address that represents a Google
               group.
               - "domain:example.com":The Google Workspace domain (primary) that
               represents all the users of that domain.
               - "allAuthenticatedUsers": A special identifier that represents all service
               accounts and all users on the internet who have authenticated with a Google
               Account. This identifier includes accounts that aren't connected to a
               Google Workspace or Cloud Identity domain, such as personal Gmail accounts.
               Users who aren't authenticated, such as anonymous visitors, aren't
               included.
               - "allUsers":A special identifier that represents anyone who is on
               the internet, including authenticated and unauthenticated users. Because
               BigQuery requires authentication before a user can access the service,
               allUsers includes only authenticated users.
        :param pulumi.Input[builtins.str] policy_id: The ID of the row access policy. The ID must contain only
               letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum
               length is 256 characters.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] table_id: The ID of the table containing this row access policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RowAccessPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents access on a subset of rows on the specified table, defined by its filter predicate. Access to the subset of rows is controlled by its IAM policy.

        ## Example Usage

        ### Bigquery Row Access Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.bigquery.Dataset("example",
            dataset_id="dataset_id",
            location="US")
        example_table = gcp.bigquery.Table("example",
            deletion_protection=False,
            dataset_id=example.dataset_id,
            table_id="table_id")
        example_row_access_policy = gcp.bigquery.RowAccessPolicy("example",
            dataset_id=example.dataset_id,
            table_id=example_table.table_id,
            policy_id="policy_id",
            filter_predicate="nullable_field is not NULL",
            grantees=["domain:google.com"])
        ```

        ## Import

        RowAccessPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}/rowAccessPolicies/{{policy_id}}`

        * `{{project}}/{{dataset_id}}/{{table_id}}/{{policy_id}}`

        * `{{dataset_id}}/{{table_id}}/{{policy_id}}`

        When using the `pulumi import` command, RowAccessPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/rowAccessPolicy:RowAccessPolicy default projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}/rowAccessPolicies/{{policy_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/rowAccessPolicy:RowAccessPolicy default {{project}}/{{dataset_id}}/{{table_id}}/{{policy_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/rowAccessPolicy:RowAccessPolicy default {{dataset_id}}/{{table_id}}/{{policy_id}}
        ```

        :param str resource_name: The name of the resource.
        :param RowAccessPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RowAccessPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset_id: Optional[pulumi.Input[builtins.str]] = None,
                 filter_predicate: Optional[pulumi.Input[builtins.str]] = None,
                 grantees: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 table_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RowAccessPolicyArgs.__new__(RowAccessPolicyArgs)

            if dataset_id is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_id'")
            __props__.__dict__["dataset_id"] = dataset_id
            if filter_predicate is None and not opts.urn:
                raise TypeError("Missing required property 'filter_predicate'")
            __props__.__dict__["filter_predicate"] = filter_predicate
            __props__.__dict__["grantees"] = grantees
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["project"] = project
            if table_id is None and not opts.urn:
                raise TypeError("Missing required property 'table_id'")
            __props__.__dict__["table_id"] = table_id
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["last_modified_time"] = None
        super(RowAccessPolicy, __self__).__init__(
            'gcp:bigquery/rowAccessPolicy:RowAccessPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_time: Optional[pulumi.Input[builtins.str]] = None,
            dataset_id: Optional[pulumi.Input[builtins.str]] = None,
            filter_predicate: Optional[pulumi.Input[builtins.str]] = None,
            grantees: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            last_modified_time: Optional[pulumi.Input[builtins.str]] = None,
            policy_id: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            table_id: Optional[pulumi.Input[builtins.str]] = None) -> 'RowAccessPolicy':
        """
        Get an existing RowAccessPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] creation_time: The time when this row access policy was created, in milliseconds since
               the epoch.
        :param pulumi.Input[builtins.str] dataset_id: The ID of the dataset containing this row access policy.
        :param pulumi.Input[builtins.str] filter_predicate: A SQL boolean expression that represents the rows defined by this row
               access policy, similar to the boolean expression in a WHERE clause of a
               SELECT query on a table.
               References to other tables, routines, and temporary functions are not
               supported.
               Examples: region="EU"
               date_field = CAST('2019-9-27' as DATE)
               nullable_field is not NULL
               numeric_field BETWEEN 1.0 AND 5.0
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] grantees: Input only. The optional list of iam_member users or groups that specifies the initial
               members that the row-level access policy should be created with.
               grantees types:
               - "user:alice@example.com": An email address that represents a specific
               Google account.
               - "serviceAccount:my-other-app@appspot.gserviceaccount.com": An email
               address that represents a service account.
               - "group:admins@example.com": An email address that represents a Google
               group.
               - "domain:example.com":The Google Workspace domain (primary) that
               represents all the users of that domain.
               - "allAuthenticatedUsers": A special identifier that represents all service
               accounts and all users on the internet who have authenticated with a Google
               Account. This identifier includes accounts that aren't connected to a
               Google Workspace or Cloud Identity domain, such as personal Gmail accounts.
               Users who aren't authenticated, such as anonymous visitors, aren't
               included.
               - "allUsers":A special identifier that represents anyone who is on
               the internet, including authenticated and unauthenticated users. Because
               BigQuery requires authentication before a user can access the service,
               allUsers includes only authenticated users.
        :param pulumi.Input[builtins.str] last_modified_time: The time when this row access policy was last modified, in milliseconds
               since the epoch.
        :param pulumi.Input[builtins.str] policy_id: The ID of the row access policy. The ID must contain only
               letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum
               length is 256 characters.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] table_id: The ID of the table containing this row access policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RowAccessPolicyState.__new__(_RowAccessPolicyState)

        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["dataset_id"] = dataset_id
        __props__.__dict__["filter_predicate"] = filter_predicate
        __props__.__dict__["grantees"] = grantees
        __props__.__dict__["last_modified_time"] = last_modified_time
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["project"] = project
        __props__.__dict__["table_id"] = table_id
        return RowAccessPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when this row access policy was created, in milliseconds since
        the epoch.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the dataset containing this row access policy.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="filterPredicate")
    def filter_predicate(self) -> pulumi.Output[builtins.str]:
        """
        A SQL boolean expression that represents the rows defined by this row
        access policy, similar to the boolean expression in a WHERE clause of a
        SELECT query on a table.
        References to other tables, routines, and temporary functions are not
        supported.
        Examples: region="EU"
        date_field = CAST('2019-9-27' as DATE)
        nullable_field is not NULL
        numeric_field BETWEEN 1.0 AND 5.0


        - - -
        """
        return pulumi.get(self, "filter_predicate")

    @property
    @pulumi.getter
    def grantees(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Input only. The optional list of iam_member users or groups that specifies the initial
        members that the row-level access policy should be created with.
        grantees types:
        - "user:alice@example.com": An email address that represents a specific
        Google account.
        - "serviceAccount:my-other-app@appspot.gserviceaccount.com": An email
        address that represents a service account.
        - "group:admins@example.com": An email address that represents a Google
        group.
        - "domain:example.com":The Google Workspace domain (primary) that
        represents all the users of that domain.
        - "allAuthenticatedUsers": A special identifier that represents all service
        accounts and all users on the internet who have authenticated with a Google
        Account. This identifier includes accounts that aren't connected to a
        Google Workspace or Cloud Identity domain, such as personal Gmail accounts.
        Users who aren't authenticated, such as anonymous visitors, aren't
        included.
        - "allUsers":A special identifier that represents anyone who is on
        the internet, including authenticated and unauthenticated users. Because
        BigQuery requires authentication before a user can access the service,
        allUsers includes only authenticated users.
        """
        return pulumi.get(self, "grantees")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when this row access policy was last modified, in milliseconds
        since the epoch.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the row access policy. The ID must contain only
        letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum
        length is 256 characters.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the table containing this row access policy.
        """
        return pulumi.get(self, "table_id")

