# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListingSubscriptionArgs', 'ListingSubscription']

@pulumi.input_type
class ListingSubscriptionArgs:
    def __init__(__self__, *,
                 data_exchange_id: pulumi.Input[builtins.str],
                 destination_dataset: pulumi.Input['ListingSubscriptionDestinationDatasetArgs'],
                 listing_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ListingSubscription resource.
        :param pulumi.Input[builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input['ListingSubscriptionDestinationDatasetArgs'] destination_dataset: The destination dataset for this subscription.
               Structure is documented below.
        :param pulumi.Input[builtins.str] listing_id: The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[builtins.str] location: The name of the location of the data exchange. Distinct from the location of the destination data set.
        """
        pulumi.set(__self__, "data_exchange_id", data_exchange_id)
        pulumi.set(__self__, "destination_dataset", destination_dataset)
        pulumi.set(__self__, "listing_id", listing_id)
        pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @data_exchange_id.setter
    def data_exchange_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_exchange_id", value)

    @property
    @pulumi.getter(name="destinationDataset")
    def destination_dataset(self) -> pulumi.Input['ListingSubscriptionDestinationDatasetArgs']:
        """
        The destination dataset for this subscription.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_dataset")

    @destination_dataset.setter
    def destination_dataset(self, value: pulumi.Input['ListingSubscriptionDestinationDatasetArgs']):
        pulumi.set(self, "destination_dataset", value)

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "listing_id")

    @listing_id.setter
    def listing_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "listing_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The name of the location of the data exchange. Distinct from the location of the destination data set.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ListingSubscriptionState:
    def __init__(__self__, *,
                 creation_time: Optional[pulumi.Input[builtins.str]] = None,
                 data_exchange_id: Optional[pulumi.Input[builtins.str]] = None,
                 destination_dataset: Optional[pulumi.Input['ListingSubscriptionDestinationDatasetArgs']] = None,
                 last_modify_time: Optional[pulumi.Input[builtins.str]] = None,
                 linked_dataset_maps: Optional[pulumi.Input[Sequence[pulumi.Input['ListingSubscriptionLinkedDatasetMapArgs']]]] = None,
                 linked_resources: Optional[pulumi.Input[Sequence[pulumi.Input['ListingSubscriptionLinkedResourceArgs']]]] = None,
                 listing_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 log_linked_dataset_query_user_email: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subscriber_contact: Optional[pulumi.Input[builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ListingSubscription resources.
        :param pulumi.Input[builtins.str] creation_time: Timestamp when the subscription was created.
        :param pulumi.Input[builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input['ListingSubscriptionDestinationDatasetArgs'] destination_dataset: The destination dataset for this subscription.
               Structure is documented below.
        :param pulumi.Input[builtins.str] last_modify_time: Timestamp when the subscription was last modified.
        :param pulumi.Input[Sequence[pulumi.Input['ListingSubscriptionLinkedDatasetMapArgs']]] linked_dataset_maps: Output only. Map of listing resource names to associated linked resource,
               e.g. projects/123/locations/US/dataExchanges/456/listings/789 > projects/123/datasets/my_dataset
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ListingSubscriptionLinkedResourceArgs']]] linked_resources: Output only. Linked resources created in the subscription. Only contains values if state = STATE_ACTIVE.
               Structure is documented below.
        :param pulumi.Input[builtins.str] listing_id: The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[builtins.str] location: The name of the location of the data exchange. Distinct from the location of the destination data set.
        :param pulumi.Input[builtins.bool] log_linked_dataset_query_user_email: Output only. By default, false. If true, the Subscriber agreed to the email sharing mandate that is enabled for Listing.
        :param pulumi.Input[builtins.str] name: The resource name of the subscription. e.g. "projects/myproject/locations/US/subscriptions/123"
        :param pulumi.Input[builtins.str] organization_display_name: Display name of the project of this subscription.
        :param pulumi.Input[builtins.str] organization_id: Organization of the project this subscription belongs to.
        :param pulumi.Input[builtins.str] resource_type: Listing shared asset type.
        :param pulumi.Input[builtins.str] state: Current state of the subscription.
        :param pulumi.Input[builtins.str] subscriber_contact: Email of the subscriber.
        :param pulumi.Input[builtins.str] subscription_id: The subscription id used to reference the subscription.
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if data_exchange_id is not None:
            pulumi.set(__self__, "data_exchange_id", data_exchange_id)
        if destination_dataset is not None:
            pulumi.set(__self__, "destination_dataset", destination_dataset)
        if last_modify_time is not None:
            pulumi.set(__self__, "last_modify_time", last_modify_time)
        if linked_dataset_maps is not None:
            pulumi.set(__self__, "linked_dataset_maps", linked_dataset_maps)
        if linked_resources is not None:
            pulumi.set(__self__, "linked_resources", linked_resources)
        if listing_id is not None:
            pulumi.set(__self__, "listing_id", listing_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_linked_dataset_query_user_email is not None:
            pulumi.set(__self__, "log_linked_dataset_query_user_email", log_linked_dataset_query_user_email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_display_name is not None:
            pulumi.set(__self__, "organization_display_name", organization_display_name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscriber_contact is not None:
            pulumi.set(__self__, "subscriber_contact", subscriber_contact)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp when the subscription was created.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @data_exchange_id.setter
    def data_exchange_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_exchange_id", value)

    @property
    @pulumi.getter(name="destinationDataset")
    def destination_dataset(self) -> Optional[pulumi.Input['ListingSubscriptionDestinationDatasetArgs']]:
        """
        The destination dataset for this subscription.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_dataset")

    @destination_dataset.setter
    def destination_dataset(self, value: Optional[pulumi.Input['ListingSubscriptionDestinationDatasetArgs']]):
        pulumi.set(self, "destination_dataset", value)

    @property
    @pulumi.getter(name="lastModifyTime")
    def last_modify_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp when the subscription was last modified.
        """
        return pulumi.get(self, "last_modify_time")

    @last_modify_time.setter
    def last_modify_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modify_time", value)

    @property
    @pulumi.getter(name="linkedDatasetMaps")
    def linked_dataset_maps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListingSubscriptionLinkedDatasetMapArgs']]]]:
        """
        Output only. Map of listing resource names to associated linked resource,
        e.g. projects/123/locations/US/dataExchanges/456/listings/789 > projects/123/datasets/my_dataset
        Structure is documented below.
        """
        return pulumi.get(self, "linked_dataset_maps")

    @linked_dataset_maps.setter
    def linked_dataset_maps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListingSubscriptionLinkedDatasetMapArgs']]]]):
        pulumi.set(self, "linked_dataset_maps", value)

    @property
    @pulumi.getter(name="linkedResources")
    def linked_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListingSubscriptionLinkedResourceArgs']]]]:
        """
        Output only. Linked resources created in the subscription. Only contains values if state = STATE_ACTIVE.
        Structure is documented below.
        """
        return pulumi.get(self, "linked_resources")

    @linked_resources.setter
    def linked_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListingSubscriptionLinkedResourceArgs']]]]):
        pulumi.set(self, "linked_resources", value)

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "listing_id")

    @listing_id.setter
    def listing_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "listing_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the location of the data exchange. Distinct from the location of the destination data set.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="logLinkedDatasetQueryUserEmail")
    def log_linked_dataset_query_user_email(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Output only. By default, false. If true, the Subscriber agreed to the email sharing mandate that is enabled for Listing.
        """
        return pulumi.get(self, "log_linked_dataset_query_user_email")

    @log_linked_dataset_query_user_email.setter
    def log_linked_dataset_query_user_email(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "log_linked_dataset_query_user_email", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the subscription. e.g. "projects/myproject/locations/US/subscriptions/123"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationDisplayName")
    def organization_display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name of the project of this subscription.
        """
        return pulumi.get(self, "organization_display_name")

    @organization_display_name.setter
    def organization_display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_display_name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Organization of the project this subscription belongs to.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Listing shared asset type.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Current state of the subscription.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subscriberContact")
    def subscriber_contact(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Email of the subscriber.
        """
        return pulumi.get(self, "subscriber_contact")

    @subscriber_contact.setter
    def subscriber_contact(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscriber_contact", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The subscription id used to reference the subscription.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.type_token("gcp:bigqueryanalyticshub/listingSubscription:ListingSubscription")
class ListingSubscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_exchange_id: Optional[pulumi.Input[builtins.str]] = None,
                 destination_dataset: Optional[pulumi.Input[Union['ListingSubscriptionDestinationDatasetArgs', 'ListingSubscriptionDestinationDatasetArgsDict']]] = None,
                 listing_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Bigquery Analytics Hub listing subscription

        To get more information about ListingSubscription, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/analytics-hub/rest/v1/projects.locations.subscriptions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/bigquery/docs/analytics-hub-introduction)

        > **Note:** When importing the resource with `pulumi import`, provide the destination project and location
        in the format projects/{{destination_project}}/locations/{{destination_location}}/subscriptions/{{subscription_id}}
        ## Example Usage

        ### Bigquery Analyticshub Listing Subscription Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        subscription = gcp.bigqueryanalyticshub.DataExchange("subscription",
            location="US",
            data_exchange_id="my_data_exchange",
            display_name="my_data_exchange",
            description="Test Description")
        subscription_dataset = gcp.bigquery.Dataset("subscription",
            dataset_id="my_listing",
            friendly_name="my_listing",
            description="Test Description",
            location="US")
        subscription_listing = gcp.bigqueryanalyticshub.Listing("subscription",
            location="US",
            data_exchange_id=subscription.data_exchange_id,
            listing_id="my_listing",
            display_name="my_listing",
            description="Test Description",
            bigquery_dataset={
                "dataset": subscription_dataset.id,
            })
        subscription_listing_subscription = gcp.bigqueryanalyticshub.ListingSubscription("subscription",
            location="US",
            data_exchange_id=subscription.data_exchange_id,
            listing_id=subscription_listing.listing_id,
            destination_dataset={
                "description": "A test subscription",
                "friendly_name": "👋",
                "labels": {
                    "testing": "123",
                },
                "location": "US",
                "dataset_reference": {
                    "dataset_id": "destination_dataset",
                    "project_id": subscription_dataset.project,
                },
            })
        ```

        ## Import

        ListingSubscription can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/subscriptions/{{subscription_id}}`

        * `{{project}}/{{location}}/{{subscription_id}}`

        * `{{location}}/{{subscription_id}}`

        When using the `pulumi import` command, ListingSubscription can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/listingSubscription:ListingSubscription default projects/{{project}}/locations/{{location}}/subscriptions/{{subscription_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/listingSubscription:ListingSubscription default {{project}}/{{location}}/{{subscription_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/listingSubscription:ListingSubscription default {{location}}/{{subscription_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[Union['ListingSubscriptionDestinationDatasetArgs', 'ListingSubscriptionDestinationDatasetArgsDict']] destination_dataset: The destination dataset for this subscription.
               Structure is documented below.
        :param pulumi.Input[builtins.str] listing_id: The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[builtins.str] location: The name of the location of the data exchange. Distinct from the location of the destination data set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListingSubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Bigquery Analytics Hub listing subscription

        To get more information about ListingSubscription, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/analytics-hub/rest/v1/projects.locations.subscriptions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/bigquery/docs/analytics-hub-introduction)

        > **Note:** When importing the resource with `pulumi import`, provide the destination project and location
        in the format projects/{{destination_project}}/locations/{{destination_location}}/subscriptions/{{subscription_id}}
        ## Example Usage

        ### Bigquery Analyticshub Listing Subscription Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        subscription = gcp.bigqueryanalyticshub.DataExchange("subscription",
            location="US",
            data_exchange_id="my_data_exchange",
            display_name="my_data_exchange",
            description="Test Description")
        subscription_dataset = gcp.bigquery.Dataset("subscription",
            dataset_id="my_listing",
            friendly_name="my_listing",
            description="Test Description",
            location="US")
        subscription_listing = gcp.bigqueryanalyticshub.Listing("subscription",
            location="US",
            data_exchange_id=subscription.data_exchange_id,
            listing_id="my_listing",
            display_name="my_listing",
            description="Test Description",
            bigquery_dataset={
                "dataset": subscription_dataset.id,
            })
        subscription_listing_subscription = gcp.bigqueryanalyticshub.ListingSubscription("subscription",
            location="US",
            data_exchange_id=subscription.data_exchange_id,
            listing_id=subscription_listing.listing_id,
            destination_dataset={
                "description": "A test subscription",
                "friendly_name": "👋",
                "labels": {
                    "testing": "123",
                },
                "location": "US",
                "dataset_reference": {
                    "dataset_id": "destination_dataset",
                    "project_id": subscription_dataset.project,
                },
            })
        ```

        ## Import

        ListingSubscription can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/subscriptions/{{subscription_id}}`

        * `{{project}}/{{location}}/{{subscription_id}}`

        * `{{location}}/{{subscription_id}}`

        When using the `pulumi import` command, ListingSubscription can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/listingSubscription:ListingSubscription default projects/{{project}}/locations/{{location}}/subscriptions/{{subscription_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/listingSubscription:ListingSubscription default {{project}}/{{location}}/{{subscription_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/listingSubscription:ListingSubscription default {{location}}/{{subscription_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ListingSubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListingSubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_exchange_id: Optional[pulumi.Input[builtins.str]] = None,
                 destination_dataset: Optional[pulumi.Input[Union['ListingSubscriptionDestinationDatasetArgs', 'ListingSubscriptionDestinationDatasetArgsDict']]] = None,
                 listing_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListingSubscriptionArgs.__new__(ListingSubscriptionArgs)

            if data_exchange_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_exchange_id'")
            __props__.__dict__["data_exchange_id"] = data_exchange_id
            if destination_dataset is None and not opts.urn:
                raise TypeError("Missing required property 'destination_dataset'")
            __props__.__dict__["destination_dataset"] = destination_dataset
            if listing_id is None and not opts.urn:
                raise TypeError("Missing required property 'listing_id'")
            __props__.__dict__["listing_id"] = listing_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["last_modify_time"] = None
            __props__.__dict__["linked_dataset_maps"] = None
            __props__.__dict__["linked_resources"] = None
            __props__.__dict__["log_linked_dataset_query_user_email"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["organization_display_name"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["resource_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["subscriber_contact"] = None
            __props__.__dict__["subscription_id"] = None
        super(ListingSubscription, __self__).__init__(
            'gcp:bigqueryanalyticshub/listingSubscription:ListingSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_time: Optional[pulumi.Input[builtins.str]] = None,
            data_exchange_id: Optional[pulumi.Input[builtins.str]] = None,
            destination_dataset: Optional[pulumi.Input[Union['ListingSubscriptionDestinationDatasetArgs', 'ListingSubscriptionDestinationDatasetArgsDict']]] = None,
            last_modify_time: Optional[pulumi.Input[builtins.str]] = None,
            linked_dataset_maps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListingSubscriptionLinkedDatasetMapArgs', 'ListingSubscriptionLinkedDatasetMapArgsDict']]]]] = None,
            linked_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListingSubscriptionLinkedResourceArgs', 'ListingSubscriptionLinkedResourceArgsDict']]]]] = None,
            listing_id: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            log_linked_dataset_query_user_email: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            organization_display_name: Optional[pulumi.Input[builtins.str]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            resource_type: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            subscriber_contact: Optional[pulumi.Input[builtins.str]] = None,
            subscription_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ListingSubscription':
        """
        Get an existing ListingSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] creation_time: Timestamp when the subscription was created.
        :param pulumi.Input[builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[Union['ListingSubscriptionDestinationDatasetArgs', 'ListingSubscriptionDestinationDatasetArgsDict']] destination_dataset: The destination dataset for this subscription.
               Structure is documented below.
        :param pulumi.Input[builtins.str] last_modify_time: Timestamp when the subscription was last modified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListingSubscriptionLinkedDatasetMapArgs', 'ListingSubscriptionLinkedDatasetMapArgsDict']]]] linked_dataset_maps: Output only. Map of listing resource names to associated linked resource,
               e.g. projects/123/locations/US/dataExchanges/456/listings/789 > projects/123/datasets/my_dataset
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListingSubscriptionLinkedResourceArgs', 'ListingSubscriptionLinkedResourceArgsDict']]]] linked_resources: Output only. Linked resources created in the subscription. Only contains values if state = STATE_ACTIVE.
               Structure is documented below.
        :param pulumi.Input[builtins.str] listing_id: The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[builtins.str] location: The name of the location of the data exchange. Distinct from the location of the destination data set.
        :param pulumi.Input[builtins.bool] log_linked_dataset_query_user_email: Output only. By default, false. If true, the Subscriber agreed to the email sharing mandate that is enabled for Listing.
        :param pulumi.Input[builtins.str] name: The resource name of the subscription. e.g. "projects/myproject/locations/US/subscriptions/123"
        :param pulumi.Input[builtins.str] organization_display_name: Display name of the project of this subscription.
        :param pulumi.Input[builtins.str] organization_id: Organization of the project this subscription belongs to.
        :param pulumi.Input[builtins.str] resource_type: Listing shared asset type.
        :param pulumi.Input[builtins.str] state: Current state of the subscription.
        :param pulumi.Input[builtins.str] subscriber_contact: Email of the subscriber.
        :param pulumi.Input[builtins.str] subscription_id: The subscription id used to reference the subscription.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListingSubscriptionState.__new__(_ListingSubscriptionState)

        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["data_exchange_id"] = data_exchange_id
        __props__.__dict__["destination_dataset"] = destination_dataset
        __props__.__dict__["last_modify_time"] = last_modify_time
        __props__.__dict__["linked_dataset_maps"] = linked_dataset_maps
        __props__.__dict__["linked_resources"] = linked_resources
        __props__.__dict__["listing_id"] = listing_id
        __props__.__dict__["location"] = location
        __props__.__dict__["log_linked_dataset_query_user_email"] = log_linked_dataset_query_user_email
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_display_name"] = organization_display_name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["project"] = project
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["state"] = state
        __props__.__dict__["subscriber_contact"] = subscriber_contact
        __props__.__dict__["subscription_id"] = subscription_id
        return ListingSubscription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp when the subscription was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @property
    @pulumi.getter(name="destinationDataset")
    def destination_dataset(self) -> pulumi.Output['outputs.ListingSubscriptionDestinationDataset']:
        """
        The destination dataset for this subscription.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_dataset")

    @property
    @pulumi.getter(name="lastModifyTime")
    def last_modify_time(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp when the subscription was last modified.
        """
        return pulumi.get(self, "last_modify_time")

    @property
    @pulumi.getter(name="linkedDatasetMaps")
    def linked_dataset_maps(self) -> pulumi.Output[Sequence['outputs.ListingSubscriptionLinkedDatasetMap']]:
        """
        Output only. Map of listing resource names to associated linked resource,
        e.g. projects/123/locations/US/dataExchanges/456/listings/789 > projects/123/datasets/my_dataset
        Structure is documented below.
        """
        return pulumi.get(self, "linked_dataset_maps")

    @property
    @pulumi.getter(name="linkedResources")
    def linked_resources(self) -> pulumi.Output[Sequence['outputs.ListingSubscriptionLinkedResource']]:
        """
        Output only. Linked resources created in the subscription. Only contains values if state = STATE_ACTIVE.
        Structure is documented below.
        """
        return pulumi.get(self, "linked_resources")

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "listing_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The name of the location of the data exchange. Distinct from the location of the destination data set.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="logLinkedDatasetQueryUserEmail")
    def log_linked_dataset_query_user_email(self) -> pulumi.Output[builtins.bool]:
        """
        Output only. By default, false. If true, the Subscriber agreed to the email sharing mandate that is enabled for Listing.
        """
        return pulumi.get(self, "log_linked_dataset_query_user_email")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the subscription. e.g. "projects/myproject/locations/US/subscriptions/123"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationDisplayName")
    def organization_display_name(self) -> pulumi.Output[builtins.str]:
        """
        Display name of the project of this subscription.
        """
        return pulumi.get(self, "organization_display_name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        Organization of the project this subscription belongs to.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        Listing shared asset type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Current state of the subscription.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriberContact")
    def subscriber_contact(self) -> pulumi.Output[builtins.str]:
        """
        Email of the subscriber.
        """
        return pulumi.get(self, "subscriber_contact")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[builtins.str]:
        """
        The subscription id used to reference the subscription.
        """
        return pulumi.get(self, "subscription_id")

