# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MaterializedViewArgs', 'MaterializedView']

@pulumi.input_type
class MaterializedViewArgs:
    def __init__(__self__, *,
                 materialized_view_id: pulumi.Input[builtins.str],
                 query: pulumi.Input[builtins.str],
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MaterializedView resource.
        :param pulumi.Input[builtins.str] materialized_view_id: The unique name of the materialized view in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
               
               
               - - -
        :param pulumi.Input[builtins.str] query: The materialized view's select query.
        :param pulumi.Input[builtins.bool] deletion_protection: Set to true to make the MaterializedView protected against deletion.
        :param pulumi.Input[builtins.str] instance: The name of the instance to create the materialized view within.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "materialized_view_id", materialized_view_id)
        pulumi.set(__self__, "query", query)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="materializedViewId")
    def materialized_view_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique name of the materialized view in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.


        - - -
        """
        return pulumi.get(self, "materialized_view_id")

    @materialized_view_id.setter
    def materialized_view_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "materialized_view_id", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[builtins.str]:
        """
        The materialized view's select query.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true to make the MaterializedView protected against deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the instance to create the materialized view within.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _MaterializedViewState:
    def __init__(__self__, *,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 materialized_view_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MaterializedView resources.
        :param pulumi.Input[builtins.bool] deletion_protection: Set to true to make the MaterializedView protected against deletion.
        :param pulumi.Input[builtins.str] instance: The name of the instance to create the materialized view within.
        :param pulumi.Input[builtins.str] materialized_view_id: The unique name of the materialized view in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: The unique name of the requested materialized view. Values are of the form `projects/<project>/instances/<instance>/materializedViews/<materializedViewId>`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] query: The materialized view's select query.
        """
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if materialized_view_id is not None:
            pulumi.set(__self__, "materialized_view_id", materialized_view_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true to make the MaterializedView protected against deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the instance to create the materialized view within.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter(name="materializedViewId")
    def materialized_view_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the materialized view in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.


        - - -
        """
        return pulumi.get(self, "materialized_view_id")

    @materialized_view_id.setter
    def materialized_view_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "materialized_view_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the requested materialized view. Values are of the form `projects/<project>/instances/<instance>/materializedViews/<materializedViewId>`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The materialized view's select query.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query", value)


@pulumi.type_token("gcp:bigtable/materializedView:MaterializedView")
class MaterializedView(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 materialized_view_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A materialized view object that can be referenced in SQL queries.

        To get more information about MaterializedView, see:

        * [API documentation](https://cloud.google.com/bigtable/docs/reference/admin/rest/v2/projects.instances.materializedViews)

        ## Example Usage

        ### Bigtable Materialized View

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.bigtable.Instance("instance",
            name="bt-instance",
            clusters=[{
                "cluster_id": "cluster-1",
                "zone": "us-east1-b",
                "num_nodes": 3,
                "storage_type": "HDD",
            }],
            deletion_protection=True)
        table = gcp.bigtable.Table("table",
            name="bt-table",
            instance_name=instance.name,
            column_families=[{
                "family": "CF",
            }])
        materialized_view = gcp.bigtable.MaterializedView("materialized_view",
            materialized_view_id="bt-materialized-view",
            instance=instance.name,
            deletion_protection=False,
            query=\"\"\"SELECT _key, COUNT(CF['col1']) as Count
        FROM ` + "`bt-table`" + `
        GROUP BY _key
        \"\"\",
            opts = pulumi.ResourceOptions(depends_on=[table]))
        ```

        ## Import

        MaterializedView can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance}}/materializedViews/{{materialized_view_id}}`

        * `{{project}}/{{instance}}/{{materialized_view_id}}`

        * `{{instance}}/{{materialized_view_id}}`

        When using the `pulumi import` command, MaterializedView can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigtable/materializedView:MaterializedView default projects/{{project}}/instances/{{instance}}/materializedViews/{{materialized_view_id}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/materializedView:MaterializedView default {{project}}/{{instance}}/{{materialized_view_id}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/materializedView:MaterializedView default {{instance}}/{{materialized_view_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] deletion_protection: Set to true to make the MaterializedView protected against deletion.
        :param pulumi.Input[builtins.str] instance: The name of the instance to create the materialized view within.
        :param pulumi.Input[builtins.str] materialized_view_id: The unique name of the materialized view in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] query: The materialized view's select query.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MaterializedViewArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A materialized view object that can be referenced in SQL queries.

        To get more information about MaterializedView, see:

        * [API documentation](https://cloud.google.com/bigtable/docs/reference/admin/rest/v2/projects.instances.materializedViews)

        ## Example Usage

        ### Bigtable Materialized View

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.bigtable.Instance("instance",
            name="bt-instance",
            clusters=[{
                "cluster_id": "cluster-1",
                "zone": "us-east1-b",
                "num_nodes": 3,
                "storage_type": "HDD",
            }],
            deletion_protection=True)
        table = gcp.bigtable.Table("table",
            name="bt-table",
            instance_name=instance.name,
            column_families=[{
                "family": "CF",
            }])
        materialized_view = gcp.bigtable.MaterializedView("materialized_view",
            materialized_view_id="bt-materialized-view",
            instance=instance.name,
            deletion_protection=False,
            query=\"\"\"SELECT _key, COUNT(CF['col1']) as Count
        FROM ` + "`bt-table`" + `
        GROUP BY _key
        \"\"\",
            opts = pulumi.ResourceOptions(depends_on=[table]))
        ```

        ## Import

        MaterializedView can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance}}/materializedViews/{{materialized_view_id}}`

        * `{{project}}/{{instance}}/{{materialized_view_id}}`

        * `{{instance}}/{{materialized_view_id}}`

        When using the `pulumi import` command, MaterializedView can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigtable/materializedView:MaterializedView default projects/{{project}}/instances/{{instance}}/materializedViews/{{materialized_view_id}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/materializedView:MaterializedView default {{project}}/{{instance}}/{{materialized_view_id}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/materializedView:MaterializedView default {{instance}}/{{materialized_view_id}}
        ```

        :param str resource_name: The name of the resource.
        :param MaterializedViewArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MaterializedViewArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 materialized_view_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MaterializedViewArgs.__new__(MaterializedViewArgs)

            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["instance"] = instance
            if materialized_view_id is None and not opts.urn:
                raise TypeError("Missing required property 'materialized_view_id'")
            __props__.__dict__["materialized_view_id"] = materialized_view_id
            __props__.__dict__["project"] = project
            if query is None and not opts.urn:
                raise TypeError("Missing required property 'query'")
            __props__.__dict__["query"] = query
            __props__.__dict__["name"] = None
        super(MaterializedView, __self__).__init__(
            'gcp:bigtable/materializedView:MaterializedView',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
            instance: Optional[pulumi.Input[builtins.str]] = None,
            materialized_view_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            query: Optional[pulumi.Input[builtins.str]] = None) -> 'MaterializedView':
        """
        Get an existing MaterializedView resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] deletion_protection: Set to true to make the MaterializedView protected against deletion.
        :param pulumi.Input[builtins.str] instance: The name of the instance to create the materialized view within.
        :param pulumi.Input[builtins.str] materialized_view_id: The unique name of the materialized view in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: The unique name of the requested materialized view. Values are of the form `projects/<project>/instances/<instance>/materializedViews/<materializedViewId>`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] query: The materialized view's select query.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MaterializedViewState.__new__(_MaterializedViewState)

        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["instance"] = instance
        __props__.__dict__["materialized_view_id"] = materialized_view_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["query"] = query
        return MaterializedView(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Set to true to make the MaterializedView protected against deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the instance to create the materialized view within.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter(name="materializedViewId")
    def materialized_view_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique name of the materialized view in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.


        - - -
        """
        return pulumi.get(self, "materialized_view_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique name of the requested materialized view. Values are of the form `projects/<project>/instances/<instance>/materializedViews/<materializedViewId>`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def query(self) -> pulumi.Output[builtins.str]:
        """
        The materialized view's select query.
        """
        return pulumi.get(self, "query")

