# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 pool: pulumi.Input[builtins.str],
                 certificate_authority: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_template: Optional[pulumi.Input[builtins.str]] = None,
                 config: Optional[pulumi.Input['CertificateConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifetime: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pem_csr: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[builtins.str] location: Location of the Certificate. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
               
               
               - - -
        :param pulumi.Input[builtins.str] pool: The name of the CaPool this Certificate belongs to.
        :param pulumi.Input[builtins.str] certificate_authority: The Certificate Authority ID that should issue the certificate. For example, to issue a Certificate from
               a Certificate Authority with resource name `projects/my-project/locations/us-central1/caPools/my-pool/certificateAuthorities/my-ca`,
               argument `pool` should be set to `projects/my-project/locations/us-central1/caPools/my-pool`, argument `certificate_authority`
               should be set to `my-ca`.
        :param pulumi.Input[builtins.str] certificate_template: The resource name for a CertificateTemplate used to issue this certificate,
               in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified,
               the caller must have the necessary permission to use this template. If this is
               omitted, no template will be used. This template must be in the same location
               as the Certificate.
        :param pulumi.Input['CertificateConfigArgs'] config: The config used to create a self-signed X.509 certificate or CSR.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels with user-defined metadata to apply to this resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[builtins.str] name: The name for this Certificate.
        :param pulumi.Input[builtins.str] pem_csr: Immutable. A pem-encoded X.509 certificate signing request (CSR).
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "pool", pool)
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if certificate_template is not None:
            pulumi.set(__self__, "certificate_template", certificate_template)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pem_csr is not None:
            pulumi.set(__self__, "pem_csr", pem_csr)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Location of the Certificate. A full list of valid locations can be found by
        running `gcloud privateca locations list`.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def pool(self) -> pulumi.Input[builtins.str]:
        """
        The name of the CaPool this Certificate belongs to.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Certificate Authority ID that should issue the certificate. For example, to issue a Certificate from
        a Certificate Authority with resource name `projects/my-project/locations/us-central1/caPools/my-pool/certificateAuthorities/my-ca`,
        argument `pool` should be set to `projects/my-project/locations/us-central1/caPools/my-pool`, argument `certificate_authority`
        should be set to `my-ca`.
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_authority", value)

    @property
    @pulumi.getter(name="certificateTemplate")
    def certificate_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name for a CertificateTemplate used to issue this certificate,
        in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified,
        the caller must have the necessary permission to use this template. If this is
        omitted, no template will be used. This template must be in the same location
        as the Certificate.
        """
        return pulumi.get(self, "certificate_template")

    @certificate_template.setter
    def certificate_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_template", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['CertificateConfigArgs']]:
        """
        The config used to create a self-signed X.509 certificate or CSR.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['CertificateConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels with user-defined metadata to apply to this resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
        "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
        fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifetime", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for this Certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pemCsr")
    def pem_csr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. A pem-encoded X.509 certificate signing request (CSR).
        """
        return pulumi.get(self, "pem_csr")

    @pem_csr.setter
    def pem_csr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pem_csr", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 certificate_authority: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_descriptions: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateDescriptionArgs']]]] = None,
                 certificate_template: Optional[pulumi.Input[builtins.str]] = None,
                 config: Optional[pulumi.Input['CertificateConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 issuer_certificate_authority: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifetime: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pem_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 pem_certificate_chains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 pem_csr: Optional[pulumi.Input[builtins.str]] = None,
                 pool: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 revocation_details: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateRevocationDetailArgs']]]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[builtins.str] certificate_authority: The Certificate Authority ID that should issue the certificate. For example, to issue a Certificate from
               a Certificate Authority with resource name `projects/my-project/locations/us-central1/caPools/my-pool/certificateAuthorities/my-ca`,
               argument `pool` should be set to `projects/my-project/locations/us-central1/caPools/my-pool`, argument `certificate_authority`
               should be set to `my-ca`.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateCertificateDescriptionArgs']]] certificate_descriptions: Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if this field is present.
               Structure is documented below.
        :param pulumi.Input[builtins.str] certificate_template: The resource name for a CertificateTemplate used to issue this certificate,
               in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified,
               the caller must have the necessary permission to use this template. If this is
               omitted, no template will be used. This template must be in the same location
               as the Certificate.
        :param pulumi.Input['CertificateConfigArgs'] config: The config used to create a self-signed X.509 certificate or CSR.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The time that this resource was created on the server.
               This is in RFC3339 text format.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] issuer_certificate_authority: The resource name of the issuing CertificateAuthority in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels with user-defined metadata to apply to this resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[builtins.str] location: Location of the Certificate. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: The name for this Certificate.
        :param pulumi.Input[builtins.str] pem_certificate: Output only. The pem-encoded, signed X.509 certificate.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] pem_certificate_chains: The chain that may be used to verify the X.509 certificate. Expected to be in issuer-to-root order according to RFC 5246.
        :param pulumi.Input[builtins.str] pem_csr: Immutable. A pem-encoded X.509 certificate signing request (CSR).
        :param pulumi.Input[builtins.str] pool: The name of the CaPool this Certificate belongs to.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateRevocationDetailArgs']]] revocation_details: Output only. Details regarding the revocation of this Certificate. This Certificate is
               considered revoked if and only if this field is present.
               Structure is documented below.
        :param pulumi.Input[builtins.str] update_time: Output only. The time at which this CertificateAuthority was updated.
               This is in RFC3339 text format.
        """
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if certificate_descriptions is not None:
            pulumi.set(__self__, "certificate_descriptions", certificate_descriptions)
        if certificate_template is not None:
            pulumi.set(__self__, "certificate_template", certificate_template)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if issuer_certificate_authority is not None:
            pulumi.set(__self__, "issuer_certificate_authority", issuer_certificate_authority)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pem_certificate is not None:
            pulumi.set(__self__, "pem_certificate", pem_certificate)
        if pem_certificate_chains is not None:
            pulumi.set(__self__, "pem_certificate_chains", pem_certificate_chains)
        if pem_csr is not None:
            pulumi.set(__self__, "pem_csr", pem_csr)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if revocation_details is not None:
            pulumi.set(__self__, "revocation_details", revocation_details)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Certificate Authority ID that should issue the certificate. For example, to issue a Certificate from
        a Certificate Authority with resource name `projects/my-project/locations/us-central1/caPools/my-pool/certificateAuthorities/my-ca`,
        argument `pool` should be set to `projects/my-project/locations/us-central1/caPools/my-pool`, argument `certificate_authority`
        should be set to `my-ca`.
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_authority", value)

    @property
    @pulumi.getter(name="certificateDescriptions")
    def certificate_descriptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateDescriptionArgs']]]]:
        """
        Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if this field is present.
        Structure is documented below.
        """
        return pulumi.get(self, "certificate_descriptions")

    @certificate_descriptions.setter
    def certificate_descriptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateDescriptionArgs']]]]):
        pulumi.set(self, "certificate_descriptions", value)

    @property
    @pulumi.getter(name="certificateTemplate")
    def certificate_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name for a CertificateTemplate used to issue this certificate,
        in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified,
        the caller must have the necessary permission to use this template. If this is
        omitted, no template will be used. This template must be in the same location
        as the Certificate.
        """
        return pulumi.get(self, "certificate_template")

    @certificate_template.setter
    def certificate_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_template", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['CertificateConfigArgs']]:
        """
        The config used to create a self-signed X.509 certificate or CSR.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['CertificateConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time that this resource was created on the server.
        This is in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="issuerCertificateAuthority")
    def issuer_certificate_authority(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the issuing CertificateAuthority in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
        """
        return pulumi.get(self, "issuer_certificate_authority")

    @issuer_certificate_authority.setter
    def issuer_certificate_authority(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issuer_certificate_authority", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels with user-defined metadata to apply to this resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
        "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
        fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifetime", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of the Certificate. A full list of valid locations can be found by
        running `gcloud privateca locations list`.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for this Certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The pem-encoded, signed X.509 certificate.
        """
        return pulumi.get(self, "pem_certificate")

    @pem_certificate.setter
    def pem_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pem_certificate", value)

    @property
    @pulumi.getter(name="pemCertificateChains")
    def pem_certificate_chains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The chain that may be used to verify the X.509 certificate. Expected to be in issuer-to-root order according to RFC 5246.
        """
        return pulumi.get(self, "pem_certificate_chains")

    @pem_certificate_chains.setter
    def pem_certificate_chains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pem_certificate_chains", value)

    @property
    @pulumi.getter(name="pemCsr")
    def pem_csr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. A pem-encoded X.509 certificate signing request (CSR).
        """
        return pulumi.get(self, "pem_csr")

    @pem_csr.setter
    def pem_csr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pem_csr", value)

    @property
    @pulumi.getter
    def pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the CaPool this Certificate belongs to.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="revocationDetails")
    def revocation_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateRevocationDetailArgs']]]]:
        """
        Output only. Details regarding the revocation of this Certificate. This Certificate is
        considered revoked if and only if this field is present.
        Structure is documented below.
        """
        return pulumi.get(self, "revocation_details")

    @revocation_details.setter
    def revocation_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateRevocationDetailArgs']]]]):
        pulumi.set(self, "revocation_details", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which this CertificateAuthority was updated.
        This is in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:certificateauthority/certificate:Certificate")
class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_template: Optional[pulumi.Input[builtins.str]] = None,
                 config: Optional[pulumi.Input[Union['CertificateConfigArgs', 'CertificateConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifetime: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pem_csr: Optional[pulumi.Input[builtins.str]] = None,
                 pool: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Certificate corresponds to a signed X.509 certificate issued by a Certificate.

        > **Note:** The Certificate Authority that is referenced by this resource **must** be
        `tier = "ENTERPRISE"`

        ## Example Usage

        ### Privateca Certificate Generated Key

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std
        import pulumi_tls as tls

        default = gcp.certificateauthority.CaPool("default",
            location="us-central1",
            name="default",
            tier="ENTERPRISE")
        default_authority = gcp.certificateauthority.Authority("default",
            location="us-central1",
            pool=default.name,
            certificate_authority_id="my-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        cert_key = tls.PrivateKey("cert_key", algorithm="RSA")
        default_certificate = gcp.certificateauthority.Certificate("default",
            location="us-central1",
            pool=default.name,
            certificate_authority=default_authority.certificate_authority_id,
            lifetime="86000s",
            name="cert-1",
            config={
                "subject_config": {
                    "subject": {
                        "common_name": "san1.example.com",
                        "country_code": "us",
                        "organization": "google",
                        "organizational_unit": "enterprise",
                        "locality": "mountain view",
                        "province": "california",
                        "street_address": "1600 amphitheatre parkway",
                    },
                    "subject_alt_name": {
                        "email_addresses": ["email@example.com"],
                        "ip_addresses": ["127.0.0.1"],
                        "uris": ["http://www.ietf.org/rfc/rfc3986.txt"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": False,
                        },
                    },
                    "name_constraints": {
                        "critical": True,
                        "permitted_dns_names": ["*.example.com"],
                        "excluded_dns_names": ["*.deny.example.com"],
                        "permitted_ip_ranges": ["10.0.0.0/8"],
                        "excluded_ip_ranges": ["10.1.1.0/24"],
                        "permitted_email_addresses": [".example.com"],
                        "excluded_email_addresses": [".deny.example.com"],
                        "permitted_uris": [".example.com"],
                        "excluded_uris": [".deny.example.com"],
                    },
                },
                "public_key": {
                    "format": "PEM",
                    "key": std.base64encode_output(input=cert_key.public_key_pem).apply(lambda invoke: invoke.result),
                },
            })
        ```
        ### Privateca Certificate With Template

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificateauthority.CaPool("default",
            location="us-central1",
            name="my-pool",
            tier="ENTERPRISE")
        default_certificate_template = gcp.certificateauthority.CertificateTemplate("default",
            location="us-central1",
            name="my-certificate-template",
            description="An updated sample certificate template",
            identity_constraints={
                "allow_subject_alt_names_passthrough": True,
                "allow_subject_passthrough": True,
                "cel_expression": {
                    "description": "Always true",
                    "expression": "true",
                    "location": "any.file.anywhere",
                    "title": "Sample expression",
                },
            },
            passthrough_extensions={
                "additional_extensions": [{
                    "object_id_paths": [
                        1,
                        6,
                    ],
                }],
                "known_extensions": ["EXTENDED_KEY_USAGE"],
            },
            predefined_values={
                "additional_extensions": [{
                    "object_id": {
                        "object_id_paths": [
                            1,
                            6,
                        ],
                    },
                    "value": "c3RyaW5nCg==",
                    "critical": True,
                }],
                "aia_ocsp_servers": ["string"],
                "ca_options": {
                    "is_ca": False,
                    "max_issuer_path_length": 6,
                },
                "key_usage": {
                    "base_key_usage": {
                        "cert_sign": False,
                        "content_commitment": True,
                        "crl_sign": False,
                        "data_encipherment": True,
                        "decipher_only": True,
                        "digital_signature": True,
                        "encipher_only": True,
                        "key_agreement": True,
                        "key_encipherment": True,
                    },
                    "extended_key_usage": {
                        "client_auth": True,
                        "code_signing": True,
                        "email_protection": True,
                        "ocsp_signing": True,
                        "server_auth": True,
                        "time_stamping": True,
                    },
                    "unknown_extended_key_usages": [{
                        "object_id_paths": [
                            1,
                            6,
                        ],
                    }],
                },
                "policy_ids": [{
                    "object_id_paths": [
                        1,
                        6,
                    ],
                }],
            })
        default_authority = gcp.certificateauthority.Authority("default",
            location="us-central1",
            pool=default.name,
            certificate_authority_id="my-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": False,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        default_certificate = gcp.certificateauthority.Certificate("default",
            location="us-central1",
            pool=default.name,
            certificate_authority=default_authority.certificate_authority_id,
            name="my-certificate",
            lifetime="860s",
            pem_csr=std.file(input="test-fixtures/rsa_csr.pem").result,
            certificate_template=default_certificate_template.id)
        ```
        ### Privateca Certificate Csr

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificateauthority.CaPool("default",
            location="us-central1",
            name="my-pool",
            tier="ENTERPRISE")
        default_authority = gcp.certificateauthority.Authority("default",
            location="us-central1",
            pool=default.name,
            certificate_authority_id="my-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": False,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        default_certificate = gcp.certificateauthority.Certificate("default",
            location="us-central1",
            pool=default.name,
            certificate_authority=default_authority.certificate_authority_id,
            name="my-certificate",
            lifetime="860s",
            pem_csr=std.file(input="test-fixtures/rsa_csr.pem").result)
        ```
        ### Privateca Certificate No Authority

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificateauthority.CaPool("default",
            location="us-central1",
            name="my-pool",
            tier="ENTERPRISE")
        default_authority = gcp.certificateauthority.Authority("default",
            location="us-central1",
            pool=default.name,
            certificate_authority_id="my-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "digital_signature": True,
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            lifetime="86400s",
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        default_certificate = gcp.certificateauthority.Certificate("default",
            location="us-central1",
            pool=default.name,
            name="my-certificate",
            lifetime="860s",
            config={
                "subject_config": {
                    "subject": {
                        "common_name": "san1.example.com",
                        "country_code": "us",
                        "organization": "google",
                        "organizational_unit": "enterprise",
                        "locality": "mountain view",
                        "province": "california",
                        "street_address": "1600 amphitheatre parkway",
                        "postal_code": "94109",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": False,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
                "public_key": {
                    "format": "PEM",
                    "key": std.filebase64(input="test-fixtures/rsa_public.pem").result,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[default_authority]))
        ```
        ### Privateca Certificate Custom Ski

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificateauthority.CaPool("default",
            location="us-central1",
            name="my-pool",
            tier="ENTERPRISE")
        default_authority = gcp.certificateauthority.Authority("default",
            location="us-central1",
            pool=default.name,
            certificate_authority_id="my-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "digital_signature": True,
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            lifetime="86400s",
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        default_certificate = gcp.certificateauthority.Certificate("default",
            location="us-central1",
            pool=default.name,
            name="my-certificate",
            lifetime="860s",
            config={
                "subject_config": {
                    "subject": {
                        "common_name": "san1.example.com",
                        "country_code": "us",
                        "organization": "google",
                        "organizational_unit": "enterprise",
                        "locality": "mountain view",
                        "province": "california",
                        "street_address": "1600 amphitheatre parkway",
                        "postal_code": "94109",
                    },
                },
                "subject_key_id": {
                    "key_id": "4cf3372289b1d411b999dbb9ebcd44744b6b2fca",
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": False,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
                "public_key": {
                    "format": "PEM",
                    "key": std.filebase64(input="test-fixtures/rsa_public.pem").result,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[default_authority]))
        ```

        ## Import

        Certificate can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificates/{{name}}`

        * `{{project}}/{{location}}/{{pool}}/{{name}}`

        * `{{location}}/{{pool}}/{{name}}`

        When using the `pulumi import` command, Certificate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificateauthority/certificate:Certificate default projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/certificate:Certificate default {{project}}/{{location}}/{{pool}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/certificate:Certificate default {{location}}/{{pool}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] certificate_authority: The Certificate Authority ID that should issue the certificate. For example, to issue a Certificate from
               a Certificate Authority with resource name `projects/my-project/locations/us-central1/caPools/my-pool/certificateAuthorities/my-ca`,
               argument `pool` should be set to `projects/my-project/locations/us-central1/caPools/my-pool`, argument `certificate_authority`
               should be set to `my-ca`.
        :param pulumi.Input[builtins.str] certificate_template: The resource name for a CertificateTemplate used to issue this certificate,
               in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified,
               the caller must have the necessary permission to use this template. If this is
               omitted, no template will be used. This template must be in the same location
               as the Certificate.
        :param pulumi.Input[Union['CertificateConfigArgs', 'CertificateConfigArgsDict']] config: The config used to create a self-signed X.509 certificate or CSR.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels with user-defined metadata to apply to this resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[builtins.str] location: Location of the Certificate. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: The name for this Certificate.
        :param pulumi.Input[builtins.str] pem_csr: Immutable. A pem-encoded X.509 certificate signing request (CSR).
        :param pulumi.Input[builtins.str] pool: The name of the CaPool this Certificate belongs to.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Certificate corresponds to a signed X.509 certificate issued by a Certificate.

        > **Note:** The Certificate Authority that is referenced by this resource **must** be
        `tier = "ENTERPRISE"`

        ## Example Usage

        ### Privateca Certificate Generated Key

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std
        import pulumi_tls as tls

        default = gcp.certificateauthority.CaPool("default",
            location="us-central1",
            name="default",
            tier="ENTERPRISE")
        default_authority = gcp.certificateauthority.Authority("default",
            location="us-central1",
            pool=default.name,
            certificate_authority_id="my-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        cert_key = tls.PrivateKey("cert_key", algorithm="RSA")
        default_certificate = gcp.certificateauthority.Certificate("default",
            location="us-central1",
            pool=default.name,
            certificate_authority=default_authority.certificate_authority_id,
            lifetime="86000s",
            name="cert-1",
            config={
                "subject_config": {
                    "subject": {
                        "common_name": "san1.example.com",
                        "country_code": "us",
                        "organization": "google",
                        "organizational_unit": "enterprise",
                        "locality": "mountain view",
                        "province": "california",
                        "street_address": "1600 amphitheatre parkway",
                    },
                    "subject_alt_name": {
                        "email_addresses": ["email@example.com"],
                        "ip_addresses": ["127.0.0.1"],
                        "uris": ["http://www.ietf.org/rfc/rfc3986.txt"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": False,
                        },
                    },
                    "name_constraints": {
                        "critical": True,
                        "permitted_dns_names": ["*.example.com"],
                        "excluded_dns_names": ["*.deny.example.com"],
                        "permitted_ip_ranges": ["10.0.0.0/8"],
                        "excluded_ip_ranges": ["10.1.1.0/24"],
                        "permitted_email_addresses": [".example.com"],
                        "excluded_email_addresses": [".deny.example.com"],
                        "permitted_uris": [".example.com"],
                        "excluded_uris": [".deny.example.com"],
                    },
                },
                "public_key": {
                    "format": "PEM",
                    "key": std.base64encode_output(input=cert_key.public_key_pem).apply(lambda invoke: invoke.result),
                },
            })
        ```
        ### Privateca Certificate With Template

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificateauthority.CaPool("default",
            location="us-central1",
            name="my-pool",
            tier="ENTERPRISE")
        default_certificate_template = gcp.certificateauthority.CertificateTemplate("default",
            location="us-central1",
            name="my-certificate-template",
            description="An updated sample certificate template",
            identity_constraints={
                "allow_subject_alt_names_passthrough": True,
                "allow_subject_passthrough": True,
                "cel_expression": {
                    "description": "Always true",
                    "expression": "true",
                    "location": "any.file.anywhere",
                    "title": "Sample expression",
                },
            },
            passthrough_extensions={
                "additional_extensions": [{
                    "object_id_paths": [
                        1,
                        6,
                    ],
                }],
                "known_extensions": ["EXTENDED_KEY_USAGE"],
            },
            predefined_values={
                "additional_extensions": [{
                    "object_id": {
                        "object_id_paths": [
                            1,
                            6,
                        ],
                    },
                    "value": "c3RyaW5nCg==",
                    "critical": True,
                }],
                "aia_ocsp_servers": ["string"],
                "ca_options": {
                    "is_ca": False,
                    "max_issuer_path_length": 6,
                },
                "key_usage": {
                    "base_key_usage": {
                        "cert_sign": False,
                        "content_commitment": True,
                        "crl_sign": False,
                        "data_encipherment": True,
                        "decipher_only": True,
                        "digital_signature": True,
                        "encipher_only": True,
                        "key_agreement": True,
                        "key_encipherment": True,
                    },
                    "extended_key_usage": {
                        "client_auth": True,
                        "code_signing": True,
                        "email_protection": True,
                        "ocsp_signing": True,
                        "server_auth": True,
                        "time_stamping": True,
                    },
                    "unknown_extended_key_usages": [{
                        "object_id_paths": [
                            1,
                            6,
                        ],
                    }],
                },
                "policy_ids": [{
                    "object_id_paths": [
                        1,
                        6,
                    ],
                }],
            })
        default_authority = gcp.certificateauthority.Authority("default",
            location="us-central1",
            pool=default.name,
            certificate_authority_id="my-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": False,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        default_certificate = gcp.certificateauthority.Certificate("default",
            location="us-central1",
            pool=default.name,
            certificate_authority=default_authority.certificate_authority_id,
            name="my-certificate",
            lifetime="860s",
            pem_csr=std.file(input="test-fixtures/rsa_csr.pem").result,
            certificate_template=default_certificate_template.id)
        ```
        ### Privateca Certificate Csr

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificateauthority.CaPool("default",
            location="us-central1",
            name="my-pool",
            tier="ENTERPRISE")
        default_authority = gcp.certificateauthority.Authority("default",
            location="us-central1",
            pool=default.name,
            certificate_authority_id="my-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": False,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        default_certificate = gcp.certificateauthority.Certificate("default",
            location="us-central1",
            pool=default.name,
            certificate_authority=default_authority.certificate_authority_id,
            name="my-certificate",
            lifetime="860s",
            pem_csr=std.file(input="test-fixtures/rsa_csr.pem").result)
        ```
        ### Privateca Certificate No Authority

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificateauthority.CaPool("default",
            location="us-central1",
            name="my-pool",
            tier="ENTERPRISE")
        default_authority = gcp.certificateauthority.Authority("default",
            location="us-central1",
            pool=default.name,
            certificate_authority_id="my-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "digital_signature": True,
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            lifetime="86400s",
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        default_certificate = gcp.certificateauthority.Certificate("default",
            location="us-central1",
            pool=default.name,
            name="my-certificate",
            lifetime="860s",
            config={
                "subject_config": {
                    "subject": {
                        "common_name": "san1.example.com",
                        "country_code": "us",
                        "organization": "google",
                        "organizational_unit": "enterprise",
                        "locality": "mountain view",
                        "province": "california",
                        "street_address": "1600 amphitheatre parkway",
                        "postal_code": "94109",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": False,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
                "public_key": {
                    "format": "PEM",
                    "key": std.filebase64(input="test-fixtures/rsa_public.pem").result,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[default_authority]))
        ```
        ### Privateca Certificate Custom Ski

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificateauthority.CaPool("default",
            location="us-central1",
            name="my-pool",
            tier="ENTERPRISE")
        default_authority = gcp.certificateauthority.Authority("default",
            location="us-central1",
            pool=default.name,
            certificate_authority_id="my-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "digital_signature": True,
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            lifetime="86400s",
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        default_certificate = gcp.certificateauthority.Certificate("default",
            location="us-central1",
            pool=default.name,
            name="my-certificate",
            lifetime="860s",
            config={
                "subject_config": {
                    "subject": {
                        "common_name": "san1.example.com",
                        "country_code": "us",
                        "organization": "google",
                        "organizational_unit": "enterprise",
                        "locality": "mountain view",
                        "province": "california",
                        "street_address": "1600 amphitheatre parkway",
                        "postal_code": "94109",
                    },
                },
                "subject_key_id": {
                    "key_id": "4cf3372289b1d411b999dbb9ebcd44744b6b2fca",
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": False,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
                "public_key": {
                    "format": "PEM",
                    "key": std.filebase64(input="test-fixtures/rsa_public.pem").result,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[default_authority]))
        ```

        ## Import

        Certificate can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificates/{{name}}`

        * `{{project}}/{{location}}/{{pool}}/{{name}}`

        * `{{location}}/{{pool}}/{{name}}`

        When using the `pulumi import` command, Certificate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificateauthority/certificate:Certificate default projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/certificate:Certificate default {{project}}/{{location}}/{{pool}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/certificate:Certificate default {{location}}/{{pool}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_template: Optional[pulumi.Input[builtins.str]] = None,
                 config: Optional[pulumi.Input[Union['CertificateConfigArgs', 'CertificateConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifetime: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pem_csr: Optional[pulumi.Input[builtins.str]] = None,
                 pool: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            __props__.__dict__["certificate_authority"] = certificate_authority
            __props__.__dict__["certificate_template"] = certificate_template
            __props__.__dict__["config"] = config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["lifetime"] = lifetime
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["pem_csr"] = pem_csr
            if pool is None and not opts.urn:
                raise TypeError("Missing required property 'pool'")
            __props__.__dict__["pool"] = pool
            __props__.__dict__["project"] = project
            __props__.__dict__["certificate_descriptions"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["issuer_certificate_authority"] = None
            __props__.__dict__["pem_certificate"] = None
            __props__.__dict__["pem_certificate_chains"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["revocation_details"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Certificate, __self__).__init__(
            'gcp:certificateauthority/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_authority: Optional[pulumi.Input[builtins.str]] = None,
            certificate_descriptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateCertificateDescriptionArgs', 'CertificateCertificateDescriptionArgsDict']]]]] = None,
            certificate_template: Optional[pulumi.Input[builtins.str]] = None,
            config: Optional[pulumi.Input[Union['CertificateConfigArgs', 'CertificateConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            issuer_certificate_authority: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifetime: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            pem_certificate: Optional[pulumi.Input[builtins.str]] = None,
            pem_certificate_chains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            pem_csr: Optional[pulumi.Input[builtins.str]] = None,
            pool: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            revocation_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateRevocationDetailArgs', 'CertificateRevocationDetailArgsDict']]]]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] certificate_authority: The Certificate Authority ID that should issue the certificate. For example, to issue a Certificate from
               a Certificate Authority with resource name `projects/my-project/locations/us-central1/caPools/my-pool/certificateAuthorities/my-ca`,
               argument `pool` should be set to `projects/my-project/locations/us-central1/caPools/my-pool`, argument `certificate_authority`
               should be set to `my-ca`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificateCertificateDescriptionArgs', 'CertificateCertificateDescriptionArgsDict']]]] certificate_descriptions: Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if this field is present.
               Structure is documented below.
        :param pulumi.Input[builtins.str] certificate_template: The resource name for a CertificateTemplate used to issue this certificate,
               in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified,
               the caller must have the necessary permission to use this template. If this is
               omitted, no template will be used. This template must be in the same location
               as the Certificate.
        :param pulumi.Input[Union['CertificateConfigArgs', 'CertificateConfigArgsDict']] config: The config used to create a self-signed X.509 certificate or CSR.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The time that this resource was created on the server.
               This is in RFC3339 text format.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] issuer_certificate_authority: The resource name of the issuing CertificateAuthority in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels with user-defined metadata to apply to this resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[builtins.str] location: Location of the Certificate. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: The name for this Certificate.
        :param pulumi.Input[builtins.str] pem_certificate: Output only. The pem-encoded, signed X.509 certificate.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] pem_certificate_chains: The chain that may be used to verify the X.509 certificate. Expected to be in issuer-to-root order according to RFC 5246.
        :param pulumi.Input[builtins.str] pem_csr: Immutable. A pem-encoded X.509 certificate signing request (CSR).
        :param pulumi.Input[builtins.str] pool: The name of the CaPool this Certificate belongs to.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificateRevocationDetailArgs', 'CertificateRevocationDetailArgsDict']]]] revocation_details: Output only. Details regarding the revocation of this Certificate. This Certificate is
               considered revoked if and only if this field is present.
               Structure is documented below.
        :param pulumi.Input[builtins.str] update_time: Output only. The time at which this CertificateAuthority was updated.
               This is in RFC3339 text format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["certificate_authority"] = certificate_authority
        __props__.__dict__["certificate_descriptions"] = certificate_descriptions
        __props__.__dict__["certificate_template"] = certificate_template
        __props__.__dict__["config"] = config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["issuer_certificate_authority"] = issuer_certificate_authority
        __props__.__dict__["labels"] = labels
        __props__.__dict__["lifetime"] = lifetime
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["pem_certificate"] = pem_certificate
        __props__.__dict__["pem_certificate_chains"] = pem_certificate_chains
        __props__.__dict__["pem_csr"] = pem_csr
        __props__.__dict__["pool"] = pool
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["revocation_details"] = revocation_details
        __props__.__dict__["update_time"] = update_time
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Certificate Authority ID that should issue the certificate. For example, to issue a Certificate from
        a Certificate Authority with resource name `projects/my-project/locations/us-central1/caPools/my-pool/certificateAuthorities/my-ca`,
        argument `pool` should be set to `projects/my-project/locations/us-central1/caPools/my-pool`, argument `certificate_authority`
        should be set to `my-ca`.
        """
        return pulumi.get(self, "certificate_authority")

    @property
    @pulumi.getter(name="certificateDescriptions")
    def certificate_descriptions(self) -> pulumi.Output[Sequence['outputs.CertificateCertificateDescription']]:
        """
        Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if this field is present.
        Structure is documented below.
        """
        return pulumi.get(self, "certificate_descriptions")

    @property
    @pulumi.getter(name="certificateTemplate")
    def certificate_template(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The resource name for a CertificateTemplate used to issue this certificate,
        in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified,
        the caller must have the necessary permission to use this template. If this is
        omitted, no template will be used. This template must be in the same location
        as the Certificate.
        """
        return pulumi.get(self, "certificate_template")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional['outputs.CertificateConfig']]:
        """
        The config used to create a self-signed X.509 certificate or CSR.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time that this resource was created on the server.
        This is in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="issuerCertificateAuthority")
    def issuer_certificate_authority(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the issuing CertificateAuthority in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
        """
        return pulumi.get(self, "issuer_certificate_authority")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels with user-defined metadata to apply to this resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def lifetime(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
        "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
        fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "lifetime")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Location of the Certificate. A full list of valid locations can be found by
        running `gcloud privateca locations list`.


        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name for this Certificate.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The pem-encoded, signed X.509 certificate.
        """
        return pulumi.get(self, "pem_certificate")

    @property
    @pulumi.getter(name="pemCertificateChains")
    def pem_certificate_chains(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The chain that may be used to verify the X.509 certificate. Expected to be in issuer-to-root order according to RFC 5246.
        """
        return pulumi.get(self, "pem_certificate_chains")

    @property
    @pulumi.getter(name="pemCsr")
    def pem_csr(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Immutable. A pem-encoded X.509 certificate signing request (CSR).
        """
        return pulumi.get(self, "pem_csr")

    @property
    @pulumi.getter
    def pool(self) -> pulumi.Output[builtins.str]:
        """
        The name of the CaPool this Certificate belongs to.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="revocationDetails")
    def revocation_details(self) -> pulumi.Output[Sequence['outputs.CertificateRevocationDetail']]:
        """
        Output only. Details regarding the revocation of this Certificate. This Certificate is
        considered revoked if and only if this field is present.
        Structure is documented below.
        """
        return pulumi.get(self, "revocation_details")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which this CertificateAuthority was updated.
        This is in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

