# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed: Optional[pulumi.Input['CertificateManagedArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 self_managed: Optional[pulumi.Input['CertificateSelfManagedArgs']] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the Certificate resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The Certificate Manager location. If not specified, "global" is used.
        :param pulumi.Input['CertificateManagedArgs'] managed: Configuration and state of a Managed Certificate.
               Certificate Manager provisions and renews Managed Certificates
               automatically, for as long as it's authorized to do so.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: A user-defined name of the certificate. Certificate names must be unique
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] scope: The scope of the certificate.
               DEFAULT: Certificates with default scope are served from core Google data centers.
               If unsure, choose this option.
               EDGE_CACHE: Certificates with scope EDGE_CACHE are special-purposed certificates, served from Edge Points of Presence.
               See https://cloud.google.com/vpc/docs/edge-locations.
               ALL_REGIONS: Certificates with ALL_REGIONS scope are served from all GCP regions (You can only use ALL_REGIONS with global certs).
               See https://cloud.google.com/compute/docs/regions-zones.
               CLIENT_AUTH: Certificates with CLIENT_AUTH scope are used by a load balancer (TLS client) to be presented to the backend (TLS server) when backend mTLS is configured.
               See https://cloud.google.com/load-balancing/docs/backend-authenticated-tls-backend-mtls#client-certificate.
        :param pulumi.Input['CertificateSelfManagedArgs'] self_managed: Certificate data for a SelfManaged Certificate.
               SelfManaged Certificates are uploaded by the user. Updating such
               certificates before they expire remains the user's responsibility.
               Structure is documented below.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed is not None:
            pulumi.set(__self__, "managed", managed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if self_managed is not None:
            pulumi.set(__self__, "self_managed", self_managed)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of label tags associated with the Certificate resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Certificate Manager location. If not specified, "global" is used.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def managed(self) -> Optional[pulumi.Input['CertificateManagedArgs']]:
        """
        Configuration and state of a Managed Certificate.
        Certificate Manager provisions and renews Managed Certificates
        automatically, for as long as it's authorized to do so.
        Structure is documented below.
        """
        return pulumi.get(self, "managed")

    @managed.setter
    def managed(self, value: Optional[pulumi.Input['CertificateManagedArgs']]):
        pulumi.set(self, "managed", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-defined name of the certificate. Certificate names must be unique
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of the certificate.
        DEFAULT: Certificates with default scope are served from core Google data centers.
        If unsure, choose this option.
        EDGE_CACHE: Certificates with scope EDGE_CACHE are special-purposed certificates, served from Edge Points of Presence.
        See https://cloud.google.com/vpc/docs/edge-locations.
        ALL_REGIONS: Certificates with ALL_REGIONS scope are served from all GCP regions (You can only use ALL_REGIONS with global certs).
        See https://cloud.google.com/compute/docs/regions-zones.
        CLIENT_AUTH: Certificates with CLIENT_AUTH scope are used by a load balancer (TLS client) to be presented to the backend (TLS server) when backend mTLS is configured.
        See https://cloud.google.com/load-balancing/docs/backend-authenticated-tls-backend-mtls#client-certificate.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="selfManaged")
    def self_managed(self) -> Optional[pulumi.Input['CertificateSelfManagedArgs']]:
        """
        Certificate data for a SelfManaged Certificate.
        SelfManaged Certificates are uploaded by the user. Updating such
        certificates before they expire remains the user's responsibility.
        Structure is documented below.
        """
        return pulumi.get(self, "self_managed")

    @self_managed.setter
    def self_managed(self, value: Optional[pulumi.Input['CertificateSelfManagedArgs']]):
        pulumi.set(self, "self_managed", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed: Optional[pulumi.Input['CertificateManagedArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 san_dnsnames: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 self_managed: Optional[pulumi.Input['CertificateSelfManagedArgs']] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the Certificate resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The Certificate Manager location. If not specified, "global" is used.
        :param pulumi.Input['CertificateManagedArgs'] managed: Configuration and state of a Managed Certificate.
               Certificate Manager provisions and renews Managed Certificates
               automatically, for as long as it's authorized to do so.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: A user-defined name of the certificate. Certificate names must be unique
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] san_dnsnames: The list of Subject Alternative Names of dnsName type defined in the certificate (see RFC 5280 4.2.1.6)
        :param pulumi.Input[builtins.str] scope: The scope of the certificate.
               DEFAULT: Certificates with default scope are served from core Google data centers.
               If unsure, choose this option.
               EDGE_CACHE: Certificates with scope EDGE_CACHE are special-purposed certificates, served from Edge Points of Presence.
               See https://cloud.google.com/vpc/docs/edge-locations.
               ALL_REGIONS: Certificates with ALL_REGIONS scope are served from all GCP regions (You can only use ALL_REGIONS with global certs).
               See https://cloud.google.com/compute/docs/regions-zones.
               CLIENT_AUTH: Certificates with CLIENT_AUTH scope are used by a load balancer (TLS client) to be presented to the backend (TLS server) when backend mTLS is configured.
               See https://cloud.google.com/load-balancing/docs/backend-authenticated-tls-backend-mtls#client-certificate.
        :param pulumi.Input['CertificateSelfManagedArgs'] self_managed: Certificate data for a SelfManaged Certificate.
               SelfManaged Certificates are uploaded by the user. Updating such
               certificates before they expire remains the user's responsibility.
               Structure is documented below.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed is not None:
            pulumi.set(__self__, "managed", managed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if san_dnsnames is not None:
            pulumi.set(__self__, "san_dnsnames", san_dnsnames)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if self_managed is not None:
            pulumi.set(__self__, "self_managed", self_managed)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of label tags associated with the Certificate resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Certificate Manager location. If not specified, "global" is used.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def managed(self) -> Optional[pulumi.Input['CertificateManagedArgs']]:
        """
        Configuration and state of a Managed Certificate.
        Certificate Manager provisions and renews Managed Certificates
        automatically, for as long as it's authorized to do so.
        Structure is documented below.
        """
        return pulumi.get(self, "managed")

    @managed.setter
    def managed(self, value: Optional[pulumi.Input['CertificateManagedArgs']]):
        pulumi.set(self, "managed", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-defined name of the certificate. Certificate names must be unique
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="sanDnsnames")
    def san_dnsnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of Subject Alternative Names of dnsName type defined in the certificate (see RFC 5280 4.2.1.6)
        """
        return pulumi.get(self, "san_dnsnames")

    @san_dnsnames.setter
    def san_dnsnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "san_dnsnames", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of the certificate.
        DEFAULT: Certificates with default scope are served from core Google data centers.
        If unsure, choose this option.
        EDGE_CACHE: Certificates with scope EDGE_CACHE are special-purposed certificates, served from Edge Points of Presence.
        See https://cloud.google.com/vpc/docs/edge-locations.
        ALL_REGIONS: Certificates with ALL_REGIONS scope are served from all GCP regions (You can only use ALL_REGIONS with global certs).
        See https://cloud.google.com/compute/docs/regions-zones.
        CLIENT_AUTH: Certificates with CLIENT_AUTH scope are used by a load balancer (TLS client) to be presented to the backend (TLS server) when backend mTLS is configured.
        See https://cloud.google.com/load-balancing/docs/backend-authenticated-tls-backend-mtls#client-certificate.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="selfManaged")
    def self_managed(self) -> Optional[pulumi.Input['CertificateSelfManagedArgs']]:
        """
        Certificate data for a SelfManaged Certificate.
        SelfManaged Certificates are uploaded by the user. Updating such
        certificates before they expire remains the user's responsibility.
        Structure is documented below.
        """
        return pulumi.get(self, "self_managed")

    @self_managed.setter
    def self_managed(self, value: Optional[pulumi.Input['CertificateSelfManagedArgs']]):
        pulumi.set(self, "self_managed", value)


@pulumi.type_token("gcp:certificatemanager/certificate:Certificate")
class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed: Optional[pulumi.Input[Union['CertificateManagedArgs', 'CertificateManagedArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 self_managed: Optional[pulumi.Input[Union['CertificateSelfManagedArgs', 'CertificateSelfManagedArgsDict']]] = None,
                 __props__=None):
        """
        Certificate represents a HTTP-reachable backend for a Certificate.

        ## Example Usage

        ### Certificate Manager Google Managed Certificate Dns

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.certificatemanager.DnsAuthorization("instance",
            name="dns-auth",
            description="The default dnss",
            domain="subdomain.hashicorptest.com")
        instance2 = gcp.certificatemanager.DnsAuthorization("instance2",
            name="dns-auth2",
            description="The default dnss",
            domain="subdomain2.hashicorptest.com")
        default = gcp.certificatemanager.Certificate("default",
            name="dns-cert",
            description="The default cert",
            scope="EDGE_CACHE",
            labels={
                "env": "test",
            },
            managed={
                "domains": [
                    instance.domain,
                    instance2.domain,
                ],
                "dns_authorizations": [
                    instance.id,
                    instance2.id,
                ],
            })
        ```
        ### Certificate Manager Google Managed Certificate Issuance Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.certificateauthority.CaPool("pool",
            name="ca-pool",
            location="us-central1",
            tier="ENTERPRISE")
        ca_authority = gcp.certificateauthority.Authority("ca_authority",
            location="us-central1",
            pool=pool.name,
            certificate_authority_id="ca-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        # creating certificate_issuance_config to use it in the managed certificate
        issuanceconfig = gcp.certificatemanager.CertificateIssuanceConfig("issuanceconfig",
            name="issuance-config",
            description="sample description for the certificate issuanceConfigs",
            certificate_authority_config={
                "certificate_authority_service_config": {
                    "ca_pool": pool.id,
                },
            },
            lifetime="1814400s",
            rotation_window_percentage=34,
            key_algorithm="ECDSA_P256",
            opts = pulumi.ResourceOptions(depends_on=[ca_authority]))
        default = gcp.certificatemanager.Certificate("default",
            name="issuance-config-cert",
            description="The default cert",
            scope="EDGE_CACHE",
            managed={
                "domains": ["terraform.subdomain1.com"],
                "issuance_config": issuanceconfig.id,
            })
        ```
        ### Certificate Manager Certificate Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.certificatemanager.DnsAuthorization("instance",
            name="dns-auth",
            description="The default dnss",
            domain="subdomain.hashicorptest.com")
        instance2 = gcp.certificatemanager.DnsAuthorization("instance2",
            name="dns-auth2",
            description="The default dnss",
            domain="subdomain2.hashicorptest.com")
        default = gcp.certificatemanager.Certificate("default",
            name="self-managed-cert",
            description="Global cert",
            scope="EDGE_CACHE",
            managed={
                "domains": [
                    instance.domain,
                    instance2.domain,
                ],
                "dns_authorizations": [
                    instance.id,
                    instance2.id,
                ],
            })
        ```
        ### Certificate Manager Self Managed Certificate Regional

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificatemanager.Certificate("default",
            name="self-managed-cert",
            description="Regional cert",
            location="us-central1",
            self_managed={
                "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                "pem_private_key": std.file(input="test-fixtures/private-key.pem").result,
            })
        ```
        ### Certificate Manager Google Managed Certificate Issuance Config All Regions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.certificateauthority.CaPool("pool",
            name="ca-pool",
            location="us-central1",
            tier="ENTERPRISE")
        ca_authority = gcp.certificateauthority.Authority("ca_authority",
            location="us-central1",
            pool=pool.name,
            certificate_authority_id="ca-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        # creating certificate_issuance_config to use it in the managed certificate
        issuanceconfig = gcp.certificatemanager.CertificateIssuanceConfig("issuanceconfig",
            name="issuance-config",
            description="sample description for the certificate issuanceConfigs",
            certificate_authority_config={
                "certificate_authority_service_config": {
                    "ca_pool": pool.id,
                },
            },
            lifetime="1814400s",
            rotation_window_percentage=34,
            key_algorithm="ECDSA_P256",
            opts = pulumi.ResourceOptions(depends_on=[ca_authority]))
        default = gcp.certificatemanager.Certificate("default",
            name="issuance-config-cert",
            description="sample google managed all_regions certificate with issuance config for terraform",
            scope="ALL_REGIONS",
            managed={
                "domains": ["terraform.subdomain1.com"],
                "issuance_config": issuanceconfig.id,
            })
        ```
        ### Certificate Manager Google Managed Certificate Dns All Regions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.certificatemanager.DnsAuthorization("instance",
            name="dns-auth",
            description="The default dnss",
            domain="subdomain.hashicorptest.com")
        instance2 = gcp.certificatemanager.DnsAuthorization("instance2",
            name="dns-auth2",
            description="The default dnss",
            domain="subdomain2.hashicorptest.com")
        default = gcp.certificatemanager.Certificate("default",
            name="dns-cert",
            description="The default cert",
            scope="ALL_REGIONS",
            managed={
                "domains": [
                    instance.domain,
                    instance2.domain,
                ],
                "dns_authorizations": [
                    instance.id,
                    instance2.id,
                ],
            })
        ```
        ### Certificate Manager Google Managed Regional Certificate Dns Auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.certificatemanager.DnsAuthorization("instance",
            name="dns-auth",
            location="us-central1",
            description="The default dnss",
            domain="subdomain.hashicorptest.com")
        default = gcp.certificatemanager.Certificate("default",
            name="dns-cert",
            description="regional managed certs",
            location="us-central1",
            managed={
                "domains": [instance.domain],
                "dns_authorizations": [instance.id],
            })
        ```
        ### Certificate Manager Client Auth Certificate

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificatemanager.Certificate("default",
            name="client-auth-cert",
            description="Global cert",
            scope="CLIENT_AUTH",
            self_managed={
                "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                "pem_private_key": std.file(input="test-fixtures/private-key.pem").result,
            })
        ```

        ## Import

        Certificate can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/certificates/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Certificate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificatemanager/certificate:Certificate default projects/{{project}}/locations/{{location}}/certificates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/certificate:Certificate default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/certificate:Certificate default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the Certificate resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The Certificate Manager location. If not specified, "global" is used.
        :param pulumi.Input[Union['CertificateManagedArgs', 'CertificateManagedArgsDict']] managed: Configuration and state of a Managed Certificate.
               Certificate Manager provisions and renews Managed Certificates
               automatically, for as long as it's authorized to do so.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: A user-defined name of the certificate. Certificate names must be unique
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] scope: The scope of the certificate.
               DEFAULT: Certificates with default scope are served from core Google data centers.
               If unsure, choose this option.
               EDGE_CACHE: Certificates with scope EDGE_CACHE are special-purposed certificates, served from Edge Points of Presence.
               See https://cloud.google.com/vpc/docs/edge-locations.
               ALL_REGIONS: Certificates with ALL_REGIONS scope are served from all GCP regions (You can only use ALL_REGIONS with global certs).
               See https://cloud.google.com/compute/docs/regions-zones.
               CLIENT_AUTH: Certificates with CLIENT_AUTH scope are used by a load balancer (TLS client) to be presented to the backend (TLS server) when backend mTLS is configured.
               See https://cloud.google.com/load-balancing/docs/backend-authenticated-tls-backend-mtls#client-certificate.
        :param pulumi.Input[Union['CertificateSelfManagedArgs', 'CertificateSelfManagedArgsDict']] self_managed: Certificate data for a SelfManaged Certificate.
               SelfManaged Certificates are uploaded by the user. Updating such
               certificates before they expire remains the user's responsibility.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CertificateArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Certificate represents a HTTP-reachable backend for a Certificate.

        ## Example Usage

        ### Certificate Manager Google Managed Certificate Dns

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.certificatemanager.DnsAuthorization("instance",
            name="dns-auth",
            description="The default dnss",
            domain="subdomain.hashicorptest.com")
        instance2 = gcp.certificatemanager.DnsAuthorization("instance2",
            name="dns-auth2",
            description="The default dnss",
            domain="subdomain2.hashicorptest.com")
        default = gcp.certificatemanager.Certificate("default",
            name="dns-cert",
            description="The default cert",
            scope="EDGE_CACHE",
            labels={
                "env": "test",
            },
            managed={
                "domains": [
                    instance.domain,
                    instance2.domain,
                ],
                "dns_authorizations": [
                    instance.id,
                    instance2.id,
                ],
            })
        ```
        ### Certificate Manager Google Managed Certificate Issuance Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.certificateauthority.CaPool("pool",
            name="ca-pool",
            location="us-central1",
            tier="ENTERPRISE")
        ca_authority = gcp.certificateauthority.Authority("ca_authority",
            location="us-central1",
            pool=pool.name,
            certificate_authority_id="ca-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        # creating certificate_issuance_config to use it in the managed certificate
        issuanceconfig = gcp.certificatemanager.CertificateIssuanceConfig("issuanceconfig",
            name="issuance-config",
            description="sample description for the certificate issuanceConfigs",
            certificate_authority_config={
                "certificate_authority_service_config": {
                    "ca_pool": pool.id,
                },
            },
            lifetime="1814400s",
            rotation_window_percentage=34,
            key_algorithm="ECDSA_P256",
            opts = pulumi.ResourceOptions(depends_on=[ca_authority]))
        default = gcp.certificatemanager.Certificate("default",
            name="issuance-config-cert",
            description="The default cert",
            scope="EDGE_CACHE",
            managed={
                "domains": ["terraform.subdomain1.com"],
                "issuance_config": issuanceconfig.id,
            })
        ```
        ### Certificate Manager Certificate Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.certificatemanager.DnsAuthorization("instance",
            name="dns-auth",
            description="The default dnss",
            domain="subdomain.hashicorptest.com")
        instance2 = gcp.certificatemanager.DnsAuthorization("instance2",
            name="dns-auth2",
            description="The default dnss",
            domain="subdomain2.hashicorptest.com")
        default = gcp.certificatemanager.Certificate("default",
            name="self-managed-cert",
            description="Global cert",
            scope="EDGE_CACHE",
            managed={
                "domains": [
                    instance.domain,
                    instance2.domain,
                ],
                "dns_authorizations": [
                    instance.id,
                    instance2.id,
                ],
            })
        ```
        ### Certificate Manager Self Managed Certificate Regional

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificatemanager.Certificate("default",
            name="self-managed-cert",
            description="Regional cert",
            location="us-central1",
            self_managed={
                "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                "pem_private_key": std.file(input="test-fixtures/private-key.pem").result,
            })
        ```
        ### Certificate Manager Google Managed Certificate Issuance Config All Regions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.certificateauthority.CaPool("pool",
            name="ca-pool",
            location="us-central1",
            tier="ENTERPRISE")
        ca_authority = gcp.certificateauthority.Authority("ca_authority",
            location="us-central1",
            pool=pool.name,
            certificate_authority_id="ca-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        # creating certificate_issuance_config to use it in the managed certificate
        issuanceconfig = gcp.certificatemanager.CertificateIssuanceConfig("issuanceconfig",
            name="issuance-config",
            description="sample description for the certificate issuanceConfigs",
            certificate_authority_config={
                "certificate_authority_service_config": {
                    "ca_pool": pool.id,
                },
            },
            lifetime="1814400s",
            rotation_window_percentage=34,
            key_algorithm="ECDSA_P256",
            opts = pulumi.ResourceOptions(depends_on=[ca_authority]))
        default = gcp.certificatemanager.Certificate("default",
            name="issuance-config-cert",
            description="sample google managed all_regions certificate with issuance config for terraform",
            scope="ALL_REGIONS",
            managed={
                "domains": ["terraform.subdomain1.com"],
                "issuance_config": issuanceconfig.id,
            })
        ```
        ### Certificate Manager Google Managed Certificate Dns All Regions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.certificatemanager.DnsAuthorization("instance",
            name="dns-auth",
            description="The default dnss",
            domain="subdomain.hashicorptest.com")
        instance2 = gcp.certificatemanager.DnsAuthorization("instance2",
            name="dns-auth2",
            description="The default dnss",
            domain="subdomain2.hashicorptest.com")
        default = gcp.certificatemanager.Certificate("default",
            name="dns-cert",
            description="The default cert",
            scope="ALL_REGIONS",
            managed={
                "domains": [
                    instance.domain,
                    instance2.domain,
                ],
                "dns_authorizations": [
                    instance.id,
                    instance2.id,
                ],
            })
        ```
        ### Certificate Manager Google Managed Regional Certificate Dns Auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.certificatemanager.DnsAuthorization("instance",
            name="dns-auth",
            location="us-central1",
            description="The default dnss",
            domain="subdomain.hashicorptest.com")
        default = gcp.certificatemanager.Certificate("default",
            name="dns-cert",
            description="regional managed certs",
            location="us-central1",
            managed={
                "domains": [instance.domain],
                "dns_authorizations": [instance.id],
            })
        ```
        ### Certificate Manager Client Auth Certificate

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificatemanager.Certificate("default",
            name="client-auth-cert",
            description="Global cert",
            scope="CLIENT_AUTH",
            self_managed={
                "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                "pem_private_key": std.file(input="test-fixtures/private-key.pem").result,
            })
        ```

        ## Import

        Certificate can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/certificates/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Certificate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificatemanager/certificate:Certificate default projects/{{project}}/locations/{{location}}/certificates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/certificate:Certificate default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/certificate:Certificate default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed: Optional[pulumi.Input[Union['CertificateManagedArgs', 'CertificateManagedArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 self_managed: Optional[pulumi.Input[Union['CertificateSelfManagedArgs', 'CertificateSelfManagedArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["managed"] = managed
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["scope"] = scope
            __props__.__dict__["self_managed"] = self_managed
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["san_dnsnames"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Certificate, __self__).__init__(
            'gcp:certificatemanager/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            managed: Optional[pulumi.Input[Union['CertificateManagedArgs', 'CertificateManagedArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            san_dnsnames: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None,
            self_managed: Optional[pulumi.Input[Union['CertificateSelfManagedArgs', 'CertificateSelfManagedArgsDict']]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the Certificate resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The Certificate Manager location. If not specified, "global" is used.
        :param pulumi.Input[Union['CertificateManagedArgs', 'CertificateManagedArgsDict']] managed: Configuration and state of a Managed Certificate.
               Certificate Manager provisions and renews Managed Certificates
               automatically, for as long as it's authorized to do so.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: A user-defined name of the certificate. Certificate names must be unique
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] san_dnsnames: The list of Subject Alternative Names of dnsName type defined in the certificate (see RFC 5280 4.2.1.6)
        :param pulumi.Input[builtins.str] scope: The scope of the certificate.
               DEFAULT: Certificates with default scope are served from core Google data centers.
               If unsure, choose this option.
               EDGE_CACHE: Certificates with scope EDGE_CACHE are special-purposed certificates, served from Edge Points of Presence.
               See https://cloud.google.com/vpc/docs/edge-locations.
               ALL_REGIONS: Certificates with ALL_REGIONS scope are served from all GCP regions (You can only use ALL_REGIONS with global certs).
               See https://cloud.google.com/compute/docs/regions-zones.
               CLIENT_AUTH: Certificates with CLIENT_AUTH scope are used by a load balancer (TLS client) to be presented to the backend (TLS server) when backend mTLS is configured.
               See https://cloud.google.com/load-balancing/docs/backend-authenticated-tls-backend-mtls#client-certificate.
        :param pulumi.Input[Union['CertificateSelfManagedArgs', 'CertificateSelfManagedArgsDict']] self_managed: Certificate data for a SelfManaged Certificate.
               SelfManaged Certificates are uploaded by the user. Updating such
               certificates before they expire remains the user's responsibility.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["managed"] = managed
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["san_dnsnames"] = san_dnsnames
        __props__.__dict__["scope"] = scope
        __props__.__dict__["self_managed"] = self_managed
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Set of label tags associated with the Certificate resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Certificate Manager location. If not specified, "global" is used.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def managed(self) -> pulumi.Output[Optional['outputs.CertificateManaged']]:
        """
        Configuration and state of a Managed Certificate.
        Certificate Manager provisions and renews Managed Certificates
        automatically, for as long as it's authorized to do so.
        Structure is documented below.
        """
        return pulumi.get(self, "managed")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A user-defined name of the certificate. Certificate names must be unique
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="sanDnsnames")
    def san_dnsnames(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of Subject Alternative Names of dnsName type defined in the certificate (see RFC 5280 4.2.1.6)
        """
        return pulumi.get(self, "san_dnsnames")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The scope of the certificate.
        DEFAULT: Certificates with default scope are served from core Google data centers.
        If unsure, choose this option.
        EDGE_CACHE: Certificates with scope EDGE_CACHE are special-purposed certificates, served from Edge Points of Presence.
        See https://cloud.google.com/vpc/docs/edge-locations.
        ALL_REGIONS: Certificates with ALL_REGIONS scope are served from all GCP regions (You can only use ALL_REGIONS with global certs).
        See https://cloud.google.com/compute/docs/regions-zones.
        CLIENT_AUTH: Certificates with CLIENT_AUTH scope are used by a load balancer (TLS client) to be presented to the backend (TLS server) when backend mTLS is configured.
        See https://cloud.google.com/load-balancing/docs/backend-authenticated-tls-backend-mtls#client-certificate.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="selfManaged")
    def self_managed(self) -> pulumi.Output[Optional['outputs.CertificateSelfManaged']]:
        """
        Certificate data for a SelfManaged Certificate.
        SelfManaged Certificates are uploaded by the user. Updating such
        certificates before they expire remains the user's responsibility.
        Structure is documented below.
        """
        return pulumi.get(self, "self_managed")

