# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateIssuanceConfigArgs', 'CertificateIssuanceConfig']

@pulumi.input_type
class CertificateIssuanceConfigArgs:
    def __init__(__self__, *,
                 certificate_authority_config: pulumi.Input['CertificateIssuanceConfigCertificateAuthorityConfigArgs'],
                 key_algorithm: pulumi.Input[builtins.str],
                 lifetime: pulumi.Input[builtins.str],
                 rotation_window_percentage: pulumi.Input[builtins.int],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CertificateIssuanceConfig resource.
        :param pulumi.Input['CertificateIssuanceConfigCertificateAuthorityConfigArgs'] certificate_authority_config: The CA that issues the workload certificate. It includes the CA address, type, authentication to CA service, etc.
               Structure is documented below.
        :param pulumi.Input[builtins.str] key_algorithm: Key algorithm to use when generating the private key.
               Possible values are: `RSA_2048`, `ECDSA_P256`.
        :param pulumi.Input[builtins.str] lifetime: Lifetime of issued certificates. A duration in seconds with up to nine fractional digits, ending with 's'.
               Example: "1814400s". Valid values are from 21 days (1814400s) to 30 days (2592000s)
        :param pulumi.Input[builtins.int] rotation_window_percentage: It specifies the percentage of elapsed time of the certificate lifetime to wait before renewing the certificate.
               Must be a number between 1-99, inclusive.
               You must set the rotation window percentage in relation to the certificate lifetime so that certificate renewal occurs at least 7 days after
               the certificate has been issued and at least 7 days before it expires.
        :param pulumi.Input[builtins.str] description: One or more paragraphs of text description of a CertificateIssuanceConfig.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: 'Set of label tags associated with the CertificateIssuanceConfig resource. An object containing a list of "key": value
               pairs. Example: { "name": "wrench", "count": "3" }. **Note**: This field is non-authoritative, and will only manage the
               labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
               resource.
        :param pulumi.Input[builtins.str] location: The Certificate Manager location. If not specified, "global" is used.
        :param pulumi.Input[builtins.str] name: A user-defined name of the certificate issuance config.
               CertificateIssuanceConfig names must be unique globally.
        """
        pulumi.set(__self__, "certificate_authority_config", certificate_authority_config)
        pulumi.set(__self__, "key_algorithm", key_algorithm)
        pulumi.set(__self__, "lifetime", lifetime)
        pulumi.set(__self__, "rotation_window_percentage", rotation_window_percentage)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="certificateAuthorityConfig")
    def certificate_authority_config(self) -> pulumi.Input['CertificateIssuanceConfigCertificateAuthorityConfigArgs']:
        """
        The CA that issues the workload certificate. It includes the CA address, type, authentication to CA service, etc.
        Structure is documented below.
        """
        return pulumi.get(self, "certificate_authority_config")

    @certificate_authority_config.setter
    def certificate_authority_config(self, value: pulumi.Input['CertificateIssuanceConfigCertificateAuthorityConfigArgs']):
        pulumi.set(self, "certificate_authority_config", value)

    @property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Input[builtins.str]:
        """
        Key algorithm to use when generating the private key.
        Possible values are: `RSA_2048`, `ECDSA_P256`.
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_algorithm", value)

    @property
    @pulumi.getter
    def lifetime(self) -> pulumi.Input[builtins.str]:
        """
        Lifetime of issued certificates. A duration in seconds with up to nine fractional digits, ending with 's'.
        Example: "1814400s". Valid values are from 21 days (1814400s) to 30 days (2592000s)
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "lifetime", value)

    @property
    @pulumi.getter(name="rotationWindowPercentage")
    def rotation_window_percentage(self) -> pulumi.Input[builtins.int]:
        """
        It specifies the percentage of elapsed time of the certificate lifetime to wait before renewing the certificate.
        Must be a number between 1-99, inclusive.
        You must set the rotation window percentage in relation to the certificate lifetime so that certificate renewal occurs at least 7 days after
        the certificate has been issued and at least 7 days before it expires.
        """
        return pulumi.get(self, "rotation_window_percentage")

    @rotation_window_percentage.setter
    def rotation_window_percentage(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "rotation_window_percentage", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        One or more paragraphs of text description of a CertificateIssuanceConfig.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        'Set of label tags associated with the CertificateIssuanceConfig resource. An object containing a list of "key": value
        pairs. Example: { "name": "wrench", "count": "3" }. **Note**: This field is non-authoritative, and will only manage the
        labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
        resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Certificate Manager location. If not specified, "global" is used.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-defined name of the certificate issuance config.
        CertificateIssuanceConfig names must be unique globally.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _CertificateIssuanceConfigState:
    def __init__(__self__, *,
                 certificate_authority_config: Optional[pulumi.Input['CertificateIssuanceConfigCertificateAuthorityConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 key_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifetime: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 rotation_window_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CertificateIssuanceConfig resources.
        :param pulumi.Input['CertificateIssuanceConfigCertificateAuthorityConfigArgs'] certificate_authority_config: The CA that issues the workload certificate. It includes the CA address, type, authentication to CA service, etc.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The creation timestamp of a CertificateIssuanceConfig. Timestamp is in RFC3339 UTC "Zulu" format,
               accurate to nanoseconds with up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] description: One or more paragraphs of text description of a CertificateIssuanceConfig.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] key_algorithm: Key algorithm to use when generating the private key.
               Possible values are: `RSA_2048`, `ECDSA_P256`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: 'Set of label tags associated with the CertificateIssuanceConfig resource. An object containing a list of "key": value
               pairs. Example: { "name": "wrench", "count": "3" }. **Note**: This field is non-authoritative, and will only manage the
               labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
               resource.
        :param pulumi.Input[builtins.str] lifetime: Lifetime of issued certificates. A duration in seconds with up to nine fractional digits, ending with 's'.
               Example: "1814400s". Valid values are from 21 days (1814400s) to 30 days (2592000s)
        :param pulumi.Input[builtins.str] location: The Certificate Manager location. If not specified, "global" is used.
        :param pulumi.Input[builtins.str] name: A user-defined name of the certificate issuance config.
               CertificateIssuanceConfig names must be unique globally.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.int] rotation_window_percentage: It specifies the percentage of elapsed time of the certificate lifetime to wait before renewing the certificate.
               Must be a number between 1-99, inclusive.
               You must set the rotation window percentage in relation to the certificate lifetime so that certificate renewal occurs at least 7 days after
               the certificate has been issued and at least 7 days before it expires.
        :param pulumi.Input[builtins.str] update_time: The last update timestamp of a CertificateIssuanceConfig. Timestamp is in RFC3339 UTC "Zulu" format,
               accurate to nanoseconds with up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if certificate_authority_config is not None:
            pulumi.set(__self__, "certificate_authority_config", certificate_authority_config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if key_algorithm is not None:
            pulumi.set(__self__, "key_algorithm", key_algorithm)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if rotation_window_percentage is not None:
            pulumi.set(__self__, "rotation_window_percentage", rotation_window_percentage)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="certificateAuthorityConfig")
    def certificate_authority_config(self) -> Optional[pulumi.Input['CertificateIssuanceConfigCertificateAuthorityConfigArgs']]:
        """
        The CA that issues the workload certificate. It includes the CA address, type, authentication to CA service, etc.
        Structure is documented below.
        """
        return pulumi.get(self, "certificate_authority_config")

    @certificate_authority_config.setter
    def certificate_authority_config(self, value: Optional[pulumi.Input['CertificateIssuanceConfigCertificateAuthorityConfigArgs']]):
        pulumi.set(self, "certificate_authority_config", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation timestamp of a CertificateIssuanceConfig. Timestamp is in RFC3339 UTC "Zulu" format,
        accurate to nanoseconds with up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        One or more paragraphs of text description of a CertificateIssuanceConfig.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key algorithm to use when generating the private key.
        Possible values are: `RSA_2048`, `ECDSA_P256`.
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_algorithm", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        'Set of label tags associated with the CertificateIssuanceConfig resource. An object containing a list of "key": value
        pairs. Example: { "name": "wrench", "count": "3" }. **Note**: This field is non-authoritative, and will only manage the
        labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
        resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lifetime of issued certificates. A duration in seconds with up to nine fractional digits, ending with 's'.
        Example: "1814400s". Valid values are from 21 days (1814400s) to 30 days (2592000s)
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifetime", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Certificate Manager location. If not specified, "global" is used.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-defined name of the certificate issuance config.
        CertificateIssuanceConfig names must be unique globally.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="rotationWindowPercentage")
    def rotation_window_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        It specifies the percentage of elapsed time of the certificate lifetime to wait before renewing the certificate.
        Must be a number between 1-99, inclusive.
        You must set the rotation window percentage in relation to the certificate lifetime so that certificate renewal occurs at least 7 days after
        the certificate has been issued and at least 7 days before it expires.
        """
        return pulumi.get(self, "rotation_window_percentage")

    @rotation_window_percentage.setter
    def rotation_window_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rotation_window_percentage", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last update timestamp of a CertificateIssuanceConfig. Timestamp is in RFC3339 UTC "Zulu" format,
        accurate to nanoseconds with up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:certificatemanager/certificateIssuanceConfig:CertificateIssuanceConfig")
class CertificateIssuanceConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority_config: Optional[pulumi.Input[Union['CertificateIssuanceConfigCertificateAuthorityConfigArgs', 'CertificateIssuanceConfigCertificateAuthorityConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 key_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifetime: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rotation_window_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Certificate represents a HTTP-reachable backend for a Certificate.

        To get more information about CertificateIssuanceConfig, see:

        * [API documentation](https://cloud.google.com/certificate-manager/docs/reference/certificate-manager/rest/v1/projects.locations.certificateIssuanceConfigs)
        * How-to Guides
            * [Manage certificate issuance configs](https://cloud.google.com/certificate-manager/docs/issuance-configs)

        ## Example Usage

        ### Certificate Manager Certificate Issuance Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.certificateauthority.CaPool("pool",
            name="ca-pool",
            location="us-central1",
            tier="ENTERPRISE")
        ca_authority = gcp.certificateauthority.Authority("ca_authority",
            location="us-central1",
            pool=pool.name,
            certificate_authority_id="ca-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        default = gcp.certificatemanager.CertificateIssuanceConfig("default",
            name="issuance-config",
            description="sample description for the certificate issuanceConfigs",
            certificate_authority_config={
                "certificate_authority_service_config": {
                    "ca_pool": pool.id,
                },
            },
            lifetime="1814400s",
            rotation_window_percentage=34,
            key_algorithm="ECDSA_P256",
            labels={
                "name": "wrench",
                "count": "3",
            },
            opts = pulumi.ResourceOptions(depends_on=[ca_authority]))
        ```

        ## Import

        CertificateIssuanceConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/certificateIssuanceConfigs/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, CertificateIssuanceConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificatemanager/certificateIssuanceConfig:CertificateIssuanceConfig default projects/{{project}}/locations/{{location}}/certificateIssuanceConfigs/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/certificateIssuanceConfig:CertificateIssuanceConfig default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/certificateIssuanceConfig:CertificateIssuanceConfig default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CertificateIssuanceConfigCertificateAuthorityConfigArgs', 'CertificateIssuanceConfigCertificateAuthorityConfigArgsDict']] certificate_authority_config: The CA that issues the workload certificate. It includes the CA address, type, authentication to CA service, etc.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: One or more paragraphs of text description of a CertificateIssuanceConfig.
        :param pulumi.Input[builtins.str] key_algorithm: Key algorithm to use when generating the private key.
               Possible values are: `RSA_2048`, `ECDSA_P256`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: 'Set of label tags associated with the CertificateIssuanceConfig resource. An object containing a list of "key": value
               pairs. Example: { "name": "wrench", "count": "3" }. **Note**: This field is non-authoritative, and will only manage the
               labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
               resource.
        :param pulumi.Input[builtins.str] lifetime: Lifetime of issued certificates. A duration in seconds with up to nine fractional digits, ending with 's'.
               Example: "1814400s". Valid values are from 21 days (1814400s) to 30 days (2592000s)
        :param pulumi.Input[builtins.str] location: The Certificate Manager location. If not specified, "global" is used.
        :param pulumi.Input[builtins.str] name: A user-defined name of the certificate issuance config.
               CertificateIssuanceConfig names must be unique globally.
        :param pulumi.Input[builtins.int] rotation_window_percentage: It specifies the percentage of elapsed time of the certificate lifetime to wait before renewing the certificate.
               Must be a number between 1-99, inclusive.
               You must set the rotation window percentage in relation to the certificate lifetime so that certificate renewal occurs at least 7 days after
               the certificate has been issued and at least 7 days before it expires.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateIssuanceConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Certificate represents a HTTP-reachable backend for a Certificate.

        To get more information about CertificateIssuanceConfig, see:

        * [API documentation](https://cloud.google.com/certificate-manager/docs/reference/certificate-manager/rest/v1/projects.locations.certificateIssuanceConfigs)
        * How-to Guides
            * [Manage certificate issuance configs](https://cloud.google.com/certificate-manager/docs/issuance-configs)

        ## Example Usage

        ### Certificate Manager Certificate Issuance Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.certificateauthority.CaPool("pool",
            name="ca-pool",
            location="us-central1",
            tier="ENTERPRISE")
        ca_authority = gcp.certificateauthority.Authority("ca_authority",
            location="us-central1",
            pool=pool.name,
            certificate_authority_id="ca-authority",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "HashiCorp",
                        "common_name": "my-certificate-authority",
                    },
                    "subject_alt_name": {
                        "dns_names": ["hashicorp.com"],
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        default = gcp.certificatemanager.CertificateIssuanceConfig("default",
            name="issuance-config",
            description="sample description for the certificate issuanceConfigs",
            certificate_authority_config={
                "certificate_authority_service_config": {
                    "ca_pool": pool.id,
                },
            },
            lifetime="1814400s",
            rotation_window_percentage=34,
            key_algorithm="ECDSA_P256",
            labels={
                "name": "wrench",
                "count": "3",
            },
            opts = pulumi.ResourceOptions(depends_on=[ca_authority]))
        ```

        ## Import

        CertificateIssuanceConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/certificateIssuanceConfigs/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, CertificateIssuanceConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificatemanager/certificateIssuanceConfig:CertificateIssuanceConfig default projects/{{project}}/locations/{{location}}/certificateIssuanceConfigs/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/certificateIssuanceConfig:CertificateIssuanceConfig default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/certificateIssuanceConfig:CertificateIssuanceConfig default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CertificateIssuanceConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateIssuanceConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority_config: Optional[pulumi.Input[Union['CertificateIssuanceConfigCertificateAuthorityConfigArgs', 'CertificateIssuanceConfigCertificateAuthorityConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 key_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifetime: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rotation_window_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateIssuanceConfigArgs.__new__(CertificateIssuanceConfigArgs)

            if certificate_authority_config is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_authority_config'")
            __props__.__dict__["certificate_authority_config"] = certificate_authority_config
            __props__.__dict__["description"] = description
            if key_algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'key_algorithm'")
            __props__.__dict__["key_algorithm"] = key_algorithm
            __props__.__dict__["labels"] = labels
            if lifetime is None and not opts.urn:
                raise TypeError("Missing required property 'lifetime'")
            __props__.__dict__["lifetime"] = lifetime
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if rotation_window_percentage is None and not opts.urn:
                raise TypeError("Missing required property 'rotation_window_percentage'")
            __props__.__dict__["rotation_window_percentage"] = rotation_window_percentage
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CertificateIssuanceConfig, __self__).__init__(
            'gcp:certificatemanager/certificateIssuanceConfig:CertificateIssuanceConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_authority_config: Optional[pulumi.Input[Union['CertificateIssuanceConfigCertificateAuthorityConfigArgs', 'CertificateIssuanceConfigCertificateAuthorityConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            key_algorithm: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifetime: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            rotation_window_percentage: Optional[pulumi.Input[builtins.int]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'CertificateIssuanceConfig':
        """
        Get an existing CertificateIssuanceConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CertificateIssuanceConfigCertificateAuthorityConfigArgs', 'CertificateIssuanceConfigCertificateAuthorityConfigArgsDict']] certificate_authority_config: The CA that issues the workload certificate. It includes the CA address, type, authentication to CA service, etc.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The creation timestamp of a CertificateIssuanceConfig. Timestamp is in RFC3339 UTC "Zulu" format,
               accurate to nanoseconds with up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] description: One or more paragraphs of text description of a CertificateIssuanceConfig.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] key_algorithm: Key algorithm to use when generating the private key.
               Possible values are: `RSA_2048`, `ECDSA_P256`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: 'Set of label tags associated with the CertificateIssuanceConfig resource. An object containing a list of "key": value
               pairs. Example: { "name": "wrench", "count": "3" }. **Note**: This field is non-authoritative, and will only manage the
               labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
               resource.
        :param pulumi.Input[builtins.str] lifetime: Lifetime of issued certificates. A duration in seconds with up to nine fractional digits, ending with 's'.
               Example: "1814400s". Valid values are from 21 days (1814400s) to 30 days (2592000s)
        :param pulumi.Input[builtins.str] location: The Certificate Manager location. If not specified, "global" is used.
        :param pulumi.Input[builtins.str] name: A user-defined name of the certificate issuance config.
               CertificateIssuanceConfig names must be unique globally.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.int] rotation_window_percentage: It specifies the percentage of elapsed time of the certificate lifetime to wait before renewing the certificate.
               Must be a number between 1-99, inclusive.
               You must set the rotation window percentage in relation to the certificate lifetime so that certificate renewal occurs at least 7 days after
               the certificate has been issued and at least 7 days before it expires.
        :param pulumi.Input[builtins.str] update_time: The last update timestamp of a CertificateIssuanceConfig. Timestamp is in RFC3339 UTC "Zulu" format,
               accurate to nanoseconds with up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateIssuanceConfigState.__new__(_CertificateIssuanceConfigState)

        __props__.__dict__["certificate_authority_config"] = certificate_authority_config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["key_algorithm"] = key_algorithm
        __props__.__dict__["labels"] = labels
        __props__.__dict__["lifetime"] = lifetime
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["rotation_window_percentage"] = rotation_window_percentage
        __props__.__dict__["update_time"] = update_time
        return CertificateIssuanceConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateAuthorityConfig")
    def certificate_authority_config(self) -> pulumi.Output['outputs.CertificateIssuanceConfigCertificateAuthorityConfig']:
        """
        The CA that issues the workload certificate. It includes the CA address, type, authentication to CA service, etc.
        Structure is documented below.
        """
        return pulumi.get(self, "certificate_authority_config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The creation timestamp of a CertificateIssuanceConfig. Timestamp is in RFC3339 UTC "Zulu" format,
        accurate to nanoseconds with up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        One or more paragraphs of text description of a CertificateIssuanceConfig.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Output[builtins.str]:
        """
        Key algorithm to use when generating the private key.
        Possible values are: `RSA_2048`, `ECDSA_P256`.
        """
        return pulumi.get(self, "key_algorithm")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        'Set of label tags associated with the CertificateIssuanceConfig resource. An object containing a list of "key": value
        pairs. Example: { "name": "wrench", "count": "3" }. **Note**: This field is non-authoritative, and will only manage the
        labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
        resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def lifetime(self) -> pulumi.Output[builtins.str]:
        """
        Lifetime of issued certificates. A duration in seconds with up to nine fractional digits, ending with 's'.
        Example: "1814400s". Valid values are from 21 days (1814400s) to 30 days (2592000s)
        """
        return pulumi.get(self, "lifetime")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Certificate Manager location. If not specified, "global" is used.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A user-defined name of the certificate issuance config.
        CertificateIssuanceConfig names must be unique globally.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="rotationWindowPercentage")
    def rotation_window_percentage(self) -> pulumi.Output[builtins.int]:
        """
        It specifies the percentage of elapsed time of the certificate lifetime to wait before renewing the certificate.
        Must be a number between 1-99, inclusive.
        You must set the rotation window percentage in relation to the certificate lifetime so that certificate renewal occurs at least 7 days after
        the certificate has been issued and at least 7 days before it expires.
        """
        return pulumi.get(self, "rotation_window_percentage")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The last update timestamp of a CertificateIssuanceConfig. Timestamp is in RFC3339 UTC "Zulu" format,
        accurate to nanoseconds with up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

