# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReferenceListArgs', 'ReferenceList']

@pulumi.input_type
class ReferenceListArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 entries: pulumi.Input[Sequence[pulumi.Input['ReferenceListEntryArgs']]],
                 instance: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 reference_list_id: pulumi.Input[builtins.str],
                 syntax_type: pulumi.Input[builtins.str],
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ReferenceList resource.
        :param pulumi.Input[builtins.str] description: Required. A user-provided description of the reference list.
        :param pulumi.Input[Sequence[pulumi.Input['ReferenceListEntryArgs']]] entries: Required. The entries of the reference list.
               When listed, they are returned in the order that was specified at creation
               or update. The combined size of the values of the reference list may not
               exceed 6MB.
               This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
               Structure is documented below.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.str] reference_list_id: Required. The ID to use for the reference list. This is also the display name for
               the reference list. It must satisfy the following requirements:
               - Starts with letter.
               - Contains only letters, numbers and underscore.
               - Has length < 256.
               - Must be unique.
        :param pulumi.Input[builtins.str] syntax_type: Possible values:
               REFERENCE_LIST_SYNTAX_TYPE_PLAIN_TEXT_STRING
               REFERENCE_LIST_SYNTAX_TYPE_REGEX
               REFERENCE_LIST_SYNTAX_TYPE_CIDR
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "entries", entries)
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "reference_list_id", reference_list_id)
        pulumi.set(__self__, "syntax_type", syntax_type)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        Required. A user-provided description of the reference list.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def entries(self) -> pulumi.Input[Sequence[pulumi.Input['ReferenceListEntryArgs']]]:
        """
        Required. The entries of the reference list.
        When listed, they are returned in the order that was specified at creation
        or update. The combined size of the values of the reference list may not
        exceed 6MB.
        This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
        Structure is documented below.
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: pulumi.Input[Sequence[pulumi.Input['ReferenceListEntryArgs']]]):
        pulumi.set(self, "entries", value)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Input[builtins.str]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="referenceListId")
    def reference_list_id(self) -> pulumi.Input[builtins.str]:
        """
        Required. The ID to use for the reference list. This is also the display name for
        the reference list. It must satisfy the following requirements:
        - Starts with letter.
        - Contains only letters, numbers and underscore.
        - Has length < 256.
        - Must be unique.
        """
        return pulumi.get(self, "reference_list_id")

    @reference_list_id.setter
    def reference_list_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "reference_list_id", value)

    @property
    @pulumi.getter(name="syntaxType")
    def syntax_type(self) -> pulumi.Input[builtins.str]:
        """
        Possible values:
        REFERENCE_LIST_SYNTAX_TYPE_PLAIN_TEXT_STRING
        REFERENCE_LIST_SYNTAX_TYPE_REGEX
        REFERENCE_LIST_SYNTAX_TYPE_CIDR
        """
        return pulumi.get(self, "syntax_type")

    @syntax_type.setter
    def syntax_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "syntax_type", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ReferenceListState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['ReferenceListEntryArgs']]]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reference_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 revision_create_time: Optional[pulumi.Input[builtins.str]] = None,
                 rule_associations_count: Optional[pulumi.Input[builtins.int]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scope_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ReferenceListScopeInfoArgs']]]] = None,
                 syntax_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReferenceList resources.
        :param pulumi.Input[builtins.str] description: Required. A user-provided description of the reference list.
        :param pulumi.Input[builtins.str] display_name: Output only. The unique display name of the reference list.
        :param pulumi.Input[Sequence[pulumi.Input['ReferenceListEntryArgs']]] entries: Required. The entries of the reference list.
               When listed, they are returned in the order that was specified at creation
               or update. The combined size of the values of the reference list may not
               exceed 6MB.
               This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
               Structure is documented below.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.str] name: Output only. The resource name of the reference list.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/referenceLists/{reference_list}
        :param pulumi.Input[builtins.str] reference_list_id: Required. The ID to use for the reference list. This is also the display name for
               the reference list. It must satisfy the following requirements:
               - Starts with letter.
               - Contains only letters, numbers and underscore.
               - Has length < 256.
               - Must be unique.
        :param pulumi.Input[builtins.str] revision_create_time: Output only. The timestamp when the reference list was last updated.
        :param pulumi.Input[builtins.int] rule_associations_count: Output only. The count of self-authored rules using the reference list.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] rules: Output only. The resource names for the associated self-authored Rules that use this
               reference list.
               This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
        :param pulumi.Input[Sequence[pulumi.Input['ReferenceListScopeInfoArgs']]] scope_infos: ScopeInfo specifies the scope info of the reference list.
               Structure is documented below.
        :param pulumi.Input[builtins.str] syntax_type: Possible values:
               REFERENCE_LIST_SYNTAX_TYPE_PLAIN_TEXT_STRING
               REFERENCE_LIST_SYNTAX_TYPE_REGEX
               REFERENCE_LIST_SYNTAX_TYPE_CIDR
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reference_list_id is not None:
            pulumi.set(__self__, "reference_list_id", reference_list_id)
        if revision_create_time is not None:
            pulumi.set(__self__, "revision_create_time", revision_create_time)
        if rule_associations_count is not None:
            pulumi.set(__self__, "rule_associations_count", rule_associations_count)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if scope_infos is not None:
            pulumi.set(__self__, "scope_infos", scope_infos)
        if syntax_type is not None:
            pulumi.set(__self__, "syntax_type", syntax_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. A user-provided description of the reference list.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The unique display name of the reference list.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReferenceListEntryArgs']]]]:
        """
        Required. The entries of the reference list.
        When listed, they are returned in the order that was specified at creation
        or update. The combined size of the values of the reference list may not
        exceed 6MB.
        This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
        Structure is documented below.
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReferenceListEntryArgs']]]]):
        pulumi.set(self, "entries", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The resource name of the reference list.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/referenceLists/{reference_list}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="referenceListId")
    def reference_list_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. The ID to use for the reference list. This is also the display name for
        the reference list. It must satisfy the following requirements:
        - Starts with letter.
        - Contains only letters, numbers and underscore.
        - Has length < 256.
        - Must be unique.
        """
        return pulumi.get(self, "reference_list_id")

    @reference_list_id.setter
    def reference_list_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reference_list_id", value)

    @property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The timestamp when the reference list was last updated.
        """
        return pulumi.get(self, "revision_create_time")

    @revision_create_time.setter
    def revision_create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "revision_create_time", value)

    @property
    @pulumi.getter(name="ruleAssociationsCount")
    def rule_associations_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Output only. The count of self-authored rules using the reference list.
        """
        return pulumi.get(self, "rule_associations_count")

    @rule_associations_count.setter
    def rule_associations_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rule_associations_count", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Output only. The resource names for the associated self-authored Rules that use this
        reference list.
        This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="scopeInfos")
    def scope_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReferenceListScopeInfoArgs']]]]:
        """
        ScopeInfo specifies the scope info of the reference list.
        Structure is documented below.
        """
        return pulumi.get(self, "scope_infos")

    @scope_infos.setter
    def scope_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReferenceListScopeInfoArgs']]]]):
        pulumi.set(self, "scope_infos", value)

    @property
    @pulumi.getter(name="syntaxType")
    def syntax_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible values:
        REFERENCE_LIST_SYNTAX_TYPE_PLAIN_TEXT_STRING
        REFERENCE_LIST_SYNTAX_TYPE_REGEX
        REFERENCE_LIST_SYNTAX_TYPE_CIDR
        """
        return pulumi.get(self, "syntax_type")

    @syntax_type.setter
    def syntax_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "syntax_type", value)


@pulumi.type_token("gcp:chronicle/referenceList:ReferenceList")
class ReferenceList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReferenceListEntryArgs', 'ReferenceListEntryArgsDict']]]]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reference_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 syntax_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Reference lists are user-defined lists of values which users can use in multiple Rules.

        To get more information about ReferenceList, see:

        * [API documentation](https://cloud.google.com/chronicle/docs/reference/rest/v1/projects.locations.instances.referenceLists)
        * How-to Guides
            * [Google SecOps Guides](https://cloud.google.com/chronicle/docs/secops/secops-overview)

        ## Example Usage

        ### Chronicle Referencelist Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.ReferenceList("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            reference_list_id="reference_list_id",
            description="referencelist-description",
            entries=[{
                "value": "referencelist-entry-value",
            }],
            syntax_type="REFERENCE_LIST_SYNTAX_TYPE_PLAIN_TEXT_STRING")
        ```

        ## Import

        ReferenceList can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance}}/referenceLists/{{reference_list_id}}`

        * `{{project}}/{{location}}/{{instance}}/{{reference_list_id}}`

        * `{{location}}/{{instance}}/{{reference_list_id}}`

        When using the `pulumi import` command, ReferenceList can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:chronicle/referenceList:ReferenceList default projects/{{project}}/locations/{{location}}/instances/{{instance}}/referenceLists/{{reference_list_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/referenceList:ReferenceList default {{project}}/{{location}}/{{instance}}/{{reference_list_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/referenceList:ReferenceList default {{location}}/{{instance}}/{{reference_list_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Required. A user-provided description of the reference list.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReferenceListEntryArgs', 'ReferenceListEntryArgsDict']]]] entries: Required. The entries of the reference list.
               When listed, they are returned in the order that was specified at creation
               or update. The combined size of the values of the reference list may not
               exceed 6MB.
               This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
               Structure is documented below.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.str] reference_list_id: Required. The ID to use for the reference list. This is also the display name for
               the reference list. It must satisfy the following requirements:
               - Starts with letter.
               - Contains only letters, numbers and underscore.
               - Has length < 256.
               - Must be unique.
        :param pulumi.Input[builtins.str] syntax_type: Possible values:
               REFERENCE_LIST_SYNTAX_TYPE_PLAIN_TEXT_STRING
               REFERENCE_LIST_SYNTAX_TYPE_REGEX
               REFERENCE_LIST_SYNTAX_TYPE_CIDR
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReferenceListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Reference lists are user-defined lists of values which users can use in multiple Rules.

        To get more information about ReferenceList, see:

        * [API documentation](https://cloud.google.com/chronicle/docs/reference/rest/v1/projects.locations.instances.referenceLists)
        * How-to Guides
            * [Google SecOps Guides](https://cloud.google.com/chronicle/docs/secops/secops-overview)

        ## Example Usage

        ### Chronicle Referencelist Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.ReferenceList("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            reference_list_id="reference_list_id",
            description="referencelist-description",
            entries=[{
                "value": "referencelist-entry-value",
            }],
            syntax_type="REFERENCE_LIST_SYNTAX_TYPE_PLAIN_TEXT_STRING")
        ```

        ## Import

        ReferenceList can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance}}/referenceLists/{{reference_list_id}}`

        * `{{project}}/{{location}}/{{instance}}/{{reference_list_id}}`

        * `{{location}}/{{instance}}/{{reference_list_id}}`

        When using the `pulumi import` command, ReferenceList can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:chronicle/referenceList:ReferenceList default projects/{{project}}/locations/{{location}}/instances/{{instance}}/referenceLists/{{reference_list_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/referenceList:ReferenceList default {{project}}/{{location}}/{{instance}}/{{reference_list_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/referenceList:ReferenceList default {{location}}/{{instance}}/{{reference_list_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ReferenceListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReferenceListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReferenceListEntryArgs', 'ReferenceListEntryArgsDict']]]]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reference_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 syntax_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReferenceListArgs.__new__(ReferenceListArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if entries is None and not opts.urn:
                raise TypeError("Missing required property 'entries'")
            __props__.__dict__["entries"] = entries
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if reference_list_id is None and not opts.urn:
                raise TypeError("Missing required property 'reference_list_id'")
            __props__.__dict__["reference_list_id"] = reference_list_id
            if syntax_type is None and not opts.urn:
                raise TypeError("Missing required property 'syntax_type'")
            __props__.__dict__["syntax_type"] = syntax_type
            __props__.__dict__["display_name"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["revision_create_time"] = None
            __props__.__dict__["rule_associations_count"] = None
            __props__.__dict__["rules"] = None
            __props__.__dict__["scope_infos"] = None
        super(ReferenceList, __self__).__init__(
            'gcp:chronicle/referenceList:ReferenceList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReferenceListEntryArgs', 'ReferenceListEntryArgsDict']]]]] = None,
            instance: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            reference_list_id: Optional[pulumi.Input[builtins.str]] = None,
            revision_create_time: Optional[pulumi.Input[builtins.str]] = None,
            rule_associations_count: Optional[pulumi.Input[builtins.int]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            scope_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReferenceListScopeInfoArgs', 'ReferenceListScopeInfoArgsDict']]]]] = None,
            syntax_type: Optional[pulumi.Input[builtins.str]] = None) -> 'ReferenceList':
        """
        Get an existing ReferenceList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Required. A user-provided description of the reference list.
        :param pulumi.Input[builtins.str] display_name: Output only. The unique display name of the reference list.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReferenceListEntryArgs', 'ReferenceListEntryArgsDict']]]] entries: Required. The entries of the reference list.
               When listed, they are returned in the order that was specified at creation
               or update. The combined size of the values of the reference list may not
               exceed 6MB.
               This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
               Structure is documented below.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.str] name: Output only. The resource name of the reference list.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/referenceLists/{reference_list}
        :param pulumi.Input[builtins.str] reference_list_id: Required. The ID to use for the reference list. This is also the display name for
               the reference list. It must satisfy the following requirements:
               - Starts with letter.
               - Contains only letters, numbers and underscore.
               - Has length < 256.
               - Must be unique.
        :param pulumi.Input[builtins.str] revision_create_time: Output only. The timestamp when the reference list was last updated.
        :param pulumi.Input[builtins.int] rule_associations_count: Output only. The count of self-authored rules using the reference list.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] rules: Output only. The resource names for the associated self-authored Rules that use this
               reference list.
               This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReferenceListScopeInfoArgs', 'ReferenceListScopeInfoArgsDict']]]] scope_infos: ScopeInfo specifies the scope info of the reference list.
               Structure is documented below.
        :param pulumi.Input[builtins.str] syntax_type: Possible values:
               REFERENCE_LIST_SYNTAX_TYPE_PLAIN_TEXT_STRING
               REFERENCE_LIST_SYNTAX_TYPE_REGEX
               REFERENCE_LIST_SYNTAX_TYPE_CIDR
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReferenceListState.__new__(_ReferenceListState)

        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["entries"] = entries
        __props__.__dict__["instance"] = instance
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["reference_list_id"] = reference_list_id
        __props__.__dict__["revision_create_time"] = revision_create_time
        __props__.__dict__["rule_associations_count"] = rule_associations_count
        __props__.__dict__["rules"] = rules
        __props__.__dict__["scope_infos"] = scope_infos
        __props__.__dict__["syntax_type"] = syntax_type
        return ReferenceList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Required. A user-provided description of the reference list.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The unique display name of the reference list.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def entries(self) -> pulumi.Output[Sequence['outputs.ReferenceListEntry']]:
        """
        Required. The entries of the reference list.
        When listed, they are returned in the order that was specified at creation
        or update. The combined size of the values of the reference list may not
        exceed 6MB.
        This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
        Structure is documented below.
        """
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The resource name of the reference list.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/referenceLists/{reference_list}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="referenceListId")
    def reference_list_id(self) -> pulumi.Output[builtins.str]:
        """
        Required. The ID to use for the reference list. This is also the display name for
        the reference list. It must satisfy the following requirements:
        - Starts with letter.
        - Contains only letters, numbers and underscore.
        - Has length < 256.
        - Must be unique.
        """
        return pulumi.get(self, "reference_list_id")

    @property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The timestamp when the reference list was last updated.
        """
        return pulumi.get(self, "revision_create_time")

    @property
    @pulumi.getter(name="ruleAssociationsCount")
    def rule_associations_count(self) -> pulumi.Output[builtins.int]:
        """
        Output only. The count of self-authored rules using the reference list.
        """
        return pulumi.get(self, "rule_associations_count")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Output only. The resource names for the associated self-authored Rules that use this
        reference list.
        This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="scopeInfos")
    def scope_infos(self) -> pulumi.Output[Sequence['outputs.ReferenceListScopeInfo']]:
        """
        ScopeInfo specifies the scope info of the reference list.
        Structure is documented below.
        """
        return pulumi.get(self, "scope_infos")

    @property
    @pulumi.getter(name="syntaxType")
    def syntax_type(self) -> pulumi.Output[builtins.str]:
        """
        Possible values:
        REFERENCE_LIST_SYNTAX_TYPE_PLAIN_TEXT_STRING
        REFERENCE_LIST_SYNTAX_TYPE_REGEX
        REFERENCE_LIST_SYNTAX_TYPE_CIDR
        """
        return pulumi.get(self, "syntax_type")

