# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WatchlistArgs', 'Watchlist']

@pulumi.input_type
class WatchlistArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 entity_population_mechanism: pulumi.Input['WatchlistEntityPopulationMechanismArgs'],
                 instance: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 multiplying_factor: Optional[pulumi.Input[builtins.float]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 watchlist_id: Optional[pulumi.Input[builtins.str]] = None,
                 watchlist_user_preferences: Optional[pulumi.Input['WatchlistWatchlistUserPreferencesArgs']] = None):
        """
        The set of arguments for constructing a Watchlist resource.
        :param pulumi.Input[builtins.str] display_name: Required. Display name of the watchlist.
               Note that it must be at least one character and less than 63 characters
               (https://google.aip.dev/148).
        :param pulumi.Input['WatchlistEntityPopulationMechanismArgs'] entity_population_mechanism: Mechanism to populate entities in the watchlist.
               Structure is documented below.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.str] description: Optional. Description of the watchlist.
        :param pulumi.Input[builtins.float] multiplying_factor: Optional. Weight applied to the risk score for entities in this watchlist. The default is 1.0 if it is not specified.
        :param pulumi.Input[builtins.str] watchlist_id: Optional. The ID to use for the watchlist, which will become the final component of the watchlist's resource name. This
               value should be 4-63 characters, and valid characters are /a-z-/.
        :param pulumi.Input['WatchlistWatchlistUserPreferencesArgs'] watchlist_user_preferences: A collection of user preferences for watchlist UI configuration.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "entity_population_mechanism", entity_population_mechanism)
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "location", location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if multiplying_factor is not None:
            pulumi.set(__self__, "multiplying_factor", multiplying_factor)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if watchlist_id is not None:
            pulumi.set(__self__, "watchlist_id", watchlist_id)
        if watchlist_user_preferences is not None:
            pulumi.set(__self__, "watchlist_user_preferences", watchlist_user_preferences)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        Required. Display name of the watchlist.
        Note that it must be at least one character and less than 63 characters
        (https://google.aip.dev/148).
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="entityPopulationMechanism")
    def entity_population_mechanism(self) -> pulumi.Input['WatchlistEntityPopulationMechanismArgs']:
        """
        Mechanism to populate entities in the watchlist.
        Structure is documented below.
        """
        return pulumi.get(self, "entity_population_mechanism")

    @entity_population_mechanism.setter
    def entity_population_mechanism(self, value: pulumi.Input['WatchlistEntityPopulationMechanismArgs']):
        pulumi.set(self, "entity_population_mechanism", value)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Input[builtins.str]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Description of the watchlist.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="multiplyingFactor")
    def multiplying_factor(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Optional. Weight applied to the risk score for entities in this watchlist. The default is 1.0 if it is not specified.
        """
        return pulumi.get(self, "multiplying_factor")

    @multiplying_factor.setter
    def multiplying_factor(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "multiplying_factor", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="watchlistId")
    def watchlist_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The ID to use for the watchlist, which will become the final component of the watchlist's resource name. This
        value should be 4-63 characters, and valid characters are /a-z-/.
        """
        return pulumi.get(self, "watchlist_id")

    @watchlist_id.setter
    def watchlist_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "watchlist_id", value)

    @property
    @pulumi.getter(name="watchlistUserPreferences")
    def watchlist_user_preferences(self) -> Optional[pulumi.Input['WatchlistWatchlistUserPreferencesArgs']]:
        """
        A collection of user preferences for watchlist UI configuration.
        """
        return pulumi.get(self, "watchlist_user_preferences")

    @watchlist_user_preferences.setter
    def watchlist_user_preferences(self, value: Optional[pulumi.Input['WatchlistWatchlistUserPreferencesArgs']]):
        pulumi.set(self, "watchlist_user_preferences", value)


@pulumi.input_type
class _WatchlistState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 entity_counts: Optional[pulumi.Input[Sequence[pulumi.Input['WatchlistEntityCountArgs']]]] = None,
                 entity_population_mechanism: Optional[pulumi.Input['WatchlistEntityPopulationMechanismArgs']] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 multiplying_factor: Optional[pulumi.Input[builtins.float]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 watchlist_id: Optional[pulumi.Input[builtins.str]] = None,
                 watchlist_user_preferences: Optional[pulumi.Input['WatchlistWatchlistUserPreferencesArgs']] = None):
        """
        Input properties used for looking up and filtering Watchlist resources.
        :param pulumi.Input[builtins.str] create_time: Output only. Time the watchlist was created.
        :param pulumi.Input[builtins.str] description: Optional. Description of the watchlist.
        :param pulumi.Input[builtins.str] display_name: Required. Display name of the watchlist.
               Note that it must be at least one character and less than 63 characters
               (https://google.aip.dev/148).
        :param pulumi.Input[Sequence[pulumi.Input['WatchlistEntityCountArgs']]] entity_counts: Count of different types of entities in the watchlist.
               Structure is documented below.
        :param pulumi.Input['WatchlistEntityPopulationMechanismArgs'] entity_population_mechanism: Mechanism to populate entities in the watchlist.
               Structure is documented below.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.float] multiplying_factor: Optional. Weight applied to the risk score for entities in this watchlist. The default is 1.0 if it is not specified.
        :param pulumi.Input[builtins.str] name: Identifier. Resource name of the watchlist. This unique identifier is generated using values provided for the URL parameters.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/watchlists/{watchlist}
        :param pulumi.Input[builtins.str] update_time: Output only. Time the watchlist was last updated.
        :param pulumi.Input[builtins.str] watchlist_id: Optional. The ID to use for the watchlist, which will become the final component of the watchlist's resource name. This
               value should be 4-63 characters, and valid characters are /a-z-/.
        :param pulumi.Input['WatchlistWatchlistUserPreferencesArgs'] watchlist_user_preferences: A collection of user preferences for watchlist UI configuration.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if entity_counts is not None:
            pulumi.set(__self__, "entity_counts", entity_counts)
        if entity_population_mechanism is not None:
            pulumi.set(__self__, "entity_population_mechanism", entity_population_mechanism)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if multiplying_factor is not None:
            pulumi.set(__self__, "multiplying_factor", multiplying_factor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if watchlist_id is not None:
            pulumi.set(__self__, "watchlist_id", watchlist_id)
        if watchlist_user_preferences is not None:
            pulumi.set(__self__, "watchlist_user_preferences", watchlist_user_preferences)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Time the watchlist was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Description of the watchlist.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. Display name of the watchlist.
        Note that it must be at least one character and less than 63 characters
        (https://google.aip.dev/148).
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="entityCounts")
    def entity_counts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WatchlistEntityCountArgs']]]]:
        """
        Count of different types of entities in the watchlist.
        Structure is documented below.
        """
        return pulumi.get(self, "entity_counts")

    @entity_counts.setter
    def entity_counts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WatchlistEntityCountArgs']]]]):
        pulumi.set(self, "entity_counts", value)

    @property
    @pulumi.getter(name="entityPopulationMechanism")
    def entity_population_mechanism(self) -> Optional[pulumi.Input['WatchlistEntityPopulationMechanismArgs']]:
        """
        Mechanism to populate entities in the watchlist.
        Structure is documented below.
        """
        return pulumi.get(self, "entity_population_mechanism")

    @entity_population_mechanism.setter
    def entity_population_mechanism(self, value: Optional[pulumi.Input['WatchlistEntityPopulationMechanismArgs']]):
        pulumi.set(self, "entity_population_mechanism", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="multiplyingFactor")
    def multiplying_factor(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Optional. Weight applied to the risk score for entities in this watchlist. The default is 1.0 if it is not specified.
        """
        return pulumi.get(self, "multiplying_factor")

    @multiplying_factor.setter
    def multiplying_factor(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "multiplying_factor", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. Resource name of the watchlist. This unique identifier is generated using values provided for the URL parameters.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/watchlists/{watchlist}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Time the watchlist was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="watchlistId")
    def watchlist_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The ID to use for the watchlist, which will become the final component of the watchlist's resource name. This
        value should be 4-63 characters, and valid characters are /a-z-/.
        """
        return pulumi.get(self, "watchlist_id")

    @watchlist_id.setter
    def watchlist_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "watchlist_id", value)

    @property
    @pulumi.getter(name="watchlistUserPreferences")
    def watchlist_user_preferences(self) -> Optional[pulumi.Input['WatchlistWatchlistUserPreferencesArgs']]:
        """
        A collection of user preferences for watchlist UI configuration.
        """
        return pulumi.get(self, "watchlist_user_preferences")

    @watchlist_user_preferences.setter
    def watchlist_user_preferences(self, value: Optional[pulumi.Input['WatchlistWatchlistUserPreferencesArgs']]):
        pulumi.set(self, "watchlist_user_preferences", value)


@pulumi.type_token("gcp:chronicle/watchlist:Watchlist")
class Watchlist(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 entity_population_mechanism: Optional[pulumi.Input[Union['WatchlistEntityPopulationMechanismArgs', 'WatchlistEntityPopulationMechanismArgsDict']]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 multiplying_factor: Optional[pulumi.Input[builtins.float]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 watchlist_id: Optional[pulumi.Input[builtins.str]] = None,
                 watchlist_user_preferences: Optional[pulumi.Input[Union['WatchlistWatchlistUserPreferencesArgs', 'WatchlistWatchlistUserPreferencesArgsDict']]] = None,
                 __props__=None):
        """
        A watchlist is a list of entities that allows for bulk operations over the included entities.

        To get more information about Watchlist, see:

        * [API documentation](https://cloud.google.com/chronicle/docs/reference/rest/v1/projects.locations.instances.watchlists)
        * How-to Guides
            * [Google SecOps Guides](https://cloud.google.com/chronicle/docs/secops/secops-overview)

        ## Example Usage

        ### Chronicle Watchlist Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.Watchlist("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            watchlist_id="watchlist-id",
            description="watchlist-description",
            display_name="watchlist_name",
            multiplying_factor=1,
            entity_population_mechanism={
                "manual": {},
            },
            watchlist_user_preferences={
                "pinned": True,
            })
        ```
        ### Chronicle Watchlist Without Id

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.Watchlist("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            description="watchlist-description",
            display_name="watchlist-name",
            multiplying_factor=1,
            entity_population_mechanism={
                "manual": {},
            },
            watchlist_user_preferences={
                "pinned": True,
            })
        ```

        ## Import

        Watchlist can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance}}/watchlists/{{watchlist_id}}`

        * `{{project}}/{{location}}/{{instance}}/{{watchlist_id}}`

        * `{{location}}/{{instance}}/{{watchlist_id}}`

        When using the `pulumi import` command, Watchlist can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:chronicle/watchlist:Watchlist default projects/{{project}}/locations/{{location}}/instances/{{instance}}/watchlists/{{watchlist_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/watchlist:Watchlist default {{project}}/{{location}}/{{instance}}/{{watchlist_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/watchlist:Watchlist default {{location}}/{{instance}}/{{watchlist_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Optional. Description of the watchlist.
        :param pulumi.Input[builtins.str] display_name: Required. Display name of the watchlist.
               Note that it must be at least one character and less than 63 characters
               (https://google.aip.dev/148).
        :param pulumi.Input[Union['WatchlistEntityPopulationMechanismArgs', 'WatchlistEntityPopulationMechanismArgsDict']] entity_population_mechanism: Mechanism to populate entities in the watchlist.
               Structure is documented below.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.float] multiplying_factor: Optional. Weight applied to the risk score for entities in this watchlist. The default is 1.0 if it is not specified.
        :param pulumi.Input[builtins.str] watchlist_id: Optional. The ID to use for the watchlist, which will become the final component of the watchlist's resource name. This
               value should be 4-63 characters, and valid characters are /a-z-/.
        :param pulumi.Input[Union['WatchlistWatchlistUserPreferencesArgs', 'WatchlistWatchlistUserPreferencesArgsDict']] watchlist_user_preferences: A collection of user preferences for watchlist UI configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WatchlistArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A watchlist is a list of entities that allows for bulk operations over the included entities.

        To get more information about Watchlist, see:

        * [API documentation](https://cloud.google.com/chronicle/docs/reference/rest/v1/projects.locations.instances.watchlists)
        * How-to Guides
            * [Google SecOps Guides](https://cloud.google.com/chronicle/docs/secops/secops-overview)

        ## Example Usage

        ### Chronicle Watchlist Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.Watchlist("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            watchlist_id="watchlist-id",
            description="watchlist-description",
            display_name="watchlist_name",
            multiplying_factor=1,
            entity_population_mechanism={
                "manual": {},
            },
            watchlist_user_preferences={
                "pinned": True,
            })
        ```
        ### Chronicle Watchlist Without Id

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.Watchlist("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            description="watchlist-description",
            display_name="watchlist-name",
            multiplying_factor=1,
            entity_population_mechanism={
                "manual": {},
            },
            watchlist_user_preferences={
                "pinned": True,
            })
        ```

        ## Import

        Watchlist can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance}}/watchlists/{{watchlist_id}}`

        * `{{project}}/{{location}}/{{instance}}/{{watchlist_id}}`

        * `{{location}}/{{instance}}/{{watchlist_id}}`

        When using the `pulumi import` command, Watchlist can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:chronicle/watchlist:Watchlist default projects/{{project}}/locations/{{location}}/instances/{{instance}}/watchlists/{{watchlist_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/watchlist:Watchlist default {{project}}/{{location}}/{{instance}}/{{watchlist_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/watchlist:Watchlist default {{location}}/{{instance}}/{{watchlist_id}}
        ```

        :param str resource_name: The name of the resource.
        :param WatchlistArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WatchlistArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 entity_population_mechanism: Optional[pulumi.Input[Union['WatchlistEntityPopulationMechanismArgs', 'WatchlistEntityPopulationMechanismArgsDict']]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 multiplying_factor: Optional[pulumi.Input[builtins.float]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 watchlist_id: Optional[pulumi.Input[builtins.str]] = None,
                 watchlist_user_preferences: Optional[pulumi.Input[Union['WatchlistWatchlistUserPreferencesArgs', 'WatchlistWatchlistUserPreferencesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WatchlistArgs.__new__(WatchlistArgs)

            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if entity_population_mechanism is None and not opts.urn:
                raise TypeError("Missing required property 'entity_population_mechanism'")
            __props__.__dict__["entity_population_mechanism"] = entity_population_mechanism
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["multiplying_factor"] = multiplying_factor
            __props__.__dict__["project"] = project
            __props__.__dict__["watchlist_id"] = watchlist_id
            __props__.__dict__["watchlist_user_preferences"] = watchlist_user_preferences
            __props__.__dict__["create_time"] = None
            __props__.__dict__["entity_counts"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(Watchlist, __self__).__init__(
            'gcp:chronicle/watchlist:Watchlist',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            entity_counts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WatchlistEntityCountArgs', 'WatchlistEntityCountArgsDict']]]]] = None,
            entity_population_mechanism: Optional[pulumi.Input[Union['WatchlistEntityPopulationMechanismArgs', 'WatchlistEntityPopulationMechanismArgsDict']]] = None,
            instance: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            multiplying_factor: Optional[pulumi.Input[builtins.float]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            watchlist_id: Optional[pulumi.Input[builtins.str]] = None,
            watchlist_user_preferences: Optional[pulumi.Input[Union['WatchlistWatchlistUserPreferencesArgs', 'WatchlistWatchlistUserPreferencesArgsDict']]] = None) -> 'Watchlist':
        """
        Get an existing Watchlist resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Output only. Time the watchlist was created.
        :param pulumi.Input[builtins.str] description: Optional. Description of the watchlist.
        :param pulumi.Input[builtins.str] display_name: Required. Display name of the watchlist.
               Note that it must be at least one character and less than 63 characters
               (https://google.aip.dev/148).
        :param pulumi.Input[Sequence[pulumi.Input[Union['WatchlistEntityCountArgs', 'WatchlistEntityCountArgsDict']]]] entity_counts: Count of different types of entities in the watchlist.
               Structure is documented below.
        :param pulumi.Input[Union['WatchlistEntityPopulationMechanismArgs', 'WatchlistEntityPopulationMechanismArgsDict']] entity_population_mechanism: Mechanism to populate entities in the watchlist.
               Structure is documented below.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.float] multiplying_factor: Optional. Weight applied to the risk score for entities in this watchlist. The default is 1.0 if it is not specified.
        :param pulumi.Input[builtins.str] name: Identifier. Resource name of the watchlist. This unique identifier is generated using values provided for the URL parameters.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/watchlists/{watchlist}
        :param pulumi.Input[builtins.str] update_time: Output only. Time the watchlist was last updated.
        :param pulumi.Input[builtins.str] watchlist_id: Optional. The ID to use for the watchlist, which will become the final component of the watchlist's resource name. This
               value should be 4-63 characters, and valid characters are /a-z-/.
        :param pulumi.Input[Union['WatchlistWatchlistUserPreferencesArgs', 'WatchlistWatchlistUserPreferencesArgsDict']] watchlist_user_preferences: A collection of user preferences for watchlist UI configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WatchlistState.__new__(_WatchlistState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["entity_counts"] = entity_counts
        __props__.__dict__["entity_population_mechanism"] = entity_population_mechanism
        __props__.__dict__["instance"] = instance
        __props__.__dict__["location"] = location
        __props__.__dict__["multiplying_factor"] = multiplying_factor
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["watchlist_id"] = watchlist_id
        __props__.__dict__["watchlist_user_preferences"] = watchlist_user_preferences
        return Watchlist(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Time the watchlist was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. Description of the watchlist.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Required. Display name of the watchlist.
        Note that it must be at least one character and less than 63 characters
        (https://google.aip.dev/148).
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="entityCounts")
    def entity_counts(self) -> pulumi.Output[Sequence['outputs.WatchlistEntityCount']]:
        """
        Count of different types of entities in the watchlist.
        Structure is documented below.
        """
        return pulumi.get(self, "entity_counts")

    @property
    @pulumi.getter(name="entityPopulationMechanism")
    def entity_population_mechanism(self) -> pulumi.Output['outputs.WatchlistEntityPopulationMechanism']:
        """
        Mechanism to populate entities in the watchlist.
        Structure is documented below.
        """
        return pulumi.get(self, "entity_population_mechanism")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="multiplyingFactor")
    def multiplying_factor(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        Optional. Weight applied to the risk score for entities in this watchlist. The default is 1.0 if it is not specified.
        """
        return pulumi.get(self, "multiplying_factor")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. Resource name of the watchlist. This unique identifier is generated using values provided for the URL parameters.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/watchlists/{watchlist}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Time the watchlist was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="watchlistId")
    def watchlist_id(self) -> pulumi.Output[builtins.str]:
        """
        Optional. The ID to use for the watchlist, which will become the final component of the watchlist's resource name. This
        value should be 4-63 characters, and valid characters are /a-z-/.
        """
        return pulumi.get(self, "watchlist_id")

    @property
    @pulumi.getter(name="watchlistUserPreferences")
    def watchlist_user_preferences(self) -> pulumi.Output['outputs.WatchlistWatchlistUserPreferences']:
        """
        A collection of user preferences for watchlist UI configuration.
        """
        return pulumi.get(self, "watchlist_user_preferences")

