# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BitbucketServerConfigArgs', 'BitbucketServerConfig']

@pulumi.input_type
class BitbucketServerConfigArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[builtins.str],
                 config_id: pulumi.Input[builtins.str],
                 host_uri: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 secrets: pulumi.Input['BitbucketServerConfigSecretsArgs'],
                 username: pulumi.Input[builtins.str],
                 connected_repositories: Optional[pulumi.Input[Sequence[pulumi.Input['BitbucketServerConfigConnectedRepositoryArgs']]]] = None,
                 peered_network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_ca: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a BitbucketServerConfig resource.
        :param pulumi.Input[builtins.str] api_key: Immutable. API Key that will be attached to webhook. Once this field has been set, it cannot be changed.
               Changing this field will result in deleting/ recreating the resource.
        :param pulumi.Input[builtins.str] config_id: The ID to use for the BitbucketServerConfig, which will become the final component of the BitbucketServerConfig's resource name.
        :param pulumi.Input[builtins.str] host_uri: Immutable. The URI of the Bitbucket Server host. Once this field has been set, it cannot be changed.
               If you need to change it, please create another BitbucketServerConfig.
        :param pulumi.Input[builtins.str] location: The location of this bitbucket server config.
        :param pulumi.Input['BitbucketServerConfigSecretsArgs'] secrets: Secret Manager secrets needed by the config.
               Structure is documented below.
        :param pulumi.Input[builtins.str] username: Username of the account Cloud Build will use on Bitbucket Server.
        :param pulumi.Input[Sequence[pulumi.Input['BitbucketServerConfigConnectedRepositoryArgs']]] connected_repositories: Connected Bitbucket Server repositories for this config.
        :param pulumi.Input[builtins.str] peered_network: The network to be used when reaching out to the Bitbucket Server instance. The VPC network must be enabled for private
               service connection. This should be set if the Bitbucket Server instance is hosted on-premises and not reachable by
               public internet. If this field is left empty, no network peering will occur and calls to the Bitbucket Server instance
               will be made over the public internet. Must be in the format projects/{project}/global/networks/{network}, where
               {project} is a project number or id and {network} is the name of a VPC network in the project.
        :param pulumi.Input[builtins.str] ssl_ca: SSL certificate to use for requests to Bitbucket Server. The format should be PEM format but the extension can be one of
               .pem, .cer, or .crt.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "host_uri", host_uri)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "secrets", secrets)
        pulumi.set(__self__, "username", username)
        if connected_repositories is not None:
            pulumi.set(__self__, "connected_repositories", connected_repositories)
        if peered_network is not None:
            pulumi.set(__self__, "peered_network", peered_network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if ssl_ca is not None:
            pulumi.set(__self__, "ssl_ca", ssl_ca)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[builtins.str]:
        """
        Immutable. API Key that will be attached to webhook. Once this field has been set, it cannot be changed.
        Changing this field will result in deleting/ recreating the resource.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID to use for the BitbucketServerConfig, which will become the final component of the BitbucketServerConfig's resource name.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> pulumi.Input[builtins.str]:
        """
        Immutable. The URI of the Bitbucket Server host. Once this field has been set, it cannot be changed.
        If you need to change it, please create another BitbucketServerConfig.
        """
        return pulumi.get(self, "host_uri")

    @host_uri.setter
    def host_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host_uri", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of this bitbucket server config.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Input['BitbucketServerConfigSecretsArgs']:
        """
        Secret Manager secrets needed by the config.
        Structure is documented below.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: pulumi.Input['BitbucketServerConfigSecretsArgs']):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        Username of the account Cloud Build will use on Bitbucket Server.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="connectedRepositories")
    def connected_repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BitbucketServerConfigConnectedRepositoryArgs']]]]:
        """
        Connected Bitbucket Server repositories for this config.
        """
        return pulumi.get(self, "connected_repositories")

    @connected_repositories.setter
    def connected_repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BitbucketServerConfigConnectedRepositoryArgs']]]]):
        pulumi.set(self, "connected_repositories", value)

    @property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network to be used when reaching out to the Bitbucket Server instance. The VPC network must be enabled for private
        service connection. This should be set if the Bitbucket Server instance is hosted on-premises and not reachable by
        public internet. If this field is left empty, no network peering will occur and calls to the Bitbucket Server instance
        will be made over the public internet. Must be in the format projects/{project}/global/networks/{network}, where
        {project} is a project number or id and {network} is the name of a VPC network in the project.
        """
        return pulumi.get(self, "peered_network")

    @peered_network.setter
    def peered_network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peered_network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SSL certificate to use for requests to Bitbucket Server. The format should be PEM format but the extension can be one of
        .pem, .cer, or .crt.
        """
        return pulumi.get(self, "ssl_ca")

    @ssl_ca.setter
    def ssl_ca(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_ca", value)


@pulumi.input_type
class _BitbucketServerConfigState:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[builtins.str]] = None,
                 config_id: Optional[pulumi.Input[builtins.str]] = None,
                 connected_repositories: Optional[pulumi.Input[Sequence[pulumi.Input['BitbucketServerConfigConnectedRepositoryArgs']]]] = None,
                 host_uri: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peered_network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 secrets: Optional[pulumi.Input['BitbucketServerConfigSecretsArgs']] = None,
                 ssl_ca: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 webhook_key: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BitbucketServerConfig resources.
        :param pulumi.Input[builtins.str] api_key: Immutable. API Key that will be attached to webhook. Once this field has been set, it cannot be changed.
               Changing this field will result in deleting/ recreating the resource.
        :param pulumi.Input[builtins.str] config_id: The ID to use for the BitbucketServerConfig, which will become the final component of the BitbucketServerConfig's resource name.
        :param pulumi.Input[Sequence[pulumi.Input['BitbucketServerConfigConnectedRepositoryArgs']]] connected_repositories: Connected Bitbucket Server repositories for this config.
        :param pulumi.Input[builtins.str] host_uri: Immutable. The URI of the Bitbucket Server host. Once this field has been set, it cannot be changed.
               If you need to change it, please create another BitbucketServerConfig.
        :param pulumi.Input[builtins.str] location: The location of this bitbucket server config.
        :param pulumi.Input[builtins.str] name: The resource name for the config.
        :param pulumi.Input[builtins.str] peered_network: The network to be used when reaching out to the Bitbucket Server instance. The VPC network must be enabled for private
               service connection. This should be set if the Bitbucket Server instance is hosted on-premises and not reachable by
               public internet. If this field is left empty, no network peering will occur and calls to the Bitbucket Server instance
               will be made over the public internet. Must be in the format projects/{project}/global/networks/{network}, where
               {project} is a project number or id and {network} is the name of a VPC network in the project.
        :param pulumi.Input['BitbucketServerConfigSecretsArgs'] secrets: Secret Manager secrets needed by the config.
               Structure is documented below.
        :param pulumi.Input[builtins.str] ssl_ca: SSL certificate to use for requests to Bitbucket Server. The format should be PEM format but the extension can be one of
               .pem, .cer, or .crt.
        :param pulumi.Input[builtins.str] username: Username of the account Cloud Build will use on Bitbucket Server.
        :param pulumi.Input[builtins.str] webhook_key: Output only. UUID included in webhook requests. The UUID is used to look up the corresponding config.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if connected_repositories is not None:
            pulumi.set(__self__, "connected_repositories", connected_repositories)
        if host_uri is not None:
            pulumi.set(__self__, "host_uri", host_uri)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peered_network is not None:
            pulumi.set(__self__, "peered_network", peered_network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if ssl_ca is not None:
            pulumi.set(__self__, "ssl_ca", ssl_ca)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if webhook_key is not None:
            pulumi.set(__self__, "webhook_key", webhook_key)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. API Key that will be attached to webhook. Once this field has been set, it cannot be changed.
        Changing this field will result in deleting/ recreating the resource.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the BitbucketServerConfig, which will become the final component of the BitbucketServerConfig's resource name.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter(name="connectedRepositories")
    def connected_repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BitbucketServerConfigConnectedRepositoryArgs']]]]:
        """
        Connected Bitbucket Server repositories for this config.
        """
        return pulumi.get(self, "connected_repositories")

    @connected_repositories.setter
    def connected_repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BitbucketServerConfigConnectedRepositoryArgs']]]]):
        pulumi.set(self, "connected_repositories", value)

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. The URI of the Bitbucket Server host. Once this field has been set, it cannot be changed.
        If you need to change it, please create another BitbucketServerConfig.
        """
        return pulumi.get(self, "host_uri")

    @host_uri.setter
    def host_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_uri", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of this bitbucket server config.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name for the config.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network to be used when reaching out to the Bitbucket Server instance. The VPC network must be enabled for private
        service connection. This should be set if the Bitbucket Server instance is hosted on-premises and not reachable by
        public internet. If this field is left empty, no network peering will occur and calls to the Bitbucket Server instance
        will be made over the public internet. Must be in the format projects/{project}/global/networks/{network}, where
        {project} is a project number or id and {network} is the name of a VPC network in the project.
        """
        return pulumi.get(self, "peered_network")

    @peered_network.setter
    def peered_network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peered_network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input['BitbucketServerConfigSecretsArgs']]:
        """
        Secret Manager secrets needed by the config.
        Structure is documented below.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input['BitbucketServerConfigSecretsArgs']]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SSL certificate to use for requests to Bitbucket Server. The format should be PEM format but the extension can be one of
        .pem, .cer, or .crt.
        """
        return pulumi.get(self, "ssl_ca")

    @ssl_ca.setter
    def ssl_ca(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_ca", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username of the account Cloud Build will use on Bitbucket Server.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="webhookKey")
    def webhook_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. UUID included in webhook requests. The UUID is used to look up the corresponding config.
        """
        return pulumi.get(self, "webhook_key")

    @webhook_key.setter
    def webhook_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "webhook_key", value)


@pulumi.type_token("gcp:cloudbuild/bitbucketServerConfig:BitbucketServerConfig")
class BitbucketServerConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[builtins.str]] = None,
                 config_id: Optional[pulumi.Input[builtins.str]] = None,
                 connected_repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BitbucketServerConfigConnectedRepositoryArgs', 'BitbucketServerConfigConnectedRepositoryArgsDict']]]]] = None,
                 host_uri: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 peered_network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Union['BitbucketServerConfigSecretsArgs', 'BitbucketServerConfigSecretsArgsDict']]] = None,
                 ssl_ca: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        BitbucketServerConfig represents the configuration for a Bitbucket Server.

        To get more information about BitbucketServerConfig, see:

        * [API documentation](https://cloud.google.com/build/docs/api/reference/rest/v1/projects.locations.bitbucketServerConfigs)
        * How-to Guides
            * [Connect to a Bitbucket Server host](https://cloud.google.com/build/docs/automating-builds/bitbucket/connect-host-bitbucket-server)

        ## Example Usage

        ### Cloudbuild Bitbucket Server Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bbs_config = gcp.cloudbuild.BitbucketServerConfig("bbs-config",
            config_id="bbs-config",
            location="us-central1",
            host_uri="https://bbs.com",
            secrets={
                "admin_access_token_version_name": "projects/myProject/secrets/mybbspat/versions/1",
                "read_access_token_version_name": "projects/myProject/secrets/mybbspat/versions/1",
                "webhook_secret_version_name": "projects/myProject/secrets/mybbspat/versions/1",
            },
            username="test",
            api_key="<api-key>")
        ```
        ### Cloudbuild Bitbucket Server Config Repositories

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bbs_config_with_repos = gcp.cloudbuild.BitbucketServerConfig("bbs-config-with-repos",
            config_id="bbs-config",
            location="us-central1",
            host_uri="https://bbs.com",
            secrets={
                "admin_access_token_version_name": "projects/myProject/secrets/mybbspat/versions/1",
                "read_access_token_version_name": "projects/myProject/secrets/mybbspat/versions/1",
                "webhook_secret_version_name": "projects/myProject/secrets/mybbspat/versions/1",
            },
            username="test",
            api_key="<api-key>",
            connected_repositories=[
                {
                    "project_key": "DEV",
                    "repo_slug": "repo1",
                },
                {
                    "project_key": "PROD",
                    "repo_slug": "repo1",
                },
            ])
        ```
        ### Cloudbuild Bitbucket Server Config Peered Network

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        project = gcp.organizations.get_project()
        servicenetworking = gcp.projects.Service("servicenetworking",
            service="servicenetworking.googleapis.com",
            disable_on_destroy=False)
        vpc_network = gcp.compute.Network("vpc_network", name="vpc-network",
        opts = pulumi.ResourceOptions(depends_on=[servicenetworking]))
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="private-ip-alloc",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=vpc_network.id)
        default = gcp.servicenetworking.Connection("default",
            network=vpc_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name],
            opts = pulumi.ResourceOptions(depends_on=[servicenetworking]))
        bbs_config_with_peered_network = gcp.cloudbuild.BitbucketServerConfig("bbs-config-with-peered-network",
            config_id="bbs-config",
            location="us-central1",
            host_uri="https://bbs.com",
            secrets={
                "admin_access_token_version_name": "projects/myProject/secrets/mybbspat/versions/1",
                "read_access_token_version_name": "projects/myProject/secrets/mybbspat/versions/1",
                "webhook_secret_version_name": "projects/myProject/secrets/mybbspat/versions/1",
            },
            username="test",
            api_key="<api-key>",
            peered_network=vpc_network.id.apply(lambda id: std.replace(text=id,
                search=project.name,
                replace=project.number)).apply(lambda invoke: invoke.result),
            ssl_ca=\"\"\"-----BEGIN CERTIFICATE-----
        -----END CERTIFICATE-----
        -----BEGIN CERTIFICATE-----
        -----END CERTIFICATE-----
        \"\"\",
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```

        ## Import

        BitbucketServerConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/bitbucketServerConfigs/{{config_id}}`

        * `{{project}}/{{location}}/{{config_id}}`

        * `{{location}}/{{config_id}}`

        When using the `pulumi import` command, BitbucketServerConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudbuild/bitbucketServerConfig:BitbucketServerConfig default projects/{{project}}/locations/{{location}}/bitbucketServerConfigs/{{config_id}}
        ```

        ```sh
        $ pulumi import gcp:cloudbuild/bitbucketServerConfig:BitbucketServerConfig default {{project}}/{{location}}/{{config_id}}
        ```

        ```sh
        $ pulumi import gcp:cloudbuild/bitbucketServerConfig:BitbucketServerConfig default {{location}}/{{config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_key: Immutable. API Key that will be attached to webhook. Once this field has been set, it cannot be changed.
               Changing this field will result in deleting/ recreating the resource.
        :param pulumi.Input[builtins.str] config_id: The ID to use for the BitbucketServerConfig, which will become the final component of the BitbucketServerConfig's resource name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BitbucketServerConfigConnectedRepositoryArgs', 'BitbucketServerConfigConnectedRepositoryArgsDict']]]] connected_repositories: Connected Bitbucket Server repositories for this config.
        :param pulumi.Input[builtins.str] host_uri: Immutable. The URI of the Bitbucket Server host. Once this field has been set, it cannot be changed.
               If you need to change it, please create another BitbucketServerConfig.
        :param pulumi.Input[builtins.str] location: The location of this bitbucket server config.
        :param pulumi.Input[builtins.str] peered_network: The network to be used when reaching out to the Bitbucket Server instance. The VPC network must be enabled for private
               service connection. This should be set if the Bitbucket Server instance is hosted on-premises and not reachable by
               public internet. If this field is left empty, no network peering will occur and calls to the Bitbucket Server instance
               will be made over the public internet. Must be in the format projects/{project}/global/networks/{network}, where
               {project} is a project number or id and {network} is the name of a VPC network in the project.
        :param pulumi.Input[Union['BitbucketServerConfigSecretsArgs', 'BitbucketServerConfigSecretsArgsDict']] secrets: Secret Manager secrets needed by the config.
               Structure is documented below.
        :param pulumi.Input[builtins.str] ssl_ca: SSL certificate to use for requests to Bitbucket Server. The format should be PEM format but the extension can be one of
               .pem, .cer, or .crt.
        :param pulumi.Input[builtins.str] username: Username of the account Cloud Build will use on Bitbucket Server.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BitbucketServerConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        BitbucketServerConfig represents the configuration for a Bitbucket Server.

        To get more information about BitbucketServerConfig, see:

        * [API documentation](https://cloud.google.com/build/docs/api/reference/rest/v1/projects.locations.bitbucketServerConfigs)
        * How-to Guides
            * [Connect to a Bitbucket Server host](https://cloud.google.com/build/docs/automating-builds/bitbucket/connect-host-bitbucket-server)

        ## Example Usage

        ### Cloudbuild Bitbucket Server Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bbs_config = gcp.cloudbuild.BitbucketServerConfig("bbs-config",
            config_id="bbs-config",
            location="us-central1",
            host_uri="https://bbs.com",
            secrets={
                "admin_access_token_version_name": "projects/myProject/secrets/mybbspat/versions/1",
                "read_access_token_version_name": "projects/myProject/secrets/mybbspat/versions/1",
                "webhook_secret_version_name": "projects/myProject/secrets/mybbspat/versions/1",
            },
            username="test",
            api_key="<api-key>")
        ```
        ### Cloudbuild Bitbucket Server Config Repositories

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bbs_config_with_repos = gcp.cloudbuild.BitbucketServerConfig("bbs-config-with-repos",
            config_id="bbs-config",
            location="us-central1",
            host_uri="https://bbs.com",
            secrets={
                "admin_access_token_version_name": "projects/myProject/secrets/mybbspat/versions/1",
                "read_access_token_version_name": "projects/myProject/secrets/mybbspat/versions/1",
                "webhook_secret_version_name": "projects/myProject/secrets/mybbspat/versions/1",
            },
            username="test",
            api_key="<api-key>",
            connected_repositories=[
                {
                    "project_key": "DEV",
                    "repo_slug": "repo1",
                },
                {
                    "project_key": "PROD",
                    "repo_slug": "repo1",
                },
            ])
        ```
        ### Cloudbuild Bitbucket Server Config Peered Network

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        project = gcp.organizations.get_project()
        servicenetworking = gcp.projects.Service("servicenetworking",
            service="servicenetworking.googleapis.com",
            disable_on_destroy=False)
        vpc_network = gcp.compute.Network("vpc_network", name="vpc-network",
        opts = pulumi.ResourceOptions(depends_on=[servicenetworking]))
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="private-ip-alloc",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=vpc_network.id)
        default = gcp.servicenetworking.Connection("default",
            network=vpc_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name],
            opts = pulumi.ResourceOptions(depends_on=[servicenetworking]))
        bbs_config_with_peered_network = gcp.cloudbuild.BitbucketServerConfig("bbs-config-with-peered-network",
            config_id="bbs-config",
            location="us-central1",
            host_uri="https://bbs.com",
            secrets={
                "admin_access_token_version_name": "projects/myProject/secrets/mybbspat/versions/1",
                "read_access_token_version_name": "projects/myProject/secrets/mybbspat/versions/1",
                "webhook_secret_version_name": "projects/myProject/secrets/mybbspat/versions/1",
            },
            username="test",
            api_key="<api-key>",
            peered_network=vpc_network.id.apply(lambda id: std.replace(text=id,
                search=project.name,
                replace=project.number)).apply(lambda invoke: invoke.result),
            ssl_ca=\"\"\"-----BEGIN CERTIFICATE-----
        -----END CERTIFICATE-----
        -----BEGIN CERTIFICATE-----
        -----END CERTIFICATE-----
        \"\"\",
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```

        ## Import

        BitbucketServerConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/bitbucketServerConfigs/{{config_id}}`

        * `{{project}}/{{location}}/{{config_id}}`

        * `{{location}}/{{config_id}}`

        When using the `pulumi import` command, BitbucketServerConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudbuild/bitbucketServerConfig:BitbucketServerConfig default projects/{{project}}/locations/{{location}}/bitbucketServerConfigs/{{config_id}}
        ```

        ```sh
        $ pulumi import gcp:cloudbuild/bitbucketServerConfig:BitbucketServerConfig default {{project}}/{{location}}/{{config_id}}
        ```

        ```sh
        $ pulumi import gcp:cloudbuild/bitbucketServerConfig:BitbucketServerConfig default {{location}}/{{config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param BitbucketServerConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BitbucketServerConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[builtins.str]] = None,
                 config_id: Optional[pulumi.Input[builtins.str]] = None,
                 connected_repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BitbucketServerConfigConnectedRepositoryArgs', 'BitbucketServerConfigConnectedRepositoryArgsDict']]]]] = None,
                 host_uri: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 peered_network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Union['BitbucketServerConfigSecretsArgs', 'BitbucketServerConfigSecretsArgsDict']]] = None,
                 ssl_ca: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BitbucketServerConfigArgs.__new__(BitbucketServerConfigArgs)

            if api_key is None and not opts.urn:
                raise TypeError("Missing required property 'api_key'")
            __props__.__dict__["api_key"] = api_key
            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            __props__.__dict__["connected_repositories"] = connected_repositories
            if host_uri is None and not opts.urn:
                raise TypeError("Missing required property 'host_uri'")
            __props__.__dict__["host_uri"] = host_uri
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["peered_network"] = peered_network
            __props__.__dict__["project"] = project
            if secrets is None and not opts.urn:
                raise TypeError("Missing required property 'secrets'")
            __props__.__dict__["secrets"] = secrets
            __props__.__dict__["ssl_ca"] = ssl_ca
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["name"] = None
            __props__.__dict__["webhook_key"] = None
        super(BitbucketServerConfig, __self__).__init__(
            'gcp:cloudbuild/bitbucketServerConfig:BitbucketServerConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key: Optional[pulumi.Input[builtins.str]] = None,
            config_id: Optional[pulumi.Input[builtins.str]] = None,
            connected_repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BitbucketServerConfigConnectedRepositoryArgs', 'BitbucketServerConfigConnectedRepositoryArgsDict']]]]] = None,
            host_uri: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            peered_network: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            secrets: Optional[pulumi.Input[Union['BitbucketServerConfigSecretsArgs', 'BitbucketServerConfigSecretsArgsDict']]] = None,
            ssl_ca: Optional[pulumi.Input[builtins.str]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None,
            webhook_key: Optional[pulumi.Input[builtins.str]] = None) -> 'BitbucketServerConfig':
        """
        Get an existing BitbucketServerConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_key: Immutable. API Key that will be attached to webhook. Once this field has been set, it cannot be changed.
               Changing this field will result in deleting/ recreating the resource.
        :param pulumi.Input[builtins.str] config_id: The ID to use for the BitbucketServerConfig, which will become the final component of the BitbucketServerConfig's resource name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BitbucketServerConfigConnectedRepositoryArgs', 'BitbucketServerConfigConnectedRepositoryArgsDict']]]] connected_repositories: Connected Bitbucket Server repositories for this config.
        :param pulumi.Input[builtins.str] host_uri: Immutable. The URI of the Bitbucket Server host. Once this field has been set, it cannot be changed.
               If you need to change it, please create another BitbucketServerConfig.
        :param pulumi.Input[builtins.str] location: The location of this bitbucket server config.
        :param pulumi.Input[builtins.str] name: The resource name for the config.
        :param pulumi.Input[builtins.str] peered_network: The network to be used when reaching out to the Bitbucket Server instance. The VPC network must be enabled for private
               service connection. This should be set if the Bitbucket Server instance is hosted on-premises and not reachable by
               public internet. If this field is left empty, no network peering will occur and calls to the Bitbucket Server instance
               will be made over the public internet. Must be in the format projects/{project}/global/networks/{network}, where
               {project} is a project number or id and {network} is the name of a VPC network in the project.
        :param pulumi.Input[Union['BitbucketServerConfigSecretsArgs', 'BitbucketServerConfigSecretsArgsDict']] secrets: Secret Manager secrets needed by the config.
               Structure is documented below.
        :param pulumi.Input[builtins.str] ssl_ca: SSL certificate to use for requests to Bitbucket Server. The format should be PEM format but the extension can be one of
               .pem, .cer, or .crt.
        :param pulumi.Input[builtins.str] username: Username of the account Cloud Build will use on Bitbucket Server.
        :param pulumi.Input[builtins.str] webhook_key: Output only. UUID included in webhook requests. The UUID is used to look up the corresponding config.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BitbucketServerConfigState.__new__(_BitbucketServerConfigState)

        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["connected_repositories"] = connected_repositories
        __props__.__dict__["host_uri"] = host_uri
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["peered_network"] = peered_network
        __props__.__dict__["project"] = project
        __props__.__dict__["secrets"] = secrets
        __props__.__dict__["ssl_ca"] = ssl_ca
        __props__.__dict__["username"] = username
        __props__.__dict__["webhook_key"] = webhook_key
        return BitbucketServerConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[builtins.str]:
        """
        Immutable. API Key that will be attached to webhook. Once this field has been set, it cannot be changed.
        Changing this field will result in deleting/ recreating the resource.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID to use for the BitbucketServerConfig, which will become the final component of the BitbucketServerConfig's resource name.
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter(name="connectedRepositories")
    def connected_repositories(self) -> pulumi.Output[Optional[Sequence['outputs.BitbucketServerConfigConnectedRepository']]]:
        """
        Connected Bitbucket Server repositories for this config.
        """
        return pulumi.get(self, "connected_repositories")

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> pulumi.Output[builtins.str]:
        """
        Immutable. The URI of the Bitbucket Server host. Once this field has been set, it cannot be changed.
        If you need to change it, please create another BitbucketServerConfig.
        """
        return pulumi.get(self, "host_uri")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of this bitbucket server config.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name for the config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The network to be used when reaching out to the Bitbucket Server instance. The VPC network must be enabled for private
        service connection. This should be set if the Bitbucket Server instance is hosted on-premises and not reachable by
        public internet. If this field is left empty, no network peering will occur and calls to the Bitbucket Server instance
        will be made over the public internet. Must be in the format projects/{project}/global/networks/{network}, where
        {project} is a project number or id and {network} is the name of a VPC network in the project.
        """
        return pulumi.get(self, "peered_network")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Output['outputs.BitbucketServerConfigSecrets']:
        """
        Secret Manager secrets needed by the config.
        Structure is documented below.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        SSL certificate to use for requests to Bitbucket Server. The format should be PEM format but the extension can be one of
        .pem, .cer, or .crt.
        """
        return pulumi.get(self, "ssl_ca")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[builtins.str]:
        """
        Username of the account Cloud Build will use on Bitbucket Server.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="webhookKey")
    def webhook_key(self) -> pulumi.Output[builtins.str]:
        """
        Output only. UUID included in webhook requests. The UUID is used to look up the corresponding config.
        """
        return pulumi.get(self, "webhook_key")

