# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 template: pulumi.Input['ServiceTemplateArgs'],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 binary_authorization: Optional[pulumi.Input['ServiceBinaryAuthorizationArgs']] = None,
                 build_config: Optional[pulumi.Input['ServiceBuildConfigArgs']] = None,
                 client: Optional[pulumi.Input[builtins.str]] = None,
                 client_version: Optional[pulumi.Input[builtins.str]] = None,
                 custom_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_uri_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 iap_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ingress: Optional[pulumi.Input[builtins.str]] = None,
                 invoker_iam_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 launch_stage: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 scaling: Optional[pulumi.Input['ServiceScalingArgs']] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[builtins.str] location: The location of the cloud run service
        :param pulumi.Input['ServiceTemplateArgs'] template: The template used to create revisions for this Service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and
               should be preserved when modifying objects. Cloud Run API v2 does not support annotations with 'run.googleapis.com',
               'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected in new
               resources. All system annotations in v1 now have a corresponding field in v2 Service. This field follows Kubernetes
               annotations' namespacing, limits, and rules. **Note**: This field is non-authoritative, and will only manage the
               annotations present in your configuration. Please refer to the field 'effective_annotations' for all of the annotations
               present on the resource.
        :param pulumi.Input['ServiceBinaryAuthorizationArgs'] binary_authorization: Settings for the Binary Authorization feature.
        :param pulumi.Input['ServiceBuildConfigArgs'] build_config: Configuration for building a Cloud Run function.
        :param pulumi.Input[builtins.str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[builtins.str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_audiences: One or more custom audiences that you want this service to support. Specify each custom audience as the full URL in a
               string. The custom audiences are encoded in the token and used to authenticate requests. For more information, see
               https://cloud.google.com/run/docs/configuring/custom-audiences.
        :param pulumi.Input[builtins.bool] default_uri_disabled: Disables public resolution of the default URI of this service.
        :param pulumi.Input[builtins.str] description: User-provided description of the Service. This field currently has a 512-character limit.
        :param pulumi.Input[builtins.bool] iap_enabled: Used to enable/disable IAP for the service.
        :param pulumi.Input[builtins.str] ingress: Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or
               INGRESS_TRAFFIC_UNSPECIFIED if no revision is active. Possible values: ["INGRESS_TRAFFIC_ALL",
               "INGRESS_TRAFFIC_INTERNAL_ONLY", "INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER"]
        :param pulumi.Input[builtins.bool] invoker_iam_disabled: Disables IAM permission check for run.routes.invoke for callers of this service. For more information, visit
               https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with
               Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment,
               state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
               https://cloud.google.com/run/docs/configuring/labels. Cloud Run API v2 does not support labels with
               'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they
               will be rejected. All system labels in v1 now have a corresponding field in v2 Service. **Note**: This field is
               non-authoritative, and will only manage the labels present in your configuration. Please refer to the field
               'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch
               Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA. If no value is
               specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that
               stage. On read (or output), describes whether the resource uses preview features. For example, if ALPHA is provided as
               input, but only BETA and GA-level features are used, this field will be BETA on output. Possible values:
               ["UNIMPLEMENTED", "PRELAUNCH", "EARLY_ACCESS", "ALPHA", "BETA", "GA", "DEPRECATED"]
        :param pulumi.Input[builtins.str] name: Name of the Service.
        :param pulumi.Input['ServiceScalingArgs'] scaling: Scaling settings that apply to the whole service
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]] traffics: Specifies how to distribute traffic over a collection of Revisions belonging to the Service. If traffic is empty or not
               provided, defaults to 100% traffic to the latest Ready Revision.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "template", template)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if build_config is not None:
            pulumi.set(__self__, "build_config", build_config)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if client_version is not None:
            pulumi.set(__self__, "client_version", client_version)
        if custom_audiences is not None:
            pulumi.set(__self__, "custom_audiences", custom_audiences)
        if default_uri_disabled is not None:
            pulumi.set(__self__, "default_uri_disabled", default_uri_disabled)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if iap_enabled is not None:
            pulumi.set(__self__, "iap_enabled", iap_enabled)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if invoker_iam_disabled is not None:
            pulumi.set(__self__, "invoker_iam_disabled", invoker_iam_disabled)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if scaling is not None:
            pulumi.set(__self__, "scaling", scaling)
        if traffics is not None:
            pulumi.set(__self__, "traffics", traffics)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the cloud run service
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def template(self) -> pulumi.Input['ServiceTemplateArgs']:
        """
        The template used to create revisions for this Service.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input['ServiceTemplateArgs']):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and
        should be preserved when modifying objects. Cloud Run API v2 does not support annotations with 'run.googleapis.com',
        'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected in new
        resources. All system annotations in v1 now have a corresponding field in v2 Service. This field follows Kubernetes
        annotations' namespacing, limits, and rules. **Note**: This field is non-authoritative, and will only manage the
        annotations present in your configuration. Please refer to the field 'effective_annotations' for all of the annotations
        present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['ServiceBinaryAuthorizationArgs']]:
        """
        Settings for the Binary Authorization feature.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['ServiceBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @property
    @pulumi.getter(name="buildConfig")
    def build_config(self) -> Optional[pulumi.Input['ServiceBuildConfigArgs']]:
        """
        Configuration for building a Cloud Run function.
        """
        return pulumi.get(self, "build_config")

    @build_config.setter
    def build_config(self, value: Optional[pulumi.Input['ServiceBuildConfigArgs']]):
        pulumi.set(self, "build_config", value)

    @property
    @pulumi.getter
    def client(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @client.setter
    def client(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client", value)

    @property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @client_version.setter
    def client_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_version", value)

    @property
    @pulumi.getter(name="customAudiences")
    def custom_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more custom audiences that you want this service to support. Specify each custom audience as the full URL in a
        string. The custom audiences are encoded in the token and used to authenticate requests. For more information, see
        https://cloud.google.com/run/docs/configuring/custom-audiences.
        """
        return pulumi.get(self, "custom_audiences")

    @custom_audiences.setter
    def custom_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_audiences", value)

    @property
    @pulumi.getter(name="defaultUriDisabled")
    def default_uri_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disables public resolution of the default URI of this service.
        """
        return pulumi.get(self, "default_uri_disabled")

    @default_uri_disabled.setter
    def default_uri_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default_uri_disabled", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided description of the Service. This field currently has a 512-character limit.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="iapEnabled")
    def iap_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Used to enable/disable IAP for the service.
        """
        return pulumi.get(self, "iap_enabled")

    @iap_enabled.setter
    def iap_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "iap_enabled", value)

    @property
    @pulumi.getter
    def ingress(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or
        INGRESS_TRAFFIC_UNSPECIFIED if no revision is active. Possible values: ["INGRESS_TRAFFIC_ALL",
        "INGRESS_TRAFFIC_INTERNAL_ONLY", "INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER"]
        """
        return pulumi.get(self, "ingress")

    @ingress.setter
    def ingress(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ingress", value)

    @property
    @pulumi.getter(name="invokerIamDisabled")
    def invoker_iam_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disables IAM permission check for run.routes.invoke for callers of this service. For more information, visit
        https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
        """
        return pulumi.get(self, "invoker_iam_disabled")

    @invoker_iam_disabled.setter
    def invoker_iam_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "invoker_iam_disabled", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with
        Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment,
        state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        https://cloud.google.com/run/docs/configuring/labels. Cloud Run API v2 does not support labels with
        'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they
        will be rejected. All system labels in v1 now have a corresponding field in v2 Service. **Note**: This field is
        non-authoritative, and will only manage the labels present in your configuration. Please refer to the field
        'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The launch stage as defined by [Google Cloud Platform Launch
        Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA. If no value is
        specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that
        stage. On read (or output), describes whether the resource uses preview features. For example, if ALPHA is provided as
        input, but only BETA and GA-level features are used, this field will be BETA on output. Possible values:
        ["UNIMPLEMENTED", "PRELAUNCH", "EARLY_ACCESS", "ALPHA", "BETA", "GA", "DEPRECATED"]
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_stage", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def scaling(self) -> Optional[pulumi.Input['ServiceScalingArgs']]:
        """
        Scaling settings that apply to the whole service
        """
        return pulumi.get(self, "scaling")

    @scaling.setter
    def scaling(self, value: Optional[pulumi.Input['ServiceScalingArgs']]):
        pulumi.set(self, "scaling", value)

    @property
    @pulumi.getter
    def traffics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]:
        """
        Specifies how to distribute traffic over a collection of Revisions belonging to the Service. If traffic is empty or not
        provided, defaults to 100% traffic to the latest Ready Revision.
        """
        return pulumi.get(self, "traffics")

    @traffics.setter
    def traffics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]):
        pulumi.set(self, "traffics", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 binary_authorization: Optional[pulumi.Input['ServiceBinaryAuthorizationArgs']] = None,
                 build_config: Optional[pulumi.Input['ServiceBuildConfigArgs']] = None,
                 client: Optional[pulumi.Input[builtins.str]] = None,
                 client_version: Optional[pulumi.Input[builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConditionArgs']]]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 creator: Optional[pulumi.Input[builtins.str]] = None,
                 custom_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_uri_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 delete_time: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[builtins.str]] = None,
                 generation: Optional[pulumi.Input[builtins.str]] = None,
                 iap_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ingress: Optional[pulumi.Input[builtins.str]] = None,
                 invoker_iam_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 last_modifier: Optional[pulumi.Input[builtins.str]] = None,
                 latest_created_revision: Optional[pulumi.Input[builtins.str]] = None,
                 latest_ready_revision: Optional[pulumi.Input[builtins.str]] = None,
                 launch_stage: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 observed_generation: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 reconciling: Optional[pulumi.Input[builtins.bool]] = None,
                 scaling: Optional[pulumi.Input['ServiceScalingArgs']] = None,
                 template: Optional[pulumi.Input['ServiceTemplateArgs']] = None,
                 terminal_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTerminalConditionArgs']]]] = None,
                 traffic_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficStatusArgs']]]] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 uri: Optional[pulumi.Input[builtins.str]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and
               should be preserved when modifying objects. Cloud Run API v2 does not support annotations with 'run.googleapis.com',
               'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected in new
               resources. All system annotations in v1 now have a corresponding field in v2 Service. This field follows Kubernetes
               annotations' namespacing, limits, and rules. **Note**: This field is non-authoritative, and will only manage the
               annotations present in your configuration. Please refer to the field 'effective_annotations' for all of the annotations
               present on the resource.
        :param pulumi.Input['ServiceBinaryAuthorizationArgs'] binary_authorization: Settings for the Binary Authorization feature.
        :param pulumi.Input['ServiceBuildConfigArgs'] build_config: Configuration for building a Cloud Run function.
        :param pulumi.Input[builtins.str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[builtins.str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceConditionArgs']]] conditions: The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Service does not reach its Serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The creation time.
        :param pulumi.Input[builtins.str] creator: Email address of the authenticated creator.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_audiences: One or more custom audiences that you want this service to support. Specify each custom audience as the full URL in a
               string. The custom audiences are encoded in the token and used to authenticate requests. For more information, see
               https://cloud.google.com/run/docs/configuring/custom-audiences.
        :param pulumi.Input[builtins.bool] default_uri_disabled: Disables public resolution of the default URI of this service.
        :param pulumi.Input[builtins.str] delete_time: The deletion time.
        :param pulumi.Input[builtins.str] description: User-provided description of the Service. This field currently has a 512-character limit.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] etag: A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        :param pulumi.Input[builtins.str] expire_time: For a deleted resource, the time after which it will be permanently deleted.
        :param pulumi.Input[builtins.str] generation: A number that monotonically increases every time the user modifies the desired state. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        :param pulumi.Input[builtins.bool] iap_enabled: Used to enable/disable IAP for the service.
        :param pulumi.Input[builtins.str] ingress: Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or
               INGRESS_TRAFFIC_UNSPECIFIED if no revision is active. Possible values: ["INGRESS_TRAFFIC_ALL",
               "INGRESS_TRAFFIC_INTERNAL_ONLY", "INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER"]
        :param pulumi.Input[builtins.bool] invoker_iam_disabled: Disables IAM permission check for run.routes.invoke for callers of this service. For more information, visit
               https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with
               Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment,
               state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
               https://cloud.google.com/run/docs/configuring/labels. Cloud Run API v2 does not support labels with
               'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they
               will be rejected. All system labels in v1 now have a corresponding field in v2 Service. **Note**: This field is
               non-authoritative, and will only manage the labels present in your configuration. Please refer to the field
               'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] last_modifier: Email address of the last authenticated modifier.
        :param pulumi.Input[builtins.str] latest_created_revision: Name of the last created revision. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[builtins.str] latest_ready_revision: Name of the latest revision that is serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[builtins.str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch
               Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA. If no value is
               specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that
               stage. On read (or output), describes whether the resource uses preview features. For example, if ALPHA is provided as
               input, but only BETA and GA-level features are used, this field will be BETA on output. Possible values:
               ["UNIMPLEMENTED", "PRELAUNCH", "EARLY_ACCESS", "ALPHA", "BETA", "GA", "DEPRECATED"]
        :param pulumi.Input[builtins.str] location: The location of the cloud run service
        :param pulumi.Input[builtins.str] name: Name of the Service.
        :param pulumi.Input[builtins.str] observed_generation: The generation of this Service currently serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.bool] reconciling: Returns true if the Service is currently being acted upon by the system to bring it into the desired state.
               When a new Service is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Service to the desired serving state. This process is called reconciliation. While reconciliation is in process, observedGeneration, latest_ready_revison, trafficStatuses, and uri will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the serving state matches the Service, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
               If reconciliation succeeded, the following fields will match: traffic and trafficStatuses, observedGeneration and generation, latestReadyRevision and latestCreatedRevision.
               If reconciliation failed, trafficStatuses, observedGeneration, and latestReadyRevision will have the state of the last serving revision, or empty for newly created Services. Additional information on the failure can be found in terminalCondition and conditions.
        :param pulumi.Input['ServiceScalingArgs'] scaling: Scaling settings that apply to the whole service
        :param pulumi.Input['ServiceTemplateArgs'] template: The template used to create revisions for this Service.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTerminalConditionArgs']]] terminal_conditions: The Condition of this Service, containing its readiness status, and detailed error information in case it did not reach a serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTrafficStatusArgs']]] traffic_statuses: Detailed status information for corresponding traffic targets. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]] traffics: Specifies how to distribute traffic over a collection of Revisions belonging to the Service. If traffic is empty or not
               provided, defaults to 100% traffic to the latest Ready Revision.
        :param pulumi.Input[builtins.str] uid: Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[builtins.str] update_time: The last-modified time.
        :param pulumi.Input[builtins.str] uri: (Output)
               Displays the target URI.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] urls: All URLs serving traffic for this Service.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if build_config is not None:
            pulumi.set(__self__, "build_config", build_config)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if client_version is not None:
            pulumi.set(__self__, "client_version", client_version)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if custom_audiences is not None:
            pulumi.set(__self__, "custom_audiences", custom_audiences)
        if default_uri_disabled is not None:
            pulumi.set(__self__, "default_uri_disabled", default_uri_disabled)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if iap_enabled is not None:
            pulumi.set(__self__, "iap_enabled", iap_enabled)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if invoker_iam_disabled is not None:
            pulumi.set(__self__, "invoker_iam_disabled", invoker_iam_disabled)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if last_modifier is not None:
            pulumi.set(__self__, "last_modifier", last_modifier)
        if latest_created_revision is not None:
            pulumi.set(__self__, "latest_created_revision", latest_created_revision)
        if latest_ready_revision is not None:
            pulumi.set(__self__, "latest_ready_revision", latest_ready_revision)
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if scaling is not None:
            pulumi.set(__self__, "scaling", scaling)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if terminal_conditions is not None:
            pulumi.set(__self__, "terminal_conditions", terminal_conditions)
        if traffic_statuses is not None:
            pulumi.set(__self__, "traffic_statuses", traffic_statuses)
        if traffics is not None:
            pulumi.set(__self__, "traffics", traffics)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if urls is not None:
            pulumi.set(__self__, "urls", urls)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and
        should be preserved when modifying objects. Cloud Run API v2 does not support annotations with 'run.googleapis.com',
        'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected in new
        resources. All system annotations in v1 now have a corresponding field in v2 Service. This field follows Kubernetes
        annotations' namespacing, limits, and rules. **Note**: This field is non-authoritative, and will only manage the
        annotations present in your configuration. Please refer to the field 'effective_annotations' for all of the annotations
        present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['ServiceBinaryAuthorizationArgs']]:
        """
        Settings for the Binary Authorization feature.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['ServiceBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @property
    @pulumi.getter(name="buildConfig")
    def build_config(self) -> Optional[pulumi.Input['ServiceBuildConfigArgs']]:
        """
        Configuration for building a Cloud Run function.
        """
        return pulumi.get(self, "build_config")

    @build_config.setter
    def build_config(self, value: Optional[pulumi.Input['ServiceBuildConfigArgs']]):
        pulumi.set(self, "build_config", value)

    @property
    @pulumi.getter
    def client(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @client.setter
    def client(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client", value)

    @property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @client_version.setter
    def client_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_version", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConditionArgs']]]]:
        """
        The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Service does not reach its Serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Email address of the authenticated creator.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creator", value)

    @property
    @pulumi.getter(name="customAudiences")
    def custom_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more custom audiences that you want this service to support. Specify each custom audience as the full URL in a
        string. The custom audiences are encoded in the token and used to authenticate requests. For more information, see
        https://cloud.google.com/run/docs/configuring/custom-audiences.
        """
        return pulumi.get(self, "custom_audiences")

    @custom_audiences.setter
    def custom_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_audiences", value)

    @property
    @pulumi.getter(name="defaultUriDisabled")
    def default_uri_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disables public resolution of the default URI of this service.
        """
        return pulumi.get(self, "default_uri_disabled")

    @default_uri_disabled.setter
    def default_uri_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default_uri_disabled", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The deletion time.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided description of the Service. This field currently has a 512-character limit.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For a deleted resource, the time after which it will be permanently deleted.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A number that monotonically increases every time the user modifies the desired state. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter(name="iapEnabled")
    def iap_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Used to enable/disable IAP for the service.
        """
        return pulumi.get(self, "iap_enabled")

    @iap_enabled.setter
    def iap_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "iap_enabled", value)

    @property
    @pulumi.getter
    def ingress(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or
        INGRESS_TRAFFIC_UNSPECIFIED if no revision is active. Possible values: ["INGRESS_TRAFFIC_ALL",
        "INGRESS_TRAFFIC_INTERNAL_ONLY", "INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER"]
        """
        return pulumi.get(self, "ingress")

    @ingress.setter
    def ingress(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ingress", value)

    @property
    @pulumi.getter(name="invokerIamDisabled")
    def invoker_iam_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disables IAM permission check for run.routes.invoke for callers of this service. For more information, visit
        https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
        """
        return pulumi.get(self, "invoker_iam_disabled")

    @invoker_iam_disabled.setter
    def invoker_iam_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "invoker_iam_disabled", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with
        Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment,
        state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        https://cloud.google.com/run/docs/configuring/labels. Cloud Run API v2 does not support labels with
        'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they
        will be rejected. All system labels in v1 now have a corresponding field in v2 Service. **Note**: This field is
        non-authoritative, and will only manage the labels present in your configuration. Please refer to the field
        'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="lastModifier")
    def last_modifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Email address of the last authenticated modifier.
        """
        return pulumi.get(self, "last_modifier")

    @last_modifier.setter
    def last_modifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modifier", value)

    @property
    @pulumi.getter(name="latestCreatedRevision")
    def latest_created_revision(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the last created revision. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "latest_created_revision")

    @latest_created_revision.setter
    def latest_created_revision(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "latest_created_revision", value)

    @property
    @pulumi.getter(name="latestReadyRevision")
    def latest_ready_revision(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the latest revision that is serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "latest_ready_revision")

    @latest_ready_revision.setter
    def latest_ready_revision(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "latest_ready_revision", value)

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The launch stage as defined by [Google Cloud Platform Launch
        Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA. If no value is
        specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that
        stage. On read (or output), describes whether the resource uses preview features. For example, if ALPHA is provided as
        input, but only BETA and GA-level features are used, this field will be BETA on output. Possible values:
        ["UNIMPLEMENTED", "PRELAUNCH", "EARLY_ACCESS", "ALPHA", "BETA", "GA", "DEPRECATED"]
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_stage", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the cloud run service
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The generation of this Service currently serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Returns true if the Service is currently being acted upon by the system to bring it into the desired state.
        When a new Service is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Service to the desired serving state. This process is called reconciliation. While reconciliation is in process, observedGeneration, latest_ready_revison, trafficStatuses, and uri will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the serving state matches the Service, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
        If reconciliation succeeded, the following fields will match: traffic and trafficStatuses, observedGeneration and generation, latestReadyRevision and latestCreatedRevision.
        If reconciliation failed, trafficStatuses, observedGeneration, and latestReadyRevision will have the state of the last serving revision, or empty for newly created Services. Additional information on the failure can be found in terminalCondition and conditions.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter
    def scaling(self) -> Optional[pulumi.Input['ServiceScalingArgs']]:
        """
        Scaling settings that apply to the whole service
        """
        return pulumi.get(self, "scaling")

    @scaling.setter
    def scaling(self, value: Optional[pulumi.Input['ServiceScalingArgs']]):
        pulumi.set(self, "scaling", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['ServiceTemplateArgs']]:
        """
        The template used to create revisions for this Service.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['ServiceTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="terminalConditions")
    def terminal_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTerminalConditionArgs']]]]:
        """
        The Condition of this Service, containing its readiness status, and detailed error information in case it did not reach a serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "terminal_conditions")

    @terminal_conditions.setter
    def terminal_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTerminalConditionArgs']]]]):
        pulumi.set(self, "terminal_conditions", value)

    @property
    @pulumi.getter(name="trafficStatuses")
    def traffic_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficStatusArgs']]]]:
        """
        Detailed status information for corresponding traffic targets. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "traffic_statuses")

    @traffic_statuses.setter
    def traffic_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficStatusArgs']]]]):
        pulumi.set(self, "traffic_statuses", value)

    @property
    @pulumi.getter
    def traffics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]:
        """
        Specifies how to distribute traffic over a collection of Revisions belonging to the Service. If traffic is empty or not
        provided, defaults to 100% traffic to the latest Ready Revision.
        """
        return pulumi.get(self, "traffics")

    @traffics.setter
    def traffics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]):
        pulumi.set(self, "traffics", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last-modified time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Displays the target URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        All URLs serving traffic for this Service.
        """
        return pulumi.get(self, "urls")

    @urls.setter
    def urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "urls", value)


@pulumi.type_token("gcp:cloudrunv2/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 binary_authorization: Optional[pulumi.Input[Union['ServiceBinaryAuthorizationArgs', 'ServiceBinaryAuthorizationArgsDict']]] = None,
                 build_config: Optional[pulumi.Input[Union['ServiceBuildConfigArgs', 'ServiceBuildConfigArgsDict']]] = None,
                 client: Optional[pulumi.Input[builtins.str]] = None,
                 client_version: Optional[pulumi.Input[builtins.str]] = None,
                 custom_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_uri_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 iap_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ingress: Optional[pulumi.Input[builtins.str]] = None,
                 invoker_iam_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 launch_stage: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 scaling: Optional[pulumi.Input[Union['ServiceScalingArgs', 'ServiceScalingArgsDict']]] = None,
                 template: Optional[pulumi.Input[Union['ServiceTemplateArgs', 'ServiceTemplateArgsDict']]] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceTrafficArgs', 'ServiceTrafficArgsDict']]]]] = None,
                 __props__=None):
        """
        Service acts as a top-level container that manages a set of configurations and revision templates which implement a network service. Service exists to provide a singular abstraction which can be access controlled, reasoned about, and which encapsulates software lifecycle decisions such as rollout policy and team resource ownership.

        To get more information about Service, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        ## Example Usage

        ### Cloudrunv2 Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
            })
        ```
        ### Cloudrunv2 Service Limits

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    "resources": {
                        "limits": {
                            "cpu": "2",
                            "memory": "1024Mi",
                        },
                    },
                }],
            })
        ```
        ### Cloudrunv2 Service Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret-1",
            replication={
                "auto": {},
            })
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        instance = gcp.sql.DatabaseInstance("instance",
            name="cloudrun-sql",
            region="us-central1",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-f1-micro",
            },
            deletion_protection=True)
        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "scaling": {
                    "max_instance_count": 2,
                },
                "volumes": [{
                    "name": "cloudsql",
                    "cloud_sql_instance": {
                        "instances": [instance.connection_name],
                    },
                }],
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    "envs": [
                        {
                            "name": "FOO",
                            "value": "bar",
                        },
                        {
                            "name": "SECRET_ENV_VAR",
                            "value_source": {
                                "secret_key_ref": {
                                    "secret": secret.secret_id,
                                    "version": "1",
                                },
                            },
                        },
                    ],
                    "volume_mounts": [{
                        "name": "cloudsql",
                        "mount_path": "/cloudsql",
                    }],
                }],
            },
            traffics=[{
                "type": "TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST",
                "percent": 100,
            }],
            opts = pulumi.ResourceOptions(depends_on=[secret_version_data]))
        project = gcp.organizations.get_project()
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts = pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Service Vpcaccess

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test_network = gcp.compute.Network("custom_test",
            name="run-network",
            auto_create_subnetworks=False)
        custom_test = gcp.compute.Subnetwork("custom_test",
            name="run-subnetwork",
            ip_cidr_range="10.2.0.0/28",
            region="us-central1",
            network=custom_test_network.id)
        connector = gcp.vpcaccess.Connector("connector",
            name="run-vpc",
            subnet={
                "name": custom_test.name,
            },
            machine_type="e2-standard-4",
            min_instances=2,
            max_instances=3,
            region="us-central1")
        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
                "vpc_access": {
                    "connector": connector.id,
                    "egress": "ALL_TRAFFIC",
                },
            })
        ```
        ### Cloudrunv2 Service Directvpc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            launch_stage="GA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
                "vpc_access": {
                    "network_interfaces": [{
                        "network": "default",
                        "subnetwork": "default",
                        "tags": [
                            "tag1",
                            "tag2",
                            "tag3",
                        ],
                    }],
                },
            })
        ```
        ### Cloudrunv2 Service Gpu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    "resources": {
                        "limits": {
                            "cpu": "4",
                            "memory": "16Gi",
                            "nvidia.com/gpu": "1",
                        },
                        "startup_cpu_boost": True,
                    },
                }],
                "node_selector": {
                    "accelerator": "nvidia-l4",
                },
                "gpu_zonal_redundancy_disabled": True,
                "scaling": {
                    "max_instance_count": 1,
                },
            })
        ```
        ### Cloudrunv2 Service Probes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    "startup_probe": {
                        "initial_delay_seconds": 0,
                        "timeout_seconds": 1,
                        "period_seconds": 3,
                        "failure_threshold": 1,
                        "tcp_socket": {
                            "port": 8080,
                        },
                    },
                    "liveness_probe": {
                        "http_get": {
                            "path": "/",
                        },
                    },
                }],
            })
        ```
        ### Cloudrunv2 Service Secret

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret-1",
            replication={
                "auto": {},
            })
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "volumes": [{
                    "name": "a-volume",
                    "secret": {
                        "secret": secret.secret_id,
                        "default_mode": 292,
                        "items": [{
                            "version": "1",
                            "path": "my-secret",
                        }],
                    },
                }],
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    "volume_mounts": [{
                        "name": "a-volume",
                        "mount_path": "/secrets",
                    }],
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[secret_version_data]))
        project = gcp.organizations.get_project()
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts = pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Service Multicontainer

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [
                    {
                        "name": "hello-1",
                        "ports": {
                            "container_port": 8080,
                        },
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                        "depends_ons": ["hello-2"],
                        "volume_mounts": [{
                            "name": "empty-dir-volume",
                            "mount_path": "/mnt",
                        }],
                    },
                    {
                        "name": "hello-2",
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                        "envs": [{
                            "name": "PORT",
                            "value": "8081",
                        }],
                        "startup_probe": {
                            "http_get": {
                                "port": 8081,
                            },
                        },
                    },
                ],
                "volumes": [{
                    "name": "empty-dir-volume",
                    "empty_dir": {
                        "medium": "MEMORY",
                        "size_limit": "256Mi",
                    },
                }],
            })
        ```
        ### Cloudrunv2 Service Mount Gcs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_bucket = gcp.storage.Bucket("default",
            name="cloudrun-service",
            location="US")
        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            template={
                "execution_environment": "EXECUTION_ENVIRONMENT_GEN2",
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    "volume_mounts": [{
                        "name": "bucket",
                        "mount_path": "/var/www",
                    }],
                }],
                "volumes": [{
                    "name": "bucket",
                    "gcs": {
                        "bucket": default_bucket.name,
                        "read_only": False,
                    },
                }],
            })
        ```
        ### Cloudrunv2 Service Mount Nfs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_instance = gcp.filestore.Instance("default",
            name="cloudrun-service",
            location="us-central1-b",
            tier="BASIC_HDD",
            file_shares={
                "capacity_gb": 1024,
                "name": "share1",
            },
            networks=[{
                "network": "default",
                "modes": ["MODE_IPV4"],
            }])
        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "execution_environment": "EXECUTION_ENVIRONMENT_GEN2",
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello:latest",
                    "volume_mounts": [{
                        "name": "nfs",
                        "mount_path": "/mnt/nfs/filestore",
                    }],
                }],
                "vpc_access": {
                    "network_interfaces": [{
                        "network": "default",
                        "subnetwork": "default",
                    }],
                },
                "volumes": [{
                    "name": "nfs",
                    "nfs": {
                        "server": default_instance.networks[0].ip_addresses[0],
                        "path": "/share1",
                        "read_only": False,
                    },
                }],
            })
        ```
        ### Cloudrunv2 Service Mesh

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        mesh = gcp.networkservices.Mesh("mesh", name="network-services-mesh")
        wait_for_mesh = time.index.Sleep("wait_for_mesh", create_duration=1m,
        opts = pulumi.ResourceOptions(depends_on=[mesh]))
        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            deletion_protection=False,
            location="us-central1",
            launch_stage="BETA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
                "service_mesh": {
                    "mesh": mesh.id,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[wait_for_mesh]))
        ```
        ### Cloudrunv2 Service Invokeriam

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            invoker_iam_disabled=True,
            description="The serving URL of this service will not perform any IAM check when invoked",
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
            })
        ```
        ### Cloudrunv2 Service Function

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project.project_id}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function_source.zip"))
        cloudbuild_service_account = gcp.serviceaccount.Account("cloudbuild_service_account", account_id="build-sa")
        act_as = gcp.projects.IAMMember("act_as",
            project=project.project_id,
            role="roles/iam.serviceAccountUser",
            member=cloudbuild_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        logs_writer = gcp.projects.IAMMember("logs_writer",
            project=project.project_id,
            role="roles/logging.logWriter",
            member=cloudbuild_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    "base_image_uri": "us-central1-docker.pkg.dev/serverless-runtimes/google-22-full/runtimes/nodejs22",
                }],
            },
            build_config={
                "source_location": pulumi.Output.all(
                    bucketName=bucket.name,
                    objectName=object.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucketName']}/{resolved_outputs['objectName']}")
        ,
                "function_target": "helloHttp",
                "image_uri": "us-docker.pkg.dev/cloudrun/container/hello",
                "base_image": "us-central1-docker.pkg.dev/serverless-runtimes/google-22-full/runtimes/nodejs22",
                "enable_automatic_updates": True,
                "environment_variables": {
                    "FOO_KEY": "FOO_VALUE",
                    "BAR_KEY": "BAR_VALUE",
                },
                "service_account": cloudbuild_service_account.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    act_as,
                    logs_writer,
                ]))
        ```
        ### Cloudrunv2 Service Iap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-iap-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            launch_stage="BETA",
            iap_enabled=True,
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
            })
        ```

        ## Import

        Service can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/services/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Service can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudrunv2/service:Service default projects/{{project}}/locations/{{location}}/services/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrunv2/service:Service default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrunv2/service:Service default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and
               should be preserved when modifying objects. Cloud Run API v2 does not support annotations with 'run.googleapis.com',
               'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected in new
               resources. All system annotations in v1 now have a corresponding field in v2 Service. This field follows Kubernetes
               annotations' namespacing, limits, and rules. **Note**: This field is non-authoritative, and will only manage the
               annotations present in your configuration. Please refer to the field 'effective_annotations' for all of the annotations
               present on the resource.
        :param pulumi.Input[Union['ServiceBinaryAuthorizationArgs', 'ServiceBinaryAuthorizationArgsDict']] binary_authorization: Settings for the Binary Authorization feature.
        :param pulumi.Input[Union['ServiceBuildConfigArgs', 'ServiceBuildConfigArgsDict']] build_config: Configuration for building a Cloud Run function.
        :param pulumi.Input[builtins.str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[builtins.str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_audiences: One or more custom audiences that you want this service to support. Specify each custom audience as the full URL in a
               string. The custom audiences are encoded in the token and used to authenticate requests. For more information, see
               https://cloud.google.com/run/docs/configuring/custom-audiences.
        :param pulumi.Input[builtins.bool] default_uri_disabled: Disables public resolution of the default URI of this service.
        :param pulumi.Input[builtins.str] description: User-provided description of the Service. This field currently has a 512-character limit.
        :param pulumi.Input[builtins.bool] iap_enabled: Used to enable/disable IAP for the service.
        :param pulumi.Input[builtins.str] ingress: Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or
               INGRESS_TRAFFIC_UNSPECIFIED if no revision is active. Possible values: ["INGRESS_TRAFFIC_ALL",
               "INGRESS_TRAFFIC_INTERNAL_ONLY", "INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER"]
        :param pulumi.Input[builtins.bool] invoker_iam_disabled: Disables IAM permission check for run.routes.invoke for callers of this service. For more information, visit
               https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with
               Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment,
               state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
               https://cloud.google.com/run/docs/configuring/labels. Cloud Run API v2 does not support labels with
               'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they
               will be rejected. All system labels in v1 now have a corresponding field in v2 Service. **Note**: This field is
               non-authoritative, and will only manage the labels present in your configuration. Please refer to the field
               'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch
               Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA. If no value is
               specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that
               stage. On read (or output), describes whether the resource uses preview features. For example, if ALPHA is provided as
               input, but only BETA and GA-level features are used, this field will be BETA on output. Possible values:
               ["UNIMPLEMENTED", "PRELAUNCH", "EARLY_ACCESS", "ALPHA", "BETA", "GA", "DEPRECATED"]
        :param pulumi.Input[builtins.str] location: The location of the cloud run service
        :param pulumi.Input[builtins.str] name: Name of the Service.
        :param pulumi.Input[Union['ServiceScalingArgs', 'ServiceScalingArgsDict']] scaling: Scaling settings that apply to the whole service
        :param pulumi.Input[Union['ServiceTemplateArgs', 'ServiceTemplateArgsDict']] template: The template used to create revisions for this Service.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceTrafficArgs', 'ServiceTrafficArgsDict']]]] traffics: Specifies how to distribute traffic over a collection of Revisions belonging to the Service. If traffic is empty or not
               provided, defaults to 100% traffic to the latest Ready Revision.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Service acts as a top-level container that manages a set of configurations and revision templates which implement a network service. Service exists to provide a singular abstraction which can be access controlled, reasoned about, and which encapsulates software lifecycle decisions such as rollout policy and team resource ownership.

        To get more information about Service, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        ## Example Usage

        ### Cloudrunv2 Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
            })
        ```
        ### Cloudrunv2 Service Limits

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    "resources": {
                        "limits": {
                            "cpu": "2",
                            "memory": "1024Mi",
                        },
                    },
                }],
            })
        ```
        ### Cloudrunv2 Service Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret-1",
            replication={
                "auto": {},
            })
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        instance = gcp.sql.DatabaseInstance("instance",
            name="cloudrun-sql",
            region="us-central1",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-f1-micro",
            },
            deletion_protection=True)
        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "scaling": {
                    "max_instance_count": 2,
                },
                "volumes": [{
                    "name": "cloudsql",
                    "cloud_sql_instance": {
                        "instances": [instance.connection_name],
                    },
                }],
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    "envs": [
                        {
                            "name": "FOO",
                            "value": "bar",
                        },
                        {
                            "name": "SECRET_ENV_VAR",
                            "value_source": {
                                "secret_key_ref": {
                                    "secret": secret.secret_id,
                                    "version": "1",
                                },
                            },
                        },
                    ],
                    "volume_mounts": [{
                        "name": "cloudsql",
                        "mount_path": "/cloudsql",
                    }],
                }],
            },
            traffics=[{
                "type": "TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST",
                "percent": 100,
            }],
            opts = pulumi.ResourceOptions(depends_on=[secret_version_data]))
        project = gcp.organizations.get_project()
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts = pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Service Vpcaccess

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test_network = gcp.compute.Network("custom_test",
            name="run-network",
            auto_create_subnetworks=False)
        custom_test = gcp.compute.Subnetwork("custom_test",
            name="run-subnetwork",
            ip_cidr_range="10.2.0.0/28",
            region="us-central1",
            network=custom_test_network.id)
        connector = gcp.vpcaccess.Connector("connector",
            name="run-vpc",
            subnet={
                "name": custom_test.name,
            },
            machine_type="e2-standard-4",
            min_instances=2,
            max_instances=3,
            region="us-central1")
        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
                "vpc_access": {
                    "connector": connector.id,
                    "egress": "ALL_TRAFFIC",
                },
            })
        ```
        ### Cloudrunv2 Service Directvpc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            launch_stage="GA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
                "vpc_access": {
                    "network_interfaces": [{
                        "network": "default",
                        "subnetwork": "default",
                        "tags": [
                            "tag1",
                            "tag2",
                            "tag3",
                        ],
                    }],
                },
            })
        ```
        ### Cloudrunv2 Service Gpu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    "resources": {
                        "limits": {
                            "cpu": "4",
                            "memory": "16Gi",
                            "nvidia.com/gpu": "1",
                        },
                        "startup_cpu_boost": True,
                    },
                }],
                "node_selector": {
                    "accelerator": "nvidia-l4",
                },
                "gpu_zonal_redundancy_disabled": True,
                "scaling": {
                    "max_instance_count": 1,
                },
            })
        ```
        ### Cloudrunv2 Service Probes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    "startup_probe": {
                        "initial_delay_seconds": 0,
                        "timeout_seconds": 1,
                        "period_seconds": 3,
                        "failure_threshold": 1,
                        "tcp_socket": {
                            "port": 8080,
                        },
                    },
                    "liveness_probe": {
                        "http_get": {
                            "path": "/",
                        },
                    },
                }],
            })
        ```
        ### Cloudrunv2 Service Secret

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret-1",
            replication={
                "auto": {},
            })
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "volumes": [{
                    "name": "a-volume",
                    "secret": {
                        "secret": secret.secret_id,
                        "default_mode": 292,
                        "items": [{
                            "version": "1",
                            "path": "my-secret",
                        }],
                    },
                }],
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    "volume_mounts": [{
                        "name": "a-volume",
                        "mount_path": "/secrets",
                    }],
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[secret_version_data]))
        project = gcp.organizations.get_project()
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts = pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Service Multicontainer

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [
                    {
                        "name": "hello-1",
                        "ports": {
                            "container_port": 8080,
                        },
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                        "depends_ons": ["hello-2"],
                        "volume_mounts": [{
                            "name": "empty-dir-volume",
                            "mount_path": "/mnt",
                        }],
                    },
                    {
                        "name": "hello-2",
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                        "envs": [{
                            "name": "PORT",
                            "value": "8081",
                        }],
                        "startup_probe": {
                            "http_get": {
                                "port": 8081,
                            },
                        },
                    },
                ],
                "volumes": [{
                    "name": "empty-dir-volume",
                    "empty_dir": {
                        "medium": "MEMORY",
                        "size_limit": "256Mi",
                    },
                }],
            })
        ```
        ### Cloudrunv2 Service Mount Gcs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_bucket = gcp.storage.Bucket("default",
            name="cloudrun-service",
            location="US")
        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            template={
                "execution_environment": "EXECUTION_ENVIRONMENT_GEN2",
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    "volume_mounts": [{
                        "name": "bucket",
                        "mount_path": "/var/www",
                    }],
                }],
                "volumes": [{
                    "name": "bucket",
                    "gcs": {
                        "bucket": default_bucket.name,
                        "read_only": False,
                    },
                }],
            })
        ```
        ### Cloudrunv2 Service Mount Nfs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_instance = gcp.filestore.Instance("default",
            name="cloudrun-service",
            location="us-central1-b",
            tier="BASIC_HDD",
            file_shares={
                "capacity_gb": 1024,
                "name": "share1",
            },
            networks=[{
                "network": "default",
                "modes": ["MODE_IPV4"],
            }])
        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "execution_environment": "EXECUTION_ENVIRONMENT_GEN2",
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello:latest",
                    "volume_mounts": [{
                        "name": "nfs",
                        "mount_path": "/mnt/nfs/filestore",
                    }],
                }],
                "vpc_access": {
                    "network_interfaces": [{
                        "network": "default",
                        "subnetwork": "default",
                    }],
                },
                "volumes": [{
                    "name": "nfs",
                    "nfs": {
                        "server": default_instance.networks[0].ip_addresses[0],
                        "path": "/share1",
                        "read_only": False,
                    },
                }],
            })
        ```
        ### Cloudrunv2 Service Mesh

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        mesh = gcp.networkservices.Mesh("mesh", name="network-services-mesh")
        wait_for_mesh = time.index.Sleep("wait_for_mesh", create_duration=1m,
        opts = pulumi.ResourceOptions(depends_on=[mesh]))
        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            deletion_protection=False,
            location="us-central1",
            launch_stage="BETA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
                "service_mesh": {
                    "mesh": mesh.id,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[wait_for_mesh]))
        ```
        ### Cloudrunv2 Service Invokeriam

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            invoker_iam_disabled=True,
            description="The serving URL of this service will not perform any IAM check when invoked",
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
            })
        ```
        ### Cloudrunv2 Service Function

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project.project_id}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function_source.zip"))
        cloudbuild_service_account = gcp.serviceaccount.Account("cloudbuild_service_account", account_id="build-sa")
        act_as = gcp.projects.IAMMember("act_as",
            project=project.project_id,
            role="roles/iam.serviceAccountUser",
            member=cloudbuild_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        logs_writer = gcp.projects.IAMMember("logs_writer",
            project=project.project_id,
            role="roles/logging.logWriter",
            member=cloudbuild_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    "base_image_uri": "us-central1-docker.pkg.dev/serverless-runtimes/google-22-full/runtimes/nodejs22",
                }],
            },
            build_config={
                "source_location": pulumi.Output.all(
                    bucketName=bucket.name,
                    objectName=object.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucketName']}/{resolved_outputs['objectName']}")
        ,
                "function_target": "helloHttp",
                "image_uri": "us-docker.pkg.dev/cloudrun/container/hello",
                "base_image": "us-central1-docker.pkg.dev/serverless-runtimes/google-22-full/runtimes/nodejs22",
                "enable_automatic_updates": True,
                "environment_variables": {
                    "FOO_KEY": "FOO_VALUE",
                    "BAR_KEY": "BAR_VALUE",
                },
                "service_account": cloudbuild_service_account.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    act_as,
                    logs_writer,
                ]))
        ```
        ### Cloudrunv2 Service Iap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            name="cloudrun-iap-service",
            location="us-central1",
            deletion_protection=False,
            ingress="INGRESS_TRAFFIC_ALL",
            launch_stage="BETA",
            iap_enabled=True,
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
            })
        ```

        ## Import

        Service can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/services/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Service can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudrunv2/service:Service default projects/{{project}}/locations/{{location}}/services/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrunv2/service:Service default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrunv2/service:Service default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 binary_authorization: Optional[pulumi.Input[Union['ServiceBinaryAuthorizationArgs', 'ServiceBinaryAuthorizationArgsDict']]] = None,
                 build_config: Optional[pulumi.Input[Union['ServiceBuildConfigArgs', 'ServiceBuildConfigArgsDict']]] = None,
                 client: Optional[pulumi.Input[builtins.str]] = None,
                 client_version: Optional[pulumi.Input[builtins.str]] = None,
                 custom_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_uri_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 iap_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ingress: Optional[pulumi.Input[builtins.str]] = None,
                 invoker_iam_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 launch_stage: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 scaling: Optional[pulumi.Input[Union['ServiceScalingArgs', 'ServiceScalingArgsDict']]] = None,
                 template: Optional[pulumi.Input[Union['ServiceTemplateArgs', 'ServiceTemplateArgsDict']]] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceTrafficArgs', 'ServiceTrafficArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["binary_authorization"] = binary_authorization
            __props__.__dict__["build_config"] = build_config
            __props__.__dict__["client"] = client
            __props__.__dict__["client_version"] = client_version
            __props__.__dict__["custom_audiences"] = custom_audiences
            __props__.__dict__["default_uri_disabled"] = default_uri_disabled
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["iap_enabled"] = iap_enabled
            __props__.__dict__["ingress"] = ingress
            __props__.__dict__["invoker_iam_disabled"] = invoker_iam_disabled
            __props__.__dict__["labels"] = labels
            __props__.__dict__["launch_stage"] = launch_stage
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["scaling"] = scaling
            if template is None and not opts.urn:
                raise TypeError("Missing required property 'template'")
            __props__.__dict__["template"] = template
            __props__.__dict__["traffics"] = traffics
            __props__.__dict__["conditions"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["creator"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["expire_time"] = None
            __props__.__dict__["generation"] = None
            __props__.__dict__["last_modifier"] = None
            __props__.__dict__["latest_created_revision"] = None
            __props__.__dict__["latest_ready_revision"] = None
            __props__.__dict__["observed_generation"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["terminal_conditions"] = None
            __props__.__dict__["traffic_statuses"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["uri"] = None
            __props__.__dict__["urls"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Service, __self__).__init__(
            'gcp:cloudrunv2/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            binary_authorization: Optional[pulumi.Input[Union['ServiceBinaryAuthorizationArgs', 'ServiceBinaryAuthorizationArgsDict']]] = None,
            build_config: Optional[pulumi.Input[Union['ServiceBuildConfigArgs', 'ServiceBuildConfigArgsDict']]] = None,
            client: Optional[pulumi.Input[builtins.str]] = None,
            client_version: Optional[pulumi.Input[builtins.str]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceConditionArgs', 'ServiceConditionArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            creator: Optional[pulumi.Input[builtins.str]] = None,
            custom_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            default_uri_disabled: Optional[pulumi.Input[builtins.bool]] = None,
            delete_time: Optional[pulumi.Input[builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            expire_time: Optional[pulumi.Input[builtins.str]] = None,
            generation: Optional[pulumi.Input[builtins.str]] = None,
            iap_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            ingress: Optional[pulumi.Input[builtins.str]] = None,
            invoker_iam_disabled: Optional[pulumi.Input[builtins.bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            last_modifier: Optional[pulumi.Input[builtins.str]] = None,
            latest_created_revision: Optional[pulumi.Input[builtins.str]] = None,
            latest_ready_revision: Optional[pulumi.Input[builtins.str]] = None,
            launch_stage: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            observed_generation: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            reconciling: Optional[pulumi.Input[builtins.bool]] = None,
            scaling: Optional[pulumi.Input[Union['ServiceScalingArgs', 'ServiceScalingArgsDict']]] = None,
            template: Optional[pulumi.Input[Union['ServiceTemplateArgs', 'ServiceTemplateArgsDict']]] = None,
            terminal_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceTerminalConditionArgs', 'ServiceTerminalConditionArgsDict']]]]] = None,
            traffic_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceTrafficStatusArgs', 'ServiceTrafficStatusArgsDict']]]]] = None,
            traffics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceTrafficArgs', 'ServiceTrafficArgsDict']]]]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            uri: Optional[pulumi.Input[builtins.str]] = None,
            urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and
               should be preserved when modifying objects. Cloud Run API v2 does not support annotations with 'run.googleapis.com',
               'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected in new
               resources. All system annotations in v1 now have a corresponding field in v2 Service. This field follows Kubernetes
               annotations' namespacing, limits, and rules. **Note**: This field is non-authoritative, and will only manage the
               annotations present in your configuration. Please refer to the field 'effective_annotations' for all of the annotations
               present on the resource.
        :param pulumi.Input[Union['ServiceBinaryAuthorizationArgs', 'ServiceBinaryAuthorizationArgsDict']] binary_authorization: Settings for the Binary Authorization feature.
        :param pulumi.Input[Union['ServiceBuildConfigArgs', 'ServiceBuildConfigArgsDict']] build_config: Configuration for building a Cloud Run function.
        :param pulumi.Input[builtins.str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[builtins.str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceConditionArgs', 'ServiceConditionArgsDict']]]] conditions: The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Service does not reach its Serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The creation time.
        :param pulumi.Input[builtins.str] creator: Email address of the authenticated creator.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_audiences: One or more custom audiences that you want this service to support. Specify each custom audience as the full URL in a
               string. The custom audiences are encoded in the token and used to authenticate requests. For more information, see
               https://cloud.google.com/run/docs/configuring/custom-audiences.
        :param pulumi.Input[builtins.bool] default_uri_disabled: Disables public resolution of the default URI of this service.
        :param pulumi.Input[builtins.str] delete_time: The deletion time.
        :param pulumi.Input[builtins.str] description: User-provided description of the Service. This field currently has a 512-character limit.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] etag: A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        :param pulumi.Input[builtins.str] expire_time: For a deleted resource, the time after which it will be permanently deleted.
        :param pulumi.Input[builtins.str] generation: A number that monotonically increases every time the user modifies the desired state. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        :param pulumi.Input[builtins.bool] iap_enabled: Used to enable/disable IAP for the service.
        :param pulumi.Input[builtins.str] ingress: Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or
               INGRESS_TRAFFIC_UNSPECIFIED if no revision is active. Possible values: ["INGRESS_TRAFFIC_ALL",
               "INGRESS_TRAFFIC_INTERNAL_ONLY", "INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER"]
        :param pulumi.Input[builtins.bool] invoker_iam_disabled: Disables IAM permission check for run.routes.invoke for callers of this service. For more information, visit
               https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with
               Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment,
               state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
               https://cloud.google.com/run/docs/configuring/labels. Cloud Run API v2 does not support labels with
               'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they
               will be rejected. All system labels in v1 now have a corresponding field in v2 Service. **Note**: This field is
               non-authoritative, and will only manage the labels present in your configuration. Please refer to the field
               'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] last_modifier: Email address of the last authenticated modifier.
        :param pulumi.Input[builtins.str] latest_created_revision: Name of the last created revision. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[builtins.str] latest_ready_revision: Name of the latest revision that is serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[builtins.str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch
               Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA. If no value is
               specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that
               stage. On read (or output), describes whether the resource uses preview features. For example, if ALPHA is provided as
               input, but only BETA and GA-level features are used, this field will be BETA on output. Possible values:
               ["UNIMPLEMENTED", "PRELAUNCH", "EARLY_ACCESS", "ALPHA", "BETA", "GA", "DEPRECATED"]
        :param pulumi.Input[builtins.str] location: The location of the cloud run service
        :param pulumi.Input[builtins.str] name: Name of the Service.
        :param pulumi.Input[builtins.str] observed_generation: The generation of this Service currently serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.bool] reconciling: Returns true if the Service is currently being acted upon by the system to bring it into the desired state.
               When a new Service is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Service to the desired serving state. This process is called reconciliation. While reconciliation is in process, observedGeneration, latest_ready_revison, trafficStatuses, and uri will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the serving state matches the Service, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
               If reconciliation succeeded, the following fields will match: traffic and trafficStatuses, observedGeneration and generation, latestReadyRevision and latestCreatedRevision.
               If reconciliation failed, trafficStatuses, observedGeneration, and latestReadyRevision will have the state of the last serving revision, or empty for newly created Services. Additional information on the failure can be found in terminalCondition and conditions.
        :param pulumi.Input[Union['ServiceScalingArgs', 'ServiceScalingArgsDict']] scaling: Scaling settings that apply to the whole service
        :param pulumi.Input[Union['ServiceTemplateArgs', 'ServiceTemplateArgsDict']] template: The template used to create revisions for this Service.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceTerminalConditionArgs', 'ServiceTerminalConditionArgsDict']]]] terminal_conditions: The Condition of this Service, containing its readiness status, and detailed error information in case it did not reach a serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceTrafficStatusArgs', 'ServiceTrafficStatusArgsDict']]]] traffic_statuses: Detailed status information for corresponding traffic targets. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceTrafficArgs', 'ServiceTrafficArgsDict']]]] traffics: Specifies how to distribute traffic over a collection of Revisions belonging to the Service. If traffic is empty or not
               provided, defaults to 100% traffic to the latest Ready Revision.
        :param pulumi.Input[builtins.str] uid: Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[builtins.str] update_time: The last-modified time.
        :param pulumi.Input[builtins.str] uri: (Output)
               Displays the target URI.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] urls: All URLs serving traffic for this Service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["binary_authorization"] = binary_authorization
        __props__.__dict__["build_config"] = build_config
        __props__.__dict__["client"] = client
        __props__.__dict__["client_version"] = client_version
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["creator"] = creator
        __props__.__dict__["custom_audiences"] = custom_audiences
        __props__.__dict__["default_uri_disabled"] = default_uri_disabled
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["generation"] = generation
        __props__.__dict__["iap_enabled"] = iap_enabled
        __props__.__dict__["ingress"] = ingress
        __props__.__dict__["invoker_iam_disabled"] = invoker_iam_disabled
        __props__.__dict__["labels"] = labels
        __props__.__dict__["last_modifier"] = last_modifier
        __props__.__dict__["latest_created_revision"] = latest_created_revision
        __props__.__dict__["latest_ready_revision"] = latest_ready_revision
        __props__.__dict__["launch_stage"] = launch_stage
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["observed_generation"] = observed_generation
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["scaling"] = scaling
        __props__.__dict__["template"] = template
        __props__.__dict__["terminal_conditions"] = terminal_conditions
        __props__.__dict__["traffic_statuses"] = traffic_statuses
        __props__.__dict__["traffics"] = traffics
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["uri"] = uri
        __props__.__dict__["urls"] = urls
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and
        should be preserved when modifying objects. Cloud Run API v2 does not support annotations with 'run.googleapis.com',
        'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected in new
        resources. All system annotations in v1 now have a corresponding field in v2 Service. This field follows Kubernetes
        annotations' namespacing, limits, and rules. **Note**: This field is non-authoritative, and will only manage the
        annotations present in your configuration. Please refer to the field 'effective_annotations' for all of the annotations
        present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> pulumi.Output[Optional['outputs.ServiceBinaryAuthorization']]:
        """
        Settings for the Binary Authorization feature.
        """
        return pulumi.get(self, "binary_authorization")

    @property
    @pulumi.getter(name="buildConfig")
    def build_config(self) -> pulumi.Output[Optional['outputs.ServiceBuildConfig']]:
        """
        Configuration for building a Cloud Run function.
        """
        return pulumi.get(self, "build_config")

    @property
    @pulumi.getter
    def client(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.ServiceCondition']]:
        """
        The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Service does not reach its Serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> pulumi.Output[builtins.str]:
        """
        Email address of the authenticated creator.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="customAudiences")
    def custom_audiences(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        One or more custom audiences that you want this service to support. Specify each custom audience as the full URL in a
        string. The custom audiences are encoded in the token and used to authenticate requests. For more information, see
        https://cloud.google.com/run/docs/configuring/custom-audiences.
        """
        return pulumi.get(self, "custom_audiences")

    @property
    @pulumi.getter(name="defaultUriDisabled")
    def default_uri_disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Disables public resolution of the default URI of this service.
        """
        return pulumi.get(self, "default_uri_disabled")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[builtins.str]:
        """
        The deletion time.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-provided description of the Service. This field currently has a 512-character limit.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[builtins.str]:
        """
        For a deleted resource, the time after which it will be permanently deleted.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def generation(self) -> pulumi.Output[builtins.str]:
        """
        A number that monotonically increases every time the user modifies the desired state. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter(name="iapEnabled")
    def iap_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Used to enable/disable IAP for the service.
        """
        return pulumi.get(self, "iap_enabled")

    @property
    @pulumi.getter
    def ingress(self) -> pulumi.Output[builtins.str]:
        """
        Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or
        INGRESS_TRAFFIC_UNSPECIFIED if no revision is active. Possible values: ["INGRESS_TRAFFIC_ALL",
        "INGRESS_TRAFFIC_INTERNAL_ONLY", "INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER"]
        """
        return pulumi.get(self, "ingress")

    @property
    @pulumi.getter(name="invokerIamDisabled")
    def invoker_iam_disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Disables IAM permission check for run.routes.invoke for callers of this service. For more information, visit
        https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
        """
        return pulumi.get(self, "invoker_iam_disabled")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with
        Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment,
        state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        https://cloud.google.com/run/docs/configuring/labels. Cloud Run API v2 does not support labels with
        'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they
        will be rejected. All system labels in v1 now have a corresponding field in v2 Service. **Note**: This field is
        non-authoritative, and will only manage the labels present in your configuration. Please refer to the field
        'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lastModifier")
    def last_modifier(self) -> pulumi.Output[builtins.str]:
        """
        Email address of the last authenticated modifier.
        """
        return pulumi.get(self, "last_modifier")

    @property
    @pulumi.getter(name="latestCreatedRevision")
    def latest_created_revision(self) -> pulumi.Output[builtins.str]:
        """
        Name of the last created revision. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "latest_created_revision")

    @property
    @pulumi.getter(name="latestReadyRevision")
    def latest_ready_revision(self) -> pulumi.Output[builtins.str]:
        """
        Name of the latest revision that is serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "latest_ready_revision")

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> pulumi.Output[builtins.str]:
        """
        The launch stage as defined by [Google Cloud Platform Launch
        Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA. If no value is
        specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that
        stage. On read (or output), describes whether the resource uses preview features. For example, if ALPHA is provided as
        input, but only BETA and GA-level features are used, this field will be BETA on output. Possible values:
        ["UNIMPLEMENTED", "PRELAUNCH", "EARLY_ACCESS", "ALPHA", "BETA", "GA", "DEPRECATED"]
        """
        return pulumi.get(self, "launch_stage")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the cloud run service
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> pulumi.Output[builtins.str]:
        """
        The generation of this Service currently serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[builtins.bool]:
        """
        Returns true if the Service is currently being acted upon by the system to bring it into the desired state.
        When a new Service is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Service to the desired serving state. This process is called reconciliation. While reconciliation is in process, observedGeneration, latest_ready_revison, trafficStatuses, and uri will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the serving state matches the Service, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
        If reconciliation succeeded, the following fields will match: traffic and trafficStatuses, observedGeneration and generation, latestReadyRevision and latestCreatedRevision.
        If reconciliation failed, trafficStatuses, observedGeneration, and latestReadyRevision will have the state of the last serving revision, or empty for newly created Services. Additional information on the failure can be found in terminalCondition and conditions.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def scaling(self) -> pulumi.Output[Optional['outputs.ServiceScaling']]:
        """
        Scaling settings that apply to the whole service
        """
        return pulumi.get(self, "scaling")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output['outputs.ServiceTemplate']:
        """
        The template used to create revisions for this Service.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="terminalConditions")
    def terminal_conditions(self) -> pulumi.Output[Sequence['outputs.ServiceTerminalCondition']]:
        """
        The Condition of this Service, containing its readiness status, and detailed error information in case it did not reach a serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "terminal_conditions")

    @property
    @pulumi.getter(name="trafficStatuses")
    def traffic_statuses(self) -> pulumi.Output[Sequence['outputs.ServiceTrafficStatus']]:
        """
        Detailed status information for corresponding traffic targets. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "traffic_statuses")

    @property
    @pulumi.getter
    def traffics(self) -> pulumi.Output[Sequence['outputs.ServiceTraffic']]:
        """
        Specifies how to distribute traffic over a collection of Revisions belonging to the Service. If traffic is empty or not
        provided, defaults to 100% traffic to the latest Ready Revision.
        """
        return pulumi.get(self, "traffics")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The last-modified time.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Output[builtins.str]:
        """
        (Output)
        Displays the target URI.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def urls(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        All URLs serving traffic for this Service.
        """
        return pulumi.get(self, "urls")

