# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRuntimeTemplateIamPolicyResult',
    'AwaitableGetRuntimeTemplateIamPolicyResult',
    'get_runtime_template_iam_policy',
    'get_runtime_template_iam_policy_output',
]

@pulumi.output_type
class GetRuntimeTemplateIamPolicyResult:
    """
    A collection of values returned by getRuntimeTemplateIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, location=None, policy_data=None, project=None, runtime_template=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if runtime_template and not isinstance(runtime_template, str):
            raise TypeError("Expected argument 'runtime_template' to be a str")
        pulumi.set(__self__, "runtime_template", runtime_template)

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> builtins.str:
        """
        (Required only by `colab.RuntimeTemplateIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="runtimeTemplate")
    def runtime_template(self) -> builtins.str:
        return pulumi.get(self, "runtime_template")


class AwaitableGetRuntimeTemplateIamPolicyResult(GetRuntimeTemplateIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuntimeTemplateIamPolicyResult(
            etag=self.etag,
            id=self.id,
            location=self.location,
            policy_data=self.policy_data,
            project=self.project,
            runtime_template=self.runtime_template)


def get_runtime_template_iam_policy(location: Optional[builtins.str] = None,
                                    project: Optional[builtins.str] = None,
                                    runtime_template: Optional[builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuntimeTemplateIamPolicyResult:
    """
    Retrieves the current IAM policy data for runtimetemplate

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.colab.get_runtime_template_iam_policy(project=runtime_template["project"],
        location=runtime_template["location"],
        runtime_template=runtime_template["name"])
    ```


    :param builtins.str location: The location for the resource: https://cloud.google.com/colab/docs/locations Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param builtins.str runtime_template: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['runtimeTemplate'] = runtime_template
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:colab/getRuntimeTemplateIamPolicy:getRuntimeTemplateIamPolicy', __args__, opts=opts, typ=GetRuntimeTemplateIamPolicyResult).value

    return AwaitableGetRuntimeTemplateIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'),
        runtime_template=pulumi.get(__ret__, 'runtime_template'))
def get_runtime_template_iam_policy_output(location: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                           project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                           runtime_template: Optional[pulumi.Input[builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRuntimeTemplateIamPolicyResult]:
    """
    Retrieves the current IAM policy data for runtimetemplate

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.colab.get_runtime_template_iam_policy(project=runtime_template["project"],
        location=runtime_template["location"],
        runtime_template=runtime_template["name"])
    ```


    :param builtins.str location: The location for the resource: https://cloud.google.com/colab/docs/locations Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param builtins.str runtime_template: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['runtimeTemplate'] = runtime_template
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:colab/getRuntimeTemplateIamPolicy:getRuntimeTemplateIamPolicy', __args__, opts=opts, typ=GetRuntimeTemplateIamPolicyResult)
    return __ret__.apply(lambda __response__: GetRuntimeTemplateIamPolicyResult(
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project'),
        runtime_template=pulumi.get(__response__, 'runtime_template')))
