# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuntimeTemplateArgs', 'RuntimeTemplate']

@pulumi.input_type
class RuntimeTemplateArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 data_persistent_disk_spec: Optional[pulumi.Input['RuntimeTemplateDataPersistentDiskSpecArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_spec: Optional[pulumi.Input['RuntimeTemplateEncryptionSpecArgs']] = None,
                 euc_config: Optional[pulumi.Input['RuntimeTemplateEucConfigArgs']] = None,
                 idle_shutdown_config: Optional[pulumi.Input['RuntimeTemplateIdleShutdownConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 machine_spec: Optional[pulumi.Input['RuntimeTemplateMachineSpecArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_spec: Optional[pulumi.Input['RuntimeTemplateNetworkSpecArgs']] = None,
                 network_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 shielded_vm_config: Optional[pulumi.Input['RuntimeTemplateShieldedVmConfigArgs']] = None,
                 software_config: Optional[pulumi.Input['RuntimeTemplateSoftwareConfigArgs']] = None):
        """
        The set of arguments for constructing a RuntimeTemplate resource.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the Runtime Template.
        :param pulumi.Input[builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
               
               
               - - -
        :param pulumi.Input['RuntimeTemplateDataPersistentDiskSpecArgs'] data_persistent_disk_spec: The configuration for the data disk of the runtime.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: The description of the Runtime Template.
        :param pulumi.Input['RuntimeTemplateEncryptionSpecArgs'] encryption_spec: Customer-managed encryption key spec for the notebook runtime.
               Structure is documented below.
        :param pulumi.Input['RuntimeTemplateEucConfigArgs'] euc_config: EUC configuration of the NotebookRuntimeTemplate.
               Structure is documented below.
        :param pulumi.Input['RuntimeTemplateIdleShutdownConfigArgs'] idle_shutdown_config: Notebook Idle Shutdown configuration for the runtime.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to identify and group the runtime template.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['RuntimeTemplateMachineSpecArgs'] machine_spec: 'The machine configuration of the runtime.'
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of the Runtime Template
        :param pulumi.Input['RuntimeTemplateNetworkSpecArgs'] network_spec: The network configuration for the runtime.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] network_tags: Applies the given Compute Engine tags to the runtime.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['RuntimeTemplateShieldedVmConfigArgs'] shielded_vm_config: Runtime Shielded VM spec.
               Structure is documented below.
        :param pulumi.Input['RuntimeTemplateSoftwareConfigArgs'] software_config: The notebook software configuration of the notebook runtime.
               Structure is documented below.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        if data_persistent_disk_spec is not None:
            pulumi.set(__self__, "data_persistent_disk_spec", data_persistent_disk_spec)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_spec is not None:
            pulumi.set(__self__, "encryption_spec", encryption_spec)
        if euc_config is not None:
            pulumi.set(__self__, "euc_config", euc_config)
        if idle_shutdown_config is not None:
            pulumi.set(__self__, "idle_shutdown_config", idle_shutdown_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if machine_spec is not None:
            pulumi.set(__self__, "machine_spec", machine_spec)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_spec is not None:
            pulumi.set(__self__, "network_spec", network_spec)
        if network_tags is not None:
            pulumi.set(__self__, "network_tags", network_tags)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if shielded_vm_config is not None:
            pulumi.set(__self__, "shielded_vm_config", shielded_vm_config)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        Required. The display name of the Runtime Template.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location for the resource: https://cloud.google.com/colab/docs/locations


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="dataPersistentDiskSpec")
    def data_persistent_disk_spec(self) -> Optional[pulumi.Input['RuntimeTemplateDataPersistentDiskSpecArgs']]:
        """
        The configuration for the data disk of the runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "data_persistent_disk_spec")

    @data_persistent_disk_spec.setter
    def data_persistent_disk_spec(self, value: Optional[pulumi.Input['RuntimeTemplateDataPersistentDiskSpecArgs']]):
        pulumi.set(self, "data_persistent_disk_spec", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Runtime Template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionSpec")
    def encryption_spec(self) -> Optional[pulumi.Input['RuntimeTemplateEncryptionSpecArgs']]:
        """
        Customer-managed encryption key spec for the notebook runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_spec")

    @encryption_spec.setter
    def encryption_spec(self, value: Optional[pulumi.Input['RuntimeTemplateEncryptionSpecArgs']]):
        pulumi.set(self, "encryption_spec", value)

    @property
    @pulumi.getter(name="eucConfig")
    def euc_config(self) -> Optional[pulumi.Input['RuntimeTemplateEucConfigArgs']]:
        """
        EUC configuration of the NotebookRuntimeTemplate.
        Structure is documented below.
        """
        return pulumi.get(self, "euc_config")

    @euc_config.setter
    def euc_config(self, value: Optional[pulumi.Input['RuntimeTemplateEucConfigArgs']]):
        pulumi.set(self, "euc_config", value)

    @property
    @pulumi.getter(name="idleShutdownConfig")
    def idle_shutdown_config(self) -> Optional[pulumi.Input['RuntimeTemplateIdleShutdownConfigArgs']]:
        """
        Notebook Idle Shutdown configuration for the runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "idle_shutdown_config")

    @idle_shutdown_config.setter
    def idle_shutdown_config(self, value: Optional[pulumi.Input['RuntimeTemplateIdleShutdownConfigArgs']]):
        pulumi.set(self, "idle_shutdown_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels to identify and group the runtime template.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="machineSpec")
    def machine_spec(self) -> Optional[pulumi.Input['RuntimeTemplateMachineSpecArgs']]:
        """
        'The machine configuration of the runtime.'
        Structure is documented below.
        """
        return pulumi.get(self, "machine_spec")

    @machine_spec.setter
    def machine_spec(self, value: Optional[pulumi.Input['RuntimeTemplateMachineSpecArgs']]):
        pulumi.set(self, "machine_spec", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Runtime Template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkSpec")
    def network_spec(self) -> Optional[pulumi.Input['RuntimeTemplateNetworkSpecArgs']]:
        """
        The network configuration for the runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "network_spec")

    @network_spec.setter
    def network_spec(self, value: Optional[pulumi.Input['RuntimeTemplateNetworkSpecArgs']]):
        pulumi.set(self, "network_spec", value)

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Applies the given Compute Engine tags to the runtime.
        """
        return pulumi.get(self, "network_tags")

    @network_tags.setter
    def network_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "network_tags", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="shieldedVmConfig")
    def shielded_vm_config(self) -> Optional[pulumi.Input['RuntimeTemplateShieldedVmConfigArgs']]:
        """
        Runtime Shielded VM spec.
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_vm_config")

    @shielded_vm_config.setter
    def shielded_vm_config(self, value: Optional[pulumi.Input['RuntimeTemplateShieldedVmConfigArgs']]):
        pulumi.set(self, "shielded_vm_config", value)

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional[pulumi.Input['RuntimeTemplateSoftwareConfigArgs']]:
        """
        The notebook software configuration of the notebook runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "software_config")

    @software_config.setter
    def software_config(self, value: Optional[pulumi.Input['RuntimeTemplateSoftwareConfigArgs']]):
        pulumi.set(self, "software_config", value)


@pulumi.input_type
class _RuntimeTemplateState:
    def __init__(__self__, *,
                 data_persistent_disk_spec: Optional[pulumi.Input['RuntimeTemplateDataPersistentDiskSpecArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 encryption_spec: Optional[pulumi.Input['RuntimeTemplateEncryptionSpecArgs']] = None,
                 euc_config: Optional[pulumi.Input['RuntimeTemplateEucConfigArgs']] = None,
                 idle_shutdown_config: Optional[pulumi.Input['RuntimeTemplateIdleShutdownConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 machine_spec: Optional[pulumi.Input['RuntimeTemplateMachineSpecArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_spec: Optional[pulumi.Input['RuntimeTemplateNetworkSpecArgs']] = None,
                 network_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 shielded_vm_config: Optional[pulumi.Input['RuntimeTemplateShieldedVmConfigArgs']] = None,
                 software_config: Optional[pulumi.Input['RuntimeTemplateSoftwareConfigArgs']] = None):
        """
        Input properties used for looking up and filtering RuntimeTemplate resources.
        :param pulumi.Input['RuntimeTemplateDataPersistentDiskSpecArgs'] data_persistent_disk_spec: The configuration for the data disk of the runtime.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: The description of the Runtime Template.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the Runtime Template.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['RuntimeTemplateEncryptionSpecArgs'] encryption_spec: Customer-managed encryption key spec for the notebook runtime.
               Structure is documented below.
        :param pulumi.Input['RuntimeTemplateEucConfigArgs'] euc_config: EUC configuration of the NotebookRuntimeTemplate.
               Structure is documented below.
        :param pulumi.Input['RuntimeTemplateIdleShutdownConfigArgs'] idle_shutdown_config: Notebook Idle Shutdown configuration for the runtime.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to identify and group the runtime template.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
               
               
               - - -
        :param pulumi.Input['RuntimeTemplateMachineSpecArgs'] machine_spec: 'The machine configuration of the runtime.'
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of the Runtime Template
        :param pulumi.Input['RuntimeTemplateNetworkSpecArgs'] network_spec: The network configuration for the runtime.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] network_tags: Applies the given Compute Engine tags to the runtime.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['RuntimeTemplateShieldedVmConfigArgs'] shielded_vm_config: Runtime Shielded VM spec.
               Structure is documented below.
        :param pulumi.Input['RuntimeTemplateSoftwareConfigArgs'] software_config: The notebook software configuration of the notebook runtime.
               Structure is documented below.
        """
        if data_persistent_disk_spec is not None:
            pulumi.set(__self__, "data_persistent_disk_spec", data_persistent_disk_spec)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if encryption_spec is not None:
            pulumi.set(__self__, "encryption_spec", encryption_spec)
        if euc_config is not None:
            pulumi.set(__self__, "euc_config", euc_config)
        if idle_shutdown_config is not None:
            pulumi.set(__self__, "idle_shutdown_config", idle_shutdown_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if machine_spec is not None:
            pulumi.set(__self__, "machine_spec", machine_spec)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_spec is not None:
            pulumi.set(__self__, "network_spec", network_spec)
        if network_tags is not None:
            pulumi.set(__self__, "network_tags", network_tags)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if shielded_vm_config is not None:
            pulumi.set(__self__, "shielded_vm_config", shielded_vm_config)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)

    @property
    @pulumi.getter(name="dataPersistentDiskSpec")
    def data_persistent_disk_spec(self) -> Optional[pulumi.Input['RuntimeTemplateDataPersistentDiskSpecArgs']]:
        """
        The configuration for the data disk of the runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "data_persistent_disk_spec")

    @data_persistent_disk_spec.setter
    def data_persistent_disk_spec(self, value: Optional[pulumi.Input['RuntimeTemplateDataPersistentDiskSpecArgs']]):
        pulumi.set(self, "data_persistent_disk_spec", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Runtime Template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. The display name of the Runtime Template.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="encryptionSpec")
    def encryption_spec(self) -> Optional[pulumi.Input['RuntimeTemplateEncryptionSpecArgs']]:
        """
        Customer-managed encryption key spec for the notebook runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_spec")

    @encryption_spec.setter
    def encryption_spec(self, value: Optional[pulumi.Input['RuntimeTemplateEncryptionSpecArgs']]):
        pulumi.set(self, "encryption_spec", value)

    @property
    @pulumi.getter(name="eucConfig")
    def euc_config(self) -> Optional[pulumi.Input['RuntimeTemplateEucConfigArgs']]:
        """
        EUC configuration of the NotebookRuntimeTemplate.
        Structure is documented below.
        """
        return pulumi.get(self, "euc_config")

    @euc_config.setter
    def euc_config(self, value: Optional[pulumi.Input['RuntimeTemplateEucConfigArgs']]):
        pulumi.set(self, "euc_config", value)

    @property
    @pulumi.getter(name="idleShutdownConfig")
    def idle_shutdown_config(self) -> Optional[pulumi.Input['RuntimeTemplateIdleShutdownConfigArgs']]:
        """
        Notebook Idle Shutdown configuration for the runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "idle_shutdown_config")

    @idle_shutdown_config.setter
    def idle_shutdown_config(self, value: Optional[pulumi.Input['RuntimeTemplateIdleShutdownConfigArgs']]):
        pulumi.set(self, "idle_shutdown_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels to identify and group the runtime template.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location for the resource: https://cloud.google.com/colab/docs/locations


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="machineSpec")
    def machine_spec(self) -> Optional[pulumi.Input['RuntimeTemplateMachineSpecArgs']]:
        """
        'The machine configuration of the runtime.'
        Structure is documented below.
        """
        return pulumi.get(self, "machine_spec")

    @machine_spec.setter
    def machine_spec(self, value: Optional[pulumi.Input['RuntimeTemplateMachineSpecArgs']]):
        pulumi.set(self, "machine_spec", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Runtime Template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkSpec")
    def network_spec(self) -> Optional[pulumi.Input['RuntimeTemplateNetworkSpecArgs']]:
        """
        The network configuration for the runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "network_spec")

    @network_spec.setter
    def network_spec(self, value: Optional[pulumi.Input['RuntimeTemplateNetworkSpecArgs']]):
        pulumi.set(self, "network_spec", value)

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Applies the given Compute Engine tags to the runtime.
        """
        return pulumi.get(self, "network_tags")

    @network_tags.setter
    def network_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "network_tags", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="shieldedVmConfig")
    def shielded_vm_config(self) -> Optional[pulumi.Input['RuntimeTemplateShieldedVmConfigArgs']]:
        """
        Runtime Shielded VM spec.
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_vm_config")

    @shielded_vm_config.setter
    def shielded_vm_config(self, value: Optional[pulumi.Input['RuntimeTemplateShieldedVmConfigArgs']]):
        pulumi.set(self, "shielded_vm_config", value)

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional[pulumi.Input['RuntimeTemplateSoftwareConfigArgs']]:
        """
        The notebook software configuration of the notebook runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "software_config")

    @software_config.setter
    def software_config(self, value: Optional[pulumi.Input['RuntimeTemplateSoftwareConfigArgs']]):
        pulumi.set(self, "software_config", value)


@pulumi.type_token("gcp:colab/runtimeTemplate:RuntimeTemplate")
class RuntimeTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_persistent_disk_spec: Optional[pulumi.Input[Union['RuntimeTemplateDataPersistentDiskSpecArgs', 'RuntimeTemplateDataPersistentDiskSpecArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_spec: Optional[pulumi.Input[Union['RuntimeTemplateEncryptionSpecArgs', 'RuntimeTemplateEncryptionSpecArgsDict']]] = None,
                 euc_config: Optional[pulumi.Input[Union['RuntimeTemplateEucConfigArgs', 'RuntimeTemplateEucConfigArgsDict']]] = None,
                 idle_shutdown_config: Optional[pulumi.Input[Union['RuntimeTemplateIdleShutdownConfigArgs', 'RuntimeTemplateIdleShutdownConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 machine_spec: Optional[pulumi.Input[Union['RuntimeTemplateMachineSpecArgs', 'RuntimeTemplateMachineSpecArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_spec: Optional[pulumi.Input[Union['RuntimeTemplateNetworkSpecArgs', 'RuntimeTemplateNetworkSpecArgsDict']]] = None,
                 network_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 shielded_vm_config: Optional[pulumi.Input[Union['RuntimeTemplateShieldedVmConfigArgs', 'RuntimeTemplateShieldedVmConfigArgsDict']]] = None,
                 software_config: Optional[pulumi.Input[Union['RuntimeTemplateSoftwareConfigArgs', 'RuntimeTemplateSoftwareConfigArgsDict']]] = None,
                 __props__=None):
        """
        'A runtime template is a VM configuration that specifies a machine type and other characteristics of the VM,
         as well as common settings such as the network and whether public internet access is enabled. When you create
         a runtime, its VM is created according to the specifications of a runtime template.'

        To get more information about RuntimeTemplate, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.notebookRuntimeTemplates)
        * How-to Guides
            * [Create a runtime template](https://cloud.google.com/colab/docs/create-runtime-template)

        ## Example Usage

        ### Colab Runtime Template Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        runtime_template = gcp.colab.RuntimeTemplate("runtime-template",
            name="colab-runtime-template",
            display_name="Runtime template basic",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        ```
        ### Colab Runtime Template No Name

        ```python
        import pulumi
        import pulumi_gcp as gcp

        runtime_template = gcp.colab.RuntimeTemplate("runtime-template",
            display_name="Runtime template no name",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        ```
        ### Colab Runtime Template Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_network = gcp.compute.Network("my_network",
            name="colab-test-default",
            auto_create_subnetworks=False)
        my_subnetwork = gcp.compute.Subnetwork("my_subnetwork",
            name="colab-test-default",
            network=my_network.id,
            region="us-central1",
            ip_cidr_range="10.0.1.0/24")
        runtime_template = gcp.colab.RuntimeTemplate("runtime-template",
            name="colab-runtime-template",
            display_name="Runtime template full",
            location="us-central1",
            description="Full runtime template",
            machine_spec={
                "machine_type": "n1-standard-2",
                "accelerator_type": "NVIDIA_TESLA_T4",
                "accelerator_count": 1,
            },
            data_persistent_disk_spec={
                "disk_type": "pd-standard",
                "disk_size_gb": "200",
            },
            network_spec={
                "enable_internet_access": True,
                "network": my_network.id,
                "subnetwork": my_subnetwork.id,
            },
            labels={
                "k": "val",
            },
            idle_shutdown_config={
                "idle_timeout": "3600s",
            },
            euc_config={
                "euc_disabled": False,
            },
            shielded_vm_config={
                "enable_secure_boot": False,
            },
            network_tags=[
                "abc",
                "def",
            ],
            encryption_spec={
                "kms_key_name": "my-crypto-key",
            })
        ```

        ## Import

        RuntimeTemplate can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/notebookRuntimeTemplates/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, RuntimeTemplate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:colab/runtimeTemplate:RuntimeTemplate default projects/{{project}}/locations/{{location}}/notebookRuntimeTemplates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:colab/runtimeTemplate:RuntimeTemplate default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:colab/runtimeTemplate:RuntimeTemplate default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RuntimeTemplateDataPersistentDiskSpecArgs', 'RuntimeTemplateDataPersistentDiskSpecArgsDict']] data_persistent_disk_spec: The configuration for the data disk of the runtime.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: The description of the Runtime Template.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the Runtime Template.
        :param pulumi.Input[Union['RuntimeTemplateEncryptionSpecArgs', 'RuntimeTemplateEncryptionSpecArgsDict']] encryption_spec: Customer-managed encryption key spec for the notebook runtime.
               Structure is documented below.
        :param pulumi.Input[Union['RuntimeTemplateEucConfigArgs', 'RuntimeTemplateEucConfigArgsDict']] euc_config: EUC configuration of the NotebookRuntimeTemplate.
               Structure is documented below.
        :param pulumi.Input[Union['RuntimeTemplateIdleShutdownConfigArgs', 'RuntimeTemplateIdleShutdownConfigArgsDict']] idle_shutdown_config: Notebook Idle Shutdown configuration for the runtime.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to identify and group the runtime template.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
               
               
               - - -
        :param pulumi.Input[Union['RuntimeTemplateMachineSpecArgs', 'RuntimeTemplateMachineSpecArgsDict']] machine_spec: 'The machine configuration of the runtime.'
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of the Runtime Template
        :param pulumi.Input[Union['RuntimeTemplateNetworkSpecArgs', 'RuntimeTemplateNetworkSpecArgsDict']] network_spec: The network configuration for the runtime.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] network_tags: Applies the given Compute Engine tags to the runtime.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['RuntimeTemplateShieldedVmConfigArgs', 'RuntimeTemplateShieldedVmConfigArgsDict']] shielded_vm_config: Runtime Shielded VM spec.
               Structure is documented below.
        :param pulumi.Input[Union['RuntimeTemplateSoftwareConfigArgs', 'RuntimeTemplateSoftwareConfigArgsDict']] software_config: The notebook software configuration of the notebook runtime.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuntimeTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        'A runtime template is a VM configuration that specifies a machine type and other characteristics of the VM,
         as well as common settings such as the network and whether public internet access is enabled. When you create
         a runtime, its VM is created according to the specifications of a runtime template.'

        To get more information about RuntimeTemplate, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.notebookRuntimeTemplates)
        * How-to Guides
            * [Create a runtime template](https://cloud.google.com/colab/docs/create-runtime-template)

        ## Example Usage

        ### Colab Runtime Template Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        runtime_template = gcp.colab.RuntimeTemplate("runtime-template",
            name="colab-runtime-template",
            display_name="Runtime template basic",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        ```
        ### Colab Runtime Template No Name

        ```python
        import pulumi
        import pulumi_gcp as gcp

        runtime_template = gcp.colab.RuntimeTemplate("runtime-template",
            display_name="Runtime template no name",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        ```
        ### Colab Runtime Template Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_network = gcp.compute.Network("my_network",
            name="colab-test-default",
            auto_create_subnetworks=False)
        my_subnetwork = gcp.compute.Subnetwork("my_subnetwork",
            name="colab-test-default",
            network=my_network.id,
            region="us-central1",
            ip_cidr_range="10.0.1.0/24")
        runtime_template = gcp.colab.RuntimeTemplate("runtime-template",
            name="colab-runtime-template",
            display_name="Runtime template full",
            location="us-central1",
            description="Full runtime template",
            machine_spec={
                "machine_type": "n1-standard-2",
                "accelerator_type": "NVIDIA_TESLA_T4",
                "accelerator_count": 1,
            },
            data_persistent_disk_spec={
                "disk_type": "pd-standard",
                "disk_size_gb": "200",
            },
            network_spec={
                "enable_internet_access": True,
                "network": my_network.id,
                "subnetwork": my_subnetwork.id,
            },
            labels={
                "k": "val",
            },
            idle_shutdown_config={
                "idle_timeout": "3600s",
            },
            euc_config={
                "euc_disabled": False,
            },
            shielded_vm_config={
                "enable_secure_boot": False,
            },
            network_tags=[
                "abc",
                "def",
            ],
            encryption_spec={
                "kms_key_name": "my-crypto-key",
            })
        ```

        ## Import

        RuntimeTemplate can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/notebookRuntimeTemplates/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, RuntimeTemplate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:colab/runtimeTemplate:RuntimeTemplate default projects/{{project}}/locations/{{location}}/notebookRuntimeTemplates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:colab/runtimeTemplate:RuntimeTemplate default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:colab/runtimeTemplate:RuntimeTemplate default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RuntimeTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuntimeTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_persistent_disk_spec: Optional[pulumi.Input[Union['RuntimeTemplateDataPersistentDiskSpecArgs', 'RuntimeTemplateDataPersistentDiskSpecArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_spec: Optional[pulumi.Input[Union['RuntimeTemplateEncryptionSpecArgs', 'RuntimeTemplateEncryptionSpecArgsDict']]] = None,
                 euc_config: Optional[pulumi.Input[Union['RuntimeTemplateEucConfigArgs', 'RuntimeTemplateEucConfigArgsDict']]] = None,
                 idle_shutdown_config: Optional[pulumi.Input[Union['RuntimeTemplateIdleShutdownConfigArgs', 'RuntimeTemplateIdleShutdownConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 machine_spec: Optional[pulumi.Input[Union['RuntimeTemplateMachineSpecArgs', 'RuntimeTemplateMachineSpecArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_spec: Optional[pulumi.Input[Union['RuntimeTemplateNetworkSpecArgs', 'RuntimeTemplateNetworkSpecArgsDict']]] = None,
                 network_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 shielded_vm_config: Optional[pulumi.Input[Union['RuntimeTemplateShieldedVmConfigArgs', 'RuntimeTemplateShieldedVmConfigArgsDict']]] = None,
                 software_config: Optional[pulumi.Input[Union['RuntimeTemplateSoftwareConfigArgs', 'RuntimeTemplateSoftwareConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuntimeTemplateArgs.__new__(RuntimeTemplateArgs)

            __props__.__dict__["data_persistent_disk_spec"] = data_persistent_disk_spec
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["encryption_spec"] = encryption_spec
            __props__.__dict__["euc_config"] = euc_config
            __props__.__dict__["idle_shutdown_config"] = idle_shutdown_config
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["machine_spec"] = machine_spec
            __props__.__dict__["name"] = name
            __props__.__dict__["network_spec"] = network_spec
            __props__.__dict__["network_tags"] = network_tags
            __props__.__dict__["project"] = project
            __props__.__dict__["shielded_vm_config"] = shielded_vm_config
            __props__.__dict__["software_config"] = software_config
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RuntimeTemplate, __self__).__init__(
            'gcp:colab/runtimeTemplate:RuntimeTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_persistent_disk_spec: Optional[pulumi.Input[Union['RuntimeTemplateDataPersistentDiskSpecArgs', 'RuntimeTemplateDataPersistentDiskSpecArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            encryption_spec: Optional[pulumi.Input[Union['RuntimeTemplateEncryptionSpecArgs', 'RuntimeTemplateEncryptionSpecArgsDict']]] = None,
            euc_config: Optional[pulumi.Input[Union['RuntimeTemplateEucConfigArgs', 'RuntimeTemplateEucConfigArgsDict']]] = None,
            idle_shutdown_config: Optional[pulumi.Input[Union['RuntimeTemplateIdleShutdownConfigArgs', 'RuntimeTemplateIdleShutdownConfigArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            machine_spec: Optional[pulumi.Input[Union['RuntimeTemplateMachineSpecArgs', 'RuntimeTemplateMachineSpecArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_spec: Optional[pulumi.Input[Union['RuntimeTemplateNetworkSpecArgs', 'RuntimeTemplateNetworkSpecArgsDict']]] = None,
            network_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            shielded_vm_config: Optional[pulumi.Input[Union['RuntimeTemplateShieldedVmConfigArgs', 'RuntimeTemplateShieldedVmConfigArgsDict']]] = None,
            software_config: Optional[pulumi.Input[Union['RuntimeTemplateSoftwareConfigArgs', 'RuntimeTemplateSoftwareConfigArgsDict']]] = None) -> 'RuntimeTemplate':
        """
        Get an existing RuntimeTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RuntimeTemplateDataPersistentDiskSpecArgs', 'RuntimeTemplateDataPersistentDiskSpecArgsDict']] data_persistent_disk_spec: The configuration for the data disk of the runtime.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: The description of the Runtime Template.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the Runtime Template.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['RuntimeTemplateEncryptionSpecArgs', 'RuntimeTemplateEncryptionSpecArgsDict']] encryption_spec: Customer-managed encryption key spec for the notebook runtime.
               Structure is documented below.
        :param pulumi.Input[Union['RuntimeTemplateEucConfigArgs', 'RuntimeTemplateEucConfigArgsDict']] euc_config: EUC configuration of the NotebookRuntimeTemplate.
               Structure is documented below.
        :param pulumi.Input[Union['RuntimeTemplateIdleShutdownConfigArgs', 'RuntimeTemplateIdleShutdownConfigArgsDict']] idle_shutdown_config: Notebook Idle Shutdown configuration for the runtime.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to identify and group the runtime template.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
               
               
               - - -
        :param pulumi.Input[Union['RuntimeTemplateMachineSpecArgs', 'RuntimeTemplateMachineSpecArgsDict']] machine_spec: 'The machine configuration of the runtime.'
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of the Runtime Template
        :param pulumi.Input[Union['RuntimeTemplateNetworkSpecArgs', 'RuntimeTemplateNetworkSpecArgsDict']] network_spec: The network configuration for the runtime.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] network_tags: Applies the given Compute Engine tags to the runtime.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['RuntimeTemplateShieldedVmConfigArgs', 'RuntimeTemplateShieldedVmConfigArgsDict']] shielded_vm_config: Runtime Shielded VM spec.
               Structure is documented below.
        :param pulumi.Input[Union['RuntimeTemplateSoftwareConfigArgs', 'RuntimeTemplateSoftwareConfigArgsDict']] software_config: The notebook software configuration of the notebook runtime.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuntimeTemplateState.__new__(_RuntimeTemplateState)

        __props__.__dict__["data_persistent_disk_spec"] = data_persistent_disk_spec
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["encryption_spec"] = encryption_spec
        __props__.__dict__["euc_config"] = euc_config
        __props__.__dict__["idle_shutdown_config"] = idle_shutdown_config
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["machine_spec"] = machine_spec
        __props__.__dict__["name"] = name
        __props__.__dict__["network_spec"] = network_spec
        __props__.__dict__["network_tags"] = network_tags
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["shielded_vm_config"] = shielded_vm_config
        __props__.__dict__["software_config"] = software_config
        return RuntimeTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataPersistentDiskSpec")
    def data_persistent_disk_spec(self) -> pulumi.Output['outputs.RuntimeTemplateDataPersistentDiskSpec']:
        """
        The configuration for the data disk of the runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "data_persistent_disk_spec")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Runtime Template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Required. The display name of the Runtime Template.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="encryptionSpec")
    def encryption_spec(self) -> pulumi.Output[Optional['outputs.RuntimeTemplateEncryptionSpec']]:
        """
        Customer-managed encryption key spec for the notebook runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_spec")

    @property
    @pulumi.getter(name="eucConfig")
    def euc_config(self) -> pulumi.Output['outputs.RuntimeTemplateEucConfig']:
        """
        EUC configuration of the NotebookRuntimeTemplate.
        Structure is documented below.
        """
        return pulumi.get(self, "euc_config")

    @property
    @pulumi.getter(name="idleShutdownConfig")
    def idle_shutdown_config(self) -> pulumi.Output['outputs.RuntimeTemplateIdleShutdownConfig']:
        """
        Notebook Idle Shutdown configuration for the runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "idle_shutdown_config")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Labels to identify and group the runtime template.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location for the resource: https://cloud.google.com/colab/docs/locations


        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="machineSpec")
    def machine_spec(self) -> pulumi.Output['outputs.RuntimeTemplateMachineSpec']:
        """
        'The machine configuration of the runtime.'
        Structure is documented below.
        """
        return pulumi.get(self, "machine_spec")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the Runtime Template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkSpec")
    def network_spec(self) -> pulumi.Output['outputs.RuntimeTemplateNetworkSpec']:
        """
        The network configuration for the runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "network_spec")

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Applies the given Compute Engine tags to the runtime.
        """
        return pulumi.get(self, "network_tags")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="shieldedVmConfig")
    def shielded_vm_config(self) -> pulumi.Output['outputs.RuntimeTemplateShieldedVmConfig']:
        """
        Runtime Shielded VM spec.
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_vm_config")

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> pulumi.Output['outputs.RuntimeTemplateSoftwareConfig']:
        """
        The notebook software configuration of the notebook runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "software_config")

