# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserWorkloadsSecretArgs', 'UserWorkloadsSecret']

@pulumi.input_type
class UserWorkloadsSecretArgs:
    def __init__(__self__, *,
                 environment: pulumi.Input[builtins.str],
                 data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a UserWorkloadsSecret resource.
        :param pulumi.Input[builtins.str] environment: Environment where the Kubernetes Secret will be stored and used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] data: A map of the secret data.
        :param pulumi.Input[builtins.str] name: Name of the Kubernetes Secret.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The location or Compute Engine region for the environment.
        """
        pulumi.set(__self__, "environment", environment)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Input[builtins.str]:
        """
        Environment where the Kubernetes Secret will be stored and used.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of the secret data.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Kubernetes Secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location or Compute Engine region for the environment.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _UserWorkloadsSecretState:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserWorkloadsSecret resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] data: A map of the secret data.
        :param pulumi.Input[builtins.str] environment: Environment where the Kubernetes Secret will be stored and used.
        :param pulumi.Input[builtins.str] name: Name of the Kubernetes Secret.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The location or Compute Engine region for the environment.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of the secret data.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Environment where the Kubernetes Secret will be stored and used.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Kubernetes Secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location or Compute Engine region for the environment.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("gcp:composer/userWorkloadsSecret:UserWorkloadsSecret")
class UserWorkloadsSecret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        User workloads Secret used by Airflow tasks that run with Kubernetes Executor or KubernetesPodOperator.
        Intended for Composer 3 Environments.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        example = gcp.composer.Environment("example",
            name="example-environment",
            project="example-project",
            region="us-central1",
            config={
                "software_config": {
                    "image_version": "example-image-version",
                },
            })
        example_user_workloads_secret = gcp.composer.UserWorkloadsSecret("example",
            name="example-secret",
            project="example-project",
            region="us-central1",
            environment=example.name,
            data={
                "email": std.base64encode(input="example-email").result,
                "password": std.base64encode(input="example-password").result,
            })
        ```

        ## Import

        Secret can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/environments/{{environment}}/userWorkloadsSecrets/{{name}}`

        * `{{project}}/{{region}}/{{environment}}/{{name}}`

        * `{{environment}}/{{name}}`

        When using the `pulumi import` command, Environment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:composer/userWorkloadsSecret:UserWorkloadsSecret example projects/{{project}}/locations/{{region}}/environments/{{environment}}/userWorkloadsSecrets/{{name}}
        ```

        ```sh
        $ pulumi import gcp:composer/userWorkloadsSecret:UserWorkloadsSecret example {{project}}/{{region}}/{{environment}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:composer/userWorkloadsSecret:UserWorkloadsSecret example {{environment}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] data: A map of the secret data.
        :param pulumi.Input[builtins.str] environment: Environment where the Kubernetes Secret will be stored and used.
        :param pulumi.Input[builtins.str] name: Name of the Kubernetes Secret.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The location or Compute Engine region for the environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserWorkloadsSecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        User workloads Secret used by Airflow tasks that run with Kubernetes Executor or KubernetesPodOperator.
        Intended for Composer 3 Environments.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        example = gcp.composer.Environment("example",
            name="example-environment",
            project="example-project",
            region="us-central1",
            config={
                "software_config": {
                    "image_version": "example-image-version",
                },
            })
        example_user_workloads_secret = gcp.composer.UserWorkloadsSecret("example",
            name="example-secret",
            project="example-project",
            region="us-central1",
            environment=example.name,
            data={
                "email": std.base64encode(input="example-email").result,
                "password": std.base64encode(input="example-password").result,
            })
        ```

        ## Import

        Secret can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/environments/{{environment}}/userWorkloadsSecrets/{{name}}`

        * `{{project}}/{{region}}/{{environment}}/{{name}}`

        * `{{environment}}/{{name}}`

        When using the `pulumi import` command, Environment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:composer/userWorkloadsSecret:UserWorkloadsSecret example projects/{{project}}/locations/{{region}}/environments/{{environment}}/userWorkloadsSecrets/{{name}}
        ```

        ```sh
        $ pulumi import gcp:composer/userWorkloadsSecret:UserWorkloadsSecret example {{project}}/{{region}}/{{environment}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:composer/userWorkloadsSecret:UserWorkloadsSecret example {{environment}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param UserWorkloadsSecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserWorkloadsSecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserWorkloadsSecretArgs.__new__(UserWorkloadsSecretArgs)

            __props__.__dict__["data"] = None if data is None else pulumi.Output.secret(data)
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["data"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(UserWorkloadsSecret, __self__).__init__(
            'gcp:composer/userWorkloadsSecret:UserWorkloadsSecret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            environment: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'UserWorkloadsSecret':
        """
        Get an existing UserWorkloadsSecret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] data: A map of the secret data.
        :param pulumi.Input[builtins.str] environment: Environment where the Kubernetes Secret will be stored and used.
        :param pulumi.Input[builtins.str] name: Name of the Kubernetes Secret.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The location or Compute Engine region for the environment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserWorkloadsSecretState.__new__(_UserWorkloadsSecretState)

        __props__.__dict__["data"] = data
        __props__.__dict__["environment"] = environment
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        return UserWorkloadsSecret(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of the secret data.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[builtins.str]:
        """
        Environment where the Kubernetes Secret will be stored and used.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Kubernetes Secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The location or Compute Engine region for the environment.
        """
        return pulumi.get(self, "region")

