# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AttachedDiskArgs', 'AttachedDisk']

@pulumi.input_type
class AttachedDiskArgs:
    def __init__(__self__, *,
                 disk: pulumi.Input[builtins.str],
                 instance: pulumi.Input[builtins.str],
                 device_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface: Optional[pulumi.Input[builtins.str]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AttachedDisk resource.
        :param pulumi.Input[builtins.str] disk: `name` or `self_link` of the disk that will be attached.
               
               
               - - -
        :param pulumi.Input[builtins.str] instance: `name` or `self_link` of the compute instance that the disk will be attached to.
               If the `self_link` is provided then `zone` and `project` are extracted from the
               self link. If only the name is used then `zone` and `project` must be defined
               as properties on the resource or provider.
        :param pulumi.Input[builtins.str] device_name: Specifies a unique device name of your choice that is
               reflected into the /dev/disk/by-id/google-* tree of a Linux operating
               system running within the instance. This name can be used to
               reference the device for mounting, resizing, and so on, from within
               the instance.
               
               If not specified, the server chooses a default device name to apply
               to this disk, in the form persistent-disks-x, where x is a number
               assigned by Google Compute Engine.
        :param pulumi.Input[builtins.str] interface: The disk interface used for attaching this disk.
               
               This field is only used for specific cases, please don't specify
               this field without advice from Google. Not specifying the field
               will allow the the server to assign the correct interface.
               
               Possible values:
               "SCSI"
               "NVME"
        :param pulumi.Input[builtins.str] mode: The mode in which to attach this disk, either READ_WRITE or
               READ_ONLY. If not specified, the default is to attach the disk in
               READ_WRITE mode.
               
               Possible values:
               "READ_ONLY"
               "READ_WRITE"
        :param pulumi.Input[builtins.str] project: The project that the referenced compute instance is a part of. If `instance` is referenced by its
               `self_link` the project defined in the link will take precedence.
        :param pulumi.Input[builtins.str] zone: The zone that the referenced compute instance is located within. If `instance` is referenced by its
               `self_link` the zone defined in the link will take precedence.
        """
        pulumi.set(__self__, "disk", disk)
        pulumi.set(__self__, "instance", instance)
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def disk(self) -> pulumi.Input[builtins.str]:
        """
        `name` or `self_link` of the disk that will be attached.


        - - -
        """
        return pulumi.get(self, "disk")

    @disk.setter
    def disk(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "disk", value)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Input[builtins.str]:
        """
        `name` or `self_link` of the compute instance that the disk will be attached to.
        If the `self_link` is provided then `zone` and `project` are extracted from the
        self link. If only the name is used then `zone` and `project` must be defined
        as properties on the resource or provider.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a unique device name of your choice that is
        reflected into the /dev/disk/by-id/google-* tree of a Linux operating
        system running within the instance. This name can be used to
        reference the device for mounting, resizing, and so on, from within
        the instance.

        If not specified, the server chooses a default device name to apply
        to this disk, in the form persistent-disks-x, where x is a number
        assigned by Google Compute Engine.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The disk interface used for attaching this disk.

        This field is only used for specific cases, please don't specify
        this field without advice from Google. Not specifying the field
        will allow the the server to assign the correct interface.

        Possible values:
        "SCSI"
        "NVME"
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mode in which to attach this disk, either READ_WRITE or
        READ_ONLY. If not specified, the default is to attach the disk in
        READ_WRITE mode.

        Possible values:
        "READ_ONLY"
        "READ_WRITE"
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project that the referenced compute instance is a part of. If `instance` is referenced by its
        `self_link` the project defined in the link will take precedence.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The zone that the referenced compute instance is located within. If `instance` is referenced by its
        `self_link` the zone defined in the link will take precedence.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _AttachedDiskState:
    def __init__(__self__, *,
                 device_name: Optional[pulumi.Input[builtins.str]] = None,
                 disk: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 interface: Optional[pulumi.Input[builtins.str]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AttachedDisk resources.
        :param pulumi.Input[builtins.str] device_name: Specifies a unique device name of your choice that is
               reflected into the /dev/disk/by-id/google-* tree of a Linux operating
               system running within the instance. This name can be used to
               reference the device for mounting, resizing, and so on, from within
               the instance.
               
               If not specified, the server chooses a default device name to apply
               to this disk, in the form persistent-disks-x, where x is a number
               assigned by Google Compute Engine.
        :param pulumi.Input[builtins.str] disk: `name` or `self_link` of the disk that will be attached.
               
               
               - - -
        :param pulumi.Input[builtins.str] instance: `name` or `self_link` of the compute instance that the disk will be attached to.
               If the `self_link` is provided then `zone` and `project` are extracted from the
               self link. If only the name is used then `zone` and `project` must be defined
               as properties on the resource or provider.
        :param pulumi.Input[builtins.str] interface: The disk interface used for attaching this disk.
               
               This field is only used for specific cases, please don't specify
               this field without advice from Google. Not specifying the field
               will allow the the server to assign the correct interface.
               
               Possible values:
               "SCSI"
               "NVME"
        :param pulumi.Input[builtins.str] mode: The mode in which to attach this disk, either READ_WRITE or
               READ_ONLY. If not specified, the default is to attach the disk in
               READ_WRITE mode.
               
               Possible values:
               "READ_ONLY"
               "READ_WRITE"
        :param pulumi.Input[builtins.str] project: The project that the referenced compute instance is a part of. If `instance` is referenced by its
               `self_link` the project defined in the link will take precedence.
        :param pulumi.Input[builtins.str] zone: The zone that the referenced compute instance is located within. If `instance` is referenced by its
               `self_link` the zone defined in the link will take precedence.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a unique device name of your choice that is
        reflected into the /dev/disk/by-id/google-* tree of a Linux operating
        system running within the instance. This name can be used to
        reference the device for mounting, resizing, and so on, from within
        the instance.

        If not specified, the server chooses a default device name to apply
        to this disk, in the form persistent-disks-x, where x is a number
        assigned by Google Compute Engine.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter
    def disk(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `name` or `self_link` of the disk that will be attached.


        - - -
        """
        return pulumi.get(self, "disk")

    @disk.setter
    def disk(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "disk", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `name` or `self_link` of the compute instance that the disk will be attached to.
        If the `self_link` is provided then `zone` and `project` are extracted from the
        self link. If only the name is used then `zone` and `project` must be defined
        as properties on the resource or provider.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The disk interface used for attaching this disk.

        This field is only used for specific cases, please don't specify
        this field without advice from Google. Not specifying the field
        will allow the the server to assign the correct interface.

        Possible values:
        "SCSI"
        "NVME"
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mode in which to attach this disk, either READ_WRITE or
        READ_ONLY. If not specified, the default is to attach the disk in
        READ_WRITE mode.

        Possible values:
        "READ_ONLY"
        "READ_WRITE"
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project that the referenced compute instance is a part of. If `instance` is referenced by its
        `self_link` the project defined in the link will take precedence.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The zone that the referenced compute instance is located within. If `instance` is referenced by its
        `self_link` the zone defined in the link will take precedence.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:compute/attachedDisk:AttachedDisk")
class AttachedDisk(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device_name: Optional[pulumi.Input[builtins.str]] = None,
                 disk: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 interface: Optional[pulumi.Input[builtins.str]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Persistent disks can be attached to a compute instance using the `attached_disk`
        section within the compute instance configuration.
        However there may be situations where managing the attached disks via the compute
        instance config isn't preferable or possible, such as attaching dynamic
        numbers of disks using the `count` variable.

        To get more information about attaching disks, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/instances/attachDisk)
        * How-to Guides
            * [Adding a persistent disk](https://cloud.google.com/compute/docs/disks/add-persistent-disk)

        **Note:** When using `compute.AttachedDisk` you **must** use `lifecycle.ignore_changes = ["attached_disk"]` on the `compute.Instance` resource that has the disks attached. Otherwise the two resources will fight for control of the attached disk block.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_instance = gcp.compute.Instance("default",
            name="attached-disk-instance",
            machine_type="e2-medium",
            zone="us-west1-a",
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-11",
                },
            },
            network_interfaces=[{
                "network": "default",
            }])
        default = gcp.compute.AttachedDisk("default",
            disk=default_google_compute_disk["id"],
            instance=default_instance.id)
        ```

        ## Import

        Attached Disk can be imported the following ways:

        * `projects/{{project}}/zones/{{zone}}/instances/{{instance.name}}/{{disk.name}}`

        * `{{project}}/{{zone}}/{{instance.name}}/{{disk.name}}`

        When using the `pulumi import` command, Attached Disk can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/attachedDisk:AttachedDisk default projects/{{project}}/zones/{{zone}}/instances/{{instance.name}}/{{disk.name}}
        ```

        ```sh
        $ pulumi import gcp:compute/attachedDisk:AttachedDisk default {{project}}/{{zone}}/{{instance.name}}/{{disk.name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] device_name: Specifies a unique device name of your choice that is
               reflected into the /dev/disk/by-id/google-* tree of a Linux operating
               system running within the instance. This name can be used to
               reference the device for mounting, resizing, and so on, from within
               the instance.
               
               If not specified, the server chooses a default device name to apply
               to this disk, in the form persistent-disks-x, where x is a number
               assigned by Google Compute Engine.
        :param pulumi.Input[builtins.str] disk: `name` or `self_link` of the disk that will be attached.
               
               
               - - -
        :param pulumi.Input[builtins.str] instance: `name` or `self_link` of the compute instance that the disk will be attached to.
               If the `self_link` is provided then `zone` and `project` are extracted from the
               self link. If only the name is used then `zone` and `project` must be defined
               as properties on the resource or provider.
        :param pulumi.Input[builtins.str] interface: The disk interface used for attaching this disk.
               
               This field is only used for specific cases, please don't specify
               this field without advice from Google. Not specifying the field
               will allow the the server to assign the correct interface.
               
               Possible values:
               "SCSI"
               "NVME"
        :param pulumi.Input[builtins.str] mode: The mode in which to attach this disk, either READ_WRITE or
               READ_ONLY. If not specified, the default is to attach the disk in
               READ_WRITE mode.
               
               Possible values:
               "READ_ONLY"
               "READ_WRITE"
        :param pulumi.Input[builtins.str] project: The project that the referenced compute instance is a part of. If `instance` is referenced by its
               `self_link` the project defined in the link will take precedence.
        :param pulumi.Input[builtins.str] zone: The zone that the referenced compute instance is located within. If `instance` is referenced by its
               `self_link` the zone defined in the link will take precedence.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AttachedDiskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Persistent disks can be attached to a compute instance using the `attached_disk`
        section within the compute instance configuration.
        However there may be situations where managing the attached disks via the compute
        instance config isn't preferable or possible, such as attaching dynamic
        numbers of disks using the `count` variable.

        To get more information about attaching disks, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/instances/attachDisk)
        * How-to Guides
            * [Adding a persistent disk](https://cloud.google.com/compute/docs/disks/add-persistent-disk)

        **Note:** When using `compute.AttachedDisk` you **must** use `lifecycle.ignore_changes = ["attached_disk"]` on the `compute.Instance` resource that has the disks attached. Otherwise the two resources will fight for control of the attached disk block.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_instance = gcp.compute.Instance("default",
            name="attached-disk-instance",
            machine_type="e2-medium",
            zone="us-west1-a",
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-11",
                },
            },
            network_interfaces=[{
                "network": "default",
            }])
        default = gcp.compute.AttachedDisk("default",
            disk=default_google_compute_disk["id"],
            instance=default_instance.id)
        ```

        ## Import

        Attached Disk can be imported the following ways:

        * `projects/{{project}}/zones/{{zone}}/instances/{{instance.name}}/{{disk.name}}`

        * `{{project}}/{{zone}}/{{instance.name}}/{{disk.name}}`

        When using the `pulumi import` command, Attached Disk can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/attachedDisk:AttachedDisk default projects/{{project}}/zones/{{zone}}/instances/{{instance.name}}/{{disk.name}}
        ```

        ```sh
        $ pulumi import gcp:compute/attachedDisk:AttachedDisk default {{project}}/{{zone}}/{{instance.name}}/{{disk.name}}
        ```

        :param str resource_name: The name of the resource.
        :param AttachedDiskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AttachedDiskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device_name: Optional[pulumi.Input[builtins.str]] = None,
                 disk: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 interface: Optional[pulumi.Input[builtins.str]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AttachedDiskArgs.__new__(AttachedDiskArgs)

            __props__.__dict__["device_name"] = device_name
            if disk is None and not opts.urn:
                raise TypeError("Missing required property 'disk'")
            __props__.__dict__["disk"] = disk
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            __props__.__dict__["interface"] = interface
            __props__.__dict__["mode"] = mode
            __props__.__dict__["project"] = project
            __props__.__dict__["zone"] = zone
        super(AttachedDisk, __self__).__init__(
            'gcp:compute/attachedDisk:AttachedDisk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            device_name: Optional[pulumi.Input[builtins.str]] = None,
            disk: Optional[pulumi.Input[builtins.str]] = None,
            instance: Optional[pulumi.Input[builtins.str]] = None,
            interface: Optional[pulumi.Input[builtins.str]] = None,
            mode: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'AttachedDisk':
        """
        Get an existing AttachedDisk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] device_name: Specifies a unique device name of your choice that is
               reflected into the /dev/disk/by-id/google-* tree of a Linux operating
               system running within the instance. This name can be used to
               reference the device for mounting, resizing, and so on, from within
               the instance.
               
               If not specified, the server chooses a default device name to apply
               to this disk, in the form persistent-disks-x, where x is a number
               assigned by Google Compute Engine.
        :param pulumi.Input[builtins.str] disk: `name` or `self_link` of the disk that will be attached.
               
               
               - - -
        :param pulumi.Input[builtins.str] instance: `name` or `self_link` of the compute instance that the disk will be attached to.
               If the `self_link` is provided then `zone` and `project` are extracted from the
               self link. If only the name is used then `zone` and `project` must be defined
               as properties on the resource or provider.
        :param pulumi.Input[builtins.str] interface: The disk interface used for attaching this disk.
               
               This field is only used for specific cases, please don't specify
               this field without advice from Google. Not specifying the field
               will allow the the server to assign the correct interface.
               
               Possible values:
               "SCSI"
               "NVME"
        :param pulumi.Input[builtins.str] mode: The mode in which to attach this disk, either READ_WRITE or
               READ_ONLY. If not specified, the default is to attach the disk in
               READ_WRITE mode.
               
               Possible values:
               "READ_ONLY"
               "READ_WRITE"
        :param pulumi.Input[builtins.str] project: The project that the referenced compute instance is a part of. If `instance` is referenced by its
               `self_link` the project defined in the link will take precedence.
        :param pulumi.Input[builtins.str] zone: The zone that the referenced compute instance is located within. If `instance` is referenced by its
               `self_link` the zone defined in the link will take precedence.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AttachedDiskState.__new__(_AttachedDiskState)

        __props__.__dict__["device_name"] = device_name
        __props__.__dict__["disk"] = disk
        __props__.__dict__["instance"] = instance
        __props__.__dict__["interface"] = interface
        __props__.__dict__["mode"] = mode
        __props__.__dict__["project"] = project
        __props__.__dict__["zone"] = zone
        return AttachedDisk(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies a unique device name of your choice that is
        reflected into the /dev/disk/by-id/google-* tree of a Linux operating
        system running within the instance. This name can be used to
        reference the device for mounting, resizing, and so on, from within
        the instance.

        If not specified, the server chooses a default device name to apply
        to this disk, in the form persistent-disks-x, where x is a number
        assigned by Google Compute Engine.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def disk(self) -> pulumi.Output[builtins.str]:
        """
        `name` or `self_link` of the disk that will be attached.


        - - -
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[builtins.str]:
        """
        `name` or `self_link` of the compute instance that the disk will be attached to.
        If the `self_link` is provided then `zone` and `project` are extracted from the
        self link. If only the name is used then `zone` and `project` must be defined
        as properties on the resource or provider.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def interface(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The disk interface used for attaching this disk.

        This field is only used for specific cases, please don't specify
        this field without advice from Google. Not specifying the field
        will allow the the server to assign the correct interface.

        Possible values:
        "SCSI"
        "NVME"
        """
        return pulumi.get(self, "interface")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The mode in which to attach this disk, either READ_WRITE or
        READ_ONLY. If not specified, the default is to attach the disk in
        READ_WRITE mode.

        Possible values:
        "READ_ONLY"
        "READ_WRITE"
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The project that the referenced compute instance is a part of. If `instance` is referenced by its
        `self_link` the project defined in the link will take precedence.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        The zone that the referenced compute instance is located within. If `instance` is referenced by its
        `self_link` the zone defined in the link will take precedence.
        """
        return pulumi.get(self, "zone")

