# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ForwardingRuleArgs', 'ForwardingRule']

@pulumi.input_type
class ForwardingRuleArgs:
    def __init__(__self__, *,
                 all_ports: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_global_access: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_psc_global_access: Optional[pulumi.Input[builtins.bool]] = None,
                 backend_service: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_collection: Optional[pulumi.Input[builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 is_mirroring_collector: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 network_tier: Optional[pulumi.Input[builtins.str]] = None,
                 no_automate_dns_zone: Optional[pulumi.Input[builtins.bool]] = None,
                 port_range: Optional[pulumi.Input[builtins.str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 recreate_closed_psc: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_directory_registrations: Optional[pulumi.Input['ForwardingRuleServiceDirectoryRegistrationsArgs']] = None,
                 service_label: Optional[pulumi.Input[builtins.str]] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ForwardingRule resource.
        :param pulumi.Input[builtins.bool] all_ports: The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
               Only packets addressed to ports in the specified range will be forwarded
               to the backends configured with this forwarding rule.
               The `allPorts` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, SCTP, or
               L3_DEFAULT.
               * It's applicable only to the following products: internal passthrough
               Network Load Balancers, backend service-based external passthrough Network
               Load Balancers, and internal and external protocol forwarding.
               * Set this field to true to allow packets addressed to any port or packets
               lacking destination port information (for example, UDP fragments after the
               first fragment) to be forwarded to the backends configured with this
               forwarding rule. The L3_DEFAULT protocol requires `allPorts` be set to
               true.
        :param pulumi.Input[builtins.bool] allow_global_access: This field is used along with the `backend_service` field for
               internal load balancing or with the `target` field for internal
               TargetInstance.
               If the field is set to `TRUE`, clients can access ILB from all
               regions.
               Otherwise only allows access from clients in the same region as the
               internal load balancer.
        :param pulumi.Input[builtins.bool] allow_psc_global_access: This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        :param pulumi.Input[builtins.str] backend_service: Identifies the backend service to which the forwarding rule sends traffic.
               Required for Internal TCP/UDP Load Balancing and Network Load Balancing;
               must be omitted for all other load balancer types.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[builtins.str] ip_address: IP address for which this forwarding rule accepts traffic. When a client
               sends traffic to this IP address, the forwarding rule directs the traffic
               to the referenced `target` or `backendService`.
               While creating a forwarding rule, specifying an `IPAddress` is
               required under the following circumstances:
               * When the `target` is set to `targetGrpcProxy` and
               `validateForProxyless` is set to `true`, the
               `IPAddress` should be set to `0.0.0.0`.
               * When the `target` is a Private Service Connect Google APIs
               bundle, you must specify an `IPAddress`.
               Otherwise, you can optionally specify an IP address that references an
               existing static (reserved) IP address resource. When omitted, Google Cloud
               assigns an ephemeral IP address.
               Use one of the following formats to specify an IP address while creating a
               forwarding rule:
               * IP address number, as in `100.1.2.3`
               * IPv6 address range, as in `2600:1234::/96`
               * Full resource URL, as in
               `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
               * Partial URL or by name, as in:
               * `projects/project_id/regions/region/addresses/address-name`
               * `regions/region/addresses/address-name`
               * `global/addresses/address-name`
               * `address-name`
               The forwarding rule's `target` or `backendService`,
               and in most cases, also the `loadBalancingScheme`, determine the
               type of IP address that you can use. For detailed information, see
               [IP address
               specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               When reading an `IPAddress`, the API always returns the IP
               address number.
        :param pulumi.Input[builtins.str] ip_collection: Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP
               in EXTERNAL_IPV6_FORWARDING_RULE_CREATION mode.
               Use one of the following formats to specify a sub-PDP when creating an
               IPv6 NetLB forwarding rule using BYOIP:
               Full resource URL, as in:
               * `https://www.googleapis.com/compute/v1/projects/{{projectId}}/regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
               Partial URL, as in:
               * `projects/{{projectId}}/regions/region/publicDelegatedPrefixes/{{sub-pdp-name}}`
               * `regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        :param pulumi.Input[builtins.str] ip_protocol: The IP protocol to which this rule applies.
               For protocol forwarding, valid
               options are `TCP`, `UDP`, `ESP`,
               `AH`, `SCTP`, `ICMP` and
               `L3_DEFAULT`.
               The valid IP protocols are different for different load balancing products
               as described in [Load balancing
               features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
               A Forwarding Rule with protocol L3_DEFAULT can attach with target instance or
               backend service with UNSPECIFIED protocol.
               A forwarding rule with "L3_DEFAULT" IPProtocal cannot be attached to a backend service with TCP or UDP.
               Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`, `L3_DEFAULT`.
        :param pulumi.Input[builtins.str] ip_version: The IP address version that will be used by this forwarding rule.
               Valid options are IPV4 and IPV6.
               If not set, the IPv4 address will be used by default.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[builtins.bool] is_mirroring_collector: Indicates whether or not this load balancer can be used as a collector for
               packet mirroring. To prevent mirroring loops, instances behind this
               load balancer will not have their traffic mirrored even if a
               `PacketMirroring` rule applies to them.
               This can only be set to true for load balancers that have their
               `loadBalancingScheme` set to `INTERNAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] load_balancing_scheme: Specifies the forwarding rule type.
               Note that an empty string value (`""`) is also supported for some use
               cases, for example PSC (private service connection) regional forwarding
               rules.
               For more information about forwarding rules, refer to
               [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, `INTERNAL_MANAGED`.
        :param pulumi.Input[builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, the forwarding rule name must be a 1-20 characters string with
               lowercase letters and numbers and must start with a letter.
               
               
               - - -
        :param pulumi.Input[builtins.str] network: This field is not used for external load balancing.
               For Internal TCP/UDP Load Balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule.
               If the subnetwork is specified, the network of the subnetwork will be used.
               If neither subnetwork nor this field is specified, the default network will
               be used.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, a network must be provided.
        :param pulumi.Input[builtins.str] network_tier: This signifies the networking tier used for configuring
               this load balancer and can only take the following values:
               `PREMIUM`, `STANDARD`.
               For regional ForwardingRule, the valid values are `PREMIUM` and
               `STANDARD`. For GlobalForwardingRule, the valid value is
               `PREMIUM`.
               If this field is not specified, it is assumed to be `PREMIUM`.
               If `IPAddress` is specified, this value must be equal to the
               networkTier of the Address.
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[builtins.bool] no_automate_dns_zone: This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        :param pulumi.Input[builtins.str] port_range: The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
               Only packets addressed to ports in the specified range will be forwarded
               to the backends configured with this forwarding rule.
               The `portRange` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
               and
               * It's applicable only to the following products: external passthrough
               Network Load Balancers, internal and external proxy Network Load
               Balancers, internal and external Application Load Balancers, external
               protocol forwarding, and Classic VPN.
               * Some products have restrictions on what ports can be used. See
               [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
               for details.
               For external forwarding rules, two or more forwarding rules cannot use the
               same `[IPAddress, IPProtocol]` pair, and cannot have overlapping
               `portRange`s.
               For internal forwarding rules within the same VPC network, two or more
               forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair, and
               cannot have overlapping `portRange`s.
               @pattern: \\d+(?:-\\d+)?
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ports: The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
               Only packets addressed to ports in the specified range will be forwarded
               to the backends configured with this forwarding rule.
               The `ports` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
               and
               * It's applicable only to the following products: internal passthrough
               Network Load Balancers, backend service-based external passthrough Network
               Load Balancers, and internal protocol forwarding.
               * You can specify a list of up to five ports by number, separated by
               commas. The ports can be contiguous or discontiguous.
               For external forwarding rules, two or more forwarding rules cannot use the
               same `[IPAddress, IPProtocol]` pair if they share at least one port
               number.
               For internal forwarding rules within the same VPC network, two or more
               forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair if
               they share at least one port number.
               @pattern: \\d+(?:-\\d+)?
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: A reference to the region where the regional forwarding rule resides.
               This field is not applicable to global forwarding rules.
        :param pulumi.Input['ForwardingRuleServiceDirectoryRegistrationsArgs'] service_directory_registrations: Service Directory resources to register this forwarding rule with.
               Currently, only supports a single Service Directory resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] service_label: An optional prefix to the service name for this Forwarding Rule.
               If specified, will be the first label of the fully qualified service
               name.
               The label must be 1-63 characters long, and comply with RFC1035.
               Specifically, the label must be 1-63 characters long and match the
               regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters
               must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               This field is only used for INTERNAL load balancing.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_ip_ranges: If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        :param pulumi.Input[builtins.str] subnetwork: This field identifies the subnetwork that the load balanced IP should
               belong to for this Forwarding Rule, used in internal load balancing and
               network load balancing with IPv6.
               If the network specified is in auto subnet mode, this field is optional.
               However, a subnetwork must be specified if the network is in custom subnet
               mode or when creating external forwarding rule with IPv6.
        :param pulumi.Input[builtins.str] target: The URL of the target resource to receive the matched traffic.  For
               regional forwarding rules, this target must be in the same region as the
               forwarding rule. For global forwarding rules, this target must be a global
               load balancing resource.
               The forwarded traffic must be of a type appropriate to the target object.
               *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
               *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
               *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
               For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
        """
        if all_ports is not None:
            pulumi.set(__self__, "all_ports", all_ports)
        if allow_global_access is not None:
            pulumi.set(__self__, "allow_global_access", allow_global_access)
        if allow_psc_global_access is not None:
            pulumi.set(__self__, "allow_psc_global_access", allow_psc_global_access)
        if backend_service is not None:
            pulumi.set(__self__, "backend_service", backend_service)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_collection is not None:
            pulumi.set(__self__, "ip_collection", ip_collection)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if is_mirroring_collector is not None:
            pulumi.set(__self__, "is_mirroring_collector", is_mirroring_collector)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_tier is not None:
            pulumi.set(__self__, "network_tier", network_tier)
        if no_automate_dns_zone is not None:
            pulumi.set(__self__, "no_automate_dns_zone", no_automate_dns_zone)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if recreate_closed_psc is not None:
            pulumi.set(__self__, "recreate_closed_psc", recreate_closed_psc)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_directory_registrations is not None:
            pulumi.set(__self__, "service_directory_registrations", service_directory_registrations)
        if service_label is not None:
            pulumi.set(__self__, "service_label", service_label)
        if source_ip_ranges is not None:
            pulumi.set(__self__, "source_ip_ranges", source_ip_ranges)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="allPorts")
    def all_ports(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
        Only packets addressed to ports in the specified range will be forwarded
        to the backends configured with this forwarding rule.
        The `allPorts` field has the following limitations:
        * It requires that the forwarding rule `IPProtocol` be TCP, UDP, SCTP, or
        L3_DEFAULT.
        * It's applicable only to the following products: internal passthrough
        Network Load Balancers, backend service-based external passthrough Network
        Load Balancers, and internal and external protocol forwarding.
        * Set this field to true to allow packets addressed to any port or packets
        lacking destination port information (for example, UDP fragments after the
        first fragment) to be forwarded to the backends configured with this
        forwarding rule. The L3_DEFAULT protocol requires `allPorts` be set to
        true.
        """
        return pulumi.get(self, "all_ports")

    @all_ports.setter
    def all_ports(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "all_ports", value)

    @property
    @pulumi.getter(name="allowGlobalAccess")
    def allow_global_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This field is used along with the `backend_service` field for
        internal load balancing or with the `target` field for internal
        TargetInstance.
        If the field is set to `TRUE`, clients can access ILB from all
        regions.
        Otherwise only allows access from clients in the same region as the
        internal load balancer.
        """
        return pulumi.get(self, "allow_global_access")

    @allow_global_access.setter
    def allow_global_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_global_access", value)

    @property
    @pulumi.getter(name="allowPscGlobalAccess")
    def allow_psc_global_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        """
        return pulumi.get(self, "allow_psc_global_access")

    @allow_psc_global_access.setter
    def allow_psc_global_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_psc_global_access", value)

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifies the backend service to which the forwarding rule sends traffic.
        Required for Internal TCP/UDP Load Balancing and Network Load Balancing;
        must be omitted for all other load balancer types.
        """
        return pulumi.get(self, "backend_service")

    @backend_service.setter
    def backend_service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backend_service", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address for which this forwarding rule accepts traffic. When a client
        sends traffic to this IP address, the forwarding rule directs the traffic
        to the referenced `target` or `backendService`.
        While creating a forwarding rule, specifying an `IPAddress` is
        required under the following circumstances:
        * When the `target` is set to `targetGrpcProxy` and
        `validateForProxyless` is set to `true`, the
        `IPAddress` should be set to `0.0.0.0`.
        * When the `target` is a Private Service Connect Google APIs
        bundle, you must specify an `IPAddress`.
        Otherwise, you can optionally specify an IP address that references an
        existing static (reserved) IP address resource. When omitted, Google Cloud
        assigns an ephemeral IP address.
        Use one of the following formats to specify an IP address while creating a
        forwarding rule:
        * IP address number, as in `100.1.2.3`
        * IPv6 address range, as in `2600:1234::/96`
        * Full resource URL, as in
        `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
        * Partial URL or by name, as in:
        * `projects/project_id/regions/region/addresses/address-name`
        * `regions/region/addresses/address-name`
        * `global/addresses/address-name`
        * `address-name`
        The forwarding rule's `target` or `backendService`,
        and in most cases, also the `loadBalancingScheme`, determine the
        type of IP address that you can use. For detailed information, see
        [IP address
        specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        When reading an `IPAddress`, the API always returns the IP
        address number.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipCollection")
    def ip_collection(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP
        in EXTERNAL_IPV6_FORWARDING_RULE_CREATION mode.
        Use one of the following formats to specify a sub-PDP when creating an
        IPv6 NetLB forwarding rule using BYOIP:
        Full resource URL, as in:
        * `https://www.googleapis.com/compute/v1/projects/{{projectId}}/regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        Partial URL, as in:
        * `projects/{{projectId}}/regions/region/publicDelegatedPrefixes/{{sub-pdp-name}}`
        * `regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        """
        return pulumi.get(self, "ip_collection")

    @ip_collection.setter
    def ip_collection(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_collection", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP protocol to which this rule applies.
        For protocol forwarding, valid
        options are `TCP`, `UDP`, `ESP`,
        `AH`, `SCTP`, `ICMP` and
        `L3_DEFAULT`.
        The valid IP protocols are different for different load balancing products
        as described in [Load balancing
        features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
        A Forwarding Rule with protocol L3_DEFAULT can attach with target instance or
        backend service with UNSPECIFIED protocol.
        A forwarding rule with "L3_DEFAULT" IPProtocal cannot be attached to a backend service with TCP or UDP.
        Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`, `L3_DEFAULT`.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address version that will be used by this forwarding rule.
        Valid options are IPV4 and IPV6.
        If not set, the IPv4 address will be used by default.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="isMirroringCollector")
    def is_mirroring_collector(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether or not this load balancer can be used as a collector for
        packet mirroring. To prevent mirroring loops, instances behind this
        load balancer will not have their traffic mirrored even if a
        `PacketMirroring` rule applies to them.
        This can only be set to true for load balancers that have their
        `loadBalancingScheme` set to `INTERNAL`.
        """
        return pulumi.get(self, "is_mirroring_collector")

    @is_mirroring_collector.setter
    def is_mirroring_collector(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_mirroring_collector", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels to apply to this forwarding rule.  A list of key->value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the forwarding rule type.
        Note that an empty string value (`""`) is also supported for some use
        cases, for example PSC (private service connection) regional forwarding
        rules.
        For more information about forwarding rules, refer to
        [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, `INTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
        Specifically, the name must be 1-63 characters long and match the regular
        expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must
        be a dash, lowercase letter, or digit, except the last character, which
        cannot be a dash.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, the forwarding rule name must be a 1-20 characters string with
        lowercase letters and numbers and must start with a letter.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This field is not used for external load balancing.
        For Internal TCP/UDP Load Balancing, this field identifies the network that
        the load balanced IP should belong to for this Forwarding Rule.
        If the subnetwork is specified, the network of the subnetwork will be used.
        If neither subnetwork nor this field is specified, the default network will
        be used.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, a network must be provided.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This signifies the networking tier used for configuring
        this load balancer and can only take the following values:
        `PREMIUM`, `STANDARD`.
        For regional ForwardingRule, the valid values are `PREMIUM` and
        `STANDARD`. For GlobalForwardingRule, the valid value is
        `PREMIUM`.
        If this field is not specified, it is assumed to be `PREMIUM`.
        If `IPAddress` is specified, this value must be equal to the
        networkTier of the Address.
        Possible values are: `PREMIUM`, `STANDARD`.
        """
        return pulumi.get(self, "network_tier")

    @network_tier.setter
    def network_tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_tier", value)

    @property
    @pulumi.getter(name="noAutomateDnsZone")
    def no_automate_dns_zone(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        """
        return pulumi.get(self, "no_automate_dns_zone")

    @no_automate_dns_zone.setter
    def no_automate_dns_zone(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "no_automate_dns_zone", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
        Only packets addressed to ports in the specified range will be forwarded
        to the backends configured with this forwarding rule.
        The `portRange` field has the following limitations:
        * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
        and
        * It's applicable only to the following products: external passthrough
        Network Load Balancers, internal and external proxy Network Load
        Balancers, internal and external Application Load Balancers, external
        protocol forwarding, and Classic VPN.
        * Some products have restrictions on what ports can be used. See
        [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
        for details.
        For external forwarding rules, two or more forwarding rules cannot use the
        same `[IPAddress, IPProtocol]` pair, and cannot have overlapping
        `portRange`s.
        For internal forwarding rules within the same VPC network, two or more
        forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair, and
        cannot have overlapping `portRange`s.
        @pattern: \\d+(?:-\\d+)?
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
        Only packets addressed to ports in the specified range will be forwarded
        to the backends configured with this forwarding rule.
        The `ports` field has the following limitations:
        * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
        and
        * It's applicable only to the following products: internal passthrough
        Network Load Balancers, backend service-based external passthrough Network
        Load Balancers, and internal protocol forwarding.
        * You can specify a list of up to five ports by number, separated by
        commas. The ports can be contiguous or discontiguous.
        For external forwarding rules, two or more forwarding rules cannot use the
        same `[IPAddress, IPProtocol]` pair if they share at least one port
        number.
        For internal forwarding rules within the same VPC network, two or more
        forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair if
        they share at least one port number.
        @pattern: \\d+(?:-\\d+)?
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="recreateClosedPsc")
    def recreate_closed_psc(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "recreate_closed_psc")

    @recreate_closed_psc.setter
    def recreate_closed_psc(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "recreate_closed_psc", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to the region where the regional forwarding rule resides.
        This field is not applicable to global forwarding rules.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceDirectoryRegistrations")
    def service_directory_registrations(self) -> Optional[pulumi.Input['ForwardingRuleServiceDirectoryRegistrationsArgs']]:
        """
        Service Directory resources to register this forwarding rule with.
        Currently, only supports a single Service Directory resource.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_registrations")

    @service_directory_registrations.setter
    def service_directory_registrations(self, value: Optional[pulumi.Input['ForwardingRuleServiceDirectoryRegistrationsArgs']]):
        pulumi.set(self, "service_directory_registrations", value)

    @property
    @pulumi.getter(name="serviceLabel")
    def service_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional prefix to the service name for this Forwarding Rule.
        If specified, will be the first label of the fully qualified service
        name.
        The label must be 1-63 characters long, and comply with RFC1035.
        Specifically, the label must be 1-63 characters long and match the
        regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters
        must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        This field is only used for INTERNAL load balancing.
        """
        return pulumi.get(self, "service_label")

    @service_label.setter
    def service_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_label", value)

    @property
    @pulumi.getter(name="sourceIpRanges")
    def source_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        """
        return pulumi.get(self, "source_ip_ranges")

    @source_ip_ranges.setter
    def source_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_ip_ranges", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This field identifies the subnetwork that the load balanced IP should
        belong to for this Forwarding Rule, used in internal load balancing and
        network load balancing with IPv6.
        If the network specified is in auto subnet mode, this field is optional.
        However, a subnetwork must be specified if the network is in custom subnet
        mode or when creating external forwarding rule with IPv6.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the target resource to receive the matched traffic.  For
        regional forwarding rules, this target must be in the same region as the
        forwarding rule. For global forwarding rules, this target must be a global
        load balancing resource.
        The forwarded traffic must be of a type appropriate to the target object.
        *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
        *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
        *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
        For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class _ForwardingRuleState:
    def __init__(__self__, *,
                 all_ports: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_global_access: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_psc_global_access: Optional[pulumi.Input[builtins.bool]] = None,
                 backend_service: Optional[pulumi.Input[builtins.str]] = None,
                 base_forwarding_rule: Optional[pulumi.Input[builtins.str]] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 forwarding_rule_id: Optional[pulumi.Input[builtins.int]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_collection: Optional[pulumi.Input[builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 is_mirroring_collector: Optional[pulumi.Input[builtins.bool]] = None,
                 label_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 network_tier: Optional[pulumi.Input[builtins.str]] = None,
                 no_automate_dns_zone: Optional[pulumi.Input[builtins.bool]] = None,
                 port_range: Optional[pulumi.Input[builtins.str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 psc_connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 psc_connection_status: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 recreate_closed_psc: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 service_directory_registrations: Optional[pulumi.Input['ForwardingRuleServiceDirectoryRegistrationsArgs']] = None,
                 service_label: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ForwardingRule resources.
        :param pulumi.Input[builtins.bool] all_ports: The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
               Only packets addressed to ports in the specified range will be forwarded
               to the backends configured with this forwarding rule.
               The `allPorts` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, SCTP, or
               L3_DEFAULT.
               * It's applicable only to the following products: internal passthrough
               Network Load Balancers, backend service-based external passthrough Network
               Load Balancers, and internal and external protocol forwarding.
               * Set this field to true to allow packets addressed to any port or packets
               lacking destination port information (for example, UDP fragments after the
               first fragment) to be forwarded to the backends configured with this
               forwarding rule. The L3_DEFAULT protocol requires `allPorts` be set to
               true.
        :param pulumi.Input[builtins.bool] allow_global_access: This field is used along with the `backend_service` field for
               internal load balancing or with the `target` field for internal
               TargetInstance.
               If the field is set to `TRUE`, clients can access ILB from all
               regions.
               Otherwise only allows access from clients in the same region as the
               internal load balancer.
        :param pulumi.Input[builtins.bool] allow_psc_global_access: This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        :param pulumi.Input[builtins.str] backend_service: Identifies the backend service to which the forwarding rule sends traffic.
               Required for Internal TCP/UDP Load Balancing and Network Load Balancing;
               must be omitted for all other load balancer types.
        :param pulumi.Input[builtins.str] base_forwarding_rule: [Output Only] The URL for the corresponding base Forwarding Rule. By base Forwarding Rule, we mean the Forwarding Rule that has the same IP address, protocol, and port settings with the current Forwarding Rule, but without sourceIPRanges specified. Always empty if the current Forwarding Rule does not have sourceIPRanges specified.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.int] forwarding_rule_id: The unique identifier number for the resource. This identifier is defined by the server.
        :param pulumi.Input[builtins.str] ip_address: IP address for which this forwarding rule accepts traffic. When a client
               sends traffic to this IP address, the forwarding rule directs the traffic
               to the referenced `target` or `backendService`.
               While creating a forwarding rule, specifying an `IPAddress` is
               required under the following circumstances:
               * When the `target` is set to `targetGrpcProxy` and
               `validateForProxyless` is set to `true`, the
               `IPAddress` should be set to `0.0.0.0`.
               * When the `target` is a Private Service Connect Google APIs
               bundle, you must specify an `IPAddress`.
               Otherwise, you can optionally specify an IP address that references an
               existing static (reserved) IP address resource. When omitted, Google Cloud
               assigns an ephemeral IP address.
               Use one of the following formats to specify an IP address while creating a
               forwarding rule:
               * IP address number, as in `100.1.2.3`
               * IPv6 address range, as in `2600:1234::/96`
               * Full resource URL, as in
               `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
               * Partial URL or by name, as in:
               * `projects/project_id/regions/region/addresses/address-name`
               * `regions/region/addresses/address-name`
               * `global/addresses/address-name`
               * `address-name`
               The forwarding rule's `target` or `backendService`,
               and in most cases, also the `loadBalancingScheme`, determine the
               type of IP address that you can use. For detailed information, see
               [IP address
               specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               When reading an `IPAddress`, the API always returns the IP
               address number.
        :param pulumi.Input[builtins.str] ip_collection: Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP
               in EXTERNAL_IPV6_FORWARDING_RULE_CREATION mode.
               Use one of the following formats to specify a sub-PDP when creating an
               IPv6 NetLB forwarding rule using BYOIP:
               Full resource URL, as in:
               * `https://www.googleapis.com/compute/v1/projects/{{projectId}}/regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
               Partial URL, as in:
               * `projects/{{projectId}}/regions/region/publicDelegatedPrefixes/{{sub-pdp-name}}`
               * `regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        :param pulumi.Input[builtins.str] ip_protocol: The IP protocol to which this rule applies.
               For protocol forwarding, valid
               options are `TCP`, `UDP`, `ESP`,
               `AH`, `SCTP`, `ICMP` and
               `L3_DEFAULT`.
               The valid IP protocols are different for different load balancing products
               as described in [Load balancing
               features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
               A Forwarding Rule with protocol L3_DEFAULT can attach with target instance or
               backend service with UNSPECIFIED protocol.
               A forwarding rule with "L3_DEFAULT" IPProtocal cannot be attached to a backend service with TCP or UDP.
               Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`, `L3_DEFAULT`.
        :param pulumi.Input[builtins.str] ip_version: The IP address version that will be used by this forwarding rule.
               Valid options are IPV4 and IPV6.
               If not set, the IPv4 address will be used by default.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[builtins.bool] is_mirroring_collector: Indicates whether or not this load balancer can be used as a collector for
               packet mirroring. To prevent mirroring loops, instances behind this
               load balancer will not have their traffic mirrored even if a
               `PacketMirroring` rule applies to them.
               This can only be set to true for load balancers that have their
               `loadBalancingScheme` set to `INTERNAL`.
        :param pulumi.Input[builtins.str] label_fingerprint: The fingerprint used for optimistic locking of this resource.  Used
               internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] load_balancing_scheme: Specifies the forwarding rule type.
               Note that an empty string value (`""`) is also supported for some use
               cases, for example PSC (private service connection) regional forwarding
               rules.
               For more information about forwarding rules, refer to
               [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, `INTERNAL_MANAGED`.
        :param pulumi.Input[builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, the forwarding rule name must be a 1-20 characters string with
               lowercase letters and numbers and must start with a letter.
               
               
               - - -
        :param pulumi.Input[builtins.str] network: This field is not used for external load balancing.
               For Internal TCP/UDP Load Balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule.
               If the subnetwork is specified, the network of the subnetwork will be used.
               If neither subnetwork nor this field is specified, the default network will
               be used.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, a network must be provided.
        :param pulumi.Input[builtins.str] network_tier: This signifies the networking tier used for configuring
               this load balancer and can only take the following values:
               `PREMIUM`, `STANDARD`.
               For regional ForwardingRule, the valid values are `PREMIUM` and
               `STANDARD`. For GlobalForwardingRule, the valid value is
               `PREMIUM`.
               If this field is not specified, it is assumed to be `PREMIUM`.
               If `IPAddress` is specified, this value must be equal to the
               networkTier of the Address.
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[builtins.bool] no_automate_dns_zone: This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        :param pulumi.Input[builtins.str] port_range: The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
               Only packets addressed to ports in the specified range will be forwarded
               to the backends configured with this forwarding rule.
               The `portRange` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
               and
               * It's applicable only to the following products: external passthrough
               Network Load Balancers, internal and external proxy Network Load
               Balancers, internal and external Application Load Balancers, external
               protocol forwarding, and Classic VPN.
               * Some products have restrictions on what ports can be used. See
               [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
               for details.
               For external forwarding rules, two or more forwarding rules cannot use the
               same `[IPAddress, IPProtocol]` pair, and cannot have overlapping
               `portRange`s.
               For internal forwarding rules within the same VPC network, two or more
               forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair, and
               cannot have overlapping `portRange`s.
               @pattern: \\d+(?:-\\d+)?
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ports: The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
               Only packets addressed to ports in the specified range will be forwarded
               to the backends configured with this forwarding rule.
               The `ports` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
               and
               * It's applicable only to the following products: internal passthrough
               Network Load Balancers, backend service-based external passthrough Network
               Load Balancers, and internal protocol forwarding.
               * You can specify a list of up to five ports by number, separated by
               commas. The ports can be contiguous or discontiguous.
               For external forwarding rules, two or more forwarding rules cannot use the
               same `[IPAddress, IPProtocol]` pair if they share at least one port
               number.
               For internal forwarding rules within the same VPC network, two or more
               forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair if
               they share at least one port number.
               @pattern: \\d+(?:-\\d+)?
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] psc_connection_id: The PSC connection id of the PSC Forwarding Rule.
        :param pulumi.Input[builtins.str] psc_connection_status: The PSC connection status of the PSC Forwarding Rule. Possible values: `STATUS_UNSPECIFIED`, `PENDING`, `ACCEPTED`, `REJECTED`, `CLOSED`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] region: A reference to the region where the regional forwarding rule resides.
               This field is not applicable to global forwarding rules.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input['ForwardingRuleServiceDirectoryRegistrationsArgs'] service_directory_registrations: Service Directory resources to register this forwarding rule with.
               Currently, only supports a single Service Directory resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] service_label: An optional prefix to the service name for this Forwarding Rule.
               If specified, will be the first label of the fully qualified service
               name.
               The label must be 1-63 characters long, and comply with RFC1035.
               Specifically, the label must be 1-63 characters long and match the
               regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters
               must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               This field is only used for INTERNAL load balancing.
        :param pulumi.Input[builtins.str] service_name: The internal fully qualified service name for this Forwarding Rule.
               This field is only used for INTERNAL load balancing.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_ip_ranges: If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        :param pulumi.Input[builtins.str] subnetwork: This field identifies the subnetwork that the load balanced IP should
               belong to for this Forwarding Rule, used in internal load balancing and
               network load balancing with IPv6.
               If the network specified is in auto subnet mode, this field is optional.
               However, a subnetwork must be specified if the network is in custom subnet
               mode or when creating external forwarding rule with IPv6.
        :param pulumi.Input[builtins.str] target: The URL of the target resource to receive the matched traffic.  For
               regional forwarding rules, this target must be in the same region as the
               forwarding rule. For global forwarding rules, this target must be a global
               load balancing resource.
               The forwarded traffic must be of a type appropriate to the target object.
               *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
               *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
               *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
               For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
        """
        if all_ports is not None:
            pulumi.set(__self__, "all_ports", all_ports)
        if allow_global_access is not None:
            pulumi.set(__self__, "allow_global_access", allow_global_access)
        if allow_psc_global_access is not None:
            pulumi.set(__self__, "allow_psc_global_access", allow_psc_global_access)
        if backend_service is not None:
            pulumi.set(__self__, "backend_service", backend_service)
        if base_forwarding_rule is not None:
            pulumi.set(__self__, "base_forwarding_rule", base_forwarding_rule)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if forwarding_rule_id is not None:
            pulumi.set(__self__, "forwarding_rule_id", forwarding_rule_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_collection is not None:
            pulumi.set(__self__, "ip_collection", ip_collection)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if is_mirroring_collector is not None:
            pulumi.set(__self__, "is_mirroring_collector", is_mirroring_collector)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_tier is not None:
            pulumi.set(__self__, "network_tier", network_tier)
        if no_automate_dns_zone is not None:
            pulumi.set(__self__, "no_automate_dns_zone", no_automate_dns_zone)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_connection_id is not None:
            pulumi.set(__self__, "psc_connection_id", psc_connection_id)
        if psc_connection_status is not None:
            pulumi.set(__self__, "psc_connection_status", psc_connection_status)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if recreate_closed_psc is not None:
            pulumi.set(__self__, "recreate_closed_psc", recreate_closed_psc)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if service_directory_registrations is not None:
            pulumi.set(__self__, "service_directory_registrations", service_directory_registrations)
        if service_label is not None:
            pulumi.set(__self__, "service_label", service_label)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if source_ip_ranges is not None:
            pulumi.set(__self__, "source_ip_ranges", source_ip_ranges)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="allPorts")
    def all_ports(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
        Only packets addressed to ports in the specified range will be forwarded
        to the backends configured with this forwarding rule.
        The `allPorts` field has the following limitations:
        * It requires that the forwarding rule `IPProtocol` be TCP, UDP, SCTP, or
        L3_DEFAULT.
        * It's applicable only to the following products: internal passthrough
        Network Load Balancers, backend service-based external passthrough Network
        Load Balancers, and internal and external protocol forwarding.
        * Set this field to true to allow packets addressed to any port or packets
        lacking destination port information (for example, UDP fragments after the
        first fragment) to be forwarded to the backends configured with this
        forwarding rule. The L3_DEFAULT protocol requires `allPorts` be set to
        true.
        """
        return pulumi.get(self, "all_ports")

    @all_ports.setter
    def all_ports(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "all_ports", value)

    @property
    @pulumi.getter(name="allowGlobalAccess")
    def allow_global_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This field is used along with the `backend_service` field for
        internal load balancing or with the `target` field for internal
        TargetInstance.
        If the field is set to `TRUE`, clients can access ILB from all
        regions.
        Otherwise only allows access from clients in the same region as the
        internal load balancer.
        """
        return pulumi.get(self, "allow_global_access")

    @allow_global_access.setter
    def allow_global_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_global_access", value)

    @property
    @pulumi.getter(name="allowPscGlobalAccess")
    def allow_psc_global_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        """
        return pulumi.get(self, "allow_psc_global_access")

    @allow_psc_global_access.setter
    def allow_psc_global_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_psc_global_access", value)

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifies the backend service to which the forwarding rule sends traffic.
        Required for Internal TCP/UDP Load Balancing and Network Load Balancing;
        must be omitted for all other load balancer types.
        """
        return pulumi.get(self, "backend_service")

    @backend_service.setter
    def backend_service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backend_service", value)

    @property
    @pulumi.getter(name="baseForwardingRule")
    def base_forwarding_rule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [Output Only] The URL for the corresponding base Forwarding Rule. By base Forwarding Rule, we mean the Forwarding Rule that has the same IP address, protocol, and port settings with the current Forwarding Rule, but without sourceIPRanges specified. Always empty if the current Forwarding Rule does not have sourceIPRanges specified.
        """
        return pulumi.get(self, "base_forwarding_rule")

    @base_forwarding_rule.setter
    def base_forwarding_rule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "base_forwarding_rule", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="forwardingRuleId")
    def forwarding_rule_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The unique identifier number for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "forwarding_rule_id")

    @forwarding_rule_id.setter
    def forwarding_rule_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "forwarding_rule_id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address for which this forwarding rule accepts traffic. When a client
        sends traffic to this IP address, the forwarding rule directs the traffic
        to the referenced `target` or `backendService`.
        While creating a forwarding rule, specifying an `IPAddress` is
        required under the following circumstances:
        * When the `target` is set to `targetGrpcProxy` and
        `validateForProxyless` is set to `true`, the
        `IPAddress` should be set to `0.0.0.0`.
        * When the `target` is a Private Service Connect Google APIs
        bundle, you must specify an `IPAddress`.
        Otherwise, you can optionally specify an IP address that references an
        existing static (reserved) IP address resource. When omitted, Google Cloud
        assigns an ephemeral IP address.
        Use one of the following formats to specify an IP address while creating a
        forwarding rule:
        * IP address number, as in `100.1.2.3`
        * IPv6 address range, as in `2600:1234::/96`
        * Full resource URL, as in
        `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
        * Partial URL or by name, as in:
        * `projects/project_id/regions/region/addresses/address-name`
        * `regions/region/addresses/address-name`
        * `global/addresses/address-name`
        * `address-name`
        The forwarding rule's `target` or `backendService`,
        and in most cases, also the `loadBalancingScheme`, determine the
        type of IP address that you can use. For detailed information, see
        [IP address
        specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        When reading an `IPAddress`, the API always returns the IP
        address number.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipCollection")
    def ip_collection(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP
        in EXTERNAL_IPV6_FORWARDING_RULE_CREATION mode.
        Use one of the following formats to specify a sub-PDP when creating an
        IPv6 NetLB forwarding rule using BYOIP:
        Full resource URL, as in:
        * `https://www.googleapis.com/compute/v1/projects/{{projectId}}/regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        Partial URL, as in:
        * `projects/{{projectId}}/regions/region/publicDelegatedPrefixes/{{sub-pdp-name}}`
        * `regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        """
        return pulumi.get(self, "ip_collection")

    @ip_collection.setter
    def ip_collection(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_collection", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP protocol to which this rule applies.
        For protocol forwarding, valid
        options are `TCP`, `UDP`, `ESP`,
        `AH`, `SCTP`, `ICMP` and
        `L3_DEFAULT`.
        The valid IP protocols are different for different load balancing products
        as described in [Load balancing
        features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
        A Forwarding Rule with protocol L3_DEFAULT can attach with target instance or
        backend service with UNSPECIFIED protocol.
        A forwarding rule with "L3_DEFAULT" IPProtocal cannot be attached to a backend service with TCP or UDP.
        Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`, `L3_DEFAULT`.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address version that will be used by this forwarding rule.
        Valid options are IPV4 and IPV6.
        If not set, the IPv4 address will be used by default.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="isMirroringCollector")
    def is_mirroring_collector(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether or not this load balancer can be used as a collector for
        packet mirroring. To prevent mirroring loops, instances behind this
        load balancer will not have their traffic mirrored even if a
        `PacketMirroring` rule applies to them.
        This can only be set to true for load balancers that have their
        `loadBalancingScheme` set to `INTERNAL`.
        """
        return pulumi.get(self, "is_mirroring_collector")

    @is_mirroring_collector.setter
    def is_mirroring_collector(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_mirroring_collector", value)

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fingerprint used for optimistic locking of this resource.  Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label_fingerprint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels to apply to this forwarding rule.  A list of key->value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the forwarding rule type.
        Note that an empty string value (`""`) is also supported for some use
        cases, for example PSC (private service connection) regional forwarding
        rules.
        For more information about forwarding rules, refer to
        [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, `INTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
        Specifically, the name must be 1-63 characters long and match the regular
        expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must
        be a dash, lowercase letter, or digit, except the last character, which
        cannot be a dash.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, the forwarding rule name must be a 1-20 characters string with
        lowercase letters and numbers and must start with a letter.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This field is not used for external load balancing.
        For Internal TCP/UDP Load Balancing, this field identifies the network that
        the load balanced IP should belong to for this Forwarding Rule.
        If the subnetwork is specified, the network of the subnetwork will be used.
        If neither subnetwork nor this field is specified, the default network will
        be used.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, a network must be provided.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This signifies the networking tier used for configuring
        this load balancer and can only take the following values:
        `PREMIUM`, `STANDARD`.
        For regional ForwardingRule, the valid values are `PREMIUM` and
        `STANDARD`. For GlobalForwardingRule, the valid value is
        `PREMIUM`.
        If this field is not specified, it is assumed to be `PREMIUM`.
        If `IPAddress` is specified, this value must be equal to the
        networkTier of the Address.
        Possible values are: `PREMIUM`, `STANDARD`.
        """
        return pulumi.get(self, "network_tier")

    @network_tier.setter
    def network_tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_tier", value)

    @property
    @pulumi.getter(name="noAutomateDnsZone")
    def no_automate_dns_zone(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        """
        return pulumi.get(self, "no_automate_dns_zone")

    @no_automate_dns_zone.setter
    def no_automate_dns_zone(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "no_automate_dns_zone", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
        Only packets addressed to ports in the specified range will be forwarded
        to the backends configured with this forwarding rule.
        The `portRange` field has the following limitations:
        * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
        and
        * It's applicable only to the following products: external passthrough
        Network Load Balancers, internal and external proxy Network Load
        Balancers, internal and external Application Load Balancers, external
        protocol forwarding, and Classic VPN.
        * Some products have restrictions on what ports can be used. See
        [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
        for details.
        For external forwarding rules, two or more forwarding rules cannot use the
        same `[IPAddress, IPProtocol]` pair, and cannot have overlapping
        `portRange`s.
        For internal forwarding rules within the same VPC network, two or more
        forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair, and
        cannot have overlapping `portRange`s.
        @pattern: \\d+(?:-\\d+)?
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
        Only packets addressed to ports in the specified range will be forwarded
        to the backends configured with this forwarding rule.
        The `ports` field has the following limitations:
        * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
        and
        * It's applicable only to the following products: internal passthrough
        Network Load Balancers, backend service-based external passthrough Network
        Load Balancers, and internal protocol forwarding.
        * You can specify a list of up to five ports by number, separated by
        commas. The ports can be contiguous or discontiguous.
        For external forwarding rules, two or more forwarding rules cannot use the
        same `[IPAddress, IPProtocol]` pair if they share at least one port
        number.
        For internal forwarding rules within the same VPC network, two or more
        forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair if
        they share at least one port number.
        @pattern: \\d+(?:-\\d+)?
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PSC connection id of the PSC Forwarding Rule.
        """
        return pulumi.get(self, "psc_connection_id")

    @psc_connection_id.setter
    def psc_connection_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "psc_connection_id", value)

    @property
    @pulumi.getter(name="pscConnectionStatus")
    def psc_connection_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PSC connection status of the PSC Forwarding Rule. Possible values: `STATUS_UNSPECIFIED`, `PENDING`, `ACCEPTED`, `REJECTED`, `CLOSED`
        """
        return pulumi.get(self, "psc_connection_status")

    @psc_connection_status.setter
    def psc_connection_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "psc_connection_status", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="recreateClosedPsc")
    def recreate_closed_psc(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "recreate_closed_psc")

    @recreate_closed_psc.setter
    def recreate_closed_psc(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "recreate_closed_psc", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to the region where the regional forwarding rule resides.
        This field is not applicable to global forwarding rules.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="serviceDirectoryRegistrations")
    def service_directory_registrations(self) -> Optional[pulumi.Input['ForwardingRuleServiceDirectoryRegistrationsArgs']]:
        """
        Service Directory resources to register this forwarding rule with.
        Currently, only supports a single Service Directory resource.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_registrations")

    @service_directory_registrations.setter
    def service_directory_registrations(self, value: Optional[pulumi.Input['ForwardingRuleServiceDirectoryRegistrationsArgs']]):
        pulumi.set(self, "service_directory_registrations", value)

    @property
    @pulumi.getter(name="serviceLabel")
    def service_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional prefix to the service name for this Forwarding Rule.
        If specified, will be the first label of the fully qualified service
        name.
        The label must be 1-63 characters long, and comply with RFC1035.
        Specifically, the label must be 1-63 characters long and match the
        regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters
        must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        This field is only used for INTERNAL load balancing.
        """
        return pulumi.get(self, "service_label")

    @service_label.setter
    def service_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_label", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internal fully qualified service name for this Forwarding Rule.
        This field is only used for INTERNAL load balancing.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="sourceIpRanges")
    def source_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        """
        return pulumi.get(self, "source_ip_ranges")

    @source_ip_ranges.setter
    def source_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_ip_ranges", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This field identifies the subnetwork that the load balanced IP should
        belong to for this Forwarding Rule, used in internal load balancing and
        network load balancing with IPv6.
        If the network specified is in auto subnet mode, this field is optional.
        However, a subnetwork must be specified if the network is in custom subnet
        mode or when creating external forwarding rule with IPv6.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the target resource to receive the matched traffic.  For
        regional forwarding rules, this target must be in the same region as the
        forwarding rule. For global forwarding rules, this target must be a global
        load balancing resource.
        The forwarded traffic must be of a type appropriate to the target object.
        *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
        *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
        *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
        For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target", value)


@pulumi.type_token("gcp:compute/forwardingRule:ForwardingRule")
class ForwardingRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 all_ports: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_global_access: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_psc_global_access: Optional[pulumi.Input[builtins.bool]] = None,
                 backend_service: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_collection: Optional[pulumi.Input[builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 is_mirroring_collector: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 network_tier: Optional[pulumi.Input[builtins.str]] = None,
                 no_automate_dns_zone: Optional[pulumi.Input[builtins.bool]] = None,
                 port_range: Optional[pulumi.Input[builtins.str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 recreate_closed_psc: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_directory_registrations: Optional[pulumi.Input[Union['ForwardingRuleServiceDirectoryRegistrationsArgs', 'ForwardingRuleServiceDirectoryRegistrationsArgsDict']]] = None,
                 service_label: Optional[pulumi.Input[builtins.str]] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A ForwardingRule resource. A ForwardingRule resource specifies which pool
        of target virtual machines to forward a packet to if it matches the given
        [IPAddress, IPProtocol, portRange] tuple.

        To get more information about ForwardingRule, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/forwardingRules)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/load-balancing/network/forwarding-rules)

        ## Example Usage

        ### Forwarding Rule Externallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hc = gcp.compute.RegionHealthCheck("hc",
            name="check-website-backend",
            check_interval_sec=1,
            timeout_sec=1,
            region="us-central1",
            tcp_health_check={
                "port": 80,
            })
        backend = gcp.compute.RegionBackendService("backend",
            name="website-backend",
            region="us-central1",
            load_balancing_scheme="EXTERNAL",
            health_checks=hc.id)
        # Forwarding rule for External Network Load Balancing using Backend Services
        default = gcp.compute.ForwardingRule("default",
            name="website-forwarding-rule",
            region="us-central1",
            port_range="80",
            backend_service=backend.id)
        ```
        ### Forwarding Rule Global Internallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hc = gcp.compute.HealthCheck("hc",
            name="check-website-backend",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        backend = gcp.compute.RegionBackendService("backend",
            name="website-backend",
            region="us-central1",
            health_checks=hc.id)
        default_network = gcp.compute.Network("default",
            name="website-net",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="website-net",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=default_network.id)
        # Forwarding rule for Internal Load Balancing
        default = gcp.compute.ForwardingRule("default",
            name="website-forwarding-rule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=backend.id,
            all_ports=True,
            allow_global_access=True,
            network=default_network.name,
            subnetwork=default_subnetwork.name)
        ```
        ### Forwarding Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_target_pool = gcp.compute.TargetPool("default", name="website-target-pool")
        default = gcp.compute.ForwardingRule("default",
            name="website-forwarding-rule",
            target=default_target_pool.id,
            port_range="80")
        ```
        ### Forwarding Rule L3 Default

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("health_check",
            name="health-check",
            region="us-central1",
            tcp_health_check={
                "port": 80,
            })
        service = gcp.compute.RegionBackendService("service",
            region="us-central1",
            name="service",
            health_checks=health_check.id,
            protocol="UNSPECIFIED",
            load_balancing_scheme="EXTERNAL")
        fwd_rule = gcp.compute.ForwardingRule("fwd_rule",
            name="l3-forwarding-rule",
            backend_service=service.id,
            ip_protocol="L3_DEFAULT",
            all_ports=True)
        ```
        ### Forwarding Rule Internallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hc = gcp.compute.HealthCheck("hc",
            name="check-website-backend",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        backend = gcp.compute.RegionBackendService("backend",
            name="website-backend",
            region="us-central1",
            health_checks=hc.id)
        default_network = gcp.compute.Network("default",
            name="website-net",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="website-net",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=default_network.id)
        # Forwarding rule for Internal Load Balancing
        default = gcp.compute.ForwardingRule("default",
            name="website-forwarding-rule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=backend.id,
            all_ports=True,
            network=default_network.name,
            subnetwork=default_subnetwork.name,
            ip_version="IPV4")
        ```
        ### Forwarding Rule Http Lb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        default_network = gcp.compute.Network("default",
            name="website-net",
            auto_create_subnetworks=False,
            routing_mode="REGIONAL")
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="website-net-default",
            ip_cidr_range="10.1.2.0/24",
            region="us-central1",
            network=default_network.id)
        instance_template = gcp.compute.InstanceTemplate("instance_template",
            name="template-website-backend",
            machine_type="e2-medium",
            network_interfaces=[{
                "network": default_network.id,
                "subnetwork": default_subnetwork.id,
            }],
            disks=[{
                "source_image": debian_image.self_link,
                "auto_delete": True,
                "boot": True,
            }],
            tags=[
                "allow-ssh",
                "load-balanced-backend",
            ])
        rigm = gcp.compute.RegionInstanceGroupManager("rigm",
            region="us-central1",
            name="website-rigm",
            versions=[{
                "instance_template": instance_template.id,
                "name": "primary",
            }],
            base_instance_name="internal-glb",
            target_size=1)
        fw1 = gcp.compute.Firewall("fw1",
            name="website-fw-1",
            network=default_network.id,
            source_ranges=["10.1.2.0/24"],
            allows=[
                {
                    "protocol": "tcp",
                },
                {
                    "protocol": "udp",
                },
                {
                    "protocol": "icmp",
                },
            ],
            direction="INGRESS")
        fw2 = gcp.compute.Firewall("fw2",
            name="website-fw-2",
            network=default_network.id,
            source_ranges=["0.0.0.0/0"],
            allows=[{
                "protocol": "tcp",
                "ports": ["22"],
            }],
            target_tags=["allow-ssh"],
            direction="INGRESS",
            opts = pulumi.ResourceOptions(depends_on=[fw1]))
        fw3 = gcp.compute.Firewall("fw3",
            name="website-fw-3",
            network=default_network.id,
            source_ranges=[
                "130.211.0.0/22",
                "35.191.0.0/16",
            ],
            allows=[{
                "protocol": "tcp",
            }],
            target_tags=["load-balanced-backend"],
            direction="INGRESS",
            opts = pulumi.ResourceOptions(depends_on=[fw2]))
        fw4 = gcp.compute.Firewall("fw4",
            name="website-fw-4",
            network=default_network.id,
            source_ranges=["10.129.0.0/26"],
            target_tags=["load-balanced-backend"],
            allows=[
                {
                    "protocol": "tcp",
                    "ports": ["80"],
                },
                {
                    "protocol": "tcp",
                    "ports": ["443"],
                },
                {
                    "protocol": "tcp",
                    "ports": ["8000"],
                },
            ],
            direction="INGRESS",
            opts = pulumi.ResourceOptions(depends_on=[fw3]))
        default_region_health_check = gcp.compute.RegionHealthCheck("default",
            region="us-central1",
            name="website-hc",
            http_health_check={
                "port_specification": "USE_SERVING_PORT",
            },
            opts = pulumi.ResourceOptions(depends_on=[fw4]))
        default_region_backend_service = gcp.compute.RegionBackendService("default",
            load_balancing_scheme="INTERNAL_MANAGED",
            backends=[{
                "group": rigm.instance_group,
                "balancing_mode": "UTILIZATION",
                "capacity_scaler": 1,
            }],
            region="us-central1",
            name="website-backend",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default_region_health_check.id)
        default_region_url_map = gcp.compute.RegionUrlMap("default",
            region="us-central1",
            name="website-map",
            default_service=default_region_backend_service.id)
        default_region_target_http_proxy = gcp.compute.RegionTargetHttpProxy("default",
            region="us-central1",
            name="website-proxy",
            url_map=default_region_url_map.id)
        proxy = gcp.compute.Subnetwork("proxy",
            name="website-net-proxy",
            ip_cidr_range="10.129.0.0/26",
            region="us-central1",
            network=default_network.id,
            purpose="REGIONAL_MANAGED_PROXY",
            role="ACTIVE")
        # Forwarding rule for Internal Load Balancing
        default = gcp.compute.ForwardingRule("default",
            name="website-forwarding-rule",
            region="us-central1",
            ip_protocol="TCP",
            load_balancing_scheme="INTERNAL_MANAGED",
            port_range="80",
            target=default_region_target_http_proxy.id,
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            network_tier="PREMIUM",
            opts = pulumi.ResourceOptions(depends_on=[proxy]))
        ```
        ### Forwarding Rule Regional Http Xlb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        default_network = gcp.compute.Network("default",
            name="website-net",
            auto_create_subnetworks=False,
            routing_mode="REGIONAL")
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="website-net-default",
            ip_cidr_range="10.1.2.0/24",
            region="us-central1",
            network=default_network.id)
        instance_template = gcp.compute.InstanceTemplate("instance_template",
            name="template-website-backend",
            machine_type="e2-medium",
            network_interfaces=[{
                "network": default_network.id,
                "subnetwork": default_subnetwork.id,
            }],
            disks=[{
                "source_image": debian_image.self_link,
                "auto_delete": True,
                "boot": True,
            }],
            tags=[
                "allow-ssh",
                "load-balanced-backend",
            ])
        rigm = gcp.compute.RegionInstanceGroupManager("rigm",
            region="us-central1",
            name="website-rigm",
            versions=[{
                "instance_template": instance_template.id,
                "name": "primary",
            }],
            base_instance_name="internal-glb",
            target_size=1)
        fw1 = gcp.compute.Firewall("fw1",
            name="website-fw-1",
            network=default_network.id,
            source_ranges=["10.1.2.0/24"],
            allows=[
                {
                    "protocol": "tcp",
                },
                {
                    "protocol": "udp",
                },
                {
                    "protocol": "icmp",
                },
            ],
            direction="INGRESS")
        fw2 = gcp.compute.Firewall("fw2",
            name="website-fw-2",
            network=default_network.id,
            source_ranges=["0.0.0.0/0"],
            allows=[{
                "protocol": "tcp",
                "ports": ["22"],
            }],
            target_tags=["allow-ssh"],
            direction="INGRESS",
            opts = pulumi.ResourceOptions(depends_on=[fw1]))
        fw3 = gcp.compute.Firewall("fw3",
            name="website-fw-3",
            network=default_network.id,
            source_ranges=[
                "130.211.0.0/22",
                "35.191.0.0/16",
            ],
            allows=[{
                "protocol": "tcp",
            }],
            target_tags=["load-balanced-backend"],
            direction="INGRESS",
            opts = pulumi.ResourceOptions(depends_on=[fw2]))
        fw4 = gcp.compute.Firewall("fw4",
            name="website-fw-4",
            network=default_network.id,
            source_ranges=["10.129.0.0/26"],
            target_tags=["load-balanced-backend"],
            allows=[
                {
                    "protocol": "tcp",
                    "ports": ["80"],
                },
                {
                    "protocol": "tcp",
                    "ports": ["443"],
                },
                {
                    "protocol": "tcp",
                    "ports": ["8000"],
                },
            ],
            direction="INGRESS",
            opts = pulumi.ResourceOptions(depends_on=[fw3]))
        default_region_health_check = gcp.compute.RegionHealthCheck("default",
            region="us-central1",
            name="website-hc",
            http_health_check={
                "port_specification": "USE_SERVING_PORT",
            },
            opts = pulumi.ResourceOptions(depends_on=[fw4]))
        default_region_backend_service = gcp.compute.RegionBackendService("default",
            load_balancing_scheme="EXTERNAL_MANAGED",
            backends=[{
                "group": rigm.instance_group,
                "balancing_mode": "UTILIZATION",
                "capacity_scaler": 1,
            }],
            region="us-central1",
            name="website-backend",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default_region_health_check.id)
        default_region_url_map = gcp.compute.RegionUrlMap("default",
            region="us-central1",
            name="website-map",
            default_service=default_region_backend_service.id)
        default_region_target_http_proxy = gcp.compute.RegionTargetHttpProxy("default",
            region="us-central1",
            name="website-proxy",
            url_map=default_region_url_map.id)
        default_address = gcp.compute.Address("default",
            name="website-ip-1",
            region="us-central1",
            network_tier="STANDARD")
        proxy = gcp.compute.Subnetwork("proxy",
            name="website-net-proxy",
            ip_cidr_range="10.129.0.0/26",
            region="us-central1",
            network=default_network.id,
            purpose="REGIONAL_MANAGED_PROXY",
            role="ACTIVE")
        # Forwarding rule for Regional External Load Balancing
        default = gcp.compute.ForwardingRule("default",
            name="website-forwarding-rule",
            region="us-central1",
            ip_protocol="TCP",
            load_balancing_scheme="EXTERNAL_MANAGED",
            port_range="80",
            target=default_region_target_http_proxy.id,
            network=default_network.id,
            ip_address=default_address.address,
            network_tier="STANDARD",
            opts = pulumi.ResourceOptions(depends_on=[proxy]))
        ```
        ### Forwarding Rule Vpc Psc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # Consumer service endpoint
        consumer_net = gcp.compute.Network("consumer_net",
            name="consumer-net",
            auto_create_subnetworks=False)
        consumer_subnet = gcp.compute.Subnetwork("consumer_subnet",
            name="consumer-net",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=consumer_net.id)
        consumer_address = gcp.compute.Address("consumer_address",
            name="website-ip-1",
            region="us-central1",
            subnetwork=consumer_subnet.id,
            address_type="INTERNAL")
        # Producer service attachment
        producer_net = gcp.compute.Network("producer_net",
            name="producer-net",
            auto_create_subnetworks=False)
        psc_producer_subnet = gcp.compute.Subnetwork("psc_producer_subnet",
            name="producer-psc-net",
            ip_cidr_range="10.1.0.0/16",
            region="us-central1",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=producer_net.id)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="producer-net",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=producer_net.id)
        producer_service_health_check = gcp.compute.HealthCheck("producer_service_health_check",
            name="producer-service-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        producer_service_backend = gcp.compute.RegionBackendService("producer_service_backend",
            name="producer-service-backend",
            region="us-central1",
            health_checks=producer_service_health_check.id)
        producer_target_service = gcp.compute.ForwardingRule("producer_target_service",
            name="producer-forwarding-rule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=producer_service_backend.id,
            all_ports=True,
            network=producer_net.name,
            subnetwork=producer_subnet.name)
        producer_service_attachment = gcp.compute.ServiceAttachment("producer_service_attachment",
            name="producer-service",
            region="us-central1",
            description="A service attachment configured with Terraform",
            enable_proxy_protocol=True,
            connection_preference="ACCEPT_AUTOMATIC",
            nat_subnets=[psc_producer_subnet.name],
            target_service=producer_target_service.id)
        # Forwarding rule for VPC private service connect
        default = gcp.compute.ForwardingRule("default",
            name="psc-endpoint",
            region="us-central1",
            load_balancing_scheme="",
            target=producer_service_attachment.id,
            network=consumer_net.name,
            ip_address=consumer_address.id,
            allow_psc_global_access=True)
        ```
        ### Forwarding Rule Vpc Psc No Automate Dns

        ```python
        import pulumi
        import pulumi_gcp as gcp

        consumer_net = gcp.compute.Network("consumer_net",
            name="consumer-net",
            auto_create_subnetworks=False)
        consumer_subnet = gcp.compute.Subnetwork("consumer_subnet",
            name="consumer-net",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=consumer_net.id)
        consumer_address = gcp.compute.Address("consumer_address",
            name="website-ip-1",
            region="us-central1",
            subnetwork=consumer_subnet.id,
            address_type="INTERNAL")
        producer_net = gcp.compute.Network("producer_net",
            name="producer-net",
            auto_create_subnetworks=False)
        psc_producer_subnet = gcp.compute.Subnetwork("psc_producer_subnet",
            name="producer-psc-net",
            ip_cidr_range="10.1.0.0/16",
            region="us-central1",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=producer_net.id)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="producer-net",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=producer_net.id)
        producer_service_health_check = gcp.compute.HealthCheck("producer_service_health_check",
            name="producer-service-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        producer_service_backend = gcp.compute.RegionBackendService("producer_service_backend",
            name="producer-service-backend",
            region="us-central1",
            health_checks=producer_service_health_check.id)
        producer_target_service = gcp.compute.ForwardingRule("producer_target_service",
            name="producer-forwarding-rule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=producer_service_backend.id,
            all_ports=True,
            network=producer_net.name,
            subnetwork=producer_subnet.name)
        producer_service_attachment = gcp.compute.ServiceAttachment("producer_service_attachment",
            name="producer-service",
            region="us-central1",
            description="A service attachment configured with Terraform",
            enable_proxy_protocol=True,
            connection_preference="ACCEPT_AUTOMATIC",
            nat_subnets=[psc_producer_subnet.name],
            target_service=producer_target_service.id)
        default = gcp.compute.ForwardingRule("default",
            name="psc-endpoint",
            region="us-central1",
            load_balancing_scheme="",
            target=producer_service_attachment.id,
            network=consumer_net.name,
            ip_address=consumer_address.id,
            allow_psc_global_access=True,
            no_automate_dns_zone=True)
        ```
        ### Forwarding Rule Regional Steering

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.compute.Address("basic",
            name="website-ip",
            region="us-central1")
        external = gcp.compute.RegionBackendService("external",
            name="service-backend",
            region="us-central1",
            load_balancing_scheme="EXTERNAL")
        external_forwarding_rule = gcp.compute.ForwardingRule("external",
            name="external-forwarding-rule",
            region="us-central1",
            ip_address=basic.address,
            backend_service=external.self_link,
            load_balancing_scheme="EXTERNAL")
        steering = gcp.compute.ForwardingRule("steering",
            name="steering-rule",
            region="us-central1",
            ip_address=basic.address,
            backend_service=external.self_link,
            load_balancing_scheme="EXTERNAL",
            source_ip_ranges=[
                "34.121.88.0/24",
                "35.187.239.137",
            ],
            opts = pulumi.ResourceOptions(depends_on=[external_forwarding_rule]))
        ```
        ### Forwarding Rule Internallb Ipv6

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hc = gcp.compute.HealthCheck("hc",
            name="check-ilb-ipv6-backend",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        backend = gcp.compute.RegionBackendService("backend",
            name="ilb-ipv6-backend",
            region="us-central1",
            health_checks=hc.id)
        default_network = gcp.compute.Network("default",
            name="net-ipv6",
            auto_create_subnetworks=False,
            enable_ula_internal_ipv6=True)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="subnet-internal-ipv6",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            stack_type="IPV4_IPV6",
            ipv6_access_type="INTERNAL",
            network=default_network.id)
        # Forwarding rule for Internal Load Balancing
        default = gcp.compute.ForwardingRule("default",
            name="ilb-ipv6-forwarding-rule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=backend.id,
            all_ports=True,
            network=default_network.name,
            subnetwork=default_subnetwork.name,
            ip_version="IPV6")
        ```

        ## Import

        ForwardingRule can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/forwardingRules/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, ForwardingRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/forwardingRule:ForwardingRule default projects/{{project}}/regions/{{region}}/forwardingRules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/forwardingRule:ForwardingRule default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/forwardingRule:ForwardingRule default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/forwardingRule:ForwardingRule default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] all_ports: The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
               Only packets addressed to ports in the specified range will be forwarded
               to the backends configured with this forwarding rule.
               The `allPorts` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, SCTP, or
               L3_DEFAULT.
               * It's applicable only to the following products: internal passthrough
               Network Load Balancers, backend service-based external passthrough Network
               Load Balancers, and internal and external protocol forwarding.
               * Set this field to true to allow packets addressed to any port or packets
               lacking destination port information (for example, UDP fragments after the
               first fragment) to be forwarded to the backends configured with this
               forwarding rule. The L3_DEFAULT protocol requires `allPorts` be set to
               true.
        :param pulumi.Input[builtins.bool] allow_global_access: This field is used along with the `backend_service` field for
               internal load balancing or with the `target` field for internal
               TargetInstance.
               If the field is set to `TRUE`, clients can access ILB from all
               regions.
               Otherwise only allows access from clients in the same region as the
               internal load balancer.
        :param pulumi.Input[builtins.bool] allow_psc_global_access: This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        :param pulumi.Input[builtins.str] backend_service: Identifies the backend service to which the forwarding rule sends traffic.
               Required for Internal TCP/UDP Load Balancing and Network Load Balancing;
               must be omitted for all other load balancer types.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[builtins.str] ip_address: IP address for which this forwarding rule accepts traffic. When a client
               sends traffic to this IP address, the forwarding rule directs the traffic
               to the referenced `target` or `backendService`.
               While creating a forwarding rule, specifying an `IPAddress` is
               required under the following circumstances:
               * When the `target` is set to `targetGrpcProxy` and
               `validateForProxyless` is set to `true`, the
               `IPAddress` should be set to `0.0.0.0`.
               * When the `target` is a Private Service Connect Google APIs
               bundle, you must specify an `IPAddress`.
               Otherwise, you can optionally specify an IP address that references an
               existing static (reserved) IP address resource. When omitted, Google Cloud
               assigns an ephemeral IP address.
               Use one of the following formats to specify an IP address while creating a
               forwarding rule:
               * IP address number, as in `100.1.2.3`
               * IPv6 address range, as in `2600:1234::/96`
               * Full resource URL, as in
               `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
               * Partial URL or by name, as in:
               * `projects/project_id/regions/region/addresses/address-name`
               * `regions/region/addresses/address-name`
               * `global/addresses/address-name`
               * `address-name`
               The forwarding rule's `target` or `backendService`,
               and in most cases, also the `loadBalancingScheme`, determine the
               type of IP address that you can use. For detailed information, see
               [IP address
               specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               When reading an `IPAddress`, the API always returns the IP
               address number.
        :param pulumi.Input[builtins.str] ip_collection: Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP
               in EXTERNAL_IPV6_FORWARDING_RULE_CREATION mode.
               Use one of the following formats to specify a sub-PDP when creating an
               IPv6 NetLB forwarding rule using BYOIP:
               Full resource URL, as in:
               * `https://www.googleapis.com/compute/v1/projects/{{projectId}}/regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
               Partial URL, as in:
               * `projects/{{projectId}}/regions/region/publicDelegatedPrefixes/{{sub-pdp-name}}`
               * `regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        :param pulumi.Input[builtins.str] ip_protocol: The IP protocol to which this rule applies.
               For protocol forwarding, valid
               options are `TCP`, `UDP`, `ESP`,
               `AH`, `SCTP`, `ICMP` and
               `L3_DEFAULT`.
               The valid IP protocols are different for different load balancing products
               as described in [Load balancing
               features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
               A Forwarding Rule with protocol L3_DEFAULT can attach with target instance or
               backend service with UNSPECIFIED protocol.
               A forwarding rule with "L3_DEFAULT" IPProtocal cannot be attached to a backend service with TCP or UDP.
               Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`, `L3_DEFAULT`.
        :param pulumi.Input[builtins.str] ip_version: The IP address version that will be used by this forwarding rule.
               Valid options are IPV4 and IPV6.
               If not set, the IPv4 address will be used by default.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[builtins.bool] is_mirroring_collector: Indicates whether or not this load balancer can be used as a collector for
               packet mirroring. To prevent mirroring loops, instances behind this
               load balancer will not have their traffic mirrored even if a
               `PacketMirroring` rule applies to them.
               This can only be set to true for load balancers that have their
               `loadBalancingScheme` set to `INTERNAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] load_balancing_scheme: Specifies the forwarding rule type.
               Note that an empty string value (`""`) is also supported for some use
               cases, for example PSC (private service connection) regional forwarding
               rules.
               For more information about forwarding rules, refer to
               [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, `INTERNAL_MANAGED`.
        :param pulumi.Input[builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, the forwarding rule name must be a 1-20 characters string with
               lowercase letters and numbers and must start with a letter.
               
               
               - - -
        :param pulumi.Input[builtins.str] network: This field is not used for external load balancing.
               For Internal TCP/UDP Load Balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule.
               If the subnetwork is specified, the network of the subnetwork will be used.
               If neither subnetwork nor this field is specified, the default network will
               be used.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, a network must be provided.
        :param pulumi.Input[builtins.str] network_tier: This signifies the networking tier used for configuring
               this load balancer and can only take the following values:
               `PREMIUM`, `STANDARD`.
               For regional ForwardingRule, the valid values are `PREMIUM` and
               `STANDARD`. For GlobalForwardingRule, the valid value is
               `PREMIUM`.
               If this field is not specified, it is assumed to be `PREMIUM`.
               If `IPAddress` is specified, this value must be equal to the
               networkTier of the Address.
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[builtins.bool] no_automate_dns_zone: This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        :param pulumi.Input[builtins.str] port_range: The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
               Only packets addressed to ports in the specified range will be forwarded
               to the backends configured with this forwarding rule.
               The `portRange` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
               and
               * It's applicable only to the following products: external passthrough
               Network Load Balancers, internal and external proxy Network Load
               Balancers, internal and external Application Load Balancers, external
               protocol forwarding, and Classic VPN.
               * Some products have restrictions on what ports can be used. See
               [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
               for details.
               For external forwarding rules, two or more forwarding rules cannot use the
               same `[IPAddress, IPProtocol]` pair, and cannot have overlapping
               `portRange`s.
               For internal forwarding rules within the same VPC network, two or more
               forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair, and
               cannot have overlapping `portRange`s.
               @pattern: \\d+(?:-\\d+)?
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ports: The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
               Only packets addressed to ports in the specified range will be forwarded
               to the backends configured with this forwarding rule.
               The `ports` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
               and
               * It's applicable only to the following products: internal passthrough
               Network Load Balancers, backend service-based external passthrough Network
               Load Balancers, and internal protocol forwarding.
               * You can specify a list of up to five ports by number, separated by
               commas. The ports can be contiguous or discontiguous.
               For external forwarding rules, two or more forwarding rules cannot use the
               same `[IPAddress, IPProtocol]` pair if they share at least one port
               number.
               For internal forwarding rules within the same VPC network, two or more
               forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair if
               they share at least one port number.
               @pattern: \\d+(?:-\\d+)?
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: A reference to the region where the regional forwarding rule resides.
               This field is not applicable to global forwarding rules.
        :param pulumi.Input[Union['ForwardingRuleServiceDirectoryRegistrationsArgs', 'ForwardingRuleServiceDirectoryRegistrationsArgsDict']] service_directory_registrations: Service Directory resources to register this forwarding rule with.
               Currently, only supports a single Service Directory resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] service_label: An optional prefix to the service name for this Forwarding Rule.
               If specified, will be the first label of the fully qualified service
               name.
               The label must be 1-63 characters long, and comply with RFC1035.
               Specifically, the label must be 1-63 characters long and match the
               regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters
               must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               This field is only used for INTERNAL load balancing.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_ip_ranges: If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        :param pulumi.Input[builtins.str] subnetwork: This field identifies the subnetwork that the load balanced IP should
               belong to for this Forwarding Rule, used in internal load balancing and
               network load balancing with IPv6.
               If the network specified is in auto subnet mode, this field is optional.
               However, a subnetwork must be specified if the network is in custom subnet
               mode or when creating external forwarding rule with IPv6.
        :param pulumi.Input[builtins.str] target: The URL of the target resource to receive the matched traffic.  For
               regional forwarding rules, this target must be in the same region as the
               forwarding rule. For global forwarding rules, this target must be a global
               load balancing resource.
               The forwarded traffic must be of a type appropriate to the target object.
               *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
               *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
               *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
               For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ForwardingRuleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A ForwardingRule resource. A ForwardingRule resource specifies which pool
        of target virtual machines to forward a packet to if it matches the given
        [IPAddress, IPProtocol, portRange] tuple.

        To get more information about ForwardingRule, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/forwardingRules)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/load-balancing/network/forwarding-rules)

        ## Example Usage

        ### Forwarding Rule Externallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hc = gcp.compute.RegionHealthCheck("hc",
            name="check-website-backend",
            check_interval_sec=1,
            timeout_sec=1,
            region="us-central1",
            tcp_health_check={
                "port": 80,
            })
        backend = gcp.compute.RegionBackendService("backend",
            name="website-backend",
            region="us-central1",
            load_balancing_scheme="EXTERNAL",
            health_checks=hc.id)
        # Forwarding rule for External Network Load Balancing using Backend Services
        default = gcp.compute.ForwardingRule("default",
            name="website-forwarding-rule",
            region="us-central1",
            port_range="80",
            backend_service=backend.id)
        ```
        ### Forwarding Rule Global Internallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hc = gcp.compute.HealthCheck("hc",
            name="check-website-backend",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        backend = gcp.compute.RegionBackendService("backend",
            name="website-backend",
            region="us-central1",
            health_checks=hc.id)
        default_network = gcp.compute.Network("default",
            name="website-net",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="website-net",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=default_network.id)
        # Forwarding rule for Internal Load Balancing
        default = gcp.compute.ForwardingRule("default",
            name="website-forwarding-rule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=backend.id,
            all_ports=True,
            allow_global_access=True,
            network=default_network.name,
            subnetwork=default_subnetwork.name)
        ```
        ### Forwarding Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_target_pool = gcp.compute.TargetPool("default", name="website-target-pool")
        default = gcp.compute.ForwardingRule("default",
            name="website-forwarding-rule",
            target=default_target_pool.id,
            port_range="80")
        ```
        ### Forwarding Rule L3 Default

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("health_check",
            name="health-check",
            region="us-central1",
            tcp_health_check={
                "port": 80,
            })
        service = gcp.compute.RegionBackendService("service",
            region="us-central1",
            name="service",
            health_checks=health_check.id,
            protocol="UNSPECIFIED",
            load_balancing_scheme="EXTERNAL")
        fwd_rule = gcp.compute.ForwardingRule("fwd_rule",
            name="l3-forwarding-rule",
            backend_service=service.id,
            ip_protocol="L3_DEFAULT",
            all_ports=True)
        ```
        ### Forwarding Rule Internallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hc = gcp.compute.HealthCheck("hc",
            name="check-website-backend",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        backend = gcp.compute.RegionBackendService("backend",
            name="website-backend",
            region="us-central1",
            health_checks=hc.id)
        default_network = gcp.compute.Network("default",
            name="website-net",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="website-net",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=default_network.id)
        # Forwarding rule for Internal Load Balancing
        default = gcp.compute.ForwardingRule("default",
            name="website-forwarding-rule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=backend.id,
            all_ports=True,
            network=default_network.name,
            subnetwork=default_subnetwork.name,
            ip_version="IPV4")
        ```
        ### Forwarding Rule Http Lb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        default_network = gcp.compute.Network("default",
            name="website-net",
            auto_create_subnetworks=False,
            routing_mode="REGIONAL")
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="website-net-default",
            ip_cidr_range="10.1.2.0/24",
            region="us-central1",
            network=default_network.id)
        instance_template = gcp.compute.InstanceTemplate("instance_template",
            name="template-website-backend",
            machine_type="e2-medium",
            network_interfaces=[{
                "network": default_network.id,
                "subnetwork": default_subnetwork.id,
            }],
            disks=[{
                "source_image": debian_image.self_link,
                "auto_delete": True,
                "boot": True,
            }],
            tags=[
                "allow-ssh",
                "load-balanced-backend",
            ])
        rigm = gcp.compute.RegionInstanceGroupManager("rigm",
            region="us-central1",
            name="website-rigm",
            versions=[{
                "instance_template": instance_template.id,
                "name": "primary",
            }],
            base_instance_name="internal-glb",
            target_size=1)
        fw1 = gcp.compute.Firewall("fw1",
            name="website-fw-1",
            network=default_network.id,
            source_ranges=["10.1.2.0/24"],
            allows=[
                {
                    "protocol": "tcp",
                },
                {
                    "protocol": "udp",
                },
                {
                    "protocol": "icmp",
                },
            ],
            direction="INGRESS")
        fw2 = gcp.compute.Firewall("fw2",
            name="website-fw-2",
            network=default_network.id,
            source_ranges=["0.0.0.0/0"],
            allows=[{
                "protocol": "tcp",
                "ports": ["22"],
            }],
            target_tags=["allow-ssh"],
            direction="INGRESS",
            opts = pulumi.ResourceOptions(depends_on=[fw1]))
        fw3 = gcp.compute.Firewall("fw3",
            name="website-fw-3",
            network=default_network.id,
            source_ranges=[
                "130.211.0.0/22",
                "35.191.0.0/16",
            ],
            allows=[{
                "protocol": "tcp",
            }],
            target_tags=["load-balanced-backend"],
            direction="INGRESS",
            opts = pulumi.ResourceOptions(depends_on=[fw2]))
        fw4 = gcp.compute.Firewall("fw4",
            name="website-fw-4",
            network=default_network.id,
            source_ranges=["10.129.0.0/26"],
            target_tags=["load-balanced-backend"],
            allows=[
                {
                    "protocol": "tcp",
                    "ports": ["80"],
                },
                {
                    "protocol": "tcp",
                    "ports": ["443"],
                },
                {
                    "protocol": "tcp",
                    "ports": ["8000"],
                },
            ],
            direction="INGRESS",
            opts = pulumi.ResourceOptions(depends_on=[fw3]))
        default_region_health_check = gcp.compute.RegionHealthCheck("default",
            region="us-central1",
            name="website-hc",
            http_health_check={
                "port_specification": "USE_SERVING_PORT",
            },
            opts = pulumi.ResourceOptions(depends_on=[fw4]))
        default_region_backend_service = gcp.compute.RegionBackendService("default",
            load_balancing_scheme="INTERNAL_MANAGED",
            backends=[{
                "group": rigm.instance_group,
                "balancing_mode": "UTILIZATION",
                "capacity_scaler": 1,
            }],
            region="us-central1",
            name="website-backend",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default_region_health_check.id)
        default_region_url_map = gcp.compute.RegionUrlMap("default",
            region="us-central1",
            name="website-map",
            default_service=default_region_backend_service.id)
        default_region_target_http_proxy = gcp.compute.RegionTargetHttpProxy("default",
            region="us-central1",
            name="website-proxy",
            url_map=default_region_url_map.id)
        proxy = gcp.compute.Subnetwork("proxy",
            name="website-net-proxy",
            ip_cidr_range="10.129.0.0/26",
            region="us-central1",
            network=default_network.id,
            purpose="REGIONAL_MANAGED_PROXY",
            role="ACTIVE")
        # Forwarding rule for Internal Load Balancing
        default = gcp.compute.ForwardingRule("default",
            name="website-forwarding-rule",
            region="us-central1",
            ip_protocol="TCP",
            load_balancing_scheme="INTERNAL_MANAGED",
            port_range="80",
            target=default_region_target_http_proxy.id,
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            network_tier="PREMIUM",
            opts = pulumi.ResourceOptions(depends_on=[proxy]))
        ```
        ### Forwarding Rule Regional Http Xlb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        default_network = gcp.compute.Network("default",
            name="website-net",
            auto_create_subnetworks=False,
            routing_mode="REGIONAL")
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="website-net-default",
            ip_cidr_range="10.1.2.0/24",
            region="us-central1",
            network=default_network.id)
        instance_template = gcp.compute.InstanceTemplate("instance_template",
            name="template-website-backend",
            machine_type="e2-medium",
            network_interfaces=[{
                "network": default_network.id,
                "subnetwork": default_subnetwork.id,
            }],
            disks=[{
                "source_image": debian_image.self_link,
                "auto_delete": True,
                "boot": True,
            }],
            tags=[
                "allow-ssh",
                "load-balanced-backend",
            ])
        rigm = gcp.compute.RegionInstanceGroupManager("rigm",
            region="us-central1",
            name="website-rigm",
            versions=[{
                "instance_template": instance_template.id,
                "name": "primary",
            }],
            base_instance_name="internal-glb",
            target_size=1)
        fw1 = gcp.compute.Firewall("fw1",
            name="website-fw-1",
            network=default_network.id,
            source_ranges=["10.1.2.0/24"],
            allows=[
                {
                    "protocol": "tcp",
                },
                {
                    "protocol": "udp",
                },
                {
                    "protocol": "icmp",
                },
            ],
            direction="INGRESS")
        fw2 = gcp.compute.Firewall("fw2",
            name="website-fw-2",
            network=default_network.id,
            source_ranges=["0.0.0.0/0"],
            allows=[{
                "protocol": "tcp",
                "ports": ["22"],
            }],
            target_tags=["allow-ssh"],
            direction="INGRESS",
            opts = pulumi.ResourceOptions(depends_on=[fw1]))
        fw3 = gcp.compute.Firewall("fw3",
            name="website-fw-3",
            network=default_network.id,
            source_ranges=[
                "130.211.0.0/22",
                "35.191.0.0/16",
            ],
            allows=[{
                "protocol": "tcp",
            }],
            target_tags=["load-balanced-backend"],
            direction="INGRESS",
            opts = pulumi.ResourceOptions(depends_on=[fw2]))
        fw4 = gcp.compute.Firewall("fw4",
            name="website-fw-4",
            network=default_network.id,
            source_ranges=["10.129.0.0/26"],
            target_tags=["load-balanced-backend"],
            allows=[
                {
                    "protocol": "tcp",
                    "ports": ["80"],
                },
                {
                    "protocol": "tcp",
                    "ports": ["443"],
                },
                {
                    "protocol": "tcp",
                    "ports": ["8000"],
                },
            ],
            direction="INGRESS",
            opts = pulumi.ResourceOptions(depends_on=[fw3]))
        default_region_health_check = gcp.compute.RegionHealthCheck("default",
            region="us-central1",
            name="website-hc",
            http_health_check={
                "port_specification": "USE_SERVING_PORT",
            },
            opts = pulumi.ResourceOptions(depends_on=[fw4]))
        default_region_backend_service = gcp.compute.RegionBackendService("default",
            load_balancing_scheme="EXTERNAL_MANAGED",
            backends=[{
                "group": rigm.instance_group,
                "balancing_mode": "UTILIZATION",
                "capacity_scaler": 1,
            }],
            region="us-central1",
            name="website-backend",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default_region_health_check.id)
        default_region_url_map = gcp.compute.RegionUrlMap("default",
            region="us-central1",
            name="website-map",
            default_service=default_region_backend_service.id)
        default_region_target_http_proxy = gcp.compute.RegionTargetHttpProxy("default",
            region="us-central1",
            name="website-proxy",
            url_map=default_region_url_map.id)
        default_address = gcp.compute.Address("default",
            name="website-ip-1",
            region="us-central1",
            network_tier="STANDARD")
        proxy = gcp.compute.Subnetwork("proxy",
            name="website-net-proxy",
            ip_cidr_range="10.129.0.0/26",
            region="us-central1",
            network=default_network.id,
            purpose="REGIONAL_MANAGED_PROXY",
            role="ACTIVE")
        # Forwarding rule for Regional External Load Balancing
        default = gcp.compute.ForwardingRule("default",
            name="website-forwarding-rule",
            region="us-central1",
            ip_protocol="TCP",
            load_balancing_scheme="EXTERNAL_MANAGED",
            port_range="80",
            target=default_region_target_http_proxy.id,
            network=default_network.id,
            ip_address=default_address.address,
            network_tier="STANDARD",
            opts = pulumi.ResourceOptions(depends_on=[proxy]))
        ```
        ### Forwarding Rule Vpc Psc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # Consumer service endpoint
        consumer_net = gcp.compute.Network("consumer_net",
            name="consumer-net",
            auto_create_subnetworks=False)
        consumer_subnet = gcp.compute.Subnetwork("consumer_subnet",
            name="consumer-net",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=consumer_net.id)
        consumer_address = gcp.compute.Address("consumer_address",
            name="website-ip-1",
            region="us-central1",
            subnetwork=consumer_subnet.id,
            address_type="INTERNAL")
        # Producer service attachment
        producer_net = gcp.compute.Network("producer_net",
            name="producer-net",
            auto_create_subnetworks=False)
        psc_producer_subnet = gcp.compute.Subnetwork("psc_producer_subnet",
            name="producer-psc-net",
            ip_cidr_range="10.1.0.0/16",
            region="us-central1",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=producer_net.id)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="producer-net",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=producer_net.id)
        producer_service_health_check = gcp.compute.HealthCheck("producer_service_health_check",
            name="producer-service-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        producer_service_backend = gcp.compute.RegionBackendService("producer_service_backend",
            name="producer-service-backend",
            region="us-central1",
            health_checks=producer_service_health_check.id)
        producer_target_service = gcp.compute.ForwardingRule("producer_target_service",
            name="producer-forwarding-rule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=producer_service_backend.id,
            all_ports=True,
            network=producer_net.name,
            subnetwork=producer_subnet.name)
        producer_service_attachment = gcp.compute.ServiceAttachment("producer_service_attachment",
            name="producer-service",
            region="us-central1",
            description="A service attachment configured with Terraform",
            enable_proxy_protocol=True,
            connection_preference="ACCEPT_AUTOMATIC",
            nat_subnets=[psc_producer_subnet.name],
            target_service=producer_target_service.id)
        # Forwarding rule for VPC private service connect
        default = gcp.compute.ForwardingRule("default",
            name="psc-endpoint",
            region="us-central1",
            load_balancing_scheme="",
            target=producer_service_attachment.id,
            network=consumer_net.name,
            ip_address=consumer_address.id,
            allow_psc_global_access=True)
        ```
        ### Forwarding Rule Vpc Psc No Automate Dns

        ```python
        import pulumi
        import pulumi_gcp as gcp

        consumer_net = gcp.compute.Network("consumer_net",
            name="consumer-net",
            auto_create_subnetworks=False)
        consumer_subnet = gcp.compute.Subnetwork("consumer_subnet",
            name="consumer-net",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=consumer_net.id)
        consumer_address = gcp.compute.Address("consumer_address",
            name="website-ip-1",
            region="us-central1",
            subnetwork=consumer_subnet.id,
            address_type="INTERNAL")
        producer_net = gcp.compute.Network("producer_net",
            name="producer-net",
            auto_create_subnetworks=False)
        psc_producer_subnet = gcp.compute.Subnetwork("psc_producer_subnet",
            name="producer-psc-net",
            ip_cidr_range="10.1.0.0/16",
            region="us-central1",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=producer_net.id)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="producer-net",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=producer_net.id)
        producer_service_health_check = gcp.compute.HealthCheck("producer_service_health_check",
            name="producer-service-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        producer_service_backend = gcp.compute.RegionBackendService("producer_service_backend",
            name="producer-service-backend",
            region="us-central1",
            health_checks=producer_service_health_check.id)
        producer_target_service = gcp.compute.ForwardingRule("producer_target_service",
            name="producer-forwarding-rule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=producer_service_backend.id,
            all_ports=True,
            network=producer_net.name,
            subnetwork=producer_subnet.name)
        producer_service_attachment = gcp.compute.ServiceAttachment("producer_service_attachment",
            name="producer-service",
            region="us-central1",
            description="A service attachment configured with Terraform",
            enable_proxy_protocol=True,
            connection_preference="ACCEPT_AUTOMATIC",
            nat_subnets=[psc_producer_subnet.name],
            target_service=producer_target_service.id)
        default = gcp.compute.ForwardingRule("default",
            name="psc-endpoint",
            region="us-central1",
            load_balancing_scheme="",
            target=producer_service_attachment.id,
            network=consumer_net.name,
            ip_address=consumer_address.id,
            allow_psc_global_access=True,
            no_automate_dns_zone=True)
        ```
        ### Forwarding Rule Regional Steering

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.compute.Address("basic",
            name="website-ip",
            region="us-central1")
        external = gcp.compute.RegionBackendService("external",
            name="service-backend",
            region="us-central1",
            load_balancing_scheme="EXTERNAL")
        external_forwarding_rule = gcp.compute.ForwardingRule("external",
            name="external-forwarding-rule",
            region="us-central1",
            ip_address=basic.address,
            backend_service=external.self_link,
            load_balancing_scheme="EXTERNAL")
        steering = gcp.compute.ForwardingRule("steering",
            name="steering-rule",
            region="us-central1",
            ip_address=basic.address,
            backend_service=external.self_link,
            load_balancing_scheme="EXTERNAL",
            source_ip_ranges=[
                "34.121.88.0/24",
                "35.187.239.137",
            ],
            opts = pulumi.ResourceOptions(depends_on=[external_forwarding_rule]))
        ```
        ### Forwarding Rule Internallb Ipv6

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hc = gcp.compute.HealthCheck("hc",
            name="check-ilb-ipv6-backend",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        backend = gcp.compute.RegionBackendService("backend",
            name="ilb-ipv6-backend",
            region="us-central1",
            health_checks=hc.id)
        default_network = gcp.compute.Network("default",
            name="net-ipv6",
            auto_create_subnetworks=False,
            enable_ula_internal_ipv6=True)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="subnet-internal-ipv6",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            stack_type="IPV4_IPV6",
            ipv6_access_type="INTERNAL",
            network=default_network.id)
        # Forwarding rule for Internal Load Balancing
        default = gcp.compute.ForwardingRule("default",
            name="ilb-ipv6-forwarding-rule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=backend.id,
            all_ports=True,
            network=default_network.name,
            subnetwork=default_subnetwork.name,
            ip_version="IPV6")
        ```

        ## Import

        ForwardingRule can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/forwardingRules/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, ForwardingRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/forwardingRule:ForwardingRule default projects/{{project}}/regions/{{region}}/forwardingRules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/forwardingRule:ForwardingRule default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/forwardingRule:ForwardingRule default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/forwardingRule:ForwardingRule default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ForwardingRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ForwardingRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 all_ports: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_global_access: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_psc_global_access: Optional[pulumi.Input[builtins.bool]] = None,
                 backend_service: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_collection: Optional[pulumi.Input[builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 is_mirroring_collector: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 network_tier: Optional[pulumi.Input[builtins.str]] = None,
                 no_automate_dns_zone: Optional[pulumi.Input[builtins.bool]] = None,
                 port_range: Optional[pulumi.Input[builtins.str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 recreate_closed_psc: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_directory_registrations: Optional[pulumi.Input[Union['ForwardingRuleServiceDirectoryRegistrationsArgs', 'ForwardingRuleServiceDirectoryRegistrationsArgsDict']]] = None,
                 service_label: Optional[pulumi.Input[builtins.str]] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ForwardingRuleArgs.__new__(ForwardingRuleArgs)

            __props__.__dict__["all_ports"] = all_ports
            __props__.__dict__["allow_global_access"] = allow_global_access
            __props__.__dict__["allow_psc_global_access"] = allow_psc_global_access
            __props__.__dict__["backend_service"] = backend_service
            __props__.__dict__["description"] = description
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["ip_collection"] = ip_collection
            __props__.__dict__["ip_protocol"] = ip_protocol
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["is_mirroring_collector"] = is_mirroring_collector
            __props__.__dict__["labels"] = labels
            __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["network_tier"] = network_tier
            __props__.__dict__["no_automate_dns_zone"] = no_automate_dns_zone
            __props__.__dict__["port_range"] = port_range
            __props__.__dict__["ports"] = ports
            __props__.__dict__["project"] = project
            __props__.__dict__["recreate_closed_psc"] = recreate_closed_psc
            __props__.__dict__["region"] = region
            __props__.__dict__["service_directory_registrations"] = service_directory_registrations
            __props__.__dict__["service_label"] = service_label
            __props__.__dict__["source_ip_ranges"] = source_ip_ranges
            __props__.__dict__["subnetwork"] = subnetwork
            __props__.__dict__["target"] = target
            __props__.__dict__["base_forwarding_rule"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["forwarding_rule_id"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["psc_connection_id"] = None
            __props__.__dict__["psc_connection_status"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["service_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ForwardingRule, __self__).__init__(
            'gcp:compute/forwardingRule:ForwardingRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_ports: Optional[pulumi.Input[builtins.bool]] = None,
            allow_global_access: Optional[pulumi.Input[builtins.bool]] = None,
            allow_psc_global_access: Optional[pulumi.Input[builtins.bool]] = None,
            backend_service: Optional[pulumi.Input[builtins.str]] = None,
            base_forwarding_rule: Optional[pulumi.Input[builtins.str]] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            forwarding_rule_id: Optional[pulumi.Input[builtins.int]] = None,
            ip_address: Optional[pulumi.Input[builtins.str]] = None,
            ip_collection: Optional[pulumi.Input[builtins.str]] = None,
            ip_protocol: Optional[pulumi.Input[builtins.str]] = None,
            ip_version: Optional[pulumi.Input[builtins.str]] = None,
            is_mirroring_collector: Optional[pulumi.Input[builtins.bool]] = None,
            label_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            load_balancing_scheme: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            network_tier: Optional[pulumi.Input[builtins.str]] = None,
            no_automate_dns_zone: Optional[pulumi.Input[builtins.bool]] = None,
            port_range: Optional[pulumi.Input[builtins.str]] = None,
            ports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            psc_connection_id: Optional[pulumi.Input[builtins.str]] = None,
            psc_connection_status: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            recreate_closed_psc: Optional[pulumi.Input[builtins.bool]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            service_directory_registrations: Optional[pulumi.Input[Union['ForwardingRuleServiceDirectoryRegistrationsArgs', 'ForwardingRuleServiceDirectoryRegistrationsArgsDict']]] = None,
            service_label: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            subnetwork: Optional[pulumi.Input[builtins.str]] = None,
            target: Optional[pulumi.Input[builtins.str]] = None) -> 'ForwardingRule':
        """
        Get an existing ForwardingRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] all_ports: The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
               Only packets addressed to ports in the specified range will be forwarded
               to the backends configured with this forwarding rule.
               The `allPorts` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, SCTP, or
               L3_DEFAULT.
               * It's applicable only to the following products: internal passthrough
               Network Load Balancers, backend service-based external passthrough Network
               Load Balancers, and internal and external protocol forwarding.
               * Set this field to true to allow packets addressed to any port or packets
               lacking destination port information (for example, UDP fragments after the
               first fragment) to be forwarded to the backends configured with this
               forwarding rule. The L3_DEFAULT protocol requires `allPorts` be set to
               true.
        :param pulumi.Input[builtins.bool] allow_global_access: This field is used along with the `backend_service` field for
               internal load balancing or with the `target` field for internal
               TargetInstance.
               If the field is set to `TRUE`, clients can access ILB from all
               regions.
               Otherwise only allows access from clients in the same region as the
               internal load balancer.
        :param pulumi.Input[builtins.bool] allow_psc_global_access: This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        :param pulumi.Input[builtins.str] backend_service: Identifies the backend service to which the forwarding rule sends traffic.
               Required for Internal TCP/UDP Load Balancing and Network Load Balancing;
               must be omitted for all other load balancer types.
        :param pulumi.Input[builtins.str] base_forwarding_rule: [Output Only] The URL for the corresponding base Forwarding Rule. By base Forwarding Rule, we mean the Forwarding Rule that has the same IP address, protocol, and port settings with the current Forwarding Rule, but without sourceIPRanges specified. Always empty if the current Forwarding Rule does not have sourceIPRanges specified.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.int] forwarding_rule_id: The unique identifier number for the resource. This identifier is defined by the server.
        :param pulumi.Input[builtins.str] ip_address: IP address for which this forwarding rule accepts traffic. When a client
               sends traffic to this IP address, the forwarding rule directs the traffic
               to the referenced `target` or `backendService`.
               While creating a forwarding rule, specifying an `IPAddress` is
               required under the following circumstances:
               * When the `target` is set to `targetGrpcProxy` and
               `validateForProxyless` is set to `true`, the
               `IPAddress` should be set to `0.0.0.0`.
               * When the `target` is a Private Service Connect Google APIs
               bundle, you must specify an `IPAddress`.
               Otherwise, you can optionally specify an IP address that references an
               existing static (reserved) IP address resource. When omitted, Google Cloud
               assigns an ephemeral IP address.
               Use one of the following formats to specify an IP address while creating a
               forwarding rule:
               * IP address number, as in `100.1.2.3`
               * IPv6 address range, as in `2600:1234::/96`
               * Full resource URL, as in
               `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
               * Partial URL or by name, as in:
               * `projects/project_id/regions/region/addresses/address-name`
               * `regions/region/addresses/address-name`
               * `global/addresses/address-name`
               * `address-name`
               The forwarding rule's `target` or `backendService`,
               and in most cases, also the `loadBalancingScheme`, determine the
               type of IP address that you can use. For detailed information, see
               [IP address
               specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               When reading an `IPAddress`, the API always returns the IP
               address number.
        :param pulumi.Input[builtins.str] ip_collection: Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP
               in EXTERNAL_IPV6_FORWARDING_RULE_CREATION mode.
               Use one of the following formats to specify a sub-PDP when creating an
               IPv6 NetLB forwarding rule using BYOIP:
               Full resource URL, as in:
               * `https://www.googleapis.com/compute/v1/projects/{{projectId}}/regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
               Partial URL, as in:
               * `projects/{{projectId}}/regions/region/publicDelegatedPrefixes/{{sub-pdp-name}}`
               * `regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        :param pulumi.Input[builtins.str] ip_protocol: The IP protocol to which this rule applies.
               For protocol forwarding, valid
               options are `TCP`, `UDP`, `ESP`,
               `AH`, `SCTP`, `ICMP` and
               `L3_DEFAULT`.
               The valid IP protocols are different for different load balancing products
               as described in [Load balancing
               features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
               A Forwarding Rule with protocol L3_DEFAULT can attach with target instance or
               backend service with UNSPECIFIED protocol.
               A forwarding rule with "L3_DEFAULT" IPProtocal cannot be attached to a backend service with TCP or UDP.
               Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`, `L3_DEFAULT`.
        :param pulumi.Input[builtins.str] ip_version: The IP address version that will be used by this forwarding rule.
               Valid options are IPV4 and IPV6.
               If not set, the IPv4 address will be used by default.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[builtins.bool] is_mirroring_collector: Indicates whether or not this load balancer can be used as a collector for
               packet mirroring. To prevent mirroring loops, instances behind this
               load balancer will not have their traffic mirrored even if a
               `PacketMirroring` rule applies to them.
               This can only be set to true for load balancers that have their
               `loadBalancingScheme` set to `INTERNAL`.
        :param pulumi.Input[builtins.str] label_fingerprint: The fingerprint used for optimistic locking of this resource.  Used
               internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] load_balancing_scheme: Specifies the forwarding rule type.
               Note that an empty string value (`""`) is also supported for some use
               cases, for example PSC (private service connection) regional forwarding
               rules.
               For more information about forwarding rules, refer to
               [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, `INTERNAL_MANAGED`.
        :param pulumi.Input[builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, the forwarding rule name must be a 1-20 characters string with
               lowercase letters and numbers and must start with a letter.
               
               
               - - -
        :param pulumi.Input[builtins.str] network: This field is not used for external load balancing.
               For Internal TCP/UDP Load Balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule.
               If the subnetwork is specified, the network of the subnetwork will be used.
               If neither subnetwork nor this field is specified, the default network will
               be used.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, a network must be provided.
        :param pulumi.Input[builtins.str] network_tier: This signifies the networking tier used for configuring
               this load balancer and can only take the following values:
               `PREMIUM`, `STANDARD`.
               For regional ForwardingRule, the valid values are `PREMIUM` and
               `STANDARD`. For GlobalForwardingRule, the valid value is
               `PREMIUM`.
               If this field is not specified, it is assumed to be `PREMIUM`.
               If `IPAddress` is specified, this value must be equal to the
               networkTier of the Address.
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[builtins.bool] no_automate_dns_zone: This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        :param pulumi.Input[builtins.str] port_range: The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
               Only packets addressed to ports in the specified range will be forwarded
               to the backends configured with this forwarding rule.
               The `portRange` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
               and
               * It's applicable only to the following products: external passthrough
               Network Load Balancers, internal and external proxy Network Load
               Balancers, internal and external Application Load Balancers, external
               protocol forwarding, and Classic VPN.
               * Some products have restrictions on what ports can be used. See
               [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
               for details.
               For external forwarding rules, two or more forwarding rules cannot use the
               same `[IPAddress, IPProtocol]` pair, and cannot have overlapping
               `portRange`s.
               For internal forwarding rules within the same VPC network, two or more
               forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair, and
               cannot have overlapping `portRange`s.
               @pattern: \\d+(?:-\\d+)?
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ports: The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
               Only packets addressed to ports in the specified range will be forwarded
               to the backends configured with this forwarding rule.
               The `ports` field has the following limitations:
               * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
               and
               * It's applicable only to the following products: internal passthrough
               Network Load Balancers, backend service-based external passthrough Network
               Load Balancers, and internal protocol forwarding.
               * You can specify a list of up to five ports by number, separated by
               commas. The ports can be contiguous or discontiguous.
               For external forwarding rules, two or more forwarding rules cannot use the
               same `[IPAddress, IPProtocol]` pair if they share at least one port
               number.
               For internal forwarding rules within the same VPC network, two or more
               forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair if
               they share at least one port number.
               @pattern: \\d+(?:-\\d+)?
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] psc_connection_id: The PSC connection id of the PSC Forwarding Rule.
        :param pulumi.Input[builtins.str] psc_connection_status: The PSC connection status of the PSC Forwarding Rule. Possible values: `STATUS_UNSPECIFIED`, `PENDING`, `ACCEPTED`, `REJECTED`, `CLOSED`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] region: A reference to the region where the regional forwarding rule resides.
               This field is not applicable to global forwarding rules.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Union['ForwardingRuleServiceDirectoryRegistrationsArgs', 'ForwardingRuleServiceDirectoryRegistrationsArgsDict']] service_directory_registrations: Service Directory resources to register this forwarding rule with.
               Currently, only supports a single Service Directory resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] service_label: An optional prefix to the service name for this Forwarding Rule.
               If specified, will be the first label of the fully qualified service
               name.
               The label must be 1-63 characters long, and comply with RFC1035.
               Specifically, the label must be 1-63 characters long and match the
               regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters
               must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               This field is only used for INTERNAL load balancing.
        :param pulumi.Input[builtins.str] service_name: The internal fully qualified service name for this Forwarding Rule.
               This field is only used for INTERNAL load balancing.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_ip_ranges: If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        :param pulumi.Input[builtins.str] subnetwork: This field identifies the subnetwork that the load balanced IP should
               belong to for this Forwarding Rule, used in internal load balancing and
               network load balancing with IPv6.
               If the network specified is in auto subnet mode, this field is optional.
               However, a subnetwork must be specified if the network is in custom subnet
               mode or when creating external forwarding rule with IPv6.
        :param pulumi.Input[builtins.str] target: The URL of the target resource to receive the matched traffic.  For
               regional forwarding rules, this target must be in the same region as the
               forwarding rule. For global forwarding rules, this target must be a global
               load balancing resource.
               The forwarded traffic must be of a type appropriate to the target object.
               *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
               *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
               *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
               For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ForwardingRuleState.__new__(_ForwardingRuleState)

        __props__.__dict__["all_ports"] = all_ports
        __props__.__dict__["allow_global_access"] = allow_global_access
        __props__.__dict__["allow_psc_global_access"] = allow_psc_global_access
        __props__.__dict__["backend_service"] = backend_service
        __props__.__dict__["base_forwarding_rule"] = base_forwarding_rule
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["forwarding_rule_id"] = forwarding_rule_id
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ip_collection"] = ip_collection
        __props__.__dict__["ip_protocol"] = ip_protocol
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["is_mirroring_collector"] = is_mirroring_collector
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["network_tier"] = network_tier
        __props__.__dict__["no_automate_dns_zone"] = no_automate_dns_zone
        __props__.__dict__["port_range"] = port_range
        __props__.__dict__["ports"] = ports
        __props__.__dict__["project"] = project
        __props__.__dict__["psc_connection_id"] = psc_connection_id
        __props__.__dict__["psc_connection_status"] = psc_connection_status
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["recreate_closed_psc"] = recreate_closed_psc
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["service_directory_registrations"] = service_directory_registrations
        __props__.__dict__["service_label"] = service_label
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["source_ip_ranges"] = source_ip_ranges
        __props__.__dict__["subnetwork"] = subnetwork
        __props__.__dict__["target"] = target
        return ForwardingRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allPorts")
    def all_ports(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
        Only packets addressed to ports in the specified range will be forwarded
        to the backends configured with this forwarding rule.
        The `allPorts` field has the following limitations:
        * It requires that the forwarding rule `IPProtocol` be TCP, UDP, SCTP, or
        L3_DEFAULT.
        * It's applicable only to the following products: internal passthrough
        Network Load Balancers, backend service-based external passthrough Network
        Load Balancers, and internal and external protocol forwarding.
        * Set this field to true to allow packets addressed to any port or packets
        lacking destination port information (for example, UDP fragments after the
        first fragment) to be forwarded to the backends configured with this
        forwarding rule. The L3_DEFAULT protocol requires `allPorts` be set to
        true.
        """
        return pulumi.get(self, "all_ports")

    @property
    @pulumi.getter(name="allowGlobalAccess")
    def allow_global_access(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This field is used along with the `backend_service` field for
        internal load balancing or with the `target` field for internal
        TargetInstance.
        If the field is set to `TRUE`, clients can access ILB from all
        regions.
        Otherwise only allows access from clients in the same region as the
        internal load balancer.
        """
        return pulumi.get(self, "allow_global_access")

    @property
    @pulumi.getter(name="allowPscGlobalAccess")
    def allow_psc_global_access(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        """
        return pulumi.get(self, "allow_psc_global_access")

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifies the backend service to which the forwarding rule sends traffic.
        Required for Internal TCP/UDP Load Balancing and Network Load Balancing;
        must be omitted for all other load balancer types.
        """
        return pulumi.get(self, "backend_service")

    @property
    @pulumi.getter(name="baseForwardingRule")
    def base_forwarding_rule(self) -> pulumi.Output[builtins.str]:
        """
        [Output Only] The URL for the corresponding base Forwarding Rule. By base Forwarding Rule, we mean the Forwarding Rule that has the same IP address, protocol, and port settings with the current Forwarding Rule, but without sourceIPRanges specified. Always empty if the current Forwarding Rule does not have sourceIPRanges specified.
        """
        return pulumi.get(self, "base_forwarding_rule")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="forwardingRuleId")
    def forwarding_rule_id(self) -> pulumi.Output[builtins.int]:
        """
        The unique identifier number for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "forwarding_rule_id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[builtins.str]:
        """
        IP address for which this forwarding rule accepts traffic. When a client
        sends traffic to this IP address, the forwarding rule directs the traffic
        to the referenced `target` or `backendService`.
        While creating a forwarding rule, specifying an `IPAddress` is
        required under the following circumstances:
        * When the `target` is set to `targetGrpcProxy` and
        `validateForProxyless` is set to `true`, the
        `IPAddress` should be set to `0.0.0.0`.
        * When the `target` is a Private Service Connect Google APIs
        bundle, you must specify an `IPAddress`.
        Otherwise, you can optionally specify an IP address that references an
        existing static (reserved) IP address resource. When omitted, Google Cloud
        assigns an ephemeral IP address.
        Use one of the following formats to specify an IP address while creating a
        forwarding rule:
        * IP address number, as in `100.1.2.3`
        * IPv6 address range, as in `2600:1234::/96`
        * Full resource URL, as in
        `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
        * Partial URL or by name, as in:
        * `projects/project_id/regions/region/addresses/address-name`
        * `regions/region/addresses/address-name`
        * `global/addresses/address-name`
        * `address-name`
        The forwarding rule's `target` or `backendService`,
        and in most cases, also the `loadBalancingScheme`, determine the
        type of IP address that you can use. For detailed information, see
        [IP address
        specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        When reading an `IPAddress`, the API always returns the IP
        address number.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipCollection")
    def ip_collection(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP
        in EXTERNAL_IPV6_FORWARDING_RULE_CREATION mode.
        Use one of the following formats to specify a sub-PDP when creating an
        IPv6 NetLB forwarding rule using BYOIP:
        Full resource URL, as in:
        * `https://www.googleapis.com/compute/v1/projects/{{projectId}}/regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        Partial URL, as in:
        * `projects/{{projectId}}/regions/region/publicDelegatedPrefixes/{{sub-pdp-name}}`
        * `regions/{{region}}/publicDelegatedPrefixes/{{sub-pdp-name}}`
        """
        return pulumi.get(self, "ip_collection")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> pulumi.Output[builtins.str]:
        """
        The IP protocol to which this rule applies.
        For protocol forwarding, valid
        options are `TCP`, `UDP`, `ESP`,
        `AH`, `SCTP`, `ICMP` and
        `L3_DEFAULT`.
        The valid IP protocols are different for different load balancing products
        as described in [Load balancing
        features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
        A Forwarding Rule with protocol L3_DEFAULT can attach with target instance or
        backend service with UNSPECIFIED protocol.
        A forwarding rule with "L3_DEFAULT" IPProtocal cannot be attached to a backend service with TCP or UDP.
        Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`, `L3_DEFAULT`.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[builtins.str]:
        """
        The IP address version that will be used by this forwarding rule.
        Valid options are IPV4 and IPV6.
        If not set, the IPv4 address will be used by default.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="isMirroringCollector")
    def is_mirroring_collector(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether or not this load balancer can be used as a collector for
        packet mirroring. To prevent mirroring loops, instances behind this
        load balancer will not have their traffic mirrored even if a
        `PacketMirroring` rule applies to them.
        This can only be set to true for load balancers that have their
        `loadBalancingScheme` set to `INTERNAL`.
        """
        return pulumi.get(self, "is_mirroring_collector")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        The fingerprint used for optimistic locking of this resource.  Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels to apply to this forwarding rule.  A list of key->value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the forwarding rule type.
        Note that an empty string value (`""`) is also supported for some use
        cases, for example PSC (private service connection) regional forwarding
        rules.
        For more information about forwarding rules, refer to
        [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, `INTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
        Specifically, the name must be 1-63 characters long and match the regular
        expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must
        be a dash, lowercase letter, or digit, except the last character, which
        cannot be a dash.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, the forwarding rule name must be a 1-20 characters string with
        lowercase letters and numbers and must start with a letter.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[builtins.str]:
        """
        This field is not used for external load balancing.
        For Internal TCP/UDP Load Balancing, this field identifies the network that
        the load balanced IP should belong to for this Forwarding Rule.
        If the subnetwork is specified, the network of the subnetwork will be used.
        If neither subnetwork nor this field is specified, the default network will
        be used.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, a network must be provided.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> pulumi.Output[builtins.str]:
        """
        This signifies the networking tier used for configuring
        this load balancer and can only take the following values:
        `PREMIUM`, `STANDARD`.
        For regional ForwardingRule, the valid values are `PREMIUM` and
        `STANDARD`. For GlobalForwardingRule, the valid value is
        `PREMIUM`.
        If this field is not specified, it is assumed to be `PREMIUM`.
        If `IPAddress` is specified, this value must be equal to the
        networkTier of the Address.
        Possible values are: `PREMIUM`, `STANDARD`.
        """
        return pulumi.get(self, "network_tier")

    @property
    @pulumi.getter(name="noAutomateDnsZone")
    def no_automate_dns_zone(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        """
        return pulumi.get(self, "no_automate_dns_zone")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> pulumi.Output[builtins.str]:
        """
        The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
        Only packets addressed to ports in the specified range will be forwarded
        to the backends configured with this forwarding rule.
        The `portRange` field has the following limitations:
        * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
        and
        * It's applicable only to the following products: external passthrough
        Network Load Balancers, internal and external proxy Network Load
        Balancers, internal and external Application Load Balancers, external
        protocol forwarding, and Classic VPN.
        * Some products have restrictions on what ports can be used. See
        [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
        for details.
        For external forwarding rules, two or more forwarding rules cannot use the
        same `[IPAddress, IPProtocol]` pair, and cannot have overlapping
        `portRange`s.
        For internal forwarding rules within the same VPC network, two or more
        forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair, and
        cannot have overlapping `portRange`s.
        @pattern: \\d+(?:-\\d+)?
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The `ports`, `portRange`, and `allPorts` fields are mutually exclusive.
        Only packets addressed to ports in the specified range will be forwarded
        to the backends configured with this forwarding rule.
        The `ports` field has the following limitations:
        * It requires that the forwarding rule `IPProtocol` be TCP, UDP, or SCTP,
        and
        * It's applicable only to the following products: internal passthrough
        Network Load Balancers, backend service-based external passthrough Network
        Load Balancers, and internal protocol forwarding.
        * You can specify a list of up to five ports by number, separated by
        commas. The ports can be contiguous or discontiguous.
        For external forwarding rules, two or more forwarding rules cannot use the
        same `[IPAddress, IPProtocol]` pair if they share at least one port
        number.
        For internal forwarding rules within the same VPC network, two or more
        forwarding rules cannot use the same `[IPAddress, IPProtocol]` pair if
        they share at least one port number.
        @pattern: \\d+(?:-\\d+)?
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> pulumi.Output[builtins.str]:
        """
        The PSC connection id of the PSC Forwarding Rule.
        """
        return pulumi.get(self, "psc_connection_id")

    @property
    @pulumi.getter(name="pscConnectionStatus")
    def psc_connection_status(self) -> pulumi.Output[builtins.str]:
        """
        The PSC connection status of the PSC Forwarding Rule. Possible values: `STATUS_UNSPECIFIED`, `PENDING`, `ACCEPTED`, `REJECTED`, `CLOSED`
        """
        return pulumi.get(self, "psc_connection_status")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="recreateClosedPsc")
    def recreate_closed_psc(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "recreate_closed_psc")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        A reference to the region where the regional forwarding rule resides.
        This field is not applicable to global forwarding rules.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serviceDirectoryRegistrations")
    def service_directory_registrations(self) -> pulumi.Output['outputs.ForwardingRuleServiceDirectoryRegistrations']:
        """
        Service Directory resources to register this forwarding rule with.
        Currently, only supports a single Service Directory resource.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_registrations")

    @property
    @pulumi.getter(name="serviceLabel")
    def service_label(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional prefix to the service name for this Forwarding Rule.
        If specified, will be the first label of the fully qualified service
        name.
        The label must be 1-63 characters long, and comply with RFC1035.
        Specifically, the label must be 1-63 characters long and match the
        regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters
        must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        This field is only used for INTERNAL load balancing.
        """
        return pulumi.get(self, "service_label")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        The internal fully qualified service name for this Forwarding Rule.
        This field is only used for INTERNAL load balancing.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="sourceIpRanges")
    def source_ip_ranges(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        """
        return pulumi.get(self, "source_ip_ranges")

    @property
    @pulumi.getter
    def subnetwork(self) -> pulumi.Output[builtins.str]:
        """
        This field identifies the subnetwork that the load balanced IP should
        belong to for this Forwarding Rule, used in internal load balancing and
        network load balancing with IPv6.
        If the network specified is in auto subnet mode, this field is optional.
        However, a subnetwork must be specified if the network is in custom subnet
        mode or when creating external forwarding rule with IPv6.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URL of the target resource to receive the matched traffic.  For
        regional forwarding rules, this target must be in the same region as the
        forwarding rule. For global forwarding rules, this target must be a global
        load balancing resource.
        The forwarded traffic must be of a type appropriate to the target object.
        *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
        *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
        *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
        For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
        """
        return pulumi.get(self, "target")

