# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FutureReservationArgs', 'FutureReservation']

@pulumi.input_type
class FutureReservationArgs:
    def __init__(__self__, *,
                 time_window: pulumi.Input['FutureReservationTimeWindowArgs'],
                 auto_created_reservations_delete_time: Optional[pulumi.Input[builtins.str]] = None,
                 auto_created_reservations_duration: Optional[pulumi.Input['FutureReservationAutoCreatedReservationsDurationArgs']] = None,
                 auto_delete_auto_created_reservations: Optional[pulumi.Input[builtins.bool]] = None,
                 commitment_info: Optional[pulumi.Input['FutureReservationCommitmentInfoArgs']] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 planning_status: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reservation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 reservation_name: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_type: Optional[pulumi.Input[builtins.str]] = None,
                 share_settings: Optional[pulumi.Input['FutureReservationShareSettingsArgs']] = None,
                 specific_reservation_required: Optional[pulumi.Input[builtins.bool]] = None,
                 specific_sku_properties: Optional[pulumi.Input['FutureReservationSpecificSkuPropertiesArgs']] = None):
        """
        The set of arguments for constructing a FutureReservation resource.
        :param pulumi.Input['FutureReservationTimeWindowArgs'] time_window: Time window for this Future Reservation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] auto_created_reservations_delete_time: Future timestamp when the FR auto-created reservations will be deleted by Compute Engine.
        :param pulumi.Input['FutureReservationAutoCreatedReservationsDurationArgs'] auto_created_reservations_duration: Specifies the duration of auto-created reservations. It represents relative time to future reservation startTime when
               auto-created reservations will be automatically deleted by Compute Engine. Duration time unit is represented as a count
               of seconds and fractions of seconds at nanosecond resolution.
        :param pulumi.Input[builtins.bool] auto_delete_auto_created_reservations: Setting for enabling or disabling automatic deletion for auto-created reservation. If set to true, auto-created
               reservations will be deleted at Future Reservation's end time (default) or at user's defined timestamp if any of the
               [autoCreatedReservationsDeleteTime, autoCreatedReservationsDuration] values is specified. For keeping auto-created
               reservation indefinitely, this value should be set to false.
        :param pulumi.Input['FutureReservationCommitmentInfoArgs'] commitment_info: If not present, then FR will not deliver a new commitment or update an existing commitment.
        :param pulumi.Input[builtins.str] deployment_type: Type of the deployment requested as part of future reservation. Possible values: ["DENSE", "FLEXIBLE"]
        :param pulumi.Input[builtins.str] description: The description of the FutureReservation before an amendment was requested.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the las
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] name_prefix: The name prefix of the Future Reservation before an amendment was requested.
        :param pulumi.Input[builtins.str] planning_status: Planning state before being submitted for evaluation Possible values: ["DRAFT", "SUBMITTED"]
        :param pulumi.Input[builtins.str] project: (Required) The identifier for this object. Format specified above.
        :param pulumi.Input[builtins.str] reservation_mode: The reservation mode which determines reservation-termination behavior and expected pricing. Possible values:
               ["CALENDAR", "DEFAULT"]
        :param pulumi.Input[builtins.str] reservation_name: Name of reservations where the capacity is provisioned at the time of delivery of future reservations. If the
               reservation with the given name does not exist already, it is created automatically at the time of Approval with
               INACTIVE state till specified start-time. Either provide the reservationName or a namePrefix.
        :param pulumi.Input[builtins.str] scheduling_type: Maintenance information for this reservation Possible values: ["GROUPED", "INDEPENDENT"]
        :param pulumi.Input['FutureReservationShareSettingsArgs'] share_settings: The previous share settings of the Future Reservation.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] specific_reservation_required: Indicates whether the auto-created reservation can be consumed by VMs with affinity for "any" reservation. If the field
               is set, then only VMs that target the reservation by name can consume from the delivered reservation.
        :param pulumi.Input['FutureReservationSpecificSkuPropertiesArgs'] specific_sku_properties: The previous instance related properties of the Future Reservation.
               Structure is documented below.
        """
        pulumi.set(__self__, "time_window", time_window)
        if auto_created_reservations_delete_time is not None:
            pulumi.set(__self__, "auto_created_reservations_delete_time", auto_created_reservations_delete_time)
        if auto_created_reservations_duration is not None:
            pulumi.set(__self__, "auto_created_reservations_duration", auto_created_reservations_duration)
        if auto_delete_auto_created_reservations is not None:
            pulumi.set(__self__, "auto_delete_auto_created_reservations", auto_delete_auto_created_reservations)
        if commitment_info is not None:
            pulumi.set(__self__, "commitment_info", commitment_info)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if planning_status is not None:
            pulumi.set(__self__, "planning_status", planning_status)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reservation_mode is not None:
            pulumi.set(__self__, "reservation_mode", reservation_mode)
        if reservation_name is not None:
            pulumi.set(__self__, "reservation_name", reservation_name)
        if scheduling_type is not None:
            pulumi.set(__self__, "scheduling_type", scheduling_type)
        if share_settings is not None:
            pulumi.set(__self__, "share_settings", share_settings)
        if specific_reservation_required is not None:
            pulumi.set(__self__, "specific_reservation_required", specific_reservation_required)
        if specific_sku_properties is not None:
            pulumi.set(__self__, "specific_sku_properties", specific_sku_properties)

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> pulumi.Input['FutureReservationTimeWindowArgs']:
        """
        Time window for this Future Reservation.
        Structure is documented below.
        """
        return pulumi.get(self, "time_window")

    @time_window.setter
    def time_window(self, value: pulumi.Input['FutureReservationTimeWindowArgs']):
        pulumi.set(self, "time_window", value)

    @property
    @pulumi.getter(name="autoCreatedReservationsDeleteTime")
    def auto_created_reservations_delete_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Future timestamp when the FR auto-created reservations will be deleted by Compute Engine.
        """
        return pulumi.get(self, "auto_created_reservations_delete_time")

    @auto_created_reservations_delete_time.setter
    def auto_created_reservations_delete_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_created_reservations_delete_time", value)

    @property
    @pulumi.getter(name="autoCreatedReservationsDuration")
    def auto_created_reservations_duration(self) -> Optional[pulumi.Input['FutureReservationAutoCreatedReservationsDurationArgs']]:
        """
        Specifies the duration of auto-created reservations. It represents relative time to future reservation startTime when
        auto-created reservations will be automatically deleted by Compute Engine. Duration time unit is represented as a count
        of seconds and fractions of seconds at nanosecond resolution.
        """
        return pulumi.get(self, "auto_created_reservations_duration")

    @auto_created_reservations_duration.setter
    def auto_created_reservations_duration(self, value: Optional[pulumi.Input['FutureReservationAutoCreatedReservationsDurationArgs']]):
        pulumi.set(self, "auto_created_reservations_duration", value)

    @property
    @pulumi.getter(name="autoDeleteAutoCreatedReservations")
    def auto_delete_auto_created_reservations(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Setting for enabling or disabling automatic deletion for auto-created reservation. If set to true, auto-created
        reservations will be deleted at Future Reservation's end time (default) or at user's defined timestamp if any of the
        [autoCreatedReservationsDeleteTime, autoCreatedReservationsDuration] values is specified. For keeping auto-created
        reservation indefinitely, this value should be set to false.
        """
        return pulumi.get(self, "auto_delete_auto_created_reservations")

    @auto_delete_auto_created_reservations.setter
    def auto_delete_auto_created_reservations(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_delete_auto_created_reservations", value)

    @property
    @pulumi.getter(name="commitmentInfo")
    def commitment_info(self) -> Optional[pulumi.Input['FutureReservationCommitmentInfoArgs']]:
        """
        If not present, then FR will not deliver a new commitment or update an existing commitment.
        """
        return pulumi.get(self, "commitment_info")

    @commitment_info.setter
    def commitment_info(self, value: Optional[pulumi.Input['FutureReservationCommitmentInfoArgs']]):
        pulumi.set(self, "commitment_info", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the deployment requested as part of future reservation. Possible values: ["DENSE", "FLEXIBLE"]
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the FutureReservation before an amendment was requested.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the las
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name prefix of the Future Reservation before an amendment was requested.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="planningStatus")
    def planning_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Planning state before being submitted for evaluation Possible values: ["DRAFT", "SUBMITTED"]
        """
        return pulumi.get(self, "planning_status")

    @planning_status.setter
    def planning_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "planning_status", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Required) The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="reservationMode")
    def reservation_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reservation mode which determines reservation-termination behavior and expected pricing. Possible values:
        ["CALENDAR", "DEFAULT"]
        """
        return pulumi.get(self, "reservation_mode")

    @reservation_mode.setter
    def reservation_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reservation_mode", value)

    @property
    @pulumi.getter(name="reservationName")
    def reservation_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of reservations where the capacity is provisioned at the time of delivery of future reservations. If the
        reservation with the given name does not exist already, it is created automatically at the time of Approval with
        INACTIVE state till specified start-time. Either provide the reservationName or a namePrefix.
        """
        return pulumi.get(self, "reservation_name")

    @reservation_name.setter
    def reservation_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reservation_name", value)

    @property
    @pulumi.getter(name="schedulingType")
    def scheduling_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maintenance information for this reservation Possible values: ["GROUPED", "INDEPENDENT"]
        """
        return pulumi.get(self, "scheduling_type")

    @scheduling_type.setter
    def scheduling_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scheduling_type", value)

    @property
    @pulumi.getter(name="shareSettings")
    def share_settings(self) -> Optional[pulumi.Input['FutureReservationShareSettingsArgs']]:
        """
        The previous share settings of the Future Reservation.
        Structure is documented below.
        """
        return pulumi.get(self, "share_settings")

    @share_settings.setter
    def share_settings(self, value: Optional[pulumi.Input['FutureReservationShareSettingsArgs']]):
        pulumi.set(self, "share_settings", value)

    @property
    @pulumi.getter(name="specificReservationRequired")
    def specific_reservation_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the auto-created reservation can be consumed by VMs with affinity for "any" reservation. If the field
        is set, then only VMs that target the reservation by name can consume from the delivered reservation.
        """
        return pulumi.get(self, "specific_reservation_required")

    @specific_reservation_required.setter
    def specific_reservation_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "specific_reservation_required", value)

    @property
    @pulumi.getter(name="specificSkuProperties")
    def specific_sku_properties(self) -> Optional[pulumi.Input['FutureReservationSpecificSkuPropertiesArgs']]:
        """
        The previous instance related properties of the Future Reservation.
        Structure is documented below.
        """
        return pulumi.get(self, "specific_sku_properties")

    @specific_sku_properties.setter
    def specific_sku_properties(self, value: Optional[pulumi.Input['FutureReservationSpecificSkuPropertiesArgs']]):
        pulumi.set(self, "specific_sku_properties", value)


@pulumi.input_type
class _FutureReservationState:
    def __init__(__self__, *,
                 auto_created_reservations_delete_time: Optional[pulumi.Input[builtins.str]] = None,
                 auto_created_reservations_duration: Optional[pulumi.Input['FutureReservationAutoCreatedReservationsDurationArgs']] = None,
                 auto_delete_auto_created_reservations: Optional[pulumi.Input[builtins.bool]] = None,
                 commitment_info: Optional[pulumi.Input['FutureReservationCommitmentInfoArgs']] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 planning_status: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reservation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 reservation_name: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_type: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 self_link_with_id: Optional[pulumi.Input[builtins.str]] = None,
                 share_settings: Optional[pulumi.Input['FutureReservationShareSettingsArgs']] = None,
                 specific_reservation_required: Optional[pulumi.Input[builtins.bool]] = None,
                 specific_sku_properties: Optional[pulumi.Input['FutureReservationSpecificSkuPropertiesArgs']] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['FutureReservationStatusArgs']]]] = None,
                 time_window: Optional[pulumi.Input['FutureReservationTimeWindowArgs']] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering FutureReservation resources.
        :param pulumi.Input[builtins.str] auto_created_reservations_delete_time: Future timestamp when the FR auto-created reservations will be deleted by Compute Engine.
        :param pulumi.Input['FutureReservationAutoCreatedReservationsDurationArgs'] auto_created_reservations_duration: Specifies the duration of auto-created reservations. It represents relative time to future reservation startTime when
               auto-created reservations will be automatically deleted by Compute Engine. Duration time unit is represented as a count
               of seconds and fractions of seconds at nanosecond resolution.
        :param pulumi.Input[builtins.bool] auto_delete_auto_created_reservations: Setting for enabling or disabling automatic deletion for auto-created reservation. If set to true, auto-created
               reservations will be deleted at Future Reservation's end time (default) or at user's defined timestamp if any of the
               [autoCreatedReservationsDeleteTime, autoCreatedReservationsDuration] values is specified. For keeping auto-created
               reservation indefinitely, this value should be set to false.
        :param pulumi.Input['FutureReservationCommitmentInfoArgs'] commitment_info: If not present, then FR will not deliver a new commitment or update an existing commitment.
        :param pulumi.Input[builtins.str] creation_timestamp: The creation timestamp for this future reservation in RFC3339 text format.
        :param pulumi.Input[builtins.str] deployment_type: Type of the deployment requested as part of future reservation. Possible values: ["DENSE", "FLEXIBLE"]
        :param pulumi.Input[builtins.str] description: The description of the FutureReservation before an amendment was requested.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the las
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] name_prefix: The name prefix of the Future Reservation before an amendment was requested.
        :param pulumi.Input[builtins.str] planning_status: Planning state before being submitted for evaluation Possible values: ["DRAFT", "SUBMITTED"]
        :param pulumi.Input[builtins.str] project: (Required) The identifier for this object. Format specified above.
        :param pulumi.Input[builtins.str] reservation_mode: The reservation mode which determines reservation-termination behavior and expected pricing. Possible values:
               ["CALENDAR", "DEFAULT"]
        :param pulumi.Input[builtins.str] reservation_name: Name of reservations where the capacity is provisioned at the time of delivery of future reservations. If the
               reservation with the given name does not exist already, it is created automatically at the time of Approval with
               INACTIVE state till specified start-time. Either provide the reservationName or a namePrefix.
        :param pulumi.Input[builtins.str] scheduling_type: Maintenance information for this reservation Possible values: ["GROUPED", "INDEPENDENT"]
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[builtins.str] self_link_with_id: Server-defined URL for this resource with the resource id.
        :param pulumi.Input['FutureReservationShareSettingsArgs'] share_settings: The previous share settings of the Future Reservation.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] specific_reservation_required: Indicates whether the auto-created reservation can be consumed by VMs with affinity for "any" reservation. If the field
               is set, then only VMs that target the reservation by name can consume from the delivered reservation.
        :param pulumi.Input['FutureReservationSpecificSkuPropertiesArgs'] specific_sku_properties: The previous instance related properties of the Future Reservation.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['FutureReservationStatusArgs']]] statuses: [Output only] Status of the Future Reservation
               Structure is documented below.
        :param pulumi.Input['FutureReservationTimeWindowArgs'] time_window: Time window for this Future Reservation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] zone: URL of the Zone where this future reservation resides.
        """
        if auto_created_reservations_delete_time is not None:
            pulumi.set(__self__, "auto_created_reservations_delete_time", auto_created_reservations_delete_time)
        if auto_created_reservations_duration is not None:
            pulumi.set(__self__, "auto_created_reservations_duration", auto_created_reservations_duration)
        if auto_delete_auto_created_reservations is not None:
            pulumi.set(__self__, "auto_delete_auto_created_reservations", auto_delete_auto_created_reservations)
        if commitment_info is not None:
            pulumi.set(__self__, "commitment_info", commitment_info)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if planning_status is not None:
            pulumi.set(__self__, "planning_status", planning_status)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reservation_mode is not None:
            pulumi.set(__self__, "reservation_mode", reservation_mode)
        if reservation_name is not None:
            pulumi.set(__self__, "reservation_name", reservation_name)
        if scheduling_type is not None:
            pulumi.set(__self__, "scheduling_type", scheduling_type)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if self_link_with_id is not None:
            pulumi.set(__self__, "self_link_with_id", self_link_with_id)
        if share_settings is not None:
            pulumi.set(__self__, "share_settings", share_settings)
        if specific_reservation_required is not None:
            pulumi.set(__self__, "specific_reservation_required", specific_reservation_required)
        if specific_sku_properties is not None:
            pulumi.set(__self__, "specific_sku_properties", specific_sku_properties)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if time_window is not None:
            pulumi.set(__self__, "time_window", time_window)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="autoCreatedReservationsDeleteTime")
    def auto_created_reservations_delete_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Future timestamp when the FR auto-created reservations will be deleted by Compute Engine.
        """
        return pulumi.get(self, "auto_created_reservations_delete_time")

    @auto_created_reservations_delete_time.setter
    def auto_created_reservations_delete_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_created_reservations_delete_time", value)

    @property
    @pulumi.getter(name="autoCreatedReservationsDuration")
    def auto_created_reservations_duration(self) -> Optional[pulumi.Input['FutureReservationAutoCreatedReservationsDurationArgs']]:
        """
        Specifies the duration of auto-created reservations. It represents relative time to future reservation startTime when
        auto-created reservations will be automatically deleted by Compute Engine. Duration time unit is represented as a count
        of seconds and fractions of seconds at nanosecond resolution.
        """
        return pulumi.get(self, "auto_created_reservations_duration")

    @auto_created_reservations_duration.setter
    def auto_created_reservations_duration(self, value: Optional[pulumi.Input['FutureReservationAutoCreatedReservationsDurationArgs']]):
        pulumi.set(self, "auto_created_reservations_duration", value)

    @property
    @pulumi.getter(name="autoDeleteAutoCreatedReservations")
    def auto_delete_auto_created_reservations(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Setting for enabling or disabling automatic deletion for auto-created reservation. If set to true, auto-created
        reservations will be deleted at Future Reservation's end time (default) or at user's defined timestamp if any of the
        [autoCreatedReservationsDeleteTime, autoCreatedReservationsDuration] values is specified. For keeping auto-created
        reservation indefinitely, this value should be set to false.
        """
        return pulumi.get(self, "auto_delete_auto_created_reservations")

    @auto_delete_auto_created_reservations.setter
    def auto_delete_auto_created_reservations(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_delete_auto_created_reservations", value)

    @property
    @pulumi.getter(name="commitmentInfo")
    def commitment_info(self) -> Optional[pulumi.Input['FutureReservationCommitmentInfoArgs']]:
        """
        If not present, then FR will not deliver a new commitment or update an existing commitment.
        """
        return pulumi.get(self, "commitment_info")

    @commitment_info.setter
    def commitment_info(self, value: Optional[pulumi.Input['FutureReservationCommitmentInfoArgs']]):
        pulumi.set(self, "commitment_info", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation timestamp for this future reservation in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the deployment requested as part of future reservation. Possible values: ["DENSE", "FLEXIBLE"]
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the FutureReservation before an amendment was requested.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the las
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name prefix of the Future Reservation before an amendment was requested.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="planningStatus")
    def planning_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Planning state before being submitted for evaluation Possible values: ["DRAFT", "SUBMITTED"]
        """
        return pulumi.get(self, "planning_status")

    @planning_status.setter
    def planning_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "planning_status", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Required) The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="reservationMode")
    def reservation_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reservation mode which determines reservation-termination behavior and expected pricing. Possible values:
        ["CALENDAR", "DEFAULT"]
        """
        return pulumi.get(self, "reservation_mode")

    @reservation_mode.setter
    def reservation_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reservation_mode", value)

    @property
    @pulumi.getter(name="reservationName")
    def reservation_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of reservations where the capacity is provisioned at the time of delivery of future reservations. If the
        reservation with the given name does not exist already, it is created automatically at the time of Approval with
        INACTIVE state till specified start-time. Either provide the reservationName or a namePrefix.
        """
        return pulumi.get(self, "reservation_name")

    @reservation_name.setter
    def reservation_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reservation_name", value)

    @property
    @pulumi.getter(name="schedulingType")
    def scheduling_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maintenance information for this reservation Possible values: ["GROUPED", "INDEPENDENT"]
        """
        return pulumi.get(self, "scheduling_type")

    @scheduling_type.setter
    def scheduling_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scheduling_type", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Server-defined URL for this resource with the resource id.
        """
        return pulumi.get(self, "self_link_with_id")

    @self_link_with_id.setter
    def self_link_with_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link_with_id", value)

    @property
    @pulumi.getter(name="shareSettings")
    def share_settings(self) -> Optional[pulumi.Input['FutureReservationShareSettingsArgs']]:
        """
        The previous share settings of the Future Reservation.
        Structure is documented below.
        """
        return pulumi.get(self, "share_settings")

    @share_settings.setter
    def share_settings(self, value: Optional[pulumi.Input['FutureReservationShareSettingsArgs']]):
        pulumi.set(self, "share_settings", value)

    @property
    @pulumi.getter(name="specificReservationRequired")
    def specific_reservation_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the auto-created reservation can be consumed by VMs with affinity for "any" reservation. If the field
        is set, then only VMs that target the reservation by name can consume from the delivered reservation.
        """
        return pulumi.get(self, "specific_reservation_required")

    @specific_reservation_required.setter
    def specific_reservation_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "specific_reservation_required", value)

    @property
    @pulumi.getter(name="specificSkuProperties")
    def specific_sku_properties(self) -> Optional[pulumi.Input['FutureReservationSpecificSkuPropertiesArgs']]:
        """
        The previous instance related properties of the Future Reservation.
        Structure is documented below.
        """
        return pulumi.get(self, "specific_sku_properties")

    @specific_sku_properties.setter
    def specific_sku_properties(self, value: Optional[pulumi.Input['FutureReservationSpecificSkuPropertiesArgs']]):
        pulumi.set(self, "specific_sku_properties", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FutureReservationStatusArgs']]]]:
        """
        [Output only] Status of the Future Reservation
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FutureReservationStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> Optional[pulumi.Input['FutureReservationTimeWindowArgs']]:
        """
        Time window for this Future Reservation.
        Structure is documented below.
        """
        return pulumi.get(self, "time_window")

    @time_window.setter
    def time_window(self, value: Optional[pulumi.Input['FutureReservationTimeWindowArgs']]):
        pulumi.set(self, "time_window", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the Zone where this future reservation resides.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:compute/futureReservation:FutureReservation")
class FutureReservation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_created_reservations_delete_time: Optional[pulumi.Input[builtins.str]] = None,
                 auto_created_reservations_duration: Optional[pulumi.Input[Union['FutureReservationAutoCreatedReservationsDurationArgs', 'FutureReservationAutoCreatedReservationsDurationArgsDict']]] = None,
                 auto_delete_auto_created_reservations: Optional[pulumi.Input[builtins.bool]] = None,
                 commitment_info: Optional[pulumi.Input[Union['FutureReservationCommitmentInfoArgs', 'FutureReservationCommitmentInfoArgsDict']]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 planning_status: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reservation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 reservation_name: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_type: Optional[pulumi.Input[builtins.str]] = None,
                 share_settings: Optional[pulumi.Input[Union['FutureReservationShareSettingsArgs', 'FutureReservationShareSettingsArgsDict']]] = None,
                 specific_reservation_required: Optional[pulumi.Input[builtins.bool]] = None,
                 specific_sku_properties: Optional[pulumi.Input[Union['FutureReservationSpecificSkuPropertiesArgs', 'FutureReservationSpecificSkuPropertiesArgsDict']]] = None,
                 time_window: Optional[pulumi.Input[Union['FutureReservationTimeWindowArgs', 'FutureReservationTimeWindowArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Future Reservation Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        gce_future_reservation = gcp.compute.FutureReservation("gce_future_reservation",
            name="gce-future-reservation",
            project="my-project-name",
            auto_delete_auto_created_reservations=True,
            planning_status="DRAFT",
            name_prefix="fr-basic",
            time_window={
                "start_time": "2025-11-01T00:00:00Z",
                "end_time": "2025-11-02T00:00:00Z",
            },
            specific_sku_properties={
                "total_count": "1",
                "instance_properties": {
                    "machine_type": "e2-standard-2",
                },
            })
        ```

        ## Import

        FutureReservation can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/futureReservations/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, FutureReservation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/futureReservation:FutureReservation default projects/{{project}}/zones/{{zone}}/futureReservations/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/futureReservation:FutureReservation default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/futureReservation:FutureReservation default {{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/futureReservation:FutureReservation default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] auto_created_reservations_delete_time: Future timestamp when the FR auto-created reservations will be deleted by Compute Engine.
        :param pulumi.Input[Union['FutureReservationAutoCreatedReservationsDurationArgs', 'FutureReservationAutoCreatedReservationsDurationArgsDict']] auto_created_reservations_duration: Specifies the duration of auto-created reservations. It represents relative time to future reservation startTime when
               auto-created reservations will be automatically deleted by Compute Engine. Duration time unit is represented as a count
               of seconds and fractions of seconds at nanosecond resolution.
        :param pulumi.Input[builtins.bool] auto_delete_auto_created_reservations: Setting for enabling or disabling automatic deletion for auto-created reservation. If set to true, auto-created
               reservations will be deleted at Future Reservation's end time (default) or at user's defined timestamp if any of the
               [autoCreatedReservationsDeleteTime, autoCreatedReservationsDuration] values is specified. For keeping auto-created
               reservation indefinitely, this value should be set to false.
        :param pulumi.Input[Union['FutureReservationCommitmentInfoArgs', 'FutureReservationCommitmentInfoArgsDict']] commitment_info: If not present, then FR will not deliver a new commitment or update an existing commitment.
        :param pulumi.Input[builtins.str] deployment_type: Type of the deployment requested as part of future reservation. Possible values: ["DENSE", "FLEXIBLE"]
        :param pulumi.Input[builtins.str] description: The description of the FutureReservation before an amendment was requested.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the las
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] name_prefix: The name prefix of the Future Reservation before an amendment was requested.
        :param pulumi.Input[builtins.str] planning_status: Planning state before being submitted for evaluation Possible values: ["DRAFT", "SUBMITTED"]
        :param pulumi.Input[builtins.str] project: (Required) The identifier for this object. Format specified above.
        :param pulumi.Input[builtins.str] reservation_mode: The reservation mode which determines reservation-termination behavior and expected pricing. Possible values:
               ["CALENDAR", "DEFAULT"]
        :param pulumi.Input[builtins.str] reservation_name: Name of reservations where the capacity is provisioned at the time of delivery of future reservations. If the
               reservation with the given name does not exist already, it is created automatically at the time of Approval with
               INACTIVE state till specified start-time. Either provide the reservationName or a namePrefix.
        :param pulumi.Input[builtins.str] scheduling_type: Maintenance information for this reservation Possible values: ["GROUPED", "INDEPENDENT"]
        :param pulumi.Input[Union['FutureReservationShareSettingsArgs', 'FutureReservationShareSettingsArgsDict']] share_settings: The previous share settings of the Future Reservation.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] specific_reservation_required: Indicates whether the auto-created reservation can be consumed by VMs with affinity for "any" reservation. If the field
               is set, then only VMs that target the reservation by name can consume from the delivered reservation.
        :param pulumi.Input[Union['FutureReservationSpecificSkuPropertiesArgs', 'FutureReservationSpecificSkuPropertiesArgsDict']] specific_sku_properties: The previous instance related properties of the Future Reservation.
               Structure is documented below.
        :param pulumi.Input[Union['FutureReservationTimeWindowArgs', 'FutureReservationTimeWindowArgsDict']] time_window: Time window for this Future Reservation.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FutureReservationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Future Reservation Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        gce_future_reservation = gcp.compute.FutureReservation("gce_future_reservation",
            name="gce-future-reservation",
            project="my-project-name",
            auto_delete_auto_created_reservations=True,
            planning_status="DRAFT",
            name_prefix="fr-basic",
            time_window={
                "start_time": "2025-11-01T00:00:00Z",
                "end_time": "2025-11-02T00:00:00Z",
            },
            specific_sku_properties={
                "total_count": "1",
                "instance_properties": {
                    "machine_type": "e2-standard-2",
                },
            })
        ```

        ## Import

        FutureReservation can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/futureReservations/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, FutureReservation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/futureReservation:FutureReservation default projects/{{project}}/zones/{{zone}}/futureReservations/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/futureReservation:FutureReservation default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/futureReservation:FutureReservation default {{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/futureReservation:FutureReservation default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param FutureReservationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FutureReservationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_created_reservations_delete_time: Optional[pulumi.Input[builtins.str]] = None,
                 auto_created_reservations_duration: Optional[pulumi.Input[Union['FutureReservationAutoCreatedReservationsDurationArgs', 'FutureReservationAutoCreatedReservationsDurationArgsDict']]] = None,
                 auto_delete_auto_created_reservations: Optional[pulumi.Input[builtins.bool]] = None,
                 commitment_info: Optional[pulumi.Input[Union['FutureReservationCommitmentInfoArgs', 'FutureReservationCommitmentInfoArgsDict']]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 planning_status: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reservation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 reservation_name: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_type: Optional[pulumi.Input[builtins.str]] = None,
                 share_settings: Optional[pulumi.Input[Union['FutureReservationShareSettingsArgs', 'FutureReservationShareSettingsArgsDict']]] = None,
                 specific_reservation_required: Optional[pulumi.Input[builtins.bool]] = None,
                 specific_sku_properties: Optional[pulumi.Input[Union['FutureReservationSpecificSkuPropertiesArgs', 'FutureReservationSpecificSkuPropertiesArgsDict']]] = None,
                 time_window: Optional[pulumi.Input[Union['FutureReservationTimeWindowArgs', 'FutureReservationTimeWindowArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FutureReservationArgs.__new__(FutureReservationArgs)

            __props__.__dict__["auto_created_reservations_delete_time"] = auto_created_reservations_delete_time
            __props__.__dict__["auto_created_reservations_duration"] = auto_created_reservations_duration
            __props__.__dict__["auto_delete_auto_created_reservations"] = auto_delete_auto_created_reservations
            __props__.__dict__["commitment_info"] = commitment_info
            __props__.__dict__["deployment_type"] = deployment_type
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["planning_status"] = planning_status
            __props__.__dict__["project"] = project
            __props__.__dict__["reservation_mode"] = reservation_mode
            __props__.__dict__["reservation_name"] = reservation_name
            __props__.__dict__["scheduling_type"] = scheduling_type
            __props__.__dict__["share_settings"] = share_settings
            __props__.__dict__["specific_reservation_required"] = specific_reservation_required
            __props__.__dict__["specific_sku_properties"] = specific_sku_properties
            if time_window is None and not opts.urn:
                raise TypeError("Missing required property 'time_window'")
            __props__.__dict__["time_window"] = time_window
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["self_link_with_id"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["zone"] = None
        super(FutureReservation, __self__).__init__(
            'gcp:compute/futureReservation:FutureReservation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_created_reservations_delete_time: Optional[pulumi.Input[builtins.str]] = None,
            auto_created_reservations_duration: Optional[pulumi.Input[Union['FutureReservationAutoCreatedReservationsDurationArgs', 'FutureReservationAutoCreatedReservationsDurationArgsDict']]] = None,
            auto_delete_auto_created_reservations: Optional[pulumi.Input[builtins.bool]] = None,
            commitment_info: Optional[pulumi.Input[Union['FutureReservationCommitmentInfoArgs', 'FutureReservationCommitmentInfoArgsDict']]] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            deployment_type: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[builtins.str]] = None,
            planning_status: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            reservation_mode: Optional[pulumi.Input[builtins.str]] = None,
            reservation_name: Optional[pulumi.Input[builtins.str]] = None,
            scheduling_type: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            self_link_with_id: Optional[pulumi.Input[builtins.str]] = None,
            share_settings: Optional[pulumi.Input[Union['FutureReservationShareSettingsArgs', 'FutureReservationShareSettingsArgsDict']]] = None,
            specific_reservation_required: Optional[pulumi.Input[builtins.bool]] = None,
            specific_sku_properties: Optional[pulumi.Input[Union['FutureReservationSpecificSkuPropertiesArgs', 'FutureReservationSpecificSkuPropertiesArgsDict']]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FutureReservationStatusArgs', 'FutureReservationStatusArgsDict']]]]] = None,
            time_window: Optional[pulumi.Input[Union['FutureReservationTimeWindowArgs', 'FutureReservationTimeWindowArgsDict']]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'FutureReservation':
        """
        Get an existing FutureReservation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] auto_created_reservations_delete_time: Future timestamp when the FR auto-created reservations will be deleted by Compute Engine.
        :param pulumi.Input[Union['FutureReservationAutoCreatedReservationsDurationArgs', 'FutureReservationAutoCreatedReservationsDurationArgsDict']] auto_created_reservations_duration: Specifies the duration of auto-created reservations. It represents relative time to future reservation startTime when
               auto-created reservations will be automatically deleted by Compute Engine. Duration time unit is represented as a count
               of seconds and fractions of seconds at nanosecond resolution.
        :param pulumi.Input[builtins.bool] auto_delete_auto_created_reservations: Setting for enabling or disabling automatic deletion for auto-created reservation. If set to true, auto-created
               reservations will be deleted at Future Reservation's end time (default) or at user's defined timestamp if any of the
               [autoCreatedReservationsDeleteTime, autoCreatedReservationsDuration] values is specified. For keeping auto-created
               reservation indefinitely, this value should be set to false.
        :param pulumi.Input[Union['FutureReservationCommitmentInfoArgs', 'FutureReservationCommitmentInfoArgsDict']] commitment_info: If not present, then FR will not deliver a new commitment or update an existing commitment.
        :param pulumi.Input[builtins.str] creation_timestamp: The creation timestamp for this future reservation in RFC3339 text format.
        :param pulumi.Input[builtins.str] deployment_type: Type of the deployment requested as part of future reservation. Possible values: ["DENSE", "FLEXIBLE"]
        :param pulumi.Input[builtins.str] description: The description of the FutureReservation before an amendment was requested.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the las
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] name_prefix: The name prefix of the Future Reservation before an amendment was requested.
        :param pulumi.Input[builtins.str] planning_status: Planning state before being submitted for evaluation Possible values: ["DRAFT", "SUBMITTED"]
        :param pulumi.Input[builtins.str] project: (Required) The identifier for this object. Format specified above.
        :param pulumi.Input[builtins.str] reservation_mode: The reservation mode which determines reservation-termination behavior and expected pricing. Possible values:
               ["CALENDAR", "DEFAULT"]
        :param pulumi.Input[builtins.str] reservation_name: Name of reservations where the capacity is provisioned at the time of delivery of future reservations. If the
               reservation with the given name does not exist already, it is created automatically at the time of Approval with
               INACTIVE state till specified start-time. Either provide the reservationName or a namePrefix.
        :param pulumi.Input[builtins.str] scheduling_type: Maintenance information for this reservation Possible values: ["GROUPED", "INDEPENDENT"]
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[builtins.str] self_link_with_id: Server-defined URL for this resource with the resource id.
        :param pulumi.Input[Union['FutureReservationShareSettingsArgs', 'FutureReservationShareSettingsArgsDict']] share_settings: The previous share settings of the Future Reservation.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] specific_reservation_required: Indicates whether the auto-created reservation can be consumed by VMs with affinity for "any" reservation. If the field
               is set, then only VMs that target the reservation by name can consume from the delivered reservation.
        :param pulumi.Input[Union['FutureReservationSpecificSkuPropertiesArgs', 'FutureReservationSpecificSkuPropertiesArgsDict']] specific_sku_properties: The previous instance related properties of the Future Reservation.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FutureReservationStatusArgs', 'FutureReservationStatusArgsDict']]]] statuses: [Output only] Status of the Future Reservation
               Structure is documented below.
        :param pulumi.Input[Union['FutureReservationTimeWindowArgs', 'FutureReservationTimeWindowArgsDict']] time_window: Time window for this Future Reservation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] zone: URL of the Zone where this future reservation resides.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FutureReservationState.__new__(_FutureReservationState)

        __props__.__dict__["auto_created_reservations_delete_time"] = auto_created_reservations_delete_time
        __props__.__dict__["auto_created_reservations_duration"] = auto_created_reservations_duration
        __props__.__dict__["auto_delete_auto_created_reservations"] = auto_delete_auto_created_reservations
        __props__.__dict__["commitment_info"] = commitment_info
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["planning_status"] = planning_status
        __props__.__dict__["project"] = project
        __props__.__dict__["reservation_mode"] = reservation_mode
        __props__.__dict__["reservation_name"] = reservation_name
        __props__.__dict__["scheduling_type"] = scheduling_type
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["self_link_with_id"] = self_link_with_id
        __props__.__dict__["share_settings"] = share_settings
        __props__.__dict__["specific_reservation_required"] = specific_reservation_required
        __props__.__dict__["specific_sku_properties"] = specific_sku_properties
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["time_window"] = time_window
        __props__.__dict__["zone"] = zone
        return FutureReservation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoCreatedReservationsDeleteTime")
    def auto_created_reservations_delete_time(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Future timestamp when the FR auto-created reservations will be deleted by Compute Engine.
        """
        return pulumi.get(self, "auto_created_reservations_delete_time")

    @property
    @pulumi.getter(name="autoCreatedReservationsDuration")
    def auto_created_reservations_duration(self) -> pulumi.Output[Optional['outputs.FutureReservationAutoCreatedReservationsDuration']]:
        """
        Specifies the duration of auto-created reservations. It represents relative time to future reservation startTime when
        auto-created reservations will be automatically deleted by Compute Engine. Duration time unit is represented as a count
        of seconds and fractions of seconds at nanosecond resolution.
        """
        return pulumi.get(self, "auto_created_reservations_duration")

    @property
    @pulumi.getter(name="autoDeleteAutoCreatedReservations")
    def auto_delete_auto_created_reservations(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Setting for enabling or disabling automatic deletion for auto-created reservation. If set to true, auto-created
        reservations will be deleted at Future Reservation's end time (default) or at user's defined timestamp if any of the
        [autoCreatedReservationsDeleteTime, autoCreatedReservationsDuration] values is specified. For keeping auto-created
        reservation indefinitely, this value should be set to false.
        """
        return pulumi.get(self, "auto_delete_auto_created_reservations")

    @property
    @pulumi.getter(name="commitmentInfo")
    def commitment_info(self) -> pulumi.Output[Optional['outputs.FutureReservationCommitmentInfo']]:
        """
        If not present, then FR will not deliver a new commitment or update an existing commitment.
        """
        return pulumi.get(self, "commitment_info")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        The creation timestamp for this future reservation in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Type of the deployment requested as part of future reservation. Possible values: ["DENSE", "FLEXIBLE"]
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the FutureReservation before an amendment was requested.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the las
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name prefix of the Future Reservation before an amendment was requested.
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="planningStatus")
    def planning_status(self) -> pulumi.Output[builtins.str]:
        """
        Planning state before being submitted for evaluation Possible values: ["DRAFT", "SUBMITTED"]
        """
        return pulumi.get(self, "planning_status")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        (Required) The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="reservationMode")
    def reservation_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The reservation mode which determines reservation-termination behavior and expected pricing. Possible values:
        ["CALENDAR", "DEFAULT"]
        """
        return pulumi.get(self, "reservation_mode")

    @property
    @pulumi.getter(name="reservationName")
    def reservation_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of reservations where the capacity is provisioned at the time of delivery of future reservations. If the
        reservation with the given name does not exist already, it is created automatically at the time of Approval with
        INACTIVE state till specified start-time. Either provide the reservationName or a namePrefix.
        """
        return pulumi.get(self, "reservation_name")

    @property
    @pulumi.getter(name="schedulingType")
    def scheduling_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Maintenance information for this reservation Possible values: ["GROUPED", "INDEPENDENT"]
        """
        return pulumi.get(self, "scheduling_type")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> pulumi.Output[builtins.str]:
        """
        Server-defined URL for this resource with the resource id.
        """
        return pulumi.get(self, "self_link_with_id")

    @property
    @pulumi.getter(name="shareSettings")
    def share_settings(self) -> pulumi.Output[Optional['outputs.FutureReservationShareSettings']]:
        """
        The previous share settings of the Future Reservation.
        Structure is documented below.
        """
        return pulumi.get(self, "share_settings")

    @property
    @pulumi.getter(name="specificReservationRequired")
    def specific_reservation_required(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether the auto-created reservation can be consumed by VMs with affinity for "any" reservation. If the field
        is set, then only VMs that target the reservation by name can consume from the delivered reservation.
        """
        return pulumi.get(self, "specific_reservation_required")

    @property
    @pulumi.getter(name="specificSkuProperties")
    def specific_sku_properties(self) -> pulumi.Output[Optional['outputs.FutureReservationSpecificSkuProperties']]:
        """
        The previous instance related properties of the Future Reservation.
        Structure is documented below.
        """
        return pulumi.get(self, "specific_sku_properties")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.FutureReservationStatus']]:
        """
        [Output only] Status of the Future Reservation
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> pulumi.Output['outputs.FutureReservationTimeWindow']:
        """
        Time window for this Future Reservation.
        Structure is documented below.
        """
        return pulumi.get(self, "time_window")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        URL of the Zone where this future reservation resides.
        """
        return pulumi.get(self, "zone")

