# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetNodeTypesResult',
    'AwaitableGetNodeTypesResult',
    'get_node_types',
    'get_node_types_output',
]

@pulumi.output_type
class GetNodeTypesResult:
    """
    A collection of values returned by getNodeTypes.
    """
    def __init__(__self__, id=None, names=None, project=None, zone=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Sequence[builtins.str]:
        """
        A list of node types available in the given zone and project.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        return pulumi.get(self, "zone")


class AwaitableGetNodeTypesResult(GetNodeTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodeTypesResult(
            id=self.id,
            names=self.names,
            project=self.project,
            zone=self.zone)


def get_node_types(project: Optional[builtins.str] = None,
                   zone: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodeTypesResult:
    """
    Provides available node types for Compute Engine sole-tenant nodes in a zone
    for a given project. For more information, see [the official documentation](https://cloud.google.com/compute/docs/nodes/#types) and [API](https://cloud.google.com/compute/docs/reference/rest/v1/nodeTypes).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    central1b = gcp.compute.get_node_types(zone="us-central1-b")
    tmpl = gcp.compute.NodeTemplate("tmpl",
        name="test-tmpl",
        region="us-central1",
        node_type=types["names"][0])
    ```


    :param builtins.str project: ID of the project to list available node types for.
           Should match the project the nodes of this type will be deployed to.
           Defaults to the project that the provider is authenticated with.
    :param builtins.str zone: The zone to list node types for. Should be in zone of intended node groups and region of referencing node template. If `zone` is not specified, the provider-level zone must be set and is used
           instead.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getNodeTypes:getNodeTypes', __args__, opts=opts, typ=GetNodeTypesResult).value

    return AwaitableGetNodeTypesResult(
        id=pulumi.get(__ret__, 'id'),
        names=pulumi.get(__ret__, 'names'),
        project=pulumi.get(__ret__, 'project'),
        zone=pulumi.get(__ret__, 'zone'))
def get_node_types_output(project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          zone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNodeTypesResult]:
    """
    Provides available node types for Compute Engine sole-tenant nodes in a zone
    for a given project. For more information, see [the official documentation](https://cloud.google.com/compute/docs/nodes/#types) and [API](https://cloud.google.com/compute/docs/reference/rest/v1/nodeTypes).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    central1b = gcp.compute.get_node_types(zone="us-central1-b")
    tmpl = gcp.compute.NodeTemplate("tmpl",
        name="test-tmpl",
        region="us-central1",
        node_type=types["names"][0])
    ```


    :param builtins.str project: ID of the project to list available node types for.
           Should match the project the nodes of this type will be deployed to.
           Defaults to the project that the provider is authenticated with.
    :param builtins.str zone: The zone to list node types for. Should be in zone of intended node groups and region of referencing node template. If `zone` is not specified, the provider-level zone must be set and is used
           instead.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getNodeTypes:getNodeTypes', __args__, opts=opts, typ=GetNodeTypesResult)
    return __ret__.apply(lambda __response__: GetNodeTypesResult(
        id=pulumi.get(__response__, 'id'),
        names=pulumi.get(__response__, 'names'),
        project=pulumi.get(__response__, 'project'),
        zone=pulumi.get(__response__, 'zone')))
