# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSubnetworkResult',
    'AwaitableGetSubnetworkResult',
    'get_subnetwork',
    'get_subnetwork_output',
]

@pulumi.output_type
class GetSubnetworkResult:
    """
    A collection of values returned by getSubnetwork.
    """
    def __init__(__self__, description=None, external_ipv6_prefix=None, gateway_address=None, id=None, internal_ipv6_prefix=None, ip_cidr_range=None, ipv6_access_type=None, name=None, network=None, private_ip_google_access=None, project=None, region=None, secondary_ip_ranges=None, self_link=None, stack_type=None, subnetwork_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if external_ipv6_prefix and not isinstance(external_ipv6_prefix, str):
            raise TypeError("Expected argument 'external_ipv6_prefix' to be a str")
        pulumi.set(__self__, "external_ipv6_prefix", external_ipv6_prefix)
        if gateway_address and not isinstance(gateway_address, str):
            raise TypeError("Expected argument 'gateway_address' to be a str")
        pulumi.set(__self__, "gateway_address", gateway_address)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_ipv6_prefix and not isinstance(internal_ipv6_prefix, str):
            raise TypeError("Expected argument 'internal_ipv6_prefix' to be a str")
        pulumi.set(__self__, "internal_ipv6_prefix", internal_ipv6_prefix)
        if ip_cidr_range and not isinstance(ip_cidr_range, str):
            raise TypeError("Expected argument 'ip_cidr_range' to be a str")
        pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        if ipv6_access_type and not isinstance(ipv6_access_type, str):
            raise TypeError("Expected argument 'ipv6_access_type' to be a str")
        pulumi.set(__self__, "ipv6_access_type", ipv6_access_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network and not isinstance(network, str):
            raise TypeError("Expected argument 'network' to be a str")
        pulumi.set(__self__, "network", network)
        if private_ip_google_access and not isinstance(private_ip_google_access, bool):
            raise TypeError("Expected argument 'private_ip_google_access' to be a bool")
        pulumi.set(__self__, "private_ip_google_access", private_ip_google_access)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if secondary_ip_ranges and not isinstance(secondary_ip_ranges, list):
            raise TypeError("Expected argument 'secondary_ip_ranges' to be a list")
        pulumi.set(__self__, "secondary_ip_ranges", secondary_ip_ranges)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if stack_type and not isinstance(stack_type, str):
            raise TypeError("Expected argument 'stack_type' to be a str")
        pulumi.set(__self__, "stack_type", stack_type)
        if subnetwork_id and not isinstance(subnetwork_id, int):
            raise TypeError("Expected argument 'subnetwork_id' to be a int")
        pulumi.set(__self__, "subnetwork_id", subnetwork_id)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of this subnetwork.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalIpv6Prefix")
    def external_ipv6_prefix(self) -> builtins.str:
        """
        The external IPv6 address range that is assigned to this subnetwork.
        """
        return pulumi.get(self, "external_ipv6_prefix")

    @property
    @pulumi.getter(name="gatewayAddress")
    def gateway_address(self) -> builtins.str:
        """
        The IP address of the gateway.
        """
        return pulumi.get(self, "gateway_address")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internalIpv6Prefix")
    def internal_ipv6_prefix(self) -> builtins.str:
        """
        The internal IPv6 address range that is assigned to this subnetwork.
        """
        return pulumi.get(self, "internal_ipv6_prefix")

    @property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> builtins.str:
        """
        The range of IP addresses belonging to this subnetwork
        secondary range.
        """
        return pulumi.get(self, "ip_cidr_range")

    @property
    @pulumi.getter(name="ipv6AccessType")
    def ipv6_access_type(self) -> builtins.str:
        """
        The access type of IPv6 address this subnet holds. Possible values are: `EXTERNAL`, `INTERNAL`.
        """
        return pulumi.get(self, "ipv6_access_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> builtins.str:
        """
        The network name or resource link to the parent
        network of this subnetwork.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="privateIpGoogleAccess")
    def private_ip_google_access(self) -> builtins.bool:
        """
        Whether the VMs in this subnet
        can access Google services without assigned external IP
        addresses.
        """
        return pulumi.get(self, "private_ip_google_access")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secondaryIpRanges")
    def secondary_ip_ranges(self) -> Sequence['outputs.GetSubnetworkSecondaryIpRangeResult']:
        """
        An array of configurations for secondary IP ranges for
        VM instances contained in this subnetwork. Structure is documented below.
        """
        return pulumi.get(self, "secondary_ip_ranges")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> builtins.str:
        """
        The stack type for the subnet. Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        """
        return pulumi.get(self, "stack_type")

    @property
    @pulumi.getter(name="subnetworkId")
    def subnetwork_id(self) -> builtins.int:
        """
        The numeric ID of the resource.
        """
        return pulumi.get(self, "subnetwork_id")


class AwaitableGetSubnetworkResult(GetSubnetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubnetworkResult(
            description=self.description,
            external_ipv6_prefix=self.external_ipv6_prefix,
            gateway_address=self.gateway_address,
            id=self.id,
            internal_ipv6_prefix=self.internal_ipv6_prefix,
            ip_cidr_range=self.ip_cidr_range,
            ipv6_access_type=self.ipv6_access_type,
            name=self.name,
            network=self.network,
            private_ip_google_access=self.private_ip_google_access,
            project=self.project,
            region=self.region,
            secondary_ip_ranges=self.secondary_ip_ranges,
            self_link=self.self_link,
            stack_type=self.stack_type,
            subnetwork_id=self.subnetwork_id)


def get_subnetwork(name: Optional[builtins.str] = None,
                   project: Optional[builtins.str] = None,
                   region: Optional[builtins.str] = None,
                   self_link: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubnetworkResult:
    """
    Get a subnetwork within GCE from its name and region.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_subnetwork = gcp.compute.get_subnetwork(name="default-us-east1",
        region="us-east1")
    ```


    :param builtins.str name: The name of the subnetwork. One of `name` or `self_link`
           must be specified.
    :param builtins.str project: The ID of the project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param builtins.str region: The region this subnetwork has been created in. If
           unspecified, this defaults to the region configured in the provider.
    :param builtins.str self_link: The self link of the subnetwork. If `self_link` is
           specified, `name`, `project`, and `region` are ignored.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    __args__['selfLink'] = self_link
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getSubnetwork:getSubnetwork', __args__, opts=opts, typ=GetSubnetworkResult).value

    return AwaitableGetSubnetworkResult(
        description=pulumi.get(__ret__, 'description'),
        external_ipv6_prefix=pulumi.get(__ret__, 'external_ipv6_prefix'),
        gateway_address=pulumi.get(__ret__, 'gateway_address'),
        id=pulumi.get(__ret__, 'id'),
        internal_ipv6_prefix=pulumi.get(__ret__, 'internal_ipv6_prefix'),
        ip_cidr_range=pulumi.get(__ret__, 'ip_cidr_range'),
        ipv6_access_type=pulumi.get(__ret__, 'ipv6_access_type'),
        name=pulumi.get(__ret__, 'name'),
        network=pulumi.get(__ret__, 'network'),
        private_ip_google_access=pulumi.get(__ret__, 'private_ip_google_access'),
        project=pulumi.get(__ret__, 'project'),
        region=pulumi.get(__ret__, 'region'),
        secondary_ip_ranges=pulumi.get(__ret__, 'secondary_ip_ranges'),
        self_link=pulumi.get(__ret__, 'self_link'),
        stack_type=pulumi.get(__ret__, 'stack_type'),
        subnetwork_id=pulumi.get(__ret__, 'subnetwork_id'))
def get_subnetwork_output(name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          self_link: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubnetworkResult]:
    """
    Get a subnetwork within GCE from its name and region.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_subnetwork = gcp.compute.get_subnetwork(name="default-us-east1",
        region="us-east1")
    ```


    :param builtins.str name: The name of the subnetwork. One of `name` or `self_link`
           must be specified.
    :param builtins.str project: The ID of the project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param builtins.str region: The region this subnetwork has been created in. If
           unspecified, this defaults to the region configured in the provider.
    :param builtins.str self_link: The self link of the subnetwork. If `self_link` is
           specified, `name`, `project`, and `region` are ignored.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    __args__['selfLink'] = self_link
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getSubnetwork:getSubnetwork', __args__, opts=opts, typ=GetSubnetworkResult)
    return __ret__.apply(lambda __response__: GetSubnetworkResult(
        description=pulumi.get(__response__, 'description'),
        external_ipv6_prefix=pulumi.get(__response__, 'external_ipv6_prefix'),
        gateway_address=pulumi.get(__response__, 'gateway_address'),
        id=pulumi.get(__response__, 'id'),
        internal_ipv6_prefix=pulumi.get(__response__, 'internal_ipv6_prefix'),
        ip_cidr_range=pulumi.get(__response__, 'ip_cidr_range'),
        ipv6_access_type=pulumi.get(__response__, 'ipv6_access_type'),
        name=pulumi.get(__response__, 'name'),
        network=pulumi.get(__response__, 'network'),
        private_ip_google_access=pulumi.get(__response__, 'private_ip_google_access'),
        project=pulumi.get(__response__, 'project'),
        region=pulumi.get(__response__, 'region'),
        secondary_ip_ranges=pulumi.get(__response__, 'secondary_ip_ranges'),
        self_link=pulumi.get(__response__, 'self_link'),
        stack_type=pulumi.get(__response__, 'stack_type'),
        subnetwork_id=pulumi.get(__response__, 'subnetwork_id')))
