# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HaVpnGatewayArgs', 'HaVpnGateway']

@pulumi.input_type
class HaVpnGatewayArgs:
    def __init__(__self__, *,
                 network: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gateway_ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 stack_type: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['HaVpnGatewayVpnInterfaceArgs']]]] = None):
        """
        The set of arguments for constructing a HaVpnGateway resource.
        :param pulumi.Input[builtins.str] network: The network this VPN gateway is accepting traffic for.
               
               
               - - -
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] gateway_ip_version: The IP family of the gateway IPs for the HA-VPN gateway interfaces. If not specified, IPV4 will be used.
               Default value is `IPV4`.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels for this resource. These can only be added or modified by the setLabels method.
               Each label key/value pair must comply with RFC1035. Label values may be empty.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The region this gateway should sit in.
        :param pulumi.Input[builtins.str] stack_type: The stack type for this VPN gateway to identify the IP protocols that are enabled.
               If not specified, IPV4_ONLY will be used.
               Default value is `IPV4_ONLY`.
               Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        :param pulumi.Input[Sequence[pulumi.Input['HaVpnGatewayVpnInterfaceArgs']]] vpn_interfaces: A list of interfaces on this VPN gateway.
               Structure is documented below.
        """
        pulumi.set(__self__, "network", network)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gateway_ip_version is not None:
            pulumi.set(__self__, "gateway_ip_version", gateway_ip_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if stack_type is not None:
            pulumi.set(__self__, "stack_type", stack_type)
        if vpn_interfaces is not None:
            pulumi.set(__self__, "vpn_interfaces", vpn_interfaces)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[builtins.str]:
        """
        The network this VPN gateway is accepting traffic for.


        - - -
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="gatewayIpVersion")
    def gateway_ip_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP family of the gateway IPs for the HA-VPN gateway interfaces. If not specified, IPV4 will be used.
        Default value is `IPV4`.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "gateway_ip_version")

    @gateway_ip_version.setter
    def gateway_ip_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gateway_ip_version", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels for this resource. These can only be added or modified by the setLabels method.
        Each label key/value pair must comply with RFC1035. Label values may be empty.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region this gateway should sit in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The stack type for this VPN gateway to identify the IP protocols that are enabled.
        If not specified, IPV4_ONLY will be used.
        Default value is `IPV4_ONLY`.
        Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        """
        return pulumi.get(self, "stack_type")

    @stack_type.setter
    def stack_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stack_type", value)

    @property
    @pulumi.getter(name="vpnInterfaces")
    def vpn_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HaVpnGatewayVpnInterfaceArgs']]]]:
        """
        A list of interfaces on this VPN gateway.
        Structure is documented below.
        """
        return pulumi.get(self, "vpn_interfaces")

    @vpn_interfaces.setter
    def vpn_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HaVpnGatewayVpnInterfaceArgs']]]]):
        pulumi.set(self, "vpn_interfaces", value)


@pulumi.input_type
class _HaVpnGatewayState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 gateway_ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 label_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 stack_type: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['HaVpnGatewayVpnInterfaceArgs']]]] = None):
        """
        Input properties used for looking up and filtering HaVpnGateway resources.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] gateway_ip_version: The IP family of the gateway IPs for the HA-VPN gateway interfaces. If not specified, IPV4 will be used.
               Default value is `IPV4`.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[builtins.str] label_fingerprint: A fingerprint for the labels being applied to this VpnGateway, which is essentially a hash
               of the labels set used for optimistic locking. The fingerprint is initially generated by
               Compute Engine and changes after every request to modify or update labels.
               You must always provide an up-to-date fingerprint hash in order to update or change labels,
               otherwise the request will fail with error 412 conditionNotMet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels for this resource. These can only be added or modified by the setLabels method.
               Each label key/value pair must comply with RFC1035. Label values may be empty.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] network: The network this VPN gateway is accepting traffic for.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] region: The region this gateway should sit in.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[builtins.str] stack_type: The stack type for this VPN gateway to identify the IP protocols that are enabled.
               If not specified, IPV4_ONLY will be used.
               Default value is `IPV4_ONLY`.
               Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        :param pulumi.Input[Sequence[pulumi.Input['HaVpnGatewayVpnInterfaceArgs']]] vpn_interfaces: A list of interfaces on this VPN gateway.
               Structure is documented below.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if gateway_ip_version is not None:
            pulumi.set(__self__, "gateway_ip_version", gateway_ip_version)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if stack_type is not None:
            pulumi.set(__self__, "stack_type", stack_type)
        if vpn_interfaces is not None:
            pulumi.set(__self__, "vpn_interfaces", vpn_interfaces)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="gatewayIpVersion")
    def gateway_ip_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP family of the gateway IPs for the HA-VPN gateway interfaces. If not specified, IPV4 will be used.
        Default value is `IPV4`.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "gateway_ip_version")

    @gateway_ip_version.setter
    def gateway_ip_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gateway_ip_version", value)

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A fingerprint for the labels being applied to this VpnGateway, which is essentially a hash
        of the labels set used for optimistic locking. The fingerprint is initially generated by
        Compute Engine and changes after every request to modify or update labels.
        You must always provide an up-to-date fingerprint hash in order to update or change labels,
        otherwise the request will fail with error 412 conditionNotMet.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label_fingerprint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels for this resource. These can only be added or modified by the setLabels method.
        Each label key/value pair must comply with RFC1035. Label values may be empty.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network this VPN gateway is accepting traffic for.


        - - -
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region this gateway should sit in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The stack type for this VPN gateway to identify the IP protocols that are enabled.
        If not specified, IPV4_ONLY will be used.
        Default value is `IPV4_ONLY`.
        Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        """
        return pulumi.get(self, "stack_type")

    @stack_type.setter
    def stack_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stack_type", value)

    @property
    @pulumi.getter(name="vpnInterfaces")
    def vpn_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HaVpnGatewayVpnInterfaceArgs']]]]:
        """
        A list of interfaces on this VPN gateway.
        Structure is documented below.
        """
        return pulumi.get(self, "vpn_interfaces")

    @vpn_interfaces.setter
    def vpn_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HaVpnGatewayVpnInterfaceArgs']]]]):
        pulumi.set(self, "vpn_interfaces", value)


@pulumi.type_token("gcp:compute/haVpnGateway:HaVpnGateway")
class HaVpnGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gateway_ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 stack_type: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HaVpnGatewayVpnInterfaceArgs', 'HaVpnGatewayVpnInterfaceArgsDict']]]]] = None,
                 __props__=None):
        """
        Represents a VPN gateway running in GCP. This virtual device is managed
        by Google, but used only by you. This type of VPN Gateway allows for the creation
        of VPN solutions with higher availability than classic Target VPN Gateways.

        To get more information about HaVpnGateway, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/vpnGateways)
        * How-to Guides
            * [Choosing a VPN](https://cloud.google.com/vpn/docs/how-to/choosing-a-vpn)
            * [Cloud VPN Overview](https://cloud.google.com/vpn/docs/concepts/overview)

        ## Example Usage

        ### Ha Vpn Gateway Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network1 = gcp.compute.Network("network1",
            name="network1",
            auto_create_subnetworks=False)
        ha_gateway1 = gcp.compute.HaVpnGateway("ha_gateway1",
            region="us-central1",
            name="ha-vpn-1",
            network=network1.id)
        ```
        ### Ha Vpn Gateway Ipv6

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network1 = gcp.compute.Network("network1",
            name="network1",
            auto_create_subnetworks=False)
        ha_gateway1 = gcp.compute.HaVpnGateway("ha_gateway1",
            region="us-central1",
            name="ha-vpn-1",
            network=network1.id,
            stack_type="IPV4_IPV6",
            labels={
                "mykey": "myvalue",
            })
        ```
        ### Compute Ha Vpn Gateway Encrypted Interconnect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="test-network",
            auto_create_subnetworks=False)
        address1 = gcp.compute.Address("address1",
            name="test-address1",
            address_type="INTERNAL",
            purpose="IPSEC_INTERCONNECT",
            address="192.168.1.0",
            prefix_length=29,
            network=network.self_link)
        router = gcp.compute.Router("router",
            name="test-router",
            network=network.name,
            encrypted_interconnect_router=True,
            bgp={
                "asn": 16550,
            })
        attachment1 = gcp.compute.InterconnectAttachment("attachment1",
            name="test-interconnect-attachment1",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=router.id,
            encryption="IPSEC",
            ipsec_internal_addresses=[address1.self_link])
        address2 = gcp.compute.Address("address2",
            name="test-address2",
            address_type="INTERNAL",
            purpose="IPSEC_INTERCONNECT",
            address="192.168.2.0",
            prefix_length=29,
            network=network.self_link)
        attachment2 = gcp.compute.InterconnectAttachment("attachment2",
            name="test-interconnect-attachment2",
            edge_availability_domain="AVAILABILITY_DOMAIN_2",
            type="PARTNER",
            router=router.id,
            encryption="IPSEC",
            ipsec_internal_addresses=[address2.self_link])
        vpn_gateway = gcp.compute.HaVpnGateway("vpn-gateway",
            name="test-ha-vpngw",
            network=network.id,
            vpn_interfaces=[
                {
                    "id": 0,
                    "interconnect_attachment": attachment1.self_link,
                },
                {
                    "id": 1,
                    "interconnect_attachment": attachment2.self_link,
                },
            ])
        ```

        ## Import

        HaVpnGateway can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/vpnGateways/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, HaVpnGateway can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/haVpnGateway:HaVpnGateway default projects/{{project}}/regions/{{region}}/vpnGateways/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/haVpnGateway:HaVpnGateway default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/haVpnGateway:HaVpnGateway default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/haVpnGateway:HaVpnGateway default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] gateway_ip_version: The IP family of the gateway IPs for the HA-VPN gateway interfaces. If not specified, IPV4 will be used.
               Default value is `IPV4`.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels for this resource. These can only be added or modified by the setLabels method.
               Each label key/value pair must comply with RFC1035. Label values may be empty.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] network: The network this VPN gateway is accepting traffic for.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The region this gateway should sit in.
        :param pulumi.Input[builtins.str] stack_type: The stack type for this VPN gateway to identify the IP protocols that are enabled.
               If not specified, IPV4_ONLY will be used.
               Default value is `IPV4_ONLY`.
               Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HaVpnGatewayVpnInterfaceArgs', 'HaVpnGatewayVpnInterfaceArgsDict']]]] vpn_interfaces: A list of interfaces on this VPN gateway.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HaVpnGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a VPN gateway running in GCP. This virtual device is managed
        by Google, but used only by you. This type of VPN Gateway allows for the creation
        of VPN solutions with higher availability than classic Target VPN Gateways.

        To get more information about HaVpnGateway, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/vpnGateways)
        * How-to Guides
            * [Choosing a VPN](https://cloud.google.com/vpn/docs/how-to/choosing-a-vpn)
            * [Cloud VPN Overview](https://cloud.google.com/vpn/docs/concepts/overview)

        ## Example Usage

        ### Ha Vpn Gateway Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network1 = gcp.compute.Network("network1",
            name="network1",
            auto_create_subnetworks=False)
        ha_gateway1 = gcp.compute.HaVpnGateway("ha_gateway1",
            region="us-central1",
            name="ha-vpn-1",
            network=network1.id)
        ```
        ### Ha Vpn Gateway Ipv6

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network1 = gcp.compute.Network("network1",
            name="network1",
            auto_create_subnetworks=False)
        ha_gateway1 = gcp.compute.HaVpnGateway("ha_gateway1",
            region="us-central1",
            name="ha-vpn-1",
            network=network1.id,
            stack_type="IPV4_IPV6",
            labels={
                "mykey": "myvalue",
            })
        ```
        ### Compute Ha Vpn Gateway Encrypted Interconnect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="test-network",
            auto_create_subnetworks=False)
        address1 = gcp.compute.Address("address1",
            name="test-address1",
            address_type="INTERNAL",
            purpose="IPSEC_INTERCONNECT",
            address="192.168.1.0",
            prefix_length=29,
            network=network.self_link)
        router = gcp.compute.Router("router",
            name="test-router",
            network=network.name,
            encrypted_interconnect_router=True,
            bgp={
                "asn": 16550,
            })
        attachment1 = gcp.compute.InterconnectAttachment("attachment1",
            name="test-interconnect-attachment1",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=router.id,
            encryption="IPSEC",
            ipsec_internal_addresses=[address1.self_link])
        address2 = gcp.compute.Address("address2",
            name="test-address2",
            address_type="INTERNAL",
            purpose="IPSEC_INTERCONNECT",
            address="192.168.2.0",
            prefix_length=29,
            network=network.self_link)
        attachment2 = gcp.compute.InterconnectAttachment("attachment2",
            name="test-interconnect-attachment2",
            edge_availability_domain="AVAILABILITY_DOMAIN_2",
            type="PARTNER",
            router=router.id,
            encryption="IPSEC",
            ipsec_internal_addresses=[address2.self_link])
        vpn_gateway = gcp.compute.HaVpnGateway("vpn-gateway",
            name="test-ha-vpngw",
            network=network.id,
            vpn_interfaces=[
                {
                    "id": 0,
                    "interconnect_attachment": attachment1.self_link,
                },
                {
                    "id": 1,
                    "interconnect_attachment": attachment2.self_link,
                },
            ])
        ```

        ## Import

        HaVpnGateway can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/vpnGateways/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, HaVpnGateway can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/haVpnGateway:HaVpnGateway default projects/{{project}}/regions/{{region}}/vpnGateways/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/haVpnGateway:HaVpnGateway default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/haVpnGateway:HaVpnGateway default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/haVpnGateway:HaVpnGateway default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param HaVpnGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HaVpnGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gateway_ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 stack_type: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HaVpnGatewayVpnInterfaceArgs', 'HaVpnGatewayVpnInterfaceArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HaVpnGatewayArgs.__new__(HaVpnGatewayArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["gateway_ip_version"] = gateway_ip_version
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["stack_type"] = stack_type
            __props__.__dict__["vpn_interfaces"] = vpn_interfaces
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(HaVpnGateway, __self__).__init__(
            'gcp:compute/haVpnGateway:HaVpnGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            gateway_ip_version: Optional[pulumi.Input[builtins.str]] = None,
            label_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            stack_type: Optional[pulumi.Input[builtins.str]] = None,
            vpn_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HaVpnGatewayVpnInterfaceArgs', 'HaVpnGatewayVpnInterfaceArgsDict']]]]] = None) -> 'HaVpnGateway':
        """
        Get an existing HaVpnGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] gateway_ip_version: The IP family of the gateway IPs for the HA-VPN gateway interfaces. If not specified, IPV4 will be used.
               Default value is `IPV4`.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[builtins.str] label_fingerprint: A fingerprint for the labels being applied to this VpnGateway, which is essentially a hash
               of the labels set used for optimistic locking. The fingerprint is initially generated by
               Compute Engine and changes after every request to modify or update labels.
               You must always provide an up-to-date fingerprint hash in order to update or change labels,
               otherwise the request will fail with error 412 conditionNotMet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels for this resource. These can only be added or modified by the setLabels method.
               Each label key/value pair must comply with RFC1035. Label values may be empty.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] network: The network this VPN gateway is accepting traffic for.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] region: The region this gateway should sit in.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[builtins.str] stack_type: The stack type for this VPN gateway to identify the IP protocols that are enabled.
               If not specified, IPV4_ONLY will be used.
               Default value is `IPV4_ONLY`.
               Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HaVpnGatewayVpnInterfaceArgs', 'HaVpnGatewayVpnInterfaceArgsDict']]]] vpn_interfaces: A list of interfaces on this VPN gateway.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HaVpnGatewayState.__new__(_HaVpnGatewayState)

        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["gateway_ip_version"] = gateway_ip_version
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["stack_type"] = stack_type
        __props__.__dict__["vpn_interfaces"] = vpn_interfaces
        return HaVpnGateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="gatewayIpVersion")
    def gateway_ip_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The IP family of the gateway IPs for the HA-VPN gateway interfaces. If not specified, IPV4 will be used.
        Default value is `IPV4`.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "gateway_ip_version")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        A fingerprint for the labels being applied to this VpnGateway, which is essentially a hash
        of the labels set used for optimistic locking. The fingerprint is initially generated by
        Compute Engine and changes after every request to modify or update labels.
        You must always provide an up-to-date fingerprint hash in order to update or change labels,
        otherwise the request will fail with error 412 conditionNotMet.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels for this resource. These can only be added or modified by the setLabels method.
        Each label key/value pair must comply with RFC1035. Label values may be empty.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[builtins.str]:
        """
        The network this VPN gateway is accepting traffic for.


        - - -
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region this gateway should sit in.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The stack type for this VPN gateway to identify the IP protocols that are enabled.
        If not specified, IPV4_ONLY will be used.
        Default value is `IPV4_ONLY`.
        Possible values are: `IPV4_ONLY`, `IPV4_IPV6`, `IPV6_ONLY`.
        """
        return pulumi.get(self, "stack_type")

    @property
    @pulumi.getter(name="vpnInterfaces")
    def vpn_interfaces(self) -> pulumi.Output[Sequence['outputs.HaVpnGatewayVpnInterface']]:
        """
        A list of interfaces on this VPN gateway.
        Structure is documented below.
        """
        return pulumi.get(self, "vpn_interfaces")

