# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceGroupMembershipArgs', 'InstanceGroupMembership']

@pulumi.input_type
class InstanceGroupMembershipArgs:
    def __init__(__self__, *,
                 instance: pulumi.Input[builtins.str],
                 instance_group: pulumi.Input[builtins.str],
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceGroupMembership resource.
        :param pulumi.Input[builtins.str] instance: An instance being added to the InstanceGroup
        :param pulumi.Input[builtins.str] instance_group: Represents an Instance Group resource name that the instance belongs to.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] zone: A reference to the zone where the instance group resides.
        """
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "instance_group", instance_group)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Input[builtins.str]:
        """
        An instance being added to the InstanceGroup
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter(name="instanceGroup")
    def instance_group(self) -> pulumi.Input[builtins.str]:
        """
        Represents an Instance Group resource name that the instance belongs to.


        - - -
        """
        return pulumi.get(self, "instance_group")

    @instance_group.setter
    def instance_group(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_group", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to the zone where the instance group resides.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _InstanceGroupMembershipState:
    def __init__(__self__, *,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 instance_group: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceGroupMembership resources.
        :param pulumi.Input[builtins.str] instance: An instance being added to the InstanceGroup
        :param pulumi.Input[builtins.str] instance_group: Represents an Instance Group resource name that the instance belongs to.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] zone: A reference to the zone where the instance group resides.
        """
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if instance_group is not None:
            pulumi.set(__self__, "instance_group", instance_group)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An instance being added to the InstanceGroup
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter(name="instanceGroup")
    def instance_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Represents an Instance Group resource name that the instance belongs to.


        - - -
        """
        return pulumi.get(self, "instance_group")

    @instance_group.setter
    def instance_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_group", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to the zone where the instance group resides.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:compute/instanceGroupMembership:InstanceGroupMembership")
class InstanceGroupMembership(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 instance_group: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Represents the Instance membership to the Instance Group.

        > **NOTE** You can use this resource instead of the `instances` field in the
        `compute.InstanceGroup`, however it's not recommended to use it alongside this field.
        It might cause inconsistencies, as they can end up competing over control.

        > **NOTE** This resource has been added to avoid a situation, where after
        Instance is recreated, it's removed from Instance Group and it's needed to
        perform `apply` twice. To avoid situations like this, please use this resource
        with the lifecycle `replace_triggered_by` method, with the passed Instance's ID.

        To get more information about InstanceGroupMembership, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroups)
        * How-to Guides
            * [Add instances](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroups/addInstances)
            * [List instances](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroups/listInstances)
            * [Remove instances](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroups/removeInstances)

        ## Example Usage

        ### Instance Group Membership

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default-network", name="network")
        default_instance = gcp.compute.Instance("default-instance",
            name="instance",
            machine_type="e2-medium",
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-11",
                },
            },
            network_interfaces=[{
                "network": default_network.name,
            }])
        default_instance_group = gcp.compute.InstanceGroup("default-instance-group", name="instance-group")
        default_ig_membership = gcp.compute.InstanceGroupMembership("default-ig-membership",
            instance=default_instance.self_link,
            instance_group=default_instance_group.name)
        ```

        ## Import

        InstanceGroupMembership can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/instanceGroups/{{instance_group}}/{{instance}}`

        * `{{project}}/{{zone}}/{{instance_group}}/{{instance}}`

        * `{{zone}}/{{instance_group}}/{{instance}}`

        * `{{instance_group}}/{{instance}}`

        When using the `pulumi import` command, InstanceGroupMembership can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/instanceGroupMembership:InstanceGroupMembership default projects/{{project}}/zones/{{zone}}/instanceGroups/{{instance_group}}/{{instance}}
        ```

        ```sh
        $ pulumi import gcp:compute/instanceGroupMembership:InstanceGroupMembership default {{project}}/{{zone}}/{{instance_group}}/{{instance}}
        ```

        ```sh
        $ pulumi import gcp:compute/instanceGroupMembership:InstanceGroupMembership default {{zone}}/{{instance_group}}/{{instance}}
        ```

        ```sh
        $ pulumi import gcp:compute/instanceGroupMembership:InstanceGroupMembership default {{instance_group}}/{{instance}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] instance: An instance being added to the InstanceGroup
        :param pulumi.Input[builtins.str] instance_group: Represents an Instance Group resource name that the instance belongs to.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] zone: A reference to the zone where the instance group resides.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceGroupMembershipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents the Instance membership to the Instance Group.

        > **NOTE** You can use this resource instead of the `instances` field in the
        `compute.InstanceGroup`, however it's not recommended to use it alongside this field.
        It might cause inconsistencies, as they can end up competing over control.

        > **NOTE** This resource has been added to avoid a situation, where after
        Instance is recreated, it's removed from Instance Group and it's needed to
        perform `apply` twice. To avoid situations like this, please use this resource
        with the lifecycle `replace_triggered_by` method, with the passed Instance's ID.

        To get more information about InstanceGroupMembership, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroups)
        * How-to Guides
            * [Add instances](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroups/addInstances)
            * [List instances](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroups/listInstances)
            * [Remove instances](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroups/removeInstances)

        ## Example Usage

        ### Instance Group Membership

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default-network", name="network")
        default_instance = gcp.compute.Instance("default-instance",
            name="instance",
            machine_type="e2-medium",
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-11",
                },
            },
            network_interfaces=[{
                "network": default_network.name,
            }])
        default_instance_group = gcp.compute.InstanceGroup("default-instance-group", name="instance-group")
        default_ig_membership = gcp.compute.InstanceGroupMembership("default-ig-membership",
            instance=default_instance.self_link,
            instance_group=default_instance_group.name)
        ```

        ## Import

        InstanceGroupMembership can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/instanceGroups/{{instance_group}}/{{instance}}`

        * `{{project}}/{{zone}}/{{instance_group}}/{{instance}}`

        * `{{zone}}/{{instance_group}}/{{instance}}`

        * `{{instance_group}}/{{instance}}`

        When using the `pulumi import` command, InstanceGroupMembership can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/instanceGroupMembership:InstanceGroupMembership default projects/{{project}}/zones/{{zone}}/instanceGroups/{{instance_group}}/{{instance}}
        ```

        ```sh
        $ pulumi import gcp:compute/instanceGroupMembership:InstanceGroupMembership default {{project}}/{{zone}}/{{instance_group}}/{{instance}}
        ```

        ```sh
        $ pulumi import gcp:compute/instanceGroupMembership:InstanceGroupMembership default {{zone}}/{{instance_group}}/{{instance}}
        ```

        ```sh
        $ pulumi import gcp:compute/instanceGroupMembership:InstanceGroupMembership default {{instance_group}}/{{instance}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceGroupMembershipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceGroupMembershipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 instance_group: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceGroupMembershipArgs.__new__(InstanceGroupMembershipArgs)

            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            if instance_group is None and not opts.urn:
                raise TypeError("Missing required property 'instance_group'")
            __props__.__dict__["instance_group"] = instance_group
            __props__.__dict__["project"] = project
            __props__.__dict__["zone"] = zone
        super(InstanceGroupMembership, __self__).__init__(
            'gcp:compute/instanceGroupMembership:InstanceGroupMembership',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance: Optional[pulumi.Input[builtins.str]] = None,
            instance_group: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'InstanceGroupMembership':
        """
        Get an existing InstanceGroupMembership resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] instance: An instance being added to the InstanceGroup
        :param pulumi.Input[builtins.str] instance_group: Represents an Instance Group resource name that the instance belongs to.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] zone: A reference to the zone where the instance group resides.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceGroupMembershipState.__new__(_InstanceGroupMembershipState)

        __props__.__dict__["instance"] = instance
        __props__.__dict__["instance_group"] = instance_group
        __props__.__dict__["project"] = project
        __props__.__dict__["zone"] = zone
        return InstanceGroupMembership(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[builtins.str]:
        """
        An instance being added to the InstanceGroup
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter(name="instanceGroup")
    def instance_group(self) -> pulumi.Output[builtins.str]:
        """
        Represents an Instance Group resource name that the instance belongs to.


        - - -
        """
        return pulumi.get(self, "instance_group")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A reference to the zone where the instance group resides.
        """
        return pulumi.get(self, "zone")

