# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InterconnectGroupArgs', 'InterconnectGroup']

@pulumi.input_type
class InterconnectGroupArgs:
    def __init__(__self__, *,
                 intent: pulumi.Input['InterconnectGroupIntentArgs'],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 interconnects: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectGroupInterconnectArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a InterconnectGroup resource.
        :param pulumi.Input['InterconnectGroupIntentArgs'] intent: The user's intent for this group. This is the only required field besides
               the name that must be specified on group creation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Sequence[pulumi.Input['InterconnectGroupInterconnectArgs']]] interconnects: (Output)
               Interconnects used to explain this blocker in more
               detail.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        pulumi.set(__self__, "intent", intent)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if interconnects is not None:
            pulumi.set(__self__, "interconnects", interconnects)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def intent(self) -> pulumi.Input['InterconnectGroupIntentArgs']:
        """
        The user's intent for this group. This is the only required field besides
        the name that must be specified on group creation.
        Structure is documented below.
        """
        return pulumi.get(self, "intent")

    @intent.setter
    def intent(self, value: pulumi.Input['InterconnectGroupIntentArgs']):
        pulumi.set(self, "intent", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def interconnects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectGroupInterconnectArgs']]]]:
        """
        (Output)
        Interconnects used to explain this blocker in more
        detail.
        """
        return pulumi.get(self, "interconnects")

    @interconnects.setter
    def interconnects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectGroupInterconnectArgs']]]]):
        pulumi.set(self, "interconnects", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be
        1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _InterconnectGroupState:
    def __init__(__self__, *,
                 configureds: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectGroupConfiguredArgs']]]] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 intent: Optional[pulumi.Input['InterconnectGroupIntentArgs']] = None,
                 interconnects: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectGroupInterconnectArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 physical_structures: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectGroupPhysicalStructureArgs']]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering InterconnectGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input['InterconnectGroupConfiguredArgs']]] configureds: The status of the group as configured. This has the same
               structure as the operational field reported by the OperationalStatus
               method, but does not take into account the operational status of each
               resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input['InterconnectGroupIntentArgs'] intent: The user's intent for this group. This is the only required field besides
               the name that must be specified on group creation.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InterconnectGroupInterconnectArgs']]] interconnects: (Output)
               Interconnects used to explain this blocker in more
               detail.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input['InterconnectGroupPhysicalStructureArgs']]] physical_structures: An analysis of the physical layout of Interconnects in this
               group. Every Interconnect in the group is shown once in this structure.
               Structure is documented below.
        """
        if configureds is not None:
            pulumi.set(__self__, "configureds", configureds)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if intent is not None:
            pulumi.set(__self__, "intent", intent)
        if interconnects is not None:
            pulumi.set(__self__, "interconnects", interconnects)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if physical_structures is not None:
            pulumi.set(__self__, "physical_structures", physical_structures)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def configureds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectGroupConfiguredArgs']]]]:
        """
        The status of the group as configured. This has the same
        structure as the operational field reported by the OperationalStatus
        method, but does not take into account the operational status of each
        resource.
        Structure is documented below.
        """
        return pulumi.get(self, "configureds")

    @configureds.setter
    def configureds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectGroupConfiguredArgs']]]]):
        pulumi.set(self, "configureds", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def intent(self) -> Optional[pulumi.Input['InterconnectGroupIntentArgs']]:
        """
        The user's intent for this group. This is the only required field besides
        the name that must be specified on group creation.
        Structure is documented below.
        """
        return pulumi.get(self, "intent")

    @intent.setter
    def intent(self, value: Optional[pulumi.Input['InterconnectGroupIntentArgs']]):
        pulumi.set(self, "intent", value)

    @property
    @pulumi.getter
    def interconnects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectGroupInterconnectArgs']]]]:
        """
        (Output)
        Interconnects used to explain this blocker in more
        detail.
        """
        return pulumi.get(self, "interconnects")

    @interconnects.setter
    def interconnects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectGroupInterconnectArgs']]]]):
        pulumi.set(self, "interconnects", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be
        1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="physicalStructures")
    def physical_structures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectGroupPhysicalStructureArgs']]]]:
        """
        An analysis of the physical layout of Interconnects in this
        group. Every Interconnect in the group is shown once in this structure.
        Structure is documented below.
        """
        return pulumi.get(self, "physical_structures")

    @physical_structures.setter
    def physical_structures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectGroupPhysicalStructureArgs']]]]):
        pulumi.set(self, "physical_structures", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gcp:compute/interconnectGroup:InterconnectGroup")
class InterconnectGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 intent: Optional[pulumi.Input[Union['InterconnectGroupIntentArgs', 'InterconnectGroupIntentArgsDict']]] = None,
                 interconnects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterconnectGroupInterconnectArgs', 'InterconnectGroupInterconnectArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        An interconnect group resource allows customers to create, analyze, and
        expand their redundant connections.

        To get more information about InterconnectGroup, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/interconnects)
        * How-to Guides
            * [Create a Dedicated Interconnect](https://cloud.google.com/network-connectivity/docs/interconnect/concepts/dedicated-overview)

        ## Example Usage

        ### Interconnect Group Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_interconnect_group = gcp.compute.InterconnectGroup("example-interconnect-group",
            name="example-interconnect-group",
            intent={
                "topology_capability": "NO_SLA",
            })
        ```

        ## Import

        InterconnectGroup can be imported using any of these accepted formats:

        * `projects/{{project}}/global/interconnectGroups/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, InterconnectGroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/interconnectGroup:InterconnectGroup default projects/{{project}}/global/interconnectGroups/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnectGroup:InterconnectGroup default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnectGroup:InterconnectGroup default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Union['InterconnectGroupIntentArgs', 'InterconnectGroupIntentArgsDict']] intent: The user's intent for this group. This is the only required field besides
               the name that must be specified on group creation.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InterconnectGroupInterconnectArgs', 'InterconnectGroupInterconnectArgsDict']]]] interconnects: (Output)
               Interconnects used to explain this blocker in more
               detail.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InterconnectGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An interconnect group resource allows customers to create, analyze, and
        expand their redundant connections.

        To get more information about InterconnectGroup, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/interconnects)
        * How-to Guides
            * [Create a Dedicated Interconnect](https://cloud.google.com/network-connectivity/docs/interconnect/concepts/dedicated-overview)

        ## Example Usage

        ### Interconnect Group Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_interconnect_group = gcp.compute.InterconnectGroup("example-interconnect-group",
            name="example-interconnect-group",
            intent={
                "topology_capability": "NO_SLA",
            })
        ```

        ## Import

        InterconnectGroup can be imported using any of these accepted formats:

        * `projects/{{project}}/global/interconnectGroups/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, InterconnectGroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/interconnectGroup:InterconnectGroup default projects/{{project}}/global/interconnectGroups/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnectGroup:InterconnectGroup default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnectGroup:InterconnectGroup default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InterconnectGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InterconnectGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 intent: Optional[pulumi.Input[Union['InterconnectGroupIntentArgs', 'InterconnectGroupIntentArgsDict']]] = None,
                 interconnects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterconnectGroupInterconnectArgs', 'InterconnectGroupInterconnectArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InterconnectGroupArgs.__new__(InterconnectGroupArgs)

            __props__.__dict__["description"] = description
            if intent is None and not opts.urn:
                raise TypeError("Missing required property 'intent'")
            __props__.__dict__["intent"] = intent
            __props__.__dict__["interconnects"] = interconnects
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["configureds"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["physical_structures"] = None
        super(InterconnectGroup, __self__).__init__(
            'gcp:compute/interconnectGroup:InterconnectGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configureds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterconnectGroupConfiguredArgs', 'InterconnectGroupConfiguredArgsDict']]]]] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            intent: Optional[pulumi.Input[Union['InterconnectGroupIntentArgs', 'InterconnectGroupIntentArgsDict']]] = None,
            interconnects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterconnectGroupInterconnectArgs', 'InterconnectGroupInterconnectArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            physical_structures: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterconnectGroupPhysicalStructureArgs', 'InterconnectGroupPhysicalStructureArgsDict']]]]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None) -> 'InterconnectGroup':
        """
        Get an existing InterconnectGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InterconnectGroupConfiguredArgs', 'InterconnectGroupConfiguredArgsDict']]]] configureds: The status of the group as configured. This has the same
               structure as the operational field reported by the OperationalStatus
               method, but does not take into account the operational status of each
               resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Union['InterconnectGroupIntentArgs', 'InterconnectGroupIntentArgsDict']] intent: The user's intent for this group. This is the only required field besides
               the name that must be specified on group creation.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InterconnectGroupInterconnectArgs', 'InterconnectGroupInterconnectArgsDict']]]] interconnects: (Output)
               Interconnects used to explain this blocker in more
               detail.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InterconnectGroupPhysicalStructureArgs', 'InterconnectGroupPhysicalStructureArgsDict']]]] physical_structures: An analysis of the physical layout of Interconnects in this
               group. Every Interconnect in the group is shown once in this structure.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InterconnectGroupState.__new__(_InterconnectGroupState)

        __props__.__dict__["configureds"] = configureds
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["intent"] = intent
        __props__.__dict__["interconnects"] = interconnects
        __props__.__dict__["name"] = name
        __props__.__dict__["physical_structures"] = physical_structures
        __props__.__dict__["project"] = project
        return InterconnectGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def configureds(self) -> pulumi.Output[Sequence['outputs.InterconnectGroupConfigured']]:
        """
        The status of the group as configured. This has the same
        structure as the operational field reported by the OperationalStatus
        method, but does not take into account the operational status of each
        resource.
        Structure is documented below.
        """
        return pulumi.get(self, "configureds")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def intent(self) -> pulumi.Output['outputs.InterconnectGroupIntent']:
        """
        The user's intent for this group. This is the only required field besides
        the name that must be specified on group creation.
        Structure is documented below.
        """
        return pulumi.get(self, "intent")

    @property
    @pulumi.getter
    def interconnects(self) -> pulumi.Output[Optional[Sequence['outputs.InterconnectGroupInterconnect']]]:
        """
        (Output)
        Interconnects used to explain this blocker in more
        detail.
        """
        return pulumi.get(self, "interconnects")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be
        1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="physicalStructures")
    def physical_structures(self) -> pulumi.Output[Sequence['outputs.InterconnectGroupPhysicalStructure']]:
        """
        An analysis of the physical layout of Interconnects in this
        group. Every Interconnect in the group is shown once in this structure.
        Structure is documented below.
        """
        return pulumi.get(self, "physical_structures")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

