# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkFirewallPolicyPacketMirroringRuleArgs', 'NetworkFirewallPolicyPacketMirroringRule']

@pulumi.input_type
class NetworkFirewallPolicyPacketMirroringRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 direction: pulumi.Input[builtins.str],
                 firewall_policy: pulumi.Input[builtins.str],
                 match: pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleMatchArgs'],
                 priority: pulumi.Input[builtins.int],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 security_profile_group: Optional[pulumi.Input[builtins.str]] = None,
                 target_secure_tags: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgs']]]] = None,
                 tls_inspect: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a NetworkFirewallPolicyPacketMirroringRule resource.
        :param pulumi.Input[builtins.str] action: The Action to perform when the client connection triggers the rule. Valid actions are "mirror", "do_not_mirror", "goto_next".
        :param pulumi.Input[builtins.str] direction: The direction in which this rule applies.
               Possible values are: `INGRESS`, `EGRESS`.
        :param pulumi.Input[builtins.str] firewall_policy: The firewall policy of the resource.
        :param pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleMatchArgs'] match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        :param pulumi.Input[builtins.str] description: An optional description for this resource.
        :param pulumi.Input[builtins.bool] disabled: Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and
               traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
        :param pulumi.Input[builtins.str] rule_name: An optional name for the rule. This field is not a unique identifier and can be updated.
        :param pulumi.Input[builtins.str] security_profile_group: A fully-qualified URL of a SecurityProfile resource instance. Example:
               https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
               Must be specified if action = 'mirror' and cannot be specified for other actions.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgs']]] target_secure_tags: A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then
               the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the
               targetSecureTag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same
               time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule
               applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
        :param pulumi.Input[builtins.bool] tls_inspect: Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'mirror' and cannot be set
               for other actions.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "firewall_policy", firewall_policy)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "priority", priority)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if security_profile_group is not None:
            pulumi.set(__self__, "security_profile_group", security_profile_group)
        if target_secure_tags is not None:
            pulumi.set(__self__, "target_secure_tags", target_secure_tags)
        if tls_inspect is not None:
            pulumi.set(__self__, "tls_inspect", tls_inspect)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        The Action to perform when the client connection triggers the rule. Valid actions are "mirror", "do_not_mirror", "goto_next".
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[builtins.str]:
        """
        The direction in which this rule applies.
        Possible values are: `INGRESS`, `EGRESS`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="firewallPolicy")
    def firewall_policy(self) -> pulumi.Input[builtins.str]:
        """
        The firewall policy of the resource.
        """
        return pulumi.get(self, "firewall_policy")

    @firewall_policy.setter
    def firewall_policy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "firewall_policy", value)

    @property
    @pulumi.getter
    def match(self) -> pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleMatchArgs']:
        """
        A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleMatchArgs']):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[builtins.int]:
        """
        An integer indicating the priority of a rule in the list.
        The priority must be a positive value between 0 and 2147483647.
        Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description for this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and
        traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional name for the rule. This field is not a unique identifier and can be updated.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="securityProfileGroup")
    def security_profile_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A fully-qualified URL of a SecurityProfile resource instance. Example:
        https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
        Must be specified if action = 'mirror' and cannot be specified for other actions.
        """
        return pulumi.get(self, "security_profile_group")

    @security_profile_group.setter
    def security_profile_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_profile_group", value)

    @property
    @pulumi.getter(name="targetSecureTags")
    def target_secure_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgs']]]]:
        """
        A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then
        the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the
        targetSecureTag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same
        time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule
        applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
        """
        return pulumi.get(self, "target_secure_tags")

    @target_secure_tags.setter
    def target_secure_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgs']]]]):
        pulumi.set(self, "target_secure_tags", value)

    @property
    @pulumi.getter(name="tlsInspect")
    def tls_inspect(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'mirror' and cannot be set
        for other actions.
        """
        return pulumi.get(self, "tls_inspect")

    @tls_inspect.setter
    def tls_inspect(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_inspect", value)


@pulumi.input_type
class _NetworkFirewallPolicyPacketMirroringRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 firewall_policy: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 match: Optional[pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleMatchArgs']] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_tuple_count: Optional[pulumi.Input[builtins.int]] = None,
                 security_profile_group: Optional[pulumi.Input[builtins.str]] = None,
                 target_secure_tags: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgs']]]] = None,
                 tls_inspect: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering NetworkFirewallPolicyPacketMirroringRule resources.
        :param pulumi.Input[builtins.str] action: The Action to perform when the client connection triggers the rule. Valid actions are "mirror", "do_not_mirror", "goto_next".
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description for this resource.
        :param pulumi.Input[builtins.str] direction: The direction in which this rule applies.
               Possible values are: `INGRESS`, `EGRESS`.
        :param pulumi.Input[builtins.bool] disabled: Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and
               traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
        :param pulumi.Input[builtins.str] firewall_policy: The firewall policy of the resource.
        :param pulumi.Input[builtins.str] kind: Type of the resource. Always `compute#packetMirroringRule` for firewall policy packet mirroring rules
        :param pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleMatchArgs'] match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        :param pulumi.Input[builtins.str] rule_name: An optional name for the rule. This field is not a unique identifier and can be updated.
        :param pulumi.Input[builtins.int] rule_tuple_count: Calculation of the complexity of a single firewall policy rule.
        :param pulumi.Input[builtins.str] security_profile_group: A fully-qualified URL of a SecurityProfile resource instance. Example:
               https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
               Must be specified if action = 'mirror' and cannot be specified for other actions.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgs']]] target_secure_tags: A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then
               the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the
               targetSecureTag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same
               time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule
               applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
        :param pulumi.Input[builtins.bool] tls_inspect: Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'mirror' and cannot be set
               for other actions.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if firewall_policy is not None:
            pulumi.set(__self__, "firewall_policy", firewall_policy)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if rule_tuple_count is not None:
            pulumi.set(__self__, "rule_tuple_count", rule_tuple_count)
        if security_profile_group is not None:
            pulumi.set(__self__, "security_profile_group", security_profile_group)
        if target_secure_tags is not None:
            pulumi.set(__self__, "target_secure_tags", target_secure_tags)
        if tls_inspect is not None:
            pulumi.set(__self__, "tls_inspect", tls_inspect)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Action to perform when the client connection triggers the rule. Valid actions are "mirror", "do_not_mirror", "goto_next".
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description for this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The direction in which this rule applies.
        Possible values are: `INGRESS`, `EGRESS`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and
        traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="firewallPolicy")
    def firewall_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The firewall policy of the resource.
        """
        return pulumi.get(self, "firewall_policy")

    @firewall_policy.setter
    def firewall_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "firewall_policy", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the resource. Always `compute#packetMirroringRule` for firewall policy packet mirroring rules
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleMatchArgs']]:
        """
        A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleMatchArgs']]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        An integer indicating the priority of a rule in the list.
        The priority must be a positive value between 0 and 2147483647.
        Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional name for the rule. This field is not a unique identifier and can be updated.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="ruleTupleCount")
    def rule_tuple_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Calculation of the complexity of a single firewall policy rule.
        """
        return pulumi.get(self, "rule_tuple_count")

    @rule_tuple_count.setter
    def rule_tuple_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rule_tuple_count", value)

    @property
    @pulumi.getter(name="securityProfileGroup")
    def security_profile_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A fully-qualified URL of a SecurityProfile resource instance. Example:
        https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
        Must be specified if action = 'mirror' and cannot be specified for other actions.
        """
        return pulumi.get(self, "security_profile_group")

    @security_profile_group.setter
    def security_profile_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_profile_group", value)

    @property
    @pulumi.getter(name="targetSecureTags")
    def target_secure_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgs']]]]:
        """
        A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then
        the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the
        targetSecureTag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same
        time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule
        applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
        """
        return pulumi.get(self, "target_secure_tags")

    @target_secure_tags.setter
    def target_secure_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgs']]]]):
        pulumi.set(self, "target_secure_tags", value)

    @property
    @pulumi.getter(name="tlsInspect")
    def tls_inspect(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'mirror' and cannot be set
        for other actions.
        """
        return pulumi.get(self, "tls_inspect")

    @tls_inspect.setter
    def tls_inspect(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_inspect", value)


@pulumi.type_token("gcp:compute/networkFirewallPolicyPacketMirroringRule:NetworkFirewallPolicyPacketMirroringRule")
class NetworkFirewallPolicyPacketMirroringRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 firewall_policy: Optional[pulumi.Input[builtins.str]] = None,
                 match: Optional[pulumi.Input[Union['NetworkFirewallPolicyPacketMirroringRuleMatchArgs', 'NetworkFirewallPolicyPacketMirroringRuleMatchArgsDict']]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 security_profile_group: Optional[pulumi.Input[builtins.str]] = None,
                 target_secure_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgs', 'NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgsDict']]]]] = None,
                 tls_inspect: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Compute Network Firewall Policy Packet Mirroring Rule

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.compute.Network("default",
            name="fw-network",
            auto_create_subnetworks=False)
        basic_network_firewall_policy = gcp.compute.NetworkFirewallPolicy("basic_network_firewall_policy",
            name="fw-policy",
            description="Sample global network firewall policy",
            project="my-project-name")
        default_mirroring_deployment_group = gcp.networksecurity.MirroringDeploymentGroup("default",
            mirroring_deployment_group_id="deployment-group",
            location="global",
            network=default.id)
        default_mirroring_endpoint_group = gcp.networksecurity.MirroringEndpointGroup("default",
            mirroring_endpoint_group_id="endpoint-group",
            location="global",
            mirroring_deployment_group=default_mirroring_deployment_group.id)
        default_security_profile = gcp.networksecurity.SecurityProfile("default",
            name="sec-profile",
            parent="organizations/123456789",
            description="my description",
            type="CUSTOM_MIRRORING",
            custom_mirroring_profile={
                "mirroring_endpoint_group": default_mirroring_endpoint_group.id,
            })
        security_profile_group1 = gcp.networksecurity.SecurityProfileGroup("security_profile_group_1",
            name="sec-profile-group",
            parent="organizations/123456789",
            description="my description",
            custom_mirroring_profile=default_security_profile.id)
        secure_tag_key1 = gcp.tags.TagKey("secure_tag_key_1",
            description="Test tag key description",
            parent="organizations/123456789",
            purpose="GCE_FIREWALL",
            short_name="tag-key",
            purpose_data={
                "network": default.name.apply(lambda name: f"my-project-name/{name}"),
            })
        secure_tag_value1 = gcp.tags.TagValue("secure_tag_value_1",
            description="Test tag value description.",
            parent=secure_tag_key1.id,
            short_name="tag-value")
        primary = gcp.compute.NetworkFirewallPolicyPacketMirroringRule("primary",
            action="mirror",
            description="This is a simple packet mirroring rule description",
            direction="INGRESS",
            disabled=False,
            firewall_policy=basic_network_firewall_policy.name,
            priority=1000,
            rule_name="test-rule",
            match={
                "src_ip_ranges": ["10.100.0.1/32"],
                "layer4_configs": [{
                    "ip_protocol": "all",
                }],
            },
            security_profile_group=security_profile_group1.id.apply(lambda id: f"//networksecurity.googleapis.com/{id}"),
            target_secure_tags=[{
                "name": secure_tag_value1.name.apply(lambda name: f"tagValues/{name}"),
            }])
        ```

        ## Import

        NetworkFirewallPolicyPacketMirroringRule can be imported using any of these accepted formats:

        * `projects/{{project}}/global/firewallPolicies/{{firewall_policy}}/packetMirroringRules/{{priority}}`

        * `{{project}}/{{firewall_policy}}/{{priority}}`

        * `{{firewall_policy}}/{{priority}}`

        When using the `pulumi import` command, NetworkFirewallPolicyPacketMirroringRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/networkFirewallPolicyPacketMirroringRule:NetworkFirewallPolicyPacketMirroringRule default projects/{{project}}/global/firewallPolicies/{{firewall_policy}}/packetMirroringRules/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/networkFirewallPolicyPacketMirroringRule:NetworkFirewallPolicyPacketMirroringRule default {{project}}/{{firewall_policy}}/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/networkFirewallPolicyPacketMirroringRule:NetworkFirewallPolicyPacketMirroringRule default {{firewall_policy}}/{{priority}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: The Action to perform when the client connection triggers the rule. Valid actions are "mirror", "do_not_mirror", "goto_next".
        :param pulumi.Input[builtins.str] description: An optional description for this resource.
        :param pulumi.Input[builtins.str] direction: The direction in which this rule applies.
               Possible values are: `INGRESS`, `EGRESS`.
        :param pulumi.Input[builtins.bool] disabled: Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and
               traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
        :param pulumi.Input[builtins.str] firewall_policy: The firewall policy of the resource.
        :param pulumi.Input[Union['NetworkFirewallPolicyPacketMirroringRuleMatchArgs', 'NetworkFirewallPolicyPacketMirroringRuleMatchArgsDict']] match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        :param pulumi.Input[builtins.str] rule_name: An optional name for the rule. This field is not a unique identifier and can be updated.
        :param pulumi.Input[builtins.str] security_profile_group: A fully-qualified URL of a SecurityProfile resource instance. Example:
               https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
               Must be specified if action = 'mirror' and cannot be specified for other actions.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgs', 'NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgsDict']]]] target_secure_tags: A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then
               the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the
               targetSecureTag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same
               time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule
               applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
        :param pulumi.Input[builtins.bool] tls_inspect: Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'mirror' and cannot be set
               for other actions.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkFirewallPolicyPacketMirroringRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Compute Network Firewall Policy Packet Mirroring Rule

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.compute.Network("default",
            name="fw-network",
            auto_create_subnetworks=False)
        basic_network_firewall_policy = gcp.compute.NetworkFirewallPolicy("basic_network_firewall_policy",
            name="fw-policy",
            description="Sample global network firewall policy",
            project="my-project-name")
        default_mirroring_deployment_group = gcp.networksecurity.MirroringDeploymentGroup("default",
            mirroring_deployment_group_id="deployment-group",
            location="global",
            network=default.id)
        default_mirroring_endpoint_group = gcp.networksecurity.MirroringEndpointGroup("default",
            mirroring_endpoint_group_id="endpoint-group",
            location="global",
            mirroring_deployment_group=default_mirroring_deployment_group.id)
        default_security_profile = gcp.networksecurity.SecurityProfile("default",
            name="sec-profile",
            parent="organizations/123456789",
            description="my description",
            type="CUSTOM_MIRRORING",
            custom_mirroring_profile={
                "mirroring_endpoint_group": default_mirroring_endpoint_group.id,
            })
        security_profile_group1 = gcp.networksecurity.SecurityProfileGroup("security_profile_group_1",
            name="sec-profile-group",
            parent="organizations/123456789",
            description="my description",
            custom_mirroring_profile=default_security_profile.id)
        secure_tag_key1 = gcp.tags.TagKey("secure_tag_key_1",
            description="Test tag key description",
            parent="organizations/123456789",
            purpose="GCE_FIREWALL",
            short_name="tag-key",
            purpose_data={
                "network": default.name.apply(lambda name: f"my-project-name/{name}"),
            })
        secure_tag_value1 = gcp.tags.TagValue("secure_tag_value_1",
            description="Test tag value description.",
            parent=secure_tag_key1.id,
            short_name="tag-value")
        primary = gcp.compute.NetworkFirewallPolicyPacketMirroringRule("primary",
            action="mirror",
            description="This is a simple packet mirroring rule description",
            direction="INGRESS",
            disabled=False,
            firewall_policy=basic_network_firewall_policy.name,
            priority=1000,
            rule_name="test-rule",
            match={
                "src_ip_ranges": ["10.100.0.1/32"],
                "layer4_configs": [{
                    "ip_protocol": "all",
                }],
            },
            security_profile_group=security_profile_group1.id.apply(lambda id: f"//networksecurity.googleapis.com/{id}"),
            target_secure_tags=[{
                "name": secure_tag_value1.name.apply(lambda name: f"tagValues/{name}"),
            }])
        ```

        ## Import

        NetworkFirewallPolicyPacketMirroringRule can be imported using any of these accepted formats:

        * `projects/{{project}}/global/firewallPolicies/{{firewall_policy}}/packetMirroringRules/{{priority}}`

        * `{{project}}/{{firewall_policy}}/{{priority}}`

        * `{{firewall_policy}}/{{priority}}`

        When using the `pulumi import` command, NetworkFirewallPolicyPacketMirroringRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/networkFirewallPolicyPacketMirroringRule:NetworkFirewallPolicyPacketMirroringRule default projects/{{project}}/global/firewallPolicies/{{firewall_policy}}/packetMirroringRules/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/networkFirewallPolicyPacketMirroringRule:NetworkFirewallPolicyPacketMirroringRule default {{project}}/{{firewall_policy}}/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/networkFirewallPolicyPacketMirroringRule:NetworkFirewallPolicyPacketMirroringRule default {{firewall_policy}}/{{priority}}
        ```

        :param str resource_name: The name of the resource.
        :param NetworkFirewallPolicyPacketMirroringRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkFirewallPolicyPacketMirroringRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 firewall_policy: Optional[pulumi.Input[builtins.str]] = None,
                 match: Optional[pulumi.Input[Union['NetworkFirewallPolicyPacketMirroringRuleMatchArgs', 'NetworkFirewallPolicyPacketMirroringRuleMatchArgsDict']]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 security_profile_group: Optional[pulumi.Input[builtins.str]] = None,
                 target_secure_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgs', 'NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgsDict']]]]] = None,
                 tls_inspect: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkFirewallPolicyPacketMirroringRuleArgs.__new__(NetworkFirewallPolicyPacketMirroringRuleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            __props__.__dict__["disabled"] = disabled
            if firewall_policy is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_policy'")
            __props__.__dict__["firewall_policy"] = firewall_policy
            if match is None and not opts.urn:
                raise TypeError("Missing required property 'match'")
            __props__.__dict__["match"] = match
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["project"] = project
            __props__.__dict__["rule_name"] = rule_name
            __props__.__dict__["security_profile_group"] = security_profile_group
            __props__.__dict__["target_secure_tags"] = target_secure_tags
            __props__.__dict__["tls_inspect"] = tls_inspect
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["rule_tuple_count"] = None
        super(NetworkFirewallPolicyPacketMirroringRule, __self__).__init__(
            'gcp:compute/networkFirewallPolicyPacketMirroringRule:NetworkFirewallPolicyPacketMirroringRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[builtins.str]] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            direction: Optional[pulumi.Input[builtins.str]] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            firewall_policy: Optional[pulumi.Input[builtins.str]] = None,
            kind: Optional[pulumi.Input[builtins.str]] = None,
            match: Optional[pulumi.Input[Union['NetworkFirewallPolicyPacketMirroringRuleMatchArgs', 'NetworkFirewallPolicyPacketMirroringRuleMatchArgsDict']]] = None,
            priority: Optional[pulumi.Input[builtins.int]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            rule_name: Optional[pulumi.Input[builtins.str]] = None,
            rule_tuple_count: Optional[pulumi.Input[builtins.int]] = None,
            security_profile_group: Optional[pulumi.Input[builtins.str]] = None,
            target_secure_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgs', 'NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgsDict']]]]] = None,
            tls_inspect: Optional[pulumi.Input[builtins.bool]] = None) -> 'NetworkFirewallPolicyPacketMirroringRule':
        """
        Get an existing NetworkFirewallPolicyPacketMirroringRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: The Action to perform when the client connection triggers the rule. Valid actions are "mirror", "do_not_mirror", "goto_next".
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description for this resource.
        :param pulumi.Input[builtins.str] direction: The direction in which this rule applies.
               Possible values are: `INGRESS`, `EGRESS`.
        :param pulumi.Input[builtins.bool] disabled: Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and
               traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
        :param pulumi.Input[builtins.str] firewall_policy: The firewall policy of the resource.
        :param pulumi.Input[builtins.str] kind: Type of the resource. Always `compute#packetMirroringRule` for firewall policy packet mirroring rules
        :param pulumi.Input[Union['NetworkFirewallPolicyPacketMirroringRuleMatchArgs', 'NetworkFirewallPolicyPacketMirroringRuleMatchArgsDict']] match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        :param pulumi.Input[builtins.str] rule_name: An optional name for the rule. This field is not a unique identifier and can be updated.
        :param pulumi.Input[builtins.int] rule_tuple_count: Calculation of the complexity of a single firewall policy rule.
        :param pulumi.Input[builtins.str] security_profile_group: A fully-qualified URL of a SecurityProfile resource instance. Example:
               https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
               Must be specified if action = 'mirror' and cannot be specified for other actions.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgs', 'NetworkFirewallPolicyPacketMirroringRuleTargetSecureTagArgsDict']]]] target_secure_tags: A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then
               the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the
               targetSecureTag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same
               time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule
               applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
        :param pulumi.Input[builtins.bool] tls_inspect: Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'mirror' and cannot be set
               for other actions.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkFirewallPolicyPacketMirroringRuleState.__new__(_NetworkFirewallPolicyPacketMirroringRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["direction"] = direction
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["firewall_policy"] = firewall_policy
        __props__.__dict__["kind"] = kind
        __props__.__dict__["match"] = match
        __props__.__dict__["priority"] = priority
        __props__.__dict__["project"] = project
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["rule_tuple_count"] = rule_tuple_count
        __props__.__dict__["security_profile_group"] = security_profile_group
        __props__.__dict__["target_secure_tags"] = target_secure_tags
        __props__.__dict__["tls_inspect"] = tls_inspect
        return NetworkFirewallPolicyPacketMirroringRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[builtins.str]:
        """
        The Action to perform when the client connection triggers the rule. Valid actions are "mirror", "do_not_mirror", "goto_next".
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description for this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[builtins.str]:
        """
        The direction in which this rule applies.
        Possible values are: `INGRESS`, `EGRESS`.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and
        traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="firewallPolicy")
    def firewall_policy(self) -> pulumi.Output[builtins.str]:
        """
        The firewall policy of the resource.
        """
        return pulumi.get(self, "firewall_policy")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[builtins.str]:
        """
        Type of the resource. Always `compute#packetMirroringRule` for firewall policy packet mirroring rules
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def match(self) -> pulumi.Output['outputs.NetworkFirewallPolicyPacketMirroringRuleMatch']:
        """
        A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[builtins.int]:
        """
        An integer indicating the priority of a rule in the list.
        The priority must be a positive value between 0 and 2147483647.
        Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional name for the rule. This field is not a unique identifier and can be updated.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="ruleTupleCount")
    def rule_tuple_count(self) -> pulumi.Output[builtins.int]:
        """
        Calculation of the complexity of a single firewall policy rule.
        """
        return pulumi.get(self, "rule_tuple_count")

    @property
    @pulumi.getter(name="securityProfileGroup")
    def security_profile_group(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A fully-qualified URL of a SecurityProfile resource instance. Example:
        https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
        Must be specified if action = 'mirror' and cannot be specified for other actions.
        """
        return pulumi.get(self, "security_profile_group")

    @property
    @pulumi.getter(name="targetSecureTags")
    def target_secure_tags(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkFirewallPolicyPacketMirroringRuleTargetSecureTag']]]:
        """
        A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then
        the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the
        targetSecureTag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same
        time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule
        applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
        """
        return pulumi.get(self, "target_secure_tags")

    @property
    @pulumi.getter(name="tlsInspect")
    def tls_inspect(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'mirror' and cannot be set
        for other actions.
        """
        return pulumi.get(self, "tls_inspect")

