# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResourcePolicyArgs', 'ResourcePolicy']

@pulumi.input_type
class ResourcePolicyArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_consistency_group_policy: Optional[pulumi.Input['ResourcePolicyDiskConsistencyGroupPolicyArgs']] = None,
                 group_placement_policy: Optional[pulumi.Input['ResourcePolicyGroupPlacementPolicyArgs']] = None,
                 instance_schedule_policy: Optional[pulumi.Input['ResourcePolicyInstanceSchedulePolicyArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_schedule_policy: Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyArgs']] = None,
                 workload_policy: Optional[pulumi.Input['ResourcePolicyWorkloadPolicyArgs']] = None):
        """
        The set of arguments for constructing a ResourcePolicy resource.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input['ResourcePolicyDiskConsistencyGroupPolicyArgs'] disk_consistency_group_policy: Replication consistency group for asynchronous disk replication.
               Structure is documented below.
        :param pulumi.Input['ResourcePolicyGroupPlacementPolicyArgs'] group_placement_policy: Resource policy for instances used for placement configuration.
               Structure is documented below.
        :param pulumi.Input['ResourcePolicyInstanceSchedulePolicyArgs'] instance_schedule_policy: Resource policy for scheduling instance operations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the resource, provided by the client when initially creating
               the resource. The resource name must be 1-63 characters long, and comply
               with RFC1035. Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z`? which means the
               first character must be a lowercase letter, and all following characters
               must be a dash, lowercase letter, or digit, except the last character,
               which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: Region where resource policy resides.
        :param pulumi.Input['ResourcePolicySnapshotSchedulePolicyArgs'] snapshot_schedule_policy: Policy for creating snapshots of persistent disks.
               Structure is documented below.
        :param pulumi.Input['ResourcePolicyWorkloadPolicyArgs'] workload_policy: Represents the workload policy.
               Structure is documented below.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_consistency_group_policy is not None:
            pulumi.set(__self__, "disk_consistency_group_policy", disk_consistency_group_policy)
        if group_placement_policy is not None:
            pulumi.set(__self__, "group_placement_policy", group_placement_policy)
        if instance_schedule_policy is not None:
            pulumi.set(__self__, "instance_schedule_policy", instance_schedule_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if snapshot_schedule_policy is not None:
            pulumi.set(__self__, "snapshot_schedule_policy", snapshot_schedule_policy)
        if workload_policy is not None:
            pulumi.set(__self__, "workload_policy", workload_policy)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskConsistencyGroupPolicy")
    def disk_consistency_group_policy(self) -> Optional[pulumi.Input['ResourcePolicyDiskConsistencyGroupPolicyArgs']]:
        """
        Replication consistency group for asynchronous disk replication.
        Structure is documented below.
        """
        return pulumi.get(self, "disk_consistency_group_policy")

    @disk_consistency_group_policy.setter
    def disk_consistency_group_policy(self, value: Optional[pulumi.Input['ResourcePolicyDiskConsistencyGroupPolicyArgs']]):
        pulumi.set(self, "disk_consistency_group_policy", value)

    @property
    @pulumi.getter(name="groupPlacementPolicy")
    def group_placement_policy(self) -> Optional[pulumi.Input['ResourcePolicyGroupPlacementPolicyArgs']]:
        """
        Resource policy for instances used for placement configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "group_placement_policy")

    @group_placement_policy.setter
    def group_placement_policy(self, value: Optional[pulumi.Input['ResourcePolicyGroupPlacementPolicyArgs']]):
        pulumi.set(self, "group_placement_policy", value)

    @property
    @pulumi.getter(name="instanceSchedulePolicy")
    def instance_schedule_policy(self) -> Optional[pulumi.Input['ResourcePolicyInstanceSchedulePolicyArgs']]:
        """
        Resource policy for scheduling instance operations.
        Structure is documented below.
        """
        return pulumi.get(self, "instance_schedule_policy")

    @instance_schedule_policy.setter
    def instance_schedule_policy(self, value: Optional[pulumi.Input['ResourcePolicyInstanceSchedulePolicyArgs']]):
        pulumi.set(self, "instance_schedule_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource, provided by the client when initially creating
        the resource. The resource name must be 1-63 characters long, and comply
        with RFC1035. Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z`? which means the
        first character must be a lowercase letter, and all following characters
        must be a dash, lowercase letter, or digit, except the last character,
        which cannot be a dash.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where resource policy resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="snapshotSchedulePolicy")
    def snapshot_schedule_policy(self) -> Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyArgs']]:
        """
        Policy for creating snapshots of persistent disks.
        Structure is documented below.
        """
        return pulumi.get(self, "snapshot_schedule_policy")

    @snapshot_schedule_policy.setter
    def snapshot_schedule_policy(self, value: Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyArgs']]):
        pulumi.set(self, "snapshot_schedule_policy", value)

    @property
    @pulumi.getter(name="workloadPolicy")
    def workload_policy(self) -> Optional[pulumi.Input['ResourcePolicyWorkloadPolicyArgs']]:
        """
        Represents the workload policy.
        Structure is documented below.
        """
        return pulumi.get(self, "workload_policy")

    @workload_policy.setter
    def workload_policy(self, value: Optional[pulumi.Input['ResourcePolicyWorkloadPolicyArgs']]):
        pulumi.set(self, "workload_policy", value)


@pulumi.input_type
class _ResourcePolicyState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_consistency_group_policy: Optional[pulumi.Input['ResourcePolicyDiskConsistencyGroupPolicyArgs']] = None,
                 group_placement_policy: Optional[pulumi.Input['ResourcePolicyGroupPlacementPolicyArgs']] = None,
                 instance_schedule_policy: Optional[pulumi.Input['ResourcePolicyInstanceSchedulePolicyArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_schedule_policy: Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyArgs']] = None,
                 workload_policy: Optional[pulumi.Input['ResourcePolicyWorkloadPolicyArgs']] = None):
        """
        Input properties used for looking up and filtering ResourcePolicy resources.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input['ResourcePolicyDiskConsistencyGroupPolicyArgs'] disk_consistency_group_policy: Replication consistency group for asynchronous disk replication.
               Structure is documented below.
        :param pulumi.Input['ResourcePolicyGroupPlacementPolicyArgs'] group_placement_policy: Resource policy for instances used for placement configuration.
               Structure is documented below.
        :param pulumi.Input['ResourcePolicyInstanceSchedulePolicyArgs'] instance_schedule_policy: Resource policy for scheduling instance operations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the resource, provided by the client when initially creating
               the resource. The resource name must be 1-63 characters long, and comply
               with RFC1035. Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z`? which means the
               first character must be a lowercase letter, and all following characters
               must be a dash, lowercase letter, or digit, except the last character,
               which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: Region where resource policy resides.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input['ResourcePolicySnapshotSchedulePolicyArgs'] snapshot_schedule_policy: Policy for creating snapshots of persistent disks.
               Structure is documented below.
        :param pulumi.Input['ResourcePolicyWorkloadPolicyArgs'] workload_policy: Represents the workload policy.
               Structure is documented below.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_consistency_group_policy is not None:
            pulumi.set(__self__, "disk_consistency_group_policy", disk_consistency_group_policy)
        if group_placement_policy is not None:
            pulumi.set(__self__, "group_placement_policy", group_placement_policy)
        if instance_schedule_policy is not None:
            pulumi.set(__self__, "instance_schedule_policy", instance_schedule_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if snapshot_schedule_policy is not None:
            pulumi.set(__self__, "snapshot_schedule_policy", snapshot_schedule_policy)
        if workload_policy is not None:
            pulumi.set(__self__, "workload_policy", workload_policy)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskConsistencyGroupPolicy")
    def disk_consistency_group_policy(self) -> Optional[pulumi.Input['ResourcePolicyDiskConsistencyGroupPolicyArgs']]:
        """
        Replication consistency group for asynchronous disk replication.
        Structure is documented below.
        """
        return pulumi.get(self, "disk_consistency_group_policy")

    @disk_consistency_group_policy.setter
    def disk_consistency_group_policy(self, value: Optional[pulumi.Input['ResourcePolicyDiskConsistencyGroupPolicyArgs']]):
        pulumi.set(self, "disk_consistency_group_policy", value)

    @property
    @pulumi.getter(name="groupPlacementPolicy")
    def group_placement_policy(self) -> Optional[pulumi.Input['ResourcePolicyGroupPlacementPolicyArgs']]:
        """
        Resource policy for instances used for placement configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "group_placement_policy")

    @group_placement_policy.setter
    def group_placement_policy(self, value: Optional[pulumi.Input['ResourcePolicyGroupPlacementPolicyArgs']]):
        pulumi.set(self, "group_placement_policy", value)

    @property
    @pulumi.getter(name="instanceSchedulePolicy")
    def instance_schedule_policy(self) -> Optional[pulumi.Input['ResourcePolicyInstanceSchedulePolicyArgs']]:
        """
        Resource policy for scheduling instance operations.
        Structure is documented below.
        """
        return pulumi.get(self, "instance_schedule_policy")

    @instance_schedule_policy.setter
    def instance_schedule_policy(self, value: Optional[pulumi.Input['ResourcePolicyInstanceSchedulePolicyArgs']]):
        pulumi.set(self, "instance_schedule_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource, provided by the client when initially creating
        the resource. The resource name must be 1-63 characters long, and comply
        with RFC1035. Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z`? which means the
        first character must be a lowercase letter, and all following characters
        must be a dash, lowercase letter, or digit, except the last character,
        which cannot be a dash.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where resource policy resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="snapshotSchedulePolicy")
    def snapshot_schedule_policy(self) -> Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyArgs']]:
        """
        Policy for creating snapshots of persistent disks.
        Structure is documented below.
        """
        return pulumi.get(self, "snapshot_schedule_policy")

    @snapshot_schedule_policy.setter
    def snapshot_schedule_policy(self, value: Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyArgs']]):
        pulumi.set(self, "snapshot_schedule_policy", value)

    @property
    @pulumi.getter(name="workloadPolicy")
    def workload_policy(self) -> Optional[pulumi.Input['ResourcePolicyWorkloadPolicyArgs']]:
        """
        Represents the workload policy.
        Structure is documented below.
        """
        return pulumi.get(self, "workload_policy")

    @workload_policy.setter
    def workload_policy(self, value: Optional[pulumi.Input['ResourcePolicyWorkloadPolicyArgs']]):
        pulumi.set(self, "workload_policy", value)


@pulumi.type_token("gcp:compute/resourcePolicy:ResourcePolicy")
class ResourcePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_consistency_group_policy: Optional[pulumi.Input[Union['ResourcePolicyDiskConsistencyGroupPolicyArgs', 'ResourcePolicyDiskConsistencyGroupPolicyArgsDict']]] = None,
                 group_placement_policy: Optional[pulumi.Input[Union['ResourcePolicyGroupPlacementPolicyArgs', 'ResourcePolicyGroupPlacementPolicyArgsDict']]] = None,
                 instance_schedule_policy: Optional[pulumi.Input[Union['ResourcePolicyInstanceSchedulePolicyArgs', 'ResourcePolicyInstanceSchedulePolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_schedule_policy: Optional[pulumi.Input[Union['ResourcePolicySnapshotSchedulePolicyArgs', 'ResourcePolicySnapshotSchedulePolicyArgsDict']]] = None,
                 workload_policy: Optional[pulumi.Input[Union['ResourcePolicyWorkloadPolicyArgs', 'ResourcePolicyWorkloadPolicyArgsDict']]] = None,
                 __props__=None):
        """
        A policy that can be attached to a resource to specify or schedule actions on that resource.

        To get more information about ResourcePolicy, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/resourcePolicies)

        ## Example Usage

        ### Resource Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foo = gcp.compute.ResourcePolicy("foo",
            name="gce-policy",
            region="us-central1",
            snapshot_schedule_policy={
                "schedule": {
                    "daily_schedule": {
                        "days_in_cycle": 1,
                        "start_time": "04:00",
                    },
                },
            })
        ```
        ### Resource Policy Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bar = gcp.compute.ResourcePolicy("bar",
            name="gce-policy",
            region="us-central1",
            snapshot_schedule_policy={
                "schedule": {
                    "hourly_schedule": {
                        "hours_in_cycle": 20,
                        "start_time": "23:00",
                    },
                },
                "retention_policy": {
                    "max_retention_days": 10,
                    "on_source_disk_delete": "KEEP_AUTO_SNAPSHOTS",
                },
                "snapshot_properties": {
                    "labels": {
                        "my_label": "value",
                    },
                    "storage_locations": "us",
                    "guest_flush": True,
                },
            })
        ```
        ### Resource Policy Placement Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        baz = gcp.compute.ResourcePolicy("baz",
            name="gce-policy",
            region="us-central1",
            group_placement_policy={
                "vm_count": 2,
                "collocation": "COLLOCATED",
            })
        ```
        ### Resource Policy Placement Policy Max Distance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        baz = gcp.compute.ResourcePolicy("baz",
            name="gce-policy",
            region="us-central1",
            group_placement_policy={
                "vm_count": 2,
                "collocation": "COLLOCATED",
                "max_distance": 2,
            })
        ```
        ### Resource Policy Instance Schedule Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hourly = gcp.compute.ResourcePolicy("hourly",
            name="gce-policy",
            region="us-central1",
            description="Start and stop instances",
            instance_schedule_policy={
                "vm_start_schedule": {
                    "schedule": "0 * * * *",
                },
                "vm_stop_schedule": {
                    "schedule": "15 * * * *",
                },
                "time_zone": "US/Central",
            })
        ```
        ### Resource Policy Snapshot Schedule Chain Name

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hourly = gcp.compute.ResourcePolicy("hourly",
            name="gce-policy",
            region="us-central1",
            description="chain name snapshot",
            snapshot_schedule_policy={
                "schedule": {
                    "hourly_schedule": {
                        "hours_in_cycle": 20,
                        "start_time": "23:00",
                    },
                },
                "retention_policy": {
                    "max_retention_days": 14,
                    "on_source_disk_delete": "KEEP_AUTO_SNAPSHOTS",
                },
                "snapshot_properties": {
                    "labels": {
                        "my_label": "value",
                    },
                    "storage_locations": "us",
                    "guest_flush": True,
                    "chain_name": "test-schedule-chain-name",
                },
            })
        ```
        ### Resource Policy Consistency Group

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cgroup = gcp.compute.ResourcePolicy("cgroup",
            name="gce-policy",
            region="europe-west1",
            disk_consistency_group_policy={
                "enabled": True,
            })
        ```
        ### Resource Policy Workload Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bar = gcp.compute.ResourcePolicy("bar",
            name="gce-policy",
            region="europe-west1",
            workload_policy={
                "type": "HIGH_AVAILABILITY",
            })
        ```
        ### Resource Policy Workload Policy Accelerator Topology

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bar = gcp.compute.ResourcePolicy("bar",
            name="gce-policy",
            region="europe-west1",
            workload_policy={
                "type": "HIGH_THROUGHPUT",
                "accelerator_topology": "SOME NEW TOPOLOGY",
            })
        ```
        ### Resource Policy Workload Policy Max Topology Distance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bar = gcp.compute.ResourcePolicy("bar",
            name="gce-policy",
            region="europe-west1",
            workload_policy={
                "type": "HIGH_THROUGHPUT",
                "max_topology_distance": "BLOCK",
            })
        ```
        ### Resource Policy Placement Policy Gpu Topology

        ```python
        import pulumi
        import pulumi_gcp as gcp

        baz = gcp.compute.ResourcePolicy("baz",
            name="gce-policy",
            region="europe-west9",
            group_placement_policy={
                "collocation": "COLLOCATED",
                "gpu_topology": "1x72",
            })
        ```
        ### Resource Policy Placement Policy Tpu Topology

        ```python
        import pulumi
        import pulumi_gcp as gcp

        baz = gcp.compute.ResourcePolicy("baz",
            name="gce-policy",
            region="us-central1",
            group_placement_policy={
                "vm_count": 2,
                "collocation": "COLLOCATED",
                "tpu_topology": "4x4",
            })
        ```

        ## Import

        ResourcePolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/resourcePolicies/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, ResourcePolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/resourcePolicy:ResourcePolicy default projects/{{project}}/regions/{{region}}/resourcePolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resourcePolicy:ResourcePolicy default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resourcePolicy:ResourcePolicy default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resourcePolicy:ResourcePolicy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Union['ResourcePolicyDiskConsistencyGroupPolicyArgs', 'ResourcePolicyDiskConsistencyGroupPolicyArgsDict']] disk_consistency_group_policy: Replication consistency group for asynchronous disk replication.
               Structure is documented below.
        :param pulumi.Input[Union['ResourcePolicyGroupPlacementPolicyArgs', 'ResourcePolicyGroupPlacementPolicyArgsDict']] group_placement_policy: Resource policy for instances used for placement configuration.
               Structure is documented below.
        :param pulumi.Input[Union['ResourcePolicyInstanceSchedulePolicyArgs', 'ResourcePolicyInstanceSchedulePolicyArgsDict']] instance_schedule_policy: Resource policy for scheduling instance operations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the resource, provided by the client when initially creating
               the resource. The resource name must be 1-63 characters long, and comply
               with RFC1035. Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z`? which means the
               first character must be a lowercase letter, and all following characters
               must be a dash, lowercase letter, or digit, except the last character,
               which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: Region where resource policy resides.
        :param pulumi.Input[Union['ResourcePolicySnapshotSchedulePolicyArgs', 'ResourcePolicySnapshotSchedulePolicyArgsDict']] snapshot_schedule_policy: Policy for creating snapshots of persistent disks.
               Structure is documented below.
        :param pulumi.Input[Union['ResourcePolicyWorkloadPolicyArgs', 'ResourcePolicyWorkloadPolicyArgsDict']] workload_policy: Represents the workload policy.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ResourcePolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A policy that can be attached to a resource to specify or schedule actions on that resource.

        To get more information about ResourcePolicy, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/resourcePolicies)

        ## Example Usage

        ### Resource Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foo = gcp.compute.ResourcePolicy("foo",
            name="gce-policy",
            region="us-central1",
            snapshot_schedule_policy={
                "schedule": {
                    "daily_schedule": {
                        "days_in_cycle": 1,
                        "start_time": "04:00",
                    },
                },
            })
        ```
        ### Resource Policy Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bar = gcp.compute.ResourcePolicy("bar",
            name="gce-policy",
            region="us-central1",
            snapshot_schedule_policy={
                "schedule": {
                    "hourly_schedule": {
                        "hours_in_cycle": 20,
                        "start_time": "23:00",
                    },
                },
                "retention_policy": {
                    "max_retention_days": 10,
                    "on_source_disk_delete": "KEEP_AUTO_SNAPSHOTS",
                },
                "snapshot_properties": {
                    "labels": {
                        "my_label": "value",
                    },
                    "storage_locations": "us",
                    "guest_flush": True,
                },
            })
        ```
        ### Resource Policy Placement Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        baz = gcp.compute.ResourcePolicy("baz",
            name="gce-policy",
            region="us-central1",
            group_placement_policy={
                "vm_count": 2,
                "collocation": "COLLOCATED",
            })
        ```
        ### Resource Policy Placement Policy Max Distance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        baz = gcp.compute.ResourcePolicy("baz",
            name="gce-policy",
            region="us-central1",
            group_placement_policy={
                "vm_count": 2,
                "collocation": "COLLOCATED",
                "max_distance": 2,
            })
        ```
        ### Resource Policy Instance Schedule Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hourly = gcp.compute.ResourcePolicy("hourly",
            name="gce-policy",
            region="us-central1",
            description="Start and stop instances",
            instance_schedule_policy={
                "vm_start_schedule": {
                    "schedule": "0 * * * *",
                },
                "vm_stop_schedule": {
                    "schedule": "15 * * * *",
                },
                "time_zone": "US/Central",
            })
        ```
        ### Resource Policy Snapshot Schedule Chain Name

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hourly = gcp.compute.ResourcePolicy("hourly",
            name="gce-policy",
            region="us-central1",
            description="chain name snapshot",
            snapshot_schedule_policy={
                "schedule": {
                    "hourly_schedule": {
                        "hours_in_cycle": 20,
                        "start_time": "23:00",
                    },
                },
                "retention_policy": {
                    "max_retention_days": 14,
                    "on_source_disk_delete": "KEEP_AUTO_SNAPSHOTS",
                },
                "snapshot_properties": {
                    "labels": {
                        "my_label": "value",
                    },
                    "storage_locations": "us",
                    "guest_flush": True,
                    "chain_name": "test-schedule-chain-name",
                },
            })
        ```
        ### Resource Policy Consistency Group

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cgroup = gcp.compute.ResourcePolicy("cgroup",
            name="gce-policy",
            region="europe-west1",
            disk_consistency_group_policy={
                "enabled": True,
            })
        ```
        ### Resource Policy Workload Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bar = gcp.compute.ResourcePolicy("bar",
            name="gce-policy",
            region="europe-west1",
            workload_policy={
                "type": "HIGH_AVAILABILITY",
            })
        ```
        ### Resource Policy Workload Policy Accelerator Topology

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bar = gcp.compute.ResourcePolicy("bar",
            name="gce-policy",
            region="europe-west1",
            workload_policy={
                "type": "HIGH_THROUGHPUT",
                "accelerator_topology": "SOME NEW TOPOLOGY",
            })
        ```
        ### Resource Policy Workload Policy Max Topology Distance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bar = gcp.compute.ResourcePolicy("bar",
            name="gce-policy",
            region="europe-west1",
            workload_policy={
                "type": "HIGH_THROUGHPUT",
                "max_topology_distance": "BLOCK",
            })
        ```
        ### Resource Policy Placement Policy Gpu Topology

        ```python
        import pulumi
        import pulumi_gcp as gcp

        baz = gcp.compute.ResourcePolicy("baz",
            name="gce-policy",
            region="europe-west9",
            group_placement_policy={
                "collocation": "COLLOCATED",
                "gpu_topology": "1x72",
            })
        ```
        ### Resource Policy Placement Policy Tpu Topology

        ```python
        import pulumi
        import pulumi_gcp as gcp

        baz = gcp.compute.ResourcePolicy("baz",
            name="gce-policy",
            region="us-central1",
            group_placement_policy={
                "vm_count": 2,
                "collocation": "COLLOCATED",
                "tpu_topology": "4x4",
            })
        ```

        ## Import

        ResourcePolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/resourcePolicies/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, ResourcePolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/resourcePolicy:ResourcePolicy default projects/{{project}}/regions/{{region}}/resourcePolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resourcePolicy:ResourcePolicy default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resourcePolicy:ResourcePolicy default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resourcePolicy:ResourcePolicy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ResourcePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourcePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_consistency_group_policy: Optional[pulumi.Input[Union['ResourcePolicyDiskConsistencyGroupPolicyArgs', 'ResourcePolicyDiskConsistencyGroupPolicyArgsDict']]] = None,
                 group_placement_policy: Optional[pulumi.Input[Union['ResourcePolicyGroupPlacementPolicyArgs', 'ResourcePolicyGroupPlacementPolicyArgsDict']]] = None,
                 instance_schedule_policy: Optional[pulumi.Input[Union['ResourcePolicyInstanceSchedulePolicyArgs', 'ResourcePolicyInstanceSchedulePolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_schedule_policy: Optional[pulumi.Input[Union['ResourcePolicySnapshotSchedulePolicyArgs', 'ResourcePolicySnapshotSchedulePolicyArgsDict']]] = None,
                 workload_policy: Optional[pulumi.Input[Union['ResourcePolicyWorkloadPolicyArgs', 'ResourcePolicyWorkloadPolicyArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourcePolicyArgs.__new__(ResourcePolicyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["disk_consistency_group_policy"] = disk_consistency_group_policy
            __props__.__dict__["group_placement_policy"] = group_placement_policy
            __props__.__dict__["instance_schedule_policy"] = instance_schedule_policy
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["snapshot_schedule_policy"] = snapshot_schedule_policy
            __props__.__dict__["workload_policy"] = workload_policy
            __props__.__dict__["self_link"] = None
        super(ResourcePolicy, __self__).__init__(
            'gcp:compute/resourcePolicy:ResourcePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            disk_consistency_group_policy: Optional[pulumi.Input[Union['ResourcePolicyDiskConsistencyGroupPolicyArgs', 'ResourcePolicyDiskConsistencyGroupPolicyArgsDict']]] = None,
            group_placement_policy: Optional[pulumi.Input[Union['ResourcePolicyGroupPlacementPolicyArgs', 'ResourcePolicyGroupPlacementPolicyArgsDict']]] = None,
            instance_schedule_policy: Optional[pulumi.Input[Union['ResourcePolicyInstanceSchedulePolicyArgs', 'ResourcePolicyInstanceSchedulePolicyArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            snapshot_schedule_policy: Optional[pulumi.Input[Union['ResourcePolicySnapshotSchedulePolicyArgs', 'ResourcePolicySnapshotSchedulePolicyArgsDict']]] = None,
            workload_policy: Optional[pulumi.Input[Union['ResourcePolicyWorkloadPolicyArgs', 'ResourcePolicyWorkloadPolicyArgsDict']]] = None) -> 'ResourcePolicy':
        """
        Get an existing ResourcePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Union['ResourcePolicyDiskConsistencyGroupPolicyArgs', 'ResourcePolicyDiskConsistencyGroupPolicyArgsDict']] disk_consistency_group_policy: Replication consistency group for asynchronous disk replication.
               Structure is documented below.
        :param pulumi.Input[Union['ResourcePolicyGroupPlacementPolicyArgs', 'ResourcePolicyGroupPlacementPolicyArgsDict']] group_placement_policy: Resource policy for instances used for placement configuration.
               Structure is documented below.
        :param pulumi.Input[Union['ResourcePolicyInstanceSchedulePolicyArgs', 'ResourcePolicyInstanceSchedulePolicyArgsDict']] instance_schedule_policy: Resource policy for scheduling instance operations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the resource, provided by the client when initially creating
               the resource. The resource name must be 1-63 characters long, and comply
               with RFC1035. Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z`? which means the
               first character must be a lowercase letter, and all following characters
               must be a dash, lowercase letter, or digit, except the last character,
               which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: Region where resource policy resides.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Union['ResourcePolicySnapshotSchedulePolicyArgs', 'ResourcePolicySnapshotSchedulePolicyArgsDict']] snapshot_schedule_policy: Policy for creating snapshots of persistent disks.
               Structure is documented below.
        :param pulumi.Input[Union['ResourcePolicyWorkloadPolicyArgs', 'ResourcePolicyWorkloadPolicyArgsDict']] workload_policy: Represents the workload policy.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourcePolicyState.__new__(_ResourcePolicyState)

        __props__.__dict__["description"] = description
        __props__.__dict__["disk_consistency_group_policy"] = disk_consistency_group_policy
        __props__.__dict__["group_placement_policy"] = group_placement_policy
        __props__.__dict__["instance_schedule_policy"] = instance_schedule_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["snapshot_schedule_policy"] = snapshot_schedule_policy
        __props__.__dict__["workload_policy"] = workload_policy
        return ResourcePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskConsistencyGroupPolicy")
    def disk_consistency_group_policy(self) -> pulumi.Output[Optional['outputs.ResourcePolicyDiskConsistencyGroupPolicy']]:
        """
        Replication consistency group for asynchronous disk replication.
        Structure is documented below.
        """
        return pulumi.get(self, "disk_consistency_group_policy")

    @property
    @pulumi.getter(name="groupPlacementPolicy")
    def group_placement_policy(self) -> pulumi.Output[Optional['outputs.ResourcePolicyGroupPlacementPolicy']]:
        """
        Resource policy for instances used for placement configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "group_placement_policy")

    @property
    @pulumi.getter(name="instanceSchedulePolicy")
    def instance_schedule_policy(self) -> pulumi.Output[Optional['outputs.ResourcePolicyInstanceSchedulePolicy']]:
        """
        Resource policy for scheduling instance operations.
        Structure is documented below.
        """
        return pulumi.get(self, "instance_schedule_policy")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource, provided by the client when initially creating
        the resource. The resource name must be 1-63 characters long, and comply
        with RFC1035. Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z`? which means the
        first character must be a lowercase letter, and all following characters
        must be a dash, lowercase letter, or digit, except the last character,
        which cannot be a dash.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where resource policy resides.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="snapshotSchedulePolicy")
    def snapshot_schedule_policy(self) -> pulumi.Output[Optional['outputs.ResourcePolicySnapshotSchedulePolicy']]:
        """
        Policy for creating snapshots of persistent disks.
        Structure is documented below.
        """
        return pulumi.get(self, "snapshot_schedule_policy")

    @property
    @pulumi.getter(name="workloadPolicy")
    def workload_policy(self) -> pulumi.Output[Optional['outputs.ResourcePolicyWorkloadPolicy']]:
        """
        Represents the workload policy.
        Structure is documented below.
        """
        return pulumi.get(self, "workload_policy")

