# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ResourcePolicyAttachmentArgs', 'ResourcePolicyAttachment']

@pulumi.input_type
class ResourcePolicyAttachmentArgs:
    def __init__(__self__, *,
                 instance: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ResourcePolicyAttachment resource.
        :param pulumi.Input[builtins.str] instance: The name of the instance in which the resource policies are attached to.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: The resource policy to be attached to the instance for scheduling start/stop
               operations. Do not specify the self link.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] zone: A reference to the zone where the instance resides.
        """
        pulumi.set(__self__, "instance", instance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Input[builtins.str]:
        """
        The name of the instance in which the resource policies are attached to.


        - - -
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource policy to be attached to the instance for scheduling start/stop
        operations. Do not specify the self link.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to the zone where the instance resides.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _ResourcePolicyAttachmentState:
    def __init__(__self__, *,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ResourcePolicyAttachment resources.
        :param pulumi.Input[builtins.str] instance: The name of the instance in which the resource policies are attached to.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: The resource policy to be attached to the instance for scheduling start/stop
               operations. Do not specify the self link.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] zone: A reference to the zone where the instance resides.
        """
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the instance in which the resource policies are attached to.


        - - -
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource policy to be attached to the instance for scheduling start/stop
        operations. Do not specify the self link.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to the zone where the instance resides.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:compute/resourcePolicyAttachment:ResourcePolicyAttachment")
class ResourcePolicyAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Adds existing resource policies to a compute instance. You can only add one policy
        which will be applied to this instance for scheduling start/stop operations.

        This resource can be used instead of setting the resource_policy directly in the
        compute instance resource to avoid dependency issues when using instance-level IAM
        permissions.

        ## Example Usage

        ### Compute Resource Policy Attachment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.compute.Instance("instance",
            network_interfaces=[{
                "access_configs": [{}],
                "network": "default",
            }],
            name="my-instance",
            machine_type="e2-medium",
            zone="us-central1-a",
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-11",
                },
            })
        policy = gcp.compute.ResourcePolicy("policy",
            name="my-resource-policy",
            region="us-central1",
            instance_schedule_policy={
                "vm_start_schedule": {
                    "schedule": "0 8 * * *",
                },
                "vm_stop_schedule": {
                    "schedule": "0 18 * * *",
                },
                "time_zone": "America/New_York",
            })
        attachment = gcp.compute.ResourcePolicyAttachment("attachment",
            name=policy.name,
            instance=instance.name,
            zone="us-central1-a")
        ```

        ## Import

        ResourcePolicyAttachment can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/instances/{{instance}}/{{name}}`

        * `{{project}}/{{zone}}/{{instance}}/{{name}}`

        * `{{zone}}/{{instance}}/{{name}}`

        * `{{instance}}/{{name}}`

        When using the `pulumi import` command, ResourcePolicyAttachment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/resourcePolicyAttachment:ResourcePolicyAttachment default projects/{{project}}/zones/{{zone}}/instances/{{instance}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resourcePolicyAttachment:ResourcePolicyAttachment default {{project}}/{{zone}}/{{instance}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resourcePolicyAttachment:ResourcePolicyAttachment default {{zone}}/{{instance}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resourcePolicyAttachment:ResourcePolicyAttachment default {{instance}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] instance: The name of the instance in which the resource policies are attached to.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: The resource policy to be attached to the instance for scheduling start/stop
               operations. Do not specify the self link.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] zone: A reference to the zone where the instance resides.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourcePolicyAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Adds existing resource policies to a compute instance. You can only add one policy
        which will be applied to this instance for scheduling start/stop operations.

        This resource can be used instead of setting the resource_policy directly in the
        compute instance resource to avoid dependency issues when using instance-level IAM
        permissions.

        ## Example Usage

        ### Compute Resource Policy Attachment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.compute.Instance("instance",
            network_interfaces=[{
                "access_configs": [{}],
                "network": "default",
            }],
            name="my-instance",
            machine_type="e2-medium",
            zone="us-central1-a",
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-11",
                },
            })
        policy = gcp.compute.ResourcePolicy("policy",
            name="my-resource-policy",
            region="us-central1",
            instance_schedule_policy={
                "vm_start_schedule": {
                    "schedule": "0 8 * * *",
                },
                "vm_stop_schedule": {
                    "schedule": "0 18 * * *",
                },
                "time_zone": "America/New_York",
            })
        attachment = gcp.compute.ResourcePolicyAttachment("attachment",
            name=policy.name,
            instance=instance.name,
            zone="us-central1-a")
        ```

        ## Import

        ResourcePolicyAttachment can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/instances/{{instance}}/{{name}}`

        * `{{project}}/{{zone}}/{{instance}}/{{name}}`

        * `{{zone}}/{{instance}}/{{name}}`

        * `{{instance}}/{{name}}`

        When using the `pulumi import` command, ResourcePolicyAttachment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/resourcePolicyAttachment:ResourcePolicyAttachment default projects/{{project}}/zones/{{zone}}/instances/{{instance}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resourcePolicyAttachment:ResourcePolicyAttachment default {{project}}/{{zone}}/{{instance}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resourcePolicyAttachment:ResourcePolicyAttachment default {{zone}}/{{instance}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resourcePolicyAttachment:ResourcePolicyAttachment default {{instance}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ResourcePolicyAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourcePolicyAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourcePolicyAttachmentArgs.__new__(ResourcePolicyAttachmentArgs)

            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["zone"] = zone
        super(ResourcePolicyAttachment, __self__).__init__(
            'gcp:compute/resourcePolicyAttachment:ResourcePolicyAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'ResourcePolicyAttachment':
        """
        Get an existing ResourcePolicyAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] instance: The name of the instance in which the resource policies are attached to.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: The resource policy to be attached to the instance for scheduling start/stop
               operations. Do not specify the self link.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] zone: A reference to the zone where the instance resides.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourcePolicyAttachmentState.__new__(_ResourcePolicyAttachmentState)

        __props__.__dict__["instance"] = instance
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["zone"] = zone
        return ResourcePolicyAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[builtins.str]:
        """
        The name of the instance in which the resource policies are attached to.


        - - -
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource policy to be attached to the instance for scheduling start/stop
        operations. Do not specify the self link.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        A reference to the zone where the instance resides.
        """
        return pulumi.get(self, "zone")

