# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouterPeerArgs', 'RouterPeer']

@pulumi.input_type
class RouterPeerArgs:
    def __init__(__self__, *,
                 interface: pulumi.Input[builtins.str],
                 peer_asn: pulumi.Input[builtins.int],
                 router: pulumi.Input[builtins.str],
                 advertise_mode: Optional[pulumi.Input[builtins.str]] = None,
                 advertised_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 advertised_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]]] = None,
                 advertised_route_priority: Optional[pulumi.Input[builtins.int]] = None,
                 bfd: Optional[pulumi.Input['RouterPeerBfdArgs']] = None,
                 custom_learned_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerCustomLearnedIpRangeArgs']]]] = None,
                 custom_learned_route_priority: Optional[pulumi.Input[builtins.int]] = None,
                 enable: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_ipv4: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 export_policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 import_policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 md5_authentication_key: Optional[pulumi.Input['RouterPeerMd5AuthenticationKeyArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peer_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 peer_ipv4_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 peer_ipv6_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 router_appliance_instance: Optional[pulumi.Input[builtins.str]] = None,
                 zero_advertised_route_priority: Optional[pulumi.Input[builtins.bool]] = None,
                 zero_custom_learned_route_priority: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a RouterPeer resource.
        :param pulumi.Input[builtins.str] interface: Name of the interface the BGP peer is associated with.
        :param pulumi.Input[builtins.int] peer_asn: Peer BGP Autonomous System Number (ASN).
               Each BGP interface may use a different value.
        :param pulumi.Input[builtins.str] router: The name of the Cloud Router in which this BgpPeer will be configured.
               
               
               - - -
        :param pulumi.Input[builtins.str] advertise_mode: User-specified flag to indicate which mode to use for advertisement.
               Valid values of this enum field are: `DEFAULT`, `CUSTOM`
               Default value is `DEFAULT`.
               Possible values are: `DEFAULT`, `CUSTOM`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] advertised_groups: User-specified list of prefix groups to advertise in custom
               mode, which currently supports the following option:
               * `ALL_SUBNETS`: Advertises all of the router's own VPC subnets.
               This excludes any routes learned for subnets that use VPC Network
               Peering.
               
               Note that this field can only be populated if advertiseMode is `CUSTOM`
               and overrides the list defined for the router (in the "bgp" message).
               These groups are advertised in addition to any specified prefixes.
               Leave this field blank to advertise no custom groups.
        :param pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]] advertised_ip_ranges: User-specified list of individual IP ranges to advertise in
               custom mode. This field can only be populated if advertiseMode
               is `CUSTOM` and is advertised to all peers of the router. These IP
               ranges will be advertised in addition to any specified groups.
               Leave this field blank to advertise no custom IP ranges.
               Structure is documented below.
        :param pulumi.Input[builtins.int] advertised_route_priority: The priority of routes advertised to this BGP peer.
               Where there is more than one matching route of maximum
               length, the routes with the lowest priority value win.
        :param pulumi.Input['RouterPeerBfdArgs'] bfd: BFD configuration for the BGP peering.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['RouterPeerCustomLearnedIpRangeArgs']]] custom_learned_ip_ranges: The custom learned route IP address range. Must be a valid CIDR-formatted prefix.
               If an IP address is provided without a subnet mask, it is interpreted as, for IPv4,
               a /32 singular IP address range, and, for IPv6, /128.
               Structure is documented below.
        :param pulumi.Input[builtins.int] custom_learned_route_priority: The user-defined custom learned route priority for a BGP session.
               This value is applied to all custom learned route ranges for the session.
               You can choose a value from 0 to 65335. If you don't provide a value,
               Google Cloud assigns a priority of 100 to the ranges.
        :param pulumi.Input[builtins.bool] enable: The status of the BGP peer connection. If set to false, any active session
               with the peer is terminated and all associated routing information is removed.
               If set to true, the peer connection can be established with routing information.
               The default is true.
        :param pulumi.Input[builtins.bool] enable_ipv4: Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
        :param pulumi.Input[builtins.bool] enable_ipv6: Enable IPv6 traffic over BGP Peer. If not specified, it is disabled by default.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] export_policies: routers.list of export policies applied to this peer, in the order they must be evaluated.
               The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] import_policies: routers.list of import policies applied to this peer, in the order they must be evaluated.
               The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
        :param pulumi.Input[builtins.str] ip_address: IP address of the interface inside Google Cloud Platform.
               Only IPv4 is supported.
        :param pulumi.Input[builtins.str] ipv4_nexthop_address: IPv4 address of the interface inside Google Cloud Platform.
        :param pulumi.Input[builtins.str] ipv6_nexthop_address: IPv6 address of the interface inside Google Cloud Platform.
               The address must be in the range 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64.
               If you do not specify the next hop addresses, Google Cloud automatically
               assigns unused addresses from the 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64 range for you.
        :param pulumi.Input['RouterPeerMd5AuthenticationKeyArgs'] md5_authentication_key: Configuration for MD5 authentication on the BGP session.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name of this BGP peer. The name must be 1-63 characters long,
               and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] peer_ip_address: IP address of the BGP interface outside Google Cloud Platform.
               Only IPv4 is supported. Required if `ip_address` is set.
        :param pulumi.Input[builtins.str] peer_ipv4_nexthop_address: IPv4 address of the BGP interface outside Google Cloud Platform.
        :param pulumi.Input[builtins.str] peer_ipv6_nexthop_address: IPv6 address of the BGP interface outside Google Cloud Platform.
               The address must be in the range 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64.
               If you do not specify the next hop addresses, Google Cloud automatically
               assigns unused addresses from the 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64 range for you.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: Region where the router and BgpPeer reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[builtins.str] router_appliance_instance: The URI of the VM instance that is used as third-party router appliances
               such as Next Gen Firewalls, Virtual Routers, or Router Appliances.
               The VM instance must be located in zones contained in the same region as
               this Cloud Router. The VM instance is the peer side of the BGP session.
        :param pulumi.Input[builtins.bool] zero_advertised_route_priority: The user-defined zero-advertised-route-priority for a advertised-route-priority in BGP session.
               This value has to be set true to force the advertised_route_priority to be 0.
        :param pulumi.Input[builtins.bool] zero_custom_learned_route_priority: The user-defined zero-custom-learned-route-priority for a custom-learned-route-priority in BGP session.
               This value has to be set true to force the custom_learned_route_priority to be 0.
        """
        pulumi.set(__self__, "interface", interface)
        pulumi.set(__self__, "peer_asn", peer_asn)
        pulumi.set(__self__, "router", router)
        if advertise_mode is not None:
            pulumi.set(__self__, "advertise_mode", advertise_mode)
        if advertised_groups is not None:
            pulumi.set(__self__, "advertised_groups", advertised_groups)
        if advertised_ip_ranges is not None:
            pulumi.set(__self__, "advertised_ip_ranges", advertised_ip_ranges)
        if advertised_route_priority is not None:
            pulumi.set(__self__, "advertised_route_priority", advertised_route_priority)
        if bfd is not None:
            pulumi.set(__self__, "bfd", bfd)
        if custom_learned_ip_ranges is not None:
            pulumi.set(__self__, "custom_learned_ip_ranges", custom_learned_ip_ranges)
        if custom_learned_route_priority is not None:
            pulumi.set(__self__, "custom_learned_route_priority", custom_learned_route_priority)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if enable_ipv4 is not None:
            pulumi.set(__self__, "enable_ipv4", enable_ipv4)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if export_policies is not None:
            pulumi.set(__self__, "export_policies", export_policies)
        if import_policies is not None:
            pulumi.set(__self__, "import_policies", import_policies)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ipv4_nexthop_address is not None:
            pulumi.set(__self__, "ipv4_nexthop_address", ipv4_nexthop_address)
        if ipv6_nexthop_address is not None:
            pulumi.set(__self__, "ipv6_nexthop_address", ipv6_nexthop_address)
        if md5_authentication_key is not None:
            pulumi.set(__self__, "md5_authentication_key", md5_authentication_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_ip_address is not None:
            pulumi.set(__self__, "peer_ip_address", peer_ip_address)
        if peer_ipv4_nexthop_address is not None:
            pulumi.set(__self__, "peer_ipv4_nexthop_address", peer_ipv4_nexthop_address)
        if peer_ipv6_nexthop_address is not None:
            pulumi.set(__self__, "peer_ipv6_nexthop_address", peer_ipv6_nexthop_address)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if router_appliance_instance is not None:
            pulumi.set(__self__, "router_appliance_instance", router_appliance_instance)
        if zero_advertised_route_priority is not None:
            pulumi.set(__self__, "zero_advertised_route_priority", zero_advertised_route_priority)
        if zero_custom_learned_route_priority is not None:
            pulumi.set(__self__, "zero_custom_learned_route_priority", zero_custom_learned_route_priority)

    @property
    @pulumi.getter
    def interface(self) -> pulumi.Input[builtins.str]:
        """
        Name of the interface the BGP peer is associated with.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> pulumi.Input[builtins.int]:
        """
        Peer BGP Autonomous System Number (ASN).
        Each BGP interface may use a different value.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "peer_asn", value)

    @property
    @pulumi.getter
    def router(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Cloud Router in which this BgpPeer will be configured.


        - - -
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter(name="advertiseMode")
    def advertise_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-specified flag to indicate which mode to use for advertisement.
        Valid values of this enum field are: `DEFAULT`, `CUSTOM`
        Default value is `DEFAULT`.
        Possible values are: `DEFAULT`, `CUSTOM`.
        """
        return pulumi.get(self, "advertise_mode")

    @advertise_mode.setter
    def advertise_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "advertise_mode", value)

    @property
    @pulumi.getter(name="advertisedGroups")
    def advertised_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        User-specified list of prefix groups to advertise in custom
        mode, which currently supports the following option:
        * `ALL_SUBNETS`: Advertises all of the router's own VPC subnets.
        This excludes any routes learned for subnets that use VPC Network
        Peering.

        Note that this field can only be populated if advertiseMode is `CUSTOM`
        and overrides the list defined for the router (in the "bgp" message).
        These groups are advertised in addition to any specified prefixes.
        Leave this field blank to advertise no custom groups.
        """
        return pulumi.get(self, "advertised_groups")

    @advertised_groups.setter
    def advertised_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "advertised_groups", value)

    @property
    @pulumi.getter(name="advertisedIpRanges")
    def advertised_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]]]:
        """
        User-specified list of individual IP ranges to advertise in
        custom mode. This field can only be populated if advertiseMode
        is `CUSTOM` and is advertised to all peers of the router. These IP
        ranges will be advertised in addition to any specified groups.
        Leave this field blank to advertise no custom IP ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "advertised_ip_ranges")

    @advertised_ip_ranges.setter
    def advertised_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]]]):
        pulumi.set(self, "advertised_ip_ranges", value)

    @property
    @pulumi.getter(name="advertisedRoutePriority")
    def advertised_route_priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The priority of routes advertised to this BGP peer.
        Where there is more than one matching route of maximum
        length, the routes with the lowest priority value win.
        """
        return pulumi.get(self, "advertised_route_priority")

    @advertised_route_priority.setter
    def advertised_route_priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "advertised_route_priority", value)

    @property
    @pulumi.getter
    def bfd(self) -> Optional[pulumi.Input['RouterPeerBfdArgs']]:
        """
        BFD configuration for the BGP peering.
        Structure is documented below.
        """
        return pulumi.get(self, "bfd")

    @bfd.setter
    def bfd(self, value: Optional[pulumi.Input['RouterPeerBfdArgs']]):
        pulumi.set(self, "bfd", value)

    @property
    @pulumi.getter(name="customLearnedIpRanges")
    def custom_learned_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerCustomLearnedIpRangeArgs']]]]:
        """
        The custom learned route IP address range. Must be a valid CIDR-formatted prefix.
        If an IP address is provided without a subnet mask, it is interpreted as, for IPv4,
        a /32 singular IP address range, and, for IPv6, /128.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_learned_ip_ranges")

    @custom_learned_ip_ranges.setter
    def custom_learned_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerCustomLearnedIpRangeArgs']]]]):
        pulumi.set(self, "custom_learned_ip_ranges", value)

    @property
    @pulumi.getter(name="customLearnedRoutePriority")
    def custom_learned_route_priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The user-defined custom learned route priority for a BGP session.
        This value is applied to all custom learned route ranges for the session.
        You can choose a value from 0 to 65335. If you don't provide a value,
        Google Cloud assigns a priority of 100 to the ranges.
        """
        return pulumi.get(self, "custom_learned_route_priority")

    @custom_learned_route_priority.setter
    def custom_learned_route_priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "custom_learned_route_priority", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The status of the BGP peer connection. If set to false, any active session
        with the peer is terminated and all associated routing information is removed.
        If set to true, the peer connection can be established with routing information.
        The default is true.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="enableIpv4")
    def enable_ipv4(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
        """
        return pulumi.get(self, "enable_ipv4")

    @enable_ipv4.setter
    def enable_ipv4(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_ipv4", value)

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable IPv6 traffic over BGP Peer. If not specified, it is disabled by default.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @property
    @pulumi.getter(name="exportPolicies")
    def export_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        routers.list of export policies applied to this peer, in the order they must be evaluated.
        The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
        """
        return pulumi.get(self, "export_policies")

    @export_policies.setter
    def export_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "export_policies", value)

    @property
    @pulumi.getter(name="importPolicies")
    def import_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        routers.list of import policies applied to this peer, in the order they must be evaluated.
        The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
        """
        return pulumi.get(self, "import_policies")

    @import_policies.setter
    def import_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "import_policies", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address of the interface inside Google Cloud Platform.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipv4NexthopAddress")
    def ipv4_nexthop_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv4 address of the interface inside Google Cloud Platform.
        """
        return pulumi.get(self, "ipv4_nexthop_address")

    @ipv4_nexthop_address.setter
    def ipv4_nexthop_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_nexthop_address", value)

    @property
    @pulumi.getter(name="ipv6NexthopAddress")
    def ipv6_nexthop_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv6 address of the interface inside Google Cloud Platform.
        The address must be in the range 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64.
        If you do not specify the next hop addresses, Google Cloud automatically
        assigns unused addresses from the 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64 range for you.
        """
        return pulumi.get(self, "ipv6_nexthop_address")

    @ipv6_nexthop_address.setter
    def ipv6_nexthop_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv6_nexthop_address", value)

    @property
    @pulumi.getter(name="md5AuthenticationKey")
    def md5_authentication_key(self) -> Optional[pulumi.Input['RouterPeerMd5AuthenticationKeyArgs']]:
        """
        Configuration for MD5 authentication on the BGP session.
        Structure is documented below.
        """
        return pulumi.get(self, "md5_authentication_key")

    @md5_authentication_key.setter
    def md5_authentication_key(self, value: Optional[pulumi.Input['RouterPeerMd5AuthenticationKeyArgs']]):
        pulumi.set(self, "md5_authentication_key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of this BGP peer. The name must be 1-63 characters long,
        and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which
        means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address of the BGP interface outside Google Cloud Platform.
        Only IPv4 is supported. Required if `ip_address` is set.
        """
        return pulumi.get(self, "peer_ip_address")

    @peer_ip_address.setter
    def peer_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_ip_address", value)

    @property
    @pulumi.getter(name="peerIpv4NexthopAddress")
    def peer_ipv4_nexthop_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv4 address of the BGP interface outside Google Cloud Platform.
        """
        return pulumi.get(self, "peer_ipv4_nexthop_address")

    @peer_ipv4_nexthop_address.setter
    def peer_ipv4_nexthop_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_ipv4_nexthop_address", value)

    @property
    @pulumi.getter(name="peerIpv6NexthopAddress")
    def peer_ipv6_nexthop_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv6 address of the BGP interface outside Google Cloud Platform.
        The address must be in the range 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64.
        If you do not specify the next hop addresses, Google Cloud automatically
        assigns unused addresses from the 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64 range for you.
        """
        return pulumi.get(self, "peer_ipv6_nexthop_address")

    @peer_ipv6_nexthop_address.setter
    def peer_ipv6_nexthop_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_ipv6_nexthop_address", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where the router and BgpPeer reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routerApplianceInstance")
    def router_appliance_instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the VM instance that is used as third-party router appliances
        such as Next Gen Firewalls, Virtual Routers, or Router Appliances.
        The VM instance must be located in zones contained in the same region as
        this Cloud Router. The VM instance is the peer side of the BGP session.
        """
        return pulumi.get(self, "router_appliance_instance")

    @router_appliance_instance.setter
    def router_appliance_instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "router_appliance_instance", value)

    @property
    @pulumi.getter(name="zeroAdvertisedRoutePriority")
    def zero_advertised_route_priority(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The user-defined zero-advertised-route-priority for a advertised-route-priority in BGP session.
        This value has to be set true to force the advertised_route_priority to be 0.
        """
        return pulumi.get(self, "zero_advertised_route_priority")

    @zero_advertised_route_priority.setter
    def zero_advertised_route_priority(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "zero_advertised_route_priority", value)

    @property
    @pulumi.getter(name="zeroCustomLearnedRoutePriority")
    def zero_custom_learned_route_priority(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The user-defined zero-custom-learned-route-priority for a custom-learned-route-priority in BGP session.
        This value has to be set true to force the custom_learned_route_priority to be 0.
        """
        return pulumi.get(self, "zero_custom_learned_route_priority")

    @zero_custom_learned_route_priority.setter
    def zero_custom_learned_route_priority(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "zero_custom_learned_route_priority", value)


@pulumi.input_type
class _RouterPeerState:
    def __init__(__self__, *,
                 advertise_mode: Optional[pulumi.Input[builtins.str]] = None,
                 advertised_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 advertised_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]]] = None,
                 advertised_route_priority: Optional[pulumi.Input[builtins.int]] = None,
                 bfd: Optional[pulumi.Input['RouterPeerBfdArgs']] = None,
                 custom_learned_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerCustomLearnedIpRangeArgs']]]] = None,
                 custom_learned_route_priority: Optional[pulumi.Input[builtins.int]] = None,
                 enable: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_ipv4: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 export_policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 import_policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 interface: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 is_advertised_route_priority_set: Optional[pulumi.Input[builtins.bool]] = None,
                 is_custom_learned_priority_set: Optional[pulumi.Input[builtins.bool]] = None,
                 management_type: Optional[pulumi.Input[builtins.str]] = None,
                 md5_authentication_key: Optional[pulumi.Input['RouterPeerMd5AuthenticationKeyArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peer_asn: Optional[pulumi.Input[builtins.int]] = None,
                 peer_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 peer_ipv4_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 peer_ipv6_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 router: Optional[pulumi.Input[builtins.str]] = None,
                 router_appliance_instance: Optional[pulumi.Input[builtins.str]] = None,
                 zero_advertised_route_priority: Optional[pulumi.Input[builtins.bool]] = None,
                 zero_custom_learned_route_priority: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering RouterPeer resources.
        :param pulumi.Input[builtins.str] advertise_mode: User-specified flag to indicate which mode to use for advertisement.
               Valid values of this enum field are: `DEFAULT`, `CUSTOM`
               Default value is `DEFAULT`.
               Possible values are: `DEFAULT`, `CUSTOM`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] advertised_groups: User-specified list of prefix groups to advertise in custom
               mode, which currently supports the following option:
               * `ALL_SUBNETS`: Advertises all of the router's own VPC subnets.
               This excludes any routes learned for subnets that use VPC Network
               Peering.
               
               Note that this field can only be populated if advertiseMode is `CUSTOM`
               and overrides the list defined for the router (in the "bgp" message).
               These groups are advertised in addition to any specified prefixes.
               Leave this field blank to advertise no custom groups.
        :param pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]] advertised_ip_ranges: User-specified list of individual IP ranges to advertise in
               custom mode. This field can only be populated if advertiseMode
               is `CUSTOM` and is advertised to all peers of the router. These IP
               ranges will be advertised in addition to any specified groups.
               Leave this field blank to advertise no custom IP ranges.
               Structure is documented below.
        :param pulumi.Input[builtins.int] advertised_route_priority: The priority of routes advertised to this BGP peer.
               Where there is more than one matching route of maximum
               length, the routes with the lowest priority value win.
        :param pulumi.Input['RouterPeerBfdArgs'] bfd: BFD configuration for the BGP peering.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['RouterPeerCustomLearnedIpRangeArgs']]] custom_learned_ip_ranges: The custom learned route IP address range. Must be a valid CIDR-formatted prefix.
               If an IP address is provided without a subnet mask, it is interpreted as, for IPv4,
               a /32 singular IP address range, and, for IPv6, /128.
               Structure is documented below.
        :param pulumi.Input[builtins.int] custom_learned_route_priority: The user-defined custom learned route priority for a BGP session.
               This value is applied to all custom learned route ranges for the session.
               You can choose a value from 0 to 65335. If you don't provide a value,
               Google Cloud assigns a priority of 100 to the ranges.
        :param pulumi.Input[builtins.bool] enable: The status of the BGP peer connection. If set to false, any active session
               with the peer is terminated and all associated routing information is removed.
               If set to true, the peer connection can be established with routing information.
               The default is true.
        :param pulumi.Input[builtins.bool] enable_ipv4: Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
        :param pulumi.Input[builtins.bool] enable_ipv6: Enable IPv6 traffic over BGP Peer. If not specified, it is disabled by default.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] export_policies: routers.list of export policies applied to this peer, in the order they must be evaluated.
               The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] import_policies: routers.list of import policies applied to this peer, in the order they must be evaluated.
               The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
        :param pulumi.Input[builtins.str] interface: Name of the interface the BGP peer is associated with.
        :param pulumi.Input[builtins.str] ip_address: IP address of the interface inside Google Cloud Platform.
               Only IPv4 is supported.
        :param pulumi.Input[builtins.str] ipv4_nexthop_address: IPv4 address of the interface inside Google Cloud Platform.
        :param pulumi.Input[builtins.str] ipv6_nexthop_address: IPv6 address of the interface inside Google Cloud Platform.
               The address must be in the range 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64.
               If you do not specify the next hop addresses, Google Cloud automatically
               assigns unused addresses from the 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64 range for you.
        :param pulumi.Input[builtins.bool] is_advertised_route_priority_set: An internal boolean field for provider use for zero_advertised_route_priority.
        :param pulumi.Input[builtins.bool] is_custom_learned_priority_set: An internal boolean field for provider use.
        :param pulumi.Input[builtins.str] management_type: The resource that configures and manages this BGP peer.
               * `MANAGED_BY_USER` is the default value and can be managed by
               you or other users
               * `MANAGED_BY_ATTACHMENT` is a BGP peer that is configured and
               managed by Cloud Interconnect, specifically by an
               InterconnectAttachment of type PARTNER. Google automatically
               creates, updates, and deletes this type of BGP peer when the
               PARTNER InterconnectAttachment is created, updated,
               or deleted.
        :param pulumi.Input['RouterPeerMd5AuthenticationKeyArgs'] md5_authentication_key: Configuration for MD5 authentication on the BGP session.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name of this BGP peer. The name must be 1-63 characters long,
               and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[builtins.int] peer_asn: Peer BGP Autonomous System Number (ASN).
               Each BGP interface may use a different value.
        :param pulumi.Input[builtins.str] peer_ip_address: IP address of the BGP interface outside Google Cloud Platform.
               Only IPv4 is supported. Required if `ip_address` is set.
        :param pulumi.Input[builtins.str] peer_ipv4_nexthop_address: IPv4 address of the BGP interface outside Google Cloud Platform.
        :param pulumi.Input[builtins.str] peer_ipv6_nexthop_address: IPv6 address of the BGP interface outside Google Cloud Platform.
               The address must be in the range 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64.
               If you do not specify the next hop addresses, Google Cloud automatically
               assigns unused addresses from the 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64 range for you.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: Region where the router and BgpPeer reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[builtins.str] router: The name of the Cloud Router in which this BgpPeer will be configured.
               
               
               - - -
        :param pulumi.Input[builtins.str] router_appliance_instance: The URI of the VM instance that is used as third-party router appliances
               such as Next Gen Firewalls, Virtual Routers, or Router Appliances.
               The VM instance must be located in zones contained in the same region as
               this Cloud Router. The VM instance is the peer side of the BGP session.
        :param pulumi.Input[builtins.bool] zero_advertised_route_priority: The user-defined zero-advertised-route-priority for a advertised-route-priority in BGP session.
               This value has to be set true to force the advertised_route_priority to be 0.
        :param pulumi.Input[builtins.bool] zero_custom_learned_route_priority: The user-defined zero-custom-learned-route-priority for a custom-learned-route-priority in BGP session.
               This value has to be set true to force the custom_learned_route_priority to be 0.
        """
        if advertise_mode is not None:
            pulumi.set(__self__, "advertise_mode", advertise_mode)
        if advertised_groups is not None:
            pulumi.set(__self__, "advertised_groups", advertised_groups)
        if advertised_ip_ranges is not None:
            pulumi.set(__self__, "advertised_ip_ranges", advertised_ip_ranges)
        if advertised_route_priority is not None:
            pulumi.set(__self__, "advertised_route_priority", advertised_route_priority)
        if bfd is not None:
            pulumi.set(__self__, "bfd", bfd)
        if custom_learned_ip_ranges is not None:
            pulumi.set(__self__, "custom_learned_ip_ranges", custom_learned_ip_ranges)
        if custom_learned_route_priority is not None:
            pulumi.set(__self__, "custom_learned_route_priority", custom_learned_route_priority)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if enable_ipv4 is not None:
            pulumi.set(__self__, "enable_ipv4", enable_ipv4)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if export_policies is not None:
            pulumi.set(__self__, "export_policies", export_policies)
        if import_policies is not None:
            pulumi.set(__self__, "import_policies", import_policies)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ipv4_nexthop_address is not None:
            pulumi.set(__self__, "ipv4_nexthop_address", ipv4_nexthop_address)
        if ipv6_nexthop_address is not None:
            pulumi.set(__self__, "ipv6_nexthop_address", ipv6_nexthop_address)
        if is_advertised_route_priority_set is not None:
            pulumi.set(__self__, "is_advertised_route_priority_set", is_advertised_route_priority_set)
        if is_custom_learned_priority_set is not None:
            pulumi.set(__self__, "is_custom_learned_priority_set", is_custom_learned_priority_set)
        if management_type is not None:
            pulumi.set(__self__, "management_type", management_type)
        if md5_authentication_key is not None:
            pulumi.set(__self__, "md5_authentication_key", md5_authentication_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peer_ip_address is not None:
            pulumi.set(__self__, "peer_ip_address", peer_ip_address)
        if peer_ipv4_nexthop_address is not None:
            pulumi.set(__self__, "peer_ipv4_nexthop_address", peer_ipv4_nexthop_address)
        if peer_ipv6_nexthop_address is not None:
            pulumi.set(__self__, "peer_ipv6_nexthop_address", peer_ipv6_nexthop_address)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if router_appliance_instance is not None:
            pulumi.set(__self__, "router_appliance_instance", router_appliance_instance)
        if zero_advertised_route_priority is not None:
            pulumi.set(__self__, "zero_advertised_route_priority", zero_advertised_route_priority)
        if zero_custom_learned_route_priority is not None:
            pulumi.set(__self__, "zero_custom_learned_route_priority", zero_custom_learned_route_priority)

    @property
    @pulumi.getter(name="advertiseMode")
    def advertise_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-specified flag to indicate which mode to use for advertisement.
        Valid values of this enum field are: `DEFAULT`, `CUSTOM`
        Default value is `DEFAULT`.
        Possible values are: `DEFAULT`, `CUSTOM`.
        """
        return pulumi.get(self, "advertise_mode")

    @advertise_mode.setter
    def advertise_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "advertise_mode", value)

    @property
    @pulumi.getter(name="advertisedGroups")
    def advertised_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        User-specified list of prefix groups to advertise in custom
        mode, which currently supports the following option:
        * `ALL_SUBNETS`: Advertises all of the router's own VPC subnets.
        This excludes any routes learned for subnets that use VPC Network
        Peering.

        Note that this field can only be populated if advertiseMode is `CUSTOM`
        and overrides the list defined for the router (in the "bgp" message).
        These groups are advertised in addition to any specified prefixes.
        Leave this field blank to advertise no custom groups.
        """
        return pulumi.get(self, "advertised_groups")

    @advertised_groups.setter
    def advertised_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "advertised_groups", value)

    @property
    @pulumi.getter(name="advertisedIpRanges")
    def advertised_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]]]:
        """
        User-specified list of individual IP ranges to advertise in
        custom mode. This field can only be populated if advertiseMode
        is `CUSTOM` and is advertised to all peers of the router. These IP
        ranges will be advertised in addition to any specified groups.
        Leave this field blank to advertise no custom IP ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "advertised_ip_ranges")

    @advertised_ip_ranges.setter
    def advertised_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]]]):
        pulumi.set(self, "advertised_ip_ranges", value)

    @property
    @pulumi.getter(name="advertisedRoutePriority")
    def advertised_route_priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The priority of routes advertised to this BGP peer.
        Where there is more than one matching route of maximum
        length, the routes with the lowest priority value win.
        """
        return pulumi.get(self, "advertised_route_priority")

    @advertised_route_priority.setter
    def advertised_route_priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "advertised_route_priority", value)

    @property
    @pulumi.getter
    def bfd(self) -> Optional[pulumi.Input['RouterPeerBfdArgs']]:
        """
        BFD configuration for the BGP peering.
        Structure is documented below.
        """
        return pulumi.get(self, "bfd")

    @bfd.setter
    def bfd(self, value: Optional[pulumi.Input['RouterPeerBfdArgs']]):
        pulumi.set(self, "bfd", value)

    @property
    @pulumi.getter(name="customLearnedIpRanges")
    def custom_learned_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerCustomLearnedIpRangeArgs']]]]:
        """
        The custom learned route IP address range. Must be a valid CIDR-formatted prefix.
        If an IP address is provided without a subnet mask, it is interpreted as, for IPv4,
        a /32 singular IP address range, and, for IPv6, /128.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_learned_ip_ranges")

    @custom_learned_ip_ranges.setter
    def custom_learned_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerCustomLearnedIpRangeArgs']]]]):
        pulumi.set(self, "custom_learned_ip_ranges", value)

    @property
    @pulumi.getter(name="customLearnedRoutePriority")
    def custom_learned_route_priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The user-defined custom learned route priority for a BGP session.
        This value is applied to all custom learned route ranges for the session.
        You can choose a value from 0 to 65335. If you don't provide a value,
        Google Cloud assigns a priority of 100 to the ranges.
        """
        return pulumi.get(self, "custom_learned_route_priority")

    @custom_learned_route_priority.setter
    def custom_learned_route_priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "custom_learned_route_priority", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The status of the BGP peer connection. If set to false, any active session
        with the peer is terminated and all associated routing information is removed.
        If set to true, the peer connection can be established with routing information.
        The default is true.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="enableIpv4")
    def enable_ipv4(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
        """
        return pulumi.get(self, "enable_ipv4")

    @enable_ipv4.setter
    def enable_ipv4(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_ipv4", value)

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable IPv6 traffic over BGP Peer. If not specified, it is disabled by default.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @property
    @pulumi.getter(name="exportPolicies")
    def export_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        routers.list of export policies applied to this peer, in the order they must be evaluated.
        The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
        """
        return pulumi.get(self, "export_policies")

    @export_policies.setter
    def export_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "export_policies", value)

    @property
    @pulumi.getter(name="importPolicies")
    def import_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        routers.list of import policies applied to this peer, in the order they must be evaluated.
        The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
        """
        return pulumi.get(self, "import_policies")

    @import_policies.setter
    def import_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "import_policies", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the interface the BGP peer is associated with.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address of the interface inside Google Cloud Platform.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipv4NexthopAddress")
    def ipv4_nexthop_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv4 address of the interface inside Google Cloud Platform.
        """
        return pulumi.get(self, "ipv4_nexthop_address")

    @ipv4_nexthop_address.setter
    def ipv4_nexthop_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_nexthop_address", value)

    @property
    @pulumi.getter(name="ipv6NexthopAddress")
    def ipv6_nexthop_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv6 address of the interface inside Google Cloud Platform.
        The address must be in the range 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64.
        If you do not specify the next hop addresses, Google Cloud automatically
        assigns unused addresses from the 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64 range for you.
        """
        return pulumi.get(self, "ipv6_nexthop_address")

    @ipv6_nexthop_address.setter
    def ipv6_nexthop_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv6_nexthop_address", value)

    @property
    @pulumi.getter(name="isAdvertisedRoutePrioritySet")
    def is_advertised_route_priority_set(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        An internal boolean field for provider use for zero_advertised_route_priority.
        """
        return pulumi.get(self, "is_advertised_route_priority_set")

    @is_advertised_route_priority_set.setter
    def is_advertised_route_priority_set(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_advertised_route_priority_set", value)

    @property
    @pulumi.getter(name="isCustomLearnedPrioritySet")
    def is_custom_learned_priority_set(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        An internal boolean field for provider use.
        """
        return pulumi.get(self, "is_custom_learned_priority_set")

    @is_custom_learned_priority_set.setter
    def is_custom_learned_priority_set(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_custom_learned_priority_set", value)

    @property
    @pulumi.getter(name="managementType")
    def management_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource that configures and manages this BGP peer.
        * `MANAGED_BY_USER` is the default value and can be managed by
        you or other users
        * `MANAGED_BY_ATTACHMENT` is a BGP peer that is configured and
        managed by Cloud Interconnect, specifically by an
        InterconnectAttachment of type PARTNER. Google automatically
        creates, updates, and deletes this type of BGP peer when the
        PARTNER InterconnectAttachment is created, updated,
        or deleted.
        """
        return pulumi.get(self, "management_type")

    @management_type.setter
    def management_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "management_type", value)

    @property
    @pulumi.getter(name="md5AuthenticationKey")
    def md5_authentication_key(self) -> Optional[pulumi.Input['RouterPeerMd5AuthenticationKeyArgs']]:
        """
        Configuration for MD5 authentication on the BGP session.
        Structure is documented below.
        """
        return pulumi.get(self, "md5_authentication_key")

    @md5_authentication_key.setter
    def md5_authentication_key(self, value: Optional[pulumi.Input['RouterPeerMd5AuthenticationKeyArgs']]):
        pulumi.set(self, "md5_authentication_key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of this BGP peer. The name must be 1-63 characters long,
        and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which
        means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Peer BGP Autonomous System Number (ASN).
        Each BGP interface may use a different value.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "peer_asn", value)

    @property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address of the BGP interface outside Google Cloud Platform.
        Only IPv4 is supported. Required if `ip_address` is set.
        """
        return pulumi.get(self, "peer_ip_address")

    @peer_ip_address.setter
    def peer_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_ip_address", value)

    @property
    @pulumi.getter(name="peerIpv4NexthopAddress")
    def peer_ipv4_nexthop_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv4 address of the BGP interface outside Google Cloud Platform.
        """
        return pulumi.get(self, "peer_ipv4_nexthop_address")

    @peer_ipv4_nexthop_address.setter
    def peer_ipv4_nexthop_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_ipv4_nexthop_address", value)

    @property
    @pulumi.getter(name="peerIpv6NexthopAddress")
    def peer_ipv6_nexthop_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv6 address of the BGP interface outside Google Cloud Platform.
        The address must be in the range 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64.
        If you do not specify the next hop addresses, Google Cloud automatically
        assigns unused addresses from the 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64 range for you.
        """
        return pulumi.get(self, "peer_ipv6_nexthop_address")

    @peer_ipv6_nexthop_address.setter
    def peer_ipv6_nexthop_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_ipv6_nexthop_address", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where the router and BgpPeer reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Cloud Router in which this BgpPeer will be configured.


        - - -
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter(name="routerApplianceInstance")
    def router_appliance_instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the VM instance that is used as third-party router appliances
        such as Next Gen Firewalls, Virtual Routers, or Router Appliances.
        The VM instance must be located in zones contained in the same region as
        this Cloud Router. The VM instance is the peer side of the BGP session.
        """
        return pulumi.get(self, "router_appliance_instance")

    @router_appliance_instance.setter
    def router_appliance_instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "router_appliance_instance", value)

    @property
    @pulumi.getter(name="zeroAdvertisedRoutePriority")
    def zero_advertised_route_priority(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The user-defined zero-advertised-route-priority for a advertised-route-priority in BGP session.
        This value has to be set true to force the advertised_route_priority to be 0.
        """
        return pulumi.get(self, "zero_advertised_route_priority")

    @zero_advertised_route_priority.setter
    def zero_advertised_route_priority(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "zero_advertised_route_priority", value)

    @property
    @pulumi.getter(name="zeroCustomLearnedRoutePriority")
    def zero_custom_learned_route_priority(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The user-defined zero-custom-learned-route-priority for a custom-learned-route-priority in BGP session.
        This value has to be set true to force the custom_learned_route_priority to be 0.
        """
        return pulumi.get(self, "zero_custom_learned_route_priority")

    @zero_custom_learned_route_priority.setter
    def zero_custom_learned_route_priority(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "zero_custom_learned_route_priority", value)


@pulumi.type_token("gcp:compute/routerPeer:RouterPeer")
class RouterPeer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advertise_mode: Optional[pulumi.Input[builtins.str]] = None,
                 advertised_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 advertised_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterPeerAdvertisedIpRangeArgs', 'RouterPeerAdvertisedIpRangeArgsDict']]]]] = None,
                 advertised_route_priority: Optional[pulumi.Input[builtins.int]] = None,
                 bfd: Optional[pulumi.Input[Union['RouterPeerBfdArgs', 'RouterPeerBfdArgsDict']]] = None,
                 custom_learned_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterPeerCustomLearnedIpRangeArgs', 'RouterPeerCustomLearnedIpRangeArgsDict']]]]] = None,
                 custom_learned_route_priority: Optional[pulumi.Input[builtins.int]] = None,
                 enable: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_ipv4: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 export_policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 import_policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 interface: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 md5_authentication_key: Optional[pulumi.Input[Union['RouterPeerMd5AuthenticationKeyArgs', 'RouterPeerMd5AuthenticationKeyArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peer_asn: Optional[pulumi.Input[builtins.int]] = None,
                 peer_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 peer_ipv4_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 peer_ipv6_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 router: Optional[pulumi.Input[builtins.str]] = None,
                 router_appliance_instance: Optional[pulumi.Input[builtins.str]] = None,
                 zero_advertised_route_priority: Optional[pulumi.Input[builtins.bool]] = None,
                 zero_custom_learned_route_priority: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        BGP information that must be configured into the routing stack to
        establish BGP peering. This information must specify the peer ASN
        and either the interface name, IP address, or peer IP address.
        Please refer to RFC4273.

        To get more information about RouterBgpPeer, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/routers)
        * How-to Guides
            * [Google Cloud Router](https://cloud.google.com/router/docs/)

        ## Example Usage

        ### Router Peer Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            name="my-router-peer",
            router="my-router",
            region="us-central1",
            peer_asn=65513,
            advertised_route_priority=100,
            interface="interface-1")
        ```
        ### Router Peer Disabled

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            name="my-router-peer",
            router="my-router",
            region="us-central1",
            peer_ip_address="169.254.1.2",
            peer_asn=65513,
            advertised_route_priority=100,
            interface="interface-1",
            enable=False)
        ```
        ### Router Peer Bfd

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            name="my-router-peer",
            router="my-router",
            region="us-central1",
            peer_ip_address="169.254.1.2",
            peer_asn=65513,
            advertised_route_priority=100,
            interface="interface-1",
            bfd={
                "min_receive_interval": 1000,
                "min_transmit_interval": 1000,
                "multiplier": 5,
                "session_initialization_mode": "ACTIVE",
            })
        ```
        ### Router Zero Custom Learend Route Priority

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            name="my-router-peer",
            router="my-router",
            region="us-central1",
            interface="interface-1",
            peer_asn=65513,
            custom_learned_route_priority=0,
            zero_custom_learned_route_priority=True)
        ```
        ### Router Zero Advertised Route Priority

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            name="my-router-peer",
            router="my-router",
            region="us-central1",
            interface="interface-1",
            peer_asn=65513,
            advertised_route_priority=0,
            zero_advertised_route_priority=True)
        ```
        ### Router Peer Router Appliance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="my-router-net",
            auto_create_subnetworks=False)
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            name="my-router-sub",
            network=network.self_link,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        addr_intf = gcp.compute.Address("addr_intf",
            name="my-router-addr-intf",
            region=subnetwork.region,
            subnetwork=subnetwork.id,
            address_type="INTERNAL")
        addr_intf_redundant = gcp.compute.Address("addr_intf_redundant",
            name="my-router-addr-intf-red",
            region=subnetwork.region,
            subnetwork=subnetwork.id,
            address_type="INTERNAL")
        addr_peer = gcp.compute.Address("addr_peer",
            name="my-router-addr-peer",
            region=subnetwork.region,
            subnetwork=subnetwork.id,
            address_type="INTERNAL")
        instance = gcp.compute.Instance("instance",
            name="router-appliance",
            zone="us-central1-a",
            machine_type="e2-medium",
            can_ip_forward=True,
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-11",
                },
            },
            network_interfaces=[{
                "network_ip": addr_peer.address,
                "subnetwork": subnetwork.self_link,
            }])
        hub = gcp.networkconnectivity.Hub("hub", name="my-router-hub")
        spoke = gcp.networkconnectivity.Spoke("spoke",
            name="my-router-spoke",
            location=subnetwork.region,
            hub=hub.id,
            linked_router_appliance_instances={
                "instances": [{
                    "virtual_machine": instance.self_link,
                    "ip_address": addr_peer.address,
                }],
                "site_to_site_data_transfer": False,
            })
        router = gcp.compute.Router("router",
            name="my-router-router",
            region=subnetwork.region,
            network=network.self_link,
            bgp={
                "asn": 64514,
            })
        interface_redundant = gcp.compute.RouterInterface("interface_redundant",
            name="my-router-intf-red",
            region=router.region,
            router=router.name,
            subnetwork=subnetwork.self_link,
            private_ip_address=addr_intf_redundant.address)
        interface = gcp.compute.RouterInterface("interface",
            name="my-router-intf",
            region=router.region,
            router=router.name,
            subnetwork=subnetwork.self_link,
            private_ip_address=addr_intf.address,
            redundant_interface=interface_redundant.name)
        peer = gcp.compute.RouterPeer("peer",
            name="my-router-peer",
            router=router.name,
            region=router.region,
            interface=interface.name,
            router_appliance_instance=instance.self_link,
            peer_asn=65513,
            peer_ip_address=addr_peer.address)
        ```

        ### Router Peer Md5 Authentication Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foobar = gcp.compute.RouterPeer("foobar",
            name="%s-peer",
            router=foobar_google_compute_router["name"],
            region=foobar_google_compute_router["region"],
            peer_asn=65515,
            advertised_route_priority=100,
            interface=foobar_google_compute_router_interface["name"],
            peer_ip_address="169.254.3.2",
            md5_authentication_key={
                "name": "%s-peer-key",
                "key": "%s-peer-key-value",
            })
        ```

        ### Router Peer Export And Import Policies

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="my-router-net",
            auto_create_subnetworks=False)
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            name="my-router-subnet",
            network=network.self_link,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        address = gcp.compute.Address("address",
            name="my-router",
            region=subnetwork.region)
        vpn_gateway = gcp.compute.HaVpnGateway("vpn_gateway",
            name="my-router-gateway",
            network=network.self_link,
            region=subnetwork.region)
        external_gateway = gcp.compute.ExternalVpnGateway("external_gateway",
            name="my-router-external-gateway",
            redundancy_type="SINGLE_IP_INTERNALLY_REDUNDANT",
            description="An externally managed VPN gateway",
            interfaces=[{
                "id": 0,
                "ip_address": "8.8.8.8",
            }])
        router = gcp.compute.Router("router",
            name="my-router",
            region=subnetwork.region,
            network=network.self_link,
            bgp={
                "asn": 64514,
            })
        vpn_tunnel = gcp.compute.VPNTunnel("vpn_tunnel",
            name="my-router",
            region=subnetwork.region,
            vpn_gateway=vpn_gateway.id,
            peer_external_gateway=external_gateway.id,
            peer_external_gateway_interface=0,
            shared_secret="unguessable",
            router=router.name,
            vpn_gateway_interface=0)
        router_interface = gcp.compute.RouterInterface("router_interface",
            name="my-router",
            router=router.name,
            region=router.region,
            vpn_tunnel=vpn_tunnel.name)
        rp_export = gcp.compute.RouterRoutePolicy("rp-export",
            name="my-router-rp-export",
            router=router.name,
            region=router.region,
            type="ROUTE_POLICY_TYPE_EXPORT",
            terms=[{
                "priority": 2,
                "match": {
                    "expression": "destination == '10.0.0.0/12'",
                    "title": "export_expression",
                    "description": "acceptance expression for export",
                },
                "actions": [{
                    "expression": "accept()",
                }],
            }],
            opts = pulumi.ResourceOptions(depends_on=[router_interface]))
        rp_import = gcp.compute.RouterRoutePolicy("rp-import",
            name="my-router-rp-import",
            router=router.name,
            region=router.region,
            type="ROUTE_POLICY_TYPE_IMPORT",
            terms=[{
                "priority": 1,
                "match": {
                    "expression": "destination == '10.0.0.0/12'",
                    "title": "import_expression",
                    "description": "acceptance expression for import",
                },
                "actions": [{
                    "expression": "accept()",
                }],
            }],
            opts = pulumi.ResourceOptions(depends_on=[
                    router_interface,
                    rp_export,
                ]))
        router_peer = gcp.compute.RouterPeer("router_peer",
            name="my-router-peer",
            router=router.name,
            region=router.region,
            peer_asn=65515,
            advertised_route_priority=100,
            interface=router_interface.name,
            md5_authentication_key={
                "name": "my-router-peer-key",
                "key": "my-router-peer-key-value",
            },
            import_policies=[rp_import.name],
            export_policies=[rp_export.name],
            opts = pulumi.ResourceOptions(depends_on=[
                    rp_export,
                    rp_import,
                    router_interface,
                ]))
        ```

        ## Import

        RouterBgpPeer can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/routers/{{router}}/{{name}}`

        * `{{project}}/{{region}}/{{router}}/{{name}}`

        * `{{region}}/{{router}}/{{name}}`

        * `{{router}}/{{name}}`

        When using the `pulumi import` command, RouterBgpPeer can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/routerPeer:RouterPeer default projects/{{project}}/regions/{{region}}/routers/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerPeer:RouterPeer default {{project}}/{{region}}/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerPeer:RouterPeer default {{region}}/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerPeer:RouterPeer default {{router}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] advertise_mode: User-specified flag to indicate which mode to use for advertisement.
               Valid values of this enum field are: `DEFAULT`, `CUSTOM`
               Default value is `DEFAULT`.
               Possible values are: `DEFAULT`, `CUSTOM`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] advertised_groups: User-specified list of prefix groups to advertise in custom
               mode, which currently supports the following option:
               * `ALL_SUBNETS`: Advertises all of the router's own VPC subnets.
               This excludes any routes learned for subnets that use VPC Network
               Peering.
               
               Note that this field can only be populated if advertiseMode is `CUSTOM`
               and overrides the list defined for the router (in the "bgp" message).
               These groups are advertised in addition to any specified prefixes.
               Leave this field blank to advertise no custom groups.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterPeerAdvertisedIpRangeArgs', 'RouterPeerAdvertisedIpRangeArgsDict']]]] advertised_ip_ranges: User-specified list of individual IP ranges to advertise in
               custom mode. This field can only be populated if advertiseMode
               is `CUSTOM` and is advertised to all peers of the router. These IP
               ranges will be advertised in addition to any specified groups.
               Leave this field blank to advertise no custom IP ranges.
               Structure is documented below.
        :param pulumi.Input[builtins.int] advertised_route_priority: The priority of routes advertised to this BGP peer.
               Where there is more than one matching route of maximum
               length, the routes with the lowest priority value win.
        :param pulumi.Input[Union['RouterPeerBfdArgs', 'RouterPeerBfdArgsDict']] bfd: BFD configuration for the BGP peering.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterPeerCustomLearnedIpRangeArgs', 'RouterPeerCustomLearnedIpRangeArgsDict']]]] custom_learned_ip_ranges: The custom learned route IP address range. Must be a valid CIDR-formatted prefix.
               If an IP address is provided without a subnet mask, it is interpreted as, for IPv4,
               a /32 singular IP address range, and, for IPv6, /128.
               Structure is documented below.
        :param pulumi.Input[builtins.int] custom_learned_route_priority: The user-defined custom learned route priority for a BGP session.
               This value is applied to all custom learned route ranges for the session.
               You can choose a value from 0 to 65335. If you don't provide a value,
               Google Cloud assigns a priority of 100 to the ranges.
        :param pulumi.Input[builtins.bool] enable: The status of the BGP peer connection. If set to false, any active session
               with the peer is terminated and all associated routing information is removed.
               If set to true, the peer connection can be established with routing information.
               The default is true.
        :param pulumi.Input[builtins.bool] enable_ipv4: Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
        :param pulumi.Input[builtins.bool] enable_ipv6: Enable IPv6 traffic over BGP Peer. If not specified, it is disabled by default.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] export_policies: routers.list of export policies applied to this peer, in the order they must be evaluated.
               The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] import_policies: routers.list of import policies applied to this peer, in the order they must be evaluated.
               The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
        :param pulumi.Input[builtins.str] interface: Name of the interface the BGP peer is associated with.
        :param pulumi.Input[builtins.str] ip_address: IP address of the interface inside Google Cloud Platform.
               Only IPv4 is supported.
        :param pulumi.Input[builtins.str] ipv4_nexthop_address: IPv4 address of the interface inside Google Cloud Platform.
        :param pulumi.Input[builtins.str] ipv6_nexthop_address: IPv6 address of the interface inside Google Cloud Platform.
               The address must be in the range 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64.
               If you do not specify the next hop addresses, Google Cloud automatically
               assigns unused addresses from the 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64 range for you.
        :param pulumi.Input[Union['RouterPeerMd5AuthenticationKeyArgs', 'RouterPeerMd5AuthenticationKeyArgsDict']] md5_authentication_key: Configuration for MD5 authentication on the BGP session.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name of this BGP peer. The name must be 1-63 characters long,
               and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[builtins.int] peer_asn: Peer BGP Autonomous System Number (ASN).
               Each BGP interface may use a different value.
        :param pulumi.Input[builtins.str] peer_ip_address: IP address of the BGP interface outside Google Cloud Platform.
               Only IPv4 is supported. Required if `ip_address` is set.
        :param pulumi.Input[builtins.str] peer_ipv4_nexthop_address: IPv4 address of the BGP interface outside Google Cloud Platform.
        :param pulumi.Input[builtins.str] peer_ipv6_nexthop_address: IPv6 address of the BGP interface outside Google Cloud Platform.
               The address must be in the range 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64.
               If you do not specify the next hop addresses, Google Cloud automatically
               assigns unused addresses from the 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64 range for you.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: Region where the router and BgpPeer reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[builtins.str] router: The name of the Cloud Router in which this BgpPeer will be configured.
               
               
               - - -
        :param pulumi.Input[builtins.str] router_appliance_instance: The URI of the VM instance that is used as third-party router appliances
               such as Next Gen Firewalls, Virtual Routers, or Router Appliances.
               The VM instance must be located in zones contained in the same region as
               this Cloud Router. The VM instance is the peer side of the BGP session.
        :param pulumi.Input[builtins.bool] zero_advertised_route_priority: The user-defined zero-advertised-route-priority for a advertised-route-priority in BGP session.
               This value has to be set true to force the advertised_route_priority to be 0.
        :param pulumi.Input[builtins.bool] zero_custom_learned_route_priority: The user-defined zero-custom-learned-route-priority for a custom-learned-route-priority in BGP session.
               This value has to be set true to force the custom_learned_route_priority to be 0.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterPeerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        BGP information that must be configured into the routing stack to
        establish BGP peering. This information must specify the peer ASN
        and either the interface name, IP address, or peer IP address.
        Please refer to RFC4273.

        To get more information about RouterBgpPeer, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/routers)
        * How-to Guides
            * [Google Cloud Router](https://cloud.google.com/router/docs/)

        ## Example Usage

        ### Router Peer Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            name="my-router-peer",
            router="my-router",
            region="us-central1",
            peer_asn=65513,
            advertised_route_priority=100,
            interface="interface-1")
        ```
        ### Router Peer Disabled

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            name="my-router-peer",
            router="my-router",
            region="us-central1",
            peer_ip_address="169.254.1.2",
            peer_asn=65513,
            advertised_route_priority=100,
            interface="interface-1",
            enable=False)
        ```
        ### Router Peer Bfd

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            name="my-router-peer",
            router="my-router",
            region="us-central1",
            peer_ip_address="169.254.1.2",
            peer_asn=65513,
            advertised_route_priority=100,
            interface="interface-1",
            bfd={
                "min_receive_interval": 1000,
                "min_transmit_interval": 1000,
                "multiplier": 5,
                "session_initialization_mode": "ACTIVE",
            })
        ```
        ### Router Zero Custom Learend Route Priority

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            name="my-router-peer",
            router="my-router",
            region="us-central1",
            interface="interface-1",
            peer_asn=65513,
            custom_learned_route_priority=0,
            zero_custom_learned_route_priority=True)
        ```
        ### Router Zero Advertised Route Priority

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            name="my-router-peer",
            router="my-router",
            region="us-central1",
            interface="interface-1",
            peer_asn=65513,
            advertised_route_priority=0,
            zero_advertised_route_priority=True)
        ```
        ### Router Peer Router Appliance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="my-router-net",
            auto_create_subnetworks=False)
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            name="my-router-sub",
            network=network.self_link,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        addr_intf = gcp.compute.Address("addr_intf",
            name="my-router-addr-intf",
            region=subnetwork.region,
            subnetwork=subnetwork.id,
            address_type="INTERNAL")
        addr_intf_redundant = gcp.compute.Address("addr_intf_redundant",
            name="my-router-addr-intf-red",
            region=subnetwork.region,
            subnetwork=subnetwork.id,
            address_type="INTERNAL")
        addr_peer = gcp.compute.Address("addr_peer",
            name="my-router-addr-peer",
            region=subnetwork.region,
            subnetwork=subnetwork.id,
            address_type="INTERNAL")
        instance = gcp.compute.Instance("instance",
            name="router-appliance",
            zone="us-central1-a",
            machine_type="e2-medium",
            can_ip_forward=True,
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-11",
                },
            },
            network_interfaces=[{
                "network_ip": addr_peer.address,
                "subnetwork": subnetwork.self_link,
            }])
        hub = gcp.networkconnectivity.Hub("hub", name="my-router-hub")
        spoke = gcp.networkconnectivity.Spoke("spoke",
            name="my-router-spoke",
            location=subnetwork.region,
            hub=hub.id,
            linked_router_appliance_instances={
                "instances": [{
                    "virtual_machine": instance.self_link,
                    "ip_address": addr_peer.address,
                }],
                "site_to_site_data_transfer": False,
            })
        router = gcp.compute.Router("router",
            name="my-router-router",
            region=subnetwork.region,
            network=network.self_link,
            bgp={
                "asn": 64514,
            })
        interface_redundant = gcp.compute.RouterInterface("interface_redundant",
            name="my-router-intf-red",
            region=router.region,
            router=router.name,
            subnetwork=subnetwork.self_link,
            private_ip_address=addr_intf_redundant.address)
        interface = gcp.compute.RouterInterface("interface",
            name="my-router-intf",
            region=router.region,
            router=router.name,
            subnetwork=subnetwork.self_link,
            private_ip_address=addr_intf.address,
            redundant_interface=interface_redundant.name)
        peer = gcp.compute.RouterPeer("peer",
            name="my-router-peer",
            router=router.name,
            region=router.region,
            interface=interface.name,
            router_appliance_instance=instance.self_link,
            peer_asn=65513,
            peer_ip_address=addr_peer.address)
        ```

        ### Router Peer Md5 Authentication Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foobar = gcp.compute.RouterPeer("foobar",
            name="%s-peer",
            router=foobar_google_compute_router["name"],
            region=foobar_google_compute_router["region"],
            peer_asn=65515,
            advertised_route_priority=100,
            interface=foobar_google_compute_router_interface["name"],
            peer_ip_address="169.254.3.2",
            md5_authentication_key={
                "name": "%s-peer-key",
                "key": "%s-peer-key-value",
            })
        ```

        ### Router Peer Export And Import Policies

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="my-router-net",
            auto_create_subnetworks=False)
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            name="my-router-subnet",
            network=network.self_link,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        address = gcp.compute.Address("address",
            name="my-router",
            region=subnetwork.region)
        vpn_gateway = gcp.compute.HaVpnGateway("vpn_gateway",
            name="my-router-gateway",
            network=network.self_link,
            region=subnetwork.region)
        external_gateway = gcp.compute.ExternalVpnGateway("external_gateway",
            name="my-router-external-gateway",
            redundancy_type="SINGLE_IP_INTERNALLY_REDUNDANT",
            description="An externally managed VPN gateway",
            interfaces=[{
                "id": 0,
                "ip_address": "8.8.8.8",
            }])
        router = gcp.compute.Router("router",
            name="my-router",
            region=subnetwork.region,
            network=network.self_link,
            bgp={
                "asn": 64514,
            })
        vpn_tunnel = gcp.compute.VPNTunnel("vpn_tunnel",
            name="my-router",
            region=subnetwork.region,
            vpn_gateway=vpn_gateway.id,
            peer_external_gateway=external_gateway.id,
            peer_external_gateway_interface=0,
            shared_secret="unguessable",
            router=router.name,
            vpn_gateway_interface=0)
        router_interface = gcp.compute.RouterInterface("router_interface",
            name="my-router",
            router=router.name,
            region=router.region,
            vpn_tunnel=vpn_tunnel.name)
        rp_export = gcp.compute.RouterRoutePolicy("rp-export",
            name="my-router-rp-export",
            router=router.name,
            region=router.region,
            type="ROUTE_POLICY_TYPE_EXPORT",
            terms=[{
                "priority": 2,
                "match": {
                    "expression": "destination == '10.0.0.0/12'",
                    "title": "export_expression",
                    "description": "acceptance expression for export",
                },
                "actions": [{
                    "expression": "accept()",
                }],
            }],
            opts = pulumi.ResourceOptions(depends_on=[router_interface]))
        rp_import = gcp.compute.RouterRoutePolicy("rp-import",
            name="my-router-rp-import",
            router=router.name,
            region=router.region,
            type="ROUTE_POLICY_TYPE_IMPORT",
            terms=[{
                "priority": 1,
                "match": {
                    "expression": "destination == '10.0.0.0/12'",
                    "title": "import_expression",
                    "description": "acceptance expression for import",
                },
                "actions": [{
                    "expression": "accept()",
                }],
            }],
            opts = pulumi.ResourceOptions(depends_on=[
                    router_interface,
                    rp_export,
                ]))
        router_peer = gcp.compute.RouterPeer("router_peer",
            name="my-router-peer",
            router=router.name,
            region=router.region,
            peer_asn=65515,
            advertised_route_priority=100,
            interface=router_interface.name,
            md5_authentication_key={
                "name": "my-router-peer-key",
                "key": "my-router-peer-key-value",
            },
            import_policies=[rp_import.name],
            export_policies=[rp_export.name],
            opts = pulumi.ResourceOptions(depends_on=[
                    rp_export,
                    rp_import,
                    router_interface,
                ]))
        ```

        ## Import

        RouterBgpPeer can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/routers/{{router}}/{{name}}`

        * `{{project}}/{{region}}/{{router}}/{{name}}`

        * `{{region}}/{{router}}/{{name}}`

        * `{{router}}/{{name}}`

        When using the `pulumi import` command, RouterBgpPeer can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/routerPeer:RouterPeer default projects/{{project}}/regions/{{region}}/routers/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerPeer:RouterPeer default {{project}}/{{region}}/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerPeer:RouterPeer default {{region}}/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerPeer:RouterPeer default {{router}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RouterPeerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterPeerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advertise_mode: Optional[pulumi.Input[builtins.str]] = None,
                 advertised_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 advertised_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterPeerAdvertisedIpRangeArgs', 'RouterPeerAdvertisedIpRangeArgsDict']]]]] = None,
                 advertised_route_priority: Optional[pulumi.Input[builtins.int]] = None,
                 bfd: Optional[pulumi.Input[Union['RouterPeerBfdArgs', 'RouterPeerBfdArgsDict']]] = None,
                 custom_learned_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterPeerCustomLearnedIpRangeArgs', 'RouterPeerCustomLearnedIpRangeArgsDict']]]]] = None,
                 custom_learned_route_priority: Optional[pulumi.Input[builtins.int]] = None,
                 enable: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_ipv4: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 export_policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 import_policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 interface: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 md5_authentication_key: Optional[pulumi.Input[Union['RouterPeerMd5AuthenticationKeyArgs', 'RouterPeerMd5AuthenticationKeyArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peer_asn: Optional[pulumi.Input[builtins.int]] = None,
                 peer_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 peer_ipv4_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 peer_ipv6_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 router: Optional[pulumi.Input[builtins.str]] = None,
                 router_appliance_instance: Optional[pulumi.Input[builtins.str]] = None,
                 zero_advertised_route_priority: Optional[pulumi.Input[builtins.bool]] = None,
                 zero_custom_learned_route_priority: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterPeerArgs.__new__(RouterPeerArgs)

            __props__.__dict__["advertise_mode"] = advertise_mode
            __props__.__dict__["advertised_groups"] = advertised_groups
            __props__.__dict__["advertised_ip_ranges"] = advertised_ip_ranges
            __props__.__dict__["advertised_route_priority"] = advertised_route_priority
            __props__.__dict__["bfd"] = bfd
            __props__.__dict__["custom_learned_ip_ranges"] = custom_learned_ip_ranges
            __props__.__dict__["custom_learned_route_priority"] = custom_learned_route_priority
            __props__.__dict__["enable"] = enable
            __props__.__dict__["enable_ipv4"] = enable_ipv4
            __props__.__dict__["enable_ipv6"] = enable_ipv6
            __props__.__dict__["export_policies"] = export_policies
            __props__.__dict__["import_policies"] = import_policies
            if interface is None and not opts.urn:
                raise TypeError("Missing required property 'interface'")
            __props__.__dict__["interface"] = interface
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["ipv4_nexthop_address"] = ipv4_nexthop_address
            __props__.__dict__["ipv6_nexthop_address"] = ipv6_nexthop_address
            __props__.__dict__["md5_authentication_key"] = md5_authentication_key
            __props__.__dict__["name"] = name
            if peer_asn is None and not opts.urn:
                raise TypeError("Missing required property 'peer_asn'")
            __props__.__dict__["peer_asn"] = peer_asn
            __props__.__dict__["peer_ip_address"] = peer_ip_address
            __props__.__dict__["peer_ipv4_nexthop_address"] = peer_ipv4_nexthop_address
            __props__.__dict__["peer_ipv6_nexthop_address"] = peer_ipv6_nexthop_address
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if router is None and not opts.urn:
                raise TypeError("Missing required property 'router'")
            __props__.__dict__["router"] = router
            __props__.__dict__["router_appliance_instance"] = router_appliance_instance
            __props__.__dict__["zero_advertised_route_priority"] = zero_advertised_route_priority
            __props__.__dict__["zero_custom_learned_route_priority"] = zero_custom_learned_route_priority
            __props__.__dict__["is_advertised_route_priority_set"] = None
            __props__.__dict__["is_custom_learned_priority_set"] = None
            __props__.__dict__["management_type"] = None
        super(RouterPeer, __self__).__init__(
            'gcp:compute/routerPeer:RouterPeer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advertise_mode: Optional[pulumi.Input[builtins.str]] = None,
            advertised_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            advertised_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterPeerAdvertisedIpRangeArgs', 'RouterPeerAdvertisedIpRangeArgsDict']]]]] = None,
            advertised_route_priority: Optional[pulumi.Input[builtins.int]] = None,
            bfd: Optional[pulumi.Input[Union['RouterPeerBfdArgs', 'RouterPeerBfdArgsDict']]] = None,
            custom_learned_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterPeerCustomLearnedIpRangeArgs', 'RouterPeerCustomLearnedIpRangeArgsDict']]]]] = None,
            custom_learned_route_priority: Optional[pulumi.Input[builtins.int]] = None,
            enable: Optional[pulumi.Input[builtins.bool]] = None,
            enable_ipv4: Optional[pulumi.Input[builtins.bool]] = None,
            enable_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
            export_policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            import_policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            interface: Optional[pulumi.Input[builtins.str]] = None,
            ip_address: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
            ipv6_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
            is_advertised_route_priority_set: Optional[pulumi.Input[builtins.bool]] = None,
            is_custom_learned_priority_set: Optional[pulumi.Input[builtins.bool]] = None,
            management_type: Optional[pulumi.Input[builtins.str]] = None,
            md5_authentication_key: Optional[pulumi.Input[Union['RouterPeerMd5AuthenticationKeyArgs', 'RouterPeerMd5AuthenticationKeyArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            peer_asn: Optional[pulumi.Input[builtins.int]] = None,
            peer_ip_address: Optional[pulumi.Input[builtins.str]] = None,
            peer_ipv4_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
            peer_ipv6_nexthop_address: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            router: Optional[pulumi.Input[builtins.str]] = None,
            router_appliance_instance: Optional[pulumi.Input[builtins.str]] = None,
            zero_advertised_route_priority: Optional[pulumi.Input[builtins.bool]] = None,
            zero_custom_learned_route_priority: Optional[pulumi.Input[builtins.bool]] = None) -> 'RouterPeer':
        """
        Get an existing RouterPeer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] advertise_mode: User-specified flag to indicate which mode to use for advertisement.
               Valid values of this enum field are: `DEFAULT`, `CUSTOM`
               Default value is `DEFAULT`.
               Possible values are: `DEFAULT`, `CUSTOM`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] advertised_groups: User-specified list of prefix groups to advertise in custom
               mode, which currently supports the following option:
               * `ALL_SUBNETS`: Advertises all of the router's own VPC subnets.
               This excludes any routes learned for subnets that use VPC Network
               Peering.
               
               Note that this field can only be populated if advertiseMode is `CUSTOM`
               and overrides the list defined for the router (in the "bgp" message).
               These groups are advertised in addition to any specified prefixes.
               Leave this field blank to advertise no custom groups.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterPeerAdvertisedIpRangeArgs', 'RouterPeerAdvertisedIpRangeArgsDict']]]] advertised_ip_ranges: User-specified list of individual IP ranges to advertise in
               custom mode. This field can only be populated if advertiseMode
               is `CUSTOM` and is advertised to all peers of the router. These IP
               ranges will be advertised in addition to any specified groups.
               Leave this field blank to advertise no custom IP ranges.
               Structure is documented below.
        :param pulumi.Input[builtins.int] advertised_route_priority: The priority of routes advertised to this BGP peer.
               Where there is more than one matching route of maximum
               length, the routes with the lowest priority value win.
        :param pulumi.Input[Union['RouterPeerBfdArgs', 'RouterPeerBfdArgsDict']] bfd: BFD configuration for the BGP peering.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterPeerCustomLearnedIpRangeArgs', 'RouterPeerCustomLearnedIpRangeArgsDict']]]] custom_learned_ip_ranges: The custom learned route IP address range. Must be a valid CIDR-formatted prefix.
               If an IP address is provided without a subnet mask, it is interpreted as, for IPv4,
               a /32 singular IP address range, and, for IPv6, /128.
               Structure is documented below.
        :param pulumi.Input[builtins.int] custom_learned_route_priority: The user-defined custom learned route priority for a BGP session.
               This value is applied to all custom learned route ranges for the session.
               You can choose a value from 0 to 65335. If you don't provide a value,
               Google Cloud assigns a priority of 100 to the ranges.
        :param pulumi.Input[builtins.bool] enable: The status of the BGP peer connection. If set to false, any active session
               with the peer is terminated and all associated routing information is removed.
               If set to true, the peer connection can be established with routing information.
               The default is true.
        :param pulumi.Input[builtins.bool] enable_ipv4: Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
        :param pulumi.Input[builtins.bool] enable_ipv6: Enable IPv6 traffic over BGP Peer. If not specified, it is disabled by default.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] export_policies: routers.list of export policies applied to this peer, in the order they must be evaluated.
               The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] import_policies: routers.list of import policies applied to this peer, in the order they must be evaluated.
               The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
        :param pulumi.Input[builtins.str] interface: Name of the interface the BGP peer is associated with.
        :param pulumi.Input[builtins.str] ip_address: IP address of the interface inside Google Cloud Platform.
               Only IPv4 is supported.
        :param pulumi.Input[builtins.str] ipv4_nexthop_address: IPv4 address of the interface inside Google Cloud Platform.
        :param pulumi.Input[builtins.str] ipv6_nexthop_address: IPv6 address of the interface inside Google Cloud Platform.
               The address must be in the range 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64.
               If you do not specify the next hop addresses, Google Cloud automatically
               assigns unused addresses from the 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64 range for you.
        :param pulumi.Input[builtins.bool] is_advertised_route_priority_set: An internal boolean field for provider use for zero_advertised_route_priority.
        :param pulumi.Input[builtins.bool] is_custom_learned_priority_set: An internal boolean field for provider use.
        :param pulumi.Input[builtins.str] management_type: The resource that configures and manages this BGP peer.
               * `MANAGED_BY_USER` is the default value and can be managed by
               you or other users
               * `MANAGED_BY_ATTACHMENT` is a BGP peer that is configured and
               managed by Cloud Interconnect, specifically by an
               InterconnectAttachment of type PARTNER. Google automatically
               creates, updates, and deletes this type of BGP peer when the
               PARTNER InterconnectAttachment is created, updated,
               or deleted.
        :param pulumi.Input[Union['RouterPeerMd5AuthenticationKeyArgs', 'RouterPeerMd5AuthenticationKeyArgsDict']] md5_authentication_key: Configuration for MD5 authentication on the BGP session.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name of this BGP peer. The name must be 1-63 characters long,
               and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[builtins.int] peer_asn: Peer BGP Autonomous System Number (ASN).
               Each BGP interface may use a different value.
        :param pulumi.Input[builtins.str] peer_ip_address: IP address of the BGP interface outside Google Cloud Platform.
               Only IPv4 is supported. Required if `ip_address` is set.
        :param pulumi.Input[builtins.str] peer_ipv4_nexthop_address: IPv4 address of the BGP interface outside Google Cloud Platform.
        :param pulumi.Input[builtins.str] peer_ipv6_nexthop_address: IPv6 address of the BGP interface outside Google Cloud Platform.
               The address must be in the range 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64.
               If you do not specify the next hop addresses, Google Cloud automatically
               assigns unused addresses from the 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64 range for you.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: Region where the router and BgpPeer reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[builtins.str] router: The name of the Cloud Router in which this BgpPeer will be configured.
               
               
               - - -
        :param pulumi.Input[builtins.str] router_appliance_instance: The URI of the VM instance that is used as third-party router appliances
               such as Next Gen Firewalls, Virtual Routers, or Router Appliances.
               The VM instance must be located in zones contained in the same region as
               this Cloud Router. The VM instance is the peer side of the BGP session.
        :param pulumi.Input[builtins.bool] zero_advertised_route_priority: The user-defined zero-advertised-route-priority for a advertised-route-priority in BGP session.
               This value has to be set true to force the advertised_route_priority to be 0.
        :param pulumi.Input[builtins.bool] zero_custom_learned_route_priority: The user-defined zero-custom-learned-route-priority for a custom-learned-route-priority in BGP session.
               This value has to be set true to force the custom_learned_route_priority to be 0.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterPeerState.__new__(_RouterPeerState)

        __props__.__dict__["advertise_mode"] = advertise_mode
        __props__.__dict__["advertised_groups"] = advertised_groups
        __props__.__dict__["advertised_ip_ranges"] = advertised_ip_ranges
        __props__.__dict__["advertised_route_priority"] = advertised_route_priority
        __props__.__dict__["bfd"] = bfd
        __props__.__dict__["custom_learned_ip_ranges"] = custom_learned_ip_ranges
        __props__.__dict__["custom_learned_route_priority"] = custom_learned_route_priority
        __props__.__dict__["enable"] = enable
        __props__.__dict__["enable_ipv4"] = enable_ipv4
        __props__.__dict__["enable_ipv6"] = enable_ipv6
        __props__.__dict__["export_policies"] = export_policies
        __props__.__dict__["import_policies"] = import_policies
        __props__.__dict__["interface"] = interface
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ipv4_nexthop_address"] = ipv4_nexthop_address
        __props__.__dict__["ipv6_nexthop_address"] = ipv6_nexthop_address
        __props__.__dict__["is_advertised_route_priority_set"] = is_advertised_route_priority_set
        __props__.__dict__["is_custom_learned_priority_set"] = is_custom_learned_priority_set
        __props__.__dict__["management_type"] = management_type
        __props__.__dict__["md5_authentication_key"] = md5_authentication_key
        __props__.__dict__["name"] = name
        __props__.__dict__["peer_asn"] = peer_asn
        __props__.__dict__["peer_ip_address"] = peer_ip_address
        __props__.__dict__["peer_ipv4_nexthop_address"] = peer_ipv4_nexthop_address
        __props__.__dict__["peer_ipv6_nexthop_address"] = peer_ipv6_nexthop_address
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["router"] = router
        __props__.__dict__["router_appliance_instance"] = router_appliance_instance
        __props__.__dict__["zero_advertised_route_priority"] = zero_advertised_route_priority
        __props__.__dict__["zero_custom_learned_route_priority"] = zero_custom_learned_route_priority
        return RouterPeer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advertiseMode")
    def advertise_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-specified flag to indicate which mode to use for advertisement.
        Valid values of this enum field are: `DEFAULT`, `CUSTOM`
        Default value is `DEFAULT`.
        Possible values are: `DEFAULT`, `CUSTOM`.
        """
        return pulumi.get(self, "advertise_mode")

    @property
    @pulumi.getter(name="advertisedGroups")
    def advertised_groups(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        User-specified list of prefix groups to advertise in custom
        mode, which currently supports the following option:
        * `ALL_SUBNETS`: Advertises all of the router's own VPC subnets.
        This excludes any routes learned for subnets that use VPC Network
        Peering.

        Note that this field can only be populated if advertiseMode is `CUSTOM`
        and overrides the list defined for the router (in the "bgp" message).
        These groups are advertised in addition to any specified prefixes.
        Leave this field blank to advertise no custom groups.
        """
        return pulumi.get(self, "advertised_groups")

    @property
    @pulumi.getter(name="advertisedIpRanges")
    def advertised_ip_ranges(self) -> pulumi.Output[Optional[Sequence['outputs.RouterPeerAdvertisedIpRange']]]:
        """
        User-specified list of individual IP ranges to advertise in
        custom mode. This field can only be populated if advertiseMode
        is `CUSTOM` and is advertised to all peers of the router. These IP
        ranges will be advertised in addition to any specified groups.
        Leave this field blank to advertise no custom IP ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "advertised_ip_ranges")

    @property
    @pulumi.getter(name="advertisedRoutePriority")
    def advertised_route_priority(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The priority of routes advertised to this BGP peer.
        Where there is more than one matching route of maximum
        length, the routes with the lowest priority value win.
        """
        return pulumi.get(self, "advertised_route_priority")

    @property
    @pulumi.getter
    def bfd(self) -> pulumi.Output['outputs.RouterPeerBfd']:
        """
        BFD configuration for the BGP peering.
        Structure is documented below.
        """
        return pulumi.get(self, "bfd")

    @property
    @pulumi.getter(name="customLearnedIpRanges")
    def custom_learned_ip_ranges(self) -> pulumi.Output[Optional[Sequence['outputs.RouterPeerCustomLearnedIpRange']]]:
        """
        The custom learned route IP address range. Must be a valid CIDR-formatted prefix.
        If an IP address is provided without a subnet mask, it is interpreted as, for IPv4,
        a /32 singular IP address range, and, for IPv6, /128.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_learned_ip_ranges")

    @property
    @pulumi.getter(name="customLearnedRoutePriority")
    def custom_learned_route_priority(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The user-defined custom learned route priority for a BGP session.
        This value is applied to all custom learned route ranges for the session.
        You can choose a value from 0 to 65335. If you don't provide a value,
        Google Cloud assigns a priority of 100 to the ranges.
        """
        return pulumi.get(self, "custom_learned_route_priority")

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The status of the BGP peer connection. If set to false, any active session
        with the peer is terminated and all associated routing information is removed.
        If set to true, the peer connection can be established with routing information.
        The default is true.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="enableIpv4")
    def enable_ipv4(self) -> pulumi.Output[builtins.bool]:
        """
        Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
        """
        return pulumi.get(self, "enable_ipv4")

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable IPv6 traffic over BGP Peer. If not specified, it is disabled by default.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter(name="exportPolicies")
    def export_policies(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        routers.list of export policies applied to this peer, in the order they must be evaluated.
        The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
        """
        return pulumi.get(self, "export_policies")

    @property
    @pulumi.getter(name="importPolicies")
    def import_policies(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        routers.list of import policies applied to this peer, in the order they must be evaluated.
        The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
        """
        return pulumi.get(self, "import_policies")

    @property
    @pulumi.getter
    def interface(self) -> pulumi.Output[builtins.str]:
        """
        Name of the interface the BGP peer is associated with.
        """
        return pulumi.get(self, "interface")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[builtins.str]:
        """
        IP address of the interface inside Google Cloud Platform.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipv4NexthopAddress")
    def ipv4_nexthop_address(self) -> pulumi.Output[builtins.str]:
        """
        IPv4 address of the interface inside Google Cloud Platform.
        """
        return pulumi.get(self, "ipv4_nexthop_address")

    @property
    @pulumi.getter(name="ipv6NexthopAddress")
    def ipv6_nexthop_address(self) -> pulumi.Output[builtins.str]:
        """
        IPv6 address of the interface inside Google Cloud Platform.
        The address must be in the range 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64.
        If you do not specify the next hop addresses, Google Cloud automatically
        assigns unused addresses from the 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64 range for you.
        """
        return pulumi.get(self, "ipv6_nexthop_address")

    @property
    @pulumi.getter(name="isAdvertisedRoutePrioritySet")
    def is_advertised_route_priority_set(self) -> pulumi.Output[builtins.bool]:
        """
        An internal boolean field for provider use for zero_advertised_route_priority.
        """
        return pulumi.get(self, "is_advertised_route_priority_set")

    @property
    @pulumi.getter(name="isCustomLearnedPrioritySet")
    def is_custom_learned_priority_set(self) -> pulumi.Output[builtins.bool]:
        """
        An internal boolean field for provider use.
        """
        return pulumi.get(self, "is_custom_learned_priority_set")

    @property
    @pulumi.getter(name="managementType")
    def management_type(self) -> pulumi.Output[builtins.str]:
        """
        The resource that configures and manages this BGP peer.
        * `MANAGED_BY_USER` is the default value and can be managed by
        you or other users
        * `MANAGED_BY_ATTACHMENT` is a BGP peer that is configured and
        managed by Cloud Interconnect, specifically by an
        InterconnectAttachment of type PARTNER. Google automatically
        creates, updates, and deletes this type of BGP peer when the
        PARTNER InterconnectAttachment is created, updated,
        or deleted.
        """
        return pulumi.get(self, "management_type")

    @property
    @pulumi.getter(name="md5AuthenticationKey")
    def md5_authentication_key(self) -> pulumi.Output[Optional['outputs.RouterPeerMd5AuthenticationKey']]:
        """
        Configuration for MD5 authentication on the BGP session.
        Structure is documented below.
        """
        return pulumi.get(self, "md5_authentication_key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of this BGP peer. The name must be 1-63 characters long,
        and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which
        means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> pulumi.Output[builtins.int]:
        """
        Peer BGP Autonomous System Number (ASN).
        Each BGP interface may use a different value.
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> pulumi.Output[builtins.str]:
        """
        IP address of the BGP interface outside Google Cloud Platform.
        Only IPv4 is supported. Required if `ip_address` is set.
        """
        return pulumi.get(self, "peer_ip_address")

    @property
    @pulumi.getter(name="peerIpv4NexthopAddress")
    def peer_ipv4_nexthop_address(self) -> pulumi.Output[builtins.str]:
        """
        IPv4 address of the BGP interface outside Google Cloud Platform.
        """
        return pulumi.get(self, "peer_ipv4_nexthop_address")

    @property
    @pulumi.getter(name="peerIpv6NexthopAddress")
    def peer_ipv6_nexthop_address(self) -> pulumi.Output[builtins.str]:
        """
        IPv6 address of the BGP interface outside Google Cloud Platform.
        The address must be in the range 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64.
        If you do not specify the next hop addresses, Google Cloud automatically
        assigns unused addresses from the 2600:2d00:0:2::/64 or 2600:2d00:0:3::/64 range for you.
        """
        return pulumi.get(self, "peer_ipv6_nexthop_address")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where the router and BgpPeer reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def router(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Cloud Router in which this BgpPeer will be configured.


        - - -
        """
        return pulumi.get(self, "router")

    @property
    @pulumi.getter(name="routerApplianceInstance")
    def router_appliance_instance(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URI of the VM instance that is used as third-party router appliances
        such as Next Gen Firewalls, Virtual Routers, or Router Appliances.
        The VM instance must be located in zones contained in the same region as
        this Cloud Router. The VM instance is the peer side of the BGP session.
        """
        return pulumi.get(self, "router_appliance_instance")

    @property
    @pulumi.getter(name="zeroAdvertisedRoutePriority")
    def zero_advertised_route_priority(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The user-defined zero-advertised-route-priority for a advertised-route-priority in BGP session.
        This value has to be set true to force the advertised_route_priority to be 0.
        """
        return pulumi.get(self, "zero_advertised_route_priority")

    @property
    @pulumi.getter(name="zeroCustomLearnedRoutePriority")
    def zero_custom_learned_route_priority(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The user-defined zero-custom-learned-route-priority for a custom-learned-route-priority in BGP session.
        This value has to be set true to force the custom_learned_route_priority to be 0.
        """
        return pulumi.get(self, "zero_custom_learned_route_priority")

