# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TargetHttpsProxyArgs', 'TargetHttpsProxy']

@pulumi.input_type
class TargetHttpsProxyArgs:
    def __init__(__self__, *,
                 url_map: pulumi.Input[builtins.str],
                 certificate_manager_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificate_map: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 http_keep_alive_timeout_sec: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_bind: Optional[pulumi.Input[builtins.bool]] = None,
                 quic_override: Optional[pulumi.Input[builtins.str]] = None,
                 server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ssl_policy: Optional[pulumi.Input[builtins.str]] = None,
                 tls_early_data: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a TargetHttpsProxy resource.
        :param pulumi.Input[builtins.str] url_map: A reference to the UrlMap resource that defines the mapping from URL
               to the BackendService.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificate_manager_certificates: URLs to certificate manager certificate resources that are used to authenticate connections between users and the load balancer.
               Certificate manager certificates only apply when the load balancing scheme is set to INTERNAL_MANAGED.
               For EXTERNAL and EXTERNAL_MANAGED, use certificate_map instead.
               sslCertificates and certificateManagerCertificates fields can not be defined together.
               Accepted format is `//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificates/{resourceName}` or just the self_link `projects/{project}/locations/{location}/certificates/{resourceName}`
        :param pulumi.Input[builtins.str] certificate_map: A reference to the CertificateMap resource uri that identifies a certificate map
               associated with the given target proxy. This field is only supported for EXTERNAL and EXTERNAL_MANAGED load balancing schemes.
               For INTERNAL_MANAGED, use certificate_manager_certificates instead.
               Accepted format is `//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}`.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.int] http_keep_alive_timeout_sec: Specifies how long to keep a connection open, after completing a response,
               while there is no matching traffic (in seconds). If an HTTP keepalive is
               not specified, a default value will be used. For Global
               external HTTP(S) load balancer, the default value is 610 seconds, the
               minimum allowed value is 5 seconds and the maximum allowed value is 1200
               seconds. For cross-region internal HTTP(S) load balancer, the default
               value is 600 seconds, the minimum allowed value is 5 seconds, and the
               maximum allowed value is 600 seconds. For Global external HTTP(S) load
               balancer (classic), this option is not available publicly.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.bool] proxy_bind: This field only applies when the forwarding rule that references
               this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        :param pulumi.Input[builtins.str] quic_override: Specifies the QUIC override policy for this resource. This determines
               whether the load balancer will attempt to negotiate QUIC with clients
               or not. Can specify one of NONE, ENABLE, or DISABLE. If NONE is
               specified, Google manages whether QUIC is used.
               Default value is `NONE`.
               Possible values are: `NONE`, `ENABLE`, `DISABLE`.
        :param pulumi.Input[builtins.str] server_tls_policy: A URL referring to a networksecurity.ServerTlsPolicy
               resource that describes how the proxy should authenticate inbound
               traffic. serverTlsPolicy only applies to a global TargetHttpsProxy
               attached to globalForwardingRules with the loadBalancingScheme
               set to INTERNAL_SELF_MANAGED or EXTERNAL or EXTERNAL_MANAGED.
               For details which ServerTlsPolicy resources are accepted with
               INTERNAL_SELF_MANAGED and which with EXTERNAL, EXTERNAL_MANAGED
               loadBalancingScheme consult ServerTlsPolicy documentation.
               If left blank, communications are not encrypted.
               If you remove this field from your configuration at the same time as
               deleting or recreating a referenced ServerTlsPolicy resource, you will
               receive a resourceInUseByAnotherResource error. Use lifecycle.create_before_destroy
               within the ServerTlsPolicy resource to avoid this.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ssl_certificates: URLs to SslCertificate resources that are used to authenticate connections between users and the load balancer.
               Currently, you may specify up to 15 SSL certificates. sslCertificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.
               sslCertificates and certificateManagerCertificates can not be defined together.
        :param pulumi.Input[builtins.str] ssl_policy: A reference to the SslPolicy resource that will be associated with
               the TargetHttpsProxy resource. If not set, the TargetHttpsProxy
               resource will not have any SSL policy configured.
        :param pulumi.Input[builtins.str] tls_early_data: Specifies whether TLS 1.3 0-RTT Data (“Early Data”) should be accepted for this service.
               Early Data allows a TLS resumption handshake to include the initial application payload
               (a HTTP request) alongside the handshake, reducing the effective round trips to “zero”.
               This applies to TLS 1.3 connections over TCP (HTTP/2) as well as over UDP (QUIC/h3).
               Possible values are: `STRICT`, `PERMISSIVE`, `UNRESTRICTED`, `DISABLED`.
        """
        pulumi.set(__self__, "url_map", url_map)
        if certificate_manager_certificates is not None:
            pulumi.set(__self__, "certificate_manager_certificates", certificate_manager_certificates)
        if certificate_map is not None:
            pulumi.set(__self__, "certificate_map", certificate_map)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if http_keep_alive_timeout_sec is not None:
            pulumi.set(__self__, "http_keep_alive_timeout_sec", http_keep_alive_timeout_sec)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if proxy_bind is not None:
            pulumi.set(__self__, "proxy_bind", proxy_bind)
        if quic_override is not None:
            pulumi.set(__self__, "quic_override", quic_override)
        if server_tls_policy is not None:
            pulumi.set(__self__, "server_tls_policy", server_tls_policy)
        if ssl_certificates is not None:
            pulumi.set(__self__, "ssl_certificates", ssl_certificates)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)
        if tls_early_data is not None:
            pulumi.set(__self__, "tls_early_data", tls_early_data)

    @property
    @pulumi.getter(name="urlMap")
    def url_map(self) -> pulumi.Input[builtins.str]:
        """
        A reference to the UrlMap resource that defines the mapping from URL
        to the BackendService.


        - - -
        """
        return pulumi.get(self, "url_map")

    @url_map.setter
    def url_map(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "url_map", value)

    @property
    @pulumi.getter(name="certificateManagerCertificates")
    def certificate_manager_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        URLs to certificate manager certificate resources that are used to authenticate connections between users and the load balancer.
        Certificate manager certificates only apply when the load balancing scheme is set to INTERNAL_MANAGED.
        For EXTERNAL and EXTERNAL_MANAGED, use certificate_map instead.
        sslCertificates and certificateManagerCertificates fields can not be defined together.
        Accepted format is `//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificates/{resourceName}` or just the self_link `projects/{project}/locations/{location}/certificates/{resourceName}`
        """
        return pulumi.get(self, "certificate_manager_certificates")

    @certificate_manager_certificates.setter
    def certificate_manager_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "certificate_manager_certificates", value)

    @property
    @pulumi.getter(name="certificateMap")
    def certificate_map(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to the CertificateMap resource uri that identifies a certificate map
        associated with the given target proxy. This field is only supported for EXTERNAL and EXTERNAL_MANAGED load balancing schemes.
        For INTERNAL_MANAGED, use certificate_manager_certificates instead.
        Accepted format is `//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}`.
        """
        return pulumi.get(self, "certificate_map")

    @certificate_map.setter
    def certificate_map(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_map", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="httpKeepAliveTimeoutSec")
    def http_keep_alive_timeout_sec(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies how long to keep a connection open, after completing a response,
        while there is no matching traffic (in seconds). If an HTTP keepalive is
        not specified, a default value will be used. For Global
        external HTTP(S) load balancer, the default value is 610 seconds, the
        minimum allowed value is 5 seconds and the maximum allowed value is 1200
        seconds. For cross-region internal HTTP(S) load balancer, the default
        value is 600 seconds, the minimum allowed value is 5 seconds, and the
        maximum allowed value is 600 seconds. For Global external HTTP(S) load
        balancer (classic), this option is not available publicly.
        """
        return pulumi.get(self, "http_keep_alive_timeout_sec")

    @http_keep_alive_timeout_sec.setter
    def http_keep_alive_timeout_sec(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "http_keep_alive_timeout_sec", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="proxyBind")
    def proxy_bind(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This field only applies when the forwarding rule that references
        this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        """
        return pulumi.get(self, "proxy_bind")

    @proxy_bind.setter
    def proxy_bind(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "proxy_bind", value)

    @property
    @pulumi.getter(name="quicOverride")
    def quic_override(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the QUIC override policy for this resource. This determines
        whether the load balancer will attempt to negotiate QUIC with clients
        or not. Can specify one of NONE, ENABLE, or DISABLE. If NONE is
        specified, Google manages whether QUIC is used.
        Default value is `NONE`.
        Possible values are: `NONE`, `ENABLE`, `DISABLE`.
        """
        return pulumi.get(self, "quic_override")

    @quic_override.setter
    def quic_override(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "quic_override", value)

    @property
    @pulumi.getter(name="serverTlsPolicy")
    def server_tls_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A URL referring to a networksecurity.ServerTlsPolicy
        resource that describes how the proxy should authenticate inbound
        traffic. serverTlsPolicy only applies to a global TargetHttpsProxy
        attached to globalForwardingRules with the loadBalancingScheme
        set to INTERNAL_SELF_MANAGED or EXTERNAL or EXTERNAL_MANAGED.
        For details which ServerTlsPolicy resources are accepted with
        INTERNAL_SELF_MANAGED and which with EXTERNAL, EXTERNAL_MANAGED
        loadBalancingScheme consult ServerTlsPolicy documentation.
        If left blank, communications are not encrypted.
        If you remove this field from your configuration at the same time as
        deleting or recreating a referenced ServerTlsPolicy resource, you will
        receive a resourceInUseByAnotherResource error. Use lifecycle.create_before_destroy
        within the ServerTlsPolicy resource to avoid this.
        """
        return pulumi.get(self, "server_tls_policy")

    @server_tls_policy.setter
    def server_tls_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_tls_policy", value)

    @property
    @pulumi.getter(name="sslCertificates")
    def ssl_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        URLs to SslCertificate resources that are used to authenticate connections between users and the load balancer.
        Currently, you may specify up to 15 SSL certificates. sslCertificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.
        sslCertificates and certificateManagerCertificates can not be defined together.
        """
        return pulumi.get(self, "ssl_certificates")

    @ssl_certificates.setter
    def ssl_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ssl_certificates", value)

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to the SslPolicy resource that will be associated with
        the TargetHttpsProxy resource. If not set, the TargetHttpsProxy
        resource will not have any SSL policy configured.
        """
        return pulumi.get(self, "ssl_policy")

    @ssl_policy.setter
    def ssl_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_policy", value)

    @property
    @pulumi.getter(name="tlsEarlyData")
    def tls_early_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether TLS 1.3 0-RTT Data (“Early Data”) should be accepted for this service.
        Early Data allows a TLS resumption handshake to include the initial application payload
        (a HTTP request) alongside the handshake, reducing the effective round trips to “zero”.
        This applies to TLS 1.3 connections over TCP (HTTP/2) as well as over UDP (QUIC/h3).
        Possible values are: `STRICT`, `PERMISSIVE`, `UNRESTRICTED`, `DISABLED`.
        """
        return pulumi.get(self, "tls_early_data")

    @tls_early_data.setter
    def tls_early_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tls_early_data", value)


@pulumi.input_type
class _TargetHttpsProxyState:
    def __init__(__self__, *,
                 certificate_manager_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificate_map: Optional[pulumi.Input[builtins.str]] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 http_keep_alive_timeout_sec: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_bind: Optional[pulumi.Input[builtins.bool]] = None,
                 proxy_id: Optional[pulumi.Input[builtins.int]] = None,
                 quic_override: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ssl_policy: Optional[pulumi.Input[builtins.str]] = None,
                 tls_early_data: Optional[pulumi.Input[builtins.str]] = None,
                 url_map: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering TargetHttpsProxy resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificate_manager_certificates: URLs to certificate manager certificate resources that are used to authenticate connections between users and the load balancer.
               Certificate manager certificates only apply when the load balancing scheme is set to INTERNAL_MANAGED.
               For EXTERNAL and EXTERNAL_MANAGED, use certificate_map instead.
               sslCertificates and certificateManagerCertificates fields can not be defined together.
               Accepted format is `//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificates/{resourceName}` or just the self_link `projects/{project}/locations/{location}/certificates/{resourceName}`
        :param pulumi.Input[builtins.str] certificate_map: A reference to the CertificateMap resource uri that identifies a certificate map
               associated with the given target proxy. This field is only supported for EXTERNAL and EXTERNAL_MANAGED load balancing schemes.
               For INTERNAL_MANAGED, use certificate_manager_certificates instead.
               Accepted format is `//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}`.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking.
               This field will be ignored when inserting a TargetHttpsProxy. An up-to-date fingerprint must be provided in order to
               patch the TargetHttpsProxy; otherwise, the request will fail with error 412 conditionNotMet.
               To see the latest fingerprint, make a get() request to retrieve the TargetHttpsProxy.
               A base64-encoded string.
        :param pulumi.Input[builtins.int] http_keep_alive_timeout_sec: Specifies how long to keep a connection open, after completing a response,
               while there is no matching traffic (in seconds). If an HTTP keepalive is
               not specified, a default value will be used. For Global
               external HTTP(S) load balancer, the default value is 610 seconds, the
               minimum allowed value is 5 seconds and the maximum allowed value is 1200
               seconds. For cross-region internal HTTP(S) load balancer, the default
               value is 600 seconds, the minimum allowed value is 5 seconds, and the
               maximum allowed value is 600 seconds. For Global external HTTP(S) load
               balancer (classic), this option is not available publicly.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.bool] proxy_bind: This field only applies when the forwarding rule that references
               this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        :param pulumi.Input[builtins.int] proxy_id: The unique identifier for the resource.
        :param pulumi.Input[builtins.str] quic_override: Specifies the QUIC override policy for this resource. This determines
               whether the load balancer will attempt to negotiate QUIC with clients
               or not. Can specify one of NONE, ENABLE, or DISABLE. If NONE is
               specified, Google manages whether QUIC is used.
               Default value is `NONE`.
               Possible values are: `NONE`, `ENABLE`, `DISABLE`.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[builtins.str] server_tls_policy: A URL referring to a networksecurity.ServerTlsPolicy
               resource that describes how the proxy should authenticate inbound
               traffic. serverTlsPolicy only applies to a global TargetHttpsProxy
               attached to globalForwardingRules with the loadBalancingScheme
               set to INTERNAL_SELF_MANAGED or EXTERNAL or EXTERNAL_MANAGED.
               For details which ServerTlsPolicy resources are accepted with
               INTERNAL_SELF_MANAGED and which with EXTERNAL, EXTERNAL_MANAGED
               loadBalancingScheme consult ServerTlsPolicy documentation.
               If left blank, communications are not encrypted.
               If you remove this field from your configuration at the same time as
               deleting or recreating a referenced ServerTlsPolicy resource, you will
               receive a resourceInUseByAnotherResource error. Use lifecycle.create_before_destroy
               within the ServerTlsPolicy resource to avoid this.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ssl_certificates: URLs to SslCertificate resources that are used to authenticate connections between users and the load balancer.
               Currently, you may specify up to 15 SSL certificates. sslCertificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.
               sslCertificates and certificateManagerCertificates can not be defined together.
        :param pulumi.Input[builtins.str] ssl_policy: A reference to the SslPolicy resource that will be associated with
               the TargetHttpsProxy resource. If not set, the TargetHttpsProxy
               resource will not have any SSL policy configured.
        :param pulumi.Input[builtins.str] tls_early_data: Specifies whether TLS 1.3 0-RTT Data (“Early Data”) should be accepted for this service.
               Early Data allows a TLS resumption handshake to include the initial application payload
               (a HTTP request) alongside the handshake, reducing the effective round trips to “zero”.
               This applies to TLS 1.3 connections over TCP (HTTP/2) as well as over UDP (QUIC/h3).
               Possible values are: `STRICT`, `PERMISSIVE`, `UNRESTRICTED`, `DISABLED`.
        :param pulumi.Input[builtins.str] url_map: A reference to the UrlMap resource that defines the mapping from URL
               to the BackendService.
               
               
               - - -
        """
        if certificate_manager_certificates is not None:
            pulumi.set(__self__, "certificate_manager_certificates", certificate_manager_certificates)
        if certificate_map is not None:
            pulumi.set(__self__, "certificate_map", certificate_map)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if http_keep_alive_timeout_sec is not None:
            pulumi.set(__self__, "http_keep_alive_timeout_sec", http_keep_alive_timeout_sec)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if proxy_bind is not None:
            pulumi.set(__self__, "proxy_bind", proxy_bind)
        if proxy_id is not None:
            pulumi.set(__self__, "proxy_id", proxy_id)
        if quic_override is not None:
            pulumi.set(__self__, "quic_override", quic_override)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if server_tls_policy is not None:
            pulumi.set(__self__, "server_tls_policy", server_tls_policy)
        if ssl_certificates is not None:
            pulumi.set(__self__, "ssl_certificates", ssl_certificates)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)
        if tls_early_data is not None:
            pulumi.set(__self__, "tls_early_data", tls_early_data)
        if url_map is not None:
            pulumi.set(__self__, "url_map", url_map)

    @property
    @pulumi.getter(name="certificateManagerCertificates")
    def certificate_manager_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        URLs to certificate manager certificate resources that are used to authenticate connections between users and the load balancer.
        Certificate manager certificates only apply when the load balancing scheme is set to INTERNAL_MANAGED.
        For EXTERNAL and EXTERNAL_MANAGED, use certificate_map instead.
        sslCertificates and certificateManagerCertificates fields can not be defined together.
        Accepted format is `//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificates/{resourceName}` or just the self_link `projects/{project}/locations/{location}/certificates/{resourceName}`
        """
        return pulumi.get(self, "certificate_manager_certificates")

    @certificate_manager_certificates.setter
    def certificate_manager_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "certificate_manager_certificates", value)

    @property
    @pulumi.getter(name="certificateMap")
    def certificate_map(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to the CertificateMap resource uri that identifies a certificate map
        associated with the given target proxy. This field is only supported for EXTERNAL and EXTERNAL_MANAGED load balancing schemes.
        For INTERNAL_MANAGED, use certificate_manager_certificates instead.
        Accepted format is `//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}`.
        """
        return pulumi.get(self, "certificate_map")

    @certificate_map.setter
    def certificate_map(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_map", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking.
        This field will be ignored when inserting a TargetHttpsProxy. An up-to-date fingerprint must be provided in order to
        patch the TargetHttpsProxy; otherwise, the request will fail with error 412 conditionNotMet.
        To see the latest fingerprint, make a get() request to retrieve the TargetHttpsProxy.
        A base64-encoded string.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="httpKeepAliveTimeoutSec")
    def http_keep_alive_timeout_sec(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies how long to keep a connection open, after completing a response,
        while there is no matching traffic (in seconds). If an HTTP keepalive is
        not specified, a default value will be used. For Global
        external HTTP(S) load balancer, the default value is 610 seconds, the
        minimum allowed value is 5 seconds and the maximum allowed value is 1200
        seconds. For cross-region internal HTTP(S) load balancer, the default
        value is 600 seconds, the minimum allowed value is 5 seconds, and the
        maximum allowed value is 600 seconds. For Global external HTTP(S) load
        balancer (classic), this option is not available publicly.
        """
        return pulumi.get(self, "http_keep_alive_timeout_sec")

    @http_keep_alive_timeout_sec.setter
    def http_keep_alive_timeout_sec(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "http_keep_alive_timeout_sec", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="proxyBind")
    def proxy_bind(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This field only applies when the forwarding rule that references
        this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        """
        return pulumi.get(self, "proxy_bind")

    @proxy_bind.setter
    def proxy_bind(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "proxy_bind", value)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The unique identifier for the resource.
        """
        return pulumi.get(self, "proxy_id")

    @proxy_id.setter
    def proxy_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "proxy_id", value)

    @property
    @pulumi.getter(name="quicOverride")
    def quic_override(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the QUIC override policy for this resource. This determines
        whether the load balancer will attempt to negotiate QUIC with clients
        or not. Can specify one of NONE, ENABLE, or DISABLE. If NONE is
        specified, Google manages whether QUIC is used.
        Default value is `NONE`.
        Possible values are: `NONE`, `ENABLE`, `DISABLE`.
        """
        return pulumi.get(self, "quic_override")

    @quic_override.setter
    def quic_override(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "quic_override", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="serverTlsPolicy")
    def server_tls_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A URL referring to a networksecurity.ServerTlsPolicy
        resource that describes how the proxy should authenticate inbound
        traffic. serverTlsPolicy only applies to a global TargetHttpsProxy
        attached to globalForwardingRules with the loadBalancingScheme
        set to INTERNAL_SELF_MANAGED or EXTERNAL or EXTERNAL_MANAGED.
        For details which ServerTlsPolicy resources are accepted with
        INTERNAL_SELF_MANAGED and which with EXTERNAL, EXTERNAL_MANAGED
        loadBalancingScheme consult ServerTlsPolicy documentation.
        If left blank, communications are not encrypted.
        If you remove this field from your configuration at the same time as
        deleting or recreating a referenced ServerTlsPolicy resource, you will
        receive a resourceInUseByAnotherResource error. Use lifecycle.create_before_destroy
        within the ServerTlsPolicy resource to avoid this.
        """
        return pulumi.get(self, "server_tls_policy")

    @server_tls_policy.setter
    def server_tls_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_tls_policy", value)

    @property
    @pulumi.getter(name="sslCertificates")
    def ssl_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        URLs to SslCertificate resources that are used to authenticate connections between users and the load balancer.
        Currently, you may specify up to 15 SSL certificates. sslCertificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.
        sslCertificates and certificateManagerCertificates can not be defined together.
        """
        return pulumi.get(self, "ssl_certificates")

    @ssl_certificates.setter
    def ssl_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ssl_certificates", value)

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to the SslPolicy resource that will be associated with
        the TargetHttpsProxy resource. If not set, the TargetHttpsProxy
        resource will not have any SSL policy configured.
        """
        return pulumi.get(self, "ssl_policy")

    @ssl_policy.setter
    def ssl_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_policy", value)

    @property
    @pulumi.getter(name="tlsEarlyData")
    def tls_early_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether TLS 1.3 0-RTT Data (“Early Data”) should be accepted for this service.
        Early Data allows a TLS resumption handshake to include the initial application payload
        (a HTTP request) alongside the handshake, reducing the effective round trips to “zero”.
        This applies to TLS 1.3 connections over TCP (HTTP/2) as well as over UDP (QUIC/h3).
        Possible values are: `STRICT`, `PERMISSIVE`, `UNRESTRICTED`, `DISABLED`.
        """
        return pulumi.get(self, "tls_early_data")

    @tls_early_data.setter
    def tls_early_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tls_early_data", value)

    @property
    @pulumi.getter(name="urlMap")
    def url_map(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to the UrlMap resource that defines the mapping from URL
        to the BackendService.


        - - -
        """
        return pulumi.get(self, "url_map")

    @url_map.setter
    def url_map(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url_map", value)


@pulumi.type_token("gcp:compute/targetHttpsProxy:TargetHttpsProxy")
class TargetHttpsProxy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_manager_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificate_map: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 http_keep_alive_timeout_sec: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_bind: Optional[pulumi.Input[builtins.bool]] = None,
                 quic_override: Optional[pulumi.Input[builtins.str]] = None,
                 server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ssl_policy: Optional[pulumi.Input[builtins.str]] = None,
                 tls_early_data: Optional[pulumi.Input[builtins.str]] = None,
                 url_map: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Represents a TargetHttpsProxy resource, which is used by one or more
        global forwarding rule to route incoming HTTPS requests to a URL map.

        To get more information about TargetHttpsProxy, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/targetHttpsProxies)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/load-balancing/http/target-proxies)

        ## Example Usage

        ### Target Https Proxy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default_ssl_certificate = gcp.compute.SSLCertificate("default",
            name="my-certificate",
            private_key=std.file(input="path/to/private.key").result,
            certificate=std.file(input="path/to/certificate.crt").result)
        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="http-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default_backend_service = gcp.compute.BackendService("default",
            name="backend-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default_http_health_check.id)
        default_url_map = gcp.compute.URLMap("default",
            name="url-map",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default = gcp.compute.TargetHttpsProxy("default",
            name="test-proxy",
            url_map=default_url_map.id,
            ssl_certificates=[default_ssl_certificate.id])
        ```
        ### Target Https Proxy Http Keep Alive Timeout

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default_ssl_certificate = gcp.compute.SSLCertificate("default",
            name="my-certificate",
            private_key=std.file(input="path/to/private.key").result,
            certificate=std.file(input="path/to/certificate.crt").result)
        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="http-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default_backend_service = gcp.compute.BackendService("default",
            name="backend-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="EXTERNAL_MANAGED",
            health_checks=default_http_health_check.id)
        default_url_map = gcp.compute.URLMap("default",
            name="url-map",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default = gcp.compute.TargetHttpsProxy("default",
            name="test-http-keep-alive-timeout-proxy",
            http_keep_alive_timeout_sec=610,
            url_map=default_url_map.id,
            ssl_certificates=[default_ssl_certificate.id])
        ```
        ### Target Https Proxy Mtls

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        project = gcp.organizations.get_project()
        default_trust_config = gcp.certificatemanager.TrustConfig("default",
            name="my-trust-config",
            description="sample description for the trust config",
            location="global",
            trust_stores=[{
                "trust_anchors": [{
                    "pem_certificate": std.file(input="test-fixtures/ca_cert.pem").result,
                }],
                "intermediate_cas": [{
                    "pem_certificate": std.file(input="test-fixtures/ca_cert.pem").result,
                }],
            }],
            labels={
                "foo": "bar",
            })
        default_server_tls_policy = gcp.networksecurity.ServerTlsPolicy("default",
            name="my-tls-policy",
            description="my description",
            location="global",
            allow_open=False,
            mtls_policy={
                "client_validation_mode": "ALLOW_INVALID_OR_MISSING_CLIENT_CERT",
                "client_validation_trust_config": default_trust_config.name.apply(lambda name: f"projects/{project.number}/locations/global/trustConfigs/{name}"),
            })
        default_ssl_certificate = gcp.compute.SSLCertificate("default",
            name="my-certificate",
            private_key=std.file(input="path/to/private.key").result,
            certificate=std.file(input="path/to/certificate.crt").result)
        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="http-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default_backend_service = gcp.compute.BackendService("default",
            name="backend-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default_http_health_check.id)
        default_url_map = gcp.compute.URLMap("default",
            name="url-map",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default = gcp.compute.TargetHttpsProxy("default",
            name="test-mtls-proxy",
            url_map=default_url_map.id,
            ssl_certificates=[default_ssl_certificate.id],
            server_tls_policy=default_server_tls_policy.id)
        ```
        ### Target Https Proxy Certificate Manager Certificate

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default_certificate = gcp.certificatemanager.Certificate("default",
            name="my-certificate",
            scope="ALL_REGIONS",
            self_managed={
                "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                "pem_private_key": std.file(input="test-fixtures/private-key.pem").result,
            })
        default_backend_service = gcp.compute.BackendService("default",
            name="backend-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="INTERNAL_MANAGED")
        default_url_map = gcp.compute.URLMap("default",
            name="url-map",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default = gcp.compute.TargetHttpsProxy("default",
            name="target-http-proxy",
            url_map=default_url_map.id,
            certificate_manager_certificates=[default_certificate.id.apply(lambda id: f"//certificatemanager.googleapis.com/{id}")])
        ```
        ### Target Https Proxy Fingerprint

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default_ssl_certificate = gcp.compute.SSLCertificate("default",
            name="my-certificate",
            private_key=std.file(input="path/to/private.key").result,
            certificate=std.file(input="path/to/certificate.crt").result)
        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="http-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default_backend_service = gcp.compute.BackendService("default",
            name="backend-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default_http_health_check.id)
        default_url_map = gcp.compute.URLMap("default",
            name="url-map",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default = gcp.compute.TargetHttpsProxy("default",
            name="test-fingerprint-proxy",
            url_map=default_url_map.id,
            ssl_certificates=[default_ssl_certificate.id])
        pulumi.export("targetHttpsProxyFingerprint", default.fingerprint)
        ```

        ## Import

        TargetHttpsProxy can be imported using any of these accepted formats:

        * `projects/{{project}}/global/targetHttpsProxies/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, TargetHttpsProxy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/targetHttpsProxy:TargetHttpsProxy default projects/{{project}}/global/targetHttpsProxies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/targetHttpsProxy:TargetHttpsProxy default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/targetHttpsProxy:TargetHttpsProxy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificate_manager_certificates: URLs to certificate manager certificate resources that are used to authenticate connections between users and the load balancer.
               Certificate manager certificates only apply when the load balancing scheme is set to INTERNAL_MANAGED.
               For EXTERNAL and EXTERNAL_MANAGED, use certificate_map instead.
               sslCertificates and certificateManagerCertificates fields can not be defined together.
               Accepted format is `//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificates/{resourceName}` or just the self_link `projects/{project}/locations/{location}/certificates/{resourceName}`
        :param pulumi.Input[builtins.str] certificate_map: A reference to the CertificateMap resource uri that identifies a certificate map
               associated with the given target proxy. This field is only supported for EXTERNAL and EXTERNAL_MANAGED load balancing schemes.
               For INTERNAL_MANAGED, use certificate_manager_certificates instead.
               Accepted format is `//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}`.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.int] http_keep_alive_timeout_sec: Specifies how long to keep a connection open, after completing a response,
               while there is no matching traffic (in seconds). If an HTTP keepalive is
               not specified, a default value will be used. For Global
               external HTTP(S) load balancer, the default value is 610 seconds, the
               minimum allowed value is 5 seconds and the maximum allowed value is 1200
               seconds. For cross-region internal HTTP(S) load balancer, the default
               value is 600 seconds, the minimum allowed value is 5 seconds, and the
               maximum allowed value is 600 seconds. For Global external HTTP(S) load
               balancer (classic), this option is not available publicly.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.bool] proxy_bind: This field only applies when the forwarding rule that references
               this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        :param pulumi.Input[builtins.str] quic_override: Specifies the QUIC override policy for this resource. This determines
               whether the load balancer will attempt to negotiate QUIC with clients
               or not. Can specify one of NONE, ENABLE, or DISABLE. If NONE is
               specified, Google manages whether QUIC is used.
               Default value is `NONE`.
               Possible values are: `NONE`, `ENABLE`, `DISABLE`.
        :param pulumi.Input[builtins.str] server_tls_policy: A URL referring to a networksecurity.ServerTlsPolicy
               resource that describes how the proxy should authenticate inbound
               traffic. serverTlsPolicy only applies to a global TargetHttpsProxy
               attached to globalForwardingRules with the loadBalancingScheme
               set to INTERNAL_SELF_MANAGED or EXTERNAL or EXTERNAL_MANAGED.
               For details which ServerTlsPolicy resources are accepted with
               INTERNAL_SELF_MANAGED and which with EXTERNAL, EXTERNAL_MANAGED
               loadBalancingScheme consult ServerTlsPolicy documentation.
               If left blank, communications are not encrypted.
               If you remove this field from your configuration at the same time as
               deleting or recreating a referenced ServerTlsPolicy resource, you will
               receive a resourceInUseByAnotherResource error. Use lifecycle.create_before_destroy
               within the ServerTlsPolicy resource to avoid this.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ssl_certificates: URLs to SslCertificate resources that are used to authenticate connections between users and the load balancer.
               Currently, you may specify up to 15 SSL certificates. sslCertificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.
               sslCertificates and certificateManagerCertificates can not be defined together.
        :param pulumi.Input[builtins.str] ssl_policy: A reference to the SslPolicy resource that will be associated with
               the TargetHttpsProxy resource. If not set, the TargetHttpsProxy
               resource will not have any SSL policy configured.
        :param pulumi.Input[builtins.str] tls_early_data: Specifies whether TLS 1.3 0-RTT Data (“Early Data”) should be accepted for this service.
               Early Data allows a TLS resumption handshake to include the initial application payload
               (a HTTP request) alongside the handshake, reducing the effective round trips to “zero”.
               This applies to TLS 1.3 connections over TCP (HTTP/2) as well as over UDP (QUIC/h3).
               Possible values are: `STRICT`, `PERMISSIVE`, `UNRESTRICTED`, `DISABLED`.
        :param pulumi.Input[builtins.str] url_map: A reference to the UrlMap resource that defines the mapping from URL
               to the BackendService.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TargetHttpsProxyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a TargetHttpsProxy resource, which is used by one or more
        global forwarding rule to route incoming HTTPS requests to a URL map.

        To get more information about TargetHttpsProxy, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/targetHttpsProxies)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/load-balancing/http/target-proxies)

        ## Example Usage

        ### Target Https Proxy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default_ssl_certificate = gcp.compute.SSLCertificate("default",
            name="my-certificate",
            private_key=std.file(input="path/to/private.key").result,
            certificate=std.file(input="path/to/certificate.crt").result)
        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="http-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default_backend_service = gcp.compute.BackendService("default",
            name="backend-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default_http_health_check.id)
        default_url_map = gcp.compute.URLMap("default",
            name="url-map",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default = gcp.compute.TargetHttpsProxy("default",
            name="test-proxy",
            url_map=default_url_map.id,
            ssl_certificates=[default_ssl_certificate.id])
        ```
        ### Target Https Proxy Http Keep Alive Timeout

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default_ssl_certificate = gcp.compute.SSLCertificate("default",
            name="my-certificate",
            private_key=std.file(input="path/to/private.key").result,
            certificate=std.file(input="path/to/certificate.crt").result)
        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="http-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default_backend_service = gcp.compute.BackendService("default",
            name="backend-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="EXTERNAL_MANAGED",
            health_checks=default_http_health_check.id)
        default_url_map = gcp.compute.URLMap("default",
            name="url-map",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default = gcp.compute.TargetHttpsProxy("default",
            name="test-http-keep-alive-timeout-proxy",
            http_keep_alive_timeout_sec=610,
            url_map=default_url_map.id,
            ssl_certificates=[default_ssl_certificate.id])
        ```
        ### Target Https Proxy Mtls

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        project = gcp.organizations.get_project()
        default_trust_config = gcp.certificatemanager.TrustConfig("default",
            name="my-trust-config",
            description="sample description for the trust config",
            location="global",
            trust_stores=[{
                "trust_anchors": [{
                    "pem_certificate": std.file(input="test-fixtures/ca_cert.pem").result,
                }],
                "intermediate_cas": [{
                    "pem_certificate": std.file(input="test-fixtures/ca_cert.pem").result,
                }],
            }],
            labels={
                "foo": "bar",
            })
        default_server_tls_policy = gcp.networksecurity.ServerTlsPolicy("default",
            name="my-tls-policy",
            description="my description",
            location="global",
            allow_open=False,
            mtls_policy={
                "client_validation_mode": "ALLOW_INVALID_OR_MISSING_CLIENT_CERT",
                "client_validation_trust_config": default_trust_config.name.apply(lambda name: f"projects/{project.number}/locations/global/trustConfigs/{name}"),
            })
        default_ssl_certificate = gcp.compute.SSLCertificate("default",
            name="my-certificate",
            private_key=std.file(input="path/to/private.key").result,
            certificate=std.file(input="path/to/certificate.crt").result)
        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="http-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default_backend_service = gcp.compute.BackendService("default",
            name="backend-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default_http_health_check.id)
        default_url_map = gcp.compute.URLMap("default",
            name="url-map",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default = gcp.compute.TargetHttpsProxy("default",
            name="test-mtls-proxy",
            url_map=default_url_map.id,
            ssl_certificates=[default_ssl_certificate.id],
            server_tls_policy=default_server_tls_policy.id)
        ```
        ### Target Https Proxy Certificate Manager Certificate

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default_certificate = gcp.certificatemanager.Certificate("default",
            name="my-certificate",
            scope="ALL_REGIONS",
            self_managed={
                "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                "pem_private_key": std.file(input="test-fixtures/private-key.pem").result,
            })
        default_backend_service = gcp.compute.BackendService("default",
            name="backend-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="INTERNAL_MANAGED")
        default_url_map = gcp.compute.URLMap("default",
            name="url-map",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default = gcp.compute.TargetHttpsProxy("default",
            name="target-http-proxy",
            url_map=default_url_map.id,
            certificate_manager_certificates=[default_certificate.id.apply(lambda id: f"//certificatemanager.googleapis.com/{id}")])
        ```
        ### Target Https Proxy Fingerprint

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default_ssl_certificate = gcp.compute.SSLCertificate("default",
            name="my-certificate",
            private_key=std.file(input="path/to/private.key").result,
            certificate=std.file(input="path/to/certificate.crt").result)
        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="http-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default_backend_service = gcp.compute.BackendService("default",
            name="backend-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default_http_health_check.id)
        default_url_map = gcp.compute.URLMap("default",
            name="url-map",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": default_backend_service.id,
                "path_rules": [{
                    "paths": ["/*"],
                    "service": default_backend_service.id,
                }],
            }])
        default = gcp.compute.TargetHttpsProxy("default",
            name="test-fingerprint-proxy",
            url_map=default_url_map.id,
            ssl_certificates=[default_ssl_certificate.id])
        pulumi.export("targetHttpsProxyFingerprint", default.fingerprint)
        ```

        ## Import

        TargetHttpsProxy can be imported using any of these accepted formats:

        * `projects/{{project}}/global/targetHttpsProxies/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, TargetHttpsProxy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/targetHttpsProxy:TargetHttpsProxy default projects/{{project}}/global/targetHttpsProxies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/targetHttpsProxy:TargetHttpsProxy default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/targetHttpsProxy:TargetHttpsProxy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param TargetHttpsProxyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TargetHttpsProxyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_manager_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificate_map: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 http_keep_alive_timeout_sec: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_bind: Optional[pulumi.Input[builtins.bool]] = None,
                 quic_override: Optional[pulumi.Input[builtins.str]] = None,
                 server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ssl_policy: Optional[pulumi.Input[builtins.str]] = None,
                 tls_early_data: Optional[pulumi.Input[builtins.str]] = None,
                 url_map: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TargetHttpsProxyArgs.__new__(TargetHttpsProxyArgs)

            __props__.__dict__["certificate_manager_certificates"] = certificate_manager_certificates
            __props__.__dict__["certificate_map"] = certificate_map
            __props__.__dict__["description"] = description
            __props__.__dict__["http_keep_alive_timeout_sec"] = http_keep_alive_timeout_sec
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["proxy_bind"] = proxy_bind
            __props__.__dict__["quic_override"] = quic_override
            __props__.__dict__["server_tls_policy"] = server_tls_policy
            __props__.__dict__["ssl_certificates"] = ssl_certificates
            __props__.__dict__["ssl_policy"] = ssl_policy
            __props__.__dict__["tls_early_data"] = tls_early_data
            if url_map is None and not opts.urn:
                raise TypeError("Missing required property 'url_map'")
            __props__.__dict__["url_map"] = url_map
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["proxy_id"] = None
            __props__.__dict__["self_link"] = None
        super(TargetHttpsProxy, __self__).__init__(
            'gcp:compute/targetHttpsProxy:TargetHttpsProxy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_manager_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            certificate_map: Optional[pulumi.Input[builtins.str]] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            http_keep_alive_timeout_sec: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            proxy_bind: Optional[pulumi.Input[builtins.bool]] = None,
            proxy_id: Optional[pulumi.Input[builtins.int]] = None,
            quic_override: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
            ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ssl_policy: Optional[pulumi.Input[builtins.str]] = None,
            tls_early_data: Optional[pulumi.Input[builtins.str]] = None,
            url_map: Optional[pulumi.Input[builtins.str]] = None) -> 'TargetHttpsProxy':
        """
        Get an existing TargetHttpsProxy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificate_manager_certificates: URLs to certificate manager certificate resources that are used to authenticate connections between users and the load balancer.
               Certificate manager certificates only apply when the load balancing scheme is set to INTERNAL_MANAGED.
               For EXTERNAL and EXTERNAL_MANAGED, use certificate_map instead.
               sslCertificates and certificateManagerCertificates fields can not be defined together.
               Accepted format is `//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificates/{resourceName}` or just the self_link `projects/{project}/locations/{location}/certificates/{resourceName}`
        :param pulumi.Input[builtins.str] certificate_map: A reference to the CertificateMap resource uri that identifies a certificate map
               associated with the given target proxy. This field is only supported for EXTERNAL and EXTERNAL_MANAGED load balancing schemes.
               For INTERNAL_MANAGED, use certificate_manager_certificates instead.
               Accepted format is `//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}`.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking.
               This field will be ignored when inserting a TargetHttpsProxy. An up-to-date fingerprint must be provided in order to
               patch the TargetHttpsProxy; otherwise, the request will fail with error 412 conditionNotMet.
               To see the latest fingerprint, make a get() request to retrieve the TargetHttpsProxy.
               A base64-encoded string.
        :param pulumi.Input[builtins.int] http_keep_alive_timeout_sec: Specifies how long to keep a connection open, after completing a response,
               while there is no matching traffic (in seconds). If an HTTP keepalive is
               not specified, a default value will be used. For Global
               external HTTP(S) load balancer, the default value is 610 seconds, the
               minimum allowed value is 5 seconds and the maximum allowed value is 1200
               seconds. For cross-region internal HTTP(S) load balancer, the default
               value is 600 seconds, the minimum allowed value is 5 seconds, and the
               maximum allowed value is 600 seconds. For Global external HTTP(S) load
               balancer (classic), this option is not available publicly.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.bool] proxy_bind: This field only applies when the forwarding rule that references
               this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        :param pulumi.Input[builtins.int] proxy_id: The unique identifier for the resource.
        :param pulumi.Input[builtins.str] quic_override: Specifies the QUIC override policy for this resource. This determines
               whether the load balancer will attempt to negotiate QUIC with clients
               or not. Can specify one of NONE, ENABLE, or DISABLE. If NONE is
               specified, Google manages whether QUIC is used.
               Default value is `NONE`.
               Possible values are: `NONE`, `ENABLE`, `DISABLE`.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[builtins.str] server_tls_policy: A URL referring to a networksecurity.ServerTlsPolicy
               resource that describes how the proxy should authenticate inbound
               traffic. serverTlsPolicy only applies to a global TargetHttpsProxy
               attached to globalForwardingRules with the loadBalancingScheme
               set to INTERNAL_SELF_MANAGED or EXTERNAL or EXTERNAL_MANAGED.
               For details which ServerTlsPolicy resources are accepted with
               INTERNAL_SELF_MANAGED and which with EXTERNAL, EXTERNAL_MANAGED
               loadBalancingScheme consult ServerTlsPolicy documentation.
               If left blank, communications are not encrypted.
               If you remove this field from your configuration at the same time as
               deleting or recreating a referenced ServerTlsPolicy resource, you will
               receive a resourceInUseByAnotherResource error. Use lifecycle.create_before_destroy
               within the ServerTlsPolicy resource to avoid this.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ssl_certificates: URLs to SslCertificate resources that are used to authenticate connections between users and the load balancer.
               Currently, you may specify up to 15 SSL certificates. sslCertificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.
               sslCertificates and certificateManagerCertificates can not be defined together.
        :param pulumi.Input[builtins.str] ssl_policy: A reference to the SslPolicy resource that will be associated with
               the TargetHttpsProxy resource. If not set, the TargetHttpsProxy
               resource will not have any SSL policy configured.
        :param pulumi.Input[builtins.str] tls_early_data: Specifies whether TLS 1.3 0-RTT Data (“Early Data”) should be accepted for this service.
               Early Data allows a TLS resumption handshake to include the initial application payload
               (a HTTP request) alongside the handshake, reducing the effective round trips to “zero”.
               This applies to TLS 1.3 connections over TCP (HTTP/2) as well as over UDP (QUIC/h3).
               Possible values are: `STRICT`, `PERMISSIVE`, `UNRESTRICTED`, `DISABLED`.
        :param pulumi.Input[builtins.str] url_map: A reference to the UrlMap resource that defines the mapping from URL
               to the BackendService.
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TargetHttpsProxyState.__new__(_TargetHttpsProxyState)

        __props__.__dict__["certificate_manager_certificates"] = certificate_manager_certificates
        __props__.__dict__["certificate_map"] = certificate_map
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["http_keep_alive_timeout_sec"] = http_keep_alive_timeout_sec
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["proxy_bind"] = proxy_bind
        __props__.__dict__["proxy_id"] = proxy_id
        __props__.__dict__["quic_override"] = quic_override
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["server_tls_policy"] = server_tls_policy
        __props__.__dict__["ssl_certificates"] = ssl_certificates
        __props__.__dict__["ssl_policy"] = ssl_policy
        __props__.__dict__["tls_early_data"] = tls_early_data
        __props__.__dict__["url_map"] = url_map
        return TargetHttpsProxy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateManagerCertificates")
    def certificate_manager_certificates(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        URLs to certificate manager certificate resources that are used to authenticate connections between users and the load balancer.
        Certificate manager certificates only apply when the load balancing scheme is set to INTERNAL_MANAGED.
        For EXTERNAL and EXTERNAL_MANAGED, use certificate_map instead.
        sslCertificates and certificateManagerCertificates fields can not be defined together.
        Accepted format is `//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificates/{resourceName}` or just the self_link `projects/{project}/locations/{location}/certificates/{resourceName}`
        """
        return pulumi.get(self, "certificate_manager_certificates")

    @property
    @pulumi.getter(name="certificateMap")
    def certificate_map(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A reference to the CertificateMap resource uri that identifies a certificate map
        associated with the given target proxy. This field is only supported for EXTERNAL and EXTERNAL_MANAGED load balancing schemes.
        For INTERNAL_MANAGED, use certificate_manager_certificates instead.
        Accepted format is `//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}`.
        """
        return pulumi.get(self, "certificate_map")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking.
        This field will be ignored when inserting a TargetHttpsProxy. An up-to-date fingerprint must be provided in order to
        patch the TargetHttpsProxy; otherwise, the request will fail with error 412 conditionNotMet.
        To see the latest fingerprint, make a get() request to retrieve the TargetHttpsProxy.
        A base64-encoded string.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="httpKeepAliveTimeoutSec")
    def http_keep_alive_timeout_sec(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies how long to keep a connection open, after completing a response,
        while there is no matching traffic (in seconds). If an HTTP keepalive is
        not specified, a default value will be used. For Global
        external HTTP(S) load balancer, the default value is 610 seconds, the
        minimum allowed value is 5 seconds and the maximum allowed value is 1200
        seconds. For cross-region internal HTTP(S) load balancer, the default
        value is 600 seconds, the minimum allowed value is 5 seconds, and the
        maximum allowed value is 600 seconds. For Global external HTTP(S) load
        balancer (classic), this option is not available publicly.
        """
        return pulumi.get(self, "http_keep_alive_timeout_sec")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="proxyBind")
    def proxy_bind(self) -> pulumi.Output[builtins.bool]:
        """
        This field only applies when the forwarding rule that references
        this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        """
        return pulumi.get(self, "proxy_bind")

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> pulumi.Output[builtins.int]:
        """
        The unique identifier for the resource.
        """
        return pulumi.get(self, "proxy_id")

    @property
    @pulumi.getter(name="quicOverride")
    def quic_override(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the QUIC override policy for this resource. This determines
        whether the load balancer will attempt to negotiate QUIC with clients
        or not. Can specify one of NONE, ENABLE, or DISABLE. If NONE is
        specified, Google manages whether QUIC is used.
        Default value is `NONE`.
        Possible values are: `NONE`, `ENABLE`, `DISABLE`.
        """
        return pulumi.get(self, "quic_override")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serverTlsPolicy")
    def server_tls_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A URL referring to a networksecurity.ServerTlsPolicy
        resource that describes how the proxy should authenticate inbound
        traffic. serverTlsPolicy only applies to a global TargetHttpsProxy
        attached to globalForwardingRules with the loadBalancingScheme
        set to INTERNAL_SELF_MANAGED or EXTERNAL or EXTERNAL_MANAGED.
        For details which ServerTlsPolicy resources are accepted with
        INTERNAL_SELF_MANAGED and which with EXTERNAL, EXTERNAL_MANAGED
        loadBalancingScheme consult ServerTlsPolicy documentation.
        If left blank, communications are not encrypted.
        If you remove this field from your configuration at the same time as
        deleting or recreating a referenced ServerTlsPolicy resource, you will
        receive a resourceInUseByAnotherResource error. Use lifecycle.create_before_destroy
        within the ServerTlsPolicy resource to avoid this.
        """
        return pulumi.get(self, "server_tls_policy")

    @property
    @pulumi.getter(name="sslCertificates")
    def ssl_certificates(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        URLs to SslCertificate resources that are used to authenticate connections between users and the load balancer.
        Currently, you may specify up to 15 SSL certificates. sslCertificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.
        sslCertificates and certificateManagerCertificates can not be defined together.
        """
        return pulumi.get(self, "ssl_certificates")

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A reference to the SslPolicy resource that will be associated with
        the TargetHttpsProxy resource. If not set, the TargetHttpsProxy
        resource will not have any SSL policy configured.
        """
        return pulumi.get(self, "ssl_policy")

    @property
    @pulumi.getter(name="tlsEarlyData")
    def tls_early_data(self) -> pulumi.Output[builtins.str]:
        """
        Specifies whether TLS 1.3 0-RTT Data (“Early Data”) should be accepted for this service.
        Early Data allows a TLS resumption handshake to include the initial application payload
        (a HTTP request) alongside the handshake, reducing the effective round trips to “zero”.
        This applies to TLS 1.3 connections over TCP (HTTP/2) as well as over UDP (QUIC/h3).
        Possible values are: `STRICT`, `PERMISSIVE`, `UNRESTRICTED`, `DISABLED`.
        """
        return pulumi.get(self, "tls_early_data")

    @property
    @pulumi.getter(name="urlMap")
    def url_map(self) -> pulumi.Output[builtins.str]:
        """
        A reference to the UrlMap resource that defines the mapping from URL
        to the BackendService.


        - - -
        """
        return pulumi.get(self, "url_map")

