# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    """
    A collection of values returned by getCluster.
    """
    def __init__(__self__, addons_configs=None, allow_net_admin=None, authenticator_groups_configs=None, binary_authorizations=None, cluster_autoscalings=None, cluster_ipv4_cidr=None, cluster_telemetries=None, confidential_nodes=None, control_plane_endpoints_configs=None, cost_management_configs=None, database_encryptions=None, datapath_provider=None, default_max_pods_per_node=None, default_snat_statuses=None, deletion_protection=None, description=None, disable_l4_lb_firewall_reconciliation=None, dns_configs=None, effective_labels=None, enable_autopilot=None, enable_cilium_clusterwide_network_policy=None, enable_fqdn_network_policy=None, enable_intranode_visibility=None, enable_k8s_beta_apis=None, enable_kubernetes_alpha=None, enable_l4_ilb_subsetting=None, enable_legacy_abac=None, enable_multi_networking=None, enable_shielded_nodes=None, enable_tpu=None, endpoint=None, enterprise_configs=None, fleets=None, gateway_api_configs=None, gke_auto_upgrade_configs=None, id=None, identity_service_configs=None, in_transit_encryption_config=None, initial_node_count=None, ip_allocation_policies=None, label_fingerprint=None, location=None, logging_configs=None, logging_service=None, maintenance_policies=None, master_authorized_networks_configs=None, master_auths=None, master_version=None, mesh_certificates=None, min_master_version=None, monitoring_configs=None, monitoring_service=None, name=None, network=None, network_performance_configs=None, network_policies=None, networking_mode=None, node_configs=None, node_locations=None, node_pool_auto_configs=None, node_pool_defaults=None, node_pools=None, node_version=None, notification_configs=None, operation=None, pod_autoscalings=None, pod_security_policy_configs=None, private_cluster_configs=None, private_ipv6_google_access=None, project=None, protect_configs=None, pulumi_labels=None, release_channels=None, remove_default_node_pool=None, resource_labels=None, resource_usage_export_configs=None, secret_manager_configs=None, security_posture_configs=None, self_link=None, service_external_ips_configs=None, services_ipv4_cidr=None, subnetwork=None, tpu_configs=None, tpu_ipv4_cidr_block=None, user_managed_keys_configs=None, vertical_pod_autoscalings=None, workload_alts_configs=None, workload_identity_configs=None):
        if addons_configs and not isinstance(addons_configs, list):
            raise TypeError("Expected argument 'addons_configs' to be a list")
        pulumi.set(__self__, "addons_configs", addons_configs)
        if allow_net_admin and not isinstance(allow_net_admin, bool):
            raise TypeError("Expected argument 'allow_net_admin' to be a bool")
        pulumi.set(__self__, "allow_net_admin", allow_net_admin)
        if authenticator_groups_configs and not isinstance(authenticator_groups_configs, list):
            raise TypeError("Expected argument 'authenticator_groups_configs' to be a list")
        pulumi.set(__self__, "authenticator_groups_configs", authenticator_groups_configs)
        if binary_authorizations and not isinstance(binary_authorizations, list):
            raise TypeError("Expected argument 'binary_authorizations' to be a list")
        pulumi.set(__self__, "binary_authorizations", binary_authorizations)
        if cluster_autoscalings and not isinstance(cluster_autoscalings, list):
            raise TypeError("Expected argument 'cluster_autoscalings' to be a list")
        pulumi.set(__self__, "cluster_autoscalings", cluster_autoscalings)
        if cluster_ipv4_cidr and not isinstance(cluster_ipv4_cidr, str):
            raise TypeError("Expected argument 'cluster_ipv4_cidr' to be a str")
        pulumi.set(__self__, "cluster_ipv4_cidr", cluster_ipv4_cidr)
        if cluster_telemetries and not isinstance(cluster_telemetries, list):
            raise TypeError("Expected argument 'cluster_telemetries' to be a list")
        pulumi.set(__self__, "cluster_telemetries", cluster_telemetries)
        if confidential_nodes and not isinstance(confidential_nodes, list):
            raise TypeError("Expected argument 'confidential_nodes' to be a list")
        pulumi.set(__self__, "confidential_nodes", confidential_nodes)
        if control_plane_endpoints_configs and not isinstance(control_plane_endpoints_configs, list):
            raise TypeError("Expected argument 'control_plane_endpoints_configs' to be a list")
        pulumi.set(__self__, "control_plane_endpoints_configs", control_plane_endpoints_configs)
        if cost_management_configs and not isinstance(cost_management_configs, list):
            raise TypeError("Expected argument 'cost_management_configs' to be a list")
        pulumi.set(__self__, "cost_management_configs", cost_management_configs)
        if database_encryptions and not isinstance(database_encryptions, list):
            raise TypeError("Expected argument 'database_encryptions' to be a list")
        pulumi.set(__self__, "database_encryptions", database_encryptions)
        if datapath_provider and not isinstance(datapath_provider, str):
            raise TypeError("Expected argument 'datapath_provider' to be a str")
        pulumi.set(__self__, "datapath_provider", datapath_provider)
        if default_max_pods_per_node and not isinstance(default_max_pods_per_node, int):
            raise TypeError("Expected argument 'default_max_pods_per_node' to be a int")
        pulumi.set(__self__, "default_max_pods_per_node", default_max_pods_per_node)
        if default_snat_statuses and not isinstance(default_snat_statuses, list):
            raise TypeError("Expected argument 'default_snat_statuses' to be a list")
        pulumi.set(__self__, "default_snat_statuses", default_snat_statuses)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disable_l4_lb_firewall_reconciliation and not isinstance(disable_l4_lb_firewall_reconciliation, bool):
            raise TypeError("Expected argument 'disable_l4_lb_firewall_reconciliation' to be a bool")
        pulumi.set(__self__, "disable_l4_lb_firewall_reconciliation", disable_l4_lb_firewall_reconciliation)
        if dns_configs and not isinstance(dns_configs, list):
            raise TypeError("Expected argument 'dns_configs' to be a list")
        pulumi.set(__self__, "dns_configs", dns_configs)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_autopilot and not isinstance(enable_autopilot, bool):
            raise TypeError("Expected argument 'enable_autopilot' to be a bool")
        pulumi.set(__self__, "enable_autopilot", enable_autopilot)
        if enable_cilium_clusterwide_network_policy and not isinstance(enable_cilium_clusterwide_network_policy, bool):
            raise TypeError("Expected argument 'enable_cilium_clusterwide_network_policy' to be a bool")
        pulumi.set(__self__, "enable_cilium_clusterwide_network_policy", enable_cilium_clusterwide_network_policy)
        if enable_fqdn_network_policy and not isinstance(enable_fqdn_network_policy, bool):
            raise TypeError("Expected argument 'enable_fqdn_network_policy' to be a bool")
        pulumi.set(__self__, "enable_fqdn_network_policy", enable_fqdn_network_policy)
        if enable_intranode_visibility and not isinstance(enable_intranode_visibility, bool):
            raise TypeError("Expected argument 'enable_intranode_visibility' to be a bool")
        pulumi.set(__self__, "enable_intranode_visibility", enable_intranode_visibility)
        if enable_k8s_beta_apis and not isinstance(enable_k8s_beta_apis, list):
            raise TypeError("Expected argument 'enable_k8s_beta_apis' to be a list")
        pulumi.set(__self__, "enable_k8s_beta_apis", enable_k8s_beta_apis)
        if enable_kubernetes_alpha and not isinstance(enable_kubernetes_alpha, bool):
            raise TypeError("Expected argument 'enable_kubernetes_alpha' to be a bool")
        pulumi.set(__self__, "enable_kubernetes_alpha", enable_kubernetes_alpha)
        if enable_l4_ilb_subsetting and not isinstance(enable_l4_ilb_subsetting, bool):
            raise TypeError("Expected argument 'enable_l4_ilb_subsetting' to be a bool")
        pulumi.set(__self__, "enable_l4_ilb_subsetting", enable_l4_ilb_subsetting)
        if enable_legacy_abac and not isinstance(enable_legacy_abac, bool):
            raise TypeError("Expected argument 'enable_legacy_abac' to be a bool")
        pulumi.set(__self__, "enable_legacy_abac", enable_legacy_abac)
        if enable_multi_networking and not isinstance(enable_multi_networking, bool):
            raise TypeError("Expected argument 'enable_multi_networking' to be a bool")
        pulumi.set(__self__, "enable_multi_networking", enable_multi_networking)
        if enable_shielded_nodes and not isinstance(enable_shielded_nodes, bool):
            raise TypeError("Expected argument 'enable_shielded_nodes' to be a bool")
        pulumi.set(__self__, "enable_shielded_nodes", enable_shielded_nodes)
        if enable_tpu and not isinstance(enable_tpu, bool):
            raise TypeError("Expected argument 'enable_tpu' to be a bool")
        pulumi.set(__self__, "enable_tpu", enable_tpu)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if enterprise_configs and not isinstance(enterprise_configs, list):
            raise TypeError("Expected argument 'enterprise_configs' to be a list")
        pulumi.set(__self__, "enterprise_configs", enterprise_configs)
        if fleets and not isinstance(fleets, list):
            raise TypeError("Expected argument 'fleets' to be a list")
        pulumi.set(__self__, "fleets", fleets)
        if gateway_api_configs and not isinstance(gateway_api_configs, list):
            raise TypeError("Expected argument 'gateway_api_configs' to be a list")
        pulumi.set(__self__, "gateway_api_configs", gateway_api_configs)
        if gke_auto_upgrade_configs and not isinstance(gke_auto_upgrade_configs, list):
            raise TypeError("Expected argument 'gke_auto_upgrade_configs' to be a list")
        pulumi.set(__self__, "gke_auto_upgrade_configs", gke_auto_upgrade_configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity_service_configs and not isinstance(identity_service_configs, list):
            raise TypeError("Expected argument 'identity_service_configs' to be a list")
        pulumi.set(__self__, "identity_service_configs", identity_service_configs)
        if in_transit_encryption_config and not isinstance(in_transit_encryption_config, str):
            raise TypeError("Expected argument 'in_transit_encryption_config' to be a str")
        pulumi.set(__self__, "in_transit_encryption_config", in_transit_encryption_config)
        if initial_node_count and not isinstance(initial_node_count, int):
            raise TypeError("Expected argument 'initial_node_count' to be a int")
        pulumi.set(__self__, "initial_node_count", initial_node_count)
        if ip_allocation_policies and not isinstance(ip_allocation_policies, list):
            raise TypeError("Expected argument 'ip_allocation_policies' to be a list")
        pulumi.set(__self__, "ip_allocation_policies", ip_allocation_policies)
        if label_fingerprint and not isinstance(label_fingerprint, str):
            raise TypeError("Expected argument 'label_fingerprint' to be a str")
        pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if logging_configs and not isinstance(logging_configs, list):
            raise TypeError("Expected argument 'logging_configs' to be a list")
        pulumi.set(__self__, "logging_configs", logging_configs)
        if logging_service and not isinstance(logging_service, str):
            raise TypeError("Expected argument 'logging_service' to be a str")
        pulumi.set(__self__, "logging_service", logging_service)
        if maintenance_policies and not isinstance(maintenance_policies, list):
            raise TypeError("Expected argument 'maintenance_policies' to be a list")
        pulumi.set(__self__, "maintenance_policies", maintenance_policies)
        if master_authorized_networks_configs and not isinstance(master_authorized_networks_configs, list):
            raise TypeError("Expected argument 'master_authorized_networks_configs' to be a list")
        pulumi.set(__self__, "master_authorized_networks_configs", master_authorized_networks_configs)
        if master_auths and not isinstance(master_auths, list):
            raise TypeError("Expected argument 'master_auths' to be a list")
        pulumi.set(__self__, "master_auths", master_auths)
        if master_version and not isinstance(master_version, str):
            raise TypeError("Expected argument 'master_version' to be a str")
        pulumi.set(__self__, "master_version", master_version)
        if mesh_certificates and not isinstance(mesh_certificates, list):
            raise TypeError("Expected argument 'mesh_certificates' to be a list")
        pulumi.set(__self__, "mesh_certificates", mesh_certificates)
        if min_master_version and not isinstance(min_master_version, str):
            raise TypeError("Expected argument 'min_master_version' to be a str")
        pulumi.set(__self__, "min_master_version", min_master_version)
        if monitoring_configs and not isinstance(monitoring_configs, list):
            raise TypeError("Expected argument 'monitoring_configs' to be a list")
        pulumi.set(__self__, "monitoring_configs", monitoring_configs)
        if monitoring_service and not isinstance(monitoring_service, str):
            raise TypeError("Expected argument 'monitoring_service' to be a str")
        pulumi.set(__self__, "monitoring_service", monitoring_service)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network and not isinstance(network, str):
            raise TypeError("Expected argument 'network' to be a str")
        pulumi.set(__self__, "network", network)
        if network_performance_configs and not isinstance(network_performance_configs, list):
            raise TypeError("Expected argument 'network_performance_configs' to be a list")
        pulumi.set(__self__, "network_performance_configs", network_performance_configs)
        if network_policies and not isinstance(network_policies, list):
            raise TypeError("Expected argument 'network_policies' to be a list")
        pulumi.set(__self__, "network_policies", network_policies)
        if networking_mode and not isinstance(networking_mode, str):
            raise TypeError("Expected argument 'networking_mode' to be a str")
        pulumi.set(__self__, "networking_mode", networking_mode)
        if node_configs and not isinstance(node_configs, list):
            raise TypeError("Expected argument 'node_configs' to be a list")
        pulumi.set(__self__, "node_configs", node_configs)
        if node_locations and not isinstance(node_locations, list):
            raise TypeError("Expected argument 'node_locations' to be a list")
        pulumi.set(__self__, "node_locations", node_locations)
        if node_pool_auto_configs and not isinstance(node_pool_auto_configs, list):
            raise TypeError("Expected argument 'node_pool_auto_configs' to be a list")
        pulumi.set(__self__, "node_pool_auto_configs", node_pool_auto_configs)
        if node_pool_defaults and not isinstance(node_pool_defaults, list):
            raise TypeError("Expected argument 'node_pool_defaults' to be a list")
        pulumi.set(__self__, "node_pool_defaults", node_pool_defaults)
        if node_pools and not isinstance(node_pools, list):
            raise TypeError("Expected argument 'node_pools' to be a list")
        pulumi.set(__self__, "node_pools", node_pools)
        if node_version and not isinstance(node_version, str):
            raise TypeError("Expected argument 'node_version' to be a str")
        pulumi.set(__self__, "node_version", node_version)
        if notification_configs and not isinstance(notification_configs, list):
            raise TypeError("Expected argument 'notification_configs' to be a list")
        pulumi.set(__self__, "notification_configs", notification_configs)
        if operation and not isinstance(operation, str):
            raise TypeError("Expected argument 'operation' to be a str")
        pulumi.set(__self__, "operation", operation)
        if pod_autoscalings and not isinstance(pod_autoscalings, list):
            raise TypeError("Expected argument 'pod_autoscalings' to be a list")
        pulumi.set(__self__, "pod_autoscalings", pod_autoscalings)
        if pod_security_policy_configs and not isinstance(pod_security_policy_configs, list):
            raise TypeError("Expected argument 'pod_security_policy_configs' to be a list")
        pulumi.set(__self__, "pod_security_policy_configs", pod_security_policy_configs)
        if private_cluster_configs and not isinstance(private_cluster_configs, list):
            raise TypeError("Expected argument 'private_cluster_configs' to be a list")
        pulumi.set(__self__, "private_cluster_configs", private_cluster_configs)
        if private_ipv6_google_access and not isinstance(private_ipv6_google_access, str):
            raise TypeError("Expected argument 'private_ipv6_google_access' to be a str")
        pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if protect_configs and not isinstance(protect_configs, list):
            raise TypeError("Expected argument 'protect_configs' to be a list")
        pulumi.set(__self__, "protect_configs", protect_configs)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if release_channels and not isinstance(release_channels, list):
            raise TypeError("Expected argument 'release_channels' to be a list")
        pulumi.set(__self__, "release_channels", release_channels)
        if remove_default_node_pool and not isinstance(remove_default_node_pool, bool):
            raise TypeError("Expected argument 'remove_default_node_pool' to be a bool")
        pulumi.set(__self__, "remove_default_node_pool", remove_default_node_pool)
        if resource_labels and not isinstance(resource_labels, dict):
            raise TypeError("Expected argument 'resource_labels' to be a dict")
        pulumi.set(__self__, "resource_labels", resource_labels)
        if resource_usage_export_configs and not isinstance(resource_usage_export_configs, list):
            raise TypeError("Expected argument 'resource_usage_export_configs' to be a list")
        pulumi.set(__self__, "resource_usage_export_configs", resource_usage_export_configs)
        if secret_manager_configs and not isinstance(secret_manager_configs, list):
            raise TypeError("Expected argument 'secret_manager_configs' to be a list")
        pulumi.set(__self__, "secret_manager_configs", secret_manager_configs)
        if security_posture_configs and not isinstance(security_posture_configs, list):
            raise TypeError("Expected argument 'security_posture_configs' to be a list")
        pulumi.set(__self__, "security_posture_configs", security_posture_configs)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if service_external_ips_configs and not isinstance(service_external_ips_configs, list):
            raise TypeError("Expected argument 'service_external_ips_configs' to be a list")
        pulumi.set(__self__, "service_external_ips_configs", service_external_ips_configs)
        if services_ipv4_cidr and not isinstance(services_ipv4_cidr, str):
            raise TypeError("Expected argument 'services_ipv4_cidr' to be a str")
        pulumi.set(__self__, "services_ipv4_cidr", services_ipv4_cidr)
        if subnetwork and not isinstance(subnetwork, str):
            raise TypeError("Expected argument 'subnetwork' to be a str")
        pulumi.set(__self__, "subnetwork", subnetwork)
        if tpu_configs and not isinstance(tpu_configs, list):
            raise TypeError("Expected argument 'tpu_configs' to be a list")
        pulumi.set(__self__, "tpu_configs", tpu_configs)
        if tpu_ipv4_cidr_block and not isinstance(tpu_ipv4_cidr_block, str):
            raise TypeError("Expected argument 'tpu_ipv4_cidr_block' to be a str")
        pulumi.set(__self__, "tpu_ipv4_cidr_block", tpu_ipv4_cidr_block)
        if user_managed_keys_configs and not isinstance(user_managed_keys_configs, list):
            raise TypeError("Expected argument 'user_managed_keys_configs' to be a list")
        pulumi.set(__self__, "user_managed_keys_configs", user_managed_keys_configs)
        if vertical_pod_autoscalings and not isinstance(vertical_pod_autoscalings, list):
            raise TypeError("Expected argument 'vertical_pod_autoscalings' to be a list")
        pulumi.set(__self__, "vertical_pod_autoscalings", vertical_pod_autoscalings)
        if workload_alts_configs and not isinstance(workload_alts_configs, list):
            raise TypeError("Expected argument 'workload_alts_configs' to be a list")
        pulumi.set(__self__, "workload_alts_configs", workload_alts_configs)
        if workload_identity_configs and not isinstance(workload_identity_configs, list):
            raise TypeError("Expected argument 'workload_identity_configs' to be a list")
        pulumi.set(__self__, "workload_identity_configs", workload_identity_configs)

    @property
    @pulumi.getter(name="addonsConfigs")
    def addons_configs(self) -> Sequence['outputs.GetClusterAddonsConfigResult']:
        return pulumi.get(self, "addons_configs")

    @property
    @pulumi.getter(name="allowNetAdmin")
    def allow_net_admin(self) -> builtins.bool:
        return pulumi.get(self, "allow_net_admin")

    @property
    @pulumi.getter(name="authenticatorGroupsConfigs")
    def authenticator_groups_configs(self) -> Sequence['outputs.GetClusterAuthenticatorGroupsConfigResult']:
        return pulumi.get(self, "authenticator_groups_configs")

    @property
    @pulumi.getter(name="binaryAuthorizations")
    def binary_authorizations(self) -> Sequence['outputs.GetClusterBinaryAuthorizationResult']:
        return pulumi.get(self, "binary_authorizations")

    @property
    @pulumi.getter(name="clusterAutoscalings")
    def cluster_autoscalings(self) -> Sequence['outputs.GetClusterClusterAutoscalingResult']:
        return pulumi.get(self, "cluster_autoscalings")

    @property
    @pulumi.getter(name="clusterIpv4Cidr")
    def cluster_ipv4_cidr(self) -> builtins.str:
        return pulumi.get(self, "cluster_ipv4_cidr")

    @property
    @pulumi.getter(name="clusterTelemetries")
    def cluster_telemetries(self) -> Sequence['outputs.GetClusterClusterTelemetryResult']:
        return pulumi.get(self, "cluster_telemetries")

    @property
    @pulumi.getter(name="confidentialNodes")
    def confidential_nodes(self) -> Sequence['outputs.GetClusterConfidentialNodeResult']:
        return pulumi.get(self, "confidential_nodes")

    @property
    @pulumi.getter(name="controlPlaneEndpointsConfigs")
    def control_plane_endpoints_configs(self) -> Sequence['outputs.GetClusterControlPlaneEndpointsConfigResult']:
        return pulumi.get(self, "control_plane_endpoints_configs")

    @property
    @pulumi.getter(name="costManagementConfigs")
    def cost_management_configs(self) -> Sequence['outputs.GetClusterCostManagementConfigResult']:
        return pulumi.get(self, "cost_management_configs")

    @property
    @pulumi.getter(name="databaseEncryptions")
    def database_encryptions(self) -> Sequence['outputs.GetClusterDatabaseEncryptionResult']:
        return pulumi.get(self, "database_encryptions")

    @property
    @pulumi.getter(name="datapathProvider")
    def datapath_provider(self) -> builtins.str:
        return pulumi.get(self, "datapath_provider")

    @property
    @pulumi.getter(name="defaultMaxPodsPerNode")
    def default_max_pods_per_node(self) -> builtins.int:
        return pulumi.get(self, "default_max_pods_per_node")

    @property
    @pulumi.getter(name="defaultSnatStatuses")
    def default_snat_statuses(self) -> Sequence['outputs.GetClusterDefaultSnatStatusResult']:
        return pulumi.get(self, "default_snat_statuses")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> builtins.bool:
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableL4LbFirewallReconciliation")
    def disable_l4_lb_firewall_reconciliation(self) -> builtins.bool:
        return pulumi.get(self, "disable_l4_lb_firewall_reconciliation")

    @property
    @pulumi.getter(name="dnsConfigs")
    def dns_configs(self) -> Sequence['outputs.GetClusterDnsConfigResult']:
        return pulumi.get(self, "dns_configs")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="enableAutopilot")
    def enable_autopilot(self) -> builtins.bool:
        return pulumi.get(self, "enable_autopilot")

    @property
    @pulumi.getter(name="enableCiliumClusterwideNetworkPolicy")
    def enable_cilium_clusterwide_network_policy(self) -> builtins.bool:
        return pulumi.get(self, "enable_cilium_clusterwide_network_policy")

    @property
    @pulumi.getter(name="enableFqdnNetworkPolicy")
    def enable_fqdn_network_policy(self) -> builtins.bool:
        return pulumi.get(self, "enable_fqdn_network_policy")

    @property
    @pulumi.getter(name="enableIntranodeVisibility")
    def enable_intranode_visibility(self) -> builtins.bool:
        return pulumi.get(self, "enable_intranode_visibility")

    @property
    @pulumi.getter(name="enableK8sBetaApis")
    def enable_k8s_beta_apis(self) -> Sequence['outputs.GetClusterEnableK8sBetaApiResult']:
        return pulumi.get(self, "enable_k8s_beta_apis")

    @property
    @pulumi.getter(name="enableKubernetesAlpha")
    def enable_kubernetes_alpha(self) -> builtins.bool:
        return pulumi.get(self, "enable_kubernetes_alpha")

    @property
    @pulumi.getter(name="enableL4IlbSubsetting")
    def enable_l4_ilb_subsetting(self) -> builtins.bool:
        return pulumi.get(self, "enable_l4_ilb_subsetting")

    @property
    @pulumi.getter(name="enableLegacyAbac")
    def enable_legacy_abac(self) -> builtins.bool:
        return pulumi.get(self, "enable_legacy_abac")

    @property
    @pulumi.getter(name="enableMultiNetworking")
    def enable_multi_networking(self) -> builtins.bool:
        return pulumi.get(self, "enable_multi_networking")

    @property
    @pulumi.getter(name="enableShieldedNodes")
    def enable_shielded_nodes(self) -> builtins.bool:
        return pulumi.get(self, "enable_shielded_nodes")

    @property
    @pulumi.getter(name="enableTpu")
    def enable_tpu(self) -> builtins.bool:
        return pulumi.get(self, "enable_tpu")

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="enterpriseConfigs")
    def enterprise_configs(self) -> Sequence['outputs.GetClusterEnterpriseConfigResult']:
        return pulumi.get(self, "enterprise_configs")

    @property
    @pulumi.getter
    def fleets(self) -> Sequence['outputs.GetClusterFleetResult']:
        return pulumi.get(self, "fleets")

    @property
    @pulumi.getter(name="gatewayApiConfigs")
    def gateway_api_configs(self) -> Sequence['outputs.GetClusterGatewayApiConfigResult']:
        return pulumi.get(self, "gateway_api_configs")

    @property
    @pulumi.getter(name="gkeAutoUpgradeConfigs")
    def gke_auto_upgrade_configs(self) -> Sequence['outputs.GetClusterGkeAutoUpgradeConfigResult']:
        return pulumi.get(self, "gke_auto_upgrade_configs")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="identityServiceConfigs")
    def identity_service_configs(self) -> Sequence['outputs.GetClusterIdentityServiceConfigResult']:
        return pulumi.get(self, "identity_service_configs")

    @property
    @pulumi.getter(name="inTransitEncryptionConfig")
    def in_transit_encryption_config(self) -> builtins.str:
        return pulumi.get(self, "in_transit_encryption_config")

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> builtins.int:
        return pulumi.get(self, "initial_node_count")

    @property
    @pulumi.getter(name="ipAllocationPolicies")
    def ip_allocation_policies(self) -> Sequence['outputs.GetClusterIpAllocationPolicyResult']:
        return pulumi.get(self, "ip_allocation_policies")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> builtins.str:
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="loggingConfigs")
    def logging_configs(self) -> Sequence['outputs.GetClusterLoggingConfigResult']:
        return pulumi.get(self, "logging_configs")

    @property
    @pulumi.getter(name="loggingService")
    def logging_service(self) -> builtins.str:
        return pulumi.get(self, "logging_service")

    @property
    @pulumi.getter(name="maintenancePolicies")
    def maintenance_policies(self) -> Sequence['outputs.GetClusterMaintenancePolicyResult']:
        return pulumi.get(self, "maintenance_policies")

    @property
    @pulumi.getter(name="masterAuthorizedNetworksConfigs")
    def master_authorized_networks_configs(self) -> Sequence['outputs.GetClusterMasterAuthorizedNetworksConfigResult']:
        return pulumi.get(self, "master_authorized_networks_configs")

    @property
    @pulumi.getter(name="masterAuths")
    def master_auths(self) -> Sequence['outputs.GetClusterMasterAuthResult']:
        return pulumi.get(self, "master_auths")

    @property
    @pulumi.getter(name="masterVersion")
    def master_version(self) -> builtins.str:
        return pulumi.get(self, "master_version")

    @property
    @pulumi.getter(name="meshCertificates")
    def mesh_certificates(self) -> Sequence['outputs.GetClusterMeshCertificateResult']:
        return pulumi.get(self, "mesh_certificates")

    @property
    @pulumi.getter(name="minMasterVersion")
    def min_master_version(self) -> builtins.str:
        return pulumi.get(self, "min_master_version")

    @property
    @pulumi.getter(name="monitoringConfigs")
    def monitoring_configs(self) -> Sequence['outputs.GetClusterMonitoringConfigResult']:
        return pulumi.get(self, "monitoring_configs")

    @property
    @pulumi.getter(name="monitoringService")
    def monitoring_service(self) -> builtins.str:
        return pulumi.get(self, "monitoring_service")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> builtins.str:
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkPerformanceConfigs")
    def network_performance_configs(self) -> Sequence['outputs.GetClusterNetworkPerformanceConfigResult']:
        return pulumi.get(self, "network_performance_configs")

    @property
    @pulumi.getter(name="networkPolicies")
    def network_policies(self) -> Sequence['outputs.GetClusterNetworkPolicyResult']:
        return pulumi.get(self, "network_policies")

    @property
    @pulumi.getter(name="networkingMode")
    def networking_mode(self) -> builtins.str:
        return pulumi.get(self, "networking_mode")

    @property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> Sequence['outputs.GetClusterNodeConfigResult']:
        return pulumi.get(self, "node_configs")

    @property
    @pulumi.getter(name="nodeLocations")
    def node_locations(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "node_locations")

    @property
    @pulumi.getter(name="nodePoolAutoConfigs")
    def node_pool_auto_configs(self) -> Sequence['outputs.GetClusterNodePoolAutoConfigResult']:
        return pulumi.get(self, "node_pool_auto_configs")

    @property
    @pulumi.getter(name="nodePoolDefaults")
    def node_pool_defaults(self) -> Sequence['outputs.GetClusterNodePoolDefaultResult']:
        return pulumi.get(self, "node_pool_defaults")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Sequence['outputs.GetClusterNodePoolResult']:
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="nodeVersion")
    def node_version(self) -> builtins.str:
        return pulumi.get(self, "node_version")

    @property
    @pulumi.getter(name="notificationConfigs")
    def notification_configs(self) -> Sequence['outputs.GetClusterNotificationConfigResult']:
        return pulumi.get(self, "notification_configs")

    @property
    @pulumi.getter
    def operation(self) -> builtins.str:
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter(name="podAutoscalings")
    def pod_autoscalings(self) -> Sequence['outputs.GetClusterPodAutoscalingResult']:
        return pulumi.get(self, "pod_autoscalings")

    @property
    @pulumi.getter(name="podSecurityPolicyConfigs")
    def pod_security_policy_configs(self) -> Sequence['outputs.GetClusterPodSecurityPolicyConfigResult']:
        return pulumi.get(self, "pod_security_policy_configs")

    @property
    @pulumi.getter(name="privateClusterConfigs")
    def private_cluster_configs(self) -> Sequence['outputs.GetClusterPrivateClusterConfigResult']:
        return pulumi.get(self, "private_cluster_configs")

    @property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> builtins.str:
        return pulumi.get(self, "private_ipv6_google_access")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="protectConfigs")
    def protect_configs(self) -> Sequence['outputs.GetClusterProtectConfigResult']:
        return pulumi.get(self, "protect_configs")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="releaseChannels")
    def release_channels(self) -> Sequence['outputs.GetClusterReleaseChannelResult']:
        return pulumi.get(self, "release_channels")

    @property
    @pulumi.getter(name="removeDefaultNodePool")
    def remove_default_node_pool(self) -> builtins.bool:
        return pulumi.get(self, "remove_default_node_pool")

    @property
    @pulumi.getter(name="resourceLabels")
    def resource_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "resource_labels")

    @property
    @pulumi.getter(name="resourceUsageExportConfigs")
    def resource_usage_export_configs(self) -> Sequence['outputs.GetClusterResourceUsageExportConfigResult']:
        return pulumi.get(self, "resource_usage_export_configs")

    @property
    @pulumi.getter(name="secretManagerConfigs")
    def secret_manager_configs(self) -> Sequence['outputs.GetClusterSecretManagerConfigResult']:
        return pulumi.get(self, "secret_manager_configs")

    @property
    @pulumi.getter(name="securityPostureConfigs")
    def security_posture_configs(self) -> Sequence['outputs.GetClusterSecurityPostureConfigResult']:
        return pulumi.get(self, "security_posture_configs")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serviceExternalIpsConfigs")
    def service_external_ips_configs(self) -> Sequence['outputs.GetClusterServiceExternalIpsConfigResult']:
        return pulumi.get(self, "service_external_ips_configs")

    @property
    @pulumi.getter(name="servicesIpv4Cidr")
    def services_ipv4_cidr(self) -> builtins.str:
        return pulumi.get(self, "services_ipv4_cidr")

    @property
    @pulumi.getter
    def subnetwork(self) -> builtins.str:
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter(name="tpuConfigs")
    def tpu_configs(self) -> Sequence['outputs.GetClusterTpuConfigResult']:
        return pulumi.get(self, "tpu_configs")

    @property
    @pulumi.getter(name="tpuIpv4CidrBlock")
    def tpu_ipv4_cidr_block(self) -> builtins.str:
        return pulumi.get(self, "tpu_ipv4_cidr_block")

    @property
    @pulumi.getter(name="userManagedKeysConfigs")
    def user_managed_keys_configs(self) -> Sequence['outputs.GetClusterUserManagedKeysConfigResult']:
        return pulumi.get(self, "user_managed_keys_configs")

    @property
    @pulumi.getter(name="verticalPodAutoscalings")
    def vertical_pod_autoscalings(self) -> Sequence['outputs.GetClusterVerticalPodAutoscalingResult']:
        return pulumi.get(self, "vertical_pod_autoscalings")

    @property
    @pulumi.getter(name="workloadAltsConfigs")
    def workload_alts_configs(self) -> Sequence['outputs.GetClusterWorkloadAltsConfigResult']:
        return pulumi.get(self, "workload_alts_configs")

    @property
    @pulumi.getter(name="workloadIdentityConfigs")
    def workload_identity_configs(self) -> Sequence['outputs.GetClusterWorkloadIdentityConfigResult']:
        return pulumi.get(self, "workload_identity_configs")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            addons_configs=self.addons_configs,
            allow_net_admin=self.allow_net_admin,
            authenticator_groups_configs=self.authenticator_groups_configs,
            binary_authorizations=self.binary_authorizations,
            cluster_autoscalings=self.cluster_autoscalings,
            cluster_ipv4_cidr=self.cluster_ipv4_cidr,
            cluster_telemetries=self.cluster_telemetries,
            confidential_nodes=self.confidential_nodes,
            control_plane_endpoints_configs=self.control_plane_endpoints_configs,
            cost_management_configs=self.cost_management_configs,
            database_encryptions=self.database_encryptions,
            datapath_provider=self.datapath_provider,
            default_max_pods_per_node=self.default_max_pods_per_node,
            default_snat_statuses=self.default_snat_statuses,
            deletion_protection=self.deletion_protection,
            description=self.description,
            disable_l4_lb_firewall_reconciliation=self.disable_l4_lb_firewall_reconciliation,
            dns_configs=self.dns_configs,
            effective_labels=self.effective_labels,
            enable_autopilot=self.enable_autopilot,
            enable_cilium_clusterwide_network_policy=self.enable_cilium_clusterwide_network_policy,
            enable_fqdn_network_policy=self.enable_fqdn_network_policy,
            enable_intranode_visibility=self.enable_intranode_visibility,
            enable_k8s_beta_apis=self.enable_k8s_beta_apis,
            enable_kubernetes_alpha=self.enable_kubernetes_alpha,
            enable_l4_ilb_subsetting=self.enable_l4_ilb_subsetting,
            enable_legacy_abac=self.enable_legacy_abac,
            enable_multi_networking=self.enable_multi_networking,
            enable_shielded_nodes=self.enable_shielded_nodes,
            enable_tpu=self.enable_tpu,
            endpoint=self.endpoint,
            enterprise_configs=self.enterprise_configs,
            fleets=self.fleets,
            gateway_api_configs=self.gateway_api_configs,
            gke_auto_upgrade_configs=self.gke_auto_upgrade_configs,
            id=self.id,
            identity_service_configs=self.identity_service_configs,
            in_transit_encryption_config=self.in_transit_encryption_config,
            initial_node_count=self.initial_node_count,
            ip_allocation_policies=self.ip_allocation_policies,
            label_fingerprint=self.label_fingerprint,
            location=self.location,
            logging_configs=self.logging_configs,
            logging_service=self.logging_service,
            maintenance_policies=self.maintenance_policies,
            master_authorized_networks_configs=self.master_authorized_networks_configs,
            master_auths=self.master_auths,
            master_version=self.master_version,
            mesh_certificates=self.mesh_certificates,
            min_master_version=self.min_master_version,
            monitoring_configs=self.monitoring_configs,
            monitoring_service=self.monitoring_service,
            name=self.name,
            network=self.network,
            network_performance_configs=self.network_performance_configs,
            network_policies=self.network_policies,
            networking_mode=self.networking_mode,
            node_configs=self.node_configs,
            node_locations=self.node_locations,
            node_pool_auto_configs=self.node_pool_auto_configs,
            node_pool_defaults=self.node_pool_defaults,
            node_pools=self.node_pools,
            node_version=self.node_version,
            notification_configs=self.notification_configs,
            operation=self.operation,
            pod_autoscalings=self.pod_autoscalings,
            pod_security_policy_configs=self.pod_security_policy_configs,
            private_cluster_configs=self.private_cluster_configs,
            private_ipv6_google_access=self.private_ipv6_google_access,
            project=self.project,
            protect_configs=self.protect_configs,
            pulumi_labels=self.pulumi_labels,
            release_channels=self.release_channels,
            remove_default_node_pool=self.remove_default_node_pool,
            resource_labels=self.resource_labels,
            resource_usage_export_configs=self.resource_usage_export_configs,
            secret_manager_configs=self.secret_manager_configs,
            security_posture_configs=self.security_posture_configs,
            self_link=self.self_link,
            service_external_ips_configs=self.service_external_ips_configs,
            services_ipv4_cidr=self.services_ipv4_cidr,
            subnetwork=self.subnetwork,
            tpu_configs=self.tpu_configs,
            tpu_ipv4_cidr_block=self.tpu_ipv4_cidr_block,
            user_managed_keys_configs=self.user_managed_keys_configs,
            vertical_pod_autoscalings=self.vertical_pod_autoscalings,
            workload_alts_configs=self.workload_alts_configs,
            workload_identity_configs=self.workload_identity_configs)


def get_cluster(location: Optional[builtins.str] = None,
                name: Optional[builtins.str] = None,
                project: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    Get info about a GKE cluster from its name and location.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_cluster = gcp.container.get_cluster(name="my-cluster",
        location="us-east1-a")
    pulumi.export("endpoint", my_cluster.endpoint)
    pulumi.export("instanceGroupUrls", my_cluster.node_pools[0].instance_group_urls)
    pulumi.export("nodeConfig", my_cluster.node_configs)
    pulumi.export("nodePools", my_cluster.node_pools)
    ```


    :param builtins.str location: The location (zone or region) this cluster has been
           created in. One of `location`, `region`, `zone`, or a provider-level `zone` must
           be specified.
    :param builtins.str name: The name of the cluster.
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:container/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        addons_configs=pulumi.get(__ret__, 'addons_configs'),
        allow_net_admin=pulumi.get(__ret__, 'allow_net_admin'),
        authenticator_groups_configs=pulumi.get(__ret__, 'authenticator_groups_configs'),
        binary_authorizations=pulumi.get(__ret__, 'binary_authorizations'),
        cluster_autoscalings=pulumi.get(__ret__, 'cluster_autoscalings'),
        cluster_ipv4_cidr=pulumi.get(__ret__, 'cluster_ipv4_cidr'),
        cluster_telemetries=pulumi.get(__ret__, 'cluster_telemetries'),
        confidential_nodes=pulumi.get(__ret__, 'confidential_nodes'),
        control_plane_endpoints_configs=pulumi.get(__ret__, 'control_plane_endpoints_configs'),
        cost_management_configs=pulumi.get(__ret__, 'cost_management_configs'),
        database_encryptions=pulumi.get(__ret__, 'database_encryptions'),
        datapath_provider=pulumi.get(__ret__, 'datapath_provider'),
        default_max_pods_per_node=pulumi.get(__ret__, 'default_max_pods_per_node'),
        default_snat_statuses=pulumi.get(__ret__, 'default_snat_statuses'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        disable_l4_lb_firewall_reconciliation=pulumi.get(__ret__, 'disable_l4_lb_firewall_reconciliation'),
        dns_configs=pulumi.get(__ret__, 'dns_configs'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        enable_autopilot=pulumi.get(__ret__, 'enable_autopilot'),
        enable_cilium_clusterwide_network_policy=pulumi.get(__ret__, 'enable_cilium_clusterwide_network_policy'),
        enable_fqdn_network_policy=pulumi.get(__ret__, 'enable_fqdn_network_policy'),
        enable_intranode_visibility=pulumi.get(__ret__, 'enable_intranode_visibility'),
        enable_k8s_beta_apis=pulumi.get(__ret__, 'enable_k8s_beta_apis'),
        enable_kubernetes_alpha=pulumi.get(__ret__, 'enable_kubernetes_alpha'),
        enable_l4_ilb_subsetting=pulumi.get(__ret__, 'enable_l4_ilb_subsetting'),
        enable_legacy_abac=pulumi.get(__ret__, 'enable_legacy_abac'),
        enable_multi_networking=pulumi.get(__ret__, 'enable_multi_networking'),
        enable_shielded_nodes=pulumi.get(__ret__, 'enable_shielded_nodes'),
        enable_tpu=pulumi.get(__ret__, 'enable_tpu'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        enterprise_configs=pulumi.get(__ret__, 'enterprise_configs'),
        fleets=pulumi.get(__ret__, 'fleets'),
        gateway_api_configs=pulumi.get(__ret__, 'gateway_api_configs'),
        gke_auto_upgrade_configs=pulumi.get(__ret__, 'gke_auto_upgrade_configs'),
        id=pulumi.get(__ret__, 'id'),
        identity_service_configs=pulumi.get(__ret__, 'identity_service_configs'),
        in_transit_encryption_config=pulumi.get(__ret__, 'in_transit_encryption_config'),
        initial_node_count=pulumi.get(__ret__, 'initial_node_count'),
        ip_allocation_policies=pulumi.get(__ret__, 'ip_allocation_policies'),
        label_fingerprint=pulumi.get(__ret__, 'label_fingerprint'),
        location=pulumi.get(__ret__, 'location'),
        logging_configs=pulumi.get(__ret__, 'logging_configs'),
        logging_service=pulumi.get(__ret__, 'logging_service'),
        maintenance_policies=pulumi.get(__ret__, 'maintenance_policies'),
        master_authorized_networks_configs=pulumi.get(__ret__, 'master_authorized_networks_configs'),
        master_auths=pulumi.get(__ret__, 'master_auths'),
        master_version=pulumi.get(__ret__, 'master_version'),
        mesh_certificates=pulumi.get(__ret__, 'mesh_certificates'),
        min_master_version=pulumi.get(__ret__, 'min_master_version'),
        monitoring_configs=pulumi.get(__ret__, 'monitoring_configs'),
        monitoring_service=pulumi.get(__ret__, 'monitoring_service'),
        name=pulumi.get(__ret__, 'name'),
        network=pulumi.get(__ret__, 'network'),
        network_performance_configs=pulumi.get(__ret__, 'network_performance_configs'),
        network_policies=pulumi.get(__ret__, 'network_policies'),
        networking_mode=pulumi.get(__ret__, 'networking_mode'),
        node_configs=pulumi.get(__ret__, 'node_configs'),
        node_locations=pulumi.get(__ret__, 'node_locations'),
        node_pool_auto_configs=pulumi.get(__ret__, 'node_pool_auto_configs'),
        node_pool_defaults=pulumi.get(__ret__, 'node_pool_defaults'),
        node_pools=pulumi.get(__ret__, 'node_pools'),
        node_version=pulumi.get(__ret__, 'node_version'),
        notification_configs=pulumi.get(__ret__, 'notification_configs'),
        operation=pulumi.get(__ret__, 'operation'),
        pod_autoscalings=pulumi.get(__ret__, 'pod_autoscalings'),
        pod_security_policy_configs=pulumi.get(__ret__, 'pod_security_policy_configs'),
        private_cluster_configs=pulumi.get(__ret__, 'private_cluster_configs'),
        private_ipv6_google_access=pulumi.get(__ret__, 'private_ipv6_google_access'),
        project=pulumi.get(__ret__, 'project'),
        protect_configs=pulumi.get(__ret__, 'protect_configs'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        release_channels=pulumi.get(__ret__, 'release_channels'),
        remove_default_node_pool=pulumi.get(__ret__, 'remove_default_node_pool'),
        resource_labels=pulumi.get(__ret__, 'resource_labels'),
        resource_usage_export_configs=pulumi.get(__ret__, 'resource_usage_export_configs'),
        secret_manager_configs=pulumi.get(__ret__, 'secret_manager_configs'),
        security_posture_configs=pulumi.get(__ret__, 'security_posture_configs'),
        self_link=pulumi.get(__ret__, 'self_link'),
        service_external_ips_configs=pulumi.get(__ret__, 'service_external_ips_configs'),
        services_ipv4_cidr=pulumi.get(__ret__, 'services_ipv4_cidr'),
        subnetwork=pulumi.get(__ret__, 'subnetwork'),
        tpu_configs=pulumi.get(__ret__, 'tpu_configs'),
        tpu_ipv4_cidr_block=pulumi.get(__ret__, 'tpu_ipv4_cidr_block'),
        user_managed_keys_configs=pulumi.get(__ret__, 'user_managed_keys_configs'),
        vertical_pod_autoscalings=pulumi.get(__ret__, 'vertical_pod_autoscalings'),
        workload_alts_configs=pulumi.get(__ret__, 'workload_alts_configs'),
        workload_identity_configs=pulumi.get(__ret__, 'workload_identity_configs'))
def get_cluster_output(location: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       name: Optional[pulumi.Input[builtins.str]] = None,
                       project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterResult]:
    """
    Get info about a GKE cluster from its name and location.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_cluster = gcp.container.get_cluster(name="my-cluster",
        location="us-east1-a")
    pulumi.export("endpoint", my_cluster.endpoint)
    pulumi.export("instanceGroupUrls", my_cluster.node_pools[0].instance_group_urls)
    pulumi.export("nodeConfig", my_cluster.node_configs)
    pulumi.export("nodePools", my_cluster.node_pools)
    ```


    :param builtins.str location: The location (zone or region) this cluster has been
           created in. One of `location`, `region`, `zone`, or a provider-level `zone` must
           be specified.
    :param builtins.str name: The name of the cluster.
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:container/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult)
    return __ret__.apply(lambda __response__: GetClusterResult(
        addons_configs=pulumi.get(__response__, 'addons_configs'),
        allow_net_admin=pulumi.get(__response__, 'allow_net_admin'),
        authenticator_groups_configs=pulumi.get(__response__, 'authenticator_groups_configs'),
        binary_authorizations=pulumi.get(__response__, 'binary_authorizations'),
        cluster_autoscalings=pulumi.get(__response__, 'cluster_autoscalings'),
        cluster_ipv4_cidr=pulumi.get(__response__, 'cluster_ipv4_cidr'),
        cluster_telemetries=pulumi.get(__response__, 'cluster_telemetries'),
        confidential_nodes=pulumi.get(__response__, 'confidential_nodes'),
        control_plane_endpoints_configs=pulumi.get(__response__, 'control_plane_endpoints_configs'),
        cost_management_configs=pulumi.get(__response__, 'cost_management_configs'),
        database_encryptions=pulumi.get(__response__, 'database_encryptions'),
        datapath_provider=pulumi.get(__response__, 'datapath_provider'),
        default_max_pods_per_node=pulumi.get(__response__, 'default_max_pods_per_node'),
        default_snat_statuses=pulumi.get(__response__, 'default_snat_statuses'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        disable_l4_lb_firewall_reconciliation=pulumi.get(__response__, 'disable_l4_lb_firewall_reconciliation'),
        dns_configs=pulumi.get(__response__, 'dns_configs'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        enable_autopilot=pulumi.get(__response__, 'enable_autopilot'),
        enable_cilium_clusterwide_network_policy=pulumi.get(__response__, 'enable_cilium_clusterwide_network_policy'),
        enable_fqdn_network_policy=pulumi.get(__response__, 'enable_fqdn_network_policy'),
        enable_intranode_visibility=pulumi.get(__response__, 'enable_intranode_visibility'),
        enable_k8s_beta_apis=pulumi.get(__response__, 'enable_k8s_beta_apis'),
        enable_kubernetes_alpha=pulumi.get(__response__, 'enable_kubernetes_alpha'),
        enable_l4_ilb_subsetting=pulumi.get(__response__, 'enable_l4_ilb_subsetting'),
        enable_legacy_abac=pulumi.get(__response__, 'enable_legacy_abac'),
        enable_multi_networking=pulumi.get(__response__, 'enable_multi_networking'),
        enable_shielded_nodes=pulumi.get(__response__, 'enable_shielded_nodes'),
        enable_tpu=pulumi.get(__response__, 'enable_tpu'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        enterprise_configs=pulumi.get(__response__, 'enterprise_configs'),
        fleets=pulumi.get(__response__, 'fleets'),
        gateway_api_configs=pulumi.get(__response__, 'gateway_api_configs'),
        gke_auto_upgrade_configs=pulumi.get(__response__, 'gke_auto_upgrade_configs'),
        id=pulumi.get(__response__, 'id'),
        identity_service_configs=pulumi.get(__response__, 'identity_service_configs'),
        in_transit_encryption_config=pulumi.get(__response__, 'in_transit_encryption_config'),
        initial_node_count=pulumi.get(__response__, 'initial_node_count'),
        ip_allocation_policies=pulumi.get(__response__, 'ip_allocation_policies'),
        label_fingerprint=pulumi.get(__response__, 'label_fingerprint'),
        location=pulumi.get(__response__, 'location'),
        logging_configs=pulumi.get(__response__, 'logging_configs'),
        logging_service=pulumi.get(__response__, 'logging_service'),
        maintenance_policies=pulumi.get(__response__, 'maintenance_policies'),
        master_authorized_networks_configs=pulumi.get(__response__, 'master_authorized_networks_configs'),
        master_auths=pulumi.get(__response__, 'master_auths'),
        master_version=pulumi.get(__response__, 'master_version'),
        mesh_certificates=pulumi.get(__response__, 'mesh_certificates'),
        min_master_version=pulumi.get(__response__, 'min_master_version'),
        monitoring_configs=pulumi.get(__response__, 'monitoring_configs'),
        monitoring_service=pulumi.get(__response__, 'monitoring_service'),
        name=pulumi.get(__response__, 'name'),
        network=pulumi.get(__response__, 'network'),
        network_performance_configs=pulumi.get(__response__, 'network_performance_configs'),
        network_policies=pulumi.get(__response__, 'network_policies'),
        networking_mode=pulumi.get(__response__, 'networking_mode'),
        node_configs=pulumi.get(__response__, 'node_configs'),
        node_locations=pulumi.get(__response__, 'node_locations'),
        node_pool_auto_configs=pulumi.get(__response__, 'node_pool_auto_configs'),
        node_pool_defaults=pulumi.get(__response__, 'node_pool_defaults'),
        node_pools=pulumi.get(__response__, 'node_pools'),
        node_version=pulumi.get(__response__, 'node_version'),
        notification_configs=pulumi.get(__response__, 'notification_configs'),
        operation=pulumi.get(__response__, 'operation'),
        pod_autoscalings=pulumi.get(__response__, 'pod_autoscalings'),
        pod_security_policy_configs=pulumi.get(__response__, 'pod_security_policy_configs'),
        private_cluster_configs=pulumi.get(__response__, 'private_cluster_configs'),
        private_ipv6_google_access=pulumi.get(__response__, 'private_ipv6_google_access'),
        project=pulumi.get(__response__, 'project'),
        protect_configs=pulumi.get(__response__, 'protect_configs'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        release_channels=pulumi.get(__response__, 'release_channels'),
        remove_default_node_pool=pulumi.get(__response__, 'remove_default_node_pool'),
        resource_labels=pulumi.get(__response__, 'resource_labels'),
        resource_usage_export_configs=pulumi.get(__response__, 'resource_usage_export_configs'),
        secret_manager_configs=pulumi.get(__response__, 'secret_manager_configs'),
        security_posture_configs=pulumi.get(__response__, 'security_posture_configs'),
        self_link=pulumi.get(__response__, 'self_link'),
        service_external_ips_configs=pulumi.get(__response__, 'service_external_ips_configs'),
        services_ipv4_cidr=pulumi.get(__response__, 'services_ipv4_cidr'),
        subnetwork=pulumi.get(__response__, 'subnetwork'),
        tpu_configs=pulumi.get(__response__, 'tpu_configs'),
        tpu_ipv4_cidr_block=pulumi.get(__response__, 'tpu_ipv4_cidr_block'),
        user_managed_keys_configs=pulumi.get(__response__, 'user_managed_keys_configs'),
        vertical_pod_autoscalings=pulumi.get(__response__, 'vertical_pod_autoscalings'),
        workload_alts_configs=pulumi.get(__response__, 'workload_alts_configs'),
        workload_identity_configs=pulumi.get(__response__, 'workload_identity_configs')))
