# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PolicyTagArgs', 'PolicyTag']

@pulumi.input_type
class PolicyTagArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 taxonomy: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 parent_policy_tag: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PolicyTag resource.
        :param pulumi.Input[builtins.str] display_name: User defined name of this policy tag. It must: be unique within the parent
               taxonomy; contain only unicode letters, numbers, underscores, dashes and spaces;
               not start or end with spaces; and be at most 200 bytes long when encoded in UTF-8.
        :param pulumi.Input[builtins.str] taxonomy: Taxonomy the policy tag is associated with
               
               
               - - -
        :param pulumi.Input[builtins.str] description: Description of this policy tag. It must: contain only unicode characters, tabs,
               newlines, carriage returns and page breaks; and be at most 2000 bytes long when
               encoded in UTF-8. If not set, defaults to an empty description.
               If not set, defaults to an empty description.
        :param pulumi.Input[builtins.str] parent_policy_tag: Resource name of this policy tag's parent policy tag.
               If empty, it means this policy tag is a top level policy tag.
               If not set, defaults to an empty string.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "taxonomy", taxonomy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parent_policy_tag is not None:
            pulumi.set(__self__, "parent_policy_tag", parent_policy_tag)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        User defined name of this policy tag. It must: be unique within the parent
        taxonomy; contain only unicode letters, numbers, underscores, dashes and spaces;
        not start or end with spaces; and be at most 200 bytes long when encoded in UTF-8.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def taxonomy(self) -> pulumi.Input[builtins.str]:
        """
        Taxonomy the policy tag is associated with


        - - -
        """
        return pulumi.get(self, "taxonomy")

    @taxonomy.setter
    def taxonomy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "taxonomy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of this policy tag. It must: contain only unicode characters, tabs,
        newlines, carriage returns and page breaks; and be at most 2000 bytes long when
        encoded in UTF-8. If not set, defaults to an empty description.
        If not set, defaults to an empty description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="parentPolicyTag")
    def parent_policy_tag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource name of this policy tag's parent policy tag.
        If empty, it means this policy tag is a top level policy tag.
        If not set, defaults to an empty string.
        """
        return pulumi.get(self, "parent_policy_tag")

    @parent_policy_tag.setter
    def parent_policy_tag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_policy_tag", value)


@pulumi.input_type
class _PolicyTagState:
    def __init__(__self__, *,
                 child_policy_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_policy_tag: Optional[pulumi.Input[builtins.str]] = None,
                 taxonomy: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PolicyTag resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] child_policy_tags: Resource names of child policy tags of this policy tag.
        :param pulumi.Input[builtins.str] description: Description of this policy tag. It must: contain only unicode characters, tabs,
               newlines, carriage returns and page breaks; and be at most 2000 bytes long when
               encoded in UTF-8. If not set, defaults to an empty description.
               If not set, defaults to an empty description.
        :param pulumi.Input[builtins.str] display_name: User defined name of this policy tag. It must: be unique within the parent
               taxonomy; contain only unicode letters, numbers, underscores, dashes and spaces;
               not start or end with spaces; and be at most 200 bytes long when encoded in UTF-8.
        :param pulumi.Input[builtins.str] name: Resource name of this policy tag, whose format is:
               "projects/{project}/locations/{region}/taxonomies/{taxonomy}/policyTags/{policytag}"
        :param pulumi.Input[builtins.str] parent_policy_tag: Resource name of this policy tag's parent policy tag.
               If empty, it means this policy tag is a top level policy tag.
               If not set, defaults to an empty string.
        :param pulumi.Input[builtins.str] taxonomy: Taxonomy the policy tag is associated with
               
               
               - - -
        """
        if child_policy_tags is not None:
            pulumi.set(__self__, "child_policy_tags", child_policy_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_policy_tag is not None:
            pulumi.set(__self__, "parent_policy_tag", parent_policy_tag)
        if taxonomy is not None:
            pulumi.set(__self__, "taxonomy", taxonomy)

    @property
    @pulumi.getter(name="childPolicyTags")
    def child_policy_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Resource names of child policy tags of this policy tag.
        """
        return pulumi.get(self, "child_policy_tags")

    @child_policy_tags.setter
    def child_policy_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "child_policy_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of this policy tag. It must: contain only unicode characters, tabs,
        newlines, carriage returns and page breaks; and be at most 2000 bytes long when
        encoded in UTF-8. If not set, defaults to an empty description.
        If not set, defaults to an empty description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User defined name of this policy tag. It must: be unique within the parent
        taxonomy; contain only unicode letters, numbers, underscores, dashes and spaces;
        not start or end with spaces; and be at most 200 bytes long when encoded in UTF-8.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource name of this policy tag, whose format is:
        "projects/{project}/locations/{region}/taxonomies/{taxonomy}/policyTags/{policytag}"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentPolicyTag")
    def parent_policy_tag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource name of this policy tag's parent policy tag.
        If empty, it means this policy tag is a top level policy tag.
        If not set, defaults to an empty string.
        """
        return pulumi.get(self, "parent_policy_tag")

    @parent_policy_tag.setter
    def parent_policy_tag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_policy_tag", value)

    @property
    @pulumi.getter
    def taxonomy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Taxonomy the policy tag is associated with


        - - -
        """
        return pulumi.get(self, "taxonomy")

    @taxonomy.setter
    def taxonomy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "taxonomy", value)


@pulumi.type_token("gcp:datacatalog/policyTag:PolicyTag")
class PolicyTag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_policy_tag: Optional[pulumi.Input[builtins.str]] = None,
                 taxonomy: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Denotes one policy tag in a taxonomy.

        To get more information about PolicyTag, see:

        * [API documentation](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.taxonomies.policyTags)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/data-catalog/docs)

        ## Example Usage

        ### Data Catalog Taxonomies Policy Tag Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_taxonomy = gcp.datacatalog.Taxonomy("my_taxonomy",
            display_name="taxonomy_display_name",
            description="A collection of policy tags",
            activated_policy_types=["FINE_GRAINED_ACCESS_CONTROL"])
        basic_policy_tag = gcp.datacatalog.PolicyTag("basic_policy_tag",
            taxonomy=my_taxonomy.id,
            display_name="Low security",
            description="A policy tag normally associated with low security items")
        ```
        ### Data Catalog Taxonomies Policy Tag Child Policies

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_taxonomy = gcp.datacatalog.Taxonomy("my_taxonomy",
            display_name="taxonomy_display_name",
            description="A collection of policy tags",
            activated_policy_types=["FINE_GRAINED_ACCESS_CONTROL"])
        parent_policy = gcp.datacatalog.PolicyTag("parent_policy",
            taxonomy=my_taxonomy.id,
            display_name="High",
            description="A policy tag category used for high security access")
        child_policy = gcp.datacatalog.PolicyTag("child_policy",
            taxonomy=my_taxonomy.id,
            display_name="ssn",
            description="A hash of the users ssn",
            parent_policy_tag=parent_policy.id)
        child_policy2 = gcp.datacatalog.PolicyTag("child_policy2",
            taxonomy=my_taxonomy.id,
            display_name="dob",
            description="The users date of birth",
            parent_policy_tag=parent_policy.id,
            opts = pulumi.ResourceOptions(depends_on=[child_policy]))
        ```

        ## Import

        PolicyTag can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, PolicyTag can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:datacatalog/policyTag:PolicyTag default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of this policy tag. It must: contain only unicode characters, tabs,
               newlines, carriage returns and page breaks; and be at most 2000 bytes long when
               encoded in UTF-8. If not set, defaults to an empty description.
               If not set, defaults to an empty description.
        :param pulumi.Input[builtins.str] display_name: User defined name of this policy tag. It must: be unique within the parent
               taxonomy; contain only unicode letters, numbers, underscores, dashes and spaces;
               not start or end with spaces; and be at most 200 bytes long when encoded in UTF-8.
        :param pulumi.Input[builtins.str] parent_policy_tag: Resource name of this policy tag's parent policy tag.
               If empty, it means this policy tag is a top level policy tag.
               If not set, defaults to an empty string.
        :param pulumi.Input[builtins.str] taxonomy: Taxonomy the policy tag is associated with
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyTagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Denotes one policy tag in a taxonomy.

        To get more information about PolicyTag, see:

        * [API documentation](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.taxonomies.policyTags)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/data-catalog/docs)

        ## Example Usage

        ### Data Catalog Taxonomies Policy Tag Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_taxonomy = gcp.datacatalog.Taxonomy("my_taxonomy",
            display_name="taxonomy_display_name",
            description="A collection of policy tags",
            activated_policy_types=["FINE_GRAINED_ACCESS_CONTROL"])
        basic_policy_tag = gcp.datacatalog.PolicyTag("basic_policy_tag",
            taxonomy=my_taxonomy.id,
            display_name="Low security",
            description="A policy tag normally associated with low security items")
        ```
        ### Data Catalog Taxonomies Policy Tag Child Policies

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_taxonomy = gcp.datacatalog.Taxonomy("my_taxonomy",
            display_name="taxonomy_display_name",
            description="A collection of policy tags",
            activated_policy_types=["FINE_GRAINED_ACCESS_CONTROL"])
        parent_policy = gcp.datacatalog.PolicyTag("parent_policy",
            taxonomy=my_taxonomy.id,
            display_name="High",
            description="A policy tag category used for high security access")
        child_policy = gcp.datacatalog.PolicyTag("child_policy",
            taxonomy=my_taxonomy.id,
            display_name="ssn",
            description="A hash of the users ssn",
            parent_policy_tag=parent_policy.id)
        child_policy2 = gcp.datacatalog.PolicyTag("child_policy2",
            taxonomy=my_taxonomy.id,
            display_name="dob",
            description="The users date of birth",
            parent_policy_tag=parent_policy.id,
            opts = pulumi.ResourceOptions(depends_on=[child_policy]))
        ```

        ## Import

        PolicyTag can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, PolicyTag can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:datacatalog/policyTag:PolicyTag default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param PolicyTagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyTagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_policy_tag: Optional[pulumi.Input[builtins.str]] = None,
                 taxonomy: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyTagArgs.__new__(PolicyTagArgs)

            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["parent_policy_tag"] = parent_policy_tag
            if taxonomy is None and not opts.urn:
                raise TypeError("Missing required property 'taxonomy'")
            __props__.__dict__["taxonomy"] = taxonomy
            __props__.__dict__["child_policy_tags"] = None
            __props__.__dict__["name"] = None
        super(PolicyTag, __self__).__init__(
            'gcp:datacatalog/policyTag:PolicyTag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            child_policy_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent_policy_tag: Optional[pulumi.Input[builtins.str]] = None,
            taxonomy: Optional[pulumi.Input[builtins.str]] = None) -> 'PolicyTag':
        """
        Get an existing PolicyTag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] child_policy_tags: Resource names of child policy tags of this policy tag.
        :param pulumi.Input[builtins.str] description: Description of this policy tag. It must: contain only unicode characters, tabs,
               newlines, carriage returns and page breaks; and be at most 2000 bytes long when
               encoded in UTF-8. If not set, defaults to an empty description.
               If not set, defaults to an empty description.
        :param pulumi.Input[builtins.str] display_name: User defined name of this policy tag. It must: be unique within the parent
               taxonomy; contain only unicode letters, numbers, underscores, dashes and spaces;
               not start or end with spaces; and be at most 200 bytes long when encoded in UTF-8.
        :param pulumi.Input[builtins.str] name: Resource name of this policy tag, whose format is:
               "projects/{project}/locations/{region}/taxonomies/{taxonomy}/policyTags/{policytag}"
        :param pulumi.Input[builtins.str] parent_policy_tag: Resource name of this policy tag's parent policy tag.
               If empty, it means this policy tag is a top level policy tag.
               If not set, defaults to an empty string.
        :param pulumi.Input[builtins.str] taxonomy: Taxonomy the policy tag is associated with
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyTagState.__new__(_PolicyTagState)

        __props__.__dict__["child_policy_tags"] = child_policy_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_policy_tag"] = parent_policy_tag
        __props__.__dict__["taxonomy"] = taxonomy
        return PolicyTag(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="childPolicyTags")
    def child_policy_tags(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Resource names of child policy tags of this policy tag.
        """
        return pulumi.get(self, "child_policy_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of this policy tag. It must: contain only unicode characters, tabs,
        newlines, carriage returns and page breaks; and be at most 2000 bytes long when
        encoded in UTF-8. If not set, defaults to an empty description.
        If not set, defaults to an empty description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        User defined name of this policy tag. It must: be unique within the parent
        taxonomy; contain only unicode letters, numbers, underscores, dashes and spaces;
        not start or end with spaces; and be at most 200 bytes long when encoded in UTF-8.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Resource name of this policy tag, whose format is:
        "projects/{project}/locations/{region}/taxonomies/{taxonomy}/policyTags/{policytag}"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentPolicyTag")
    def parent_policy_tag(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Resource name of this policy tag's parent policy tag.
        If empty, it means this policy tag is a top level policy tag.
        If not set, defaults to an empty string.
        """
        return pulumi.get(self, "parent_policy_tag")

    @property
    @pulumi.getter
    def taxonomy(self) -> pulumi.Output[builtins.str]:
        """
        Taxonomy the policy tag is associated with


        - - -
        """
        return pulumi.get(self, "taxonomy")

