# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'PipelineScheduleInfoArgs',
    'PipelineScheduleInfoArgsDict',
    'PipelineWorkloadArgs',
    'PipelineWorkloadArgsDict',
    'PipelineWorkloadDataflowFlexTemplateRequestArgs',
    'PipelineWorkloadDataflowFlexTemplateRequestArgsDict',
    'PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterArgs',
    'PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterArgsDict',
    'PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentArgs',
    'PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentArgsDict',
    'PipelineWorkloadDataflowLaunchTemplateRequestArgs',
    'PipelineWorkloadDataflowLaunchTemplateRequestArgsDict',
    'PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersArgs',
    'PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersArgsDict',
    'PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentArgs',
    'PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentArgsDict',
]

MYPY = False

if not MYPY:
    class PipelineScheduleInfoArgsDict(TypedDict):
        next_job_time: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        When the next Scheduler job is going to run.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        schedule: NotRequired[pulumi.Input[builtins.str]]
        """
        Unix-cron format of the schedule. This information is retrieved from the linked Cloud Scheduler.
        """
        time_zone: NotRequired[pulumi.Input[builtins.str]]
        """
        Timezone ID. This matches the timezone IDs used by the Cloud Scheduler API. If empty, UTC time is assumed.
        """
elif False:
    PipelineScheduleInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineScheduleInfoArgs:
    def __init__(__self__, *,
                 next_job_time: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] next_job_time: (Output)
               When the next Scheduler job is going to run.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] schedule: Unix-cron format of the schedule. This information is retrieved from the linked Cloud Scheduler.
        :param pulumi.Input[builtins.str] time_zone: Timezone ID. This matches the timezone IDs used by the Cloud Scheduler API. If empty, UTC time is assumed.
        """
        if next_job_time is not None:
            pulumi.set(__self__, "next_job_time", next_job_time)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="nextJobTime")
    def next_job_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        When the next Scheduler job is going to run.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "next_job_time")

    @next_job_time.setter
    def next_job_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_job_time", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unix-cron format of the schedule. This information is retrieved from the linked Cloud Scheduler.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timezone ID. This matches the timezone IDs used by the Cloud Scheduler API. If empty, UTC time is assumed.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)


if not MYPY:
    class PipelineWorkloadArgsDict(TypedDict):
        dataflow_flex_template_request: NotRequired[pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestArgsDict']]
        """
        Template information and additional parameters needed to launch a Dataflow job using the flex launch API.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchflextemplaterequest
        Structure is documented below.
        """
        dataflow_launch_template_request: NotRequired[pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestArgsDict']]
        """
        Template information and additional parameters needed to launch a Dataflow job using the standard launch API.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchtemplaterequest
        Structure is documented below.
        """
elif False:
    PipelineWorkloadArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineWorkloadArgs:
    def __init__(__self__, *,
                 dataflow_flex_template_request: Optional[pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestArgs']] = None,
                 dataflow_launch_template_request: Optional[pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestArgs']] = None):
        """
        :param pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestArgs'] dataflow_flex_template_request: Template information and additional parameters needed to launch a Dataflow job using the flex launch API.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchflextemplaterequest
               Structure is documented below.
        :param pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestArgs'] dataflow_launch_template_request: Template information and additional parameters needed to launch a Dataflow job using the standard launch API.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchtemplaterequest
               Structure is documented below.
        """
        if dataflow_flex_template_request is not None:
            pulumi.set(__self__, "dataflow_flex_template_request", dataflow_flex_template_request)
        if dataflow_launch_template_request is not None:
            pulumi.set(__self__, "dataflow_launch_template_request", dataflow_launch_template_request)

    @property
    @pulumi.getter(name="dataflowFlexTemplateRequest")
    def dataflow_flex_template_request(self) -> Optional[pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestArgs']]:
        """
        Template information and additional parameters needed to launch a Dataflow job using the flex launch API.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchflextemplaterequest
        Structure is documented below.
        """
        return pulumi.get(self, "dataflow_flex_template_request")

    @dataflow_flex_template_request.setter
    def dataflow_flex_template_request(self, value: Optional[pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestArgs']]):
        pulumi.set(self, "dataflow_flex_template_request", value)

    @property
    @pulumi.getter(name="dataflowLaunchTemplateRequest")
    def dataflow_launch_template_request(self) -> Optional[pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestArgs']]:
        """
        Template information and additional parameters needed to launch a Dataflow job using the standard launch API.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchtemplaterequest
        Structure is documented below.
        """
        return pulumi.get(self, "dataflow_launch_template_request")

    @dataflow_launch_template_request.setter
    def dataflow_launch_template_request(self, value: Optional[pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestArgs']]):
        pulumi.set(self, "dataflow_launch_template_request", value)


if not MYPY:
    class PipelineWorkloadDataflowFlexTemplateRequestArgsDict(TypedDict):
        launch_parameter: pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterArgsDict']
        """
        Parameter to launch a job from a Flex Template.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchflextemplateparameter
        Structure is documented below.
        """
        location: pulumi.Input[builtins.str]
        """
        The regional endpoint to which to direct the request. For example, us-central1, us-west1.
        """
        project_id: pulumi.Input[builtins.str]
        """
        The ID of the Cloud Platform project that the job belongs to.
        """
        validate_only: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, the request is validated but not actually executed. Defaults to false.
        """
elif False:
    PipelineWorkloadDataflowFlexTemplateRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineWorkloadDataflowFlexTemplateRequestArgs:
    def __init__(__self__, *,
                 launch_parameter: pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterArgs'],
                 location: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.str],
                 validate_only: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterArgs'] launch_parameter: Parameter to launch a job from a Flex Template.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchflextemplateparameter
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The regional endpoint to which to direct the request. For example, us-central1, us-west1.
        :param pulumi.Input[builtins.str] project_id: The ID of the Cloud Platform project that the job belongs to.
        :param pulumi.Input[builtins.bool] validate_only: If true, the request is validated but not actually executed. Defaults to false.
        """
        pulumi.set(__self__, "launch_parameter", launch_parameter)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "project_id", project_id)
        if validate_only is not None:
            pulumi.set(__self__, "validate_only", validate_only)

    @property
    @pulumi.getter(name="launchParameter")
    def launch_parameter(self) -> pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterArgs']:
        """
        Parameter to launch a job from a Flex Template.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchflextemplateparameter
        Structure is documented below.
        """
        return pulumi.get(self, "launch_parameter")

    @launch_parameter.setter
    def launch_parameter(self, value: pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterArgs']):
        pulumi.set(self, "launch_parameter", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The regional endpoint to which to direct the request. For example, us-central1, us-west1.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Cloud Platform project that the job belongs to.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the request is validated but not actually executed. Defaults to false.
        """
        return pulumi.get(self, "validate_only")

    @validate_only.setter
    def validate_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "validate_only", value)


if not MYPY:
    class PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterArgsDict(TypedDict):
        job_name: pulumi.Input[builtins.str]
        """
        The job name to use for the created job. For an update job request, the job name should be the same as the existing running job.
        """
        container_spec_gcs_path: NotRequired[pulumi.Input[builtins.str]]
        """
        Cloud Storage path to a file with a JSON-serialized ContainerSpec as content.
        """
        environment: NotRequired[pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentArgsDict']]
        """
        The runtime environment for the Flex Template job.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#FlexTemplateRuntimeEnvironment
        Structure is documented below.
        """
        launch_options: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Launch options for this Flex Template job. This is a common set of options across languages and templates. This should not be used to pass job parameters.
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        'The parameters for the Flex Template. Example: {"numWorkers":"5"}'
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        transform_name_mappings: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        'Use this to pass transform name mappings for streaming update jobs. Example: {"oldTransformName":"newTransformName",...}'
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        update: NotRequired[pulumi.Input[builtins.bool]]
        """
        Set this to true if you are sending a request to update a running streaming job. When set, the job name should be the same as the running job.
        """
elif False:
    PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterArgs:
    def __init__(__self__, *,
                 job_name: pulumi.Input[builtins.str],
                 container_spec_gcs_path: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentArgs']] = None,
                 launch_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 transform_name_mappings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 update: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] job_name: The job name to use for the created job. For an update job request, the job name should be the same as the existing running job.
        :param pulumi.Input[builtins.str] container_spec_gcs_path: Cloud Storage path to a file with a JSON-serialized ContainerSpec as content.
        :param pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentArgs'] environment: The runtime environment for the Flex Template job.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#FlexTemplateRuntimeEnvironment
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] launch_options: Launch options for this Flex Template job. This is a common set of options across languages and templates. This should not be used to pass job parameters.
               'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: 'The parameters for the Flex Template. Example: {"numWorkers":"5"}'
               'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] transform_name_mappings: 'Use this to pass transform name mappings for streaming update jobs. Example: {"oldTransformName":"newTransformName",...}'
               'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        :param pulumi.Input[builtins.bool] update: Set this to true if you are sending a request to update a running streaming job. When set, the job name should be the same as the running job.
        """
        pulumi.set(__self__, "job_name", job_name)
        if container_spec_gcs_path is not None:
            pulumi.set(__self__, "container_spec_gcs_path", container_spec_gcs_path)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if launch_options is not None:
            pulumi.set(__self__, "launch_options", launch_options)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if transform_name_mappings is not None:
            pulumi.set(__self__, "transform_name_mappings", transform_name_mappings)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Input[builtins.str]:
        """
        The job name to use for the created job. For an update job request, the job name should be the same as the existing running job.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter(name="containerSpecGcsPath")
    def container_spec_gcs_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Cloud Storage path to a file with a JSON-serialized ContainerSpec as content.
        """
        return pulumi.get(self, "container_spec_gcs_path")

    @container_spec_gcs_path.setter
    def container_spec_gcs_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_spec_gcs_path", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentArgs']]:
        """
        The runtime environment for the Flex Template job.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#FlexTemplateRuntimeEnvironment
        Structure is documented below.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="launchOptions")
    def launch_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Launch options for this Flex Template job. This is a common set of options across languages and templates. This should not be used to pass job parameters.
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        return pulumi.get(self, "launch_options")

    @launch_options.setter
    def launch_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "launch_options", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        'The parameters for the Flex Template. Example: {"numWorkers":"5"}'
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="transformNameMappings")
    def transform_name_mappings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        'Use this to pass transform name mappings for streaming update jobs. Example: {"oldTransformName":"newTransformName",...}'
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        return pulumi.get(self, "transform_name_mappings")

    @transform_name_mappings.setter
    def transform_name_mappings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "transform_name_mappings", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set this to true if you are sending a request to update a running streaming job. When set, the job name should be the same as the running job.
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "update", value)


if not MYPY:
    class PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentArgsDict(TypedDict):
        additional_experiments: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Additional experiment flags for the job.
        """
        additional_user_labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the labeling restrictions page. An object containing a list of key/value pairs.
        'Example: { "name": "wrench", "mass": "1kg", "count": "3" }.'
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        enable_streaming_engine: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to enable Streaming Engine for the job.
        """
        flexrs_goal: NotRequired[pulumi.Input[builtins.str]]
        """
        Set FlexRS goal for the job. https://cloud.google.com/dataflow/docs/guides/flexrs
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#FlexResourceSchedulingGoal
        Possible values are: `FLEXRS_UNSPECIFIED`, `FLEXRS_SPEED_OPTIMIZED`, `FLEXRS_COST_OPTIMIZED`.
        """
        ip_configuration: NotRequired[pulumi.Input[builtins.str]]
        """
        Configuration for VM IPs.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#WorkerIPAddressConfiguration
        Possible values are: `WORKER_IP_UNSPECIFIED`, `WORKER_IP_PUBLIC`, `WORKER_IP_PRIVATE`.
        """
        kms_key_name: NotRequired[pulumi.Input[builtins.str]]
        """
        'Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/'
        """
        machine_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The machine type to use for the job. Defaults to the value from the template if not specified.
        """
        max_workers: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        """
        network: NotRequired[pulumi.Input[builtins.str]]
        """
        Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        """
        num_workers: NotRequired[pulumi.Input[builtins.int]]
        """
        The initial number of Compute Engine instances for the job.
        """
        service_account_email: NotRequired[pulumi.Input[builtins.str]]
        """
        The email address of the service account to run the job as.
        """
        subnetwork: NotRequired[pulumi.Input[builtins.str]]
        """
        Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        """
        temp_location: NotRequired[pulumi.Input[builtins.str]]
        """
        The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        """
        worker_region: NotRequired[pulumi.Input[builtins.str]]
        """
        The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with workerZone. If neither workerRegion nor workerZone is specified, default to the control plane's region.
        """
        worker_zone: NotRequired[pulumi.Input[builtins.str]]
        """
        The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with workerRegion. If neither workerRegion nor workerZone is specified, a zone in the control plane's region is chosen based on available capacity. If both workerZone and zone are set, workerZone takes precedence.
        """
        zone: NotRequired[pulumi.Input[builtins.str]]
        """
        The Compute Engine availability zone for launching worker instances to run your pipeline. In the future, workerZone will take precedence.
        """
elif False:
    PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentArgs:
    def __init__(__self__, *,
                 additional_experiments: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 additional_user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 enable_streaming_engine: Optional[pulumi.Input[builtins.bool]] = None,
                 flexrs_goal: Optional[pulumi.Input[builtins.str]] = None,
                 ip_configuration: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[builtins.str]] = None,
                 max_workers: Optional[pulumi.Input[builtins.int]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 num_workers: Optional[pulumi.Input[builtins.int]] = None,
                 service_account_email: Optional[pulumi.Input[builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None,
                 temp_location: Optional[pulumi.Input[builtins.str]] = None,
                 worker_region: Optional[pulumi.Input[builtins.str]] = None,
                 worker_zone: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] additional_experiments: Additional experiment flags for the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_user_labels: Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the labeling restrictions page. An object containing a list of key/value pairs.
               'Example: { "name": "wrench", "mass": "1kg", "count": "3" }.'
               'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        :param pulumi.Input[builtins.bool] enable_streaming_engine: Whether to enable Streaming Engine for the job.
        :param pulumi.Input[builtins.str] flexrs_goal: Set FlexRS goal for the job. https://cloud.google.com/dataflow/docs/guides/flexrs
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#FlexResourceSchedulingGoal
               Possible values are: `FLEXRS_UNSPECIFIED`, `FLEXRS_SPEED_OPTIMIZED`, `FLEXRS_COST_OPTIMIZED`.
        :param pulumi.Input[builtins.str] ip_configuration: Configuration for VM IPs.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#WorkerIPAddressConfiguration
               Possible values are: `WORKER_IP_UNSPECIFIED`, `WORKER_IP_PUBLIC`, `WORKER_IP_PRIVATE`.
        :param pulumi.Input[builtins.str] kms_key_name: 'Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/'
        :param pulumi.Input[builtins.str] machine_type: The machine type to use for the job. Defaults to the value from the template if not specified.
        :param pulumi.Input[builtins.int] max_workers: The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        :param pulumi.Input[builtins.str] network: Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        :param pulumi.Input[builtins.int] num_workers: The initial number of Compute Engine instances for the job.
        :param pulumi.Input[builtins.str] service_account_email: The email address of the service account to run the job as.
        :param pulumi.Input[builtins.str] subnetwork: Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        :param pulumi.Input[builtins.str] temp_location: The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        :param pulumi.Input[builtins.str] worker_region: The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with workerZone. If neither workerRegion nor workerZone is specified, default to the control plane's region.
        :param pulumi.Input[builtins.str] worker_zone: The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with workerRegion. If neither workerRegion nor workerZone is specified, a zone in the control plane's region is chosen based on available capacity. If both workerZone and zone are set, workerZone takes precedence.
        :param pulumi.Input[builtins.str] zone: The Compute Engine availability zone for launching worker instances to run your pipeline. In the future, workerZone will take precedence.
        """
        if additional_experiments is not None:
            pulumi.set(__self__, "additional_experiments", additional_experiments)
        if additional_user_labels is not None:
            pulumi.set(__self__, "additional_user_labels", additional_user_labels)
        if enable_streaming_engine is not None:
            pulumi.set(__self__, "enable_streaming_engine", enable_streaming_engine)
        if flexrs_goal is not None:
            pulumi.set(__self__, "flexrs_goal", flexrs_goal)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_workers is not None:
            pulumi.set(__self__, "max_workers", max_workers)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if num_workers is not None:
            pulumi.set(__self__, "num_workers", num_workers)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if temp_location is not None:
            pulumi.set(__self__, "temp_location", temp_location)
        if worker_region is not None:
            pulumi.set(__self__, "worker_region", worker_region)
        if worker_zone is not None:
            pulumi.set(__self__, "worker_zone", worker_zone)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="additionalExperiments")
    def additional_experiments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Additional experiment flags for the job.
        """
        return pulumi.get(self, "additional_experiments")

    @additional_experiments.setter
    def additional_experiments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_experiments", value)

    @property
    @pulumi.getter(name="additionalUserLabels")
    def additional_user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the labeling restrictions page. An object containing a list of key/value pairs.
        'Example: { "name": "wrench", "mass": "1kg", "count": "3" }.'
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        return pulumi.get(self, "additional_user_labels")

    @additional_user_labels.setter
    def additional_user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_user_labels", value)

    @property
    @pulumi.getter(name="enableStreamingEngine")
    def enable_streaming_engine(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable Streaming Engine for the job.
        """
        return pulumi.get(self, "enable_streaming_engine")

    @enable_streaming_engine.setter
    def enable_streaming_engine(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_streaming_engine", value)

    @property
    @pulumi.getter(name="flexrsGoal")
    def flexrs_goal(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set FlexRS goal for the job. https://cloud.google.com/dataflow/docs/guides/flexrs
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#FlexResourceSchedulingGoal
        Possible values are: `FLEXRS_UNSPECIFIED`, `FLEXRS_SPEED_OPTIMIZED`, `FLEXRS_COST_OPTIMIZED`.
        """
        return pulumi.get(self, "flexrs_goal")

    @flexrs_goal.setter
    def flexrs_goal(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "flexrs_goal", value)

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configuration for VM IPs.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#WorkerIPAddressConfiguration
        Possible values are: `WORKER_IP_UNSPECIFIED`, `WORKER_IP_PUBLIC`, `WORKER_IP_PRIVATE`.
        """
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_configuration", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        'Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/'
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The machine type to use for the job. Defaults to the value from the template if not specified.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        """
        return pulumi.get(self, "max_workers")

    @max_workers.setter
    def max_workers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_workers", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The initial number of Compute Engine instances for the job.
        """
        return pulumi.get(self, "num_workers")

    @num_workers.setter
    def num_workers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_workers", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email address of the service account to run the job as.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter(name="tempLocation")
    def temp_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        """
        return pulumi.get(self, "temp_location")

    @temp_location.setter
    def temp_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "temp_location", value)

    @property
    @pulumi.getter(name="workerRegion")
    def worker_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with workerZone. If neither workerRegion nor workerZone is specified, default to the control plane's region.
        """
        return pulumi.get(self, "worker_region")

    @worker_region.setter
    def worker_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "worker_region", value)

    @property
    @pulumi.getter(name="workerZone")
    def worker_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with workerRegion. If neither workerRegion nor workerZone is specified, a zone in the control plane's region is chosen based on available capacity. If both workerZone and zone are set, workerZone takes precedence.
        """
        return pulumi.get(self, "worker_zone")

    @worker_zone.setter
    def worker_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "worker_zone", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Compute Engine availability zone for launching worker instances to run your pipeline. In the future, workerZone will take precedence.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class PipelineWorkloadDataflowLaunchTemplateRequestArgsDict(TypedDict):
        project_id: pulumi.Input[builtins.str]
        """
        The ID of the Cloud Platform project that the job belongs to.
        """
        gcs_path: NotRequired[pulumi.Input[builtins.str]]
        """
        A Cloud Storage path to the template from which to create the job. Must be a valid Cloud Storage URL, beginning with 'gs://'.
        """
        launch_parameters: NotRequired[pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersArgsDict']]
        """
        The parameters of the template to launch. This should be part of the body of the POST request.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchtemplateparameters
        Structure is documented below.
        """
        location: NotRequired[pulumi.Input[builtins.str]]
        """
        The regional endpoint to which to direct the request.
        """
        validate_only: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Optional)
        """
elif False:
    PipelineWorkloadDataflowLaunchTemplateRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineWorkloadDataflowLaunchTemplateRequestArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[builtins.str],
                 gcs_path: Optional[pulumi.Input[builtins.str]] = None,
                 launch_parameters: Optional[pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 validate_only: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] project_id: The ID of the Cloud Platform project that the job belongs to.
        :param pulumi.Input[builtins.str] gcs_path: A Cloud Storage path to the template from which to create the job. Must be a valid Cloud Storage URL, beginning with 'gs://'.
        :param pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersArgs'] launch_parameters: The parameters of the template to launch. This should be part of the body of the POST request.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchtemplateparameters
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The regional endpoint to which to direct the request.
        :param pulumi.Input[builtins.bool] validate_only: (Optional)
        """
        pulumi.set(__self__, "project_id", project_id)
        if gcs_path is not None:
            pulumi.set(__self__, "gcs_path", gcs_path)
        if launch_parameters is not None:
            pulumi.set(__self__, "launch_parameters", launch_parameters)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if validate_only is not None:
            pulumi.set(__self__, "validate_only", validate_only)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Cloud Platform project that the job belongs to.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="gcsPath")
    def gcs_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A Cloud Storage path to the template from which to create the job. Must be a valid Cloud Storage URL, beginning with 'gs://'.
        """
        return pulumi.get(self, "gcs_path")

    @gcs_path.setter
    def gcs_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gcs_path", value)

    @property
    @pulumi.getter(name="launchParameters")
    def launch_parameters(self) -> Optional[pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersArgs']]:
        """
        The parameters of the template to launch. This should be part of the body of the POST request.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchtemplateparameters
        Structure is documented below.
        """
        return pulumi.get(self, "launch_parameters")

    @launch_parameters.setter
    def launch_parameters(self, value: Optional[pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersArgs']]):
        pulumi.set(self, "launch_parameters", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The regional endpoint to which to direct the request.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Optional)
        """
        return pulumi.get(self, "validate_only")

    @validate_only.setter
    def validate_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "validate_only", value)


if not MYPY:
    class PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersArgsDict(TypedDict):
        job_name: pulumi.Input[builtins.str]
        """
        The job name to use for the created job.
        """
        environment: NotRequired[pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentArgsDict']]
        """
        The runtime environment for the job.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#RuntimeEnvironment
        Structure is documented below.
        """
        parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The runtime parameters to pass to the job.
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        transform_name_mapping: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job. Only applicable when updating a pipeline.
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        update: NotRequired[pulumi.Input[builtins.bool]]
        """
        If set, replace the existing pipeline with the name specified by jobName with this pipeline, preserving state.
        """
elif False:
    PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersArgs:
    def __init__(__self__, *,
                 job_name: pulumi.Input[builtins.str],
                 environment: Optional[pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentArgs']] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 transform_name_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 update: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] job_name: The job name to use for the created job.
        :param pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentArgs'] environment: The runtime environment for the job.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#RuntimeEnvironment
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: The runtime parameters to pass to the job.
               'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] transform_name_mapping: Map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job. Only applicable when updating a pipeline.
               'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        :param pulumi.Input[builtins.bool] update: If set, replace the existing pipeline with the name specified by jobName with this pipeline, preserving state.
        """
        pulumi.set(__self__, "job_name", job_name)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if transform_name_mapping is not None:
            pulumi.set(__self__, "transform_name_mapping", transform_name_mapping)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Input[builtins.str]:
        """
        The job name to use for the created job.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentArgs']]:
        """
        The runtime environment for the job.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#RuntimeEnvironment
        Structure is documented below.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The runtime parameters to pass to the job.
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="transformNameMapping")
    def transform_name_mapping(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job. Only applicable when updating a pipeline.
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        return pulumi.get(self, "transform_name_mapping")

    @transform_name_mapping.setter
    def transform_name_mapping(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "transform_name_mapping", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set, replace the existing pipeline with the name specified by jobName with this pipeline, preserving state.
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "update", value)


if not MYPY:
    class PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentArgsDict(TypedDict):
        additional_experiments: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Additional experiment flags for the job.
        """
        additional_user_labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the labeling restrictions page. An object containing a list of key/value pairs.
        'Example: { "name": "wrench", "mass": "1kg", "count": "3" }.'
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        bypass_temp_dir_validation: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to bypass the safety checks for the job's temporary directory. Use with caution.
        """
        enable_streaming_engine: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to enable Streaming Engine for the job.
        """
        ip_configuration: NotRequired[pulumi.Input[builtins.str]]
        """
        Configuration for VM IPs.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#WorkerIPAddressConfiguration
        Possible values are: `WORKER_IP_UNSPECIFIED`, `WORKER_IP_PUBLIC`, `WORKER_IP_PRIVATE`.
        """
        kms_key_name: NotRequired[pulumi.Input[builtins.str]]
        """
        'Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/'
        """
        machine_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The machine type to use for the job. Defaults to the value from the template if not specified.
        """
        max_workers: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        """
        network: NotRequired[pulumi.Input[builtins.str]]
        """
        Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        """
        num_workers: NotRequired[pulumi.Input[builtins.int]]
        """
        The initial number of Compute Engine instances for the job.
        """
        service_account_email: NotRequired[pulumi.Input[builtins.str]]
        """
        The email address of the service account to run the job as.
        """
        subnetwork: NotRequired[pulumi.Input[builtins.str]]
        """
        Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        """
        temp_location: NotRequired[pulumi.Input[builtins.str]]
        """
        The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        """
        worker_region: NotRequired[pulumi.Input[builtins.str]]
        """
        The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with workerZone. If neither workerRegion nor workerZone is specified, default to the control plane's region.
        """
        worker_zone: NotRequired[pulumi.Input[builtins.str]]
        """
        The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with workerRegion. If neither workerRegion nor workerZone is specified, a zone in the control plane's region is chosen based on available capacity. If both workerZone and zone are set, workerZone takes precedence.
        """
        zone: NotRequired[pulumi.Input[builtins.str]]
        """
        The Compute Engine availability zone for launching worker instances to run your pipeline. In the future, workerZone will take precedence.
        """
elif False:
    PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentArgs:
    def __init__(__self__, *,
                 additional_experiments: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 additional_user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 bypass_temp_dir_validation: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_streaming_engine: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_configuration: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[builtins.str]] = None,
                 max_workers: Optional[pulumi.Input[builtins.int]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 num_workers: Optional[pulumi.Input[builtins.int]] = None,
                 service_account_email: Optional[pulumi.Input[builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None,
                 temp_location: Optional[pulumi.Input[builtins.str]] = None,
                 worker_region: Optional[pulumi.Input[builtins.str]] = None,
                 worker_zone: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] additional_experiments: Additional experiment flags for the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_user_labels: Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the labeling restrictions page. An object containing a list of key/value pairs.
               'Example: { "name": "wrench", "mass": "1kg", "count": "3" }.'
               'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        :param pulumi.Input[builtins.bool] bypass_temp_dir_validation: Whether to bypass the safety checks for the job's temporary directory. Use with caution.
        :param pulumi.Input[builtins.bool] enable_streaming_engine: Whether to enable Streaming Engine for the job.
        :param pulumi.Input[builtins.str] ip_configuration: Configuration for VM IPs.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#WorkerIPAddressConfiguration
               Possible values are: `WORKER_IP_UNSPECIFIED`, `WORKER_IP_PUBLIC`, `WORKER_IP_PRIVATE`.
        :param pulumi.Input[builtins.str] kms_key_name: 'Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/'
        :param pulumi.Input[builtins.str] machine_type: The machine type to use for the job. Defaults to the value from the template if not specified.
        :param pulumi.Input[builtins.int] max_workers: The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        :param pulumi.Input[builtins.str] network: Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        :param pulumi.Input[builtins.int] num_workers: The initial number of Compute Engine instances for the job.
        :param pulumi.Input[builtins.str] service_account_email: The email address of the service account to run the job as.
        :param pulumi.Input[builtins.str] subnetwork: Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        :param pulumi.Input[builtins.str] temp_location: The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        :param pulumi.Input[builtins.str] worker_region: The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with workerZone. If neither workerRegion nor workerZone is specified, default to the control plane's region.
        :param pulumi.Input[builtins.str] worker_zone: The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with workerRegion. If neither workerRegion nor workerZone is specified, a zone in the control plane's region is chosen based on available capacity. If both workerZone and zone are set, workerZone takes precedence.
        :param pulumi.Input[builtins.str] zone: The Compute Engine availability zone for launching worker instances to run your pipeline. In the future, workerZone will take precedence.
        """
        if additional_experiments is not None:
            pulumi.set(__self__, "additional_experiments", additional_experiments)
        if additional_user_labels is not None:
            pulumi.set(__self__, "additional_user_labels", additional_user_labels)
        if bypass_temp_dir_validation is not None:
            pulumi.set(__self__, "bypass_temp_dir_validation", bypass_temp_dir_validation)
        if enable_streaming_engine is not None:
            pulumi.set(__self__, "enable_streaming_engine", enable_streaming_engine)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_workers is not None:
            pulumi.set(__self__, "max_workers", max_workers)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if num_workers is not None:
            pulumi.set(__self__, "num_workers", num_workers)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if temp_location is not None:
            pulumi.set(__self__, "temp_location", temp_location)
        if worker_region is not None:
            pulumi.set(__self__, "worker_region", worker_region)
        if worker_zone is not None:
            pulumi.set(__self__, "worker_zone", worker_zone)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="additionalExperiments")
    def additional_experiments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Additional experiment flags for the job.
        """
        return pulumi.get(self, "additional_experiments")

    @additional_experiments.setter
    def additional_experiments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_experiments", value)

    @property
    @pulumi.getter(name="additionalUserLabels")
    def additional_user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the labeling restrictions page. An object containing a list of key/value pairs.
        'Example: { "name": "wrench", "mass": "1kg", "count": "3" }.'
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        return pulumi.get(self, "additional_user_labels")

    @additional_user_labels.setter
    def additional_user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_user_labels", value)

    @property
    @pulumi.getter(name="bypassTempDirValidation")
    def bypass_temp_dir_validation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to bypass the safety checks for the job's temporary directory. Use with caution.
        """
        return pulumi.get(self, "bypass_temp_dir_validation")

    @bypass_temp_dir_validation.setter
    def bypass_temp_dir_validation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "bypass_temp_dir_validation", value)

    @property
    @pulumi.getter(name="enableStreamingEngine")
    def enable_streaming_engine(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable Streaming Engine for the job.
        """
        return pulumi.get(self, "enable_streaming_engine")

    @enable_streaming_engine.setter
    def enable_streaming_engine(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_streaming_engine", value)

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configuration for VM IPs.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#WorkerIPAddressConfiguration
        Possible values are: `WORKER_IP_UNSPECIFIED`, `WORKER_IP_PUBLIC`, `WORKER_IP_PRIVATE`.
        """
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_configuration", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        'Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/'
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The machine type to use for the job. Defaults to the value from the template if not specified.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        """
        return pulumi.get(self, "max_workers")

    @max_workers.setter
    def max_workers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_workers", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The initial number of Compute Engine instances for the job.
        """
        return pulumi.get(self, "num_workers")

    @num_workers.setter
    def num_workers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_workers", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email address of the service account to run the job as.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter(name="tempLocation")
    def temp_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        """
        return pulumi.get(self, "temp_location")

    @temp_location.setter
    def temp_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "temp_location", value)

    @property
    @pulumi.getter(name="workerRegion")
    def worker_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with workerZone. If neither workerRegion nor workerZone is specified, default to the control plane's region.
        """
        return pulumi.get(self, "worker_region")

    @worker_region.setter
    def worker_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "worker_region", value)

    @property
    @pulumi.getter(name="workerZone")
    def worker_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with workerRegion. If neither workerRegion nor workerZone is specified, a zone in the control plane's region is chosen based on available capacity. If both workerZone and zone are set, workerZone takes precedence.
        """
        return pulumi.get(self, "worker_zone")

    @worker_zone.setter
    def worker_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "worker_zone", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Compute Engine availability zone for launching worker instances to run your pipeline. In the future, workerZone will take precedence.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


