# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PipelineArgs', 'Pipeline']

@pulumi.input_type
class PipelineArgs:
    def __init__(__self__, *,
                 state: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_sources: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_info: Optional[pulumi.Input['PipelineScheduleInfoArgs']] = None,
                 scheduler_service_account_email: Optional[pulumi.Input[builtins.str]] = None,
                 workload: Optional[pulumi.Input['PipelineWorkloadArgs']] = None):
        """
        The set of arguments for constructing a Pipeline resource.
        :param pulumi.Input[builtins.str] state: The state of the pipeline. When the pipeline is created, the state is set to 'PIPELINE_STATE_ACTIVE' by default. State changes can be requested by setting the state to stopping, paused, or resuming. State cannot be changed through pipelines.patch requests.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#state
               Possible values are: `STATE_UNSPECIFIED`, `STATE_RESUMING`, `STATE_ACTIVE`, `STATE_STOPPING`, `STATE_ARCHIVED`, `STATE_PAUSED`.
               
               
               - - -
        :param pulumi.Input[builtins.str] type: The type of the pipeline. This field affects the scheduling of the pipeline and the type of metrics to show for the pipeline.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#pipelinetype
               Possible values are: `PIPELINE_TYPE_UNSPECIFIED`, `PIPELINE_TYPE_BATCH`, `PIPELINE_TYPE_STREAMING`.
        :param pulumi.Input[builtins.str] display_name: The display name of the pipeline. It can contain only letters ([A-Za-z]), numbers ([0-9]), hyphens (-), and underscores (_).
        :param pulumi.Input[builtins.str] name: "The pipeline name. For example': 'projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID."
               "- PROJECT_ID can contain letters ([A-Za-z]), numbers ([0-9]), hyphens (-), colons (:), and periods (.). For more information, see Identifying projects."
               "LOCATION_ID is the canonical ID for the pipeline's location. The list of available locations can be obtained by calling google.cloud.location.Locations.ListLocations. Note that the Data Pipelines service is not available in all regions. It depends on Cloud Scheduler, an App Engine application, so it's only available in App Engine regions."
               "PIPELINE_ID is the ID of the pipeline. Must be unique for the selected project and location."
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pipeline_sources: The sources of the pipeline (for example, Dataplex). The keys and values are set by the corresponding sources during pipeline creation.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: A reference to the region
        :param pulumi.Input['PipelineScheduleInfoArgs'] schedule_info: Internal scheduling information for a pipeline. If this information is provided, periodic jobs will be created per the schedule. If not, users are responsible for creating jobs externally.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#schedulespec
               Structure is documented below.
        :param pulumi.Input[builtins.str] scheduler_service_account_email: Optional. A service account email to be used with the Cloud Scheduler job. If not specified, the default compute engine service account will be used.
        :param pulumi.Input['PipelineWorkloadArgs'] workload: Workload information for creating new jobs.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#workload
               Structure is documented below.
        """
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pipeline_sources is not None:
            pulumi.set(__self__, "pipeline_sources", pipeline_sources)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schedule_info is not None:
            pulumi.set(__self__, "schedule_info", schedule_info)
        if scheduler_service_account_email is not None:
            pulumi.set(__self__, "scheduler_service_account_email", scheduler_service_account_email)
        if workload is not None:
            pulumi.set(__self__, "workload", workload)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[builtins.str]:
        """
        The state of the pipeline. When the pipeline is created, the state is set to 'PIPELINE_STATE_ACTIVE' by default. State changes can be requested by setting the state to stopping, paused, or resuming. State cannot be changed through pipelines.patch requests.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#state
        Possible values are: `STATE_UNSPECIFIED`, `STATE_RESUMING`, `STATE_ACTIVE`, `STATE_STOPPING`, `STATE_ARCHIVED`, `STATE_PAUSED`.


        - - -
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the pipeline. This field affects the scheduling of the pipeline and the type of metrics to show for the pipeline.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#pipelinetype
        Possible values are: `PIPELINE_TYPE_UNSPECIFIED`, `PIPELINE_TYPE_BATCH`, `PIPELINE_TYPE_STREAMING`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the pipeline. It can contain only letters ([A-Za-z]), numbers ([0-9]), hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        "The pipeline name. For example': 'projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID."
        "- PROJECT_ID can contain letters ([A-Za-z]), numbers ([0-9]), hyphens (-), colons (:), and periods (.). For more information, see Identifying projects."
        "LOCATION_ID is the canonical ID for the pipeline's location. The list of available locations can be obtained by calling google.cloud.location.Locations.ListLocations. Note that the Data Pipelines service is not available in all regions. It depends on Cloud Scheduler, an App Engine application, so it's only available in App Engine regions."
        "PIPELINE_ID is the ID of the pipeline. Must be unique for the selected project and location."
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pipelineSources")
    def pipeline_sources(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The sources of the pipeline (for example, Dataplex). The keys and values are set by the corresponding sources during pipeline creation.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "pipeline_sources")

    @pipeline_sources.setter
    def pipeline_sources(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pipeline_sources", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to the region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="scheduleInfo")
    def schedule_info(self) -> Optional[pulumi.Input['PipelineScheduleInfoArgs']]:
        """
        Internal scheduling information for a pipeline. If this information is provided, periodic jobs will be created per the schedule. If not, users are responsible for creating jobs externally.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#schedulespec
        Structure is documented below.
        """
        return pulumi.get(self, "schedule_info")

    @schedule_info.setter
    def schedule_info(self, value: Optional[pulumi.Input['PipelineScheduleInfoArgs']]):
        pulumi.set(self, "schedule_info", value)

    @property
    @pulumi.getter(name="schedulerServiceAccountEmail")
    def scheduler_service_account_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. A service account email to be used with the Cloud Scheduler job. If not specified, the default compute engine service account will be used.
        """
        return pulumi.get(self, "scheduler_service_account_email")

    @scheduler_service_account_email.setter
    def scheduler_service_account_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scheduler_service_account_email", value)

    @property
    @pulumi.getter
    def workload(self) -> Optional[pulumi.Input['PipelineWorkloadArgs']]:
        """
        Workload information for creating new jobs.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#workload
        Structure is documented below.
        """
        return pulumi.get(self, "workload")

    @workload.setter
    def workload(self, value: Optional[pulumi.Input['PipelineWorkloadArgs']]):
        pulumi.set(self, "workload", value)


@pulumi.input_type
class _PipelineState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 job_count: Optional[pulumi.Input[builtins.int]] = None,
                 last_update_time: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_sources: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_info: Optional[pulumi.Input['PipelineScheduleInfoArgs']] = None,
                 scheduler_service_account_email: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 workload: Optional[pulumi.Input['PipelineWorkloadArgs']] = None):
        """
        Input properties used for looking up and filtering Pipeline resources.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the pipeline was initially created. Set by the Data Pipelines service.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] display_name: The display name of the pipeline. It can contain only letters ([A-Za-z]), numbers ([0-9]), hyphens (-), and underscores (_).
        :param pulumi.Input[builtins.int] job_count: Number of jobs.
        :param pulumi.Input[builtins.str] last_update_time: The timestamp when the pipeline was last modified. Set by the Data Pipelines service.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] name: "The pipeline name. For example': 'projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID."
               "- PROJECT_ID can contain letters ([A-Za-z]), numbers ([0-9]), hyphens (-), colons (:), and periods (.). For more information, see Identifying projects."
               "LOCATION_ID is the canonical ID for the pipeline's location. The list of available locations can be obtained by calling google.cloud.location.Locations.ListLocations. Note that the Data Pipelines service is not available in all regions. It depends on Cloud Scheduler, an App Engine application, so it's only available in App Engine regions."
               "PIPELINE_ID is the ID of the pipeline. Must be unique for the selected project and location."
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pipeline_sources: The sources of the pipeline (for example, Dataplex). The keys and values are set by the corresponding sources during pipeline creation.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: A reference to the region
        :param pulumi.Input['PipelineScheduleInfoArgs'] schedule_info: Internal scheduling information for a pipeline. If this information is provided, periodic jobs will be created per the schedule. If not, users are responsible for creating jobs externally.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#schedulespec
               Structure is documented below.
        :param pulumi.Input[builtins.str] scheduler_service_account_email: Optional. A service account email to be used with the Cloud Scheduler job. If not specified, the default compute engine service account will be used.
        :param pulumi.Input[builtins.str] state: The state of the pipeline. When the pipeline is created, the state is set to 'PIPELINE_STATE_ACTIVE' by default. State changes can be requested by setting the state to stopping, paused, or resuming. State cannot be changed through pipelines.patch requests.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#state
               Possible values are: `STATE_UNSPECIFIED`, `STATE_RESUMING`, `STATE_ACTIVE`, `STATE_STOPPING`, `STATE_ARCHIVED`, `STATE_PAUSED`.
               
               
               - - -
        :param pulumi.Input[builtins.str] type: The type of the pipeline. This field affects the scheduling of the pipeline and the type of metrics to show for the pipeline.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#pipelinetype
               Possible values are: `PIPELINE_TYPE_UNSPECIFIED`, `PIPELINE_TYPE_BATCH`, `PIPELINE_TYPE_STREAMING`.
        :param pulumi.Input['PipelineWorkloadArgs'] workload: Workload information for creating new jobs.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#workload
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if job_count is not None:
            pulumi.set(__self__, "job_count", job_count)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pipeline_sources is not None:
            pulumi.set(__self__, "pipeline_sources", pipeline_sources)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schedule_info is not None:
            pulumi.set(__self__, "schedule_info", schedule_info)
        if scheduler_service_account_email is not None:
            pulumi.set(__self__, "scheduler_service_account_email", scheduler_service_account_email)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if workload is not None:
            pulumi.set(__self__, "workload", workload)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the pipeline was initially created. Set by the Data Pipelines service.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the pipeline. It can contain only letters ([A-Za-z]), numbers ([0-9]), hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="jobCount")
    def job_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of jobs.
        """
        return pulumi.get(self, "job_count")

    @job_count.setter
    def job_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "job_count", value)

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the pipeline was last modified. Set by the Data Pipelines service.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_update_time")

    @last_update_time.setter
    def last_update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_update_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        "The pipeline name. For example': 'projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID."
        "- PROJECT_ID can contain letters ([A-Za-z]), numbers ([0-9]), hyphens (-), colons (:), and periods (.). For more information, see Identifying projects."
        "LOCATION_ID is the canonical ID for the pipeline's location. The list of available locations can be obtained by calling google.cloud.location.Locations.ListLocations. Note that the Data Pipelines service is not available in all regions. It depends on Cloud Scheduler, an App Engine application, so it's only available in App Engine regions."
        "PIPELINE_ID is the ID of the pipeline. Must be unique for the selected project and location."
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pipelineSources")
    def pipeline_sources(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The sources of the pipeline (for example, Dataplex). The keys and values are set by the corresponding sources during pipeline creation.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "pipeline_sources")

    @pipeline_sources.setter
    def pipeline_sources(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pipeline_sources", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to the region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="scheduleInfo")
    def schedule_info(self) -> Optional[pulumi.Input['PipelineScheduleInfoArgs']]:
        """
        Internal scheduling information for a pipeline. If this information is provided, periodic jobs will be created per the schedule. If not, users are responsible for creating jobs externally.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#schedulespec
        Structure is documented below.
        """
        return pulumi.get(self, "schedule_info")

    @schedule_info.setter
    def schedule_info(self, value: Optional[pulumi.Input['PipelineScheduleInfoArgs']]):
        pulumi.set(self, "schedule_info", value)

    @property
    @pulumi.getter(name="schedulerServiceAccountEmail")
    def scheduler_service_account_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. A service account email to be used with the Cloud Scheduler job. If not specified, the default compute engine service account will be used.
        """
        return pulumi.get(self, "scheduler_service_account_email")

    @scheduler_service_account_email.setter
    def scheduler_service_account_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scheduler_service_account_email", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the pipeline. When the pipeline is created, the state is set to 'PIPELINE_STATE_ACTIVE' by default. State changes can be requested by setting the state to stopping, paused, or resuming. State cannot be changed through pipelines.patch requests.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#state
        Possible values are: `STATE_UNSPECIFIED`, `STATE_RESUMING`, `STATE_ACTIVE`, `STATE_STOPPING`, `STATE_ARCHIVED`, `STATE_PAUSED`.


        - - -
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the pipeline. This field affects the scheduling of the pipeline and the type of metrics to show for the pipeline.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#pipelinetype
        Possible values are: `PIPELINE_TYPE_UNSPECIFIED`, `PIPELINE_TYPE_BATCH`, `PIPELINE_TYPE_STREAMING`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def workload(self) -> Optional[pulumi.Input['PipelineWorkloadArgs']]:
        """
        Workload information for creating new jobs.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#workload
        Structure is documented below.
        """
        return pulumi.get(self, "workload")

    @workload.setter
    def workload(self, value: Optional[pulumi.Input['PipelineWorkloadArgs']]):
        pulumi.set(self, "workload", value)


@pulumi.type_token("gcp:dataflow/pipeline:Pipeline")
class Pipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_sources: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_info: Optional[pulumi.Input[Union['PipelineScheduleInfoArgs', 'PipelineScheduleInfoArgsDict']]] = None,
                 scheduler_service_account_email: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 workload: Optional[pulumi.Input[Union['PipelineWorkloadArgs', 'PipelineWorkloadArgsDict']]] = None,
                 __props__=None):
        """
        The main pipeline entity and all the necessary metadata for launching and managing linked jobs.

        To get more information about Pipeline, see:

        * [API documentation](https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dataflow)

        ## Example Usage

        ### Data Pipeline Pipeline

        ```python
        import pulumi
        import pulumi_gcp as gcp

        service_account = gcp.serviceaccount.Account("service_account",
            account_id="my-account",
            display_name="Service Account")
        primary = gcp.dataflow.Pipeline("primary",
            name="my-pipeline",
            display_name="my-pipeline",
            type="PIPELINE_TYPE_BATCH",
            state="STATE_ACTIVE",
            region="us-central1",
            workload={
                "dataflow_launch_template_request": {
                    "project_id": "my-project",
                    "gcs_path": "gs://my-bucket/path",
                    "launch_parameters": {
                        "job_name": "my-job",
                        "parameters": {
                            "name": "wrench",
                        },
                        "environment": {
                            "num_workers": 5,
                            "max_workers": 5,
                            "zone": "us-centra1-a",
                            "service_account_email": service_account.email,
                            "network": "default",
                            "temp_location": "gs://my-bucket/tmp_dir",
                            "bypass_temp_dir_validation": False,
                            "machine_type": "E2",
                            "additional_user_labels": {
                                "context": "test",
                            },
                            "worker_region": "us-central1",
                            "worker_zone": "us-central1-a",
                            "enable_streaming_engine": False,
                        },
                        "update": False,
                        "transform_name_mapping": {
                            "name": "wrench",
                        },
                    },
                    "location": "us-central1",
                },
            },
            schedule_info={
                "schedule": "* */2 * * *",
            })
        ```

        ## Import

        Pipeline can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/pipelines/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Pipeline can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataflow/pipeline:Pipeline default projects/{{project}}/locations/{{region}}/pipelines/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dataflow/pipeline:Pipeline default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dataflow/pipeline:Pipeline default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dataflow/pipeline:Pipeline default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: The display name of the pipeline. It can contain only letters ([A-Za-z]), numbers ([0-9]), hyphens (-), and underscores (_).
        :param pulumi.Input[builtins.str] name: "The pipeline name. For example': 'projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID."
               "- PROJECT_ID can contain letters ([A-Za-z]), numbers ([0-9]), hyphens (-), colons (:), and periods (.). For more information, see Identifying projects."
               "LOCATION_ID is the canonical ID for the pipeline's location. The list of available locations can be obtained by calling google.cloud.location.Locations.ListLocations. Note that the Data Pipelines service is not available in all regions. It depends on Cloud Scheduler, an App Engine application, so it's only available in App Engine regions."
               "PIPELINE_ID is the ID of the pipeline. Must be unique for the selected project and location."
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pipeline_sources: The sources of the pipeline (for example, Dataplex). The keys and values are set by the corresponding sources during pipeline creation.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: A reference to the region
        :param pulumi.Input[Union['PipelineScheduleInfoArgs', 'PipelineScheduleInfoArgsDict']] schedule_info: Internal scheduling information for a pipeline. If this information is provided, periodic jobs will be created per the schedule. If not, users are responsible for creating jobs externally.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#schedulespec
               Structure is documented below.
        :param pulumi.Input[builtins.str] scheduler_service_account_email: Optional. A service account email to be used with the Cloud Scheduler job. If not specified, the default compute engine service account will be used.
        :param pulumi.Input[builtins.str] state: The state of the pipeline. When the pipeline is created, the state is set to 'PIPELINE_STATE_ACTIVE' by default. State changes can be requested by setting the state to stopping, paused, or resuming. State cannot be changed through pipelines.patch requests.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#state
               Possible values are: `STATE_UNSPECIFIED`, `STATE_RESUMING`, `STATE_ACTIVE`, `STATE_STOPPING`, `STATE_ARCHIVED`, `STATE_PAUSED`.
               
               
               - - -
        :param pulumi.Input[builtins.str] type: The type of the pipeline. This field affects the scheduling of the pipeline and the type of metrics to show for the pipeline.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#pipelinetype
               Possible values are: `PIPELINE_TYPE_UNSPECIFIED`, `PIPELINE_TYPE_BATCH`, `PIPELINE_TYPE_STREAMING`.
        :param pulumi.Input[Union['PipelineWorkloadArgs', 'PipelineWorkloadArgsDict']] workload: Workload information for creating new jobs.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#workload
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The main pipeline entity and all the necessary metadata for launching and managing linked jobs.

        To get more information about Pipeline, see:

        * [API documentation](https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dataflow)

        ## Example Usage

        ### Data Pipeline Pipeline

        ```python
        import pulumi
        import pulumi_gcp as gcp

        service_account = gcp.serviceaccount.Account("service_account",
            account_id="my-account",
            display_name="Service Account")
        primary = gcp.dataflow.Pipeline("primary",
            name="my-pipeline",
            display_name="my-pipeline",
            type="PIPELINE_TYPE_BATCH",
            state="STATE_ACTIVE",
            region="us-central1",
            workload={
                "dataflow_launch_template_request": {
                    "project_id": "my-project",
                    "gcs_path": "gs://my-bucket/path",
                    "launch_parameters": {
                        "job_name": "my-job",
                        "parameters": {
                            "name": "wrench",
                        },
                        "environment": {
                            "num_workers": 5,
                            "max_workers": 5,
                            "zone": "us-centra1-a",
                            "service_account_email": service_account.email,
                            "network": "default",
                            "temp_location": "gs://my-bucket/tmp_dir",
                            "bypass_temp_dir_validation": False,
                            "machine_type": "E2",
                            "additional_user_labels": {
                                "context": "test",
                            },
                            "worker_region": "us-central1",
                            "worker_zone": "us-central1-a",
                            "enable_streaming_engine": False,
                        },
                        "update": False,
                        "transform_name_mapping": {
                            "name": "wrench",
                        },
                    },
                    "location": "us-central1",
                },
            },
            schedule_info={
                "schedule": "* */2 * * *",
            })
        ```

        ## Import

        Pipeline can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/pipelines/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Pipeline can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataflow/pipeline:Pipeline default projects/{{project}}/locations/{{region}}/pipelines/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dataflow/pipeline:Pipeline default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dataflow/pipeline:Pipeline default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dataflow/pipeline:Pipeline default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param PipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_sources: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_info: Optional[pulumi.Input[Union['PipelineScheduleInfoArgs', 'PipelineScheduleInfoArgsDict']]] = None,
                 scheduler_service_account_email: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 workload: Optional[pulumi.Input[Union['PipelineWorkloadArgs', 'PipelineWorkloadArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineArgs.__new__(PipelineArgs)

            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["name"] = name
            __props__.__dict__["pipeline_sources"] = pipeline_sources
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["schedule_info"] = schedule_info
            __props__.__dict__["scheduler_service_account_email"] = scheduler_service_account_email
            if state is None and not opts.urn:
                raise TypeError("Missing required property 'state'")
            __props__.__dict__["state"] = state
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["workload"] = workload
            __props__.__dict__["create_time"] = None
            __props__.__dict__["job_count"] = None
            __props__.__dict__["last_update_time"] = None
        super(Pipeline, __self__).__init__(
            'gcp:dataflow/pipeline:Pipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            job_count: Optional[pulumi.Input[builtins.int]] = None,
            last_update_time: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            pipeline_sources: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            schedule_info: Optional[pulumi.Input[Union['PipelineScheduleInfoArgs', 'PipelineScheduleInfoArgsDict']]] = None,
            scheduler_service_account_email: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            workload: Optional[pulumi.Input[Union['PipelineWorkloadArgs', 'PipelineWorkloadArgsDict']]] = None) -> 'Pipeline':
        """
        Get an existing Pipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the pipeline was initially created. Set by the Data Pipelines service.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] display_name: The display name of the pipeline. It can contain only letters ([A-Za-z]), numbers ([0-9]), hyphens (-), and underscores (_).
        :param pulumi.Input[builtins.int] job_count: Number of jobs.
        :param pulumi.Input[builtins.str] last_update_time: The timestamp when the pipeline was last modified. Set by the Data Pipelines service.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] name: "The pipeline name. For example': 'projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID."
               "- PROJECT_ID can contain letters ([A-Za-z]), numbers ([0-9]), hyphens (-), colons (:), and periods (.). For more information, see Identifying projects."
               "LOCATION_ID is the canonical ID for the pipeline's location. The list of available locations can be obtained by calling google.cloud.location.Locations.ListLocations. Note that the Data Pipelines service is not available in all regions. It depends on Cloud Scheduler, an App Engine application, so it's only available in App Engine regions."
               "PIPELINE_ID is the ID of the pipeline. Must be unique for the selected project and location."
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pipeline_sources: The sources of the pipeline (for example, Dataplex). The keys and values are set by the corresponding sources during pipeline creation.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: A reference to the region
        :param pulumi.Input[Union['PipelineScheduleInfoArgs', 'PipelineScheduleInfoArgsDict']] schedule_info: Internal scheduling information for a pipeline. If this information is provided, periodic jobs will be created per the schedule. If not, users are responsible for creating jobs externally.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#schedulespec
               Structure is documented below.
        :param pulumi.Input[builtins.str] scheduler_service_account_email: Optional. A service account email to be used with the Cloud Scheduler job. If not specified, the default compute engine service account will be used.
        :param pulumi.Input[builtins.str] state: The state of the pipeline. When the pipeline is created, the state is set to 'PIPELINE_STATE_ACTIVE' by default. State changes can be requested by setting the state to stopping, paused, or resuming. State cannot be changed through pipelines.patch requests.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#state
               Possible values are: `STATE_UNSPECIFIED`, `STATE_RESUMING`, `STATE_ACTIVE`, `STATE_STOPPING`, `STATE_ARCHIVED`, `STATE_PAUSED`.
               
               
               - - -
        :param pulumi.Input[builtins.str] type: The type of the pipeline. This field affects the scheduling of the pipeline and the type of metrics to show for the pipeline.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#pipelinetype
               Possible values are: `PIPELINE_TYPE_UNSPECIFIED`, `PIPELINE_TYPE_BATCH`, `PIPELINE_TYPE_STREAMING`.
        :param pulumi.Input[Union['PipelineWorkloadArgs', 'PipelineWorkloadArgsDict']] workload: Workload information for creating new jobs.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#workload
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineState.__new__(_PipelineState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["job_count"] = job_count
        __props__.__dict__["last_update_time"] = last_update_time
        __props__.__dict__["name"] = name
        __props__.__dict__["pipeline_sources"] = pipeline_sources
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["schedule_info"] = schedule_info
        __props__.__dict__["scheduler_service_account_email"] = scheduler_service_account_email
        __props__.__dict__["state"] = state
        __props__.__dict__["type"] = type
        __props__.__dict__["workload"] = workload
        return Pipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the pipeline was initially created. Set by the Data Pipelines service.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The display name of the pipeline. It can contain only letters ([A-Za-z]), numbers ([0-9]), hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="jobCount")
    def job_count(self) -> pulumi.Output[builtins.int]:
        """
        Number of jobs.
        """
        return pulumi.get(self, "job_count")

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the pipeline was last modified. Set by the Data Pipelines service.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_update_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        "The pipeline name. For example': 'projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID."
        "- PROJECT_ID can contain letters ([A-Za-z]), numbers ([0-9]), hyphens (-), colons (:), and periods (.). For more information, see Identifying projects."
        "LOCATION_ID is the canonical ID for the pipeline's location. The list of available locations can be obtained by calling google.cloud.location.Locations.ListLocations. Note that the Data Pipelines service is not available in all regions. It depends on Cloud Scheduler, an App Engine application, so it's only available in App Engine regions."
        "PIPELINE_ID is the ID of the pipeline. Must be unique for the selected project and location."
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pipelineSources")
    def pipeline_sources(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The sources of the pipeline (for example, Dataplex). The keys and values are set by the corresponding sources during pipeline creation.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "pipeline_sources")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A reference to the region
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="scheduleInfo")
    def schedule_info(self) -> pulumi.Output[Optional['outputs.PipelineScheduleInfo']]:
        """
        Internal scheduling information for a pipeline. If this information is provided, periodic jobs will be created per the schedule. If not, users are responsible for creating jobs externally.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#schedulespec
        Structure is documented below.
        """
        return pulumi.get(self, "schedule_info")

    @property
    @pulumi.getter(name="schedulerServiceAccountEmail")
    def scheduler_service_account_email(self) -> pulumi.Output[builtins.str]:
        """
        Optional. A service account email to be used with the Cloud Scheduler job. If not specified, the default compute engine service account will be used.
        """
        return pulumi.get(self, "scheduler_service_account_email")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state of the pipeline. When the pipeline is created, the state is set to 'PIPELINE_STATE_ACTIVE' by default. State changes can be requested by setting the state to stopping, paused, or resuming. State cannot be changed through pipelines.patch requests.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#state
        Possible values are: `STATE_UNSPECIFIED`, `STATE_RESUMING`, `STATE_ACTIVE`, `STATE_STOPPING`, `STATE_ARCHIVED`, `STATE_PAUSED`.


        - - -
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the pipeline. This field affects the scheduling of the pipeline and the type of metrics to show for the pipeline.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#pipelinetype
        Possible values are: `PIPELINE_TYPE_UNSPECIFIED`, `PIPELINE_TYPE_BATCH`, `PIPELINE_TYPE_STREAMING`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def workload(self) -> pulumi.Output[Optional['outputs.PipelineWorkload']]:
        """
        Workload information for creating new jobs.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#workload
        Structure is documented below.
        """
        return pulumi.get(self, "workload")

