# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PreventionJobTriggerArgs', 'PreventionJobTrigger']

@pulumi.input_type
class PreventionJobTriggerArgs:
    def __init__(__self__, *,
                 parent: pulumi.Input[builtins.str],
                 triggers: pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 inspect_job: Optional[pulumi.Input['PreventionJobTriggerInspectJobArgs']] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 trigger_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PreventionJobTrigger resource.
        :param pulumi.Input[builtins.str] parent: The parent of the trigger, either in the format `projects/{{project}}`
               or `projects/{{project}}/locations/{{location}}`
        :param pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]] triggers: What event needs to occur for a new job to be started.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A description of the job trigger.
        :param pulumi.Input[builtins.str] display_name: User set display name of the job trigger.
        :param pulumi.Input['PreventionJobTriggerInspectJobArgs'] inspect_job: Controls what and how to inspect for findings.
        :param pulumi.Input[builtins.str] status: Whether the trigger is currently active. Default value: "HEALTHY" Possible values: ["PAUSED", "HEALTHY", "CANCELLED"]
        :param pulumi.Input[builtins.str] trigger_id: The trigger id can contain uppercase and lowercase letters, numbers, and hyphens; that is, it must match the regular
               expression: [a-zA-Z\\d-_]+. The maximum length is 100 characters. Can be empty to allow the system to generate one.
        """
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "triggers", triggers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if inspect_job is not None:
            pulumi.set(__self__, "inspect_job", inspect_job)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[builtins.str]:
        """
        The parent of the trigger, either in the format `projects/{{project}}`
        or `projects/{{project}}/locations/{{location}}`
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]]:
        """
        What event needs to occur for a new job to be started.
        Structure is documented below.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]]):
        pulumi.set(self, "triggers", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the job trigger.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User set display name of the job trigger.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="inspectJob")
    def inspect_job(self) -> Optional[pulumi.Input['PreventionJobTriggerInspectJobArgs']]:
        """
        Controls what and how to inspect for findings.
        """
        return pulumi.get(self, "inspect_job")

    @inspect_job.setter
    def inspect_job(self, value: Optional[pulumi.Input['PreventionJobTriggerInspectJobArgs']]):
        pulumi.set(self, "inspect_job", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether the trigger is currently active. Default value: "HEALTHY" Possible values: ["PAUSED", "HEALTHY", "CANCELLED"]
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The trigger id can contain uppercase and lowercase letters, numbers, and hyphens; that is, it must match the regular
        expression: [a-zA-Z\\d-_]+. The maximum length is 100 characters. Can be empty to allow the system to generate one.
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trigger_id", value)


@pulumi.input_type
class _PreventionJobTriggerState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 inspect_job: Optional[pulumi.Input['PreventionJobTriggerInspectJobArgs']] = None,
                 last_run_time: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 trigger_id: Optional[pulumi.Input[builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PreventionJobTrigger resources.
        :param pulumi.Input[builtins.str] create_time: The creation timestamp of an inspectTemplate. Set by the server.
        :param pulumi.Input[builtins.str] description: A description of the job trigger.
        :param pulumi.Input[builtins.str] display_name: User set display name of the job trigger.
        :param pulumi.Input['PreventionJobTriggerInspectJobArgs'] inspect_job: Controls what and how to inspect for findings.
        :param pulumi.Input[builtins.str] last_run_time: The timestamp of the last time this trigger executed.
        :param pulumi.Input[builtins.str] name: The resource name of the job trigger. Set by the server.
        :param pulumi.Input[builtins.str] parent: The parent of the trigger, either in the format `projects/{{project}}`
               or `projects/{{project}}/locations/{{location}}`
        :param pulumi.Input[builtins.str] status: Whether the trigger is currently active. Default value: "HEALTHY" Possible values: ["PAUSED", "HEALTHY", "CANCELLED"]
        :param pulumi.Input[builtins.str] trigger_id: The trigger id can contain uppercase and lowercase letters, numbers, and hyphens; that is, it must match the regular
               expression: [a-zA-Z\\d-_]+. The maximum length is 100 characters. Can be empty to allow the system to generate one.
        :param pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]] triggers: What event needs to occur for a new job to be started.
               Structure is documented below.
        :param pulumi.Input[builtins.str] update_time: The last update timestamp of an inspectTemplate. Set by the server.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if inspect_job is not None:
            pulumi.set(__self__, "inspect_job", inspect_job)
        if last_run_time is not None:
            pulumi.set(__self__, "last_run_time", last_run_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation timestamp of an inspectTemplate. Set by the server.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the job trigger.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User set display name of the job trigger.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="inspectJob")
    def inspect_job(self) -> Optional[pulumi.Input['PreventionJobTriggerInspectJobArgs']]:
        """
        Controls what and how to inspect for findings.
        """
        return pulumi.get(self, "inspect_job")

    @inspect_job.setter
    def inspect_job(self, value: Optional[pulumi.Input['PreventionJobTriggerInspectJobArgs']]):
        pulumi.set(self, "inspect_job", value)

    @property
    @pulumi.getter(name="lastRunTime")
    def last_run_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp of the last time this trigger executed.
        """
        return pulumi.get(self, "last_run_time")

    @last_run_time.setter
    def last_run_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_run_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the job trigger. Set by the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The parent of the trigger, either in the format `projects/{{project}}`
        or `projects/{{project}}/locations/{{location}}`
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether the trigger is currently active. Default value: "HEALTHY" Possible values: ["PAUSED", "HEALTHY", "CANCELLED"]
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The trigger id can contain uppercase and lowercase letters, numbers, and hyphens; that is, it must match the regular
        expression: [a-zA-Z\\d-_]+. The maximum length is 100 characters. Can be empty to allow the system to generate one.
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trigger_id", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]]]:
        """
        What event needs to occur for a new job to be started.
        Structure is documented below.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]]]):
        pulumi.set(self, "triggers", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last update timestamp of an inspectTemplate. Set by the server.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:dataloss/preventionJobTrigger:PreventionJobTrigger")
class PreventionJobTrigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 inspect_job: Optional[pulumi.Input[Union['PreventionJobTriggerInspectJobArgs', 'PreventionJobTriggerInspectJobArgsDict']]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 trigger_id: Optional[pulumi.Input[builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PreventionJobTriggerTriggerArgs', 'PreventionJobTriggerTriggerArgsDict']]]]] = None,
                 __props__=None):
        """
        A job trigger configuration.

        To get more information about JobTrigger, see:

        * [API documentation](https://cloud.google.com/dlp/docs/reference/rest/v2/projects.jobTriggers)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dlp/docs/creating-job-triggers)

        ## Example Usage

        ### Dlp Job Trigger Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionJobTrigger("basic",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "dataset",
                            },
                        },
                    },
                }],
                "storage_config": {
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger Bigquery Row Limit

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bigquery_row_limit = gcp.dataloss.PreventionJobTrigger("bigquery_row_limit",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "dataset",
                            },
                        },
                    },
                }],
                "storage_config": {
                    "big_query_options": {
                        "table_reference": {
                            "project_id": "project",
                            "dataset_id": "dataset",
                            "table_id": "table_to_scan",
                        },
                        "rows_limit": 1000,
                        "sample_method": "RANDOM_START",
                    },
                },
            })
        ```
        ### Dlp Job Trigger Bigquery Row Limit Percentage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bigquery_row_limit_percentage = gcp.dataloss.PreventionJobTrigger("bigquery_row_limit_percentage",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "dataset",
                            },
                        },
                    },
                }],
                "storage_config": {
                    "big_query_options": {
                        "table_reference": {
                            "project_id": "project",
                            "dataset_id": "dataset",
                            "table_id": "table_to_scan",
                        },
                        "rows_limit_percent": 50,
                        "sample_method": "RANDOM_START",
                    },
                },
            })
        ```
        ### Dlp Job Trigger Job Notification Emails

        ```python
        import pulumi
        import pulumi_gcp as gcp

        job_notification_emails = gcp.dataloss.PreventionJobTrigger("job_notification_emails",
            parent="projects/my-project-name",
            description="Description for the job_trigger created by terraform",
            display_name="TerraformDisplayName",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "sample-inspect-template",
                "actions": [{
                    "job_notification_emails": {},
                }],
                "storage_config": {
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger Deidentify

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.bigquery.Dataset("default",
            dataset_id="tf_test",
            friendly_name="terraform-test",
            description="Description for the dataset created by terraform",
            location="US",
            default_table_expiration_ms=3600000,
            labels={
                "env": "default",
            })
        default_table = gcp.bigquery.Table("default",
            dataset_id=default.dataset_id,
            table_id="tf_test",
            deletion_protection=False,
            time_partitioning={
                "type": "DAY",
            },
            labels={
                "env": "default",
            },
            schema=\"\"\"    [
            {
              "name": "quantity",
              "type": "NUMERIC",
              "mode": "NULLABLE",
              "description": "The quantity"
            },
            {
              "name": "name",
              "type": "STRING",
              "mode": "NULLABLE",
              "description": "Name of the object"
            }
            ]
        \"\"\")
        deidentify = gcp.dataloss.PreventionJobTrigger("deidentify",
            parent="projects/my-project-name",
            description="Description for the job_trigger created by terraform",
            display_name="TerraformDisplayName",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "sample-inspect-template",
                "actions": [{
                    "deidentify": {
                        "cloud_storage_output": "gs://samplebucket/dir/",
                        "file_types_to_transforms": [
                            "CSV",
                            "TSV",
                        ],
                        "transformation_details_storage_config": {
                            "table": {
                                "project_id": "my-project-name",
                                "dataset_id": default.dataset_id,
                                "table_id": default_table.table_id,
                            },
                        },
                        "transformation_config": {
                            "deidentify_template": "sample-deidentify-template",
                            "image_redact_template": "sample-image-redact-template",
                            "structured_deidentify_template": "sample-structured-deidentify-template",
                        },
                    },
                }],
                "storage_config": {
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger Hybrid

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hybrid_trigger = gcp.dataloss.PreventionJobTrigger("hybrid_trigger",
            parent="projects/my-project-name",
            triggers=[{
                "manual": {},
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "dataset",
                            },
                        },
                    },
                }],
                "storage_config": {
                    "hybrid_options": {
                        "description": "Hybrid job trigger for data from the comments field of a table that contains customer appointment bookings",
                        "required_finding_label_keys": ["appointment-bookings-comments"],
                        "labels": {
                            "env": "prod",
                        },
                        "table_options": {
                            "identifying_fields": [{
                                "name": "booking_id",
                            }],
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger Inspect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        inspect = gcp.dataloss.PreventionJobTrigger("inspect",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "dataset",
                            },
                        },
                    },
                }],
                "storage_config": {
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
                "inspect_config": {
                    "custom_info_types": [{
                        "info_type": {
                            "name": "MY_CUSTOM_TYPE",
                        },
                        "likelihood": "UNLIKELY",
                        "regex": {
                            "pattern": "test*",
                        },
                    }],
                    "info_types": [{
                        "name": "EMAIL_ADDRESS",
                    }],
                    "min_likelihood": "UNLIKELY",
                    "rule_sets": [
                        {
                            "info_types": [{
                                "name": "EMAIL_ADDRESS",
                            }],
                            "rules": [{
                                "exclusion_rule": {
                                    "regex": {
                                        "pattern": ".+@example.com",
                                    },
                                    "matching_type": "MATCHING_TYPE_FULL_MATCH",
                                },
                            }],
                        },
                        {
                            "info_types": [{
                                "name": "MY_CUSTOM_TYPE",
                            }],
                            "rules": [{
                                "hotword_rule": {
                                    "hotword_regex": {
                                        "pattern": "example*",
                                    },
                                    "proximity": {
                                        "window_before": 50,
                                    },
                                    "likelihood_adjustment": {
                                        "fixed_likelihood": "VERY_LIKELY",
                                    },
                                },
                            }],
                        },
                    ],
                    "limits": {
                        "max_findings_per_item": 10,
                        "max_findings_per_request": 50,
                    },
                },
            })
        ```
        ### Dlp Job Trigger Publish To Stackdriver

        ```python
        import pulumi
        import pulumi_gcp as gcp

        publish_to_stackdriver = gcp.dataloss.PreventionJobTrigger("publish_to_stackdriver",
            parent="projects/my-project-name",
            description="Description for the job_trigger created by terraform",
            display_name="TerraformDisplayName",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "sample-inspect-template",
                "actions": [{
                    "publish_to_stackdriver": {},
                }],
                "storage_config": {
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger With Id

        ```python
        import pulumi
        import pulumi_gcp as gcp

        with_trigger_id = gcp.dataloss.PreventionJobTrigger("with_trigger_id",
            parent="projects/my-project-name",
            description="Starting description",
            display_name="display",
            trigger_id="id-",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "dataset123",
                            },
                        },
                    },
                }],
                "storage_config": {
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger Multiple Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionJobTrigger("basic",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [
                    {
                        "save_findings": {
                            "output_config": {
                                "table": {
                                    "project_id": "project",
                                    "dataset_id": "dataset",
                                },
                            },
                        },
                    },
                    {
                        "pub_sub": {
                            "topic": "projects/project/topics/topic-name",
                        },
                    },
                ],
                "storage_config": {
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger Cloud Storage Optional Timespan Autopopulation

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionJobTrigger("basic",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "dataset",
                            },
                        },
                    },
                }],
                "storage_config": {
                    "timespan_config": {
                        "enable_auto_population_of_timespan_config": True,
                    },
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger Timespan Config Big Query

        ```python
        import pulumi
        import pulumi_gcp as gcp

        timespan_config_big_query = gcp.dataloss.PreventionJobTrigger("timespan_config_big_query",
            parent="projects/my-project-name",
            description="BigQuery DLP Job Trigger with timespan config and row limit",
            display_name="bigquery-dlp-job-trigger-limit-timespan",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "projects/test/locations/global/inspectTemplates/6425492983381733900",
                "storage_config": {
                    "big_query_options": {
                        "table_reference": {
                            "project_id": "project",
                            "dataset_id": "dataset",
                            "table_id": "table",
                        },
                        "sample_method": "",
                    },
                    "timespan_config": {
                        "start_time": "2023-01-01T00:00:23Z",
                        "timestamp_field": {
                            "name": "timestamp",
                        },
                    },
                },
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "output",
                            },
                        },
                    },
                }],
            })
        ```

        ## Import

        JobTrigger can be imported using any of these accepted formats:

        * `{{parent}}/jobTriggers/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, JobTrigger can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataloss/preventionJobTrigger:PreventionJobTrigger default {{parent}}/jobTriggers/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dataloss/preventionJobTrigger:PreventionJobTrigger default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description of the job trigger.
        :param pulumi.Input[builtins.str] display_name: User set display name of the job trigger.
        :param pulumi.Input[Union['PreventionJobTriggerInspectJobArgs', 'PreventionJobTriggerInspectJobArgsDict']] inspect_job: Controls what and how to inspect for findings.
        :param pulumi.Input[builtins.str] parent: The parent of the trigger, either in the format `projects/{{project}}`
               or `projects/{{project}}/locations/{{location}}`
        :param pulumi.Input[builtins.str] status: Whether the trigger is currently active. Default value: "HEALTHY" Possible values: ["PAUSED", "HEALTHY", "CANCELLED"]
        :param pulumi.Input[builtins.str] trigger_id: The trigger id can contain uppercase and lowercase letters, numbers, and hyphens; that is, it must match the regular
               expression: [a-zA-Z\\d-_]+. The maximum length is 100 characters. Can be empty to allow the system to generate one.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PreventionJobTriggerTriggerArgs', 'PreventionJobTriggerTriggerArgsDict']]]] triggers: What event needs to occur for a new job to be started.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PreventionJobTriggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A job trigger configuration.

        To get more information about JobTrigger, see:

        * [API documentation](https://cloud.google.com/dlp/docs/reference/rest/v2/projects.jobTriggers)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dlp/docs/creating-job-triggers)

        ## Example Usage

        ### Dlp Job Trigger Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionJobTrigger("basic",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "dataset",
                            },
                        },
                    },
                }],
                "storage_config": {
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger Bigquery Row Limit

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bigquery_row_limit = gcp.dataloss.PreventionJobTrigger("bigquery_row_limit",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "dataset",
                            },
                        },
                    },
                }],
                "storage_config": {
                    "big_query_options": {
                        "table_reference": {
                            "project_id": "project",
                            "dataset_id": "dataset",
                            "table_id": "table_to_scan",
                        },
                        "rows_limit": 1000,
                        "sample_method": "RANDOM_START",
                    },
                },
            })
        ```
        ### Dlp Job Trigger Bigquery Row Limit Percentage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bigquery_row_limit_percentage = gcp.dataloss.PreventionJobTrigger("bigquery_row_limit_percentage",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "dataset",
                            },
                        },
                    },
                }],
                "storage_config": {
                    "big_query_options": {
                        "table_reference": {
                            "project_id": "project",
                            "dataset_id": "dataset",
                            "table_id": "table_to_scan",
                        },
                        "rows_limit_percent": 50,
                        "sample_method": "RANDOM_START",
                    },
                },
            })
        ```
        ### Dlp Job Trigger Job Notification Emails

        ```python
        import pulumi
        import pulumi_gcp as gcp

        job_notification_emails = gcp.dataloss.PreventionJobTrigger("job_notification_emails",
            parent="projects/my-project-name",
            description="Description for the job_trigger created by terraform",
            display_name="TerraformDisplayName",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "sample-inspect-template",
                "actions": [{
                    "job_notification_emails": {},
                }],
                "storage_config": {
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger Deidentify

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.bigquery.Dataset("default",
            dataset_id="tf_test",
            friendly_name="terraform-test",
            description="Description for the dataset created by terraform",
            location="US",
            default_table_expiration_ms=3600000,
            labels={
                "env": "default",
            })
        default_table = gcp.bigquery.Table("default",
            dataset_id=default.dataset_id,
            table_id="tf_test",
            deletion_protection=False,
            time_partitioning={
                "type": "DAY",
            },
            labels={
                "env": "default",
            },
            schema=\"\"\"    [
            {
              "name": "quantity",
              "type": "NUMERIC",
              "mode": "NULLABLE",
              "description": "The quantity"
            },
            {
              "name": "name",
              "type": "STRING",
              "mode": "NULLABLE",
              "description": "Name of the object"
            }
            ]
        \"\"\")
        deidentify = gcp.dataloss.PreventionJobTrigger("deidentify",
            parent="projects/my-project-name",
            description="Description for the job_trigger created by terraform",
            display_name="TerraformDisplayName",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "sample-inspect-template",
                "actions": [{
                    "deidentify": {
                        "cloud_storage_output": "gs://samplebucket/dir/",
                        "file_types_to_transforms": [
                            "CSV",
                            "TSV",
                        ],
                        "transformation_details_storage_config": {
                            "table": {
                                "project_id": "my-project-name",
                                "dataset_id": default.dataset_id,
                                "table_id": default_table.table_id,
                            },
                        },
                        "transformation_config": {
                            "deidentify_template": "sample-deidentify-template",
                            "image_redact_template": "sample-image-redact-template",
                            "structured_deidentify_template": "sample-structured-deidentify-template",
                        },
                    },
                }],
                "storage_config": {
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger Hybrid

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hybrid_trigger = gcp.dataloss.PreventionJobTrigger("hybrid_trigger",
            parent="projects/my-project-name",
            triggers=[{
                "manual": {},
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "dataset",
                            },
                        },
                    },
                }],
                "storage_config": {
                    "hybrid_options": {
                        "description": "Hybrid job trigger for data from the comments field of a table that contains customer appointment bookings",
                        "required_finding_label_keys": ["appointment-bookings-comments"],
                        "labels": {
                            "env": "prod",
                        },
                        "table_options": {
                            "identifying_fields": [{
                                "name": "booking_id",
                            }],
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger Inspect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        inspect = gcp.dataloss.PreventionJobTrigger("inspect",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "dataset",
                            },
                        },
                    },
                }],
                "storage_config": {
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
                "inspect_config": {
                    "custom_info_types": [{
                        "info_type": {
                            "name": "MY_CUSTOM_TYPE",
                        },
                        "likelihood": "UNLIKELY",
                        "regex": {
                            "pattern": "test*",
                        },
                    }],
                    "info_types": [{
                        "name": "EMAIL_ADDRESS",
                    }],
                    "min_likelihood": "UNLIKELY",
                    "rule_sets": [
                        {
                            "info_types": [{
                                "name": "EMAIL_ADDRESS",
                            }],
                            "rules": [{
                                "exclusion_rule": {
                                    "regex": {
                                        "pattern": ".+@example.com",
                                    },
                                    "matching_type": "MATCHING_TYPE_FULL_MATCH",
                                },
                            }],
                        },
                        {
                            "info_types": [{
                                "name": "MY_CUSTOM_TYPE",
                            }],
                            "rules": [{
                                "hotword_rule": {
                                    "hotword_regex": {
                                        "pattern": "example*",
                                    },
                                    "proximity": {
                                        "window_before": 50,
                                    },
                                    "likelihood_adjustment": {
                                        "fixed_likelihood": "VERY_LIKELY",
                                    },
                                },
                            }],
                        },
                    ],
                    "limits": {
                        "max_findings_per_item": 10,
                        "max_findings_per_request": 50,
                    },
                },
            })
        ```
        ### Dlp Job Trigger Publish To Stackdriver

        ```python
        import pulumi
        import pulumi_gcp as gcp

        publish_to_stackdriver = gcp.dataloss.PreventionJobTrigger("publish_to_stackdriver",
            parent="projects/my-project-name",
            description="Description for the job_trigger created by terraform",
            display_name="TerraformDisplayName",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "sample-inspect-template",
                "actions": [{
                    "publish_to_stackdriver": {},
                }],
                "storage_config": {
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger With Id

        ```python
        import pulumi
        import pulumi_gcp as gcp

        with_trigger_id = gcp.dataloss.PreventionJobTrigger("with_trigger_id",
            parent="projects/my-project-name",
            description="Starting description",
            display_name="display",
            trigger_id="id-",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "dataset123",
                            },
                        },
                    },
                }],
                "storage_config": {
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger Multiple Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionJobTrigger("basic",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [
                    {
                        "save_findings": {
                            "output_config": {
                                "table": {
                                    "project_id": "project",
                                    "dataset_id": "dataset",
                                },
                            },
                        },
                    },
                    {
                        "pub_sub": {
                            "topic": "projects/project/topics/topic-name",
                        },
                    },
                ],
                "storage_config": {
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger Cloud Storage Optional Timespan Autopopulation

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionJobTrigger("basic",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "fake",
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "dataset",
                            },
                        },
                    },
                }],
                "storage_config": {
                    "timespan_config": {
                        "enable_auto_population_of_timespan_config": True,
                    },
                    "cloud_storage_options": {
                        "file_set": {
                            "url": "gs://mybucket/directory/",
                        },
                    },
                },
            })
        ```
        ### Dlp Job Trigger Timespan Config Big Query

        ```python
        import pulumi
        import pulumi_gcp as gcp

        timespan_config_big_query = gcp.dataloss.PreventionJobTrigger("timespan_config_big_query",
            parent="projects/my-project-name",
            description="BigQuery DLP Job Trigger with timespan config and row limit",
            display_name="bigquery-dlp-job-trigger-limit-timespan",
            triggers=[{
                "schedule": {
                    "recurrence_period_duration": "86400s",
                },
            }],
            inspect_job={
                "inspect_template_name": "projects/test/locations/global/inspectTemplates/6425492983381733900",
                "storage_config": {
                    "big_query_options": {
                        "table_reference": {
                            "project_id": "project",
                            "dataset_id": "dataset",
                            "table_id": "table",
                        },
                        "sample_method": "",
                    },
                    "timespan_config": {
                        "start_time": "2023-01-01T00:00:23Z",
                        "timestamp_field": {
                            "name": "timestamp",
                        },
                    },
                },
                "actions": [{
                    "save_findings": {
                        "output_config": {
                            "table": {
                                "project_id": "project",
                                "dataset_id": "output",
                            },
                        },
                    },
                }],
            })
        ```

        ## Import

        JobTrigger can be imported using any of these accepted formats:

        * `{{parent}}/jobTriggers/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, JobTrigger can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataloss/preventionJobTrigger:PreventionJobTrigger default {{parent}}/jobTriggers/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dataloss/preventionJobTrigger:PreventionJobTrigger default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param PreventionJobTriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PreventionJobTriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 inspect_job: Optional[pulumi.Input[Union['PreventionJobTriggerInspectJobArgs', 'PreventionJobTriggerInspectJobArgsDict']]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 trigger_id: Optional[pulumi.Input[builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PreventionJobTriggerTriggerArgs', 'PreventionJobTriggerTriggerArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PreventionJobTriggerArgs.__new__(PreventionJobTriggerArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["inspect_job"] = inspect_job
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            __props__.__dict__["status"] = status
            __props__.__dict__["trigger_id"] = trigger_id
            if triggers is None and not opts.urn:
                raise TypeError("Missing required property 'triggers'")
            __props__.__dict__["triggers"] = triggers
            __props__.__dict__["create_time"] = None
            __props__.__dict__["last_run_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(PreventionJobTrigger, __self__).__init__(
            'gcp:dataloss/preventionJobTrigger:PreventionJobTrigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            inspect_job: Optional[pulumi.Input[Union['PreventionJobTriggerInspectJobArgs', 'PreventionJobTriggerInspectJobArgsDict']]] = None,
            last_run_time: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            trigger_id: Optional[pulumi.Input[builtins.str]] = None,
            triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PreventionJobTriggerTriggerArgs', 'PreventionJobTriggerTriggerArgsDict']]]]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'PreventionJobTrigger':
        """
        Get an existing PreventionJobTrigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: The creation timestamp of an inspectTemplate. Set by the server.
        :param pulumi.Input[builtins.str] description: A description of the job trigger.
        :param pulumi.Input[builtins.str] display_name: User set display name of the job trigger.
        :param pulumi.Input[Union['PreventionJobTriggerInspectJobArgs', 'PreventionJobTriggerInspectJobArgsDict']] inspect_job: Controls what and how to inspect for findings.
        :param pulumi.Input[builtins.str] last_run_time: The timestamp of the last time this trigger executed.
        :param pulumi.Input[builtins.str] name: The resource name of the job trigger. Set by the server.
        :param pulumi.Input[builtins.str] parent: The parent of the trigger, either in the format `projects/{{project}}`
               or `projects/{{project}}/locations/{{location}}`
        :param pulumi.Input[builtins.str] status: Whether the trigger is currently active. Default value: "HEALTHY" Possible values: ["PAUSED", "HEALTHY", "CANCELLED"]
        :param pulumi.Input[builtins.str] trigger_id: The trigger id can contain uppercase and lowercase letters, numbers, and hyphens; that is, it must match the regular
               expression: [a-zA-Z\\d-_]+. The maximum length is 100 characters. Can be empty to allow the system to generate one.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PreventionJobTriggerTriggerArgs', 'PreventionJobTriggerTriggerArgsDict']]]] triggers: What event needs to occur for a new job to be started.
               Structure is documented below.
        :param pulumi.Input[builtins.str] update_time: The last update timestamp of an inspectTemplate. Set by the server.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PreventionJobTriggerState.__new__(_PreventionJobTriggerState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["inspect_job"] = inspect_job
        __props__.__dict__["last_run_time"] = last_run_time
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["status"] = status
        __props__.__dict__["trigger_id"] = trigger_id
        __props__.__dict__["triggers"] = triggers
        __props__.__dict__["update_time"] = update_time
        return PreventionJobTrigger(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The creation timestamp of an inspectTemplate. Set by the server.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the job trigger.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User set display name of the job trigger.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="inspectJob")
    def inspect_job(self) -> pulumi.Output[Optional['outputs.PreventionJobTriggerInspectJob']]:
        """
        Controls what and how to inspect for findings.
        """
        return pulumi.get(self, "inspect_job")

    @property
    @pulumi.getter(name="lastRunTime")
    def last_run_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of the last time this trigger executed.
        """
        return pulumi.get(self, "last_run_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the job trigger. Set by the server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[builtins.str]:
        """
        The parent of the trigger, either in the format `projects/{{project}}`
        or `projects/{{project}}/locations/{{location}}`
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Whether the trigger is currently active. Default value: "HEALTHY" Possible values: ["PAUSED", "HEALTHY", "CANCELLED"]
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> pulumi.Output[builtins.str]:
        """
        The trigger id can contain uppercase and lowercase letters, numbers, and hyphens; that is, it must match the regular
        expression: [a-zA-Z\\d-_]+. The maximum length is 100 characters. Can be empty to allow the system to generate one.
        """
        return pulumi.get(self, "trigger_id")

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Sequence['outputs.PreventionJobTriggerTrigger']]:
        """
        What event needs to occur for a new job to be started.
        Structure is documented below.
        """
        return pulumi.get(self, "triggers")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The last update timestamp of an inspectTemplate. Set by the server.
        """
        return pulumi.get(self, "update_time")

