# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatascanArgs', 'Datascan']

@pulumi.input_type
class DatascanArgs:
    def __init__(__self__, *,
                 data: pulumi.Input['DatascanDataArgs'],
                 data_scan_id: pulumi.Input[builtins.str],
                 execution_spec: pulumi.Input['DatascanExecutionSpecArgs'],
                 location: pulumi.Input[builtins.str],
                 data_discovery_spec: Optional[pulumi.Input['DatascanDataDiscoverySpecArgs']] = None,
                 data_profile_spec: Optional[pulumi.Input['DatascanDataProfileSpecArgs']] = None,
                 data_quality_spec: Optional[pulumi.Input['DatascanDataQualitySpecArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Datascan resource.
        :param pulumi.Input['DatascanDataArgs'] data: The data source for DataScan.
               Structure is documented below.
        :param pulumi.Input[builtins.str] data_scan_id: DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
        :param pulumi.Input['DatascanExecutionSpecArgs'] execution_spec: DataScan execution settings.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The location where the data scan should reside.
        :param pulumi.Input['DatascanDataDiscoverySpecArgs'] data_discovery_spec: DataDiscoveryScan related setting.
        :param pulumi.Input['DatascanDataProfileSpecArgs'] data_profile_spec: DataProfileScan related setting.
        :param pulumi.Input['DatascanDataQualitySpecArgs'] data_quality_spec: DataQualityScan related setting.
        :param pulumi.Input[builtins.str] description: Description of the scan.
        :param pulumi.Input[builtins.str] display_name: User friendly display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the scan. A list of key->value pairs. **Note**: This field is non-authoritative, and will only
               manage the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels
               present on the resource.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "data_scan_id", data_scan_id)
        pulumi.set(__self__, "execution_spec", execution_spec)
        pulumi.set(__self__, "location", location)
        if data_discovery_spec is not None:
            pulumi.set(__self__, "data_discovery_spec", data_discovery_spec)
        if data_profile_spec is not None:
            pulumi.set(__self__, "data_profile_spec", data_profile_spec)
        if data_quality_spec is not None:
            pulumi.set(__self__, "data_quality_spec", data_quality_spec)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Input['DatascanDataArgs']:
        """
        The data source for DataScan.
        Structure is documented below.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input['DatascanDataArgs']):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="dataScanId")
    def data_scan_id(self) -> pulumi.Input[builtins.str]:
        """
        DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
        """
        return pulumi.get(self, "data_scan_id")

    @data_scan_id.setter
    def data_scan_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_scan_id", value)

    @property
    @pulumi.getter(name="executionSpec")
    def execution_spec(self) -> pulumi.Input['DatascanExecutionSpecArgs']:
        """
        DataScan execution settings.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_spec")

    @execution_spec.setter
    def execution_spec(self, value: pulumi.Input['DatascanExecutionSpecArgs']):
        pulumi.set(self, "execution_spec", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location where the data scan should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="dataDiscoverySpec")
    def data_discovery_spec(self) -> Optional[pulumi.Input['DatascanDataDiscoverySpecArgs']]:
        """
        DataDiscoveryScan related setting.
        """
        return pulumi.get(self, "data_discovery_spec")

    @data_discovery_spec.setter
    def data_discovery_spec(self, value: Optional[pulumi.Input['DatascanDataDiscoverySpecArgs']]):
        pulumi.set(self, "data_discovery_spec", value)

    @property
    @pulumi.getter(name="dataProfileSpec")
    def data_profile_spec(self) -> Optional[pulumi.Input['DatascanDataProfileSpecArgs']]:
        """
        DataProfileScan related setting.
        """
        return pulumi.get(self, "data_profile_spec")

    @data_profile_spec.setter
    def data_profile_spec(self, value: Optional[pulumi.Input['DatascanDataProfileSpecArgs']]):
        pulumi.set(self, "data_profile_spec", value)

    @property
    @pulumi.getter(name="dataQualitySpec")
    def data_quality_spec(self) -> Optional[pulumi.Input['DatascanDataQualitySpecArgs']]:
        """
        DataQualityScan related setting.
        """
        return pulumi.get(self, "data_quality_spec")

    @data_quality_spec.setter
    def data_quality_spec(self, value: Optional[pulumi.Input['DatascanDataQualitySpecArgs']]):
        pulumi.set(self, "data_quality_spec", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the scan.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined labels for the scan. A list of key->value pairs. **Note**: This field is non-authoritative, and will only
        manage the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels
        present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _DatascanState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 data: Optional[pulumi.Input['DatascanDataArgs']] = None,
                 data_discovery_spec: Optional[pulumi.Input['DatascanDataDiscoverySpecArgs']] = None,
                 data_profile_spec: Optional[pulumi.Input['DatascanDataProfileSpecArgs']] = None,
                 data_quality_spec: Optional[pulumi.Input['DatascanDataQualitySpecArgs']] = None,
                 data_scan_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 execution_spec: Optional[pulumi.Input['DatascanExecutionSpecArgs']] = None,
                 execution_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['DatascanExecutionStatusArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Datascan resources.
        :param pulumi.Input[builtins.str] create_time: The time when the scan was created.
        :param pulumi.Input['DatascanDataArgs'] data: The data source for DataScan.
               Structure is documented below.
        :param pulumi.Input['DatascanDataDiscoverySpecArgs'] data_discovery_spec: DataDiscoveryScan related setting.
        :param pulumi.Input['DatascanDataProfileSpecArgs'] data_profile_spec: DataProfileScan related setting.
        :param pulumi.Input['DatascanDataQualitySpecArgs'] data_quality_spec: DataQualityScan related setting.
        :param pulumi.Input[builtins.str] data_scan_id: DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
        :param pulumi.Input[builtins.str] description: Description of the scan.
        :param pulumi.Input[builtins.str] display_name: User friendly display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['DatascanExecutionSpecArgs'] execution_spec: DataScan execution settings.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['DatascanExecutionStatusArgs']]] execution_statuses: Status of the data scan execution.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the scan. A list of key->value pairs. **Note**: This field is non-authoritative, and will only
               manage the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels
               present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the data scan should reside.
        :param pulumi.Input[builtins.str] name: The relative resource name of the scan, of the form: projects/{project}/locations/{locationId}/dataScans/{datascan_id}, where project refers to a project_id or project_number and locationId refers to a GCP region.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] state: Current state of the DataScan.
        :param pulumi.Input[builtins.str] type: The type of DataScan.
        :param pulumi.Input[builtins.str] uid: System generated globally unique ID for the scan. This ID will be different if the scan is deleted and re-created with the same name.
        :param pulumi.Input[builtins.str] update_time: The time when the scan was last updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if data_discovery_spec is not None:
            pulumi.set(__self__, "data_discovery_spec", data_discovery_spec)
        if data_profile_spec is not None:
            pulumi.set(__self__, "data_profile_spec", data_profile_spec)
        if data_quality_spec is not None:
            pulumi.set(__self__, "data_quality_spec", data_quality_spec)
        if data_scan_id is not None:
            pulumi.set(__self__, "data_scan_id", data_scan_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if execution_spec is not None:
            pulumi.set(__self__, "execution_spec", execution_spec)
        if execution_statuses is not None:
            pulumi.set(__self__, "execution_statuses", execution_statuses)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the scan was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input['DatascanDataArgs']]:
        """
        The data source for DataScan.
        Structure is documented below.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input['DatascanDataArgs']]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="dataDiscoverySpec")
    def data_discovery_spec(self) -> Optional[pulumi.Input['DatascanDataDiscoverySpecArgs']]:
        """
        DataDiscoveryScan related setting.
        """
        return pulumi.get(self, "data_discovery_spec")

    @data_discovery_spec.setter
    def data_discovery_spec(self, value: Optional[pulumi.Input['DatascanDataDiscoverySpecArgs']]):
        pulumi.set(self, "data_discovery_spec", value)

    @property
    @pulumi.getter(name="dataProfileSpec")
    def data_profile_spec(self) -> Optional[pulumi.Input['DatascanDataProfileSpecArgs']]:
        """
        DataProfileScan related setting.
        """
        return pulumi.get(self, "data_profile_spec")

    @data_profile_spec.setter
    def data_profile_spec(self, value: Optional[pulumi.Input['DatascanDataProfileSpecArgs']]):
        pulumi.set(self, "data_profile_spec", value)

    @property
    @pulumi.getter(name="dataQualitySpec")
    def data_quality_spec(self) -> Optional[pulumi.Input['DatascanDataQualitySpecArgs']]:
        """
        DataQualityScan related setting.
        """
        return pulumi.get(self, "data_quality_spec")

    @data_quality_spec.setter
    def data_quality_spec(self, value: Optional[pulumi.Input['DatascanDataQualitySpecArgs']]):
        pulumi.set(self, "data_quality_spec", value)

    @property
    @pulumi.getter(name="dataScanId")
    def data_scan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
        """
        return pulumi.get(self, "data_scan_id")

    @data_scan_id.setter
    def data_scan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_scan_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the scan.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="executionSpec")
    def execution_spec(self) -> Optional[pulumi.Input['DatascanExecutionSpecArgs']]:
        """
        DataScan execution settings.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_spec")

    @execution_spec.setter
    def execution_spec(self, value: Optional[pulumi.Input['DatascanExecutionSpecArgs']]):
        pulumi.set(self, "execution_spec", value)

    @property
    @pulumi.getter(name="executionStatuses")
    def execution_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatascanExecutionStatusArgs']]]]:
        """
        Status of the data scan execution.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_statuses")

    @execution_statuses.setter
    def execution_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatascanExecutionStatusArgs']]]]):
        pulumi.set(self, "execution_statuses", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined labels for the scan. A list of key->value pairs. **Note**: This field is non-authoritative, and will only
        manage the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels
        present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the data scan should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative resource name of the scan, of the form: projects/{project}/locations/{locationId}/dataScans/{datascan_id}, where project refers to a project_id or project_number and locationId refers to a GCP region.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Current state of the DataScan.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of DataScan.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        System generated globally unique ID for the scan. This ID will be different if the scan is deleted and re-created with the same name.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the scan was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:dataplex/datascan:Datascan")
class Datascan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[Union['DatascanDataArgs', 'DatascanDataArgsDict']]] = None,
                 data_discovery_spec: Optional[pulumi.Input[Union['DatascanDataDiscoverySpecArgs', 'DatascanDataDiscoverySpecArgsDict']]] = None,
                 data_profile_spec: Optional[pulumi.Input[Union['DatascanDataProfileSpecArgs', 'DatascanDataProfileSpecArgsDict']]] = None,
                 data_quality_spec: Optional[pulumi.Input[Union['DatascanDataQualitySpecArgs', 'DatascanDataQualitySpecArgsDict']]] = None,
                 data_scan_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 execution_spec: Optional[pulumi.Input[Union['DatascanExecutionSpecArgs', 'DatascanExecutionSpecArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Represents a user-visible job which provides the insights for the related data source.

        To get more information about Datascan, see:

        * [API documentation](https://cloud.google.com/dataplex/docs/reference/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dataplex/docs)

        ## Example Usage

        ### Dataplex Datascan Basic Profile

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_profile = gcp.dataplex.Datascan("basic_profile",
            location="us-central1",
            data_scan_id="dataprofile-basic",
            data={
                "resource": "//bigquery.googleapis.com/projects/bigquery-public-data/datasets/samples/tables/shakespeare",
            },
            execution_spec={
                "trigger": {
                    "on_demand": {},
                },
            },
            data_profile_spec={},
            project="my-project-name")
        ```
        ### Dataplex Datascan Full Profile

        ```python
        import pulumi
        import pulumi_gcp as gcp

        source = gcp.bigquery.Dataset("source",
            dataset_id="dataplex_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US",
            delete_contents_on_destroy=True)
        full_profile = gcp.dataplex.Datascan("full_profile",
            location="us-central1",
            display_name="Full Datascan Profile",
            data_scan_id="dataprofile-full",
            description="Example resource - Full Datascan Profile",
            labels={
                "author": "billing",
            },
            data={
                "resource": "//bigquery.googleapis.com/projects/bigquery-public-data/datasets/samples/tables/shakespeare",
            },
            execution_spec={
                "trigger": {
                    "schedule": {
                        "cron": "TZ=America/New_York 1 1 * * *",
                    },
                },
            },
            data_profile_spec={
                "sampling_percent": 80,
                "row_filter": "word_count > 10",
                "include_fields": {
                    "field_names": ["word_count"],
                },
                "exclude_fields": {
                    "field_names": ["property_type"],
                },
                "post_scan_actions": {
                    "bigquery_export": {
                        "results_table": "//bigquery.googleapis.com/projects/my-project-name/datasets/dataplex_dataset/tables/profile_export",
                    },
                },
            },
            project="my-project-name",
            opts = pulumi.ResourceOptions(depends_on=[source]))
        ```
        ### Dataplex Datascan Basic Quality

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_quality = gcp.dataplex.Datascan("basic_quality",
            location="us-central1",
            data_scan_id="dataquality-basic",
            data={
                "resource": "//bigquery.googleapis.com/projects/bigquery-public-data/datasets/samples/tables/shakespeare",
            },
            execution_spec={
                "trigger": {
                    "on_demand": {},
                },
            },
            data_quality_spec={
                "rules": [{
                    "dimension": "VALIDITY",
                    "name": "rule1",
                    "description": "rule 1 for validity dimension",
                    "table_condition_expectation": {
                        "sql_expression": "COUNT(*) > 0",
                    },
                }],
            },
            project="my-project-name")
        ```
        ### Dataplex Datascan Full Quality

        ```python
        import pulumi
        import pulumi_gcp as gcp

        full_quality = gcp.dataplex.Datascan("full_quality",
            location="us-central1",
            display_name="Full Datascan Quality",
            data_scan_id="dataquality-full",
            description="Example resource - Full Datascan Quality",
            labels={
                "author": "billing",
            },
            data={
                "resource": "//bigquery.googleapis.com/projects/bigquery-public-data/datasets/austin_bikeshare/tables/bikeshare_stations",
            },
            execution_spec={
                "trigger": {
                    "schedule": {
                        "cron": "TZ=America/New_York 1 1 * * *",
                    },
                },
                "field": "modified_date",
            },
            data_quality_spec={
                "sampling_percent": 5,
                "row_filter": "station_id > 1000",
                "catalog_publishing_enabled": True,
                "post_scan_actions": {
                    "notification_report": {
                        "recipients": {
                            "emails": ["jane.doe@example.com"],
                        },
                        "score_threshold_trigger": {
                            "score_threshold": 86,
                        },
                    },
                },
                "rules": [
                    {
                        "column": "address",
                        "dimension": "VALIDITY",
                        "threshold": 0.99,
                        "non_null_expectation": {},
                    },
                    {
                        "column": "council_district",
                        "dimension": "VALIDITY",
                        "ignore_null": True,
                        "threshold": 0.9,
                        "range_expectation": {
                            "min_value": "1",
                            "max_value": "10",
                            "strict_min_enabled": True,
                            "strict_max_enabled": False,
                        },
                    },
                    {
                        "column": "power_type",
                        "dimension": "VALIDITY",
                        "ignore_null": False,
                        "regex_expectation": {
                            "regex": ".*solar.*",
                        },
                    },
                    {
                        "column": "property_type",
                        "dimension": "VALIDITY",
                        "ignore_null": False,
                        "set_expectation": {
                            "values": [
                                "sidewalk",
                                "parkland",
                            ],
                        },
                    },
                    {
                        "column": "address",
                        "dimension": "UNIQUENESS",
                        "uniqueness_expectation": {},
                    },
                    {
                        "column": "number_of_docks",
                        "dimension": "VALIDITY",
                        "statistic_range_expectation": {
                            "statistic": "MEAN",
                            "min_value": "5",
                            "max_value": "15",
                            "strict_min_enabled": True,
                            "strict_max_enabled": True,
                        },
                    },
                    {
                        "column": "footprint_length",
                        "dimension": "VALIDITY",
                        "row_condition_expectation": {
                            "sql_expression": "footprint_length > 0 AND footprint_length <= 10",
                        },
                    },
                    {
                        "dimension": "VALIDITY",
                        "table_condition_expectation": {
                            "sql_expression": "COUNT(*) > 0",
                        },
                    },
                    {
                        "dimension": "VALIDITY",
                        "sql_assertion": {
                            "sql_statement": "select * from bigquery-public-data.austin_bikeshare.bikeshare_stations where station_id is null",
                        },
                    },
                ],
            },
            project="my-project-name")
        ```
        ### Dataplex Datascan Basic Discovery

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tf_test_bucket = gcp.storage.Bucket("tf_test_bucket",
            name="tf-test-bucket-name-_91042",
            location="us-west1",
            uniform_bucket_level_access=True)
        basic_discovery = gcp.dataplex.Datascan("basic_discovery",
            location="us-central1",
            data_scan_id="datadiscovery-basic",
            data={
                "resource": pulumi.Output.all(
                    project=tf_test_bucket.project,
                    name=tf_test_bucket.name
        ).apply(lambda resolved_outputs: f"//storage.googleapis.com/projects/{resolved_outputs['project']}/buckets/{resolved_outputs['name']}")
        ,
            },
            execution_spec={
                "trigger": {
                    "on_demand": {},
                },
            },
            data_discovery_spec={},
            project="my-project-name")
        ```
        ### Dataplex Datascan Full Discovery

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tf_test_bucket = gcp.storage.Bucket("tf_test_bucket",
            name="tf-test-bucket-name-_72490",
            location="us-west1",
            uniform_bucket_level_access=True)
        tf_test_connection = gcp.bigquery.Connection("tf_test_connection",
            connection_id="tf-test-connection-_89605",
            location="us-central1",
            friendly_name="tf-test-connection-_56730",
            description="a bigquery connection for tf test",
            cloud_resource={})
        full_discovery = gcp.dataplex.Datascan("full_discovery",
            location="us-central1",
            display_name="Full Datascan Discovery",
            data_scan_id="datadiscovery-full",
            description="Example resource - Full Datascan Discovery",
            labels={
                "author": "billing",
            },
            data={
                "resource": pulumi.Output.all(
                    project=tf_test_bucket.project,
                    name=tf_test_bucket.name
        ).apply(lambda resolved_outputs: f"//storage.googleapis.com/projects/{resolved_outputs['project']}/buckets/{resolved_outputs['name']}")
        ,
            },
            execution_spec={
                "trigger": {
                    "schedule": {
                        "cron": "TZ=America/New_York 1 1 * * *",
                    },
                },
            },
            data_discovery_spec={
                "bigquery_publishing_config": {
                    "table_type": "BIGLAKE",
                    "connection": pulumi.Output.all(
                        project=tf_test_connection.project,
                        location=tf_test_connection.location,
                        connection_id=tf_test_connection.connection_id
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/connections/{resolved_outputs['connection_id']}")
        ,
                    "location": tf_test_bucket.location,
                    "project": tf_test_bucket.project.apply(lambda project: f"projects/{project}"),
                },
                "storage_config": {
                    "include_patterns": [
                        "ai*",
                        "ml*",
                    ],
                    "exclude_patterns": [
                        "doc*",
                        "gen*",
                    ],
                    "csv_options": {
                        "header_rows": 5,
                        "delimiter": ",",
                        "encoding": "UTF-8",
                        "type_inference_disabled": False,
                        "quote": "'",
                    },
                    "json_options": {
                        "encoding": "UTF-8",
                        "type_inference_disabled": False,
                    },
                },
            },
            project="my-project-name")
        ```

        ## Import

        Datascan can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dataScans/{{data_scan_id}}`

        * `{{project}}/{{location}}/{{data_scan_id}}`

        * `{{location}}/{{data_scan_id}}`

        * `{{data_scan_id}}`

        When using the `pulumi import` command, Datascan can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataplex/datascan:Datascan default projects/{{project}}/locations/{{location}}/dataScans/{{data_scan_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/datascan:Datascan default {{project}}/{{location}}/{{data_scan_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/datascan:Datascan default {{location}}/{{data_scan_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/datascan:Datascan default {{data_scan_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DatascanDataArgs', 'DatascanDataArgsDict']] data: The data source for DataScan.
               Structure is documented below.
        :param pulumi.Input[Union['DatascanDataDiscoverySpecArgs', 'DatascanDataDiscoverySpecArgsDict']] data_discovery_spec: DataDiscoveryScan related setting.
        :param pulumi.Input[Union['DatascanDataProfileSpecArgs', 'DatascanDataProfileSpecArgsDict']] data_profile_spec: DataProfileScan related setting.
        :param pulumi.Input[Union['DatascanDataQualitySpecArgs', 'DatascanDataQualitySpecArgsDict']] data_quality_spec: DataQualityScan related setting.
        :param pulumi.Input[builtins.str] data_scan_id: DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
        :param pulumi.Input[builtins.str] description: Description of the scan.
        :param pulumi.Input[builtins.str] display_name: User friendly display name.
        :param pulumi.Input[Union['DatascanExecutionSpecArgs', 'DatascanExecutionSpecArgsDict']] execution_spec: DataScan execution settings.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the scan. A list of key->value pairs. **Note**: This field is non-authoritative, and will only
               manage the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels
               present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the data scan should reside.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatascanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a user-visible job which provides the insights for the related data source.

        To get more information about Datascan, see:

        * [API documentation](https://cloud.google.com/dataplex/docs/reference/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dataplex/docs)

        ## Example Usage

        ### Dataplex Datascan Basic Profile

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_profile = gcp.dataplex.Datascan("basic_profile",
            location="us-central1",
            data_scan_id="dataprofile-basic",
            data={
                "resource": "//bigquery.googleapis.com/projects/bigquery-public-data/datasets/samples/tables/shakespeare",
            },
            execution_spec={
                "trigger": {
                    "on_demand": {},
                },
            },
            data_profile_spec={},
            project="my-project-name")
        ```
        ### Dataplex Datascan Full Profile

        ```python
        import pulumi
        import pulumi_gcp as gcp

        source = gcp.bigquery.Dataset("source",
            dataset_id="dataplex_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US",
            delete_contents_on_destroy=True)
        full_profile = gcp.dataplex.Datascan("full_profile",
            location="us-central1",
            display_name="Full Datascan Profile",
            data_scan_id="dataprofile-full",
            description="Example resource - Full Datascan Profile",
            labels={
                "author": "billing",
            },
            data={
                "resource": "//bigquery.googleapis.com/projects/bigquery-public-data/datasets/samples/tables/shakespeare",
            },
            execution_spec={
                "trigger": {
                    "schedule": {
                        "cron": "TZ=America/New_York 1 1 * * *",
                    },
                },
            },
            data_profile_spec={
                "sampling_percent": 80,
                "row_filter": "word_count > 10",
                "include_fields": {
                    "field_names": ["word_count"],
                },
                "exclude_fields": {
                    "field_names": ["property_type"],
                },
                "post_scan_actions": {
                    "bigquery_export": {
                        "results_table": "//bigquery.googleapis.com/projects/my-project-name/datasets/dataplex_dataset/tables/profile_export",
                    },
                },
            },
            project="my-project-name",
            opts = pulumi.ResourceOptions(depends_on=[source]))
        ```
        ### Dataplex Datascan Basic Quality

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_quality = gcp.dataplex.Datascan("basic_quality",
            location="us-central1",
            data_scan_id="dataquality-basic",
            data={
                "resource": "//bigquery.googleapis.com/projects/bigquery-public-data/datasets/samples/tables/shakespeare",
            },
            execution_spec={
                "trigger": {
                    "on_demand": {},
                },
            },
            data_quality_spec={
                "rules": [{
                    "dimension": "VALIDITY",
                    "name": "rule1",
                    "description": "rule 1 for validity dimension",
                    "table_condition_expectation": {
                        "sql_expression": "COUNT(*) > 0",
                    },
                }],
            },
            project="my-project-name")
        ```
        ### Dataplex Datascan Full Quality

        ```python
        import pulumi
        import pulumi_gcp as gcp

        full_quality = gcp.dataplex.Datascan("full_quality",
            location="us-central1",
            display_name="Full Datascan Quality",
            data_scan_id="dataquality-full",
            description="Example resource - Full Datascan Quality",
            labels={
                "author": "billing",
            },
            data={
                "resource": "//bigquery.googleapis.com/projects/bigquery-public-data/datasets/austin_bikeshare/tables/bikeshare_stations",
            },
            execution_spec={
                "trigger": {
                    "schedule": {
                        "cron": "TZ=America/New_York 1 1 * * *",
                    },
                },
                "field": "modified_date",
            },
            data_quality_spec={
                "sampling_percent": 5,
                "row_filter": "station_id > 1000",
                "catalog_publishing_enabled": True,
                "post_scan_actions": {
                    "notification_report": {
                        "recipients": {
                            "emails": ["jane.doe@example.com"],
                        },
                        "score_threshold_trigger": {
                            "score_threshold": 86,
                        },
                    },
                },
                "rules": [
                    {
                        "column": "address",
                        "dimension": "VALIDITY",
                        "threshold": 0.99,
                        "non_null_expectation": {},
                    },
                    {
                        "column": "council_district",
                        "dimension": "VALIDITY",
                        "ignore_null": True,
                        "threshold": 0.9,
                        "range_expectation": {
                            "min_value": "1",
                            "max_value": "10",
                            "strict_min_enabled": True,
                            "strict_max_enabled": False,
                        },
                    },
                    {
                        "column": "power_type",
                        "dimension": "VALIDITY",
                        "ignore_null": False,
                        "regex_expectation": {
                            "regex": ".*solar.*",
                        },
                    },
                    {
                        "column": "property_type",
                        "dimension": "VALIDITY",
                        "ignore_null": False,
                        "set_expectation": {
                            "values": [
                                "sidewalk",
                                "parkland",
                            ],
                        },
                    },
                    {
                        "column": "address",
                        "dimension": "UNIQUENESS",
                        "uniqueness_expectation": {},
                    },
                    {
                        "column": "number_of_docks",
                        "dimension": "VALIDITY",
                        "statistic_range_expectation": {
                            "statistic": "MEAN",
                            "min_value": "5",
                            "max_value": "15",
                            "strict_min_enabled": True,
                            "strict_max_enabled": True,
                        },
                    },
                    {
                        "column": "footprint_length",
                        "dimension": "VALIDITY",
                        "row_condition_expectation": {
                            "sql_expression": "footprint_length > 0 AND footprint_length <= 10",
                        },
                    },
                    {
                        "dimension": "VALIDITY",
                        "table_condition_expectation": {
                            "sql_expression": "COUNT(*) > 0",
                        },
                    },
                    {
                        "dimension": "VALIDITY",
                        "sql_assertion": {
                            "sql_statement": "select * from bigquery-public-data.austin_bikeshare.bikeshare_stations where station_id is null",
                        },
                    },
                ],
            },
            project="my-project-name")
        ```
        ### Dataplex Datascan Basic Discovery

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tf_test_bucket = gcp.storage.Bucket("tf_test_bucket",
            name="tf-test-bucket-name-_91042",
            location="us-west1",
            uniform_bucket_level_access=True)
        basic_discovery = gcp.dataplex.Datascan("basic_discovery",
            location="us-central1",
            data_scan_id="datadiscovery-basic",
            data={
                "resource": pulumi.Output.all(
                    project=tf_test_bucket.project,
                    name=tf_test_bucket.name
        ).apply(lambda resolved_outputs: f"//storage.googleapis.com/projects/{resolved_outputs['project']}/buckets/{resolved_outputs['name']}")
        ,
            },
            execution_spec={
                "trigger": {
                    "on_demand": {},
                },
            },
            data_discovery_spec={},
            project="my-project-name")
        ```
        ### Dataplex Datascan Full Discovery

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tf_test_bucket = gcp.storage.Bucket("tf_test_bucket",
            name="tf-test-bucket-name-_72490",
            location="us-west1",
            uniform_bucket_level_access=True)
        tf_test_connection = gcp.bigquery.Connection("tf_test_connection",
            connection_id="tf-test-connection-_89605",
            location="us-central1",
            friendly_name="tf-test-connection-_56730",
            description="a bigquery connection for tf test",
            cloud_resource={})
        full_discovery = gcp.dataplex.Datascan("full_discovery",
            location="us-central1",
            display_name="Full Datascan Discovery",
            data_scan_id="datadiscovery-full",
            description="Example resource - Full Datascan Discovery",
            labels={
                "author": "billing",
            },
            data={
                "resource": pulumi.Output.all(
                    project=tf_test_bucket.project,
                    name=tf_test_bucket.name
        ).apply(lambda resolved_outputs: f"//storage.googleapis.com/projects/{resolved_outputs['project']}/buckets/{resolved_outputs['name']}")
        ,
            },
            execution_spec={
                "trigger": {
                    "schedule": {
                        "cron": "TZ=America/New_York 1 1 * * *",
                    },
                },
            },
            data_discovery_spec={
                "bigquery_publishing_config": {
                    "table_type": "BIGLAKE",
                    "connection": pulumi.Output.all(
                        project=tf_test_connection.project,
                        location=tf_test_connection.location,
                        connection_id=tf_test_connection.connection_id
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/connections/{resolved_outputs['connection_id']}")
        ,
                    "location": tf_test_bucket.location,
                    "project": tf_test_bucket.project.apply(lambda project: f"projects/{project}"),
                },
                "storage_config": {
                    "include_patterns": [
                        "ai*",
                        "ml*",
                    ],
                    "exclude_patterns": [
                        "doc*",
                        "gen*",
                    ],
                    "csv_options": {
                        "header_rows": 5,
                        "delimiter": ",",
                        "encoding": "UTF-8",
                        "type_inference_disabled": False,
                        "quote": "'",
                    },
                    "json_options": {
                        "encoding": "UTF-8",
                        "type_inference_disabled": False,
                    },
                },
            },
            project="my-project-name")
        ```

        ## Import

        Datascan can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dataScans/{{data_scan_id}}`

        * `{{project}}/{{location}}/{{data_scan_id}}`

        * `{{location}}/{{data_scan_id}}`

        * `{{data_scan_id}}`

        When using the `pulumi import` command, Datascan can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataplex/datascan:Datascan default projects/{{project}}/locations/{{location}}/dataScans/{{data_scan_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/datascan:Datascan default {{project}}/{{location}}/{{data_scan_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/datascan:Datascan default {{location}}/{{data_scan_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/datascan:Datascan default {{data_scan_id}}
        ```

        :param str resource_name: The name of the resource.
        :param DatascanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatascanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[Union['DatascanDataArgs', 'DatascanDataArgsDict']]] = None,
                 data_discovery_spec: Optional[pulumi.Input[Union['DatascanDataDiscoverySpecArgs', 'DatascanDataDiscoverySpecArgsDict']]] = None,
                 data_profile_spec: Optional[pulumi.Input[Union['DatascanDataProfileSpecArgs', 'DatascanDataProfileSpecArgsDict']]] = None,
                 data_quality_spec: Optional[pulumi.Input[Union['DatascanDataQualitySpecArgs', 'DatascanDataQualitySpecArgsDict']]] = None,
                 data_scan_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 execution_spec: Optional[pulumi.Input[Union['DatascanExecutionSpecArgs', 'DatascanExecutionSpecArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatascanArgs.__new__(DatascanArgs)

            if data is None and not opts.urn:
                raise TypeError("Missing required property 'data'")
            __props__.__dict__["data"] = data
            __props__.__dict__["data_discovery_spec"] = data_discovery_spec
            __props__.__dict__["data_profile_spec"] = data_profile_spec
            __props__.__dict__["data_quality_spec"] = data_quality_spec
            if data_scan_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_scan_id'")
            __props__.__dict__["data_scan_id"] = data_scan_id
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if execution_spec is None and not opts.urn:
                raise TypeError("Missing required property 'execution_spec'")
            __props__.__dict__["execution_spec"] = execution_spec
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["execution_statuses"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Datascan, __self__).__init__(
            'gcp:dataplex/datascan:Datascan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            data: Optional[pulumi.Input[Union['DatascanDataArgs', 'DatascanDataArgsDict']]] = None,
            data_discovery_spec: Optional[pulumi.Input[Union['DatascanDataDiscoverySpecArgs', 'DatascanDataDiscoverySpecArgsDict']]] = None,
            data_profile_spec: Optional[pulumi.Input[Union['DatascanDataProfileSpecArgs', 'DatascanDataProfileSpecArgsDict']]] = None,
            data_quality_spec: Optional[pulumi.Input[Union['DatascanDataQualitySpecArgs', 'DatascanDataQualitySpecArgsDict']]] = None,
            data_scan_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            execution_spec: Optional[pulumi.Input[Union['DatascanExecutionSpecArgs', 'DatascanExecutionSpecArgsDict']]] = None,
            execution_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatascanExecutionStatusArgs', 'DatascanExecutionStatusArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Datascan':
        """
        Get an existing Datascan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: The time when the scan was created.
        :param pulumi.Input[Union['DatascanDataArgs', 'DatascanDataArgsDict']] data: The data source for DataScan.
               Structure is documented below.
        :param pulumi.Input[Union['DatascanDataDiscoverySpecArgs', 'DatascanDataDiscoverySpecArgsDict']] data_discovery_spec: DataDiscoveryScan related setting.
        :param pulumi.Input[Union['DatascanDataProfileSpecArgs', 'DatascanDataProfileSpecArgsDict']] data_profile_spec: DataProfileScan related setting.
        :param pulumi.Input[Union['DatascanDataQualitySpecArgs', 'DatascanDataQualitySpecArgsDict']] data_quality_spec: DataQualityScan related setting.
        :param pulumi.Input[builtins.str] data_scan_id: DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
        :param pulumi.Input[builtins.str] description: Description of the scan.
        :param pulumi.Input[builtins.str] display_name: User friendly display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['DatascanExecutionSpecArgs', 'DatascanExecutionSpecArgsDict']] execution_spec: DataScan execution settings.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatascanExecutionStatusArgs', 'DatascanExecutionStatusArgsDict']]]] execution_statuses: Status of the data scan execution.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the scan. A list of key->value pairs. **Note**: This field is non-authoritative, and will only
               manage the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels
               present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the data scan should reside.
        :param pulumi.Input[builtins.str] name: The relative resource name of the scan, of the form: projects/{project}/locations/{locationId}/dataScans/{datascan_id}, where project refers to a project_id or project_number and locationId refers to a GCP region.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] state: Current state of the DataScan.
        :param pulumi.Input[builtins.str] type: The type of DataScan.
        :param pulumi.Input[builtins.str] uid: System generated globally unique ID for the scan. This ID will be different if the scan is deleted and re-created with the same name.
        :param pulumi.Input[builtins.str] update_time: The time when the scan was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatascanState.__new__(_DatascanState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data"] = data
        __props__.__dict__["data_discovery_spec"] = data_discovery_spec
        __props__.__dict__["data_profile_spec"] = data_profile_spec
        __props__.__dict__["data_quality_spec"] = data_quality_spec
        __props__.__dict__["data_scan_id"] = data_scan_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["execution_spec"] = execution_spec
        __props__.__dict__["execution_statuses"] = execution_statuses
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["state"] = state
        __props__.__dict__["type"] = type
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Datascan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the scan was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output['outputs.DatascanData']:
        """
        The data source for DataScan.
        Structure is documented below.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="dataDiscoverySpec")
    def data_discovery_spec(self) -> pulumi.Output[Optional['outputs.DatascanDataDiscoverySpec']]:
        """
        DataDiscoveryScan related setting.
        """
        return pulumi.get(self, "data_discovery_spec")

    @property
    @pulumi.getter(name="dataProfileSpec")
    def data_profile_spec(self) -> pulumi.Output[Optional['outputs.DatascanDataProfileSpec']]:
        """
        DataProfileScan related setting.
        """
        return pulumi.get(self, "data_profile_spec")

    @property
    @pulumi.getter(name="dataQualitySpec")
    def data_quality_spec(self) -> pulumi.Output[Optional['outputs.DatascanDataQualitySpec']]:
        """
        DataQualityScan related setting.
        """
        return pulumi.get(self, "data_quality_spec")

    @property
    @pulumi.getter(name="dataScanId")
    def data_scan_id(self) -> pulumi.Output[builtins.str]:
        """
        DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
        """
        return pulumi.get(self, "data_scan_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the scan.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="executionSpec")
    def execution_spec(self) -> pulumi.Output['outputs.DatascanExecutionSpec']:
        """
        DataScan execution settings.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_spec")

    @property
    @pulumi.getter(name="executionStatuses")
    def execution_statuses(self) -> pulumi.Output[Sequence['outputs.DatascanExecutionStatus']]:
        """
        Status of the data scan execution.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_statuses")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        User-defined labels for the scan. A list of key->value pairs. **Note**: This field is non-authoritative, and will only
        manage the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels
        present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location where the data scan should reside.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The relative resource name of the scan, of the form: projects/{project}/locations/{locationId}/dataScans/{datascan_id}, where project refers to a project_id or project_number and locationId refers to a GCP region.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Current state of the DataScan.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of DataScan.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        System generated globally unique ID for the scan. This ID will be different if the scan is deleted and re-created with the same name.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the scan was last updated.
        """
        return pulumi.get(self, "update_time")

